# Samoan

## Introduction

Formerly known as the *Navigator Islands*, the Samoan archipelago has been the launch site for countless ocean voyages since its settlement 3,000 years ago by the ancestors of today’s Polynesians. Like other Pacific Islander societies, the Samoans possessed an incredible body of astronomical knowledge, cultivated through generations of scientific observational study (tofāmamao). Over time, indigenous wayfinding science has been almost completely replaced by digital navigation technologies, but the names and stories attached to some celestial features have persisted through oral traditions and colonial era publications. Beside their value as nautical aids, the moon, stars, and planets also marked the lunar months, annual socioreligious festivals, and the timing of agricultural cycles.

## Description

### General Terminology

- _fētū_ - star
- _lā_ - sun
- _māsina_ - moon
- _lagi_ - sky
- _fuifuifētū_ - constellation ("star clusters")
- _ʻemoʻemo, ʻemaʻema_ - twinkling
- _liʻo_ - observed halo or reflective ring around star/moon
- _pupula_ - light emitted by sun/star, reflected by moon
- _vānimonimo/vāteatea/vāuliuli_ - outer space ("immeasurable space"/"expanse"/"dark void")
- _fētūafi/fētūlele/fētūatiafi_ - meteor/shooting star ("fire star"/"flying star"/"fire-carrying star")
- _pusaloa_ - comet ("smoke plume")
- _nuanua_ - rainbow
- _sopolagi_ - starpath/orbit
- _sila_ - endpoint of starpath/orbit (point on the horizon where star/sun/moon/planet is seen to rise/set from)
- _maluopeaua_ - the moment at which a star/moon/planet becomes visible at the horizon ("obscured in the sea mist")
- _goto/ifo/paʻū_ - to set (descent of star/moon/sun/planet below the horizon)
- _oso/aʻe/fānaʻe/aufasa_ - to rise (ascent of star/moon/sun /planet above the horizon)
- _fetāileliʻi_ - navigational path formed by a series of constellations/stars rising in sequence
- _gasetoto_ - solar eclipse
- _gaseʻeleʻele_ - lunar eclipse
- _pulou_ - zenith position
- _pale/faliu_ - to descend from zenith position toward horizon
- _itūlagi_ - spatial division of the sky/horizon
- _tafatafailagi_ - horizon
- _tilotilo_ - to catch a fleeting glance of star/moon during cloudy conditions
- _gālouluvao_ - obstructed view of star/moon
- _lagivalea_ - view of sky obstructed by clouds
- _fanoloa_ - period of time when star/moon/planet is not visible
- _lagi e mamā/lagilelei/lagimā_ - clear view of sky
- _mataʻaga_ - the act of watching the sky for stars/signs
- _vaʻaiiliu_ - to lay down in the hull to observe the sky above
- _fotu_ - appearance of star/moon/sun/planet
- _galo_ - disappearance of star/moon/sun/planet

### Planet Terminology

#### Tupualēgase

_Undying Mystery_ - Jupiter; associated with the ritual observance of the Amo o Ātua iā Tupualēgase (the Ātua chiefdomʻs annual celebration of the deity Tupualēgase, who is embodied by the planet Jupiter).

#### Tapuʻitea

_Forbidden Radiance__ - Venus; associated with the cannibal demigoddess Tapuʻitea who self-exiled herself to outer space to spare her son Toʻivā from her insatiable appetite; Toʻivā (abbreviation of Toʻivaitotonuoleʻatoatufuga) is also seen in the night sky as an adze-shaped constellation (Sickle of Leo); Venus is known to pass through Leo once (sometimes twice) a year, acknowledging the relationship between mother and son.

#### Fētūao

_Morning Star_ - Venus when seen before sunrise; associated with the legend of Tapuʻitea.

#### Matamemea

_Reddish Face/Surface_ - Mars.

#### Tāʻelo

_Brownish_ - Mercury.

#### Fētūʻāsoa

_Garland Star_ - Saturn.

### Star Terminology

#### Matāliʻi

_Face of Liʻi_ - Pleiades (grouping of seven stars representing eyes, ears, nostrils, and mouth of demigod Liʻi); associated with the legend of a Tanifā (Cetus) pursuing a canoe paddled by Liʻi; acronychal rising of Matāliʻi signaled the beginning of the new year (Vāipālolo season) and ushered in the festivities of the first fruits (Talomua) during the lunar months of Taumafamua and Toetaumafa. Note: for display clarity and ease of use Matāliʻi is assigned to the star Alcyone.

#### Luatagata

_Two Men_ - Alpha and Beta Centauri collectively; associated with the legend of Sumu (Crux, Southern Cross).

#### Filo/Mea

Alpha and Beta Centauri individually (no distinction between the two); associated with the legend of Sumu (Crux, Southern Cross).

#### Suga/Pae

M4 and M80 within Scorpius (no distinction between the two); associated with the legend of Toloa (head of Scorpius).

#### Fētūsolonuʻu

_Gliding Star_ - Sirius; considered zenith star for traveling between Sāmoa and Fiji.

#### Telegese

_Slow-Moving_ - Sirius; considered zenith star for traveling between Sāmoa and Fiji.

#### Taʻulua

_Two Salutations_ - refers to Sirius during the part of the year when it is visible both at sunrise and sunset (thus "greeted twice" on the same day).

#### Taʻuluatuāfanua

_Taʻulua Eastward_ - Sirius seen at sunrise.

#### Taʻuluaalofi

_Taʻulua Westward_ - Sirius seen at sunset.

#### Aolele

_Flying Cloud - Small Magellanic Cloud.

#### Aotea

_Pale Cloud_ - Large Magellanic Cloud.

#### ʻAniva

_Expanse_ - Milky Way.



## Constellations

##### Triggerfish

("Sumu") Crux/Southern Cross; associated with the legend of Filo and Mea (Alpha and Beta Centauri) fishing for the Sumu.

##### Fishhook lure

("Faipā") the entire hook shaped constellation of Scorpius; associated with the legend of ʻAloʻalolelā and the magic fishhook (pā).

##### Wild duck

("Toloa") asterism within Faipā, representing a flying duck (head of Scorpius); associated with the legend of Suga and Pae (M4 and M80) hunting the Toloa; the duckʻs head (Antares) is recorded as having been used to sail from Pukapuka to ʻUpolu when the star was "low in the sky to the westward".

##### Pigeon Perch

("Tūlālupe") asterism within Faipā (distal tail of Scorpius); associated with the chiefly sport of pigeon snaring.

##### Sea monster

("Tanifā") Cetus (tail of Cetus is the head of Tanifā), pursuing Liʻi (Pleiades).

##### Tongs

("Iʻofi") Taurus; associated with the legend of Tiʻitiʻiatalaga/Maui.

##### Carrying pole

("Amoga") constellation stretching from Pi-3 Orionis to Gamma Monocerotis; associated with the legend of Tiʻitiʻiatalaga; zenith star for traveling between Sāmoa and Tonga.

##### Triad of moons

("Tolugāmāuli") asterism within Amoga (three stars of Orionʻs Belt); associated with legend of Tiʻitiʻiatalaga; noted as the "star course" to sail from Manuʻa to Pukapuka.

##### Heirloom Warclub

("ʻAnava") constellation found largely within Ursa Major.

##### Kingfisher

("Tiʻotala") Delphinus; associated with the legend of the tiʻotala (kingfisher) ambushing the grasshopper (sē).

##### Grasshopper

("Sē") constellation found within Pegasus; associated with the legend of the tiʻotala (kingfisher) ambushing the grasshopper (sē).

##### Candlenut torch

("Tuigālama") Orionʻs arm/club; associated with the legend of Tiʻitiʻiatalaga.

##### Great Adze

("Toʻivā") Sickle of Leo; associated with the legend of Tapuʻitea (Venus) and her son Toʻivāitotonuoleʻatoatufuga ("Great Adze Within the Builderʻs Tool Basket").

## References

 - [#1]: Brown, George (1910). Melanesians and Polynesians: Their Life Histories Described and Compared. MacMillan and Co.
 - [#2]: Collocott, E.E.V. (1922). Tongan Astronomy and Calendar. Occasional Papers of the Bernice Pauahi Bishop Museum, 8(4).
 - [#3]: Efi, Tui Ātua Tupua Tamasese (2009). Tupualegase: The Eternal Riddle. in Su’esu’e Manogi: In Search of Fragrance. National University of Samoa.
 - [#4]: Efi, Tui Ātua Tupua Tamasese, personal communications
 - [#5]: Johnson, Rubelite and Mahealona, John (1975). Nā Inoa Hōkū. Topgallant Publishing. Kirch, Patrick and Green, Roger (2001). Hawaiki, Ancestral Polynesia. Cambridge University Press.
 - [#6]: Kramer, Augustin (1994). The Samoa Islands, Volume 1. University of Hawaiʻi Press.
 - [#7]: Kramer, Augustin (1995). The Samoa Islands, Volume 2. Polynesian Press.
 - [#8]: Lefale, Penehuro (2010). Ua Afa le Aso. Climate Change, 100:317-335.
 - [#9]: Leuluaʻialiʻi, Lepanona, personal communications
 - [#10]: Lewis, David (1994). We the Navigators. University of Hawaiʻi Press.
 - [#11]: Makemson, Maud (1941). The Morning Star Rises. Yale University Press.
 - [#12]: Meleiseā, Leasiolagi Dr. Mālama, personal communications
 - [#13]: Noyes, Martha (2011). Polynesian Star Catalog, Revised. Self-published.
 - [#14]: Pratt, George (1893). A Grammar and Dictionary of the Samoan Language, 3rd Edition. London Missionary Society.
 - [#15]: Refiti, Lealiʻifano Dr. Albert, personal communications
 - [#16]: Seiulialiʻi, Seiuliali’i Pasikale, personal communications
 - [#17]: Simanu, Aumua (2002). O Si Manu a Aliʻi. University of Hawaiʻi Press.
 - [#18]: Smith, S. Percy (1892). Futuna, or Horne Island and Its People. In The Journal of the Polynesian Society, 1(1):33-52.
 - [#19]: Stair, John B. (1898). The Names and Movements of the Heavenly Bodies, as Looked at from a Samoan Point of View. The Journal of the Polynesian Society, 7(1):48-49.
 - [#20]: Stair, John B. (1897). Old Samoa or Flotsam and Jetsam from the Pacific Ocean. Religious Tract Society.
 - [#21]: Turner, George (1884). Samoa a Hundred Years Ago and Long Before. MacMillan and Co.
 - [#22]: Tuvale, Teʻo (1918). An Account of Samoan History up to 1918. M.L. MSS. 39 Item C. Manuscript filmed by Public Library of New South Wales, July 1968.

## Authors

This sky culture was contributed by Jake Fitisemanu (jjfitisemanu (a^t^) gmail.com) with consultation of Samoan cultural custodians and published historical sources. Programming support from Dan Smale.

## License

CC BY-SA 4.0
