/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.backend.jvm.JvmIrDeserializer;
import org.jetbrains.kotlin.backend.jvm.JvmIrTypeSystemContext;
import org.jetbrains.kotlin.backend.jvm.lower.SingletonObjectJvmStaticTransformer;
import org.jetbrains.kotlin.backend.jvm.serialization.DeserializeLazyDeclarationsKt;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrProvider;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializerImpl;", "Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializer;", "<init>", "()V", "deserializeTopLevelClass", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "irProviders", "", "Lorg/jetbrains/kotlin/ir/IrProvider;", "extensions", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions;", "backend.jvm.entrypoint"})
public final class JvmIrDeserializerImpl
implements JvmIrDeserializer {
    @Override
    public boolean deserializeTopLevelClass(@NotNull IrClass irClass, @NotNull IrBuiltIns irBuiltIns, @NotNull SymbolTable symbolTable, @NotNull List<? extends IrProvider> irProviders, @NotNull JvmGeneratorExtensions extensions) {
        Object object;
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(irProviders, "irProviders");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        SourceElement source = irClass.getSource();
        Object object2 = source instanceof KotlinJvmBinarySourceElement ? ((KotlinJvmBinarySourceElement)source).getBinaryClass().getClassHeader().getSerializedIr() : (source instanceof JvmPackagePartSource ? (Object)((object = ((JvmPackagePartSource)source).getKnownJvmBinaryClass()) != null && (object = object.getClassHeader()) != null ? ((KotlinClassHeader)object).getSerializedIr() : null) : null);
        if (object2 == null) {
            return false;
        }
        byte[] serializedIr2 = object2;
        DeserializeLazyDeclarationsKt.deserializeFromByteArray(serializedIr2, irBuiltIns, symbolTable, irProviders, irClass, new JvmIrTypeSystemContext(irBuiltIns));
        irClass.transform(new SingletonObjectJvmStaticTransformer(irBuiltIns, extensions.getCachedFields()), null);
        return true;
    }
}

