/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataKt;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataCharArray;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "value", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "", "fitsLatin1", "", "<init>", "(Ljava/util/List;Z)V", "", "([CZ)V", "getValue", "()Ljava/util/List;", "getFitsLatin1", "()Z", "toBytes", "", "dump", "", "indent", "startAddress", "", "bytesPerChar", "sizeInBytes", "getSizeInBytes", "()I", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nConstantData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantData.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataCharArray\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n11785#2:151\n12140#2,3:152\n1924#3,3:155\n1586#3:158\n1661#3,3:159\n*S KotlinDebug\n*F\n+ 1 ConstantData.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataCharArray\n*L\n86#1:151\n86#1:152,3\n90#1:155,3\n96#1:158\n96#1:159,3\n*E\n"})
public final class ConstantDataCharArray
extends ConstantDataElement {
    @NotNull
    private final List<WasmSymbol<Character>> value;
    private final boolean fitsLatin1;
    private final int bytesPerChar;
    private final int sizeInBytes;

    public ConstantDataCharArray(@NotNull List<WasmSymbol<Character>> value2, boolean fitsLatin1) {
        Intrinsics.checkNotNullParameter(value2, "value");
        super(null);
        this.value = value2;
        this.fitsLatin1 = fitsLatin1;
        this.bytesPerChar = this.fitsLatin1 ? 1 : 2;
        this.sizeInBytes = this.value.size() * this.bytesPerChar;
    }

    @NotNull
    public final List<WasmSymbol<Character>> getValue() {
        return this.value;
    }

    public final boolean getFitsLatin1() {
        return this.fitsLatin1;
    }

    /*
     * WARNING - void declaration
     */
    public ConstantDataCharArray(@NotNull char[] value2, boolean fitsLatin1) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(value2, "value");
        char[] cArray = value2;
        ConstantDataCharArray constantDataCharArray = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void it;
            void item$iv$iv;
            void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i2];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new WasmSymbol<Character>(Character.valueOf((char)it)));
        }
        constantDataCharArray((List)destination$iv$iv, fitsLatin1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public byte[] toBytes() {
        byte[] byArray;
        byte[] $this$toBytes_u24lambda_u240 = byArray = new byte[this.value.size() * this.bytesPerChar];
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = this.value;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void symbol;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WasmSymbol wasmSymbol = (WasmSymbol)item$iv;
            int index = n2;
            boolean bl2 = false;
            ConstantDataKt.toLittleEndianBytes(((Character)symbol.getOwner()).charValue(), $this$toBytes_u24lambda_u240, index * this.bytesPerChar, this.fitsLatin1);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String dump(@NotNull String indent, int startAddress) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(indent, "indent");
        if (this.value.isEmpty()) {
            return "";
        }
        Iterable iterable = this.value;
        StringBuilder stringBuilder = new StringBuilder().append(ConstantDataKt.access$addressToString(startAddress)).append(": ").append(indent).append(" i").append(8 * this.getSizeInBytes()).append("[] : ");
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WasmSymbol wasmSymbol = (WasmSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf(((Character)it.getOwner()).charValue()));
        }
        String string = Arrays.toString(CollectionsKt.toCharArray((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return stringBuilder.append(string).append("   ;;\n").toString();
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }
}

