/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.metadata;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeysKt;
import org.jetbrains.kotlin.cli.metadata.AbstractMetadataSerializer;
import org.jetbrains.kotlin.cli.pipeline.CheckCompilationErrors;
import org.jetbrains.kotlin.cli.pipeline.PerformanceNotifications;
import org.jetbrains.kotlin.cli.pipeline.PipelinePhase;
import org.jetbrains.kotlin.cli.pipeline.metadata.MetadataFrontendPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.metadata.MetadataSerializationArtifact;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.comparators.FirMemberDeclarationComparator;
import org.jetbrains.kotlin.fir.pipeline.FirResult;
import org.jetbrains.kotlin.fir.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.serialization.FirAdditionalMetadataProvider;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareSerializableStringTable;
import org.jetbrains.kotlin.fir.serialization.FirElementSerializer;
import org.jetbrains.kotlin.fir.serialization.FirSerializerExtensionBase;
import org.jetbrains.kotlin.fir.serialization.TypeApproximatorForMetadataSerializer;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.SerializableStringTable;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0004\u0019\u001a\u001b\u001cB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002J(\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H$J\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\rH\u0004\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase;", "Lorg/jetbrains/kotlin/cli/pipeline/PipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataFrontendPipelineArtifact;", "Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataSerializationArtifact;", "name", "", "<init>", "(Ljava/lang/String;)V", "executePhase", "input", "serialize", "Lorg/jetbrains/kotlin/cli/metadata/AbstractMetadataSerializer$OutputInfo;", "analysisResult", "", "Lorg/jetbrains/kotlin/fir/pipeline/ModuleCompilerAnalyzedOutput;", "destDir", "Ljava/io/File;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "collectPackagesContent", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase$PackageContent;", "firFiles", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "PackageContent", "PackageSerializer", "Counters", "FirLegacySerializerExtension", "cli"})
@SourceDebugExtension(value={"SMAP\nMetadataLegacySerializerPhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataLegacySerializerPhase.kt\norg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,278:1\n383#2,7:279\n383#2,7:286\n*S KotlinDebug\n*F\n+ 1 MetadataLegacySerializerPhase.kt\norg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase\n*L\n163#1:279,7\n167#1:286,7\n*E\n"})
public abstract class MetadataLegacySerializerPhaseBase
extends PipelinePhase<MetadataFrontendPipelineArtifact, MetadataSerializationArtifact> {
    public MetadataLegacySerializerPhaseBase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Function3[] function3Array = new Function3[]{PerformanceNotifications.BackendFinished.INSTANCE, CheckCompilationErrors.CheckDiagnosticCollector.INSTANCE};
        super(name2, SetsKt.setOf(PerformanceNotifications.BackendStarted.INSTANCE), SetsKt.setOf(function3Array));
    }

    @Override
    @NotNull
    public final MetadataSerializationArtifact executePhase(@NotNull MetadataFrontendPipelineArtifact input) {
        Intrinsics.checkNotNullParameter(input, "input");
        FirResult firResult = input.component1();
        CompilerConfiguration configuration = input.component2();
        BuiltInsBinaryVersion metadataVersion = input.getMetadataVersion();
        File file = CLIConfigurationKeysKt.getMetadataDestinationDirectory(configuration);
        Intrinsics.checkNotNull(file);
        File destDir = file;
        AbstractMetadataSerializer.OutputInfo outputInfo = this.serialize(firResult.getOutputs(), destDir, metadataVersion);
        String string = destDir.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue(string, "getCanonicalPath(...)");
        return new MetadataSerializationArtifact(outputInfo, configuration, string);
    }

    @Nullable
    protected abstract AbstractMetadataSerializer.OutputInfo serialize(@NotNull List<ModuleCompilerAnalyzedOutput> var1, @NotNull File var2, @NotNull BuiltInsBinaryVersion var3);

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<FqName, PackageContent> collectPackagesContent(@NotNull List<? extends FirFile> firFiles) {
        Intrinsics.checkNotNullParameter(firFiles, "firFiles");
        Map contentPerPackage = new LinkedHashMap();
        for (FirFile firFile : firFiles) {
            FqName packageFqName = UtilsKt.getPackageFqName(firFile);
            for (FirDeclaration declaration : firFile.getDeclarations()) {
                Object object;
                void $this$getOrPut$iv;
                Object object2 = contentPerPackage;
                Object key$iv = packageFqName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    PackageContent answer$iv = new PackageContent(null, null, 3, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                PackageContent content = (PackageContent)object;
                object2 = declaration;
                if (object2 instanceof FirCallableDeclaration || object2 instanceof FirTypeAlias) {
                    Object object3;
                    void $this$getOrPut$iv2;
                    key$iv = content.getMembersPerFile();
                    FirFile key$iv2 = firFile;
                    boolean $i$f$getOrPut2 = false;
                    Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                    if (value$iv2 == null) {
                        boolean bl = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv2.put(key$iv2, answer$iv);
                        object3 = answer$iv;
                    } else {
                        object3 = value$iv2;
                    }
                    Collection collection = (Collection)object3;
                    collection.add(declaration);
                    continue;
                }
                if (object2 instanceof FirRegularClass) {
                    ((Collection)content.getClasses()).add(declaration);
                    continue;
                }
                throw new IllegalStateException(("Unexpected declaration: " + UtilsKt.render(declaration)).toString());
            }
        }
        return contentPerPackage;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase$Counters;", "", "<init>", "()V", "totalSize", "", "getTotalSize", "()I", "setTotalSize", "(I)V", "totalFiles", "getTotalFiles", "setTotalFiles", "cli"})
    protected static final class Counters {
        private int totalSize;
        private int totalFiles;

        public final int getTotalSize() {
            return this.totalSize;
        }

        public final void setTotalSize(int n2) {
            this.totalSize = n2;
        }

        public final int getTotalFiles() {
            return this.totalFiles;
        }

        public final void setTotalFiles(int n2) {
            this.totalFiles = n2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase$FirLegacySerializerExtension;", "Lorg/jetbrains/kotlin/fir/serialization/FirSerializerExtensionBase;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "constValueProvider", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "getConstValueProvider", "()Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "additionalMetadataProvider", "Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "getAdditionalMetadataProvider", "()Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "shouldUseTypeTable", "", "cli"})
    public static final class FirLegacySerializerExtension
    extends FirSerializerExtensionBase {
        @NotNull
        private final FirSession session;
        @NotNull
        private final ScopeSession scopeSession;
        @NotNull
        private final BinaryVersion metadataVersion;

        public FirLegacySerializerExtension(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull BinaryVersion metadataVersion) {
            Intrinsics.checkNotNullParameter(session, "session");
            Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
            Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
            super(BuiltInSerializerProtocol.INSTANCE, null, 2, null);
            this.session = session;
            this.scopeSession = scopeSession;
            this.metadataVersion = metadataVersion;
        }

        @Override
        @NotNull
        public FirSession getSession() {
            return this.session;
        }

        @Override
        @NotNull
        public ScopeSession getScopeSession() {
            return this.scopeSession;
        }

        @Override
        @NotNull
        public BinaryVersion getMetadataVersion() {
            return this.metadataVersion;
        }

        @Override
        @Nullable
        public ConstValueProvider getConstValueProvider() {
            return null;
        }

        @Override
        @Nullable
        public FirAdditionalMetadataProvider getAdditionalMetadataProvider() {
            return null;
        }

        @Override
        public boolean shouldUseTypeTable() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B3\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001b\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006H\u00c6\u0003J5\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase$PackageContent;", "", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "membersPerFile", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "<init>", "(Ljava/util/List;Ljava/util/Map;)V", "getClasses", "()Ljava/util/List;", "getMembersPerFile", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cli"})
    protected static final class PackageContent {
        @NotNull
        private final List<FirRegularClass> classes;
        @NotNull
        private final Map<FirFile, List<FirMemberDeclaration>> membersPerFile;

        public PackageContent(@NotNull List<FirRegularClass> classes, @NotNull Map<FirFile, List<FirMemberDeclaration>> membersPerFile) {
            Intrinsics.checkNotNullParameter(classes, "classes");
            Intrinsics.checkNotNullParameter(membersPerFile, "membersPerFile");
            this.classes = classes;
            this.membersPerFile = membersPerFile;
        }

        public /* synthetic */ PackageContent(List list, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                list = new ArrayList();
            }
            if ((n2 & 2) != 0) {
                map = new LinkedHashMap();
            }
            this(list, map);
        }

        @NotNull
        public final List<FirRegularClass> getClasses() {
            return this.classes;
        }

        @NotNull
        public final Map<FirFile, List<FirMemberDeclaration>> getMembersPerFile() {
            return this.membersPerFile;
        }

        @NotNull
        public final List<FirRegularClass> component1() {
            return this.classes;
        }

        @NotNull
        public final Map<FirFile, List<FirMemberDeclaration>> component2() {
            return this.membersPerFile;
        }

        @NotNull
        public final PackageContent copy(@NotNull List<FirRegularClass> classes, @NotNull Map<FirFile, List<FirMemberDeclaration>> membersPerFile) {
            Intrinsics.checkNotNullParameter(classes, "classes");
            Intrinsics.checkNotNullParameter(membersPerFile, "membersPerFile");
            return new PackageContent(classes, membersPerFile);
        }

        public static /* synthetic */ PackageContent copy$default(PackageContent packageContent, List list, Map map, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = packageContent.classes;
            }
            if ((n2 & 2) != 0) {
                map = packageContent.membersPerFile;
            }
            return packageContent.copy(list, map);
        }

        @NotNull
        public String toString() {
            return "PackageContent(classes=" + this.classes + ", membersPerFile=" + this.membersPerFile + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.classes).hashCode();
            result2 = result2 * 31 + ((Object)this.membersPerFile).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PackageContent)) {
                return false;
            }
            PackageContent packageContent = (PackageContent)other;
            if (!Intrinsics.areEqual(this.classes, packageContent.classes)) {
                return false;
            }
            return Intrinsics.areEqual(this.membersPerFile, packageContent.membersPerFile);
        }

        public PackageContent() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0006\u0010-\u001a\u00020.J\u001e\u0010/\u001a\u00020.2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u00100\u001a\u00020,H\u0002J\b\u00101\u001a\u00020.H\u0002J\b\u00102\u001a\u00020.H\u0002J\b\u00103\u001a\u00020.H\u0002J\u0010\u00104\u001a\u00020.2\u0006\u00105\u001a\u000206H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase$PackageSerializer;", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "members", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "destFile", "Ljava/io/File;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "counters", "Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase$Counters;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/util/List;Ljava/util/List;Ljava/io/File;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase$Counters;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getClasses", "()Ljava/util/List;", "getMembers", "getDestFile", "()Ljava/io/File;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getCounters", "()Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase$Counters;", "extension", "Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase$FirLegacySerializerExtension;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment$Builder;", "kotlin.jvm.PlatformType", "typeApproximator", "Lorg/jetbrains/kotlin/fir/serialization/TypeApproximatorForMetadataSerializer;", "getTypeApproximator", "()Lorg/jetbrains/kotlin/fir/serialization/TypeApproximatorForMetadataSerializer;", "rootSerializer", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "serialize", "", "serializeClasses", "parentSerializer", "serializeMembers", "serializeStringTable", "serializeBuiltInsFile", "write", "stream", "Ljava/io/ByteArrayOutputStream;", "cli"})
    @SourceDebugExtension(value={"SMAP\nMetadataLegacySerializerPhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataLegacySerializerPhase.kt\norg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase$PackageSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n1586#2:279\n1661#2,3:280\n14081#3,2:283\n1#4:285\n*S KotlinDebug\n*F\n+ 1 MetadataLegacySerializerPhase.kt\norg/jetbrains/kotlin/cli/pipeline/metadata/MetadataLegacySerializerPhaseBase$PackageSerializer\n*L\n213#1:279\n213#1:280,3\n245#1:283,2\n*E\n"})
    protected static final class PackageSerializer {
        @NotNull
        private final FqName packageFqName;
        @NotNull
        private final List<FirRegularClass> classes;
        @NotNull
        private final List<FirMemberDeclaration> members;
        @NotNull
        private final File destFile;
        @NotNull
        private final FirSession session;
        @NotNull
        private final ScopeSession scopeSession;
        @NotNull
        private final Counters counters;
        @NotNull
        private final FirLegacySerializerExtension extension;
        private final ProtoBuf.PackageFragment.Builder proto;
        @NotNull
        private final TypeApproximatorForMetadataSerializer typeApproximator;
        @NotNull
        private final FirElementSerializer rootSerializer;

        public PackageSerializer(@NotNull FqName packageFqName, @NotNull List<? extends FirRegularClass> classes, @NotNull List<? extends FirMemberDeclaration> members, @NotNull File destFile, @NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull BinaryVersion metadataVersion, @NotNull Counters counters) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            Intrinsics.checkNotNullParameter(classes, "classes");
            Intrinsics.checkNotNullParameter(members, "members");
            Intrinsics.checkNotNullParameter(destFile, "destFile");
            Intrinsics.checkNotNullParameter(session, "session");
            Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
            Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
            Intrinsics.checkNotNullParameter(counters, "counters");
            this.packageFqName = packageFqName;
            this.classes = classes;
            this.members = members;
            this.destFile = destFile;
            this.session = session;
            this.scopeSession = scopeSession;
            this.counters = counters;
            this.extension = new FirLegacySerializerExtension(this.session, this.scopeSession, metadataVersion);
            this.proto = ProtoBuf.PackageFragment.newBuilder();
            this.typeApproximator = new TypeApproximatorForMetadataSerializer(this.session);
            this.rootSerializer = FirElementSerializer.Companion.createTopLevel$default(FirElementSerializer.Companion, this.session, this.scopeSession, this.extension, this.typeApproximator, FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session), false, 32, null);
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public final List<FirRegularClass> getClasses() {
            return this.classes;
        }

        @NotNull
        public final List<FirMemberDeclaration> getMembers() {
            return this.members;
        }

        @NotNull
        public final File getDestFile() {
            return this.destFile;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final ScopeSession getScopeSession() {
            return this.scopeSession;
        }

        @NotNull
        public final Counters getCounters() {
            return this.counters;
        }

        @NotNull
        public final TypeApproximatorForMetadataSerializer getTypeApproximator() {
            return this.typeApproximator;
        }

        public final void serialize() {
            this.serializeClasses(this.classes, this.rootSerializer);
            this.serializeMembers();
            this.serializeStringTable();
            this.serializeBuiltInsFile();
        }

        /*
         * WARNING - void declaration
         */
        private final void serializeClasses(List<? extends FirRegularClass> classes, FirElementSerializer parentSerializer) {
            for (FirRegularClass klass : CollectionsKt.sortedWith((Iterable)classes, FirMemberDeclarationComparator.INSTANCE)) {
                void $this$mapTo$iv$iv;
                FirElementSerializer classSerializer = FirElementSerializer.Companion.create$default(FirElementSerializer.Companion, this.session, this.scopeSession, klass, this.extension, parentSerializer, this.typeApproximator, FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session), false, 128, null);
                Iterable $this$map$iv = classSerializer.computeNestedClassifiersForClass(klass.getSymbol());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirClassifierSymbol firClassifierSymbol = (FirClassifierSymbol)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object e2 = it.getFir();
                    Intrinsics.checkNotNull(e2, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
                    collection.add((FirRegularClass)e2);
                }
                List nestedClasses = (List)destination$iv$iv;
                if (!((Collection)nestedClasses).isEmpty()) {
                    this.serializeClasses(nestedClasses, classSerializer);
                }
                FirFile file = FirProviderKt.getFirProvider(this.session).getFirClassifierContainerFileIfAny(klass.getSymbol());
                ProtoBuf.Class.Builder classProto = classSerializer.classProto(klass, file);
                this.proto.addClass_(classProto.build());
            }
        }

        private final void serializeMembers() {
            ProtoBuf.Package.Builder packagePartProto2 = this.rootSerializer.packagePartProto(this.packageFqName, CollectionsKt.sortedWith((Iterable)this.members, FirMemberDeclarationComparator.INSTANCE), null);
            this.proto.setPackage(packagePartProto2.build());
        }

        private final void serializeStringTable() {
            FirElementAwareSerializableStringTable firElementAwareSerializableStringTable = this.extension.getStringTable();
            Object object = firElementAwareSerializableStringTable instanceof SerializableStringTable ? (SerializableStringTable)firElementAwareSerializableStringTable : null;
            if (object == null || (object = ((SerializableStringTable)object).buildProto()) == null) {
                return;
            }
            Object object2 = object;
            ProtoBuf.StringTable strings2 = (ProtoBuf.StringTable)((Pair)object2).component1();
            ProtoBuf.QualifiedNameTable qualifiedNames = (ProtoBuf.QualifiedNameTable)((Pair)object2).component2();
            this.proto.setStrings(strings2);
            this.proto.setQualifiedNames(qualifiedNames);
        }

        private final void serializeBuiltInsFile() {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream $this$serializeBuiltInsFile_u24lambda_u240 = new DataOutputStream(stream);
            boolean bl = false;
            int[] version2 = this.extension.getMetadataVersion().toArray();
            $this$serializeBuiltInsFile_u24lambda_u240.writeInt(version2.length);
            int[] $this$forEach$iv = version2;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int element$iv;
                int it = element$iv = $this$forEach$iv[i2];
                boolean bl2 = false;
                $this$serializeBuiltInsFile_u24lambda_u240.writeInt(it);
            }
            this.proto.build().writeTo(stream);
            this.write(stream);
        }

        private final void write(ByteArrayOutputStream stream) {
            boolean bl;
            Counters counters = this.counters;
            counters.setTotalSize(counters.getTotalSize() + stream.size());
            counters = this.counters;
            int n2 = counters.getTotalFiles();
            counters.setTotalFiles(n2 + 1);
            boolean bl2 = bl = !this.destFile.isDirectory();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Cannot write because output destination is a directory: " + this.destFile;
                throw new AssertionError((Object)string);
            }
            this.destFile.getParentFile().mkdirs();
            byte[] byArray = stream.toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
            FilesKt.writeBytes(this.destFile, byArray);
        }
    }
}

