/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyInitializationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkers"})
public final class FirPropertyInitializationChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirPropertyInitializationChecker INSTANCE = new FirPropertyInitializationChecker();

    private FirPropertyInitializationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Set declaredLater = new LinkedHashSet();
        FirVisitorVoid visitor2 = new FirVisitorVoid(declaredLater, declaration, context2, reporter){
            final /* synthetic */ Set<FirPropertySymbol> $declaredLater;
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$declaredLater = $declaredLater;
                this.$declaration = $declaration;
                this.$context = $context;
                this.$reporter = $reporter;
            }

            public void visitElement(FirElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                element.acceptChildren(this);
            }

            public void visitConstructor(FirConstructor constructor) {
                Intrinsics.checkNotNullParameter(constructor, "constructor");
            }

            public void visitSimpleFunction(FirSimpleFunction simpleFunction) {
                Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            }

            public void visitPropertyAccessor(FirPropertyAccessor propertyAccessor) {
                Intrinsics.checkNotNullParameter(propertyAccessor, "propertyAccessor");
            }

            public void visitAnonymousFunction(FirAnonymousFunction anonymousFunction) {
                Intrinsics.checkNotNullParameter(anonymousFunction, "anonymousFunction");
            }

            public void visitRegularClass(FirRegularClass regularClass) {
                Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            }

            public void visitEnumEntry(FirEnumEntry enumEntry) {
                Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            }

            public void visitVariableAssignment(FirVariableAssignment variableAssignment) {
                Intrinsics.checkNotNullParameter(variableAssignment, "variableAssignment");
                variableAssignment.acceptChildren(this);
                FirReference firReference = ReferenceUtilsKt.getCalleeReference(variableAssignment);
                FirCallableSymbol firCallableSymbol = firReference != null ? FirReferenceUtilsKt.toResolvedCallableSymbol$default(firReference, false, 1, null) : null;
                FirPropertySymbol firPropertySymbol = firCallableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firCallableSymbol : null;
                if (firPropertySymbol == null) {
                    return;
                }
                FirPropertySymbol propertySymbol = firPropertySymbol;
                if (!this.$declaredLater.contains(propertySymbol)) {
                    return;
                }
                if (this.$declaration instanceof FirAnonymousObject && !LanguageVersionUtilsKt.isEnabled(this.$context, LanguageFeature.ForbidInitializationBeforeDeclarationInAnonymous)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)variableAssignment.getLValue().getSource(), FirErrors.INSTANCE.getINITIALIZATION_BEFORE_DECLARATION_WARNING(), (Object)propertySymbol, null, 16, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)variableAssignment.getLValue().getSource(), FirErrors.INSTANCE.getINITIALIZATION_BEFORE_DECLARATION(), (Object)propertySymbol, null, 16, null);
                }
            }
        };
        for (FirDeclaration member : CollectionsKt.asReversed(declaration.getDeclarations())) {
            if (!((Collection)declaredLater).isEmpty()) {
                member.accept(visitor2);
            }
            if (!(member instanceof FirProperty)) continue;
            declaredLater.add(((FirProperty)member).getSymbol());
        }
    }
}

