/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.SubstitutionUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVarargWithNonTrivialUpperBoundInferredToNothingChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirVarargWithNonTrivialUpperBoundInferredToNothingChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirVarargWithNonTrivialUpperBoundInferredToNothingChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVarargWithNonTrivialUpperBoundInferredToNothingChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n777#2:59\n873#2,2:60\n1642#2,10:62\n1915#2:72\n1916#2:75\n1652#2:76\n1807#2,3:77\n1#3:73\n1#3:74\n*S KotlinDebug\n*F\n+ 1 FirVarargWithNonTrivialUpperBoundInferredToNothingChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVarargWithNonTrivialUpperBoundInferredToNothingChecker\n*L\n31#1:59\n31#1:60,2\n32#1:62,10\n32#1:72\n32#1:75\n32#1:76\n45#1:77,3\n32#1:74\n*E\n"})
public final class FirVarargWithNonTrivialUpperBoundInferredToNothingChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirVarargWithNonTrivialUpperBoundInferredToNothingChecker INSTANCE = new FirVarargWithNonTrivialUpperBoundInferredToNothingChecker();

    private FirVarargWithNonTrivialUpperBoundInferredToNothingChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterator it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (expression2.getTypeArguments().isEmpty()) {
            return;
        }
        FirFunctionSymbol firFunctionSymbol = FirReferenceUtilsKt.toResolvedFunctionSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firFunctionSymbol == null) {
            return;
        }
        FirFunctionSymbol resolvedSymbol = firFunctionSymbol;
        Object object = resolvedSymbol.getValueParameterSymbols();
        boolean $i$f$filter = false;
        void var9_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirValueParameterSymbol)element$iv$iv;
            boolean bl = false;
            if (!((FirValueParameterSymbol)((Object)it)).isVararg()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            FirTypeParameterSymbol firTypeParameterSymbol;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            FirValueParameterSymbol valueParameter2 = (FirValueParameterSymbol)element$iv$iv;
            boolean bl2 = false;
            ConeTypeProjection coneTypeProjection = FirTypeUtilsKt.arrayElementTypeArgument$default(valueParameter2.getResolvedReturnTypeRef().getConeType(), false, 1, null);
            if (coneTypeProjection == null || (coneTypeProjection = ConeTypeProjectionKt.getType(coneTypeProjection)) == null) {
                firTypeParameterSymbol = null;
            } else {
                ConeTypeProjection varargType = coneTypeProjection;
                FirTypeParameterSymbol firTypeParameterSymbol2 = ToSymbolUtilsKt.toTypeParameterSymbol(context2, (ConeKotlinType)varargType);
                if (firTypeParameterSymbol2 != null) {
                    FirTypeParameterSymbol firTypeParameterSymbol3;
                    FirTypeParameterSymbol it2 = firTypeParameterSymbol3 = firTypeParameterSymbol2;
                    boolean bl3 = false;
                    firTypeParameterSymbol = !it2.isReified() ? firTypeParameterSymbol3 : null;
                } else {
                    firTypeParameterSymbol = null;
                }
            }
            if (firTypeParameterSymbol == null) continue;
            FirTypeParameterSymbol it$iv$iv = firTypeParameterSymbol;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        object = (List)destination$iv$iv;
        Iterable it3 = object;
        boolean bl = false;
        Object object2 = !((Collection)it3).isEmpty() ? object : null;
        if (object2 == null) {
            return;
        }
        Iterable typeParametersUsedAsVarargs = object2;
        ConeSubstitutor coneSubstitutor = SubstitutionUtilsKt.createConeSubstitutorFromTypeArguments$default(expression2, context2.getSession(), false, 2, null);
        if (coneSubstitutor == null) {
            return;
        }
        ConeSubstitutor substitutor2 = coneSubstitutor;
        for (FirTypeParameterSymbol typeParameter : typeParametersUsedAsVarargs) {
            int typeParameterIndex;
            boolean needReport;
            boolean bl5;
            ConeKotlinType actualVarargType;
            block19: {
                ConeTypeParameterType parameterType = FirNestedClassifierScopeKt.toConeType(typeParameter);
                actualVarargType = substitutor2.substituteOrSelf(parameterType);
                if (ConeBuiltinTypeUtilsKt.isNothing(actualVarargType)) {
                    bl5 = true;
                } else if (ConeBuiltinTypeUtilsKt.isNullableNothing(actualVarargType)) {
                    Iterable $this$any$iv = typeParameter.getResolvedBounds();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirResolvedTypeRef it4 = (FirResolvedTypeRef)element$iv;
                            boolean bl6 = false;
                            if (!(!ConeBuiltinTypeUtilsKt.isAnyOrNullableAny(it4.getConeType()))) continue;
                            bl5 = true;
                            break block19;
                        }
                        bl5 = false;
                    }
                } else {
                    bl5 = false;
                }
            }
            if (!(needReport = bl5)) continue;
            int it5 = typeParameterIndex = resolvedSymbol.getTypeParameterSymbols().indexOf(typeParameter);
            boolean bl7 = false;
            FirTypeProjection firTypeProjection = CollectionsKt.getOrNull(expression2.getTypeArguments(), it5);
            KtSourceElement typeArgumentSource = firTypeProjection != null ? firTypeProjection.getSource() : null;
            KtSourceElement ktSourceElement = typeArgumentSource;
            if (ktSourceElement == null) {
                ktSourceElement = expression2.getSource();
            }
            KtSourceElement source = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getILLEGAL_TYPE_ARGUMENT_FOR_VARARG_PARAMETER_WARNING(), (Object)actualVarargType, null, 16, null);
        }
    }
}

