/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirGlobalResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessorKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTransformerBasedResolveProcessor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirTotalResolveProcessor;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "processors", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirResolveProcessor;", "process", "", "files", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirTotalResolveProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTotalResolveProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirTotalResolveProcessor\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n*L\n1#1,94:1\n249#2,4:95\n*S KotlinDebug\n*F\n+ 1 FirTotalResolveProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirTotalResolveProcessor\n*L\n35#1:95,4\n*E\n"})
public final class FirTotalResolveProcessor {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final List<FirResolveProcessor> processors;

    public FirTotalResolveProcessor(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
        this.scopeSession = new ScopeSession();
        this.processors = FirTotalResolveProcessorKt.createAllCompilerResolveProcessors(this.session, this.scopeSession);
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(@NotNull List<? extends FirFile> files2) {
        Intrinsics.checkNotNullParameter(files2, "files");
        for (FirResolveProcessor processor : this.processors) {
            processor.beforePhase();
            try {
                FirResolveProcessor firResolveProcessor = processor;
                if (firResolveProcessor instanceof FirTransformerBasedResolveProcessor) {
                    Iterator<? extends FirFile> iterator2 = files2.iterator();
                    while (iterator2.hasNext()) {
                        FirFile file;
                        FirFile file$iv = file = iterator2.next();
                        boolean $i$f$withFileAnalysisExceptionWrapping = false;
                        try {
                            boolean bl = false;
                            ((FirTransformerBasedResolveProcessor)processor).processFile(file);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable$iv) {
                            UtilsKt.getExceptionHandler(file$iv.getModuleData().getSession()).handleExceptionOnFileAnalysis(file$iv, throwable$iv);
                            throw new KotlinNothingValueException();
                        }
                    }
                    continue;
                }
                if (firResolveProcessor instanceof FirGlobalResolveProcessor) {
                    ((FirGlobalResolveProcessor)processor).process((Collection<? extends FirFile>)files2);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            finally {
                processor.afterPhase();
            }
        }
    }
}

