/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.calls.overloads.ConeEquivalentCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.DelicateScopeAPI;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirActualizingScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u001c\u0010\u0012\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\u001c\u0010\u0016\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00110\u0017H\u0016J$\u0010\u0019\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00110\u0017H\u0016J(\u0010\u001b\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u00110\u0017H\u0016Jc\u0010\u001d\u001a\u00020\u0011\"\f\b\u0000\u0010\u001e*\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\t\u001a\u00020\n2/\u0010 \u001a+\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020\u00110\u0017\u0012\u0004\u0012\u00020\u00110!\u00a2\u0006\u0002\b\"2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020\u00110\u0017H\u0002J\"\u0010#\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u001f2\u0010\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0%H\u0002J\u0010\u0010&\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u001fH\u0002J+\u0010'\u001a\u00020\b\"\f\b\u0000\u0010\u001e*\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010(\u001a\u0002H\u001e2\u0006\u0010)\u001a\u0002H\u001eH\u0002\u00a2\u0006\u0002\u0010*J\u001a\u0010+\u001a\u0004\u0018\u00010\u00002\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0017R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirActualizingScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "delegate", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/scopes/FirScope;Lorg/jetbrains/kotlin/fir/FirSession;)V", "mayContainName", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "scopeOwnerLookupNames", "", "", "getScopeOwnerLookupNames", "()Ljava/util/List;", "processClassifiersByNameWithSubstitution", "", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "processDeclaredConstructors", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "processFunctionsByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "processCallableSymbolsByName", "S", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "processingFactory", "Lkotlin/Function3;", "Lkotlin/ExtensionFunctionType;", "hasEquivalentNotActualFromLibrary", "notExpectSymbols", "", "isFromLibrary", "areEquivalent", "symbol", "s", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "withReplacedSessionOrNull", "newSession", "newScopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirActualizingScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirActualizingScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirActualizingScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,125:1\n1915#2,2:126\n1915#2,2:128\n1807#2,3:130\n1#3:133\n25#4:134\n26#4:135\n26#4:136\n*S KotlinDebug\n*F\n+ 1 FirActualizingScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirActualizingScope\n*L\n100#1:126,2\n101#1:128,2\n105#1:130,3\n75#1:134\n81#1:135\n86#1:136\n*E\n"})
public final class FirActualizingScope
extends FirScope {
    @NotNull
    private final FirScope delegate;
    @NotNull
    private final FirSession session;
    @NotNull
    private final List<String> scopeOwnerLookupNames;

    public FirActualizingScope(@NotNull FirScope delegate, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        Intrinsics.checkNotNullParameter(session, "session");
        this.delegate = delegate;
        this.session = session;
        if (!(!(this.delegate instanceof FirTypeScope))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.scopeOwnerLookupNames = this.delegate.getScopeOwnerLookupNames();
    }

    @Override
    public boolean mayContainName(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return this.delegate.mayContainName(name2);
    }

    @Override
    @NotNull
    public List<String> getScopeOwnerLookupNames() {
        return this.scopeOwnerLookupNames;
    }

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name2, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        this.delegate.processClassifiersByNameWithSubstitution(name2, processor);
    }

    @Override
    public void processDeclaredConstructors(@NotNull Function1<? super FirConstructorSymbol, Unit> processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        this.delegate.processDeclaredConstructors(processor);
    }

    @Override
    public void processFunctionsByName(@NotNull Name name2, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        this.processCallableSymbolsByName(name2, processFunctionsByName.1.INSTANCE, processor);
    }

    @Override
    public void processPropertiesByName(@NotNull Name name2, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        this.processCallableSymbolsByName(name2, processPropertiesByName.1.INSTANCE, processor);
    }

    private final <S extends FirCallableSymbol<?>> void processCallableSymbolsByName(Name name2, Function3<? super FirScope, ? super Name, ? super Function1<? super S, Unit>, Unit> processingFactory, Function1<? super S, Unit> processor) {
        Set expectSymbols = new LinkedHashSet();
        Set notExpectSymbols = new LinkedHashSet();
        Set ignoredExpectSymbols = new LinkedHashSet();
        processingFactory.invoke(this.delegate, name2, arg_0 -> FirActualizingScope.processCallableSymbolsByName$lambda$0(expectSymbols, ignoredExpectSymbols, notExpectSymbols, arg_0));
        expectSymbols.removeIf(arg_0 -> FirActualizingScope.processCallableSymbolsByName$lambda$2(arg_0 -> FirActualizingScope.processCallableSymbolsByName$lambda$1(this, notExpectSymbols, arg_0), arg_0));
        Iterable $this$forEach$iv = expectSymbols;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            processor.invoke(element$iv);
        }
        $this$forEach$iv = notExpectSymbols;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            processor.invoke(element$iv);
        }
    }

    private final boolean hasEquivalentNotActualFromLibrary(FirCallableSymbol<?> $this$hasEquivalentNotActualFromLibrary, Set<? extends FirCallableSymbol<?>> notExpectSymbols) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = notExpectSymbols;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl2 = false;
                    if (!(this.isFromLibrary(it) && this.areEquivalent($this$hasEquivalentNotActualFromLibrary, it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isFromLibrary(FirCallableSymbol<?> $this$isFromLibrary) {
        return $this$isFromLibrary.getModuleData().getSession().getKind() == FirSession.Kind.Library;
    }

    private final <S extends FirCallableSymbol<?>> boolean areEquivalent(S symbol, S s2) {
        return ConeEquivalentCallConflictResolver.Companion.areEquivalentTopLevelCallables((FirCallableDeclaration)symbol.getFir(), (FirCallableDeclaration)s2.getFir(), this.session, null);
    }

    @Override
    @DelicateScopeAPI
    @Nullable
    public FirActualizingScope withReplacedSessionOrNull(@NotNull FirSession newSession, @NotNull ScopeSession newScopeSession) {
        FirActualizingScope firActualizingScope;
        Intrinsics.checkNotNullParameter(newSession, "newSession");
        Intrinsics.checkNotNullParameter(newScopeSession, "newScopeSession");
        FirScope firScope = this.delegate.withReplacedSessionOrNull(newSession, newScopeSession);
        if (firScope != null) {
            FirScope it = firScope;
            boolean bl = false;
            firActualizingScope = new FirActualizingScope(it, newSession);
        } else {
            firActualizingScope = null;
        }
        return firActualizingScope;
    }

    private static final Unit processCallableSymbolsByName$lambda$0(Set $expectSymbols, Set $ignoredExpectSymbols, Set $notExpectSymbols, FirCallableSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        FirCallableSymbol $this$isActual$iv = symbol;
        boolean $i$f$isActual2 = false;
        if ($this$isActual$iv.getRawStatus().isActual()) {
            FirBasedSymbol<?> matchedExpectSymbol = ExpectActualAttributesKt.getSingleMatchedExpectForActualOrNull(symbol);
            if (matchedExpectSymbol != null) {
                Collection $i$f$isActual2 = $expectSymbols;
                FirBasedSymbol<?> firBasedSymbol = matchedExpectSymbol;
                TypeIntrinsics.asMutableCollection($i$f$isActual2).remove(firBasedSymbol);
                $ignoredExpectSymbols.add(matchedExpectSymbol);
            }
        } else {
            FirCallableSymbol $this$isExpect$iv = symbol;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getRawStatus().isExpect() && $ignoredExpectSymbols.contains(symbol)) {
                return Unit.INSTANCE;
            }
        }
        FirCallableSymbol $this$isExpect$iv = symbol;
        boolean $i$f$isExpect = false;
        Set resultSet = $this$isExpect$iv.getRawStatus().isExpect() ? $expectSymbols : $notExpectSymbols;
        resultSet.add(symbol);
        return Unit.INSTANCE;
    }

    private static final boolean processCallableSymbolsByName$lambda$1(FirActualizingScope this$0, Set $notExpectSymbols, FirCallableSymbol expectSymbol) {
        Intrinsics.checkNotNullParameter(expectSymbol, "expectSymbol");
        return this$0.isFromLibrary(expectSymbol) && this$0.hasEquivalentNotActualFromLibrary(expectSymbol, $notExpectSymbols);
    }

    private static final boolean processCallableSymbolsByName$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

