/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.session;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirSessionComponent;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/session/SourcesToPathsMapper;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "<init>", "()V", "sourcesToPath", "", "Lcom/intellij/lang/LighterASTNode;", "", "registerFileSource", "", "sourceElement", "Lorg/jetbrains/kotlin/KtSourceElement;", "path", "getSourceFilePath", "entrypoint"})
public final class SourcesToPathsMapper
implements FirSessionComponent {
    @NotNull
    private final Map<LighterASTNode, String> sourcesToPath = new LinkedHashMap();

    public final void registerFileSource(@NotNull KtSourceElement sourceElement, @NotNull String path) {
        Intrinsics.checkNotNullParameter(sourceElement, "sourceElement");
        Intrinsics.checkNotNullParameter(path, "path");
        if (!(sourceElement instanceof KtPsiSourceElement)) {
            this.sourcesToPath.put(sourceElement.getTreeStructure().getRoot(), path);
        }
    }

    @Nullable
    public final String getSourceFilePath(@NotNull KtSourceElement sourceElement) {
        UserDataHolder userDataHolder;
        PsiElement psi;
        Intrinsics.checkNotNullParameter(sourceElement, "sourceElement");
        PsiElement psiElement = psi = KtSourceElementKt.getPsi(sourceElement);
        return psiElement != null ? ((userDataHolder = psiElement.getContainingFile()) != null && (userDataHolder = userDataHolder.getVirtualFile()) != null ? ((VirtualFile)userDataHolder).getPath() : null) : this.sourcesToPath.get(sourceElement.getTreeStructure().getRoot());
    }
}

