/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.transformer;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterChecker;
import org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterCheckerData;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u0012\u001e\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001aJ\u0016\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0015J\u000e\u0010!\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001aJ\"\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%H\u0086\b\u00f8\u0001\u0000J\u0018\u0010&\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstEvaluationContext;", "", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "mode", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "checker", "Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;", "evaluatedConstTracker", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "onWarning", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/expressions/IrErrorExpression;", "", "onError", "suppressExceptions", "", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function3;Z)V", "shouldSaveEvaluatedConstants", "warningIfError", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "original", "reportIfError", "canBeInterpreted", "expression", "interpret", "failAsError", "saveInConstTracker", "saveConstantsOnCondition", "saveConstants", "block", "Lkotlin/Function0;", "reportInlinedJavaConst", "result", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "ir.interpreter"})
public final class IrConstEvaluationContext {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final EvaluationMode mode;
    @NotNull
    private final IrInterpreterChecker checker;
    @Nullable
    private final EvaluatedConstTracker evaluatedConstTracker;
    @Nullable
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private final Function3<IrFile, IrElement, IrErrorExpression, Unit> onWarning;
    @NotNull
    private final Function3<IrFile, IrElement, IrErrorExpression, Unit> onError;
    private final boolean suppressExceptions;
    private boolean shouldSaveEvaluatedConstants;

    public IrConstEvaluationContext(@NotNull IrInterpreter interpreter2, @NotNull IrFile irFile, @NotNull EvaluationMode mode, @NotNull IrInterpreterChecker checker, @Nullable EvaluatedConstTracker evaluatedConstTracker, @Nullable InlineConstTracker inlineConstTracker, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onWarning, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onError, boolean suppressExceptions) {
        Intrinsics.checkNotNullParameter(interpreter2, "interpreter");
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        Intrinsics.checkNotNullParameter(mode, "mode");
        Intrinsics.checkNotNullParameter(checker, "checker");
        Intrinsics.checkNotNullParameter(onWarning, "onWarning");
        Intrinsics.checkNotNullParameter(onError, "onError");
        this.interpreter = interpreter2;
        this.irFile = irFile;
        this.mode = mode;
        this.checker = checker;
        this.evaluatedConstTracker = evaluatedConstTracker;
        this.inlineConstTracker = inlineConstTracker;
        this.onWarning = onWarning;
        this.onError = onError;
        this.suppressExceptions = suppressExceptions;
        this.shouldSaveEvaluatedConstants = true;
    }

    private final IrExpression warningIfError(IrExpression $this$warningIfError, IrExpression original) {
        if ($this$warningIfError instanceof IrErrorExpression) {
            this.onWarning.invoke(this.irFile, original, (IrErrorExpression)$this$warningIfError);
            return original;
        }
        return $this$warningIfError;
    }

    private final IrExpression reportIfError(IrExpression $this$reportIfError, IrExpression original) {
        if ($this$reportIfError instanceof IrErrorExpression) {
            this.onError.invoke(this.irFile, original, (IrErrorExpression)$this$reportIfError);
            return this.mode instanceof EvaluationMode.OnlyIntrinsicConst ? (IrExpression)IrConstImpl.Companion.constNull($this$reportIfError.getStartOffset(), $this$reportIfError.getEndOffset(), $this$reportIfError.getType()) : original;
        }
        return $this$reportIfError;
    }

    public final boolean canBeInterpreted(@NotNull IrExpression expression2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        try {
            bl = (Boolean)expression2.accept(this.checker, new IrInterpreterCheckerData(this.irFile, this.mode, this.interpreter.getIrBuiltIns()));
        }
        catch (Throwable e2) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded(e2);
            if (this.suppressExceptions) {
                return false;
            }
            throw new AssertionError("Error occurred while optimizing an expression:\n" + DumpIrTreeKt.dump$default(expression2, null, 1, null), e2);
        }
        return bl;
    }

    @NotNull
    public final IrExpression interpret(@NotNull IrExpression expression2, boolean failAsError) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        try {
            irExpression = this.interpreter.interpret(expression2, this.irFile);
        }
        catch (Throwable e2) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded(e2);
            if (this.suppressExceptions) {
                return expression2;
            }
            throw new AssertionError("Error occurred while optimizing an expression:\n" + DumpIrTreeKt.dump$default(expression2, null, 1, null), e2);
        }
        IrExpression result2 = irExpression;
        this.saveInConstTracker(result2);
        if (result2 instanceof IrConst) {
            this.reportInlinedJavaConst(expression2, (IrConst)result2);
        }
        return failAsError ? this.reportIfError(result2, expression2) : this.warningIfError(result2, expression2);
    }

    public final void saveInConstTracker(@NotNull IrExpression expression2) {
        block1: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (!this.shouldSaveEvaluatedConstants) {
                return;
            }
            EvaluatedConstTracker evaluatedConstTracker = this.evaluatedConstTracker;
            if (evaluatedConstTracker == null) break block1;
            evaluatedConstTracker.save(expression2.getStartOffset(), expression2.getEndOffset(), IrDeclarationsKt.getEvaluatedConstTrackerKey(this.irFile), expression2 instanceof IrErrorExpression ? (ConstantValue)ErrorValue.Companion.create(((IrErrorExpression)expression2).getDescription()) : IrTreeBuildUtilsKt.toConstantValue(expression2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveConstantsOnCondition(boolean saveConstants, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$saveConstantsOnCondition = false;
        boolean oldValue = this.shouldSaveEvaluatedConstants;
        this.shouldSaveEvaluatedConstants = saveConstants;
        try {
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart(1);
            this.shouldSaveEvaluatedConstants = oldValue;
            InlineMarker.finallyEnd(1);
        }
    }

    private final void reportInlinedJavaConst(IrExpression expression2, IrConst result2) {
        IrVisitorsKt.acceptVoid((IrElement)expression2, new IrVisitorVoid(this, result2){
            final /* synthetic */ IrConstEvaluationContext this$0;
            final /* synthetic */ IrConst $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            private final void report(IrField field) {
                block0: {
                    InlineConstTracker inlineConstTracker = IrConstEvaluationContext.access$getInlineConstTracker$p(this.this$0);
                    if (inlineConstTracker == null) break block0;
                    IrConstTransformerKt.reportOnIr(inlineConstTracker, IrConstEvaluationContext.access$getIrFile$p(this.this$0), field, this.$result);
                }
            }

            public void visitGetField(IrGetField expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                this.report((IrField)expression2.getSymbol().getOwner());
                super.visitGetField(expression2);
            }

            public void visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrDeclarationBase irDeclarationBase = UtilsKt.getProperty(expression2.getSymbol().getOwner());
                if (irDeclarationBase != null && (irDeclarationBase = irDeclarationBase.getBackingField()) != null) {
                    IrDeclarationBase backingField = irDeclarationBase;
                    boolean bl = false;
                    this.report((IrField)backingField);
                }
                super.visitCall(expression2);
            }
        });
    }

    public static final /* synthetic */ InlineConstTracker access$getInlineConstTracker$p(IrConstEvaluationContext $this) {
        return $this.inlineConstTracker;
    }

    public static final /* synthetic */ IrFile access$getIrFile$p(IrConstEvaluationContext $this) {
        return $this.irFile;
    }
}

