// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct InvokeModelOutput {
    /// <p>Inference response from the model in the format specified in the <code>contentType</code> header. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>.</p>
    pub body: ::aws_smithy_types::Blob,
    /// <p>The MIME type of the inference result.</p>
    pub content_type: ::std::string::String,
    /// <p>Model performance settings for the request.</p>
    pub performance_config_latency: ::std::option::Option<crate::types::PerformanceConfigLatency>,
    _request_id: Option<String>,
}
impl InvokeModelOutput {
    /// <p>Inference response from the model in the format specified in the <code>contentType</code> header. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>.</p>
    pub fn body(&self) -> &::aws_smithy_types::Blob {
        &self.body
    }
    /// <p>The MIME type of the inference result.</p>
    pub fn content_type(&self) -> &str {
        use std::ops::Deref;
        self.content_type.deref()
    }
    /// <p>Model performance settings for the request.</p>
    pub fn performance_config_latency(&self) -> ::std::option::Option<&crate::types::PerformanceConfigLatency> {
        self.performance_config_latency.as_ref()
    }
}
impl ::std::fmt::Debug for InvokeModelOutput {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeModelOutput");
        formatter.field("body", &"*** Sensitive Data Redacted ***");
        formatter.field("content_type", &self.content_type);
        formatter.field("performance_config_latency", &self.performance_config_latency);
        formatter.field("_request_id", &self._request_id);
        formatter.finish()
    }
}
impl ::aws_types::request_id::RequestId for InvokeModelOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl InvokeModelOutput {
    /// Creates a new builder-style object to manufacture [`InvokeModelOutput`](crate::operation::invoke_model::InvokeModelOutput).
    pub fn builder() -> crate::operation::invoke_model::builders::InvokeModelOutputBuilder {
        crate::operation::invoke_model::builders::InvokeModelOutputBuilder::default()
    }
}

/// A builder for [`InvokeModelOutput`](crate::operation::invoke_model::InvokeModelOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct InvokeModelOutputBuilder {
    pub(crate) body: ::std::option::Option<::aws_smithy_types::Blob>,
    pub(crate) content_type: ::std::option::Option<::std::string::String>,
    pub(crate) performance_config_latency: ::std::option::Option<crate::types::PerformanceConfigLatency>,
    _request_id: Option<String>,
}
impl InvokeModelOutputBuilder {
    /// <p>Inference response from the model in the format specified in the <code>contentType</code> header. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>.</p>
    /// This field is required.
    pub fn body(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.body = ::std::option::Option::Some(input);
        self
    }
    /// <p>Inference response from the model in the format specified in the <code>contentType</code> header. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>.</p>
    pub fn set_body(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.body = input;
        self
    }
    /// <p>Inference response from the model in the format specified in the <code>contentType</code> header. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>.</p>
    pub fn get_body(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.body
    }
    /// <p>The MIME type of the inference result.</p>
    /// This field is required.
    pub fn content_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The MIME type of the inference result.</p>
    pub fn set_content_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_type = input;
        self
    }
    /// <p>The MIME type of the inference result.</p>
    pub fn get_content_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_type
    }
    /// <p>Model performance settings for the request.</p>
    pub fn performance_config_latency(mut self, input: crate::types::PerformanceConfigLatency) -> Self {
        self.performance_config_latency = ::std::option::Option::Some(input);
        self
    }
    /// <p>Model performance settings for the request.</p>
    pub fn set_performance_config_latency(mut self, input: ::std::option::Option<crate::types::PerformanceConfigLatency>) -> Self {
        self.performance_config_latency = input;
        self
    }
    /// <p>Model performance settings for the request.</p>
    pub fn get_performance_config_latency(&self) -> &::std::option::Option<crate::types::PerformanceConfigLatency> {
        &self.performance_config_latency
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`InvokeModelOutput`](crate::operation::invoke_model::InvokeModelOutput).
    /// This method will fail if any of the following fields are not set:
    /// - [`body`](crate::operation::invoke_model::builders::InvokeModelOutputBuilder::body)
    /// - [`content_type`](crate::operation::invoke_model::builders::InvokeModelOutputBuilder::content_type)
    pub fn build(self) -> ::std::result::Result<crate::operation::invoke_model::InvokeModelOutput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::invoke_model::InvokeModelOutput {
            body: self.body.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "body",
                    "body was not specified but it is required when building InvokeModelOutput",
                )
            })?,
            content_type: self.content_type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "content_type",
                    "content_type was not specified but it is required when building InvokeModelOutput",
                )
            })?,
            performance_config_latency: self.performance_config_latency,
            _request_id: self._request_id,
        })
    }
}
impl ::std::fmt::Debug for InvokeModelOutputBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeModelOutputBuilder");
        formatter.field("body", &"*** Sensitive Data Redacted ***");
        formatter.field("content_type", &self.content_type);
        formatter.field("performance_config_latency", &self.performance_config_latency);
        formatter.field("_request_id", &self._request_id);
        formatter.finish()
    }
}
