import pytest

URL = "https://nvidia.com/en-eu"


async def is_content_offscreen(client):
    await client.navigate(URL)
    return client.execute_script("return document.body.scrollWidth > screen.width")


@pytest.mark.only_platforms("android")
@pytest.mark.asyncio
@pytest.mark.with_interventions
async def test_enabled(client):
    assert not await is_content_offscreen(client)


@pytest.mark.only_platforms("android")
@pytest.mark.asyncio
@pytest.mark.without_interventions
async def test_disabled(client):
    assert await is_content_offscreen(client)
