use std::thread::sleep;
use std::time::Duration;
use tracing::{span, Level};
use tracing_flame::FlameLayer;
use tracing_subscriber::{prelude::*, registry::Registry};

#[test]
fn capture_supported() {
    {
        let tmp_dir = tempfile::Builder::new()
            .prefix("tracing-flamegraph-test-")
            .tempdir()
            .expect("failed to create tempdir");
        let (flame_layer, _guard) =
            FlameLayer::with_file(tmp_dir.path().join("tracing.folded")).unwrap();

        let subscriber = Registry::default().with(flame_layer);

        tracing::subscriber::set_global_default(subscriber).expect("Could not set global default");

        {
            let span = span!(Level::ERROR, "outer");
            let _guard = span.enter();
            sleep(Duration::from_millis(10));

            {
                let span = span!(Level::ERROR, "Inner");
                let _guard = span.enter();
                sleep(Duration::from_millis(50));

                {
                    let span = span!(Level::ERROR, "Innermost");
                    let _guard = span.enter();
                    sleep(Duration::from_millis(50));
                }
            }

            sleep(Duration::from_millis(5));
        }

        sleep(Duration::from_millis(500));

        tmp_dir.close().expect("failed to delete tempdir");
    }
}
