package sentences

// generated by github.com/clipperhouse/uax29/v2
// from https://www.unicode.org/Public/15.0.0/ucd/auxiliary/SentenceBreakProperty.txt

import "github.com/clipperhouse/uax29/v2/internal/iterators"

type property uint16

const (
	_ATerm property = 1 << iota
	_CR
	_Close
	_Extend
	_Format
	_LF
	_Lower
	_Numeric
	_OLetter
	_SContinue
	_STerm
	_Sep
	_Sp
	_Upper
)

// lookup returns the trie value for the first UTF-8 encoding in s and
// the width in bytes of this encoding. The size will be 0 if s does not
// hold enough bytes to complete the encoding. len(s) must be greater than 0.
func lookup[T iterators.Stringish](s T) (v property, sz int) {
	c0 := s[0]
	switch {
	case c0 < 0x80: // is ASCII
		return sentencesValues[c0], 1
	case c0 < 0xC2:
		return 0, 1 // Illegal UTF-8: not a starter, not ASCII.
	case c0 < 0xE0: // 2-byte UTF-8
		if len(s) < 2 {
			return 0, 0
		}
		i := sentencesIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		return lookupValue(uint32(i), c1), 2
	case c0 < 0xF0: // 3-byte UTF-8
		if len(s) < 3 {
			return 0, 0
		}
		i := sentencesIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = sentencesIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		return lookupValue(uint32(i), c2), 3
	case c0 < 0xF8: // 4-byte UTF-8
		if len(s) < 4 {
			return 0, 0
		}
		i := sentencesIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = sentencesIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		o = uint32(i)<<6 + uint32(c2)
		i = sentencesIndex[o]
		c3 := s[3]
		if c3 < 0x80 || 0xC0 <= c3 {
			return 0, 3 // Illegal UTF-8: not a continuation byte.
		}
		return lookupValue(uint32(i), c3), 4
	}
	// Illegal rune
	return 0, 1
}

// sentencesTrie. Total size: 49280 bytes (48.12 KiB). Checksum: ee8ba394794a2865.
// type sentencesTrie struct { }

// func newSentencesTrie(i int) *sentencesTrie {
// 	return &sentencesTrie{}
// }

// lookupValue determines the type of block n and looks up the value for b.
func lookupValue(n uint32, b byte) property {
	switch {
	default:
		return property(sentencesValues[n<<6+uint32(b)])
	}
}

// sentencesValues: 349 blocks, 22336 entries, 44672 bytes
// The third block is the zero block.
var sentencesValues = [22336]property{
	// Block 0x0, offset 0x0
	0x09: 0x1000, 0x0a: 0x0020, 0x0b: 0x1000,
	0x0c: 0x1000, 0x0d: 0x0002,
	0x20: 0x1000, 0x21: 0x0400, 0x22: 0x0004,
	0x27: 0x0004, 0x28: 0x0004, 0x29: 0x0004,
	0x2c: 0x0200, 0x2d: 0x0200, 0x2e: 0x0001,
	0x30: 0x0080, 0x31: 0x0080, 0x32: 0x0080, 0x33: 0x0080, 0x34: 0x0080, 0x35: 0x0080,
	0x36: 0x0080, 0x37: 0x0080, 0x38: 0x0080, 0x39: 0x0080, 0x3a: 0x0200,
	0x3f: 0x0400,
	// Block 0x1, offset 0x40
	0x41: 0x2000, 0x42: 0x2000, 0x43: 0x2000, 0x44: 0x2000, 0x45: 0x2000,
	0x46: 0x2000, 0x47: 0x2000, 0x48: 0x2000, 0x49: 0x2000, 0x4a: 0x2000, 0x4b: 0x2000,
	0x4c: 0x2000, 0x4d: 0x2000, 0x4e: 0x2000, 0x4f: 0x2000, 0x50: 0x2000, 0x51: 0x2000,
	0x52: 0x2000, 0x53: 0x2000, 0x54: 0x2000, 0x55: 0x2000, 0x56: 0x2000, 0x57: 0x2000,
	0x58: 0x2000, 0x59: 0x2000, 0x5a: 0x2000, 0x5b: 0x0004, 0x5d: 0x0004,
	0x61: 0x0040, 0x62: 0x0040, 0x63: 0x0040,
	0x64: 0x0040, 0x65: 0x0040, 0x66: 0x0040, 0x67: 0x0040, 0x68: 0x0040, 0x69: 0x0040,
	0x6a: 0x0040, 0x6b: 0x0040, 0x6c: 0x0040, 0x6d: 0x0040, 0x6e: 0x0040, 0x6f: 0x0040,
	0x70: 0x0040, 0x71: 0x0040, 0x72: 0x0040, 0x73: 0x0040, 0x74: 0x0040, 0x75: 0x0040,
	0x76: 0x0040, 0x77: 0x0040, 0x78: 0x0040, 0x79: 0x0040, 0x7a: 0x0040, 0x7b: 0x0004,
	0x7d: 0x0004,
	// Block 0x2, offset 0x80
	// Block 0x3, offset 0xc0
	0xc5: 0x0800,
	0xe0: 0x1000,
	0xea: 0x0040, 0xeb: 0x0004, 0xed: 0x0010,
	0xf5: 0x0040,
	0xfa: 0x0040, 0xfb: 0x0004,
	// Block 0x4, offset 0x100
	0x100: 0x2000, 0x101: 0x2000, 0x102: 0x2000, 0x103: 0x2000, 0x104: 0x2000, 0x105: 0x2000,
	0x106: 0x2000, 0x107: 0x2000, 0x108: 0x2000, 0x109: 0x2000, 0x10a: 0x2000, 0x10b: 0x2000,
	0x10c: 0x2000, 0x10d: 0x2000, 0x10e: 0x2000, 0x10f: 0x2000, 0x110: 0x2000, 0x111: 0x2000,
	0x112: 0x2000, 0x113: 0x2000, 0x114: 0x2000, 0x115: 0x2000, 0x116: 0x2000,
	0x118: 0x2000, 0x119: 0x2000, 0x11a: 0x2000, 0x11b: 0x2000, 0x11c: 0x2000, 0x11d: 0x2000,
	0x11e: 0x2000, 0x11f: 0x0040, 0x120: 0x0040, 0x121: 0x0040, 0x122: 0x0040, 0x123: 0x0040,
	0x124: 0x0040, 0x125: 0x0040, 0x126: 0x0040, 0x127: 0x0040, 0x128: 0x0040, 0x129: 0x0040,
	0x12a: 0x0040, 0x12b: 0x0040, 0x12c: 0x0040, 0x12d: 0x0040, 0x12e: 0x0040, 0x12f: 0x0040,
	0x130: 0x0040, 0x131: 0x0040, 0x132: 0x0040, 0x133: 0x0040, 0x134: 0x0040, 0x135: 0x0040,
	0x136: 0x0040, 0x138: 0x0040, 0x139: 0x0040, 0x13a: 0x0040, 0x13b: 0x0040,
	0x13c: 0x0040, 0x13d: 0x0040, 0x13e: 0x0040, 0x13f: 0x0040,
	// Block 0x5, offset 0x140
	0x140: 0x2000, 0x141: 0x0040, 0x142: 0x2000, 0x143: 0x0040, 0x144: 0x2000, 0x145: 0x0040,
	0x146: 0x2000, 0x147: 0x0040, 0x148: 0x2000, 0x149: 0x0040, 0x14a: 0x2000, 0x14b: 0x0040,
	0x14c: 0x2000, 0x14d: 0x0040, 0x14e: 0x2000, 0x14f: 0x0040, 0x150: 0x2000, 0x151: 0x0040,
	0x152: 0x2000, 0x153: 0x0040, 0x154: 0x2000, 0x155: 0x0040, 0x156: 0x2000, 0x157: 0x0040,
	0x158: 0x2000, 0x159: 0x0040, 0x15a: 0x2000, 0x15b: 0x0040, 0x15c: 0x2000, 0x15d: 0x0040,
	0x15e: 0x2000, 0x15f: 0x0040, 0x160: 0x2000, 0x161: 0x0040, 0x162: 0x2000, 0x163: 0x0040,
	0x164: 0x2000, 0x165: 0x0040, 0x166: 0x2000, 0x167: 0x0040, 0x168: 0x2000, 0x169: 0x0040,
	0x16a: 0x2000, 0x16b: 0x0040, 0x16c: 0x2000, 0x16d: 0x0040, 0x16e: 0x2000, 0x16f: 0x0040,
	0x170: 0x2000, 0x171: 0x0040, 0x172: 0x2000, 0x173: 0x0040, 0x174: 0x2000, 0x175: 0x0040,
	0x176: 0x2000, 0x177: 0x0040, 0x178: 0x0040, 0x179: 0x2000, 0x17a: 0x0040, 0x17b: 0x2000,
	0x17c: 0x0040, 0x17d: 0x2000, 0x17e: 0x0040, 0x17f: 0x2000,
	// Block 0x6, offset 0x180
	0x180: 0x0040, 0x181: 0x2000, 0x182: 0x0040, 0x183: 0x2000, 0x184: 0x0040, 0x185: 0x2000,
	0x186: 0x0040, 0x187: 0x2000, 0x188: 0x0040, 0x189: 0x0040, 0x18a: 0x2000, 0x18b: 0x0040,
	0x18c: 0x2000, 0x18d: 0x0040, 0x18e: 0x2000, 0x18f: 0x0040, 0x190: 0x2000, 0x191: 0x0040,
	0x192: 0x2000, 0x193: 0x0040, 0x194: 0x2000, 0x195: 0x0040, 0x196: 0x2000, 0x197: 0x0040,
	0x198: 0x2000, 0x199: 0x0040, 0x19a: 0x2000, 0x19b: 0x0040, 0x19c: 0x2000, 0x19d: 0x0040,
	0x19e: 0x2000, 0x19f: 0x0040, 0x1a0: 0x2000, 0x1a1: 0x0040, 0x1a2: 0x2000, 0x1a3: 0x0040,
	0x1a4: 0x2000, 0x1a5: 0x0040, 0x1a6: 0x2000, 0x1a7: 0x0040, 0x1a8: 0x2000, 0x1a9: 0x0040,
	0x1aa: 0x2000, 0x1ab: 0x0040, 0x1ac: 0x2000, 0x1ad: 0x0040, 0x1ae: 0x2000, 0x1af: 0x0040,
	0x1b0: 0x2000, 0x1b1: 0x0040, 0x1b2: 0x2000, 0x1b3: 0x0040, 0x1b4: 0x2000, 0x1b5: 0x0040,
	0x1b6: 0x2000, 0x1b7: 0x0040, 0x1b8: 0x2000, 0x1b9: 0x2000, 0x1ba: 0x0040, 0x1bb: 0x2000,
	0x1bc: 0x0040, 0x1bd: 0x2000, 0x1be: 0x0040, 0x1bf: 0x0040,
	// Block 0x7, offset 0x1c0
	0x1c0: 0x0040, 0x1c1: 0x2000, 0x1c2: 0x2000, 0x1c3: 0x0040, 0x1c4: 0x2000, 0x1c5: 0x0040,
	0x1c6: 0x2000, 0x1c7: 0x2000, 0x1c8: 0x0040, 0x1c9: 0x2000, 0x1ca: 0x2000, 0x1cb: 0x2000,
	0x1cc: 0x0040, 0x1cd: 0x0040, 0x1ce: 0x2000, 0x1cf: 0x2000, 0x1d0: 0x2000, 0x1d1: 0x2000,
	0x1d2: 0x0040, 0x1d3: 0x2000, 0x1d4: 0x2000, 0x1d5: 0x0040, 0x1d6: 0x2000, 0x1d7: 0x2000,
	0x1d8: 0x2000, 0x1d9: 0x0040, 0x1da: 0x0040, 0x1db: 0x0040, 0x1dc: 0x2000, 0x1dd: 0x2000,
	0x1de: 0x0040, 0x1df: 0x2000, 0x1e0: 0x2000, 0x1e1: 0x0040, 0x1e2: 0x2000, 0x1e3: 0x0040,
	0x1e4: 0x2000, 0x1e5: 0x0040, 0x1e6: 0x2000, 0x1e7: 0x2000, 0x1e8: 0x0040, 0x1e9: 0x2000,
	0x1ea: 0x0040, 0x1eb: 0x0040, 0x1ec: 0x2000, 0x1ed: 0x0040, 0x1ee: 0x2000, 0x1ef: 0x2000,
	0x1f0: 0x0040, 0x1f1: 0x2000, 0x1f2: 0x2000, 0x1f3: 0x2000, 0x1f4: 0x0040, 0x1f5: 0x2000,
	0x1f6: 0x0040, 0x1f7: 0x2000, 0x1f8: 0x2000, 0x1f9: 0x0040, 0x1fa: 0x0040, 0x1fb: 0x0100,
	0x1fc: 0x2000, 0x1fd: 0x0040, 0x1fe: 0x0040, 0x1ff: 0x0040,
	// Block 0x8, offset 0x200
	0x200: 0x0100, 0x201: 0x0100, 0x202: 0x0100, 0x203: 0x0100, 0x204: 0x2000, 0x205: 0x2000,
	0x206: 0x0040, 0x207: 0x2000, 0x208: 0x2000, 0x209: 0x0040, 0x20a: 0x2000, 0x20b: 0x2000,
	0x20c: 0x0040, 0x20d: 0x2000, 0x20e: 0x0040, 0x20f: 0x2000, 0x210: 0x0040, 0x211: 0x2000,
	0x212: 0x0040, 0x213: 0x2000, 0x214: 0x0040, 0x215: 0x2000, 0x216: 0x0040, 0x217: 0x2000,
	0x218: 0x0040, 0x219: 0x2000, 0x21a: 0x0040, 0x21b: 0x2000, 0x21c: 0x0040, 0x21d: 0x0040,
	0x21e: 0x2000, 0x21f: 0x0040, 0x220: 0x2000, 0x221: 0x0040, 0x222: 0x2000, 0x223: 0x0040,
	0x224: 0x2000, 0x225: 0x0040, 0x226: 0x2000, 0x227: 0x0040, 0x228: 0x2000, 0x229: 0x0040,
	0x22a: 0x2000, 0x22b: 0x0040, 0x22c: 0x2000, 0x22d: 0x0040, 0x22e: 0x2000, 0x22f: 0x0040,
	0x230: 0x0040, 0x231: 0x2000, 0x232: 0x2000, 0x233: 0x0040, 0x234: 0x2000, 0x235: 0x0040,
	0x236: 0x2000, 0x237: 0x2000, 0x238: 0x2000, 0x239: 0x0040, 0x23a: 0x2000, 0x23b: 0x0040,
	0x23c: 0x2000, 0x23d: 0x0040, 0x23e: 0x2000, 0x23f: 0x0040,
	// Block 0x9, offset 0x240
	0x240: 0x2000, 0x241: 0x0040, 0x242: 0x2000, 0x243: 0x0040, 0x244: 0x2000, 0x245: 0x0040,
	0x246: 0x2000, 0x247: 0x0040, 0x248: 0x2000, 0x249: 0x0040, 0x24a: 0x2000, 0x24b: 0x0040,
	0x24c: 0x2000, 0x24d: 0x0040, 0x24e: 0x2000, 0x24f: 0x0040, 0x250: 0x2000, 0x251: 0x0040,
	0x252: 0x2000, 0x253: 0x0040, 0x254: 0x2000, 0x255: 0x0040, 0x256: 0x2000, 0x257: 0x0040,
	0x258: 0x2000, 0x259: 0x0040, 0x25a: 0x2000, 0x25b: 0x0040, 0x25c: 0x2000, 0x25d: 0x0040,
	0x25e: 0x2000, 0x25f: 0x0040, 0x260: 0x2000, 0x261: 0x0040, 0x262: 0x2000, 0x263: 0x0040,
	0x264: 0x2000, 0x265: 0x0040, 0x266: 0x2000, 0x267: 0x0040, 0x268: 0x2000, 0x269: 0x0040,
	0x26a: 0x2000, 0x26b: 0x0040, 0x26c: 0x2000, 0x26d: 0x0040, 0x26e: 0x2000, 0x26f: 0x0040,
	0x270: 0x2000, 0x271: 0x0040, 0x272: 0x2000, 0x273: 0x0040, 0x274: 0x0040, 0x275: 0x0040,
	0x276: 0x0040, 0x277: 0x0040, 0x278: 0x0040, 0x279: 0x0040, 0x27a: 0x2000, 0x27b: 0x2000,
	0x27c: 0x0040, 0x27d: 0x2000, 0x27e: 0x2000, 0x27f: 0x0040,
	// Block 0xa, offset 0x280
	0x280: 0x0040, 0x281: 0x2000, 0x282: 0x0040, 0x283: 0x2000, 0x284: 0x2000, 0x285: 0x2000,
	0x286: 0x2000, 0x287: 0x0040, 0x288: 0x2000, 0x289: 0x0040, 0x28a: 0x2000, 0x28b: 0x0040,
	0x28c: 0x2000, 0x28d: 0x0040, 0x28e: 0x2000, 0x28f: 0x0040, 0x290: 0x0040, 0x291: 0x0040,
	0x292: 0x0040, 0x293: 0x0040, 0x294: 0x0040, 0x295: 0x0040, 0x296: 0x0040, 0x297: 0x0040,
	0x298: 0x0040, 0x299: 0x0040, 0x29a: 0x0040, 0x29b: 0x0040, 0x29c: 0x0040, 0x29d: 0x0040,
	0x29e: 0x0040, 0x29f: 0x0040, 0x2a0: 0x0040, 0x2a1: 0x0040, 0x2a2: 0x0040, 0x2a3: 0x0040,
	0x2a4: 0x0040, 0x2a5: 0x0040, 0x2a6: 0x0040, 0x2a7: 0x0040, 0x2a8: 0x0040, 0x2a9: 0x0040,
	0x2aa: 0x0040, 0x2ab: 0x0040, 0x2ac: 0x0040, 0x2ad: 0x0040, 0x2ae: 0x0040, 0x2af: 0x0040,
	0x2b0: 0x0040, 0x2b1: 0x0040, 0x2b2: 0x0040, 0x2b3: 0x0040, 0x2b4: 0x0040, 0x2b5: 0x0040,
	0x2b6: 0x0040, 0x2b7: 0x0040, 0x2b8: 0x0040, 0x2b9: 0x0040, 0x2ba: 0x0040, 0x2bb: 0x0040,
	0x2bc: 0x0040, 0x2bd: 0x0040, 0x2be: 0x0040, 0x2bf: 0x0040,
	// Block 0xb, offset 0x2c0
	0x2c0: 0x0040, 0x2c1: 0x0040, 0x2c2: 0x0040, 0x2c3: 0x0040, 0x2c4: 0x0040, 0x2c5: 0x0040,
	0x2c6: 0x0040, 0x2c7: 0x0040, 0x2c8: 0x0040, 0x2c9: 0x0040, 0x2ca: 0x0040, 0x2cb: 0x0040,
	0x2cc: 0x0040, 0x2cd: 0x0040, 0x2ce: 0x0040, 0x2cf: 0x0040, 0x2d0: 0x0040, 0x2d1: 0x0040,
	0x2d2: 0x0040, 0x2d3: 0x0040, 0x2d4: 0x0100, 0x2d5: 0x0040, 0x2d6: 0x0040, 0x2d7: 0x0040,
	0x2d8: 0x0040, 0x2d9: 0x0040, 0x2da: 0x0040, 0x2db: 0x0040, 0x2dc: 0x0040, 0x2dd: 0x0040,
	0x2de: 0x0040, 0x2df: 0x0040, 0x2e0: 0x0040, 0x2e1: 0x0040, 0x2e2: 0x0040, 0x2e3: 0x0040,
	0x2e4: 0x0040, 0x2e5: 0x0040, 0x2e6: 0x0040, 0x2e7: 0x0040, 0x2e8: 0x0040, 0x2e9: 0x0040,
	0x2ea: 0x0040, 0x2eb: 0x0040, 0x2ec: 0x0040, 0x2ed: 0x0040, 0x2ee: 0x0040, 0x2ef: 0x0040,
	0x2f0: 0x0040, 0x2f1: 0x0040, 0x2f2: 0x0040, 0x2f3: 0x0040, 0x2f4: 0x0040, 0x2f5: 0x0040,
	0x2f6: 0x0040, 0x2f7: 0x0040, 0x2f8: 0x0040, 0x2f9: 0x0100, 0x2fa: 0x0100, 0x2fb: 0x0100,
	0x2fc: 0x0100, 0x2fd: 0x0100, 0x2fe: 0x0100, 0x2ff: 0x0100,
	// Block 0xc, offset 0x300
	0x300: 0x0040, 0x301: 0x0040,
	0x306: 0x0100, 0x307: 0x0100, 0x308: 0x0100, 0x309: 0x0100, 0x30a: 0x0100, 0x30b: 0x0100,
	0x30c: 0x0100, 0x30d: 0x0100, 0x30e: 0x0100, 0x30f: 0x0100, 0x310: 0x0100, 0x311: 0x0100,
	0x320: 0x0040, 0x321: 0x0040, 0x322: 0x0040, 0x323: 0x0040,
	0x324: 0x0040,
	0x32c: 0x0100, 0x32e: 0x0100,
	// Block 0xd, offset 0x340
	0x340: 0x0008, 0x341: 0x0008, 0x342: 0x0008, 0x343: 0x0008, 0x344: 0x0008, 0x345: 0x0008,
	0x346: 0x0008, 0x347: 0x0008, 0x348: 0x0008, 0x349: 0x0008, 0x34a: 0x0008, 0x34b: 0x0008,
	0x34c: 0x0008, 0x34d: 0x0008, 0x34e: 0x0008, 0x34f: 0x0008, 0x350: 0x0008, 0x351: 0x0008,
	0x352: 0x0008, 0x353: 0x0008, 0x354: 0x0008, 0x355: 0x0008, 0x356: 0x0008, 0x357: 0x0008,
	0x358: 0x0008, 0x359: 0x0008, 0x35a: 0x0008, 0x35b: 0x0008, 0x35c: 0x0008, 0x35d: 0x0008,
	0x35e: 0x0008, 0x35f: 0x0008, 0x360: 0x0008, 0x361: 0x0008, 0x362: 0x0008, 0x363: 0x0008,
	0x364: 0x0008, 0x365: 0x0008, 0x366: 0x0008, 0x367: 0x0008, 0x368: 0x0008, 0x369: 0x0008,
	0x36a: 0x0008, 0x36b: 0x0008, 0x36c: 0x0008, 0x36d: 0x0008, 0x36e: 0x0008, 0x36f: 0x0008,
	0x370: 0x0008, 0x371: 0x0008, 0x372: 0x0008, 0x373: 0x0008, 0x374: 0x0008, 0x375: 0x0008,
	0x376: 0x0008, 0x377: 0x0008, 0x378: 0x0008, 0x379: 0x0008, 0x37a: 0x0008, 0x37b: 0x0008,
	0x37c: 0x0008, 0x37d: 0x0008, 0x37e: 0x0008, 0x37f: 0x0008,
	// Block 0xe, offset 0x380
	0x380: 0x0008, 0x381: 0x0008, 0x382: 0x0008, 0x383: 0x0008, 0x384: 0x0008, 0x385: 0x0008,
	0x386: 0x0008, 0x387: 0x0008, 0x388: 0x0008, 0x389: 0x0008, 0x38a: 0x0008, 0x38b: 0x0008,
	0x38c: 0x0008, 0x38d: 0x0008, 0x38e: 0x0008, 0x38f: 0x0008, 0x390: 0x0008, 0x391: 0x0008,
	0x392: 0x0008, 0x393: 0x0008, 0x394: 0x0008, 0x395: 0x0008, 0x396: 0x0008, 0x397: 0x0008,
	0x398: 0x0008, 0x399: 0x0008, 0x39a: 0x0008, 0x39b: 0x0008, 0x39c: 0x0008, 0x39d: 0x0008,
	0x39e: 0x0008, 0x39f: 0x0008, 0x3a0: 0x0008, 0x3a1: 0x0008, 0x3a2: 0x0008, 0x3a3: 0x0008,
	0x3a4: 0x0008, 0x3a5: 0x0008, 0x3a6: 0x0008, 0x3a7: 0x0008, 0x3a8: 0x0008, 0x3a9: 0x0008,
	0x3aa: 0x0008, 0x3ab: 0x0008, 0x3ac: 0x0008, 0x3ad: 0x0008, 0x3ae: 0x0008, 0x3af: 0x0008,
	0x3b0: 0x2000, 0x3b1: 0x0040, 0x3b2: 0x2000, 0x3b3: 0x0040, 0x3b4: 0x0100,
	0x3b6: 0x2000, 0x3b7: 0x0040, 0x3ba: 0x0040, 0x3bb: 0x0040,
	0x3bc: 0x0040, 0x3bd: 0x0040, 0x3bf: 0x2000,
	// Block 0xf, offset 0x3c0
	0x3c6: 0x2000, 0x3c8: 0x2000, 0x3c9: 0x2000, 0x3ca: 0x2000,
	0x3cc: 0x2000, 0x3ce: 0x2000, 0x3cf: 0x2000, 0x3d0: 0x0040, 0x3d1: 0x2000,
	0x3d2: 0x2000, 0x3d3: 0x2000, 0x3d4: 0x2000, 0x3d5: 0x2000, 0x3d6: 0x2000, 0x3d7: 0x2000,
	0x3d8: 0x2000, 0x3d9: 0x2000, 0x3da: 0x2000, 0x3db: 0x2000, 0x3dc: 0x2000, 0x3dd: 0x2000,
	0x3de: 0x2000, 0x3df: 0x2000, 0x3e0: 0x2000, 0x3e1: 0x2000, 0x3e3: 0x2000,
	0x3e4: 0x2000, 0x3e5: 0x2000, 0x3e6: 0x2000, 0x3e7: 0x2000, 0x3e8: 0x2000, 0x3e9: 0x2000,
	0x3ea: 0x2000, 0x3eb: 0x2000, 0x3ec: 0x0040, 0x3ed: 0x0040, 0x3ee: 0x0040, 0x3ef: 0x0040,
	0x3f0: 0x0040, 0x3f1: 0x0040, 0x3f2: 0x0040, 0x3f3: 0x0040, 0x3f4: 0x0040, 0x3f5: 0x0040,
	0x3f6: 0x0040, 0x3f7: 0x0040, 0x3f8: 0x0040, 0x3f9: 0x0040, 0x3fa: 0x0040, 0x3fb: 0x0040,
	0x3fc: 0x0040, 0x3fd: 0x0040, 0x3fe: 0x0040, 0x3ff: 0x0040,
	// Block 0x10, offset 0x400
	0x400: 0x0040, 0x401: 0x0040, 0x402: 0x0040, 0x403: 0x0040, 0x404: 0x0040, 0x405: 0x0040,
	0x406: 0x0040, 0x407: 0x0040, 0x408: 0x0040, 0x409: 0x0040, 0x40a: 0x0040, 0x40b: 0x0040,
	0x40c: 0x0040, 0x40d: 0x0040, 0x40e: 0x0040, 0x40f: 0x2000, 0x410: 0x0040, 0x411: 0x0040,
	0x412: 0x2000, 0x413: 0x2000, 0x414: 0x2000, 0x415: 0x0040, 0x416: 0x0040, 0x417: 0x0040,
	0x418: 0x2000, 0x419: 0x0040, 0x41a: 0x2000, 0x41b: 0x0040, 0x41c: 0x2000, 0x41d: 0x0040,
	0x41e: 0x2000, 0x41f: 0x0040, 0x420: 0x2000, 0x421: 0x0040, 0x422: 0x2000, 0x423: 0x0040,
	0x424: 0x2000, 0x425: 0x0040, 0x426: 0x2000, 0x427: 0x0040, 0x428: 0x2000, 0x429: 0x0040,
	0x42a: 0x2000, 0x42b: 0x0040, 0x42c: 0x2000, 0x42d: 0x0040, 0x42e: 0x2000, 0x42f: 0x0040,
	0x430: 0x0040, 0x431: 0x0040, 0x432: 0x0040, 0x433: 0x0040, 0x434: 0x2000, 0x435: 0x0040,
	0x437: 0x2000, 0x438: 0x0040, 0x439: 0x2000, 0x43a: 0x2000, 0x43b: 0x0040,
	0x43c: 0x0040, 0x43d: 0x2000, 0x43e: 0x2000, 0x43f: 0x2000,
	// Block 0x11, offset 0x440
	0x440: 0x2000, 0x441: 0x2000, 0x442: 0x2000, 0x443: 0x2000, 0x444: 0x2000, 0x445: 0x2000,
	0x446: 0x2000, 0x447: 0x2000, 0x448: 0x2000, 0x449: 0x2000, 0x44a: 0x2000, 0x44b: 0x2000,
	0x44c: 0x2000, 0x44d: 0x2000, 0x44e: 0x2000, 0x44f: 0x2000, 0x450: 0x2000, 0x451: 0x2000,
	0x452: 0x2000, 0x453: 0x2000, 0x454: 0x2000, 0x455: 0x2000, 0x456: 0x2000, 0x457: 0x2000,
	0x458: 0x2000, 0x459: 0x2000, 0x45a: 0x2000, 0x45b: 0x2000, 0x45c: 0x2000, 0x45d: 0x2000,
	0x45e: 0x2000, 0x45f: 0x2000, 0x460: 0x2000, 0x461: 0x2000, 0x462: 0x2000, 0x463: 0x2000,
	0x464: 0x2000, 0x465: 0x2000, 0x466: 0x2000, 0x467: 0x2000, 0x468: 0x2000, 0x469: 0x2000,
	0x46a: 0x2000, 0x46b: 0x2000, 0x46c: 0x2000, 0x46d: 0x2000, 0x46e: 0x2000, 0x46f: 0x2000,
	0x470: 0x0040, 0x471: 0x0040, 0x472: 0x0040, 0x473: 0x0040, 0x474: 0x0040, 0x475: 0x0040,
	0x476: 0x0040, 0x477: 0x0040, 0x478: 0x0040, 0x479: 0x0040, 0x47a: 0x0040, 0x47b: 0x0040,
	0x47c: 0x0040, 0x47d: 0x0040, 0x47e: 0x0040, 0x47f: 0x0040,
	// Block 0x12, offset 0x480
	0x480: 0x0040, 0x481: 0x0040, 0x482: 0x0040, 0x483: 0x0040, 0x484: 0x0040, 0x485: 0x0040,
	0x486: 0x0040, 0x487: 0x0040, 0x488: 0x0040, 0x489: 0x0040, 0x48a: 0x0040, 0x48b: 0x0040,
	0x48c: 0x0040, 0x48d: 0x0040, 0x48e: 0x0040, 0x48f: 0x0040, 0x490: 0x0040, 0x491: 0x0040,
	0x492: 0x0040, 0x493: 0x0040, 0x494: 0x0040, 0x495: 0x0040, 0x496: 0x0040, 0x497: 0x0040,
	0x498: 0x0040, 0x499: 0x0040, 0x49a: 0x0040, 0x49b: 0x0040, 0x49c: 0x0040, 0x49d: 0x0040,
	0x49e: 0x0040, 0x49f: 0x0040, 0x4a0: 0x2000, 0x4a1: 0x0040, 0x4a2: 0x2000, 0x4a3: 0x0040,
	0x4a4: 0x2000, 0x4a5: 0x0040, 0x4a6: 0x2000, 0x4a7: 0x0040, 0x4a8: 0x2000, 0x4a9: 0x0040,
	0x4aa: 0x2000, 0x4ab: 0x0040, 0x4ac: 0x2000, 0x4ad: 0x0040, 0x4ae: 0x2000, 0x4af: 0x0040,
	0x4b0: 0x2000, 0x4b1: 0x0040, 0x4b2: 0x2000, 0x4b3: 0x0040, 0x4b4: 0x2000, 0x4b5: 0x0040,
	0x4b6: 0x2000, 0x4b7: 0x0040, 0x4b8: 0x2000, 0x4b9: 0x0040, 0x4ba: 0x2000, 0x4bb: 0x0040,
	0x4bc: 0x2000, 0x4bd: 0x0040, 0x4be: 0x2000, 0x4bf: 0x0040,
	// Block 0x13, offset 0x4c0
	0x4c0: 0x2000, 0x4c1: 0x0040, 0x4c3: 0x0008, 0x4c4: 0x0008, 0x4c5: 0x0008,
	0x4c6: 0x0008, 0x4c7: 0x0008, 0x4c8: 0x0008, 0x4c9: 0x0008, 0x4ca: 0x2000, 0x4cb: 0x0040,
	0x4cc: 0x2000, 0x4cd: 0x0040, 0x4ce: 0x2000, 0x4cf: 0x0040, 0x4d0: 0x2000, 0x4d1: 0x0040,
	0x4d2: 0x2000, 0x4d3: 0x0040, 0x4d4: 0x2000, 0x4d5: 0x0040, 0x4d6: 0x2000, 0x4d7: 0x0040,
	0x4d8: 0x2000, 0x4d9: 0x0040, 0x4da: 0x2000, 0x4db: 0x0040, 0x4dc: 0x2000, 0x4dd: 0x0040,
	0x4de: 0x2000, 0x4df: 0x0040, 0x4e0: 0x2000, 0x4e1: 0x0040, 0x4e2: 0x2000, 0x4e3: 0x0040,
	0x4e4: 0x2000, 0x4e5: 0x0040, 0x4e6: 0x2000, 0x4e7: 0x0040, 0x4e8: 0x2000, 0x4e9: 0x0040,
	0x4ea: 0x2000, 0x4eb: 0x0040, 0x4ec: 0x2000, 0x4ed: 0x0040, 0x4ee: 0x2000, 0x4ef: 0x0040,
	0x4f0: 0x2000, 0x4f1: 0x0040, 0x4f2: 0x2000, 0x4f3: 0x0040, 0x4f4: 0x2000, 0x4f5: 0x0040,
	0x4f6: 0x2000, 0x4f7: 0x0040, 0x4f8: 0x2000, 0x4f9: 0x0040, 0x4fa: 0x2000, 0x4fb: 0x0040,
	0x4fc: 0x2000, 0x4fd: 0x0040, 0x4fe: 0x2000, 0x4ff: 0x0040,
	// Block 0x14, offset 0x500
	0x500: 0x2000, 0x501: 0x2000, 0x502: 0x0040, 0x503: 0x2000, 0x504: 0x0040, 0x505: 0x2000,
	0x506: 0x0040, 0x507: 0x2000, 0x508: 0x0040, 0x509: 0x2000, 0x50a: 0x0040, 0x50b: 0x2000,
	0x50c: 0x0040, 0x50d: 0x2000, 0x50e: 0x0040, 0x50f: 0x0040, 0x510: 0x2000, 0x511: 0x0040,
	0x512: 0x2000, 0x513: 0x0040, 0x514: 0x2000, 0x515: 0x0040, 0x516: 0x2000, 0x517: 0x0040,
	0x518: 0x2000, 0x519: 0x0040, 0x51a: 0x2000, 0x51b: 0x0040, 0x51c: 0x2000, 0x51d: 0x0040,
	0x51e: 0x2000, 0x51f: 0x0040, 0x520: 0x2000, 0x521: 0x0040, 0x522: 0x2000, 0x523: 0x0040,
	0x524: 0x2000, 0x525: 0x0040, 0x526: 0x2000, 0x527: 0x0040, 0x528: 0x2000, 0x529: 0x0040,
	0x52a: 0x2000, 0x52b: 0x0040, 0x52c: 0x2000, 0x52d: 0x0040, 0x52e: 0x2000, 0x52f: 0x0040,
	0x530: 0x2000, 0x531: 0x0040, 0x532: 0x2000, 0x533: 0x0040, 0x534: 0x2000, 0x535: 0x0040,
	0x536: 0x2000, 0x537: 0x0040, 0x538: 0x2000, 0x539: 0x0040, 0x53a: 0x2000, 0x53b: 0x0040,
	0x53c: 0x2000, 0x53d: 0x0040, 0x53e: 0x2000, 0x53f: 0x0040,
	// Block 0x15, offset 0x540
	0x540: 0x2000, 0x541: 0x0040, 0x542: 0x2000, 0x543: 0x0040, 0x544: 0x2000, 0x545: 0x0040,
	0x546: 0x2000, 0x547: 0x0040, 0x548: 0x2000, 0x549: 0x0040, 0x54a: 0x2000, 0x54b: 0x0040,
	0x54c: 0x2000, 0x54d: 0x0040, 0x54e: 0x2000, 0x54f: 0x0040, 0x550: 0x2000, 0x551: 0x0040,
	0x552: 0x2000, 0x553: 0x0040, 0x554: 0x2000, 0x555: 0x0040, 0x556: 0x2000, 0x557: 0x0040,
	0x558: 0x2000, 0x559: 0x0040, 0x55a: 0x2000, 0x55b: 0x0040, 0x55c: 0x2000, 0x55d: 0x0040,
	0x55e: 0x2000, 0x55f: 0x0040, 0x560: 0x2000, 0x561: 0x0040, 0x562: 0x2000, 0x563: 0x0040,
	0x564: 0x2000, 0x565: 0x0040, 0x566: 0x2000, 0x567: 0x0040, 0x568: 0x2000, 0x569: 0x0040,
	0x56a: 0x2000, 0x56b: 0x0040, 0x56c: 0x2000, 0x56d: 0x0040, 0x56e: 0x2000, 0x56f: 0x0040,
	0x571: 0x2000, 0x572: 0x2000, 0x573: 0x2000, 0x574: 0x2000, 0x575: 0x2000,
	0x576: 0x2000, 0x577: 0x2000, 0x578: 0x2000, 0x579: 0x2000, 0x57a: 0x2000, 0x57b: 0x2000,
	0x57c: 0x2000, 0x57d: 0x2000, 0x57e: 0x2000, 0x57f: 0x2000,
	// Block 0x16, offset 0x580
	0x580: 0x2000, 0x581: 0x2000, 0x582: 0x2000, 0x583: 0x2000, 0x584: 0x2000, 0x585: 0x2000,
	0x586: 0x2000, 0x587: 0x2000, 0x588: 0x2000, 0x589: 0x2000, 0x58a: 0x2000, 0x58b: 0x2000,
	0x58c: 0x2000, 0x58d: 0x2000, 0x58e: 0x2000, 0x58f: 0x2000, 0x590: 0x2000, 0x591: 0x2000,
	0x592: 0x2000, 0x593: 0x2000, 0x594: 0x2000, 0x595: 0x2000, 0x596: 0x2000,
	0x599: 0x0100, 0x59d: 0x0200,
	0x5a0: 0x0040, 0x5a1: 0x0040, 0x5a2: 0x0040, 0x5a3: 0x0040,
	0x5a4: 0x0040, 0x5a5: 0x0040, 0x5a6: 0x0040, 0x5a7: 0x0040, 0x5a8: 0x0040, 0x5a9: 0x0040,
	0x5aa: 0x0040, 0x5ab: 0x0040, 0x5ac: 0x0040, 0x5ad: 0x0040, 0x5ae: 0x0040, 0x5af: 0x0040,
	0x5b0: 0x0040, 0x5b1: 0x0040, 0x5b2: 0x0040, 0x5b3: 0x0040, 0x5b4: 0x0040, 0x5b5: 0x0040,
	0x5b6: 0x0040, 0x5b7: 0x0040, 0x5b8: 0x0040, 0x5b9: 0x0040, 0x5ba: 0x0040, 0x5bb: 0x0040,
	0x5bc: 0x0040, 0x5bd: 0x0040, 0x5be: 0x0040, 0x5bf: 0x0040,
	// Block 0x17, offset 0x5c0
	0x5c0: 0x0040, 0x5c1: 0x0040, 0x5c2: 0x0040, 0x5c3: 0x0040, 0x5c4: 0x0040, 0x5c5: 0x0040,
	0x5c6: 0x0040, 0x5c7: 0x0040, 0x5c8: 0x0040, 0x5c9: 0x0400,
	0x5d1: 0x0008,
	0x5d2: 0x0008, 0x5d3: 0x0008, 0x5d4: 0x0008, 0x5d5: 0x0008, 0x5d6: 0x0008, 0x5d7: 0x0008,
	0x5d8: 0x0008, 0x5d9: 0x0008, 0x5da: 0x0008, 0x5db: 0x0008, 0x5dc: 0x0008, 0x5dd: 0x0008,
	0x5de: 0x0008, 0x5df: 0x0008, 0x5e0: 0x0008, 0x5e1: 0x0008, 0x5e2: 0x0008, 0x5e3: 0x0008,
	0x5e4: 0x0008, 0x5e5: 0x0008, 0x5e6: 0x0008, 0x5e7: 0x0008, 0x5e8: 0x0008, 0x5e9: 0x0008,
	0x5ea: 0x0008, 0x5eb: 0x0008, 0x5ec: 0x0008, 0x5ed: 0x0008, 0x5ee: 0x0008, 0x5ef: 0x0008,
	0x5f0: 0x0008, 0x5f1: 0x0008, 0x5f2: 0x0008, 0x5f3: 0x0008, 0x5f4: 0x0008, 0x5f5: 0x0008,
	0x5f6: 0x0008, 0x5f7: 0x0008, 0x5f8: 0x0008, 0x5f9: 0x0008, 0x5fa: 0x0008, 0x5fb: 0x0008,
	0x5fc: 0x0008, 0x5fd: 0x0008, 0x5ff: 0x0008,
	// Block 0x18, offset 0x600
	0x601: 0x0008, 0x602: 0x0008, 0x604: 0x0008, 0x605: 0x0008,
	0x607: 0x0008,
	0x610: 0x0100, 0x611: 0x0100,
	0x612: 0x0100, 0x613: 0x0100, 0x614: 0x0100, 0x615: 0x0100, 0x616: 0x0100, 0x617: 0x0100,
	0x618: 0x0100, 0x619: 0x0100, 0x61a: 0x0100, 0x61b: 0x0100, 0x61c: 0x0100, 0x61d: 0x0100,
	0x61e: 0x0100, 0x61f: 0x0100, 0x620: 0x0100, 0x621: 0x0100, 0x622: 0x0100, 0x623: 0x0100,
	0x624: 0x0100, 0x625: 0x0100, 0x626: 0x0100, 0x627: 0x0100, 0x628: 0x0100, 0x629: 0x0100,
	0x62a: 0x0100, 0x62f: 0x0100,
	0x630: 0x0100, 0x631: 0x0100, 0x632: 0x0100, 0x633: 0x0100,
	// Block 0x19, offset 0x640
	0x640: 0x0010, 0x641: 0x0010, 0x642: 0x0010, 0x643: 0x0010, 0x644: 0x0010, 0x645: 0x0010,
	0x64c: 0x0200, 0x64d: 0x0200, 0x650: 0x0008, 0x651: 0x0008,
	0x652: 0x0008, 0x653: 0x0008, 0x654: 0x0008, 0x655: 0x0008, 0x656: 0x0008, 0x657: 0x0008,
	0x658: 0x0008, 0x659: 0x0008, 0x65a: 0x0008, 0x65c: 0x0010, 0x65d: 0x0400,
	0x65e: 0x0400, 0x65f: 0x0400, 0x660: 0x0100, 0x661: 0x0100, 0x662: 0x0100, 0x663: 0x0100,
	0x664: 0x0100, 0x665: 0x0100, 0x666: 0x0100, 0x667: 0x0100, 0x668: 0x0100, 0x669: 0x0100,
	0x66a: 0x0100, 0x66b: 0x0100, 0x66c: 0x0100, 0x66d: 0x0100, 0x66e: 0x0100, 0x66f: 0x0100,
	0x670: 0x0100, 0x671: 0x0100, 0x672: 0x0100, 0x673: 0x0100, 0x674: 0x0100, 0x675: 0x0100,
	0x676: 0x0100, 0x677: 0x0100, 0x678: 0x0100, 0x679: 0x0100, 0x67a: 0x0100, 0x67b: 0x0100,
	0x67c: 0x0100, 0x67d: 0x0100, 0x67e: 0x0100, 0x67f: 0x0100,
	// Block 0x1a, offset 0x680
	0x680: 0x0100, 0x681: 0x0100, 0x682: 0x0100, 0x683: 0x0100, 0x684: 0x0100, 0x685: 0x0100,
	0x686: 0x0100, 0x687: 0x0100, 0x688: 0x0100, 0x689: 0x0100, 0x68a: 0x0100, 0x68b: 0x0008,
	0x68c: 0x0008, 0x68d: 0x0008, 0x68e: 0x0008, 0x68f: 0x0008, 0x690: 0x0008, 0x691: 0x0008,
	0x692: 0x0008, 0x693: 0x0008, 0x694: 0x0008, 0x695: 0x0008, 0x696: 0x0008, 0x697: 0x0008,
	0x698: 0x0008, 0x699: 0x0008, 0x69a: 0x0008, 0x69b: 0x0008, 0x69c: 0x0008, 0x69d: 0x0008,
	0x69e: 0x0008, 0x69f: 0x0008, 0x6a0: 0x0080, 0x6a1: 0x0080, 0x6a2: 0x0080, 0x6a3: 0x0080,
	0x6a4: 0x0080, 0x6a5: 0x0080, 0x6a6: 0x0080, 0x6a7: 0x0080, 0x6a8: 0x0080, 0x6a9: 0x0080,
	0x6ab: 0x0080, 0x6ac: 0x0080, 0x6ae: 0x0100, 0x6af: 0x0100,
	0x6b0: 0x0008, 0x6b1: 0x0100, 0x6b2: 0x0100, 0x6b3: 0x0100, 0x6b4: 0x0100, 0x6b5: 0x0100,
	0x6b6: 0x0100, 0x6b7: 0x0100, 0x6b8: 0x0100, 0x6b9: 0x0100, 0x6ba: 0x0100, 0x6bb: 0x0100,
	0x6bc: 0x0100, 0x6bd: 0x0100, 0x6be: 0x0100, 0x6bf: 0x0100,
	// Block 0x1b, offset 0x6c0
	0x6c0: 0x0100, 0x6c1: 0x0100, 0x6c2: 0x0100, 0x6c3: 0x0100, 0x6c4: 0x0100, 0x6c5: 0x0100,
	0x6c6: 0x0100, 0x6c7: 0x0100, 0x6c8: 0x0100, 0x6c9: 0x0100, 0x6ca: 0x0100, 0x6cb: 0x0100,
	0x6cc: 0x0100, 0x6cd: 0x0100, 0x6ce: 0x0100, 0x6cf: 0x0100, 0x6d0: 0x0100, 0x6d1: 0x0100,
	0x6d2: 0x0100, 0x6d3: 0x0100, 0x6d4: 0x0100, 0x6d5: 0x0100, 0x6d6: 0x0100, 0x6d7: 0x0100,
	0x6d8: 0x0100, 0x6d9: 0x0100, 0x6da: 0x0100, 0x6db: 0x0100, 0x6dc: 0x0100, 0x6dd: 0x0100,
	0x6de: 0x0100, 0x6df: 0x0100, 0x6e0: 0x0100, 0x6e1: 0x0100, 0x6e2: 0x0100, 0x6e3: 0x0100,
	0x6e4: 0x0100, 0x6e5: 0x0100, 0x6e6: 0x0100, 0x6e7: 0x0100, 0x6e8: 0x0100, 0x6e9: 0x0100,
	0x6ea: 0x0100, 0x6eb: 0x0100, 0x6ec: 0x0100, 0x6ed: 0x0100, 0x6ee: 0x0100, 0x6ef: 0x0100,
	0x6f0: 0x0100, 0x6f1: 0x0100, 0x6f2: 0x0100, 0x6f3: 0x0100, 0x6f4: 0x0100, 0x6f5: 0x0100,
	0x6f6: 0x0100, 0x6f7: 0x0100, 0x6f8: 0x0100, 0x6f9: 0x0100, 0x6fa: 0x0100, 0x6fb: 0x0100,
	0x6fc: 0x0100, 0x6fd: 0x0100, 0x6fe: 0x0100, 0x6ff: 0x0100,
	// Block 0x1c, offset 0x700
	0x700: 0x0100, 0x701: 0x0100, 0x702: 0x0100, 0x703: 0x0100, 0x704: 0x0100, 0x705: 0x0100,
	0x706: 0x0100, 0x707: 0x0100, 0x708: 0x0100, 0x709: 0x0100, 0x70a: 0x0100, 0x70b: 0x0100,
	0x70c: 0x0100, 0x70d: 0x0100, 0x70e: 0x0100, 0x70f: 0x0100, 0x710: 0x0100, 0x711: 0x0100,
	0x712: 0x0100, 0x713: 0x0100, 0x714: 0x0400, 0x715: 0x0100, 0x716: 0x0008, 0x717: 0x0008,
	0x718: 0x0008, 0x719: 0x0008, 0x71a: 0x0008, 0x71b: 0x0008, 0x71c: 0x0008, 0x71d: 0x0010,
	0x71f: 0x0008, 0x720: 0x0008, 0x721: 0x0008, 0x722: 0x0008, 0x723: 0x0008,
	0x724: 0x0008, 0x725: 0x0100, 0x726: 0x0100, 0x727: 0x0008, 0x728: 0x0008,
	0x72a: 0x0008, 0x72b: 0x0008, 0x72c: 0x0008, 0x72d: 0x0008, 0x72e: 0x0100, 0x72f: 0x0100,
	0x730: 0x0080, 0x731: 0x0080, 0x732: 0x0080, 0x733: 0x0080, 0x734: 0x0080, 0x735: 0x0080,
	0x736: 0x0080, 0x737: 0x0080, 0x738: 0x0080, 0x739: 0x0080, 0x73a: 0x0100, 0x73b: 0x0100,
	0x73c: 0x0100, 0x73f: 0x0100,
	// Block 0x1d, offset 0x740
	0x740: 0x0400, 0x741: 0x0400, 0x742: 0x0400,
	0x74f: 0x0010, 0x750: 0x0100, 0x751: 0x0008,
	0x752: 0x0100, 0x753: 0x0100, 0x754: 0x0100, 0x755: 0x0100, 0x756: 0x0100, 0x757: 0x0100,
	0x758: 0x0100, 0x759: 0x0100, 0x75a: 0x0100, 0x75b: 0x0100, 0x75c: 0x0100, 0x75d: 0x0100,
	0x75e: 0x0100, 0x75f: 0x0100, 0x760: 0x0100, 0x761: 0x0100, 0x762: 0x0100, 0x763: 0x0100,
	0x764: 0x0100, 0x765: 0x0100, 0x766: 0x0100, 0x767: 0x0100, 0x768: 0x0100, 0x769: 0x0100,
	0x76a: 0x0100, 0x76b: 0x0100, 0x76c: 0x0100, 0x76d: 0x0100, 0x76e: 0x0100, 0x76f: 0x0100,
	0x770: 0x0008, 0x771: 0x0008, 0x772: 0x0008, 0x773: 0x0008, 0x774: 0x0008, 0x775: 0x0008,
	0x776: 0x0008, 0x777: 0x0008, 0x778: 0x0008, 0x779: 0x0008, 0x77a: 0x0008, 0x77b: 0x0008,
	0x77c: 0x0008, 0x77d: 0x0008, 0x77e: 0x0008, 0x77f: 0x0008,
	// Block 0x1e, offset 0x780
	0x780: 0x0008, 0x781: 0x0008, 0x782: 0x0008, 0x783: 0x0008, 0x784: 0x0008, 0x785: 0x0008,
	0x786: 0x0008, 0x787: 0x0008, 0x788: 0x0008, 0x789: 0x0008, 0x78a: 0x0008,
	0x78d: 0x0100, 0x78e: 0x0100, 0x78f: 0x0100, 0x790: 0x0100, 0x791: 0x0100,
	0x792: 0x0100, 0x793: 0x0100, 0x794: 0x0100, 0x795: 0x0100, 0x796: 0x0100, 0x797: 0x0100,
	0x798: 0x0100, 0x799: 0x0100, 0x79a: 0x0100, 0x79b: 0x0100, 0x79c: 0x0100, 0x79d: 0x0100,
	0x79e: 0x0100, 0x79f: 0x0100, 0x7a0: 0x0100, 0x7a1: 0x0100, 0x7a2: 0x0100, 0x7a3: 0x0100,
	0x7a4: 0x0100, 0x7a5: 0x0100, 0x7a6: 0x0100, 0x7a7: 0x0100, 0x7a8: 0x0100, 0x7a9: 0x0100,
	0x7aa: 0x0100, 0x7ab: 0x0100, 0x7ac: 0x0100, 0x7ad: 0x0100, 0x7ae: 0x0100, 0x7af: 0x0100,
	0x7b0: 0x0100, 0x7b1: 0x0100, 0x7b2: 0x0100, 0x7b3: 0x0100, 0x7b4: 0x0100, 0x7b5: 0x0100,
	0x7b6: 0x0100, 0x7b7: 0x0100, 0x7b8: 0x0100, 0x7b9: 0x0100, 0x7ba: 0x0100, 0x7bb: 0x0100,
	0x7bc: 0x0100, 0x7bd: 0x0100, 0x7be: 0x0100, 0x7bf: 0x0100,
	// Block 0x1f, offset 0x7c0
	0x7c0: 0x0100, 0x7c1: 0x0100, 0x7c2: 0x0100, 0x7c3: 0x0100, 0x7c4: 0x0100, 0x7c5: 0x0100,
	0x7c6: 0x0100, 0x7c7: 0x0100, 0x7c8: 0x0100, 0x7c9: 0x0100, 0x7ca: 0x0100, 0x7cb: 0x0100,
	0x7cc: 0x0100, 0x7cd: 0x0100, 0x7ce: 0x0100, 0x7cf: 0x0100, 0x7d0: 0x0100, 0x7d1: 0x0100,
	0x7d2: 0x0100, 0x7d3: 0x0100, 0x7d4: 0x0100, 0x7d5: 0x0100, 0x7d6: 0x0100, 0x7d7: 0x0100,
	0x7d8: 0x0100, 0x7d9: 0x0100, 0x7da: 0x0100, 0x7db: 0x0100, 0x7dc: 0x0100, 0x7dd: 0x0100,
	0x7de: 0x0100, 0x7df: 0x0100, 0x7e0: 0x0100, 0x7e1: 0x0100, 0x7e2: 0x0100, 0x7e3: 0x0100,
	0x7e4: 0x0100, 0x7e5: 0x0100, 0x7e6: 0x0008, 0x7e7: 0x0008, 0x7e8: 0x0008, 0x7e9: 0x0008,
	0x7ea: 0x0008, 0x7eb: 0x0008, 0x7ec: 0x0008, 0x7ed: 0x0008, 0x7ee: 0x0008, 0x7ef: 0x0008,
	0x7f0: 0x0008, 0x7f1: 0x0100,
	// Block 0x20, offset 0x800
	0x800: 0x0080, 0x801: 0x0080, 0x802: 0x0080, 0x803: 0x0080, 0x804: 0x0080, 0x805: 0x0080,
	0x806: 0x0080, 0x807: 0x0080, 0x808: 0x0080, 0x809: 0x0080, 0x80a: 0x0100, 0x80b: 0x0100,
	0x80c: 0x0100, 0x80d: 0x0100, 0x80e: 0x0100, 0x80f: 0x0100, 0x810: 0x0100, 0x811: 0x0100,
	0x812: 0x0100, 0x813: 0x0100, 0x814: 0x0100, 0x815: 0x0100, 0x816: 0x0100, 0x817: 0x0100,
	0x818: 0x0100, 0x819: 0x0100, 0x81a: 0x0100, 0x81b: 0x0100, 0x81c: 0x0100, 0x81d: 0x0100,
	0x81e: 0x0100, 0x81f: 0x0100, 0x820: 0x0100, 0x821: 0x0100, 0x822: 0x0100, 0x823: 0x0100,
	0x824: 0x0100, 0x825: 0x0100, 0x826: 0x0100, 0x827: 0x0100, 0x828: 0x0100, 0x829: 0x0100,
	0x82a: 0x0100, 0x82b: 0x0008, 0x82c: 0x0008, 0x82d: 0x0008, 0x82e: 0x0008, 0x82f: 0x0008,
	0x830: 0x0008, 0x831: 0x0008, 0x832: 0x0008, 0x833: 0x0008, 0x834: 0x0100, 0x835: 0x0100,
	0x838: 0x0200, 0x839: 0x0400, 0x83a: 0x0100,
	0x83d: 0x0008,
	// Block 0x21, offset 0x840
	0x840: 0x0100, 0x841: 0x0100, 0x842: 0x0100, 0x843: 0x0100, 0x844: 0x0100, 0x845: 0x0100,
	0x846: 0x0100, 0x847: 0x0100, 0x848: 0x0100, 0x849: 0x0100, 0x84a: 0x0100, 0x84b: 0x0100,
	0x84c: 0x0100, 0x84d: 0x0100, 0x84e: 0x0100, 0x84f: 0x0100, 0x850: 0x0100, 0x851: 0x0100,
	0x852: 0x0100, 0x853: 0x0100, 0x854: 0x0100, 0x855: 0x0100, 0x856: 0x0008, 0x857: 0x0008,
	0x858: 0x0008, 0x859: 0x0008, 0x85a: 0x0100, 0x85b: 0x0008, 0x85c: 0x0008, 0x85d: 0x0008,
	0x85e: 0x0008, 0x85f: 0x0008, 0x860: 0x0008, 0x861: 0x0008, 0x862: 0x0008, 0x863: 0x0008,
	0x864: 0x0100, 0x865: 0x0008, 0x866: 0x0008, 0x867: 0x0008, 0x868: 0x0100, 0x869: 0x0008,
	0x86a: 0x0008, 0x86b: 0x0008, 0x86c: 0x0008, 0x86d: 0x0008,
	0x877: 0x0400, 0x879: 0x0400,
	0x87d: 0x0400, 0x87e: 0x0400,
	// Block 0x22, offset 0x880
	0x880: 0x0100, 0x881: 0x0100, 0x882: 0x0100, 0x883: 0x0100, 0x884: 0x0100, 0x885: 0x0100,
	0x886: 0x0100, 0x887: 0x0100, 0x888: 0x0100, 0x889: 0x0100, 0x88a: 0x0100, 0x88b: 0x0100,
	0x88c: 0x0100, 0x88d: 0x0100, 0x88e: 0x0100, 0x88f: 0x0100, 0x890: 0x0100, 0x891: 0x0100,
	0x892: 0x0100, 0x893: 0x0100, 0x894: 0x0100, 0x895: 0x0100, 0x896: 0x0100, 0x897: 0x0100,
	0x898: 0x0100, 0x899: 0x0008, 0x89a: 0x0008, 0x89b: 0x0008,
	0x8a0: 0x0100, 0x8a1: 0x0100, 0x8a2: 0x0100, 0x8a3: 0x0100,
	0x8a4: 0x0100, 0x8a5: 0x0100, 0x8a6: 0x0100, 0x8a7: 0x0100, 0x8a8: 0x0100, 0x8a9: 0x0100,
	0x8aa: 0x0100,
	0x8b0: 0x0100, 0x8b1: 0x0100, 0x8b2: 0x0100, 0x8b3: 0x0100, 0x8b4: 0x0100, 0x8b5: 0x0100,
	0x8b6: 0x0100, 0x8b7: 0x0100, 0x8b8: 0x0100, 0x8b9: 0x0100, 0x8ba: 0x0100, 0x8bb: 0x0100,
	0x8bc: 0x0100, 0x8bd: 0x0100, 0x8be: 0x0100, 0x8bf: 0x0100,
	// Block 0x23, offset 0x8c0
	0x8c0: 0x0100, 0x8c1: 0x0100, 0x8c2: 0x0100, 0x8c3: 0x0100, 0x8c4: 0x0100, 0x8c5: 0x0100,
	0x8c6: 0x0100, 0x8c7: 0x0100, 0x8c9: 0x0100, 0x8ca: 0x0100, 0x8cb: 0x0100,
	0x8cc: 0x0100, 0x8cd: 0x0100, 0x8ce: 0x0100, 0x8d0: 0x0010, 0x8d1: 0x0010,
	0x8d8: 0x0008, 0x8d9: 0x0008, 0x8da: 0x0008, 0x8db: 0x0008, 0x8dc: 0x0008, 0x8dd: 0x0008,
	0x8de: 0x0008, 0x8df: 0x0008, 0x8e0: 0x0100, 0x8e1: 0x0100, 0x8e2: 0x0100, 0x8e3: 0x0100,
	0x8e4: 0x0100, 0x8e5: 0x0100, 0x8e6: 0x0100, 0x8e7: 0x0100, 0x8e8: 0x0100, 0x8e9: 0x0100,
	0x8ea: 0x0100, 0x8eb: 0x0100, 0x8ec: 0x0100, 0x8ed: 0x0100, 0x8ee: 0x0100, 0x8ef: 0x0100,
	0x8f0: 0x0100, 0x8f1: 0x0100, 0x8f2: 0x0100, 0x8f3: 0x0100, 0x8f4: 0x0100, 0x8f5: 0x0100,
	0x8f6: 0x0100, 0x8f7: 0x0100, 0x8f8: 0x0100, 0x8f9: 0x0100, 0x8fa: 0x0100, 0x8fb: 0x0100,
	0x8fc: 0x0100, 0x8fd: 0x0100, 0x8fe: 0x0100, 0x8ff: 0x0100,
	// Block 0x24, offset 0x900
	0x900: 0x0100, 0x901: 0x0100, 0x902: 0x0100, 0x903: 0x0100, 0x904: 0x0100, 0x905: 0x0100,
	0x906: 0x0100, 0x907: 0x0100, 0x908: 0x0100, 0x909: 0x0100, 0x90a: 0x0008, 0x90b: 0x0008,
	0x90c: 0x0008, 0x90d: 0x0008, 0x90e: 0x0008, 0x90f: 0x0008, 0x910: 0x0008, 0x911: 0x0008,
	0x912: 0x0008, 0x913: 0x0008, 0x914: 0x0008, 0x915: 0x0008, 0x916: 0x0008, 0x917: 0x0008,
	0x918: 0x0008, 0x919: 0x0008, 0x91a: 0x0008, 0x91b: 0x0008, 0x91c: 0x0008, 0x91d: 0x0008,
	0x91e: 0x0008, 0x91f: 0x0008, 0x920: 0x0008, 0x921: 0x0008, 0x922: 0x0010, 0x923: 0x0008,
	0x924: 0x0008, 0x925: 0x0008, 0x926: 0x0008, 0x927: 0x0008, 0x928: 0x0008, 0x929: 0x0008,
	0x92a: 0x0008, 0x92b: 0x0008, 0x92c: 0x0008, 0x92d: 0x0008, 0x92e: 0x0008, 0x92f: 0x0008,
	0x930: 0x0008, 0x931: 0x0008, 0x932: 0x0008, 0x933: 0x0008, 0x934: 0x0008, 0x935: 0x0008,
	0x936: 0x0008, 0x937: 0x0008, 0x938: 0x0008, 0x939: 0x0008, 0x93a: 0x0008, 0x93b: 0x0008,
	0x93c: 0x0008, 0x93d: 0x0008, 0x93e: 0x0008, 0x93f: 0x0008,
	// Block 0x25, offset 0x940
	0x940: 0x0008, 0x941: 0x0008, 0x942: 0x0008, 0x943: 0x0008, 0x944: 0x0100, 0x945: 0x0100,
	0x946: 0x0100, 0x947: 0x0100, 0x948: 0x0100, 0x949: 0x0100, 0x94a: 0x0100, 0x94b: 0x0100,
	0x94c: 0x0100, 0x94d: 0x0100, 0x94e: 0x0100, 0x94f: 0x0100, 0x950: 0x0100, 0x951: 0x0100,
	0x952: 0x0100, 0x953: 0x0100, 0x954: 0x0100, 0x955: 0x0100, 0x956: 0x0100, 0x957: 0x0100,
	0x958: 0x0100, 0x959: 0x0100, 0x95a: 0x0100, 0x95b: 0x0100, 0x95c: 0x0100, 0x95d: 0x0100,
	0x95e: 0x0100, 0x95f: 0x0100, 0x960: 0x0100, 0x961: 0x0100, 0x962: 0x0100, 0x963: 0x0100,
	0x964: 0x0100, 0x965: 0x0100, 0x966: 0x0100, 0x967: 0x0100, 0x968: 0x0100, 0x969: 0x0100,
	0x96a: 0x0100, 0x96b: 0x0100, 0x96c: 0x0100, 0x96d: 0x0100, 0x96e: 0x0100, 0x96f: 0x0100,
	0x970: 0x0100, 0x971: 0x0100, 0x972: 0x0100, 0x973: 0x0100, 0x974: 0x0100, 0x975: 0x0100,
	0x976: 0x0100, 0x977: 0x0100, 0x978: 0x0100, 0x979: 0x0100, 0x97a: 0x0008, 0x97b: 0x0008,
	0x97c: 0x0008, 0x97d: 0x0100, 0x97e: 0x0008, 0x97f: 0x0008,
	// Block 0x26, offset 0x980
	0x980: 0x0008, 0x981: 0x0008, 0x982: 0x0008, 0x983: 0x0008, 0x984: 0x0008, 0x985: 0x0008,
	0x986: 0x0008, 0x987: 0x0008, 0x988: 0x0008, 0x989: 0x0008, 0x98a: 0x0008, 0x98b: 0x0008,
	0x98c: 0x0008, 0x98d: 0x0008, 0x98e: 0x0008, 0x98f: 0x0008, 0x990: 0x0100, 0x991: 0x0008,
	0x992: 0x0008, 0x993: 0x0008, 0x994: 0x0008, 0x995: 0x0008, 0x996: 0x0008, 0x997: 0x0008,
	0x998: 0x0100, 0x999: 0x0100, 0x99a: 0x0100, 0x99b: 0x0100, 0x99c: 0x0100, 0x99d: 0x0100,
	0x99e: 0x0100, 0x99f: 0x0100, 0x9a0: 0x0100, 0x9a1: 0x0100, 0x9a2: 0x0008, 0x9a3: 0x0008,
	0x9a4: 0x0400, 0x9a5: 0x0400, 0x9a6: 0x0080, 0x9a7: 0x0080, 0x9a8: 0x0080, 0x9a9: 0x0080,
	0x9aa: 0x0080, 0x9ab: 0x0080, 0x9ac: 0x0080, 0x9ad: 0x0080, 0x9ae: 0x0080, 0x9af: 0x0080,
	0x9b1: 0x0100, 0x9b2: 0x0100, 0x9b3: 0x0100, 0x9b4: 0x0100, 0x9b5: 0x0100,
	0x9b6: 0x0100, 0x9b7: 0x0100, 0x9b8: 0x0100, 0x9b9: 0x0100, 0x9ba: 0x0100, 0x9bb: 0x0100,
	0x9bc: 0x0100, 0x9bd: 0x0100, 0x9be: 0x0100, 0x9bf: 0x0100,
	// Block 0x27, offset 0x9c0
	0x9c0: 0x0100, 0x9c1: 0x0008, 0x9c2: 0x0008, 0x9c3: 0x0008, 0x9c5: 0x0100,
	0x9c6: 0x0100, 0x9c7: 0x0100, 0x9c8: 0x0100, 0x9c9: 0x0100, 0x9ca: 0x0100, 0x9cb: 0x0100,
	0x9cc: 0x0100, 0x9cf: 0x0100, 0x9d0: 0x0100,
	0x9d3: 0x0100, 0x9d4: 0x0100, 0x9d5: 0x0100, 0x9d6: 0x0100, 0x9d7: 0x0100,
	0x9d8: 0x0100, 0x9d9: 0x0100, 0x9da: 0x0100, 0x9db: 0x0100, 0x9dc: 0x0100, 0x9dd: 0x0100,
	0x9de: 0x0100, 0x9df: 0x0100, 0x9e0: 0x0100, 0x9e1: 0x0100, 0x9e2: 0x0100, 0x9e3: 0x0100,
	0x9e4: 0x0100, 0x9e5: 0x0100, 0x9e6: 0x0100, 0x9e7: 0x0100, 0x9e8: 0x0100,
	0x9ea: 0x0100, 0x9eb: 0x0100, 0x9ec: 0x0100, 0x9ed: 0x0100, 0x9ee: 0x0100, 0x9ef: 0x0100,
	0x9f0: 0x0100, 0x9f2: 0x0100,
	0x9f6: 0x0100, 0x9f7: 0x0100, 0x9f8: 0x0100, 0x9f9: 0x0100,
	0x9fc: 0x0008, 0x9fd: 0x0100, 0x9fe: 0x0008, 0x9ff: 0x0008,
	// Block 0x28, offset 0xa00
	0xa00: 0x0008, 0xa01: 0x0008, 0xa02: 0x0008, 0xa03: 0x0008, 0xa04: 0x0008,
	0xa07: 0x0008, 0xa08: 0x0008, 0xa0b: 0x0008,
	0xa0c: 0x0008, 0xa0d: 0x0008, 0xa0e: 0x0100,
	0xa17: 0x0008,
	0xa1c: 0x0100, 0xa1d: 0x0100,
	0xa1f: 0x0100, 0xa20: 0x0100, 0xa21: 0x0100, 0xa22: 0x0008, 0xa23: 0x0008,
	0xa26: 0x0080, 0xa27: 0x0080, 0xa28: 0x0080, 0xa29: 0x0080,
	0xa2a: 0x0080, 0xa2b: 0x0080, 0xa2c: 0x0080, 0xa2d: 0x0080, 0xa2e: 0x0080, 0xa2f: 0x0080,
	0xa30: 0x0100, 0xa31: 0x0100,
	0xa3c: 0x0100, 0xa3e: 0x0008,
	// Block 0x29, offset 0xa40
	0xa41: 0x0008, 0xa42: 0x0008, 0xa43: 0x0008, 0xa45: 0x0100,
	0xa46: 0x0100, 0xa47: 0x0100, 0xa48: 0x0100, 0xa49: 0x0100, 0xa4a: 0x0100,
	0xa4f: 0x0100, 0xa50: 0x0100,
	0xa53: 0x0100, 0xa54: 0x0100, 0xa55: 0x0100, 0xa56: 0x0100, 0xa57: 0x0100,
	0xa58: 0x0100, 0xa59: 0x0100, 0xa5a: 0x0100, 0xa5b: 0x0100, 0xa5c: 0x0100, 0xa5d: 0x0100,
	0xa5e: 0x0100, 0xa5f: 0x0100, 0xa60: 0x0100, 0xa61: 0x0100, 0xa62: 0x0100, 0xa63: 0x0100,
	0xa64: 0x0100, 0xa65: 0x0100, 0xa66: 0x0100, 0xa67: 0x0100, 0xa68: 0x0100,
	0xa6a: 0x0100, 0xa6b: 0x0100, 0xa6c: 0x0100, 0xa6d: 0x0100, 0xa6e: 0x0100, 0xa6f: 0x0100,
	0xa70: 0x0100, 0xa72: 0x0100, 0xa73: 0x0100, 0xa75: 0x0100,
	0xa76: 0x0100, 0xa78: 0x0100, 0xa79: 0x0100,
	0xa7c: 0x0008, 0xa7e: 0x0008, 0xa7f: 0x0008,
	// Block 0x2a, offset 0xa80
	0xa80: 0x0008, 0xa81: 0x0008, 0xa82: 0x0008,
	0xa87: 0x0008, 0xa88: 0x0008, 0xa8b: 0x0008,
	0xa8c: 0x0008, 0xa8d: 0x0008, 0xa91: 0x0008,
	0xa99: 0x0100, 0xa9a: 0x0100, 0xa9b: 0x0100, 0xa9c: 0x0100,
	0xa9e: 0x0100,
	0xaa6: 0x0080, 0xaa7: 0x0080, 0xaa8: 0x0080, 0xaa9: 0x0080,
	0xaaa: 0x0080, 0xaab: 0x0080, 0xaac: 0x0080, 0xaad: 0x0080, 0xaae: 0x0080, 0xaaf: 0x0080,
	0xab0: 0x0008, 0xab1: 0x0008, 0xab2: 0x0100, 0xab3: 0x0100, 0xab4: 0x0100, 0xab5: 0x0008,
	// Block 0x2b, offset 0xac0
	0xac1: 0x0008, 0xac2: 0x0008, 0xac3: 0x0008, 0xac5: 0x0100,
	0xac6: 0x0100, 0xac7: 0x0100, 0xac8: 0x0100, 0xac9: 0x0100, 0xaca: 0x0100, 0xacb: 0x0100,
	0xacc: 0x0100, 0xacd: 0x0100, 0xacf: 0x0100, 0xad0: 0x0100, 0xad1: 0x0100,
	0xad3: 0x0100, 0xad4: 0x0100, 0xad5: 0x0100, 0xad6: 0x0100, 0xad7: 0x0100,
	0xad8: 0x0100, 0xad9: 0x0100, 0xada: 0x0100, 0xadb: 0x0100, 0xadc: 0x0100, 0xadd: 0x0100,
	0xade: 0x0100, 0xadf: 0x0100, 0xae0: 0x0100, 0xae1: 0x0100, 0xae2: 0x0100, 0xae3: 0x0100,
	0xae4: 0x0100, 0xae5: 0x0100, 0xae6: 0x0100, 0xae7: 0x0100, 0xae8: 0x0100,
	0xaea: 0x0100, 0xaeb: 0x0100, 0xaec: 0x0100, 0xaed: 0x0100, 0xaee: 0x0100, 0xaef: 0x0100,
	0xaf0: 0x0100, 0xaf2: 0x0100, 0xaf3: 0x0100, 0xaf5: 0x0100,
	0xaf6: 0x0100, 0xaf7: 0x0100, 0xaf8: 0x0100, 0xaf9: 0x0100,
	0xafc: 0x0008, 0xafd: 0x0100, 0xafe: 0x0008, 0xaff: 0x0008,
	// Block 0x2c, offset 0xb00
	0xb00: 0x0008, 0xb01: 0x0008, 0xb02: 0x0008, 0xb03: 0x0008, 0xb04: 0x0008, 0xb05: 0x0008,
	0xb07: 0x0008, 0xb08: 0x0008, 0xb09: 0x0008, 0xb0b: 0x0008,
	0xb0c: 0x0008, 0xb0d: 0x0008, 0xb10: 0x0100,
	0xb20: 0x0100, 0xb21: 0x0100, 0xb22: 0x0008, 0xb23: 0x0008,
	0xb26: 0x0080, 0xb27: 0x0080, 0xb28: 0x0080, 0xb29: 0x0080,
	0xb2a: 0x0080, 0xb2b: 0x0080, 0xb2c: 0x0080, 0xb2d: 0x0080, 0xb2e: 0x0080, 0xb2f: 0x0080,
	0xb39: 0x0100, 0xb3a: 0x0008, 0xb3b: 0x0008,
	0xb3c: 0x0008, 0xb3d: 0x0008, 0xb3e: 0x0008, 0xb3f: 0x0008,
	// Block 0x2d, offset 0xb40
	0xb41: 0x0008, 0xb42: 0x0008, 0xb43: 0x0008, 0xb45: 0x0100,
	0xb46: 0x0100, 0xb47: 0x0100, 0xb48: 0x0100, 0xb49: 0x0100, 0xb4a: 0x0100, 0xb4b: 0x0100,
	0xb4c: 0x0100, 0xb4f: 0x0100, 0xb50: 0x0100,
	0xb53: 0x0100, 0xb54: 0x0100, 0xb55: 0x0100, 0xb56: 0x0100, 0xb57: 0x0100,
	0xb58: 0x0100, 0xb59: 0x0100, 0xb5a: 0x0100, 0xb5b: 0x0100, 0xb5c: 0x0100, 0xb5d: 0x0100,
	0xb5e: 0x0100, 0xb5f: 0x0100, 0xb60: 0x0100, 0xb61: 0x0100, 0xb62: 0x0100, 0xb63: 0x0100,
	0xb64: 0x0100, 0xb65: 0x0100, 0xb66: 0x0100, 0xb67: 0x0100, 0xb68: 0x0100,
	0xb6a: 0x0100, 0xb6b: 0x0100, 0xb6c: 0x0100, 0xb6d: 0x0100, 0xb6e: 0x0100, 0xb6f: 0x0100,
	0xb70: 0x0100, 0xb72: 0x0100, 0xb73: 0x0100, 0xb75: 0x0100,
	0xb76: 0x0100, 0xb77: 0x0100, 0xb78: 0x0100, 0xb79: 0x0100,
	0xb7c: 0x0008, 0xb7d: 0x0100, 0xb7e: 0x0008, 0xb7f: 0x0008,
	// Block 0x2e, offset 0xb80
	0xb80: 0x0008, 0xb81: 0x0008, 0xb82: 0x0008, 0xb83: 0x0008, 0xb84: 0x0008,
	0xb87: 0x0008, 0xb88: 0x0008, 0xb8b: 0x0008,
	0xb8c: 0x0008, 0xb8d: 0x0008,
	0xb95: 0x0008, 0xb96: 0x0008, 0xb97: 0x0008,
	0xb9c: 0x0100, 0xb9d: 0x0100,
	0xb9f: 0x0100, 0xba0: 0x0100, 0xba1: 0x0100, 0xba2: 0x0008, 0xba3: 0x0008,
	0xba6: 0x0080, 0xba7: 0x0080, 0xba8: 0x0080, 0xba9: 0x0080,
	0xbaa: 0x0080, 0xbab: 0x0080, 0xbac: 0x0080, 0xbad: 0x0080, 0xbae: 0x0080, 0xbaf: 0x0080,
	0xbb1: 0x0100,
	// Block 0x2f, offset 0xbc0
	0xbc2: 0x0008, 0xbc3: 0x0100, 0xbc5: 0x0100,
	0xbc6: 0x0100, 0xbc7: 0x0100, 0xbc8: 0x0100, 0xbc9: 0x0100, 0xbca: 0x0100,
	0xbce: 0x0100, 0xbcf: 0x0100, 0xbd0: 0x0100,
	0xbd2: 0x0100, 0xbd3: 0x0100, 0xbd4: 0x0100, 0xbd5: 0x0100,
	0xbd9: 0x0100, 0xbda: 0x0100, 0xbdc: 0x0100,
	0xbde: 0x0100, 0xbdf: 0x0100, 0xbe3: 0x0100,
	0xbe4: 0x0100, 0xbe8: 0x0100, 0xbe9: 0x0100,
	0xbea: 0x0100, 0xbee: 0x0100, 0xbef: 0x0100,
	0xbf0: 0x0100, 0xbf1: 0x0100, 0xbf2: 0x0100, 0xbf3: 0x0100, 0xbf4: 0x0100, 0xbf5: 0x0100,
	0xbf6: 0x0100, 0xbf7: 0x0100, 0xbf8: 0x0100, 0xbf9: 0x0100,
	0xbfe: 0x0008, 0xbff: 0x0008,
	// Block 0x30, offset 0xc00
	0xc00: 0x0008, 0xc01: 0x0008, 0xc02: 0x0008,
	0xc06: 0x0008, 0xc07: 0x0008, 0xc08: 0x0008, 0xc0a: 0x0008, 0xc0b: 0x0008,
	0xc0c: 0x0008, 0xc0d: 0x0008, 0xc10: 0x0100,
	0xc17: 0x0008,
	0xc26: 0x0080, 0xc27: 0x0080, 0xc28: 0x0080, 0xc29: 0x0080,
	0xc2a: 0x0080, 0xc2b: 0x0080, 0xc2c: 0x0080, 0xc2d: 0x0080, 0xc2e: 0x0080, 0xc2f: 0x0080,
	// Block 0x31, offset 0xc40
	0xc40: 0x0008, 0xc41: 0x0008, 0xc42: 0x0008, 0xc43: 0x0008, 0xc44: 0x0008, 0xc45: 0x0100,
	0xc46: 0x0100, 0xc47: 0x0100, 0xc48: 0x0100, 0xc49: 0x0100, 0xc4a: 0x0100, 0xc4b: 0x0100,
	0xc4c: 0x0100, 0xc4e: 0x0100, 0xc4f: 0x0100, 0xc50: 0x0100,
	0xc52: 0x0100, 0xc53: 0x0100, 0xc54: 0x0100, 0xc55: 0x0100, 0xc56: 0x0100, 0xc57: 0x0100,
	0xc58: 0x0100, 0xc59: 0x0100, 0xc5a: 0x0100, 0xc5b: 0x0100, 0xc5c: 0x0100, 0xc5d: 0x0100,
	0xc5e: 0x0100, 0xc5f: 0x0100, 0xc60: 0x0100, 0xc61: 0x0100, 0xc62: 0x0100, 0xc63: 0x0100,
	0xc64: 0x0100, 0xc65: 0x0100, 0xc66: 0x0100, 0xc67: 0x0100, 0xc68: 0x0100,
	0xc6a: 0x0100, 0xc6b: 0x0100, 0xc6c: 0x0100, 0xc6d: 0x0100, 0xc6e: 0x0100, 0xc6f: 0x0100,
	0xc70: 0x0100, 0xc71: 0x0100, 0xc72: 0x0100, 0xc73: 0x0100, 0xc74: 0x0100, 0xc75: 0x0100,
	0xc76: 0x0100, 0xc77: 0x0100, 0xc78: 0x0100, 0xc79: 0x0100,
	0xc7c: 0x0008, 0xc7d: 0x0100, 0xc7e: 0x0008, 0xc7f: 0x0008,
	// Block 0x32, offset 0xc80
	0xc80: 0x0008, 0xc81: 0x0008, 0xc82: 0x0008, 0xc83: 0x0008, 0xc84: 0x0008,
	0xc86: 0x0008, 0xc87: 0x0008, 0xc88: 0x0008, 0xc8a: 0x0008, 0xc8b: 0x0008,
	0xc8c: 0x0008, 0xc8d: 0x0008,
	0xc95: 0x0008, 0xc96: 0x0008,
	0xc98: 0x0100, 0xc99: 0x0100, 0xc9a: 0x0100, 0xc9d: 0x0100,
	0xca0: 0x0100, 0xca1: 0x0100, 0xca2: 0x0008, 0xca3: 0x0008,
	0xca6: 0x0080, 0xca7: 0x0080, 0xca8: 0x0080, 0xca9: 0x0080,
	0xcaa: 0x0080, 0xcab: 0x0080, 0xcac: 0x0080, 0xcad: 0x0080, 0xcae: 0x0080, 0xcaf: 0x0080,
	// Block 0x33, offset 0xcc0
	0xcc0: 0x0100, 0xcc1: 0x0008, 0xcc2: 0x0008, 0xcc3: 0x0008, 0xcc5: 0x0100,
	0xcc6: 0x0100, 0xcc7: 0x0100, 0xcc8: 0x0100, 0xcc9: 0x0100, 0xcca: 0x0100, 0xccb: 0x0100,
	0xccc: 0x0100, 0xcce: 0x0100, 0xccf: 0x0100, 0xcd0: 0x0100,
	0xcd2: 0x0100, 0xcd3: 0x0100, 0xcd4: 0x0100, 0xcd5: 0x0100, 0xcd6: 0x0100, 0xcd7: 0x0100,
	0xcd8: 0x0100, 0xcd9: 0x0100, 0xcda: 0x0100, 0xcdb: 0x0100, 0xcdc: 0x0100, 0xcdd: 0x0100,
	0xcde: 0x0100, 0xcdf: 0x0100, 0xce0: 0x0100, 0xce1: 0x0100, 0xce2: 0x0100, 0xce3: 0x0100,
	0xce4: 0x0100, 0xce5: 0x0100, 0xce6: 0x0100, 0xce7: 0x0100, 0xce8: 0x0100,
	0xcea: 0x0100, 0xceb: 0x0100, 0xcec: 0x0100, 0xced: 0x0100, 0xcee: 0x0100, 0xcef: 0x0100,
	0xcf0: 0x0100, 0xcf1: 0x0100, 0xcf2: 0x0100, 0xcf3: 0x0100, 0xcf5: 0x0100,
	0xcf6: 0x0100, 0xcf7: 0x0100, 0xcf8: 0x0100, 0xcf9: 0x0100,
	0xcfc: 0x0008, 0xcfd: 0x0100, 0xcfe: 0x0008, 0xcff: 0x0008,
	// Block 0x34, offset 0xd00
	0xd00: 0x0008, 0xd01: 0x0008, 0xd02: 0x0008, 0xd03: 0x0008, 0xd04: 0x0008,
	0xd06: 0x0008, 0xd07: 0x0008, 0xd08: 0x0008, 0xd0a: 0x0008, 0xd0b: 0x0008,
	0xd0c: 0x0008, 0xd0d: 0x0008,
	0xd15: 0x0008, 0xd16: 0x0008,
	0xd1d: 0x0100,
	0xd1e: 0x0100, 0xd20: 0x0100, 0xd21: 0x0100, 0xd22: 0x0008, 0xd23: 0x0008,
	0xd26: 0x0080, 0xd27: 0x0080, 0xd28: 0x0080, 0xd29: 0x0080,
	0xd2a: 0x0080, 0xd2b: 0x0080, 0xd2c: 0x0080, 0xd2d: 0x0080, 0xd2e: 0x0080, 0xd2f: 0x0080,
	0xd31: 0x0100, 0xd32: 0x0100, 0xd33: 0x0008,
	// Block 0x35, offset 0xd40
	0xd40: 0x0008, 0xd41: 0x0008, 0xd42: 0x0008, 0xd43: 0x0008, 0xd44: 0x0100, 0xd45: 0x0100,
	0xd46: 0x0100, 0xd47: 0x0100, 0xd48: 0x0100, 0xd49: 0x0100, 0xd4a: 0x0100, 0xd4b: 0x0100,
	0xd4c: 0x0100, 0xd4e: 0x0100, 0xd4f: 0x0100, 0xd50: 0x0100,
	0xd52: 0x0100, 0xd53: 0x0100, 0xd54: 0x0100, 0xd55: 0x0100, 0xd56: 0x0100, 0xd57: 0x0100,
	0xd58: 0x0100, 0xd59: 0x0100, 0xd5a: 0x0100, 0xd5b: 0x0100, 0xd5c: 0x0100, 0xd5d: 0x0100,
	0xd5e: 0x0100, 0xd5f: 0x0100, 0xd60: 0x0100, 0xd61: 0x0100, 0xd62: 0x0100, 0xd63: 0x0100,
	0xd64: 0x0100, 0xd65: 0x0100, 0xd66: 0x0100, 0xd67: 0x0100, 0xd68: 0x0100, 0xd69: 0x0100,
	0xd6a: 0x0100, 0xd6b: 0x0100, 0xd6c: 0x0100, 0xd6d: 0x0100, 0xd6e: 0x0100, 0xd6f: 0x0100,
	0xd70: 0x0100, 0xd71: 0x0100, 0xd72: 0x0100, 0xd73: 0x0100, 0xd74: 0x0100, 0xd75: 0x0100,
	0xd76: 0x0100, 0xd77: 0x0100, 0xd78: 0x0100, 0xd79: 0x0100, 0xd7a: 0x0100, 0xd7b: 0x0008,
	0xd7c: 0x0008, 0xd7d: 0x0100, 0xd7e: 0x0008, 0xd7f: 0x0008,
	// Block 0x36, offset 0xd80
	0xd80: 0x0008, 0xd81: 0x0008, 0xd82: 0x0008, 0xd83: 0x0008, 0xd84: 0x0008,
	0xd86: 0x0008, 0xd87: 0x0008, 0xd88: 0x0008, 0xd8a: 0x0008, 0xd8b: 0x0008,
	0xd8c: 0x0008, 0xd8d: 0x0008, 0xd8e: 0x0100,
	0xd94: 0x0100, 0xd95: 0x0100, 0xd96: 0x0100, 0xd97: 0x0008,
	0xd9f: 0x0100, 0xda0: 0x0100, 0xda1: 0x0100, 0xda2: 0x0008, 0xda3: 0x0008,
	0xda6: 0x0080, 0xda7: 0x0080, 0xda8: 0x0080, 0xda9: 0x0080,
	0xdaa: 0x0080, 0xdab: 0x0080, 0xdac: 0x0080, 0xdad: 0x0080, 0xdae: 0x0080, 0xdaf: 0x0080,
	0xdba: 0x0100, 0xdbb: 0x0100,
	0xdbc: 0x0100, 0xdbd: 0x0100, 0xdbe: 0x0100, 0xdbf: 0x0100,
	// Block 0x37, offset 0xdc0
	0xdc1: 0x0008, 0xdc2: 0x0008, 0xdc3: 0x0008, 0xdc5: 0x0100,
	0xdc6: 0x0100, 0xdc7: 0x0100, 0xdc8: 0x0100, 0xdc9: 0x0100, 0xdca: 0x0100, 0xdcb: 0x0100,
	0xdcc: 0x0100, 0xdcd: 0x0100, 0xdce: 0x0100, 0xdcf: 0x0100, 0xdd0: 0x0100, 0xdd1: 0x0100,
	0xdd2: 0x0100, 0xdd3: 0x0100, 0xdd4: 0x0100, 0xdd5: 0x0100, 0xdd6: 0x0100,
	0xdda: 0x0100, 0xddb: 0x0100, 0xddc: 0x0100, 0xddd: 0x0100,
	0xdde: 0x0100, 0xddf: 0x0100, 0xde0: 0x0100, 0xde1: 0x0100, 0xde2: 0x0100, 0xde3: 0x0100,
	0xde4: 0x0100, 0xde5: 0x0100, 0xde6: 0x0100, 0xde7: 0x0100, 0xde8: 0x0100, 0xde9: 0x0100,
	0xdea: 0x0100, 0xdeb: 0x0100, 0xdec: 0x0100, 0xded: 0x0100, 0xdee: 0x0100, 0xdef: 0x0100,
	0xdf0: 0x0100, 0xdf1: 0x0100, 0xdf3: 0x0100, 0xdf4: 0x0100, 0xdf5: 0x0100,
	0xdf6: 0x0100, 0xdf7: 0x0100, 0xdf8: 0x0100, 0xdf9: 0x0100, 0xdfa: 0x0100, 0xdfb: 0x0100,
	0xdfd: 0x0100,
	// Block 0x38, offset 0xe00
	0xe00: 0x0100, 0xe01: 0x0100, 0xe02: 0x0100, 0xe03: 0x0100, 0xe04: 0x0100, 0xe05: 0x0100,
	0xe06: 0x0100, 0xe0a: 0x0008,
	0xe0f: 0x0008, 0xe10: 0x0008, 0xe11: 0x0008,
	0xe12: 0x0008, 0xe13: 0x0008, 0xe14: 0x0008, 0xe16: 0x0008,
	0xe18: 0x0008, 0xe19: 0x0008, 0xe1a: 0x0008, 0xe1b: 0x0008, 0xe1c: 0x0008, 0xe1d: 0x0008,
	0xe1e: 0x0008, 0xe1f: 0x0008,
	0xe26: 0x0080, 0xe27: 0x0080, 0xe28: 0x0080, 0xe29: 0x0080,
	0xe2a: 0x0080, 0xe2b: 0x0080, 0xe2c: 0x0080, 0xe2d: 0x0080, 0xe2e: 0x0080, 0xe2f: 0x0080,
	0xe32: 0x0008, 0xe33: 0x0008,
	// Block 0x39, offset 0xe40
	0xe41: 0x0100, 0xe42: 0x0100, 0xe43: 0x0100, 0xe44: 0x0100, 0xe45: 0x0100,
	0xe46: 0x0100, 0xe47: 0x0100, 0xe48: 0x0100, 0xe49: 0x0100, 0xe4a: 0x0100, 0xe4b: 0x0100,
	0xe4c: 0x0100, 0xe4d: 0x0100, 0xe4e: 0x0100, 0xe4f: 0x0100, 0xe50: 0x0100, 0xe51: 0x0100,
	0xe52: 0x0100, 0xe53: 0x0100, 0xe54: 0x0100, 0xe55: 0x0100, 0xe56: 0x0100, 0xe57: 0x0100,
	0xe58: 0x0100, 0xe59: 0x0100, 0xe5a: 0x0100, 0xe5b: 0x0100, 0xe5c: 0x0100, 0xe5d: 0x0100,
	0xe5e: 0x0100, 0xe5f: 0x0100, 0xe60: 0x0100, 0xe61: 0x0100, 0xe62: 0x0100, 0xe63: 0x0100,
	0xe64: 0x0100, 0xe65: 0x0100, 0xe66: 0x0100, 0xe67: 0x0100, 0xe68: 0x0100, 0xe69: 0x0100,
	0xe6a: 0x0100, 0xe6b: 0x0100, 0xe6c: 0x0100, 0xe6d: 0x0100, 0xe6e: 0x0100, 0xe6f: 0x0100,
	0xe70: 0x0100, 0xe71: 0x0008, 0xe72: 0x0100, 0xe73: 0x0100, 0xe74: 0x0008, 0xe75: 0x0008,
	0xe76: 0x0008, 0xe77: 0x0008, 0xe78: 0x0008, 0xe79: 0x0008, 0xe7a: 0x0008,
	// Block 0x3a, offset 0xe80
	0xe80: 0x0100, 0xe81: 0x0100, 0xe82: 0x0100, 0xe83: 0x0100, 0xe84: 0x0100, 0xe85: 0x0100,
	0xe86: 0x0100, 0xe87: 0x0008, 0xe88: 0x0008, 0xe89: 0x0008, 0xe8a: 0x0008, 0xe8b: 0x0008,
	0xe8c: 0x0008, 0xe8d: 0x0008, 0xe8e: 0x0008, 0xe90: 0x0080, 0xe91: 0x0080,
	0xe92: 0x0080, 0xe93: 0x0080, 0xe94: 0x0080, 0xe95: 0x0080, 0xe96: 0x0080, 0xe97: 0x0080,
	0xe98: 0x0080, 0xe99: 0x0080,
	// Block 0x3b, offset 0xec0
	0xec1: 0x0100, 0xec2: 0x0100, 0xec4: 0x0100,
	0xec6: 0x0100, 0xec7: 0x0100, 0xec8: 0x0100, 0xec9: 0x0100, 0xeca: 0x0100,
	0xecc: 0x0100, 0xecd: 0x0100, 0xece: 0x0100, 0xecf: 0x0100, 0xed0: 0x0100, 0xed1: 0x0100,
	0xed2: 0x0100, 0xed3: 0x0100, 0xed4: 0x0100, 0xed5: 0x0100, 0xed6: 0x0100, 0xed7: 0x0100,
	0xed8: 0x0100, 0xed9: 0x0100, 0xeda: 0x0100, 0xedb: 0x0100, 0xedc: 0x0100, 0xedd: 0x0100,
	0xede: 0x0100, 0xedf: 0x0100, 0xee0: 0x0100, 0xee1: 0x0100, 0xee2: 0x0100, 0xee3: 0x0100,
	0xee5: 0x0100, 0xee7: 0x0100, 0xee8: 0x0100, 0xee9: 0x0100,
	0xeea: 0x0100, 0xeeb: 0x0100, 0xeec: 0x0100, 0xeed: 0x0100, 0xeee: 0x0100, 0xeef: 0x0100,
	0xef0: 0x0100, 0xef1: 0x0008, 0xef2: 0x0100, 0xef3: 0x0100, 0xef4: 0x0008, 0xef5: 0x0008,
	0xef6: 0x0008, 0xef7: 0x0008, 0xef8: 0x0008, 0xef9: 0x0008, 0xefa: 0x0008, 0xefb: 0x0008,
	0xefc: 0x0008, 0xefd: 0x0100,
	// Block 0x3c, offset 0xf00
	0xf00: 0x0100, 0xf01: 0x0100, 0xf02: 0x0100, 0xf03: 0x0100, 0xf04: 0x0100,
	0xf06: 0x0100, 0xf08: 0x0008, 0xf09: 0x0008, 0xf0a: 0x0008, 0xf0b: 0x0008,
	0xf0c: 0x0008, 0xf0d: 0x0008, 0xf0e: 0x0008, 0xf10: 0x0080, 0xf11: 0x0080,
	0xf12: 0x0080, 0xf13: 0x0080, 0xf14: 0x0080, 0xf15: 0x0080, 0xf16: 0x0080, 0xf17: 0x0080,
	0xf18: 0x0080, 0xf19: 0x0080, 0xf1c: 0x0100, 0xf1d: 0x0100,
	0xf1e: 0x0100, 0xf1f: 0x0100,
	// Block 0x3d, offset 0xf40
	0xf40: 0x0100,
	0xf58: 0x0008, 0xf59: 0x0008,
	0xf60: 0x0080, 0xf61: 0x0080, 0xf62: 0x0080, 0xf63: 0x0080,
	0xf64: 0x0080, 0xf65: 0x0080, 0xf66: 0x0080, 0xf67: 0x0080, 0xf68: 0x0080, 0xf69: 0x0080,
	0xf75: 0x0008,
	0xf77: 0x0008, 0xf79: 0x0008, 0xf7a: 0x0004, 0xf7b: 0x0004,
	0xf7c: 0x0004, 0xf7d: 0x0004, 0xf7e: 0x0008, 0xf7f: 0x0008,
	// Block 0x3e, offset 0xf80
	0xf80: 0x0100, 0xf81: 0x0100, 0xf82: 0x0100, 0xf83: 0x0100, 0xf84: 0x0100, 0xf85: 0x0100,
	0xf86: 0x0100, 0xf87: 0x0100, 0xf89: 0x0100, 0xf8a: 0x0100, 0xf8b: 0x0100,
	0xf8c: 0x0100, 0xf8d: 0x0100, 0xf8e: 0x0100, 0xf8f: 0x0100, 0xf90: 0x0100, 0xf91: 0x0100,
	0xf92: 0x0100, 0xf93: 0x0100, 0xf94: 0x0100, 0xf95: 0x0100, 0xf96: 0x0100, 0xf97: 0x0100,
	0xf98: 0x0100, 0xf99: 0x0100, 0xf9a: 0x0100, 0xf9b: 0x0100, 0xf9c: 0x0100, 0xf9d: 0x0100,
	0xf9e: 0x0100, 0xf9f: 0x0100, 0xfa0: 0x0100, 0xfa1: 0x0100, 0xfa2: 0x0100, 0xfa3: 0x0100,
	0xfa4: 0x0100, 0xfa5: 0x0100, 0xfa6: 0x0100, 0xfa7: 0x0100, 0xfa8: 0x0100, 0xfa9: 0x0100,
	0xfaa: 0x0100, 0xfab: 0x0100, 0xfac: 0x0100,
	0xfb1: 0x0008, 0xfb2: 0x0008, 0xfb3: 0x0008, 0xfb4: 0x0008, 0xfb5: 0x0008,
	0xfb6: 0x0008, 0xfb7: 0x0008, 0xfb8: 0x0008, 0xfb9: 0x0008, 0xfba: 0x0008, 0xfbb: 0x0008,
	0xfbc: 0x0008, 0xfbd: 0x0008, 0xfbe: 0x0008, 0xfbf: 0x0008,
	// Block 0x3f, offset 0xfc0
	0xfc0: 0x0008, 0xfc1: 0x0008, 0xfc2: 0x0008, 0xfc3: 0x0008, 0xfc4: 0x0008,
	0xfc6: 0x0008, 0xfc7: 0x0008, 0xfc8: 0x0100, 0xfc9: 0x0100, 0xfca: 0x0100, 0xfcb: 0x0100,
	0xfcc: 0x0100, 0xfcd: 0x0008, 0xfce: 0x0008, 0xfcf: 0x0008, 0xfd0: 0x0008, 0xfd1: 0x0008,
	0xfd2: 0x0008, 0xfd3: 0x0008, 0xfd4: 0x0008, 0xfd5: 0x0008, 0xfd6: 0x0008, 0xfd7: 0x0008,
	0xfd9: 0x0008, 0xfda: 0x0008, 0xfdb: 0x0008, 0xfdc: 0x0008, 0xfdd: 0x0008,
	0xfde: 0x0008, 0xfdf: 0x0008, 0xfe0: 0x0008, 0xfe1: 0x0008, 0xfe2: 0x0008, 0xfe3: 0x0008,
	0xfe4: 0x0008, 0xfe5: 0x0008, 0xfe6: 0x0008, 0xfe7: 0x0008, 0xfe8: 0x0008, 0xfe9: 0x0008,
	0xfea: 0x0008, 0xfeb: 0x0008, 0xfec: 0x0008, 0xfed: 0x0008, 0xfee: 0x0008, 0xfef: 0x0008,
	0xff0: 0x0008, 0xff1: 0x0008, 0xff2: 0x0008, 0xff3: 0x0008, 0xff4: 0x0008, 0xff5: 0x0008,
	0xff6: 0x0008, 0xff7: 0x0008, 0xff8: 0x0008, 0xff9: 0x0008, 0xffa: 0x0008, 0xffb: 0x0008,
	0xffc: 0x0008,
	// Block 0x40, offset 0x1000
	0x1006: 0x0008,
	// Block 0x41, offset 0x1040
	0x1040: 0x0100, 0x1041: 0x0100, 0x1042: 0x0100, 0x1043: 0x0100, 0x1044: 0x0100, 0x1045: 0x0100,
	0x1046: 0x0100, 0x1047: 0x0100, 0x1048: 0x0100, 0x1049: 0x0100, 0x104a: 0x0100, 0x104b: 0x0100,
	0x104c: 0x0100, 0x104d: 0x0100, 0x104e: 0x0100, 0x104f: 0x0100, 0x1050: 0x0100, 0x1051: 0x0100,
	0x1052: 0x0100, 0x1053: 0x0100, 0x1054: 0x0100, 0x1055: 0x0100, 0x1056: 0x0100, 0x1057: 0x0100,
	0x1058: 0x0100, 0x1059: 0x0100, 0x105a: 0x0100, 0x105b: 0x0100, 0x105c: 0x0100, 0x105d: 0x0100,
	0x105e: 0x0100, 0x105f: 0x0100, 0x1060: 0x0100, 0x1061: 0x0100, 0x1062: 0x0100, 0x1063: 0x0100,
	0x1064: 0x0100, 0x1065: 0x0100, 0x1066: 0x0100, 0x1067: 0x0100, 0x1068: 0x0100, 0x1069: 0x0100,
	0x106a: 0x0100, 0x106b: 0x0008, 0x106c: 0x0008, 0x106d: 0x0008, 0x106e: 0x0008, 0x106f: 0x0008,
	0x1070: 0x0008, 0x1071: 0x0008, 0x1072: 0x0008, 0x1073: 0x0008, 0x1074: 0x0008, 0x1075: 0x0008,
	0x1076: 0x0008, 0x1077: 0x0008, 0x1078: 0x0008, 0x1079: 0x0008, 0x107a: 0x0008, 0x107b: 0x0008,
	0x107c: 0x0008, 0x107d: 0x0008, 0x107e: 0x0008, 0x107f: 0x0100,
	// Block 0x42, offset 0x1080
	0x1080: 0x0080, 0x1081: 0x0080, 0x1082: 0x0080, 0x1083: 0x0080, 0x1084: 0x0080, 0x1085: 0x0080,
	0x1086: 0x0080, 0x1087: 0x0080, 0x1088: 0x0080, 0x1089: 0x0080, 0x108a: 0x0400, 0x108b: 0x0400,
	0x1090: 0x0100, 0x1091: 0x0100,
	0x1092: 0x0100, 0x1093: 0x0100, 0x1094: 0x0100, 0x1095: 0x0100, 0x1096: 0x0008, 0x1097: 0x0008,
	0x1098: 0x0008, 0x1099: 0x0008, 0x109a: 0x0100, 0x109b: 0x0100, 0x109c: 0x0100, 0x109d: 0x0100,
	0x109e: 0x0008, 0x109f: 0x0008, 0x10a0: 0x0008, 0x10a1: 0x0100, 0x10a2: 0x0008, 0x10a3: 0x0008,
	0x10a4: 0x0008, 0x10a5: 0x0100, 0x10a6: 0x0100, 0x10a7: 0x0008, 0x10a8: 0x0008, 0x10a9: 0x0008,
	0x10aa: 0x0008, 0x10ab: 0x0008, 0x10ac: 0x0008, 0x10ad: 0x0008, 0x10ae: 0x0100, 0x10af: 0x0100,
	0x10b0: 0x0100, 0x10b1: 0x0008, 0x10b2: 0x0008, 0x10b3: 0x0008, 0x10b4: 0x0008, 0x10b5: 0x0100,
	0x10b6: 0x0100, 0x10b7: 0x0100, 0x10b8: 0x0100, 0x10b9: 0x0100, 0x10ba: 0x0100, 0x10bb: 0x0100,
	0x10bc: 0x0100, 0x10bd: 0x0100, 0x10be: 0x0100, 0x10bf: 0x0100,
	// Block 0x43, offset 0x10c0
	0x10c0: 0x0100, 0x10c1: 0x0100, 0x10c2: 0x0008, 0x10c3: 0x0008, 0x10c4: 0x0008, 0x10c5: 0x0008,
	0x10c6: 0x0008, 0x10c7: 0x0008, 0x10c8: 0x0008, 0x10c9: 0x0008, 0x10ca: 0x0008, 0x10cb: 0x0008,
	0x10cc: 0x0008, 0x10cd: 0x0008, 0x10ce: 0x0100, 0x10cf: 0x0008, 0x10d0: 0x0080, 0x10d1: 0x0080,
	0x10d2: 0x0080, 0x10d3: 0x0080, 0x10d4: 0x0080, 0x10d5: 0x0080, 0x10d6: 0x0080, 0x10d7: 0x0080,
	0x10d8: 0x0080, 0x10d9: 0x0080, 0x10da: 0x0008, 0x10db: 0x0008, 0x10dc: 0x0008, 0x10dd: 0x0008,
	0x10e0: 0x2000, 0x10e1: 0x2000, 0x10e2: 0x2000, 0x10e3: 0x2000,
	0x10e4: 0x2000, 0x10e5: 0x2000, 0x10e6: 0x2000, 0x10e7: 0x2000, 0x10e8: 0x2000, 0x10e9: 0x2000,
	0x10ea: 0x2000, 0x10eb: 0x2000, 0x10ec: 0x2000, 0x10ed: 0x2000, 0x10ee: 0x2000, 0x10ef: 0x2000,
	0x10f0: 0x2000, 0x10f1: 0x2000, 0x10f2: 0x2000, 0x10f3: 0x2000, 0x10f4: 0x2000, 0x10f5: 0x2000,
	0x10f6: 0x2000, 0x10f7: 0x2000, 0x10f8: 0x2000, 0x10f9: 0x2000, 0x10fa: 0x2000, 0x10fb: 0x2000,
	0x10fc: 0x2000, 0x10fd: 0x2000, 0x10fe: 0x2000, 0x10ff: 0x2000,
	// Block 0x44, offset 0x1100
	0x1100: 0x2000, 0x1101: 0x2000, 0x1102: 0x2000, 0x1103: 0x2000, 0x1104: 0x2000, 0x1105: 0x2000,
	0x1107: 0x2000,
	0x110d: 0x2000, 0x1110: 0x0100, 0x1111: 0x0100,
	0x1112: 0x0100, 0x1113: 0x0100, 0x1114: 0x0100, 0x1115: 0x0100, 0x1116: 0x0100, 0x1117: 0x0100,
	0x1118: 0x0100, 0x1119: 0x0100, 0x111a: 0x0100, 0x111b: 0x0100, 0x111c: 0x0100, 0x111d: 0x0100,
	0x111e: 0x0100, 0x111f: 0x0100, 0x1120: 0x0100, 0x1121: 0x0100, 0x1122: 0x0100, 0x1123: 0x0100,
	0x1124: 0x0100, 0x1125: 0x0100, 0x1126: 0x0100, 0x1127: 0x0100, 0x1128: 0x0100, 0x1129: 0x0100,
	0x112a: 0x0100, 0x112b: 0x0100, 0x112c: 0x0100, 0x112d: 0x0100, 0x112e: 0x0100, 0x112f: 0x0100,
	0x1130: 0x0100, 0x1131: 0x0100, 0x1132: 0x0100, 0x1133: 0x0100, 0x1134: 0x0100, 0x1135: 0x0100,
	0x1136: 0x0100, 0x1137: 0x0100, 0x1138: 0x0100, 0x1139: 0x0100, 0x113a: 0x0100,
	0x113c: 0x0040, 0x113d: 0x0100, 0x113e: 0x0100, 0x113f: 0x0100,
	// Block 0x45, offset 0x1140
	0x1140: 0x0100, 0x1141: 0x0100, 0x1142: 0x0100, 0x1143: 0x0100, 0x1144: 0x0100, 0x1145: 0x0100,
	0x1146: 0x0100, 0x1147: 0x0100, 0x1148: 0x0100, 0x114a: 0x0100, 0x114b: 0x0100,
	0x114c: 0x0100, 0x114d: 0x0100, 0x1150: 0x0100, 0x1151: 0x0100,
	0x1152: 0x0100, 0x1153: 0x0100, 0x1154: 0x0100, 0x1155: 0x0100, 0x1156: 0x0100,
	0x1158: 0x0100, 0x115a: 0x0100, 0x115b: 0x0100, 0x115c: 0x0100, 0x115d: 0x0100,
	0x1160: 0x0100, 0x1161: 0x0100, 0x1162: 0x0100, 0x1163: 0x0100,
	0x1164: 0x0100, 0x1165: 0x0100, 0x1166: 0x0100, 0x1167: 0x0100, 0x1168: 0x0100, 0x1169: 0x0100,
	0x116a: 0x0100, 0x116b: 0x0100, 0x116c: 0x0100, 0x116d: 0x0100, 0x116e: 0x0100, 0x116f: 0x0100,
	0x1170: 0x0100, 0x1171: 0x0100, 0x1172: 0x0100, 0x1173: 0x0100, 0x1174: 0x0100, 0x1175: 0x0100,
	0x1176: 0x0100, 0x1177: 0x0100, 0x1178: 0x0100, 0x1179: 0x0100, 0x117a: 0x0100, 0x117b: 0x0100,
	0x117c: 0x0100, 0x117d: 0x0100, 0x117e: 0x0100, 0x117f: 0x0100,
	// Block 0x46, offset 0x1180
	0x1180: 0x0100, 0x1181: 0x0100, 0x1182: 0x0100, 0x1183: 0x0100, 0x1184: 0x0100, 0x1185: 0x0100,
	0x1186: 0x0100, 0x1187: 0x0100, 0x1188: 0x0100, 0x118a: 0x0100, 0x118b: 0x0100,
	0x118c: 0x0100, 0x118d: 0x0100, 0x1190: 0x0100, 0x1191: 0x0100,
	0x1192: 0x0100, 0x1193: 0x0100, 0x1194: 0x0100, 0x1195: 0x0100, 0x1196: 0x0100, 0x1197: 0x0100,
	0x1198: 0x0100, 0x1199: 0x0100, 0x119a: 0x0100, 0x119b: 0x0100, 0x119c: 0x0100, 0x119d: 0x0100,
	0x119e: 0x0100, 0x119f: 0x0100, 0x11a0: 0x0100, 0x11a1: 0x0100, 0x11a2: 0x0100, 0x11a3: 0x0100,
	0x11a4: 0x0100, 0x11a5: 0x0100, 0x11a6: 0x0100, 0x11a7: 0x0100, 0x11a8: 0x0100, 0x11a9: 0x0100,
	0x11aa: 0x0100, 0x11ab: 0x0100, 0x11ac: 0x0100, 0x11ad: 0x0100, 0x11ae: 0x0100, 0x11af: 0x0100,
	0x11b0: 0x0100, 0x11b2: 0x0100, 0x11b3: 0x0100, 0x11b4: 0x0100, 0x11b5: 0x0100,
	0x11b8: 0x0100, 0x11b9: 0x0100, 0x11ba: 0x0100, 0x11bb: 0x0100,
	0x11bc: 0x0100, 0x11bd: 0x0100, 0x11be: 0x0100,
	// Block 0x47, offset 0x11c0
	0x11c0: 0x0100, 0x11c2: 0x0100, 0x11c3: 0x0100, 0x11c4: 0x0100, 0x11c5: 0x0100,
	0x11c8: 0x0100, 0x11c9: 0x0100, 0x11ca: 0x0100, 0x11cb: 0x0100,
	0x11cc: 0x0100, 0x11cd: 0x0100, 0x11ce: 0x0100, 0x11cf: 0x0100, 0x11d0: 0x0100, 0x11d1: 0x0100,
	0x11d2: 0x0100, 0x11d3: 0x0100, 0x11d4: 0x0100, 0x11d5: 0x0100, 0x11d6: 0x0100,
	0x11d8: 0x0100, 0x11d9: 0x0100, 0x11da: 0x0100, 0x11db: 0x0100, 0x11dc: 0x0100, 0x11dd: 0x0100,
	0x11de: 0x0100, 0x11df: 0x0100, 0x11e0: 0x0100, 0x11e1: 0x0100, 0x11e2: 0x0100, 0x11e3: 0x0100,
	0x11e4: 0x0100, 0x11e5: 0x0100, 0x11e6: 0x0100, 0x11e7: 0x0100, 0x11e8: 0x0100, 0x11e9: 0x0100,
	0x11ea: 0x0100, 0x11eb: 0x0100, 0x11ec: 0x0100, 0x11ed: 0x0100, 0x11ee: 0x0100, 0x11ef: 0x0100,
	0x11f0: 0x0100, 0x11f1: 0x0100, 0x11f2: 0x0100, 0x11f3: 0x0100, 0x11f4: 0x0100, 0x11f5: 0x0100,
	0x11f6: 0x0100, 0x11f7: 0x0100, 0x11f8: 0x0100, 0x11f9: 0x0100, 0x11fa: 0x0100, 0x11fb: 0x0100,
	0x11fc: 0x0100, 0x11fd: 0x0100, 0x11fe: 0x0100, 0x11ff: 0x0100,
	// Block 0x48, offset 0x1200
	0x1200: 0x0100, 0x1201: 0x0100, 0x1202: 0x0100, 0x1203: 0x0100, 0x1204: 0x0100, 0x1205: 0x0100,
	0x1206: 0x0100, 0x1207: 0x0100, 0x1208: 0x0100, 0x1209: 0x0100, 0x120a: 0x0100, 0x120b: 0x0100,
	0x120c: 0x0100, 0x120d: 0x0100, 0x120e: 0x0100, 0x120f: 0x0100, 0x1210: 0x0100,
	0x1212: 0x0100, 0x1213: 0x0100, 0x1214: 0x0100, 0x1215: 0x0100,
	0x1218: 0x0100, 0x1219: 0x0100, 0x121a: 0x0100, 0x121b: 0x0100, 0x121c: 0x0100, 0x121d: 0x0100,
	0x121e: 0x0100, 0x121f: 0x0100, 0x1220: 0x0100, 0x1221: 0x0100, 0x1222: 0x0100, 0x1223: 0x0100,
	0x1224: 0x0100, 0x1225: 0x0100, 0x1226: 0x0100, 0x1227: 0x0100, 0x1228: 0x0100, 0x1229: 0x0100,
	0x122a: 0x0100, 0x122b: 0x0100, 0x122c: 0x0100, 0x122d: 0x0100, 0x122e: 0x0100, 0x122f: 0x0100,
	0x1230: 0x0100, 0x1231: 0x0100, 0x1232: 0x0100, 0x1233: 0x0100, 0x1234: 0x0100, 0x1235: 0x0100,
	0x1236: 0x0100, 0x1237: 0x0100, 0x1238: 0x0100, 0x1239: 0x0100, 0x123a: 0x0100, 0x123b: 0x0100,
	0x123c: 0x0100, 0x123d: 0x0100, 0x123e: 0x0100, 0x123f: 0x0100,
	// Block 0x49, offset 0x1240
	0x1240: 0x0100, 0x1241: 0x0100, 0x1242: 0x0100, 0x1243: 0x0100, 0x1244: 0x0100, 0x1245: 0x0100,
	0x1246: 0x0100, 0x1247: 0x0100, 0x1248: 0x0100, 0x1249: 0x0100, 0x124a: 0x0100, 0x124b: 0x0100,
	0x124c: 0x0100, 0x124d: 0x0100, 0x124e: 0x0100, 0x124f: 0x0100, 0x1250: 0x0100, 0x1251: 0x0100,
	0x1252: 0x0100, 0x1253: 0x0100, 0x1254: 0x0100, 0x1255: 0x0100, 0x1256: 0x0100, 0x1257: 0x0100,
	0x1258: 0x0100, 0x1259: 0x0100, 0x125a: 0x0100, 0x125d: 0x0008,
	0x125e: 0x0008, 0x125f: 0x0008, 0x1262: 0x0400,
	0x1267: 0x0400, 0x1268: 0x0400,
	// Block 0x4a, offset 0x1280
	0x1280: 0x0100, 0x1281: 0x0100, 0x1282: 0x0100, 0x1283: 0x0100, 0x1284: 0x0100, 0x1285: 0x0100,
	0x1286: 0x0100, 0x1287: 0x0100, 0x1288: 0x0100, 0x1289: 0x0100, 0x128a: 0x0100, 0x128b: 0x0100,
	0x128c: 0x0100, 0x128d: 0x0100, 0x128e: 0x0100, 0x128f: 0x0100,
	0x12a0: 0x2000, 0x12a1: 0x2000, 0x12a2: 0x2000, 0x12a3: 0x2000,
	0x12a4: 0x2000, 0x12a5: 0x2000, 0x12a6: 0x2000, 0x12a7: 0x2000, 0x12a8: 0x2000, 0x12a9: 0x2000,
	0x12aa: 0x2000, 0x12ab: 0x2000, 0x12ac: 0x2000, 0x12ad: 0x2000, 0x12ae: 0x2000, 0x12af: 0x2000,
	0x12b0: 0x2000, 0x12b1: 0x2000, 0x12b2: 0x2000, 0x12b3: 0x2000, 0x12b4: 0x2000, 0x12b5: 0x2000,
	0x12b6: 0x2000, 0x12b7: 0x2000, 0x12b8: 0x2000, 0x12b9: 0x2000, 0x12ba: 0x2000, 0x12bb: 0x2000,
	0x12bc: 0x2000, 0x12bd: 0x2000, 0x12be: 0x2000, 0x12bf: 0x2000,
	// Block 0x4b, offset 0x12c0
	0x12c0: 0x2000, 0x12c1: 0x2000, 0x12c2: 0x2000, 0x12c3: 0x2000, 0x12c4: 0x2000, 0x12c5: 0x2000,
	0x12c6: 0x2000, 0x12c7: 0x2000, 0x12c8: 0x2000, 0x12c9: 0x2000, 0x12ca: 0x2000, 0x12cb: 0x2000,
	0x12cc: 0x2000, 0x12cd: 0x2000, 0x12ce: 0x2000, 0x12cf: 0x2000, 0x12d0: 0x2000, 0x12d1: 0x2000,
	0x12d2: 0x2000, 0x12d3: 0x2000, 0x12d4: 0x2000, 0x12d5: 0x2000, 0x12d6: 0x2000, 0x12d7: 0x2000,
	0x12d8: 0x2000, 0x12d9: 0x2000, 0x12da: 0x2000, 0x12db: 0x2000, 0x12dc: 0x2000, 0x12dd: 0x2000,
	0x12de: 0x2000, 0x12df: 0x2000, 0x12e0: 0x2000, 0x12e1: 0x2000, 0x12e2: 0x2000, 0x12e3: 0x2000,
	0x12e4: 0x2000, 0x12e5: 0x2000, 0x12e6: 0x2000, 0x12e7: 0x2000, 0x12e8: 0x2000, 0x12e9: 0x2000,
	0x12ea: 0x2000, 0x12eb: 0x2000, 0x12ec: 0x2000, 0x12ed: 0x2000, 0x12ee: 0x2000, 0x12ef: 0x2000,
	0x12f0: 0x2000, 0x12f1: 0x2000, 0x12f2: 0x2000, 0x12f3: 0x2000, 0x12f4: 0x2000, 0x12f5: 0x2000,
	0x12f8: 0x0040, 0x12f9: 0x0040, 0x12fa: 0x0040, 0x12fb: 0x0040,
	0x12fc: 0x0040, 0x12fd: 0x0040,
	// Block 0x4c, offset 0x1300
	0x1301: 0x0100, 0x1302: 0x0100, 0x1303: 0x0100, 0x1304: 0x0100, 0x1305: 0x0100,
	0x1306: 0x0100, 0x1307: 0x0100, 0x1308: 0x0100, 0x1309: 0x0100, 0x130a: 0x0100, 0x130b: 0x0100,
	0x130c: 0x0100, 0x130d: 0x0100, 0x130e: 0x0100, 0x130f: 0x0100, 0x1310: 0x0100, 0x1311: 0x0100,
	0x1312: 0x0100, 0x1313: 0x0100, 0x1314: 0x0100, 0x1315: 0x0100, 0x1316: 0x0100, 0x1317: 0x0100,
	0x1318: 0x0100, 0x1319: 0x0100, 0x131a: 0x0100, 0x131b: 0x0100, 0x131c: 0x0100, 0x131d: 0x0100,
	0x131e: 0x0100, 0x131f: 0x0100, 0x1320: 0x0100, 0x1321: 0x0100, 0x1322: 0x0100, 0x1323: 0x0100,
	0x1324: 0x0100, 0x1325: 0x0100, 0x1326: 0x0100, 0x1327: 0x0100, 0x1328: 0x0100, 0x1329: 0x0100,
	0x132a: 0x0100, 0x132b: 0x0100, 0x132c: 0x0100, 0x132d: 0x0100, 0x132e: 0x0100, 0x132f: 0x0100,
	0x1330: 0x0100, 0x1331: 0x0100, 0x1332: 0x0100, 0x1333: 0x0100, 0x1334: 0x0100, 0x1335: 0x0100,
	0x1336: 0x0100, 0x1337: 0x0100, 0x1338: 0x0100, 0x1339: 0x0100, 0x133a: 0x0100, 0x133b: 0x0100,
	0x133c: 0x0100, 0x133d: 0x0100, 0x133e: 0x0100, 0x133f: 0x0100,
	// Block 0x4d, offset 0x1340
	0x1340: 0x0100, 0x1341: 0x0100, 0x1342: 0x0100, 0x1343: 0x0100, 0x1344: 0x0100, 0x1345: 0x0100,
	0x1346: 0x0100, 0x1347: 0x0100, 0x1348: 0x0100, 0x1349: 0x0100, 0x134a: 0x0100, 0x134b: 0x0100,
	0x134c: 0x0100, 0x134d: 0x0100, 0x134e: 0x0100, 0x134f: 0x0100, 0x1350: 0x0100, 0x1351: 0x0100,
	0x1352: 0x0100, 0x1353: 0x0100, 0x1354: 0x0100, 0x1355: 0x0100, 0x1356: 0x0100, 0x1357: 0x0100,
	0x1358: 0x0100, 0x1359: 0x0100, 0x135a: 0x0100, 0x135b: 0x0100, 0x135c: 0x0100, 0x135d: 0x0100,
	0x135e: 0x0100, 0x135f: 0x0100, 0x1360: 0x0100, 0x1361: 0x0100, 0x1362: 0x0100, 0x1363: 0x0100,
	0x1364: 0x0100, 0x1365: 0x0100, 0x1366: 0x0100, 0x1367: 0x0100, 0x1368: 0x0100, 0x1369: 0x0100,
	0x136a: 0x0100, 0x136b: 0x0100, 0x136c: 0x0100, 0x136e: 0x0400, 0x136f: 0x0100,
	0x1370: 0x0100, 0x1371: 0x0100, 0x1372: 0x0100, 0x1373: 0x0100, 0x1374: 0x0100, 0x1375: 0x0100,
	0x1376: 0x0100, 0x1377: 0x0100, 0x1378: 0x0100, 0x1379: 0x0100, 0x137a: 0x0100, 0x137b: 0x0100,
	0x137c: 0x0100, 0x137d: 0x0100, 0x137e: 0x0100, 0x137f: 0x0100,
	// Block 0x4e, offset 0x1380
	0x1380: 0x1000, 0x1381: 0x0100, 0x1382: 0x0100, 0x1383: 0x0100, 0x1384: 0x0100, 0x1385: 0x0100,
	0x1386: 0x0100, 0x1387: 0x0100, 0x1388: 0x0100, 0x1389: 0x0100, 0x138a: 0x0100, 0x138b: 0x0100,
	0x138c: 0x0100, 0x138d: 0x0100, 0x138e: 0x0100, 0x138f: 0x0100, 0x1390: 0x0100, 0x1391: 0x0100,
	0x1392: 0x0100, 0x1393: 0x0100, 0x1394: 0x0100, 0x1395: 0x0100, 0x1396: 0x0100, 0x1397: 0x0100,
	0x1398: 0x0100, 0x1399: 0x0100, 0x139a: 0x0100, 0x139b: 0x0004, 0x139c: 0x0004,
	0x13a0: 0x0100, 0x13a1: 0x0100, 0x13a2: 0x0100, 0x13a3: 0x0100,
	0x13a4: 0x0100, 0x13a5: 0x0100, 0x13a6: 0x0100, 0x13a7: 0x0100, 0x13a8: 0x0100, 0x13a9: 0x0100,
	0x13aa: 0x0100, 0x13ab: 0x0100, 0x13ac: 0x0100, 0x13ad: 0x0100, 0x13ae: 0x0100, 0x13af: 0x0100,
	0x13b0: 0x0100, 0x13b1: 0x0100, 0x13b2: 0x0100, 0x13b3: 0x0100, 0x13b4: 0x0100, 0x13b5: 0x0100,
	0x13b6: 0x0100, 0x13b7: 0x0100, 0x13b8: 0x0100, 0x13b9: 0x0100, 0x13ba: 0x0100, 0x13bb: 0x0100,
	0x13bc: 0x0100, 0x13bd: 0x0100, 0x13be: 0x0100, 0x13bf: 0x0100,
	// Block 0x4f, offset 0x13c0
	0x13c0: 0x0100, 0x13c1: 0x0100, 0x13c2: 0x0100, 0x13c3: 0x0100, 0x13c4: 0x0100, 0x13c5: 0x0100,
	0x13c6: 0x0100, 0x13c7: 0x0100, 0x13c8: 0x0100, 0x13c9: 0x0100, 0x13ca: 0x0100, 0x13cb: 0x0100,
	0x13cc: 0x0100, 0x13cd: 0x0100, 0x13ce: 0x0100, 0x13cf: 0x0100, 0x13d0: 0x0100, 0x13d1: 0x0100,
	0x13d2: 0x0100, 0x13d3: 0x0100, 0x13d4: 0x0100, 0x13d5: 0x0100, 0x13d6: 0x0100, 0x13d7: 0x0100,
	0x13d8: 0x0100, 0x13d9: 0x0100, 0x13da: 0x0100, 0x13db: 0x0100, 0x13dc: 0x0100, 0x13dd: 0x0100,
	0x13de: 0x0100, 0x13df: 0x0100, 0x13e0: 0x0100, 0x13e1: 0x0100, 0x13e2: 0x0100, 0x13e3: 0x0100,
	0x13e4: 0x0100, 0x13e5: 0x0100, 0x13e6: 0x0100, 0x13e7: 0x0100, 0x13e8: 0x0100, 0x13e9: 0x0100,
	0x13ea: 0x0100, 0x13ee: 0x0100, 0x13ef: 0x0100,
	0x13f0: 0x0100, 0x13f1: 0x0100, 0x13f2: 0x0100, 0x13f3: 0x0100, 0x13f4: 0x0100, 0x13f5: 0x0100,
	0x13f6: 0x0100, 0x13f7: 0x0100, 0x13f8: 0x0100,
	// Block 0x50, offset 0x1400
	0x1400: 0x0100, 0x1401: 0x0100, 0x1402: 0x0100, 0x1403: 0x0100, 0x1404: 0x0100, 0x1405: 0x0100,
	0x1406: 0x0100, 0x1407: 0x0100, 0x1408: 0x0100, 0x1409: 0x0100, 0x140a: 0x0100, 0x140b: 0x0100,
	0x140c: 0x0100, 0x140d: 0x0100, 0x140e: 0x0100, 0x140f: 0x0100, 0x1410: 0x0100, 0x1411: 0x0100,
	0x1412: 0x0008, 0x1413: 0x0008, 0x1414: 0x0008, 0x1415: 0x0008,
	0x141f: 0x0100, 0x1420: 0x0100, 0x1421: 0x0100, 0x1422: 0x0100, 0x1423: 0x0100,
	0x1424: 0x0100, 0x1425: 0x0100, 0x1426: 0x0100, 0x1427: 0x0100, 0x1428: 0x0100, 0x1429: 0x0100,
	0x142a: 0x0100, 0x142b: 0x0100, 0x142c: 0x0100, 0x142d: 0x0100, 0x142e: 0x0100, 0x142f: 0x0100,
	0x1430: 0x0100, 0x1431: 0x0100, 0x1432: 0x0008, 0x1433: 0x0008, 0x1434: 0x0008, 0x1435: 0x0400,
	0x1436: 0x0400,
	// Block 0x51, offset 0x1440
	0x1440: 0x0100, 0x1441: 0x0100, 0x1442: 0x0100, 0x1443: 0x0100, 0x1444: 0x0100, 0x1445: 0x0100,
	0x1446: 0x0100, 0x1447: 0x0100, 0x1448: 0x0100, 0x1449: 0x0100, 0x144a: 0x0100, 0x144b: 0x0100,
	0x144c: 0x0100, 0x144d: 0x0100, 0x144e: 0x0100, 0x144f: 0x0100, 0x1450: 0x0100, 0x1451: 0x0100,
	0x1452: 0x0008, 0x1453: 0x0008,
	0x1460: 0x0100, 0x1461: 0x0100, 0x1462: 0x0100, 0x1463: 0x0100,
	0x1464: 0x0100, 0x1465: 0x0100, 0x1466: 0x0100, 0x1467: 0x0100, 0x1468: 0x0100, 0x1469: 0x0100,
	0x146a: 0x0100, 0x146b: 0x0100, 0x146c: 0x0100, 0x146e: 0x0100, 0x146f: 0x0100,
	0x1470: 0x0100, 0x1472: 0x0008, 0x1473: 0x0008,
	// Block 0x52, offset 0x1480
	0x1480: 0x0100, 0x1481: 0x0100, 0x1482: 0x0100, 0x1483: 0x0100, 0x1484: 0x0100, 0x1485: 0x0100,
	0x1486: 0x0100, 0x1487: 0x0100, 0x1488: 0x0100, 0x1489: 0x0100, 0x148a: 0x0100, 0x148b: 0x0100,
	0x148c: 0x0100, 0x148d: 0x0100, 0x148e: 0x0100, 0x148f: 0x0100, 0x1490: 0x0100, 0x1491: 0x0100,
	0x1492: 0x0100, 0x1493: 0x0100, 0x1494: 0x0100, 0x1495: 0x0100, 0x1496: 0x0100, 0x1497: 0x0100,
	0x1498: 0x0100, 0x1499: 0x0100, 0x149a: 0x0100, 0x149b: 0x0100, 0x149c: 0x0100, 0x149d: 0x0100,
	0x149e: 0x0100, 0x149f: 0x0100, 0x14a0: 0x0100, 0x14a1: 0x0100, 0x14a2: 0x0100, 0x14a3: 0x0100,
	0x14a4: 0x0100, 0x14a5: 0x0100, 0x14a6: 0x0100, 0x14a7: 0x0100, 0x14a8: 0x0100, 0x14a9: 0x0100,
	0x14aa: 0x0100, 0x14ab: 0x0100, 0x14ac: 0x0100, 0x14ad: 0x0100, 0x14ae: 0x0100, 0x14af: 0x0100,
	0x14b0: 0x0100, 0x14b1: 0x0100, 0x14b2: 0x0100, 0x14b3: 0x0100, 0x14b4: 0x0008, 0x14b5: 0x0008,
	0x14b6: 0x0008, 0x14b7: 0x0008, 0x14b8: 0x0008, 0x14b9: 0x0008, 0x14ba: 0x0008, 0x14bb: 0x0008,
	0x14bc: 0x0008, 0x14bd: 0x0008, 0x14be: 0x0008, 0x14bf: 0x0008,
	// Block 0x53, offset 0x14c0
	0x14c0: 0x0008, 0x14c1: 0x0008, 0x14c2: 0x0008, 0x14c3: 0x0008, 0x14c4: 0x0008, 0x14c5: 0x0008,
	0x14c6: 0x0008, 0x14c7: 0x0008, 0x14c8: 0x0008, 0x14c9: 0x0008, 0x14ca: 0x0008, 0x14cb: 0x0008,
	0x14cc: 0x0008, 0x14cd: 0x0008, 0x14ce: 0x0008, 0x14cf: 0x0008, 0x14d0: 0x0008, 0x14d1: 0x0008,
	0x14d2: 0x0008, 0x14d3: 0x0008, 0x14d7: 0x0100,
	0x14dc: 0x0100, 0x14dd: 0x0008,
	0x14e0: 0x0080, 0x14e1: 0x0080, 0x14e2: 0x0080, 0x14e3: 0x0080,
	0x14e4: 0x0080, 0x14e5: 0x0080, 0x14e6: 0x0080, 0x14e7: 0x0080, 0x14e8: 0x0080, 0x14e9: 0x0080,
	// Block 0x54, offset 0x1500
	0x1502: 0x0200, 0x1503: 0x0400,
	0x1508: 0x0200, 0x1509: 0x0400, 0x150b: 0x0008,
	0x150c: 0x0008, 0x150d: 0x0008, 0x150e: 0x0010, 0x150f: 0x0008, 0x1510: 0x0080, 0x1511: 0x0080,
	0x1512: 0x0080, 0x1513: 0x0080, 0x1514: 0x0080, 0x1515: 0x0080, 0x1516: 0x0080, 0x1517: 0x0080,
	0x1518: 0x0080, 0x1519: 0x0080,
	0x1520: 0x0100, 0x1521: 0x0100, 0x1522: 0x0100, 0x1523: 0x0100,
	0x1524: 0x0100, 0x1525: 0x0100, 0x1526: 0x0100, 0x1527: 0x0100, 0x1528: 0x0100, 0x1529: 0x0100,
	0x152a: 0x0100, 0x152b: 0x0100, 0x152c: 0x0100, 0x152d: 0x0100, 0x152e: 0x0100, 0x152f: 0x0100,
	0x1530: 0x0100, 0x1531: 0x0100, 0x1532: 0x0100, 0x1533: 0x0100, 0x1534: 0x0100, 0x1535: 0x0100,
	0x1536: 0x0100, 0x1537: 0x0100, 0x1538: 0x0100, 0x1539: 0x0100, 0x153a: 0x0100, 0x153b: 0x0100,
	0x153c: 0x0100, 0x153d: 0x0100, 0x153e: 0x0100, 0x153f: 0x0100,
	// Block 0x55, offset 0x1540
	0x1540: 0x0100, 0x1541: 0x0100, 0x1542: 0x0100, 0x1543: 0x0100, 0x1544: 0x0100, 0x1545: 0x0100,
	0x1546: 0x0100, 0x1547: 0x0100, 0x1548: 0x0100, 0x1549: 0x0100, 0x154a: 0x0100, 0x154b: 0x0100,
	0x154c: 0x0100, 0x154d: 0x0100, 0x154e: 0x0100, 0x154f: 0x0100, 0x1550: 0x0100, 0x1551: 0x0100,
	0x1552: 0x0100, 0x1553: 0x0100, 0x1554: 0x0100, 0x1555: 0x0100, 0x1556: 0x0100, 0x1557: 0x0100,
	0x1558: 0x0100, 0x1559: 0x0100, 0x155a: 0x0100, 0x155b: 0x0100, 0x155c: 0x0100, 0x155d: 0x0100,
	0x155e: 0x0100, 0x155f: 0x0100, 0x1560: 0x0100, 0x1561: 0x0100, 0x1562: 0x0100, 0x1563: 0x0100,
	0x1564: 0x0100, 0x1565: 0x0100, 0x1566: 0x0100, 0x1567: 0x0100, 0x1568: 0x0100, 0x1569: 0x0100,
	0x156a: 0x0100, 0x156b: 0x0100, 0x156c: 0x0100, 0x156d: 0x0100, 0x156e: 0x0100, 0x156f: 0x0100,
	0x1570: 0x0100, 0x1571: 0x0100, 0x1572: 0x0100, 0x1573: 0x0100, 0x1574: 0x0100, 0x1575: 0x0100,
	0x1576: 0x0100, 0x1577: 0x0100, 0x1578: 0x0100,
	// Block 0x56, offset 0x1580
	0x1580: 0x0100, 0x1581: 0x0100, 0x1582: 0x0100, 0x1583: 0x0100, 0x1584: 0x0100, 0x1585: 0x0008,
	0x1586: 0x0008, 0x1587: 0x0100, 0x1588: 0x0100, 0x1589: 0x0100, 0x158a: 0x0100, 0x158b: 0x0100,
	0x158c: 0x0100, 0x158d: 0x0100, 0x158e: 0x0100, 0x158f: 0x0100, 0x1590: 0x0100, 0x1591: 0x0100,
	0x1592: 0x0100, 0x1593: 0x0100, 0x1594: 0x0100, 0x1595: 0x0100, 0x1596: 0x0100, 0x1597: 0x0100,
	0x1598: 0x0100, 0x1599: 0x0100, 0x159a: 0x0100, 0x159b: 0x0100, 0x159c: 0x0100, 0x159d: 0x0100,
	0x159e: 0x0100, 0x159f: 0x0100, 0x15a0: 0x0100, 0x15a1: 0x0100, 0x15a2: 0x0100, 0x15a3: 0x0100,
	0x15a4: 0x0100, 0x15a5: 0x0100, 0x15a6: 0x0100, 0x15a7: 0x0100, 0x15a8: 0x0100, 0x15a9: 0x0008,
	0x15aa: 0x0100,
	0x15b0: 0x0100, 0x15b1: 0x0100, 0x15b2: 0x0100, 0x15b3: 0x0100, 0x15b4: 0x0100, 0x15b5: 0x0100,
	0x15b6: 0x0100, 0x15b7: 0x0100, 0x15b8: 0x0100, 0x15b9: 0x0100, 0x15ba: 0x0100, 0x15bb: 0x0100,
	0x15bc: 0x0100, 0x15bd: 0x0100, 0x15be: 0x0100, 0x15bf: 0x0100,
	// Block 0x57, offset 0x15c0
	0x15c0: 0x0100, 0x15c1: 0x0100, 0x15c2: 0x0100, 0x15c3: 0x0100, 0x15c4: 0x0100, 0x15c5: 0x0100,
	0x15c6: 0x0100, 0x15c7: 0x0100, 0x15c8: 0x0100, 0x15c9: 0x0100, 0x15ca: 0x0100, 0x15cb: 0x0100,
	0x15cc: 0x0100, 0x15cd: 0x0100, 0x15ce: 0x0100, 0x15cf: 0x0100, 0x15d0: 0x0100, 0x15d1: 0x0100,
	0x15d2: 0x0100, 0x15d3: 0x0100, 0x15d4: 0x0100, 0x15d5: 0x0100, 0x15d6: 0x0100, 0x15d7: 0x0100,
	0x15d8: 0x0100, 0x15d9: 0x0100, 0x15da: 0x0100, 0x15db: 0x0100, 0x15dc: 0x0100, 0x15dd: 0x0100,
	0x15de: 0x0100, 0x15df: 0x0100, 0x15e0: 0x0100, 0x15e1: 0x0100, 0x15e2: 0x0100, 0x15e3: 0x0100,
	0x15e4: 0x0100, 0x15e5: 0x0100, 0x15e6: 0x0100, 0x15e7: 0x0100, 0x15e8: 0x0100, 0x15e9: 0x0100,
	0x15ea: 0x0100, 0x15eb: 0x0100, 0x15ec: 0x0100, 0x15ed: 0x0100, 0x15ee: 0x0100, 0x15ef: 0x0100,
	0x15f0: 0x0100, 0x15f1: 0x0100, 0x15f2: 0x0100, 0x15f3: 0x0100, 0x15f4: 0x0100, 0x15f5: 0x0100,
	// Block 0x58, offset 0x1600
	0x1600: 0x0100, 0x1601: 0x0100, 0x1602: 0x0100, 0x1603: 0x0100, 0x1604: 0x0100, 0x1605: 0x0100,
	0x1606: 0x0100, 0x1607: 0x0100, 0x1608: 0x0100, 0x1609: 0x0100, 0x160a: 0x0100, 0x160b: 0x0100,
	0x160c: 0x0100, 0x160d: 0x0100, 0x160e: 0x0100, 0x160f: 0x0100, 0x1610: 0x0100, 0x1611: 0x0100,
	0x1612: 0x0100, 0x1613: 0x0100, 0x1614: 0x0100, 0x1615: 0x0100, 0x1616: 0x0100, 0x1617: 0x0100,
	0x1618: 0x0100, 0x1619: 0x0100, 0x161a: 0x0100, 0x161b: 0x0100, 0x161c: 0x0100, 0x161d: 0x0100,
	0x161e: 0x0100, 0x1620: 0x0008, 0x1621: 0x0008, 0x1622: 0x0008, 0x1623: 0x0008,
	0x1624: 0x0008, 0x1625: 0x0008, 0x1626: 0x0008, 0x1627: 0x0008, 0x1628: 0x0008, 0x1629: 0x0008,
	0x162a: 0x0008, 0x162b: 0x0008,
	0x1630: 0x0008, 0x1631: 0x0008, 0x1632: 0x0008, 0x1633: 0x0008, 0x1634: 0x0008, 0x1635: 0x0008,
	0x1636: 0x0008, 0x1637: 0x0008, 0x1638: 0x0008, 0x1639: 0x0008, 0x163a: 0x0008, 0x163b: 0x0008,
	// Block 0x59, offset 0x1640
	0x1644: 0x0400, 0x1645: 0x0400,
	0x1646: 0x0080, 0x1647: 0x0080, 0x1648: 0x0080, 0x1649: 0x0080, 0x164a: 0x0080, 0x164b: 0x0080,
	0x164c: 0x0080, 0x164d: 0x0080, 0x164e: 0x0080, 0x164f: 0x0080, 0x1650: 0x0100, 0x1651: 0x0100,
	0x1652: 0x0100, 0x1653: 0x0100, 0x1654: 0x0100, 0x1655: 0x0100, 0x1656: 0x0100, 0x1657: 0x0100,
	0x1658: 0x0100, 0x1659: 0x0100, 0x165a: 0x0100, 0x165b: 0x0100, 0x165c: 0x0100, 0x165d: 0x0100,
	0x165e: 0x0100, 0x165f: 0x0100, 0x1660: 0x0100, 0x1661: 0x0100, 0x1662: 0x0100, 0x1663: 0x0100,
	0x1664: 0x0100, 0x1665: 0x0100, 0x1666: 0x0100, 0x1667: 0x0100, 0x1668: 0x0100, 0x1669: 0x0100,
	0x166a: 0x0100, 0x166b: 0x0100, 0x166c: 0x0100, 0x166d: 0x0100,
	0x1670: 0x0100, 0x1671: 0x0100, 0x1672: 0x0100, 0x1673: 0x0100, 0x1674: 0x0100,
	// Block 0x5a, offset 0x1680
	0x1680: 0x0100, 0x1681: 0x0100, 0x1682: 0x0100, 0x1683: 0x0100, 0x1684: 0x0100, 0x1685: 0x0100,
	0x1686: 0x0100, 0x1687: 0x0100, 0x1688: 0x0100, 0x1689: 0x0100, 0x168a: 0x0100, 0x168b: 0x0100,
	0x168c: 0x0100, 0x168d: 0x0100, 0x168e: 0x0100, 0x168f: 0x0100, 0x1690: 0x0100, 0x1691: 0x0100,
	0x1692: 0x0100, 0x1693: 0x0100, 0x1694: 0x0100, 0x1695: 0x0100, 0x1696: 0x0100, 0x1697: 0x0100,
	0x1698: 0x0100, 0x1699: 0x0100, 0x169a: 0x0100, 0x169b: 0x0100, 0x169c: 0x0100, 0x169d: 0x0100,
	0x169e: 0x0100, 0x169f: 0x0100, 0x16a0: 0x0100, 0x16a1: 0x0100, 0x16a2: 0x0100, 0x16a3: 0x0100,
	0x16a4: 0x0100, 0x16a5: 0x0100, 0x16a6: 0x0100, 0x16a7: 0x0100, 0x16a8: 0x0100, 0x16a9: 0x0100,
	0x16aa: 0x0100, 0x16ab: 0x0100,
	0x16b0: 0x0100, 0x16b1: 0x0100, 0x16b2: 0x0100, 0x16b3: 0x0100, 0x16b4: 0x0100, 0x16b5: 0x0100,
	0x16b6: 0x0100, 0x16b7: 0x0100, 0x16b8: 0x0100, 0x16b9: 0x0100, 0x16ba: 0x0100, 0x16bb: 0x0100,
	0x16bc: 0x0100, 0x16bd: 0x0100, 0x16be: 0x0100, 0x16bf: 0x0100,
	// Block 0x5b, offset 0x16c0
	0x16c0: 0x0100, 0x16c1: 0x0100, 0x16c2: 0x0100, 0x16c3: 0x0100, 0x16c4: 0x0100, 0x16c5: 0x0100,
	0x16c6: 0x0100, 0x16c7: 0x0100, 0x16c8: 0x0100, 0x16c9: 0x0100,
	0x16d0: 0x0080, 0x16d1: 0x0080,
	0x16d2: 0x0080, 0x16d3: 0x0080, 0x16d4: 0x0080, 0x16d5: 0x0080, 0x16d6: 0x0080, 0x16d7: 0x0080,
	0x16d8: 0x0080, 0x16d9: 0x0080,
	// Block 0x5c, offset 0x1700
	0x1700: 0x0100, 0x1701: 0x0100, 0x1702: 0x0100, 0x1703: 0x0100, 0x1704: 0x0100, 0x1705: 0x0100,
	0x1706: 0x0100, 0x1707: 0x0100, 0x1708: 0x0100, 0x1709: 0x0100, 0x170a: 0x0100, 0x170b: 0x0100,
	0x170c: 0x0100, 0x170d: 0x0100, 0x170e: 0x0100, 0x170f: 0x0100, 0x1710: 0x0100, 0x1711: 0x0100,
	0x1712: 0x0100, 0x1713: 0x0100, 0x1714: 0x0100, 0x1715: 0x0100, 0x1716: 0x0100, 0x1717: 0x0008,
	0x1718: 0x0008, 0x1719: 0x0008, 0x171a: 0x0008, 0x171b: 0x0008,
	0x1720: 0x0100, 0x1721: 0x0100, 0x1722: 0x0100, 0x1723: 0x0100,
	0x1724: 0x0100, 0x1725: 0x0100, 0x1726: 0x0100, 0x1727: 0x0100, 0x1728: 0x0100, 0x1729: 0x0100,
	0x172a: 0x0100, 0x172b: 0x0100, 0x172c: 0x0100, 0x172d: 0x0100, 0x172e: 0x0100, 0x172f: 0x0100,
	0x1730: 0x0100, 0x1731: 0x0100, 0x1732: 0x0100, 0x1733: 0x0100, 0x1734: 0x0100, 0x1735: 0x0100,
	0x1736: 0x0100, 0x1737: 0x0100, 0x1738: 0x0100, 0x1739: 0x0100, 0x173a: 0x0100, 0x173b: 0x0100,
	0x173c: 0x0100, 0x173d: 0x0100, 0x173e: 0x0100, 0x173f: 0x0100,
	// Block 0x5d, offset 0x1740
	0x1740: 0x0100, 0x1741: 0x0100, 0x1742: 0x0100, 0x1743: 0x0100, 0x1744: 0x0100, 0x1745: 0x0100,
	0x1746: 0x0100, 0x1747: 0x0100, 0x1748: 0x0100, 0x1749: 0x0100, 0x174a: 0x0100, 0x174b: 0x0100,
	0x174c: 0x0100, 0x174d: 0x0100, 0x174e: 0x0100, 0x174f: 0x0100, 0x1750: 0x0100, 0x1751: 0x0100,
	0x1752: 0x0100, 0x1753: 0x0100, 0x1754: 0x0100, 0x1755: 0x0008, 0x1756: 0x0008, 0x1757: 0x0008,
	0x1758: 0x0008, 0x1759: 0x0008, 0x175a: 0x0008, 0x175b: 0x0008, 0x175c: 0x0008, 0x175d: 0x0008,
	0x175e: 0x0008, 0x1760: 0x0008, 0x1761: 0x0008, 0x1762: 0x0008, 0x1763: 0x0008,
	0x1764: 0x0008, 0x1765: 0x0008, 0x1766: 0x0008, 0x1767: 0x0008, 0x1768: 0x0008, 0x1769: 0x0008,
	0x176a: 0x0008, 0x176b: 0x0008, 0x176c: 0x0008, 0x176d: 0x0008, 0x176e: 0x0008, 0x176f: 0x0008,
	0x1770: 0x0008, 0x1771: 0x0008, 0x1772: 0x0008, 0x1773: 0x0008, 0x1774: 0x0008, 0x1775: 0x0008,
	0x1776: 0x0008, 0x1777: 0x0008, 0x1778: 0x0008, 0x1779: 0x0008, 0x177a: 0x0008, 0x177b: 0x0008,
	0x177c: 0x0008, 0x177f: 0x0008,
	// Block 0x5e, offset 0x1780
	0x1780: 0x0080, 0x1781: 0x0080, 0x1782: 0x0080, 0x1783: 0x0080, 0x1784: 0x0080, 0x1785: 0x0080,
	0x1786: 0x0080, 0x1787: 0x0080, 0x1788: 0x0080, 0x1789: 0x0080,
	0x1790: 0x0080, 0x1791: 0x0080,
	0x1792: 0x0080, 0x1793: 0x0080, 0x1794: 0x0080, 0x1795: 0x0080, 0x1796: 0x0080, 0x1797: 0x0080,
	0x1798: 0x0080, 0x1799: 0x0080,
	0x17a7: 0x0100, 0x17a8: 0x0400, 0x17a9: 0x0400,
	0x17aa: 0x0400, 0x17ab: 0x0400,
	0x17b0: 0x0008, 0x17b1: 0x0008, 0x17b2: 0x0008, 0x17b3: 0x0008, 0x17b4: 0x0008, 0x17b5: 0x0008,
	0x17b6: 0x0008, 0x17b7: 0x0008, 0x17b8: 0x0008, 0x17b9: 0x0008, 0x17ba: 0x0008, 0x17bb: 0x0008,
	0x17bc: 0x0008, 0x17bd: 0x0008, 0x17be: 0x0008, 0x17bf: 0x0008,
	// Block 0x5f, offset 0x17c0
	0x17c0: 0x0008, 0x17c1: 0x0008, 0x17c2: 0x0008, 0x17c3: 0x0008, 0x17c4: 0x0008, 0x17c5: 0x0008,
	0x17c6: 0x0008, 0x17c7: 0x0008, 0x17c8: 0x0008, 0x17c9: 0x0008, 0x17ca: 0x0008, 0x17cb: 0x0008,
	0x17cc: 0x0008, 0x17cd: 0x0008, 0x17ce: 0x0008,
	// Block 0x60, offset 0x1800
	0x1800: 0x0008, 0x1801: 0x0008, 0x1802: 0x0008, 0x1803: 0x0008, 0x1804: 0x0008, 0x1805: 0x0100,
	0x1806: 0x0100, 0x1807: 0x0100, 0x1808: 0x0100, 0x1809: 0x0100, 0x180a: 0x0100, 0x180b: 0x0100,
	0x180c: 0x0100, 0x180d: 0x0100, 0x180e: 0x0100, 0x180f: 0x0100, 0x1810: 0x0100, 0x1811: 0x0100,
	0x1812: 0x0100, 0x1813: 0x0100, 0x1814: 0x0100, 0x1815: 0x0100, 0x1816: 0x0100, 0x1817: 0x0100,
	0x1818: 0x0100, 0x1819: 0x0100, 0x181a: 0x0100, 0x181b: 0x0100, 0x181c: 0x0100, 0x181d: 0x0100,
	0x181e: 0x0100, 0x181f: 0x0100, 0x1820: 0x0100, 0x1821: 0x0100, 0x1822: 0x0100, 0x1823: 0x0100,
	0x1824: 0x0100, 0x1825: 0x0100, 0x1826: 0x0100, 0x1827: 0x0100, 0x1828: 0x0100, 0x1829: 0x0100,
	0x182a: 0x0100, 0x182b: 0x0100, 0x182c: 0x0100, 0x182d: 0x0100, 0x182e: 0x0100, 0x182f: 0x0100,
	0x1830: 0x0100, 0x1831: 0x0100, 0x1832: 0x0100, 0x1833: 0x0100, 0x1834: 0x0008, 0x1835: 0x0008,
	0x1836: 0x0008, 0x1837: 0x0008, 0x1838: 0x0008, 0x1839: 0x0008, 0x183a: 0x0008, 0x183b: 0x0008,
	0x183c: 0x0008, 0x183d: 0x0008, 0x183e: 0x0008, 0x183f: 0x0008,
	// Block 0x61, offset 0x1840
	0x1840: 0x0008, 0x1841: 0x0008, 0x1842: 0x0008, 0x1843: 0x0008, 0x1844: 0x0008, 0x1845: 0x0100,
	0x1846: 0x0100, 0x1847: 0x0100, 0x1848: 0x0100, 0x1849: 0x0100, 0x184a: 0x0100, 0x184b: 0x0100,
	0x184c: 0x0100, 0x1850: 0x0080, 0x1851: 0x0080,
	0x1852: 0x0080, 0x1853: 0x0080, 0x1854: 0x0080, 0x1855: 0x0080, 0x1856: 0x0080, 0x1857: 0x0080,
	0x1858: 0x0080, 0x1859: 0x0080, 0x185a: 0x0400, 0x185b: 0x0400,
	0x185e: 0x0400, 0x185f: 0x0400,
	0x186b: 0x0008, 0x186c: 0x0008, 0x186d: 0x0008, 0x186e: 0x0008, 0x186f: 0x0008,
	0x1870: 0x0008, 0x1871: 0x0008, 0x1872: 0x0008, 0x1873: 0x0008,
	0x187d: 0x0400, 0x187e: 0x0400,
	// Block 0x62, offset 0x1880
	0x1880: 0x0008, 0x1881: 0x0008, 0x1882: 0x0008, 0x1883: 0x0100, 0x1884: 0x0100, 0x1885: 0x0100,
	0x1886: 0x0100, 0x1887: 0x0100, 0x1888: 0x0100, 0x1889: 0x0100, 0x188a: 0x0100, 0x188b: 0x0100,
	0x188c: 0x0100, 0x188d: 0x0100, 0x188e: 0x0100, 0x188f: 0x0100, 0x1890: 0x0100, 0x1891: 0x0100,
	0x1892: 0x0100, 0x1893: 0x0100, 0x1894: 0x0100, 0x1895: 0x0100, 0x1896: 0x0100, 0x1897: 0x0100,
	0x1898: 0x0100, 0x1899: 0x0100, 0x189a: 0x0100, 0x189b: 0x0100, 0x189c: 0x0100, 0x189d: 0x0100,
	0x189e: 0x0100, 0x189f: 0x0100, 0x18a0: 0x0100, 0x18a1: 0x0008, 0x18a2: 0x0008, 0x18a3: 0x0008,
	0x18a4: 0x0008, 0x18a5: 0x0008, 0x18a6: 0x0008, 0x18a7: 0x0008, 0x18a8: 0x0008, 0x18a9: 0x0008,
	0x18aa: 0x0008, 0x18ab: 0x0008, 0x18ac: 0x0008, 0x18ad: 0x0008, 0x18ae: 0x0100, 0x18af: 0x0100,
	0x18b0: 0x0080, 0x18b1: 0x0080, 0x18b2: 0x0080, 0x18b3: 0x0080, 0x18b4: 0x0080, 0x18b5: 0x0080,
	0x18b6: 0x0080, 0x18b7: 0x0080, 0x18b8: 0x0080, 0x18b9: 0x0080, 0x18ba: 0x0100, 0x18bb: 0x0100,
	0x18bc: 0x0100, 0x18bd: 0x0100, 0x18be: 0x0100, 0x18bf: 0x0100,
	// Block 0x63, offset 0x18c0
	0x18c0: 0x0100, 0x18c1: 0x0100, 0x18c2: 0x0100, 0x18c3: 0x0100, 0x18c4: 0x0100, 0x18c5: 0x0100,
	0x18c6: 0x0100, 0x18c7: 0x0100, 0x18c8: 0x0100, 0x18c9: 0x0100, 0x18ca: 0x0100, 0x18cb: 0x0100,
	0x18cc: 0x0100, 0x18cd: 0x0100, 0x18ce: 0x0100, 0x18cf: 0x0100, 0x18d0: 0x0100, 0x18d1: 0x0100,
	0x18d2: 0x0100, 0x18d3: 0x0100, 0x18d4: 0x0100, 0x18d5: 0x0100, 0x18d6: 0x0100, 0x18d7: 0x0100,
	0x18d8: 0x0100, 0x18d9: 0x0100, 0x18da: 0x0100, 0x18db: 0x0100, 0x18dc: 0x0100, 0x18dd: 0x0100,
	0x18de: 0x0100, 0x18df: 0x0100, 0x18e0: 0x0100, 0x18e1: 0x0100, 0x18e2: 0x0100, 0x18e3: 0x0100,
	0x18e4: 0x0100, 0x18e5: 0x0100, 0x18e6: 0x0008, 0x18e7: 0x0008, 0x18e8: 0x0008, 0x18e9: 0x0008,
	0x18ea: 0x0008, 0x18eb: 0x0008, 0x18ec: 0x0008, 0x18ed: 0x0008, 0x18ee: 0x0008, 0x18ef: 0x0008,
	0x18f0: 0x0008, 0x18f1: 0x0008, 0x18f2: 0x0008, 0x18f3: 0x0008,
	// Block 0x64, offset 0x1900
	0x1900: 0x0100, 0x1901: 0x0100, 0x1902: 0x0100, 0x1903: 0x0100, 0x1904: 0x0100, 0x1905: 0x0100,
	0x1906: 0x0100, 0x1907: 0x0100, 0x1908: 0x0100, 0x1909: 0x0100, 0x190a: 0x0100, 0x190b: 0x0100,
	0x190c: 0x0100, 0x190d: 0x0100, 0x190e: 0x0100, 0x190f: 0x0100, 0x1910: 0x0100, 0x1911: 0x0100,
	0x1912: 0x0100, 0x1913: 0x0100, 0x1914: 0x0100, 0x1915: 0x0100, 0x1916: 0x0100, 0x1917: 0x0100,
	0x1918: 0x0100, 0x1919: 0x0100, 0x191a: 0x0100, 0x191b: 0x0100, 0x191c: 0x0100, 0x191d: 0x0100,
	0x191e: 0x0100, 0x191f: 0x0100, 0x1920: 0x0100, 0x1921: 0x0100, 0x1922: 0x0100, 0x1923: 0x0100,
	0x1924: 0x0008, 0x1925: 0x0008, 0x1926: 0x0008, 0x1927: 0x0008, 0x1928: 0x0008, 0x1929: 0x0008,
	0x192a: 0x0008, 0x192b: 0x0008, 0x192c: 0x0008, 0x192d: 0x0008, 0x192e: 0x0008, 0x192f: 0x0008,
	0x1930: 0x0008, 0x1931: 0x0008, 0x1932: 0x0008, 0x1933: 0x0008, 0x1934: 0x0008, 0x1935: 0x0008,
	0x1936: 0x0008, 0x1937: 0x0008, 0x193b: 0x0400,
	0x193c: 0x0400,
	// Block 0x65, offset 0x1940
	0x1940: 0x0080, 0x1941: 0x0080, 0x1942: 0x0080, 0x1943: 0x0080, 0x1944: 0x0080, 0x1945: 0x0080,
	0x1946: 0x0080, 0x1947: 0x0080, 0x1948: 0x0080, 0x1949: 0x0080,
	0x194d: 0x0100, 0x194e: 0x0100, 0x194f: 0x0100, 0x1950: 0x0080, 0x1951: 0x0080,
	0x1952: 0x0080, 0x1953: 0x0080, 0x1954: 0x0080, 0x1955: 0x0080, 0x1956: 0x0080, 0x1957: 0x0080,
	0x1958: 0x0080, 0x1959: 0x0080, 0x195a: 0x0100, 0x195b: 0x0100, 0x195c: 0x0100, 0x195d: 0x0100,
	0x195e: 0x0100, 0x195f: 0x0100, 0x1960: 0x0100, 0x1961: 0x0100, 0x1962: 0x0100, 0x1963: 0x0100,
	0x1964: 0x0100, 0x1965: 0x0100, 0x1966: 0x0100, 0x1967: 0x0100, 0x1968: 0x0100, 0x1969: 0x0100,
	0x196a: 0x0100, 0x196b: 0x0100, 0x196c: 0x0100, 0x196d: 0x0100, 0x196e: 0x0100, 0x196f: 0x0100,
	0x1970: 0x0100, 0x1971: 0x0100, 0x1972: 0x0100, 0x1973: 0x0100, 0x1974: 0x0100, 0x1975: 0x0100,
	0x1976: 0x0100, 0x1977: 0x0100, 0x1978: 0x0100, 0x1979: 0x0100, 0x197a: 0x0100, 0x197b: 0x0100,
	0x197c: 0x0100, 0x197d: 0x0100, 0x197e: 0x0400, 0x197f: 0x0400,
	// Block 0x66, offset 0x1980
	0x1980: 0x0040, 0x1981: 0x0040, 0x1982: 0x0040, 0x1983: 0x0040, 0x1984: 0x0040, 0x1985: 0x0040,
	0x1986: 0x0040, 0x1987: 0x0040, 0x1988: 0x0040,
	0x1990: 0x0100, 0x1991: 0x0100,
	0x1992: 0x0100, 0x1993: 0x0100, 0x1994: 0x0100, 0x1995: 0x0100, 0x1996: 0x0100, 0x1997: 0x0100,
	0x1998: 0x0100, 0x1999: 0x0100, 0x199a: 0x0100, 0x199b: 0x0100, 0x199c: 0x0100, 0x199d: 0x0100,
	0x199e: 0x0100, 0x199f: 0x0100, 0x19a0: 0x0100, 0x19a1: 0x0100, 0x19a2: 0x0100, 0x19a3: 0x0100,
	0x19a4: 0x0100, 0x19a5: 0x0100, 0x19a6: 0x0100, 0x19a7: 0x0100, 0x19a8: 0x0100, 0x19a9: 0x0100,
	0x19aa: 0x0100, 0x19ab: 0x0100, 0x19ac: 0x0100, 0x19ad: 0x0100, 0x19ae: 0x0100, 0x19af: 0x0100,
	0x19b0: 0x0100, 0x19b1: 0x0100, 0x19b2: 0x0100, 0x19b3: 0x0100, 0x19b4: 0x0100, 0x19b5: 0x0100,
	0x19b6: 0x0100, 0x19b7: 0x0100, 0x19b8: 0x0100, 0x19b9: 0x0100, 0x19ba: 0x0100,
	0x19bd: 0x0100, 0x19be: 0x0100, 0x19bf: 0x0100,
	// Block 0x67, offset 0x19c0
	0x19d0: 0x0008, 0x19d1: 0x0008,
	0x19d2: 0x0008, 0x19d4: 0x0008, 0x19d5: 0x0008, 0x19d6: 0x0008, 0x19d7: 0x0008,
	0x19d8: 0x0008, 0x19d9: 0x0008, 0x19da: 0x0008, 0x19db: 0x0008, 0x19dc: 0x0008, 0x19dd: 0x0008,
	0x19de: 0x0008, 0x19df: 0x0008, 0x19e0: 0x0008, 0x19e1: 0x0008, 0x19e2: 0x0008, 0x19e3: 0x0008,
	0x19e4: 0x0008, 0x19e5: 0x0008, 0x19e6: 0x0008, 0x19e7: 0x0008, 0x19e8: 0x0008, 0x19e9: 0x0100,
	0x19ea: 0x0100, 0x19eb: 0x0100, 0x19ec: 0x0100, 0x19ed: 0x0008, 0x19ee: 0x0100, 0x19ef: 0x0100,
	0x19f0: 0x0100, 0x19f1: 0x0100, 0x19f2: 0x0100, 0x19f3: 0x0100, 0x19f4: 0x0008, 0x19f5: 0x0100,
	0x19f6: 0x0100, 0x19f7: 0x0008, 0x19f8: 0x0008, 0x19f9: 0x0008, 0x19fa: 0x0100,
	// Block 0x68, offset 0x1a00
	0x1a00: 0x0040, 0x1a01: 0x0040, 0x1a02: 0x0040, 0x1a03: 0x0040, 0x1a04: 0x0040, 0x1a05: 0x0040,
	0x1a06: 0x0040, 0x1a07: 0x0040, 0x1a08: 0x0040, 0x1a09: 0x0040, 0x1a0a: 0x0040, 0x1a0b: 0x0040,
	0x1a0c: 0x0040, 0x1a0d: 0x0040, 0x1a0e: 0x0040, 0x1a0f: 0x0040, 0x1a10: 0x0040, 0x1a11: 0x0040,
	0x1a12: 0x0040, 0x1a13: 0x0040, 0x1a14: 0x0040, 0x1a15: 0x0040, 0x1a16: 0x0040, 0x1a17: 0x0040,
	0x1a18: 0x0040, 0x1a19: 0x0040, 0x1a1a: 0x0040, 0x1a1b: 0x0040, 0x1a1c: 0x0040, 0x1a1d: 0x0040,
	0x1a1e: 0x0040, 0x1a1f: 0x0040, 0x1a20: 0x0040, 0x1a21: 0x0040, 0x1a22: 0x0040, 0x1a23: 0x0040,
	0x1a24: 0x0040, 0x1a25: 0x0040, 0x1a26: 0x0040, 0x1a27: 0x0040, 0x1a28: 0x0040, 0x1a29: 0x0040,
	0x1a2a: 0x0040, 0x1a2b: 0x0040, 0x1a2c: 0x0040, 0x1a2d: 0x0040, 0x1a2e: 0x0040, 0x1a2f: 0x0040,
	0x1a30: 0x0040, 0x1a31: 0x0040, 0x1a32: 0x0040, 0x1a33: 0x0040, 0x1a34: 0x0040, 0x1a35: 0x0040,
	0x1a36: 0x0040, 0x1a37: 0x0040, 0x1a38: 0x0040, 0x1a39: 0x0040, 0x1a3a: 0x0040, 0x1a3b: 0x0040,
	0x1a3c: 0x0040, 0x1a3d: 0x0040, 0x1a3e: 0x0040, 0x1a3f: 0x0040,
	// Block 0x69, offset 0x1a40
	0x1a40: 0x2000, 0x1a41: 0x0040, 0x1a42: 0x2000, 0x1a43: 0x0040, 0x1a44: 0x2000, 0x1a45: 0x0040,
	0x1a46: 0x2000, 0x1a47: 0x0040, 0x1a48: 0x2000, 0x1a49: 0x0040, 0x1a4a: 0x2000, 0x1a4b: 0x0040,
	0x1a4c: 0x2000, 0x1a4d: 0x0040, 0x1a4e: 0x2000, 0x1a4f: 0x0040, 0x1a50: 0x2000, 0x1a51: 0x0040,
	0x1a52: 0x2000, 0x1a53: 0x0040, 0x1a54: 0x2000, 0x1a55: 0x0040, 0x1a56: 0x2000, 0x1a57: 0x0040,
	0x1a58: 0x2000, 0x1a59: 0x0040, 0x1a5a: 0x2000, 0x1a5b: 0x0040, 0x1a5c: 0x2000, 0x1a5d: 0x0040,
	0x1a5e: 0x2000, 0x1a5f: 0x0040, 0x1a60: 0x2000, 0x1a61: 0x0040, 0x1a62: 0x2000, 0x1a63: 0x0040,
	0x1a64: 0x2000, 0x1a65: 0x0040, 0x1a66: 0x2000, 0x1a67: 0x0040, 0x1a68: 0x2000, 0x1a69: 0x0040,
	0x1a6a: 0x2000, 0x1a6b: 0x0040, 0x1a6c: 0x2000, 0x1a6d: 0x0040, 0x1a6e: 0x2000, 0x1a6f: 0x0040,
	0x1a70: 0x2000, 0x1a71: 0x0040, 0x1a72: 0x2000, 0x1a73: 0x0040, 0x1a74: 0x2000, 0x1a75: 0x0040,
	0x1a76: 0x2000, 0x1a77: 0x0040, 0x1a78: 0x2000, 0x1a79: 0x0040, 0x1a7a: 0x2000, 0x1a7b: 0x0040,
	0x1a7c: 0x2000, 0x1a7d: 0x0040, 0x1a7e: 0x2000, 0x1a7f: 0x0040,
	// Block 0x6a, offset 0x1a80
	0x1a80: 0x2000, 0x1a81: 0x0040, 0x1a82: 0x2000, 0x1a83: 0x0040, 0x1a84: 0x2000, 0x1a85: 0x0040,
	0x1a86: 0x2000, 0x1a87: 0x0040, 0x1a88: 0x2000, 0x1a89: 0x0040, 0x1a8a: 0x2000, 0x1a8b: 0x0040,
	0x1a8c: 0x2000, 0x1a8d: 0x0040, 0x1a8e: 0x2000, 0x1a8f: 0x0040, 0x1a90: 0x2000, 0x1a91: 0x0040,
	0x1a92: 0x2000, 0x1a93: 0x0040, 0x1a94: 0x2000, 0x1a95: 0x0040, 0x1a96: 0x0040, 0x1a97: 0x0040,
	0x1a98: 0x0040, 0x1a99: 0x0040, 0x1a9a: 0x0040, 0x1a9b: 0x0040, 0x1a9c: 0x0040, 0x1a9d: 0x0040,
	0x1a9e: 0x2000, 0x1a9f: 0x0040, 0x1aa0: 0x2000, 0x1aa1: 0x0040, 0x1aa2: 0x2000, 0x1aa3: 0x0040,
	0x1aa4: 0x2000, 0x1aa5: 0x0040, 0x1aa6: 0x2000, 0x1aa7: 0x0040, 0x1aa8: 0x2000, 0x1aa9: 0x0040,
	0x1aaa: 0x2000, 0x1aab: 0x0040, 0x1aac: 0x2000, 0x1aad: 0x0040, 0x1aae: 0x2000, 0x1aaf: 0x0040,
	0x1ab0: 0x2000, 0x1ab1: 0x0040, 0x1ab2: 0x2000, 0x1ab3: 0x0040, 0x1ab4: 0x2000, 0x1ab5: 0x0040,
	0x1ab6: 0x2000, 0x1ab7: 0x0040, 0x1ab8: 0x2000, 0x1ab9: 0x0040, 0x1aba: 0x2000, 0x1abb: 0x0040,
	0x1abc: 0x2000, 0x1abd: 0x0040, 0x1abe: 0x2000, 0x1abf: 0x0040,
	// Block 0x6b, offset 0x1ac0
	0x1ac0: 0x0040, 0x1ac1: 0x0040, 0x1ac2: 0x0040, 0x1ac3: 0x0040, 0x1ac4: 0x0040, 0x1ac5: 0x0040,
	0x1ac6: 0x0040, 0x1ac7: 0x0040, 0x1ac8: 0x2000, 0x1ac9: 0x2000, 0x1aca: 0x2000, 0x1acb: 0x2000,
	0x1acc: 0x2000, 0x1acd: 0x2000, 0x1ace: 0x2000, 0x1acf: 0x2000, 0x1ad0: 0x0040, 0x1ad1: 0x0040,
	0x1ad2: 0x0040, 0x1ad3: 0x0040, 0x1ad4: 0x0040, 0x1ad5: 0x0040,
	0x1ad8: 0x2000, 0x1ad9: 0x2000, 0x1ada: 0x2000, 0x1adb: 0x2000, 0x1adc: 0x2000, 0x1add: 0x2000,
	0x1ae0: 0x0040, 0x1ae1: 0x0040, 0x1ae2: 0x0040, 0x1ae3: 0x0040,
	0x1ae4: 0x0040, 0x1ae5: 0x0040, 0x1ae6: 0x0040, 0x1ae7: 0x0040, 0x1ae8: 0x2000, 0x1ae9: 0x2000,
	0x1aea: 0x2000, 0x1aeb: 0x2000, 0x1aec: 0x2000, 0x1aed: 0x2000, 0x1aee: 0x2000, 0x1aef: 0x2000,
	0x1af0: 0x0040, 0x1af1: 0x0040, 0x1af2: 0x0040, 0x1af3: 0x0040, 0x1af4: 0x0040, 0x1af5: 0x0040,
	0x1af6: 0x0040, 0x1af7: 0x0040, 0x1af8: 0x2000, 0x1af9: 0x2000, 0x1afa: 0x2000, 0x1afb: 0x2000,
	0x1afc: 0x2000, 0x1afd: 0x2000, 0x1afe: 0x2000, 0x1aff: 0x2000,
	// Block 0x6c, offset 0x1b00
	0x1b00: 0x0040, 0x1b01: 0x0040, 0x1b02: 0x0040, 0x1b03: 0x0040, 0x1b04: 0x0040, 0x1b05: 0x0040,
	0x1b08: 0x2000, 0x1b09: 0x2000, 0x1b0a: 0x2000, 0x1b0b: 0x2000,
	0x1b0c: 0x2000, 0x1b0d: 0x2000, 0x1b10: 0x0040, 0x1b11: 0x0040,
	0x1b12: 0x0040, 0x1b13: 0x0040, 0x1b14: 0x0040, 0x1b15: 0x0040, 0x1b16: 0x0040, 0x1b17: 0x0040,
	0x1b19: 0x2000, 0x1b1b: 0x2000, 0x1b1d: 0x2000,
	0x1b1f: 0x2000, 0x1b20: 0x0040, 0x1b21: 0x0040, 0x1b22: 0x0040, 0x1b23: 0x0040,
	0x1b24: 0x0040, 0x1b25: 0x0040, 0x1b26: 0x0040, 0x1b27: 0x0040, 0x1b28: 0x2000, 0x1b29: 0x2000,
	0x1b2a: 0x2000, 0x1b2b: 0x2000, 0x1b2c: 0x2000, 0x1b2d: 0x2000, 0x1b2e: 0x2000, 0x1b2f: 0x2000,
	0x1b30: 0x0040, 0x1b31: 0x0040, 0x1b32: 0x0040, 0x1b33: 0x0040, 0x1b34: 0x0040, 0x1b35: 0x0040,
	0x1b36: 0x0040, 0x1b37: 0x0040, 0x1b38: 0x0040, 0x1b39: 0x0040, 0x1b3a: 0x0040, 0x1b3b: 0x0040,
	0x1b3c: 0x0040, 0x1b3d: 0x0040,
	// Block 0x6d, offset 0x1b40
	0x1b40: 0x0040, 0x1b41: 0x0040, 0x1b42: 0x0040, 0x1b43: 0x0040, 0x1b44: 0x0040, 0x1b45: 0x0040,
	0x1b46: 0x0040, 0x1b47: 0x0040, 0x1b48: 0x2000, 0x1b49: 0x2000, 0x1b4a: 0x2000, 0x1b4b: 0x2000,
	0x1b4c: 0x2000, 0x1b4d: 0x2000, 0x1b4e: 0x2000, 0x1b4f: 0x2000, 0x1b50: 0x0040, 0x1b51: 0x0040,
	0x1b52: 0x0040, 0x1b53: 0x0040, 0x1b54: 0x0040, 0x1b55: 0x0040, 0x1b56: 0x0040, 0x1b57: 0x0040,
	0x1b58: 0x2000, 0x1b59: 0x2000, 0x1b5a: 0x2000, 0x1b5b: 0x2000, 0x1b5c: 0x2000, 0x1b5d: 0x2000,
	0x1b5e: 0x2000, 0x1b5f: 0x2000, 0x1b60: 0x0040, 0x1b61: 0x0040, 0x1b62: 0x0040, 0x1b63: 0x0040,
	0x1b64: 0x0040, 0x1b65: 0x0040, 0x1b66: 0x0040, 0x1b67: 0x0040, 0x1b68: 0x2000, 0x1b69: 0x2000,
	0x1b6a: 0x2000, 0x1b6b: 0x2000, 0x1b6c: 0x2000, 0x1b6d: 0x2000, 0x1b6e: 0x2000, 0x1b6f: 0x2000,
	0x1b70: 0x0040, 0x1b71: 0x0040, 0x1b72: 0x0040, 0x1b73: 0x0040, 0x1b74: 0x0040,
	0x1b76: 0x0040, 0x1b77: 0x0040, 0x1b78: 0x2000, 0x1b79: 0x2000, 0x1b7a: 0x2000, 0x1b7b: 0x2000,
	0x1b7c: 0x2000, 0x1b7e: 0x0040,
	// Block 0x6e, offset 0x1b80
	0x1b82: 0x0040, 0x1b83: 0x0040, 0x1b84: 0x0040,
	0x1b86: 0x0040, 0x1b87: 0x0040, 0x1b88: 0x2000, 0x1b89: 0x2000, 0x1b8a: 0x2000, 0x1b8b: 0x2000,
	0x1b8c: 0x2000, 0x1b90: 0x0040, 0x1b91: 0x0040,
	0x1b92: 0x0040, 0x1b93: 0x0040, 0x1b96: 0x0040, 0x1b97: 0x0040,
	0x1b98: 0x2000, 0x1b99: 0x2000, 0x1b9a: 0x2000, 0x1b9b: 0x2000,
	0x1ba0: 0x0040, 0x1ba1: 0x0040, 0x1ba2: 0x0040, 0x1ba3: 0x0040,
	0x1ba4: 0x0040, 0x1ba5: 0x0040, 0x1ba6: 0x0040, 0x1ba7: 0x0040, 0x1ba8: 0x2000, 0x1ba9: 0x2000,
	0x1baa: 0x2000, 0x1bab: 0x2000, 0x1bac: 0x2000,
	0x1bb2: 0x0040, 0x1bb3: 0x0040, 0x1bb4: 0x0040,
	0x1bb6: 0x0040, 0x1bb7: 0x0040, 0x1bb8: 0x2000, 0x1bb9: 0x2000, 0x1bba: 0x2000, 0x1bbb: 0x2000,
	0x1bbc: 0x2000,
	// Block 0x6f, offset 0x1bc0
	0x1bc0: 0x1000, 0x1bc1: 0x1000, 0x1bc2: 0x1000, 0x1bc3: 0x1000, 0x1bc4: 0x1000, 0x1bc5: 0x1000,
	0x1bc6: 0x1000, 0x1bc7: 0x1000, 0x1bc8: 0x1000, 0x1bc9: 0x1000, 0x1bca: 0x1000, 0x1bcb: 0x0010,
	0x1bcc: 0x0008, 0x1bcd: 0x0008, 0x1bce: 0x0010, 0x1bcf: 0x0010,
	0x1bd3: 0x0200, 0x1bd4: 0x0200,
	0x1bd8: 0x0004, 0x1bd9: 0x0004, 0x1bda: 0x0004, 0x1bdb: 0x0004, 0x1bdc: 0x0004, 0x1bdd: 0x0004,
	0x1bde: 0x0004, 0x1bdf: 0x0004,
	0x1be4: 0x0001, 0x1be8: 0x0800, 0x1be9: 0x0800,
	0x1bea: 0x0010, 0x1beb: 0x0010, 0x1bec: 0x0010, 0x1bed: 0x0010, 0x1bee: 0x0010, 0x1bef: 0x1000,
	0x1bf9: 0x0004, 0x1bfa: 0x0004,
	0x1bfc: 0x0400, 0x1bfd: 0x0400,
	// Block 0x70, offset 0x1c00
	0x1c05: 0x0004,
	0x1c06: 0x0004, 0x1c07: 0x0400, 0x1c08: 0x0400, 0x1c09: 0x0400,
	0x1c1f: 0x1000, 0x1c20: 0x0010, 0x1c21: 0x0010, 0x1c22: 0x0010, 0x1c23: 0x0010,
	0x1c24: 0x0010, 0x1c26: 0x0010, 0x1c27: 0x0010, 0x1c28: 0x0010, 0x1c29: 0x0010,
	0x1c2a: 0x0010, 0x1c2b: 0x0010, 0x1c2c: 0x0010, 0x1c2d: 0x0010, 0x1c2e: 0x0010, 0x1c2f: 0x0010,
	0x1c31: 0x0040,
	0x1c3d: 0x0004, 0x1c3e: 0x0004, 0x1c3f: 0x0040,
	// Block 0x71, offset 0x1c40
	0x1c4d: 0x0004, 0x1c4e: 0x0004, 0x1c50: 0x0040, 0x1c51: 0x0040,
	0x1c52: 0x0040, 0x1c53: 0x0040, 0x1c54: 0x0040, 0x1c55: 0x0040, 0x1c56: 0x0040, 0x1c57: 0x0040,
	0x1c58: 0x0040, 0x1c59: 0x0040, 0x1c5a: 0x0040, 0x1c5b: 0x0040, 0x1c5c: 0x0040,
	// Block 0x72, offset 0x1c80
	0x1c90: 0x0008, 0x1c91: 0x0008,
	0x1c92: 0x0008, 0x1c93: 0x0008, 0x1c94: 0x0008, 0x1c95: 0x0008, 0x1c96: 0x0008, 0x1c97: 0x0008,
	0x1c98: 0x0008, 0x1c99: 0x0008, 0x1c9a: 0x0008, 0x1c9b: 0x0008, 0x1c9c: 0x0008, 0x1c9d: 0x0008,
	0x1c9e: 0x0008, 0x1c9f: 0x0008, 0x1ca0: 0x0008, 0x1ca1: 0x0008, 0x1ca2: 0x0008, 0x1ca3: 0x0008,
	0x1ca4: 0x0008, 0x1ca5: 0x0008, 0x1ca6: 0x0008, 0x1ca7: 0x0008, 0x1ca8: 0x0008, 0x1ca9: 0x0008,
	0x1caa: 0x0008, 0x1cab: 0x0008, 0x1cac: 0x0008, 0x1cad: 0x0008, 0x1cae: 0x0008, 0x1caf: 0x0008,
	0x1cb0: 0x0008,
	// Block 0x73, offset 0x1cc0
	0x1cc2: 0x2000,
	0x1cc7: 0x2000, 0x1cca: 0x0040, 0x1ccb: 0x2000,
	0x1ccc: 0x2000, 0x1ccd: 0x2000, 0x1cce: 0x0040, 0x1ccf: 0x0040, 0x1cd0: 0x2000, 0x1cd1: 0x2000,
	0x1cd2: 0x2000, 0x1cd3: 0x0040, 0x1cd5: 0x2000,
	0x1cd9: 0x2000, 0x1cda: 0x2000, 0x1cdb: 0x2000, 0x1cdc: 0x2000, 0x1cdd: 0x2000,
	0x1ce4: 0x2000, 0x1ce6: 0x2000, 0x1ce8: 0x2000,
	0x1cea: 0x2000, 0x1ceb: 0x2000, 0x1cec: 0x2000, 0x1ced: 0x2000, 0x1cef: 0x0040,
	0x1cf0: 0x2000, 0x1cf1: 0x2000, 0x1cf2: 0x2000, 0x1cf3: 0x2000, 0x1cf4: 0x0040, 0x1cf5: 0x0100,
	0x1cf6: 0x0100, 0x1cf7: 0x0100, 0x1cf8: 0x0100, 0x1cf9: 0x0040,
	0x1cfc: 0x0040, 0x1cfd: 0x0040, 0x1cfe: 0x2000, 0x1cff: 0x2000,
	// Block 0x74, offset 0x1d00
	0x1d05: 0x2000,
	0x1d06: 0x0040, 0x1d07: 0x0040, 0x1d08: 0x0040, 0x1d09: 0x0040,
	0x1d0e: 0x0040,
	0x1d20: 0x2000, 0x1d21: 0x2000, 0x1d22: 0x2000, 0x1d23: 0x2000,
	0x1d24: 0x2000, 0x1d25: 0x2000, 0x1d26: 0x2000, 0x1d27: 0x2000, 0x1d28: 0x2000, 0x1d29: 0x2000,
	0x1d2a: 0x2000, 0x1d2b: 0x2000, 0x1d2c: 0x2000, 0x1d2d: 0x2000, 0x1d2e: 0x2000, 0x1d2f: 0x2000,
	0x1d30: 0x0040, 0x1d31: 0x0040, 0x1d32: 0x0040, 0x1d33: 0x0040, 0x1d34: 0x0040, 0x1d35: 0x0040,
	0x1d36: 0x0040, 0x1d37: 0x0040, 0x1d38: 0x0040, 0x1d39: 0x0040, 0x1d3a: 0x0040, 0x1d3b: 0x0040,
	0x1d3c: 0x0040, 0x1d3d: 0x0040, 0x1d3e: 0x0040, 0x1d3f: 0x0040,
	// Block 0x75, offset 0x1d40
	0x1d40: 0x0100, 0x1d41: 0x0100, 0x1d42: 0x0100, 0x1d43: 0x2000, 0x1d44: 0x0040, 0x1d45: 0x0100,
	0x1d46: 0x0100, 0x1d47: 0x0100, 0x1d48: 0x0100,
	// Block 0x76, offset 0x1d80
	0x1d88: 0x0004, 0x1d89: 0x0004, 0x1d8a: 0x0004, 0x1d8b: 0x0004,
	0x1da9: 0x0004,
	0x1daa: 0x0004,
	// Block 0x77, offset 0x1dc0
	0x1df6: 0x2000, 0x1df7: 0x2000, 0x1df8: 0x2000, 0x1df9: 0x2000, 0x1dfa: 0x2000, 0x1dfb: 0x2000,
	0x1dfc: 0x2000, 0x1dfd: 0x2000, 0x1dfe: 0x2000, 0x1dff: 0x2000,
	// Block 0x78, offset 0x1e00
	0x1e00: 0x2000, 0x1e01: 0x2000, 0x1e02: 0x2000, 0x1e03: 0x2000, 0x1e04: 0x2000, 0x1e05: 0x2000,
	0x1e06: 0x2000, 0x1e07: 0x2000, 0x1e08: 0x2000, 0x1e09: 0x2000, 0x1e0a: 0x2000, 0x1e0b: 0x2000,
	0x1e0c: 0x2000, 0x1e0d: 0x2000, 0x1e0e: 0x2000, 0x1e0f: 0x2000, 0x1e10: 0x0040, 0x1e11: 0x0040,
	0x1e12: 0x0040, 0x1e13: 0x0040, 0x1e14: 0x0040, 0x1e15: 0x0040, 0x1e16: 0x0040, 0x1e17: 0x0040,
	0x1e18: 0x0040, 0x1e19: 0x0040, 0x1e1a: 0x0040, 0x1e1b: 0x0040, 0x1e1c: 0x0040, 0x1e1d: 0x0040,
	0x1e1e: 0x0040, 0x1e1f: 0x0040, 0x1e20: 0x0040, 0x1e21: 0x0040, 0x1e22: 0x0040, 0x1e23: 0x0040,
	0x1e24: 0x0040, 0x1e25: 0x0040, 0x1e26: 0x0040, 0x1e27: 0x0040, 0x1e28: 0x0040, 0x1e29: 0x0040,
	// Block 0x79, offset 0x1e40
	0x1e5b: 0x0004, 0x1e5c: 0x0004, 0x1e5d: 0x0004,
	0x1e5e: 0x0004, 0x1e5f: 0x0004, 0x1e60: 0x0004,
	0x1e68: 0x0004, 0x1e69: 0x0004,
	0x1e6a: 0x0004, 0x1e6b: 0x0004, 0x1e6c: 0x0004, 0x1e6d: 0x0004, 0x1e6e: 0x0004, 0x1e6f: 0x0004,
	0x1e70: 0x0004, 0x1e71: 0x0004, 0x1e72: 0x0004, 0x1e73: 0x0004, 0x1e74: 0x0004, 0x1e75: 0x0004,
	// Block 0x7a, offset 0x1e80
	0x1e85: 0x0004,
	0x1e86: 0x0004,
	0x1ea6: 0x0004, 0x1ea7: 0x0004, 0x1ea8: 0x0004, 0x1ea9: 0x0004,
	0x1eaa: 0x0004, 0x1eab: 0x0004, 0x1eac: 0x0004, 0x1ead: 0x0004, 0x1eae: 0x0004, 0x1eaf: 0x0004,
	// Block 0x7b, offset 0x1ec0
	0x1ec3: 0x0004, 0x1ec4: 0x0004, 0x1ec5: 0x0004,
	0x1ec6: 0x0004, 0x1ec7: 0x0004, 0x1ec8: 0x0004, 0x1ec9: 0x0004, 0x1eca: 0x0004, 0x1ecb: 0x0004,
	0x1ecc: 0x0004, 0x1ecd: 0x0004, 0x1ece: 0x0004, 0x1ecf: 0x0004, 0x1ed0: 0x0004, 0x1ed1: 0x0004,
	0x1ed2: 0x0004, 0x1ed3: 0x0004, 0x1ed4: 0x0004, 0x1ed5: 0x0004, 0x1ed6: 0x0004, 0x1ed7: 0x0004,
	0x1ed8: 0x0004,
	// Block 0x7c, offset 0x1f00
	0x1f18: 0x0004, 0x1f19: 0x0004, 0x1f1a: 0x0004, 0x1f1b: 0x0004,
	0x1f3c: 0x0004, 0x1f3d: 0x0004,
	// Block 0x7d, offset 0x1f40
	0x1f40: 0x0040, 0x1f41: 0x0040, 0x1f42: 0x0040, 0x1f43: 0x0040, 0x1f44: 0x0040, 0x1f45: 0x0040,
	0x1f46: 0x0040, 0x1f47: 0x0040, 0x1f48: 0x0040, 0x1f49: 0x0040, 0x1f4a: 0x0040, 0x1f4b: 0x0040,
	0x1f4c: 0x0040, 0x1f4d: 0x0040, 0x1f4e: 0x0040, 0x1f4f: 0x0040, 0x1f50: 0x0040, 0x1f51: 0x0040,
	0x1f52: 0x0040, 0x1f53: 0x0040, 0x1f54: 0x0040, 0x1f55: 0x0040, 0x1f56: 0x0040, 0x1f57: 0x0040,
	0x1f58: 0x0040, 0x1f59: 0x0040, 0x1f5a: 0x0040, 0x1f5b: 0x0040, 0x1f5c: 0x0040, 0x1f5d: 0x0040,
	0x1f5e: 0x0040, 0x1f5f: 0x0040, 0x1f60: 0x2000, 0x1f61: 0x0040, 0x1f62: 0x2000, 0x1f63: 0x2000,
	0x1f64: 0x2000, 0x1f65: 0x0040, 0x1f66: 0x0040, 0x1f67: 0x2000, 0x1f68: 0x0040, 0x1f69: 0x2000,
	0x1f6a: 0x0040, 0x1f6b: 0x2000, 0x1f6c: 0x0040, 0x1f6d: 0x2000, 0x1f6e: 0x2000, 0x1f6f: 0x2000,
	0x1f70: 0x2000, 0x1f71: 0x0040, 0x1f72: 0x2000, 0x1f73: 0x0040, 0x1f74: 0x0040, 0x1f75: 0x2000,
	0x1f76: 0x0040, 0x1f77: 0x0040, 0x1f78: 0x0040, 0x1f79: 0x0040, 0x1f7a: 0x0040, 0x1f7b: 0x0040,
	0x1f7c: 0x0040, 0x1f7d: 0x0040, 0x1f7e: 0x2000, 0x1f7f: 0x2000,
	// Block 0x7e, offset 0x1f80
	0x1f80: 0x2000, 0x1f81: 0x0040, 0x1f82: 0x2000, 0x1f83: 0x0040, 0x1f84: 0x2000, 0x1f85: 0x0040,
	0x1f86: 0x2000, 0x1f87: 0x0040, 0x1f88: 0x2000, 0x1f89: 0x0040, 0x1f8a: 0x2000, 0x1f8b: 0x0040,
	0x1f8c: 0x2000, 0x1f8d: 0x0040, 0x1f8e: 0x2000, 0x1f8f: 0x0040, 0x1f90: 0x2000, 0x1f91: 0x0040,
	0x1f92: 0x2000, 0x1f93: 0x0040, 0x1f94: 0x2000, 0x1f95: 0x0040, 0x1f96: 0x2000, 0x1f97: 0x0040,
	0x1f98: 0x2000, 0x1f99: 0x0040, 0x1f9a: 0x2000, 0x1f9b: 0x0040, 0x1f9c: 0x2000, 0x1f9d: 0x0040,
	0x1f9e: 0x2000, 0x1f9f: 0x0040, 0x1fa0: 0x2000, 0x1fa1: 0x0040, 0x1fa2: 0x2000, 0x1fa3: 0x0040,
	0x1fa4: 0x0040,
	0x1fab: 0x2000, 0x1fac: 0x0040, 0x1fad: 0x2000, 0x1fae: 0x0040, 0x1faf: 0x0008,
	0x1fb0: 0x0008, 0x1fb1: 0x0008, 0x1fb2: 0x2000, 0x1fb3: 0x0040,
	// Block 0x7f, offset 0x1fc0
	0x1fc0: 0x0040, 0x1fc1: 0x0040, 0x1fc2: 0x0040, 0x1fc3: 0x0040, 0x1fc4: 0x0040, 0x1fc5: 0x0040,
	0x1fc6: 0x0040, 0x1fc7: 0x0040, 0x1fc8: 0x0040, 0x1fc9: 0x0040, 0x1fca: 0x0040, 0x1fcb: 0x0040,
	0x1fcc: 0x0040, 0x1fcd: 0x0040, 0x1fce: 0x0040, 0x1fcf: 0x0040, 0x1fd0: 0x0040, 0x1fd1: 0x0040,
	0x1fd2: 0x0040, 0x1fd3: 0x0040, 0x1fd4: 0x0040, 0x1fd5: 0x0040, 0x1fd6: 0x0040, 0x1fd7: 0x0040,
	0x1fd8: 0x0040, 0x1fd9: 0x0040, 0x1fda: 0x0040, 0x1fdb: 0x0040, 0x1fdc: 0x0040, 0x1fdd: 0x0040,
	0x1fde: 0x0040, 0x1fdf: 0x0040, 0x1fe0: 0x0040, 0x1fe1: 0x0040, 0x1fe2: 0x0040, 0x1fe3: 0x0040,
	0x1fe4: 0x0040, 0x1fe5: 0x0040, 0x1fe7: 0x0040,
	0x1fed: 0x0040,
	0x1ff0: 0x0100, 0x1ff1: 0x0100, 0x1ff2: 0x0100, 0x1ff3: 0x0100, 0x1ff4: 0x0100, 0x1ff5: 0x0100,
	0x1ff6: 0x0100, 0x1ff7: 0x0100, 0x1ff8: 0x0100, 0x1ff9: 0x0100, 0x1ffa: 0x0100, 0x1ffb: 0x0100,
	0x1ffc: 0x0100, 0x1ffd: 0x0100, 0x1ffe: 0x0100, 0x1fff: 0x0100,
	// Block 0x80, offset 0x2000
	0x2000: 0x0100, 0x2001: 0x0100, 0x2002: 0x0100, 0x2003: 0x0100, 0x2004: 0x0100, 0x2005: 0x0100,
	0x2006: 0x0100, 0x2007: 0x0100, 0x2008: 0x0100, 0x2009: 0x0100, 0x200a: 0x0100, 0x200b: 0x0100,
	0x200c: 0x0100, 0x200d: 0x0100, 0x200e: 0x0100, 0x200f: 0x0100, 0x2010: 0x0100, 0x2011: 0x0100,
	0x2012: 0x0100, 0x2013: 0x0100, 0x2014: 0x0100, 0x2015: 0x0100, 0x2016: 0x0100, 0x2017: 0x0100,
	0x2018: 0x0100, 0x2019: 0x0100, 0x201a: 0x0100, 0x201b: 0x0100, 0x201c: 0x0100, 0x201d: 0x0100,
	0x201e: 0x0100, 0x201f: 0x0100, 0x2020: 0x0100, 0x2021: 0x0100, 0x2022: 0x0100, 0x2023: 0x0100,
	0x2024: 0x0100, 0x2025: 0x0100, 0x2026: 0x0100, 0x2027: 0x0100,
	0x202f: 0x0100,
	0x203f: 0x0008,
	// Block 0x81, offset 0x2040
	0x2040: 0x0100, 0x2041: 0x0100, 0x2042: 0x0100, 0x2043: 0x0100, 0x2044: 0x0100, 0x2045: 0x0100,
	0x2046: 0x0100, 0x2047: 0x0100, 0x2048: 0x0100, 0x2049: 0x0100, 0x204a: 0x0100, 0x204b: 0x0100,
	0x204c: 0x0100, 0x204d: 0x0100, 0x204e: 0x0100, 0x204f: 0x0100, 0x2050: 0x0100, 0x2051: 0x0100,
	0x2052: 0x0100, 0x2053: 0x0100, 0x2054: 0x0100, 0x2055: 0x0100, 0x2056: 0x0100,
	0x2060: 0x0100, 0x2061: 0x0100, 0x2062: 0x0100, 0x2063: 0x0100,
	0x2064: 0x0100, 0x2065: 0x0100, 0x2066: 0x0100, 0x2068: 0x0100, 0x2069: 0x0100,
	0x206a: 0x0100, 0x206b: 0x0100, 0x206c: 0x0100, 0x206d: 0x0100, 0x206e: 0x0100,
	0x2070: 0x0100, 0x2071: 0x0100, 0x2072: 0x0100, 0x2073: 0x0100, 0x2074: 0x0100, 0x2075: 0x0100,
	0x2076: 0x0100, 0x2078: 0x0100, 0x2079: 0x0100, 0x207a: 0x0100, 0x207b: 0x0100,
	0x207c: 0x0100, 0x207d: 0x0100, 0x207e: 0x0100,
	// Block 0x82, offset 0x2080
	0x2080: 0x0100, 0x2081: 0x0100, 0x2082: 0x0100, 0x2083: 0x0100, 0x2084: 0x0100, 0x2085: 0x0100,
	0x2086: 0x0100, 0x2088: 0x0100, 0x2089: 0x0100, 0x208a: 0x0100, 0x208b: 0x0100,
	0x208c: 0x0100, 0x208d: 0x0100, 0x208e: 0x0100, 0x2090: 0x0100, 0x2091: 0x0100,
	0x2092: 0x0100, 0x2093: 0x0100, 0x2094: 0x0100, 0x2095: 0x0100, 0x2096: 0x0100,
	0x2098: 0x0100, 0x2099: 0x0100, 0x209a: 0x0100, 0x209b: 0x0100, 0x209c: 0x0100, 0x209d: 0x0100,
	0x209e: 0x0100, 0x20a0: 0x0008, 0x20a1: 0x0008, 0x20a2: 0x0008, 0x20a3: 0x0008,
	0x20a4: 0x0008, 0x20a5: 0x0008, 0x20a6: 0x0008, 0x20a7: 0x0008, 0x20a8: 0x0008, 0x20a9: 0x0008,
	0x20aa: 0x0008, 0x20ab: 0x0008, 0x20ac: 0x0008, 0x20ad: 0x0008, 0x20ae: 0x0008, 0x20af: 0x0008,
	0x20b0: 0x0008, 0x20b1: 0x0008, 0x20b2: 0x0008, 0x20b3: 0x0008, 0x20b4: 0x0008, 0x20b5: 0x0008,
	0x20b6: 0x0008, 0x20b7: 0x0008, 0x20b8: 0x0008, 0x20b9: 0x0008, 0x20ba: 0x0008, 0x20bb: 0x0008,
	0x20bc: 0x0008, 0x20bd: 0x0008, 0x20be: 0x0008, 0x20bf: 0x0008,
	// Block 0x83, offset 0x20c0
	0x20c0: 0x0004, 0x20c1: 0x0004, 0x20c2: 0x0004, 0x20c3: 0x0004, 0x20c4: 0x0004, 0x20c5: 0x0004,
	0x20c6: 0x0004, 0x20c7: 0x0004, 0x20c8: 0x0004, 0x20c9: 0x0004, 0x20ca: 0x0004, 0x20cb: 0x0004,
	0x20cc: 0x0004, 0x20cd: 0x0004,
	0x20dc: 0x0004, 0x20dd: 0x0004,
	0x20e0: 0x0004, 0x20e1: 0x0004, 0x20e2: 0x0004, 0x20e3: 0x0004,
	0x20e4: 0x0004, 0x20e5: 0x0004, 0x20e6: 0x0004, 0x20e7: 0x0004, 0x20e8: 0x0004, 0x20e9: 0x0004,
	0x20ee: 0x0400, 0x20ef: 0x0100,
	0x20fc: 0x0400,
	// Block 0x84, offset 0x2100
	0x2102: 0x0004,
	0x2113: 0x0400, 0x2114: 0x0400, 0x2115: 0x0004, 0x2116: 0x0004, 0x2117: 0x0004,
	0x2118: 0x0004, 0x2119: 0x0004, 0x211a: 0x0004, 0x211b: 0x0004, 0x211c: 0x0004,
	// Block 0x85, offset 0x2140
	0x2140: 0x1000, 0x2141: 0x0200, 0x2142: 0x0400, 0x2145: 0x0100,
	0x2146: 0x0100, 0x2147: 0x0100, 0x2148: 0x0004, 0x2149: 0x0004, 0x214a: 0x0004, 0x214b: 0x0004,
	0x214c: 0x0004, 0x214d: 0x0004, 0x214e: 0x0004, 0x214f: 0x0004, 0x2150: 0x0004, 0x2151: 0x0004,
	0x2154: 0x0004, 0x2155: 0x0004, 0x2156: 0x0004, 0x2157: 0x0004,
	0x2158: 0x0004, 0x2159: 0x0004, 0x215a: 0x0004, 0x215b: 0x0004, 0x215d: 0x0004,
	0x215e: 0x0004, 0x215f: 0x0004, 0x2161: 0x0100, 0x2162: 0x0100, 0x2163: 0x0100,
	0x2164: 0x0100, 0x2165: 0x0100, 0x2166: 0x0100, 0x2167: 0x0100, 0x2168: 0x0100, 0x2169: 0x0100,
	0x216a: 0x0008, 0x216b: 0x0008, 0x216c: 0x0008, 0x216d: 0x0008, 0x216e: 0x0008, 0x216f: 0x0008,
	0x2171: 0x0100, 0x2172: 0x0100, 0x2173: 0x0100, 0x2174: 0x0100, 0x2175: 0x0100,
	0x2178: 0x0100, 0x2179: 0x0100, 0x217a: 0x0100, 0x217b: 0x0100,
	0x217c: 0x0100,
	// Block 0x86, offset 0x2180
	0x2180: 0x0100, 0x2181: 0x0100, 0x2182: 0x0100, 0x2183: 0x0100, 0x2184: 0x0100, 0x2185: 0x0100,
	0x2186: 0x0100, 0x2187: 0x0100, 0x2188: 0x0100, 0x2189: 0x0100, 0x218a: 0x0100, 0x218b: 0x0100,
	0x218c: 0x0100, 0x218d: 0x0100, 0x218e: 0x0100, 0x218f: 0x0100, 0x2190: 0x0100, 0x2191: 0x0100,
	0x2192: 0x0100, 0x2193: 0x0100, 0x2194: 0x0100, 0x2195: 0x0100, 0x2196: 0x0100,
	0x2199: 0x0008, 0x219a: 0x0008, 0x219d: 0x0100,
	0x219e: 0x0100, 0x219f: 0x0100, 0x21a1: 0x0100, 0x21a2: 0x0100, 0x21a3: 0x0100,
	0x21a4: 0x0100, 0x21a5: 0x0100, 0x21a6: 0x0100, 0x21a7: 0x0100, 0x21a8: 0x0100, 0x21a9: 0x0100,
	0x21aa: 0x0100, 0x21ab: 0x0100, 0x21ac: 0x0100, 0x21ad: 0x0100, 0x21ae: 0x0100, 0x21af: 0x0100,
	0x21b0: 0x0100, 0x21b1: 0x0100, 0x21b2: 0x0100, 0x21b3: 0x0100, 0x21b4: 0x0100, 0x21b5: 0x0100,
	0x21b6: 0x0100, 0x21b7: 0x0100, 0x21b8: 0x0100, 0x21b9: 0x0100, 0x21ba: 0x0100, 0x21bb: 0x0100,
	0x21bc: 0x0100, 0x21bd: 0x0100, 0x21be: 0x0100, 0x21bf: 0x0100,
	// Block 0x87, offset 0x21c0
	0x21c0: 0x0100, 0x21c1: 0x0100, 0x21c2: 0x0100, 0x21c3: 0x0100, 0x21c4: 0x0100, 0x21c5: 0x0100,
	0x21c6: 0x0100, 0x21c7: 0x0100, 0x21c8: 0x0100, 0x21c9: 0x0100, 0x21ca: 0x0100, 0x21cb: 0x0100,
	0x21cc: 0x0100, 0x21cd: 0x0100, 0x21ce: 0x0100, 0x21cf: 0x0100, 0x21d0: 0x0100, 0x21d1: 0x0100,
	0x21d2: 0x0100, 0x21d3: 0x0100, 0x21d4: 0x0100, 0x21d5: 0x0100, 0x21d6: 0x0100, 0x21d7: 0x0100,
	0x21d8: 0x0100, 0x21d9: 0x0100, 0x21da: 0x0100, 0x21db: 0x0100, 0x21dc: 0x0100, 0x21dd: 0x0100,
	0x21de: 0x0100, 0x21df: 0x0100, 0x21e0: 0x0100, 0x21e1: 0x0100, 0x21e2: 0x0100, 0x21e3: 0x0100,
	0x21e4: 0x0100, 0x21e5: 0x0100, 0x21e6: 0x0100, 0x21e7: 0x0100, 0x21e8: 0x0100, 0x21e9: 0x0100,
	0x21ea: 0x0100, 0x21eb: 0x0100, 0x21ec: 0x0100, 0x21ed: 0x0100, 0x21ee: 0x0100, 0x21ef: 0x0100,
	0x21f0: 0x0100, 0x21f1: 0x0100, 0x21f2: 0x0100, 0x21f3: 0x0100, 0x21f4: 0x0100, 0x21f5: 0x0100,
	0x21f6: 0x0100, 0x21f7: 0x0100, 0x21f8: 0x0100, 0x21f9: 0x0100, 0x21fa: 0x0100,
	0x21fc: 0x0100, 0x21fd: 0x0100, 0x21fe: 0x0100, 0x21ff: 0x0100,
	// Block 0x88, offset 0x2200
	0x2205: 0x0100,
	0x2206: 0x0100, 0x2207: 0x0100, 0x2208: 0x0100, 0x2209: 0x0100, 0x220a: 0x0100, 0x220b: 0x0100,
	0x220c: 0x0100, 0x220d: 0x0100, 0x220e: 0x0100, 0x220f: 0x0100, 0x2210: 0x0100, 0x2211: 0x0100,
	0x2212: 0x0100, 0x2213: 0x0100, 0x2214: 0x0100, 0x2215: 0x0100, 0x2216: 0x0100, 0x2217: 0x0100,
	0x2218: 0x0100, 0x2219: 0x0100, 0x221a: 0x0100, 0x221b: 0x0100, 0x221c: 0x0100, 0x221d: 0x0100,
	0x221e: 0x0100, 0x221f: 0x0100, 0x2220: 0x0100, 0x2221: 0x0100, 0x2222: 0x0100, 0x2223: 0x0100,
	0x2224: 0x0100, 0x2225: 0x0100, 0x2226: 0x0100, 0x2227: 0x0100, 0x2228: 0x0100, 0x2229: 0x0100,
	0x222a: 0x0100, 0x222b: 0x0100, 0x222c: 0x0100, 0x222d: 0x0100, 0x222e: 0x0100, 0x222f: 0x0100,
	0x2231: 0x0100, 0x2232: 0x0100, 0x2233: 0x0100, 0x2234: 0x0100, 0x2235: 0x0100,
	0x2236: 0x0100, 0x2237: 0x0100, 0x2238: 0x0100, 0x2239: 0x0100, 0x223a: 0x0100, 0x223b: 0x0100,
	0x223c: 0x0100, 0x223d: 0x0100, 0x223e: 0x0100, 0x223f: 0x0100,
	// Block 0x89, offset 0x2240
	0x2240: 0x0100, 0x2241: 0x0100, 0x2242: 0x0100, 0x2243: 0x0100, 0x2244: 0x0100, 0x2245: 0x0100,
	0x2246: 0x0100, 0x2247: 0x0100, 0x2248: 0x0100, 0x2249: 0x0100, 0x224a: 0x0100, 0x224b: 0x0100,
	0x224c: 0x0100, 0x224d: 0x0100, 0x224e: 0x0100,
	0x2260: 0x0100, 0x2261: 0x0100, 0x2262: 0x0100, 0x2263: 0x0100,
	0x2264: 0x0100, 0x2265: 0x0100, 0x2266: 0x0100, 0x2267: 0x0100, 0x2268: 0x0100, 0x2269: 0x0100,
	0x226a: 0x0100, 0x226b: 0x0100, 0x226c: 0x0100, 0x226d: 0x0100, 0x226e: 0x0100, 0x226f: 0x0100,
	0x2270: 0x0100, 0x2271: 0x0100, 0x2272: 0x0100, 0x2273: 0x0100, 0x2274: 0x0100, 0x2275: 0x0100,
	0x2276: 0x0100, 0x2277: 0x0100, 0x2278: 0x0100, 0x2279: 0x0100, 0x227a: 0x0100, 0x227b: 0x0100,
	0x227c: 0x0100, 0x227d: 0x0100, 0x227e: 0x0100, 0x227f: 0x0100,
	// Block 0x8a, offset 0x2280
	0x22b0: 0x0100, 0x22b1: 0x0100, 0x22b2: 0x0100, 0x22b3: 0x0100, 0x22b4: 0x0100, 0x22b5: 0x0100,
	0x22b6: 0x0100, 0x22b7: 0x0100, 0x22b8: 0x0100, 0x22b9: 0x0100, 0x22ba: 0x0100, 0x22bb: 0x0100,
	0x22bc: 0x0100, 0x22bd: 0x0100, 0x22be: 0x0100, 0x22bf: 0x0100,
	// Block 0x8b, offset 0x22c0
	0x22c0: 0x0100, 0x22c1: 0x0100, 0x22c2: 0x0100, 0x22c3: 0x0100, 0x22c4: 0x0100, 0x22c5: 0x0100,
	0x22c6: 0x0100, 0x22c7: 0x0100, 0x22c8: 0x0100, 0x22c9: 0x0100, 0x22ca: 0x0100, 0x22cb: 0x0100,
	0x22cc: 0x0100,
	// Block 0x8c, offset 0x2300
	0x2310: 0x0100, 0x2311: 0x0100,
	0x2312: 0x0100, 0x2313: 0x0100, 0x2314: 0x0100, 0x2315: 0x0100, 0x2316: 0x0100, 0x2317: 0x0100,
	0x2318: 0x0100, 0x2319: 0x0100, 0x231a: 0x0100, 0x231b: 0x0100, 0x231c: 0x0100, 0x231d: 0x0100,
	0x231e: 0x0100, 0x231f: 0x0100, 0x2320: 0x0100, 0x2321: 0x0100, 0x2322: 0x0100, 0x2323: 0x0100,
	0x2324: 0x0100, 0x2325: 0x0100, 0x2326: 0x0100, 0x2327: 0x0100, 0x2328: 0x0100, 0x2329: 0x0100,
	0x232a: 0x0100, 0x232b: 0x0100, 0x232c: 0x0100, 0x232d: 0x0100, 0x232e: 0x0100, 0x232f: 0x0100,
	0x2330: 0x0100, 0x2331: 0x0100, 0x2332: 0x0100, 0x2333: 0x0100, 0x2334: 0x0100, 0x2335: 0x0100,
	0x2336: 0x0100, 0x2337: 0x0100, 0x2338: 0x0100, 0x2339: 0x0100, 0x233a: 0x0100, 0x233b: 0x0100,
	0x233c: 0x0100, 0x233d: 0x0100, 0x233f: 0x0400,
	// Block 0x8d, offset 0x2340
	0x2340: 0x0100, 0x2341: 0x0100, 0x2342: 0x0100, 0x2343: 0x0100, 0x2344: 0x0100, 0x2345: 0x0100,
	0x2346: 0x0100, 0x2347: 0x0100, 0x2348: 0x0100, 0x2349: 0x0100, 0x234a: 0x0100, 0x234b: 0x0100,
	0x234c: 0x0100, 0x234e: 0x0400, 0x234f: 0x0400, 0x2350: 0x0100, 0x2351: 0x0100,
	0x2352: 0x0100, 0x2353: 0x0100, 0x2354: 0x0100, 0x2355: 0x0100, 0x2356: 0x0100, 0x2357: 0x0100,
	0x2358: 0x0100, 0x2359: 0x0100, 0x235a: 0x0100, 0x235b: 0x0100, 0x235c: 0x0100, 0x235d: 0x0100,
	0x235e: 0x0100, 0x235f: 0x0100, 0x2360: 0x0080, 0x2361: 0x0080, 0x2362: 0x0080, 0x2363: 0x0080,
	0x2364: 0x0080, 0x2365: 0x0080, 0x2366: 0x0080, 0x2367: 0x0080, 0x2368: 0x0080, 0x2369: 0x0080,
	0x236a: 0x0100, 0x236b: 0x0100,
	// Block 0x8e, offset 0x2380
	0x2380: 0x2000, 0x2381: 0x0040, 0x2382: 0x2000, 0x2383: 0x0040, 0x2384: 0x2000, 0x2385: 0x0040,
	0x2386: 0x2000, 0x2387: 0x0040, 0x2388: 0x2000, 0x2389: 0x0040, 0x238a: 0x2000, 0x238b: 0x0040,
	0x238c: 0x2000, 0x238d: 0x0040, 0x238e: 0x2000, 0x238f: 0x0040, 0x2390: 0x2000, 0x2391: 0x0040,
	0x2392: 0x2000, 0x2393: 0x0040, 0x2394: 0x2000, 0x2395: 0x0040, 0x2396: 0x2000, 0x2397: 0x0040,
	0x2398: 0x2000, 0x2399: 0x0040, 0x239a: 0x2000, 0x239b: 0x0040, 0x239c: 0x2000, 0x239d: 0x0040,
	0x239e: 0x2000, 0x239f: 0x0040, 0x23a0: 0x2000, 0x23a1: 0x0040, 0x23a2: 0x2000, 0x23a3: 0x0040,
	0x23a4: 0x2000, 0x23a5: 0x0040, 0x23a6: 0x2000, 0x23a7: 0x0040, 0x23a8: 0x2000, 0x23a9: 0x0040,
	0x23aa: 0x2000, 0x23ab: 0x0040, 0x23ac: 0x2000, 0x23ad: 0x0040, 0x23ae: 0x0100, 0x23af: 0x0008,
	0x23b0: 0x0008, 0x23b1: 0x0008, 0x23b2: 0x0008, 0x23b4: 0x0008, 0x23b5: 0x0008,
	0x23b6: 0x0008, 0x23b7: 0x0008, 0x23b8: 0x0008, 0x23b9: 0x0008, 0x23ba: 0x0008, 0x23bb: 0x0008,
	0x23bc: 0x0008, 0x23bd: 0x0008, 0x23bf: 0x0100,
	// Block 0x8f, offset 0x23c0
	0x23c0: 0x2000, 0x23c1: 0x0040, 0x23c2: 0x2000, 0x23c3: 0x0040, 0x23c4: 0x2000, 0x23c5: 0x0040,
	0x23c6: 0x2000, 0x23c7: 0x0040, 0x23c8: 0x2000, 0x23c9: 0x0040, 0x23ca: 0x2000, 0x23cb: 0x0040,
	0x23cc: 0x2000, 0x23cd: 0x0040, 0x23ce: 0x2000, 0x23cf: 0x0040, 0x23d0: 0x2000, 0x23d1: 0x0040,
	0x23d2: 0x2000, 0x23d3: 0x0040, 0x23d4: 0x2000, 0x23d5: 0x0040, 0x23d6: 0x2000, 0x23d7: 0x0040,
	0x23d8: 0x2000, 0x23d9: 0x0040, 0x23da: 0x2000, 0x23db: 0x0040, 0x23dc: 0x0040, 0x23dd: 0x0040,
	0x23de: 0x0008, 0x23df: 0x0008, 0x23e0: 0x0100, 0x23e1: 0x0100, 0x23e2: 0x0100, 0x23e3: 0x0100,
	0x23e4: 0x0100, 0x23e5: 0x0100, 0x23e6: 0x0100, 0x23e7: 0x0100, 0x23e8: 0x0100, 0x23e9: 0x0100,
	0x23ea: 0x0100, 0x23eb: 0x0100, 0x23ec: 0x0100, 0x23ed: 0x0100, 0x23ee: 0x0100, 0x23ef: 0x0100,
	0x23f0: 0x0100, 0x23f1: 0x0100, 0x23f2: 0x0100, 0x23f3: 0x0100, 0x23f4: 0x0100, 0x23f5: 0x0100,
	0x23f6: 0x0100, 0x23f7: 0x0100, 0x23f8: 0x0100, 0x23f9: 0x0100, 0x23fa: 0x0100, 0x23fb: 0x0100,
	0x23fc: 0x0100, 0x23fd: 0x0100, 0x23fe: 0x0100, 0x23ff: 0x0100,
	// Block 0x90, offset 0x2400
	0x2400: 0x0100, 0x2401: 0x0100, 0x2402: 0x0100, 0x2403: 0x0100, 0x2404: 0x0100, 0x2405: 0x0100,
	0x2406: 0x0100, 0x2407: 0x0100, 0x2408: 0x0100, 0x2409: 0x0100, 0x240a: 0x0100, 0x240b: 0x0100,
	0x240c: 0x0100, 0x240d: 0x0100, 0x240e: 0x0100, 0x240f: 0x0100, 0x2410: 0x0100, 0x2411: 0x0100,
	0x2412: 0x0100, 0x2413: 0x0100, 0x2414: 0x0100, 0x2415: 0x0100, 0x2416: 0x0100, 0x2417: 0x0100,
	0x2418: 0x0100, 0x2419: 0x0100, 0x241a: 0x0100, 0x241b: 0x0100, 0x241c: 0x0100, 0x241d: 0x0100,
	0x241e: 0x0100, 0x241f: 0x0100, 0x2420: 0x0100, 0x2421: 0x0100, 0x2422: 0x0100, 0x2423: 0x0100,
	0x2424: 0x0100, 0x2425: 0x0100, 0x2426: 0x0100, 0x2427: 0x0100, 0x2428: 0x0100, 0x2429: 0x0100,
	0x242a: 0x0100, 0x242b: 0x0100, 0x242c: 0x0100, 0x242d: 0x0100, 0x242e: 0x0100, 0x242f: 0x0100,
	0x2430: 0x0008, 0x2431: 0x0008, 0x2433: 0x0400,
	0x2437: 0x0400,
	// Block 0x91, offset 0x2440
	0x2457: 0x0100,
	0x2458: 0x0100, 0x2459: 0x0100, 0x245a: 0x0100, 0x245b: 0x0100, 0x245c: 0x0100, 0x245d: 0x0100,
	0x245e: 0x0100, 0x245f: 0x0100, 0x2462: 0x2000, 0x2463: 0x0040,
	0x2464: 0x2000, 0x2465: 0x0040, 0x2466: 0x2000, 0x2467: 0x0040, 0x2468: 0x2000, 0x2469: 0x0040,
	0x246a: 0x2000, 0x246b: 0x0040, 0x246c: 0x2000, 0x246d: 0x0040, 0x246e: 0x2000, 0x246f: 0x0040,
	0x2470: 0x0040, 0x2471: 0x0040, 0x2472: 0x2000, 0x2473: 0x0040, 0x2474: 0x2000, 0x2475: 0x0040,
	0x2476: 0x2000, 0x2477: 0x0040, 0x2478: 0x2000, 0x2479: 0x0040, 0x247a: 0x2000, 0x247b: 0x0040,
	0x247c: 0x2000, 0x247d: 0x0040, 0x247e: 0x2000, 0x247f: 0x0040,
	// Block 0x92, offset 0x2480
	0x2480: 0x2000, 0x2481: 0x0040, 0x2482: 0x2000, 0x2483: 0x0040, 0x2484: 0x2000, 0x2485: 0x0040,
	0x2486: 0x2000, 0x2487: 0x0040, 0x2488: 0x2000, 0x2489: 0x0040, 0x248a: 0x2000, 0x248b: 0x0040,
	0x248c: 0x2000, 0x248d: 0x0040, 0x248e: 0x2000, 0x248f: 0x0040, 0x2490: 0x2000, 0x2491: 0x0040,
	0x2492: 0x2000, 0x2493: 0x0040, 0x2494: 0x2000, 0x2495: 0x0040, 0x2496: 0x2000, 0x2497: 0x0040,
	0x2498: 0x2000, 0x2499: 0x0040, 0x249a: 0x2000, 0x249b: 0x0040, 0x249c: 0x2000, 0x249d: 0x0040,
	0x249e: 0x2000, 0x249f: 0x0040, 0x24a0: 0x2000, 0x24a1: 0x0040, 0x24a2: 0x2000, 0x24a3: 0x0040,
	0x24a4: 0x2000, 0x24a5: 0x0040, 0x24a6: 0x2000, 0x24a7: 0x0040, 0x24a8: 0x2000, 0x24a9: 0x0040,
	0x24aa: 0x2000, 0x24ab: 0x0040, 0x24ac: 0x2000, 0x24ad: 0x0040, 0x24ae: 0x2000, 0x24af: 0x0040,
	0x24b0: 0x0040, 0x24b1: 0x0040, 0x24b2: 0x0040, 0x24b3: 0x0040, 0x24b4: 0x0040, 0x24b5: 0x0040,
	0x24b6: 0x0040, 0x24b7: 0x0040, 0x24b8: 0x0040, 0x24b9: 0x2000, 0x24ba: 0x0040, 0x24bb: 0x2000,
	0x24bc: 0x0040, 0x24bd: 0x2000, 0x24be: 0x2000, 0x24bf: 0x0040,
	// Block 0x93, offset 0x24c0
	0x24c0: 0x2000, 0x24c1: 0x0040, 0x24c2: 0x2000, 0x24c3: 0x0040, 0x24c4: 0x2000, 0x24c5: 0x0040,
	0x24c6: 0x2000, 0x24c7: 0x0040, 0x24c8: 0x0100, 0x24cb: 0x2000,
	0x24cc: 0x0040, 0x24cd: 0x2000, 0x24ce: 0x0040, 0x24cf: 0x0100, 0x24d0: 0x2000, 0x24d1: 0x0040,
	0x24d2: 0x2000, 0x24d3: 0x0040, 0x24d4: 0x0040, 0x24d5: 0x0040, 0x24d6: 0x2000, 0x24d7: 0x0040,
	0x24d8: 0x2000, 0x24d9: 0x0040, 0x24da: 0x2000, 0x24db: 0x0040, 0x24dc: 0x2000, 0x24dd: 0x0040,
	0x24de: 0x2000, 0x24df: 0x0040, 0x24e0: 0x2000, 0x24e1: 0x0040, 0x24e2: 0x2000, 0x24e3: 0x0040,
	0x24e4: 0x2000, 0x24e5: 0x0040, 0x24e6: 0x2000, 0x24e7: 0x0040, 0x24e8: 0x2000, 0x24e9: 0x0040,
	0x24ea: 0x2000, 0x24eb: 0x2000, 0x24ec: 0x2000, 0x24ed: 0x2000, 0x24ee: 0x2000, 0x24ef: 0x0040,
	0x24f0: 0x2000, 0x24f1: 0x2000, 0x24f2: 0x2000, 0x24f3: 0x2000, 0x24f4: 0x2000, 0x24f5: 0x0040,
	0x24f6: 0x2000, 0x24f7: 0x0040, 0x24f8: 0x2000, 0x24f9: 0x0040, 0x24fa: 0x2000, 0x24fb: 0x0040,
	0x24fc: 0x2000, 0x24fd: 0x0040, 0x24fe: 0x2000, 0x24ff: 0x0040,
	// Block 0x94, offset 0x2500
	0x2500: 0x2000, 0x2501: 0x0040, 0x2502: 0x2000, 0x2503: 0x0040, 0x2504: 0x2000, 0x2505: 0x2000,
	0x2506: 0x2000, 0x2507: 0x2000, 0x2508: 0x0040, 0x2509: 0x2000, 0x250a: 0x0040,
	0x2510: 0x2000, 0x2511: 0x0040,
	0x2513: 0x0040, 0x2515: 0x0040, 0x2516: 0x2000, 0x2517: 0x0040,
	0x2518: 0x2000, 0x2519: 0x0040,
	0x2532: 0x0040, 0x2533: 0x0040, 0x2534: 0x0040, 0x2535: 0x2000,
	0x2536: 0x0040, 0x2537: 0x0100, 0x2538: 0x0040, 0x2539: 0x0040, 0x253a: 0x0040, 0x253b: 0x0100,
	0x253c: 0x0100, 0x253d: 0x0100, 0x253e: 0x0100, 0x253f: 0x0100,
	// Block 0x95, offset 0x2540
	0x2540: 0x0100, 0x2541: 0x0100, 0x2542: 0x0008, 0x2543: 0x0100, 0x2544: 0x0100, 0x2545: 0x0100,
	0x2546: 0x0008, 0x2547: 0x0100, 0x2548: 0x0100, 0x2549: 0x0100, 0x254a: 0x0100, 0x254b: 0x0008,
	0x254c: 0x0100, 0x254d: 0x0100, 0x254e: 0x0100, 0x254f: 0x0100, 0x2550: 0x0100, 0x2551: 0x0100,
	0x2552: 0x0100, 0x2553: 0x0100, 0x2554: 0x0100, 0x2555: 0x0100, 0x2556: 0x0100, 0x2557: 0x0100,
	0x2558: 0x0100, 0x2559: 0x0100, 0x255a: 0x0100, 0x255b: 0x0100, 0x255c: 0x0100, 0x255d: 0x0100,
	0x255e: 0x0100, 0x255f: 0x0100, 0x2560: 0x0100, 0x2561: 0x0100, 0x2562: 0x0100, 0x2563: 0x0008,
	0x2564: 0x0008, 0x2565: 0x0008, 0x2566: 0x0008, 0x2567: 0x0008,
	0x256c: 0x0008,
	// Block 0x96, offset 0x2580
	0x2580: 0x0100, 0x2581: 0x0100, 0x2582: 0x0100, 0x2583: 0x0100, 0x2584: 0x0100, 0x2585: 0x0100,
	0x2586: 0x0100, 0x2587: 0x0100, 0x2588: 0x0100, 0x2589: 0x0100, 0x258a: 0x0100, 0x258b: 0x0100,
	0x258c: 0x0100, 0x258d: 0x0100, 0x258e: 0x0100, 0x258f: 0x0100, 0x2590: 0x0100, 0x2591: 0x0100,
	0x2592: 0x0100, 0x2593: 0x0100, 0x2594: 0x0100, 0x2595: 0x0100, 0x2596: 0x0100, 0x2597: 0x0100,
	0x2598: 0x0100, 0x2599: 0x0100, 0x259a: 0x0100, 0x259b: 0x0100, 0x259c: 0x0100, 0x259d: 0x0100,
	0x259e: 0x0100, 0x259f: 0x0100, 0x25a0: 0x0100, 0x25a1: 0x0100, 0x25a2: 0x0100, 0x25a3: 0x0100,
	0x25a4: 0x0100, 0x25a5: 0x0100, 0x25a6: 0x0100, 0x25a7: 0x0100, 0x25a8: 0x0100, 0x25a9: 0x0100,
	0x25aa: 0x0100, 0x25ab: 0x0100, 0x25ac: 0x0100, 0x25ad: 0x0100, 0x25ae: 0x0100, 0x25af: 0x0100,
	0x25b0: 0x0100, 0x25b1: 0x0100, 0x25b2: 0x0100, 0x25b3: 0x0100,
	0x25b6: 0x0400, 0x25b7: 0x0400,
	// Block 0x97, offset 0x25c0
	0x25c0: 0x0008, 0x25c1: 0x0008, 0x25c2: 0x0100, 0x25c3: 0x0100, 0x25c4: 0x0100, 0x25c5: 0x0100,
	0x25c6: 0x0100, 0x25c7: 0x0100, 0x25c8: 0x0100, 0x25c9: 0x0100, 0x25ca: 0x0100, 0x25cb: 0x0100,
	0x25cc: 0x0100, 0x25cd: 0x0100, 0x25ce: 0x0100, 0x25cf: 0x0100, 0x25d0: 0x0100, 0x25d1: 0x0100,
	0x25d2: 0x0100, 0x25d3: 0x0100, 0x25d4: 0x0100, 0x25d5: 0x0100, 0x25d6: 0x0100, 0x25d7: 0x0100,
	0x25d8: 0x0100, 0x25d9: 0x0100, 0x25da: 0x0100, 0x25db: 0x0100, 0x25dc: 0x0100, 0x25dd: 0x0100,
	0x25de: 0x0100, 0x25df: 0x0100, 0x25e0: 0x0100, 0x25e1: 0x0100, 0x25e2: 0x0100, 0x25e3: 0x0100,
	0x25e4: 0x0100, 0x25e5: 0x0100, 0x25e6: 0x0100, 0x25e7: 0x0100, 0x25e8: 0x0100, 0x25e9: 0x0100,
	0x25ea: 0x0100, 0x25eb: 0x0100, 0x25ec: 0x0100, 0x25ed: 0x0100, 0x25ee: 0x0100, 0x25ef: 0x0100,
	0x25f0: 0x0100, 0x25f1: 0x0100, 0x25f2: 0x0100, 0x25f3: 0x0100, 0x25f4: 0x0008, 0x25f5: 0x0008,
	0x25f6: 0x0008, 0x25f7: 0x0008, 0x25f8: 0x0008, 0x25f9: 0x0008, 0x25fa: 0x0008, 0x25fb: 0x0008,
	0x25fc: 0x0008, 0x25fd: 0x0008, 0x25fe: 0x0008, 0x25ff: 0x0008,
	// Block 0x98, offset 0x2600
	0x2600: 0x0008, 0x2601: 0x0008, 0x2602: 0x0008, 0x2603: 0x0008, 0x2604: 0x0008, 0x2605: 0x0008,
	0x260e: 0x0400, 0x260f: 0x0400, 0x2610: 0x0080, 0x2611: 0x0080,
	0x2612: 0x0080, 0x2613: 0x0080, 0x2614: 0x0080, 0x2615: 0x0080, 0x2616: 0x0080, 0x2617: 0x0080,
	0x2618: 0x0080, 0x2619: 0x0080,
	0x2620: 0x0008, 0x2621: 0x0008, 0x2622: 0x0008, 0x2623: 0x0008,
	0x2624: 0x0008, 0x2625: 0x0008, 0x2626: 0x0008, 0x2627: 0x0008, 0x2628: 0x0008, 0x2629: 0x0008,
	0x262a: 0x0008, 0x262b: 0x0008, 0x262c: 0x0008, 0x262d: 0x0008, 0x262e: 0x0008, 0x262f: 0x0008,
	0x2630: 0x0008, 0x2631: 0x0008, 0x2632: 0x0100, 0x2633: 0x0100, 0x2634: 0x0100, 0x2635: 0x0100,
	0x2636: 0x0100, 0x2637: 0x0100, 0x263b: 0x0100,
	0x263d: 0x0100, 0x263e: 0x0100, 0x263f: 0x0008,
	// Block 0x99, offset 0x2640
	0x2640: 0x0080, 0x2641: 0x0080, 0x2642: 0x0080, 0x2643: 0x0080, 0x2644: 0x0080, 0x2645: 0x0080,
	0x2646: 0x0080, 0x2647: 0x0080, 0x2648: 0x0080, 0x2649: 0x0080, 0x264a: 0x0100, 0x264b: 0x0100,
	0x264c: 0x0100, 0x264d: 0x0100, 0x264e: 0x0100, 0x264f: 0x0100, 0x2650: 0x0100, 0x2651: 0x0100,
	0x2652: 0x0100, 0x2653: 0x0100, 0x2654: 0x0100, 0x2655: 0x0100, 0x2656: 0x0100, 0x2657: 0x0100,
	0x2658: 0x0100, 0x2659: 0x0100, 0x265a: 0x0100, 0x265b: 0x0100, 0x265c: 0x0100, 0x265d: 0x0100,
	0x265e: 0x0100, 0x265f: 0x0100, 0x2660: 0x0100, 0x2661: 0x0100, 0x2662: 0x0100, 0x2663: 0x0100,
	0x2664: 0x0100, 0x2665: 0x0100, 0x2666: 0x0008, 0x2667: 0x0008, 0x2668: 0x0008, 0x2669: 0x0008,
	0x266a: 0x0008, 0x266b: 0x0008, 0x266c: 0x0008, 0x266d: 0x0008, 0x266f: 0x0400,
	0x2670: 0x0100, 0x2671: 0x0100, 0x2672: 0x0100, 0x2673: 0x0100, 0x2674: 0x0100, 0x2675: 0x0100,
	0x2676: 0x0100, 0x2677: 0x0100, 0x2678: 0x0100, 0x2679: 0x0100, 0x267a: 0x0100, 0x267b: 0x0100,
	0x267c: 0x0100, 0x267d: 0x0100, 0x267e: 0x0100, 0x267f: 0x0100,
	// Block 0x9a, offset 0x2680
	0x2680: 0x0100, 0x2681: 0x0100, 0x2682: 0x0100, 0x2683: 0x0100, 0x2684: 0x0100, 0x2685: 0x0100,
	0x2686: 0x0100, 0x2687: 0x0008, 0x2688: 0x0008, 0x2689: 0x0008, 0x268a: 0x0008, 0x268b: 0x0008,
	0x268c: 0x0008, 0x268d: 0x0008, 0x268e: 0x0008, 0x268f: 0x0008, 0x2690: 0x0008, 0x2691: 0x0008,
	0x2692: 0x0008, 0x2693: 0x0008,
	0x26a0: 0x0100, 0x26a1: 0x0100, 0x26a2: 0x0100, 0x26a3: 0x0100,
	0x26a4: 0x0100, 0x26a5: 0x0100, 0x26a6: 0x0100, 0x26a7: 0x0100, 0x26a8: 0x0100, 0x26a9: 0x0100,
	0x26aa: 0x0100, 0x26ab: 0x0100, 0x26ac: 0x0100, 0x26ad: 0x0100, 0x26ae: 0x0100, 0x26af: 0x0100,
	0x26b0: 0x0100, 0x26b1: 0x0100, 0x26b2: 0x0100, 0x26b3: 0x0100, 0x26b4: 0x0100, 0x26b5: 0x0100,
	0x26b6: 0x0100, 0x26b7: 0x0100, 0x26b8: 0x0100, 0x26b9: 0x0100, 0x26ba: 0x0100, 0x26bb: 0x0100,
	0x26bc: 0x0100,
	// Block 0x9b, offset 0x26c0
	0x26c0: 0x0008, 0x26c1: 0x0008, 0x26c2: 0x0008, 0x26c3: 0x0008, 0x26c4: 0x0100, 0x26c5: 0x0100,
	0x26c6: 0x0100, 0x26c7: 0x0100, 0x26c8: 0x0100, 0x26c9: 0x0100, 0x26ca: 0x0100, 0x26cb: 0x0100,
	0x26cc: 0x0100, 0x26cd: 0x0100, 0x26ce: 0x0100, 0x26cf: 0x0100, 0x26d0: 0x0100, 0x26d1: 0x0100,
	0x26d2: 0x0100, 0x26d3: 0x0100, 0x26d4: 0x0100, 0x26d5: 0x0100, 0x26d6: 0x0100, 0x26d7: 0x0100,
	0x26d8: 0x0100, 0x26d9: 0x0100, 0x26da: 0x0100, 0x26db: 0x0100, 0x26dc: 0x0100, 0x26dd: 0x0100,
	0x26de: 0x0100, 0x26df: 0x0100, 0x26e0: 0x0100, 0x26e1: 0x0100, 0x26e2: 0x0100, 0x26e3: 0x0100,
	0x26e4: 0x0100, 0x26e5: 0x0100, 0x26e6: 0x0100, 0x26e7: 0x0100, 0x26e8: 0x0100, 0x26e9: 0x0100,
	0x26ea: 0x0100, 0x26eb: 0x0100, 0x26ec: 0x0100, 0x26ed: 0x0100, 0x26ee: 0x0100, 0x26ef: 0x0100,
	0x26f0: 0x0100, 0x26f1: 0x0100, 0x26f2: 0x0100, 0x26f3: 0x0008, 0x26f4: 0x0008, 0x26f5: 0x0008,
	0x26f6: 0x0008, 0x26f7: 0x0008, 0x26f8: 0x0008, 0x26f9: 0x0008, 0x26fa: 0x0008, 0x26fb: 0x0008,
	0x26fc: 0x0008, 0x26fd: 0x0008, 0x26fe: 0x0008, 0x26ff: 0x0008,
	// Block 0x9c, offset 0x2700
	0x2700: 0x0008,
	0x2708: 0x0400, 0x2709: 0x0400,
	0x270f: 0x0100, 0x2710: 0x0080, 0x2711: 0x0080,
	0x2712: 0x0080, 0x2713: 0x0080, 0x2714: 0x0080, 0x2715: 0x0080, 0x2716: 0x0080, 0x2717: 0x0080,
	0x2718: 0x0080, 0x2719: 0x0080,
	0x2720: 0x0100, 0x2721: 0x0100, 0x2722: 0x0100, 0x2723: 0x0100,
	0x2724: 0x0100, 0x2725: 0x0008, 0x2726: 0x0100, 0x2727: 0x0100, 0x2728: 0x0100, 0x2729: 0x0100,
	0x272a: 0x0100, 0x272b: 0x0100, 0x272c: 0x0100, 0x272d: 0x0100, 0x272e: 0x0100, 0x272f: 0x0100,
	0x2730: 0x0080, 0x2731: 0x0080, 0x2732: 0x0080, 0x2733: 0x0080, 0x2734: 0x0080, 0x2735: 0x0080,
	0x2736: 0x0080, 0x2737: 0x0080, 0x2738: 0x0080, 0x2739: 0x0080, 0x273a: 0x0100, 0x273b: 0x0100,
	0x273c: 0x0100, 0x273d: 0x0100, 0x273e: 0x0100,
	// Block 0x9d, offset 0x2740
	0x2740: 0x0100, 0x2741: 0x0100, 0x2742: 0x0100, 0x2743: 0x0100, 0x2744: 0x0100, 0x2745: 0x0100,
	0x2746: 0x0100, 0x2747: 0x0100, 0x2748: 0x0100, 0x2749: 0x0100, 0x274a: 0x0100, 0x274b: 0x0100,
	0x274c: 0x0100, 0x274d: 0x0100, 0x274e: 0x0100, 0x274f: 0x0100, 0x2750: 0x0100, 0x2751: 0x0100,
	0x2752: 0x0100, 0x2753: 0x0100, 0x2754: 0x0100, 0x2755: 0x0100, 0x2756: 0x0100, 0x2757: 0x0100,
	0x2758: 0x0100, 0x2759: 0x0100, 0x275a: 0x0100, 0x275b: 0x0100, 0x275c: 0x0100, 0x275d: 0x0100,
	0x275e: 0x0100, 0x275f: 0x0100, 0x2760: 0x0100, 0x2761: 0x0100, 0x2762: 0x0100, 0x2763: 0x0100,
	0x2764: 0x0100, 0x2765: 0x0100, 0x2766: 0x0100, 0x2767: 0x0100, 0x2768: 0x0100, 0x2769: 0x0008,
	0x276a: 0x0008, 0x276b: 0x0008, 0x276c: 0x0008, 0x276d: 0x0008, 0x276e: 0x0008, 0x276f: 0x0008,
	0x2770: 0x0008, 0x2771: 0x0008, 0x2772: 0x0008, 0x2773: 0x0008, 0x2774: 0x0008, 0x2775: 0x0008,
	0x2776: 0x0008,
	// Block 0x9e, offset 0x2780
	0x2780: 0x0100, 0x2781: 0x0100, 0x2782: 0x0100, 0x2783: 0x0008, 0x2784: 0x0100, 0x2785: 0x0100,
	0x2786: 0x0100, 0x2787: 0x0100, 0x2788: 0x0100, 0x2789: 0x0100, 0x278a: 0x0100, 0x278b: 0x0100,
	0x278c: 0x0008, 0x278d: 0x0008, 0x2790: 0x0080, 0x2791: 0x0080,
	0x2792: 0x0080, 0x2793: 0x0080, 0x2794: 0x0080, 0x2795: 0x0080, 0x2796: 0x0080, 0x2797: 0x0080,
	0x2798: 0x0080, 0x2799: 0x0080, 0x279d: 0x0400,
	0x279e: 0x0400, 0x279f: 0x0400, 0x27a0: 0x0100, 0x27a1: 0x0100, 0x27a2: 0x0100, 0x27a3: 0x0100,
	0x27a4: 0x0100, 0x27a5: 0x0100, 0x27a6: 0x0100, 0x27a7: 0x0100, 0x27a8: 0x0100, 0x27a9: 0x0100,
	0x27aa: 0x0100, 0x27ab: 0x0100, 0x27ac: 0x0100, 0x27ad: 0x0100, 0x27ae: 0x0100, 0x27af: 0x0100,
	0x27b0: 0x0100, 0x27b1: 0x0100, 0x27b2: 0x0100, 0x27b3: 0x0100, 0x27b4: 0x0100, 0x27b5: 0x0100,
	0x27b6: 0x0100, 0x27ba: 0x0100, 0x27bb: 0x0008,
	0x27bc: 0x0008, 0x27bd: 0x0008, 0x27be: 0x0100, 0x27bf: 0x0100,
	// Block 0x9f, offset 0x27c0
	0x27c0: 0x0100, 0x27c1: 0x0100, 0x27c2: 0x0100, 0x27c3: 0x0100, 0x27c4: 0x0100, 0x27c5: 0x0100,
	0x27c6: 0x0100, 0x27c7: 0x0100, 0x27c8: 0x0100, 0x27c9: 0x0100, 0x27ca: 0x0100, 0x27cb: 0x0100,
	0x27cc: 0x0100, 0x27cd: 0x0100, 0x27ce: 0x0100, 0x27cf: 0x0100, 0x27d0: 0x0100, 0x27d1: 0x0100,
	0x27d2: 0x0100, 0x27d3: 0x0100, 0x27d4: 0x0100, 0x27d5: 0x0100, 0x27d6: 0x0100, 0x27d7: 0x0100,
	0x27d8: 0x0100, 0x27d9: 0x0100, 0x27da: 0x0100, 0x27db: 0x0100, 0x27dc: 0x0100, 0x27dd: 0x0100,
	0x27de: 0x0100, 0x27df: 0x0100, 0x27e0: 0x0100, 0x27e1: 0x0100, 0x27e2: 0x0100, 0x27e3: 0x0100,
	0x27e4: 0x0100, 0x27e5: 0x0100, 0x27e6: 0x0100, 0x27e7: 0x0100, 0x27e8: 0x0100, 0x27e9: 0x0100,
	0x27ea: 0x0100, 0x27eb: 0x0100, 0x27ec: 0x0100, 0x27ed: 0x0100, 0x27ee: 0x0100, 0x27ef: 0x0100,
	0x27f0: 0x0008, 0x27f1: 0x0100, 0x27f2: 0x0008, 0x27f3: 0x0008, 0x27f4: 0x0008, 0x27f5: 0x0100,
	0x27f6: 0x0100, 0x27f7: 0x0008, 0x27f8: 0x0008, 0x27f9: 0x0100, 0x27fa: 0x0100, 0x27fb: 0x0100,
	0x27fc: 0x0100, 0x27fd: 0x0100, 0x27fe: 0x0008, 0x27ff: 0x0008,
	// Block 0xa0, offset 0x2800
	0x2800: 0x0100, 0x2801: 0x0008, 0x2802: 0x0100,
	0x281b: 0x0100, 0x281c: 0x0100, 0x281d: 0x0100,
	0x2820: 0x0100, 0x2821: 0x0100, 0x2822: 0x0100, 0x2823: 0x0100,
	0x2824: 0x0100, 0x2825: 0x0100, 0x2826: 0x0100, 0x2827: 0x0100, 0x2828: 0x0100, 0x2829: 0x0100,
	0x282a: 0x0100, 0x282b: 0x0008, 0x282c: 0x0008, 0x282d: 0x0008, 0x282e: 0x0008, 0x282f: 0x0008,
	0x2830: 0x0400, 0x2831: 0x0400, 0x2832: 0x0100, 0x2833: 0x0100, 0x2834: 0x0100, 0x2835: 0x0008,
	0x2836: 0x0008,
	// Block 0xa1, offset 0x2840
	0x2841: 0x0100, 0x2842: 0x0100, 0x2843: 0x0100, 0x2844: 0x0100, 0x2845: 0x0100,
	0x2846: 0x0100, 0x2849: 0x0100, 0x284a: 0x0100, 0x284b: 0x0100,
	0x284c: 0x0100, 0x284d: 0x0100, 0x284e: 0x0100, 0x2851: 0x0100,
	0x2852: 0x0100, 0x2853: 0x0100, 0x2854: 0x0100, 0x2855: 0x0100, 0x2856: 0x0100,
	0x2860: 0x0100, 0x2861: 0x0100, 0x2862: 0x0100, 0x2863: 0x0100,
	0x2864: 0x0100, 0x2865: 0x0100, 0x2866: 0x0100, 0x2868: 0x0100, 0x2869: 0x0100,
	0x286a: 0x0100, 0x286b: 0x0100, 0x286c: 0x0100, 0x286d: 0x0100, 0x286e: 0x0100,
	0x2870: 0x0040, 0x2871: 0x0040, 0x2872: 0x0040, 0x2873: 0x0040, 0x2874: 0x0040, 0x2875: 0x0040,
	0x2876: 0x0040, 0x2877: 0x0040, 0x2878: 0x0040, 0x2879: 0x0040, 0x287a: 0x0040, 0x287b: 0x0040,
	0x287c: 0x0040, 0x287d: 0x0040, 0x287e: 0x0040, 0x287f: 0x0040,
	// Block 0xa2, offset 0x2880
	0x2880: 0x0040, 0x2881: 0x0040, 0x2882: 0x0040, 0x2883: 0x0040, 0x2884: 0x0040, 0x2885: 0x0040,
	0x2886: 0x0040, 0x2887: 0x0040, 0x2888: 0x0040, 0x2889: 0x0040, 0x288a: 0x0040, 0x288b: 0x0040,
	0x288c: 0x0040, 0x288d: 0x0040, 0x288e: 0x0040, 0x288f: 0x0040, 0x2890: 0x0040, 0x2891: 0x0040,
	0x2892: 0x0040, 0x2893: 0x0040, 0x2894: 0x0040, 0x2895: 0x0040, 0x2896: 0x0040, 0x2897: 0x0040,
	0x2898: 0x0040, 0x2899: 0x0040, 0x289a: 0x0040, 0x289c: 0x0040, 0x289d: 0x0040,
	0x289e: 0x0040, 0x289f: 0x0040, 0x28a0: 0x0040, 0x28a1: 0x0040, 0x28a2: 0x0040, 0x28a3: 0x0040,
	0x28a4: 0x0040, 0x28a5: 0x0040, 0x28a6: 0x0040, 0x28a7: 0x0040, 0x28a8: 0x0040, 0x28a9: 0x0040,
	0x28b0: 0x0040, 0x28b1: 0x0040, 0x28b2: 0x0040, 0x28b3: 0x0040, 0x28b4: 0x0040, 0x28b5: 0x0040,
	0x28b6: 0x0040, 0x28b7: 0x0040, 0x28b8: 0x0040, 0x28b9: 0x0040, 0x28ba: 0x0040, 0x28bb: 0x0040,
	0x28bc: 0x0040, 0x28bd: 0x0040, 0x28be: 0x0040, 0x28bf: 0x0040,
	// Block 0xa3, offset 0x28c0
	0x28c0: 0x0100, 0x28c1: 0x0100, 0x28c2: 0x0100, 0x28c3: 0x0100, 0x28c4: 0x0100, 0x28c5: 0x0100,
	0x28c6: 0x0100, 0x28c7: 0x0100, 0x28c8: 0x0100, 0x28c9: 0x0100, 0x28ca: 0x0100, 0x28cb: 0x0100,
	0x28cc: 0x0100, 0x28cd: 0x0100, 0x28ce: 0x0100, 0x28cf: 0x0100, 0x28d0: 0x0100, 0x28d1: 0x0100,
	0x28d2: 0x0100, 0x28d3: 0x0100, 0x28d4: 0x0100, 0x28d5: 0x0100, 0x28d6: 0x0100, 0x28d7: 0x0100,
	0x28d8: 0x0100, 0x28d9: 0x0100, 0x28da: 0x0100, 0x28db: 0x0100, 0x28dc: 0x0100, 0x28dd: 0x0100,
	0x28de: 0x0100, 0x28df: 0x0100, 0x28e0: 0x0100, 0x28e1: 0x0100, 0x28e2: 0x0100, 0x28e3: 0x0008,
	0x28e4: 0x0008, 0x28e5: 0x0008, 0x28e6: 0x0008, 0x28e7: 0x0008, 0x28e8: 0x0008, 0x28e9: 0x0008,
	0x28ea: 0x0008, 0x28eb: 0x0400, 0x28ec: 0x0008, 0x28ed: 0x0008,
	0x28f0: 0x0080, 0x28f1: 0x0080, 0x28f2: 0x0080, 0x28f3: 0x0080, 0x28f4: 0x0080, 0x28f5: 0x0080,
	0x28f6: 0x0080, 0x28f7: 0x0080, 0x28f8: 0x0080, 0x28f9: 0x0080,
	// Block 0xa4, offset 0x2900
	0x2900: 0x0100, 0x2901: 0x0100, 0x2902: 0x0100, 0x2903: 0x0100, 0x2904: 0x0100, 0x2905: 0x0100,
	0x2906: 0x0100, 0x2907: 0x0100, 0x2908: 0x0100, 0x2909: 0x0100, 0x290a: 0x0100, 0x290b: 0x0100,
	0x290c: 0x0100, 0x290d: 0x0100, 0x290e: 0x0100, 0x290f: 0x0100, 0x2910: 0x0100, 0x2911: 0x0100,
	0x2912: 0x0100, 0x2913: 0x0100, 0x2914: 0x0100, 0x2915: 0x0100, 0x2916: 0x0100, 0x2917: 0x0100,
	0x2918: 0x0100, 0x2919: 0x0100, 0x291a: 0x0100, 0x291b: 0x0100, 0x291c: 0x0100, 0x291d: 0x0100,
	0x291e: 0x0100, 0x291f: 0x0100, 0x2920: 0x0100, 0x2921: 0x0100, 0x2922: 0x0100, 0x2923: 0x0100,
	0x2930: 0x0100, 0x2931: 0x0100, 0x2932: 0x0100, 0x2933: 0x0100, 0x2934: 0x0100, 0x2935: 0x0100,
	0x2936: 0x0100, 0x2937: 0x0100, 0x2938: 0x0100, 0x2939: 0x0100, 0x293a: 0x0100, 0x293b: 0x0100,
	0x293c: 0x0100, 0x293d: 0x0100, 0x293e: 0x0100, 0x293f: 0x0100,
	// Block 0xa5, offset 0x2940
	0x2940: 0x0100, 0x2941: 0x0100, 0x2942: 0x0100, 0x2943: 0x0100, 0x2944: 0x0100, 0x2945: 0x0100,
	0x2946: 0x0100, 0x294b: 0x0100,
	0x294c: 0x0100, 0x294d: 0x0100, 0x294e: 0x0100, 0x294f: 0x0100, 0x2950: 0x0100, 0x2951: 0x0100,
	0x2952: 0x0100, 0x2953: 0x0100, 0x2954: 0x0100, 0x2955: 0x0100, 0x2956: 0x0100, 0x2957: 0x0100,
	0x2958: 0x0100, 0x2959: 0x0100, 0x295a: 0x0100, 0x295b: 0x0100, 0x295c: 0x0100, 0x295d: 0x0100,
	0x295e: 0x0100, 0x295f: 0x0100, 0x2960: 0x0100, 0x2961: 0x0100, 0x2962: 0x0100, 0x2963: 0x0100,
	0x2964: 0x0100, 0x2965: 0x0100, 0x2966: 0x0100, 0x2967: 0x0100, 0x2968: 0x0100, 0x2969: 0x0100,
	0x296a: 0x0100, 0x296b: 0x0100, 0x296c: 0x0100, 0x296d: 0x0100, 0x296e: 0x0100, 0x296f: 0x0100,
	0x2970: 0x0100, 0x2971: 0x0100, 0x2972: 0x0100, 0x2973: 0x0100, 0x2974: 0x0100, 0x2975: 0x0100,
	0x2976: 0x0100, 0x2977: 0x0100, 0x2978: 0x0100, 0x2979: 0x0100, 0x297a: 0x0100, 0x297b: 0x0100,
	// Block 0xa6, offset 0x2980
	0x2980: 0x0100, 0x2981: 0x0100, 0x2982: 0x0100, 0x2983: 0x0100, 0x2984: 0x0100, 0x2985: 0x0100,
	0x2986: 0x0100, 0x2987: 0x0100, 0x2988: 0x0100, 0x2989: 0x0100, 0x298a: 0x0100, 0x298b: 0x0100,
	0x298c: 0x0100, 0x298d: 0x0100, 0x298e: 0x0100, 0x298f: 0x0100, 0x2990: 0x0100, 0x2991: 0x0100,
	0x2992: 0x0100, 0x2993: 0x0100, 0x2994: 0x0100, 0x2995: 0x0100, 0x2996: 0x0100, 0x2997: 0x0100,
	0x2998: 0x0100, 0x2999: 0x0100, 0x299a: 0x0100, 0x299b: 0x0100, 0x299c: 0x0100, 0x299d: 0x0100,
	0x299e: 0x0100, 0x299f: 0x0100, 0x29a0: 0x0100, 0x29a1: 0x0100, 0x29a2: 0x0100, 0x29a3: 0x0100,
	0x29a4: 0x0100, 0x29a5: 0x0100, 0x29a6: 0x0100, 0x29a7: 0x0100, 0x29a8: 0x0100, 0x29a9: 0x0100,
	0x29aa: 0x0100, 0x29ab: 0x0100, 0x29ac: 0x0100, 0x29ad: 0x0100,
	0x29b0: 0x0100, 0x29b1: 0x0100, 0x29b2: 0x0100, 0x29b3: 0x0100, 0x29b4: 0x0100, 0x29b5: 0x0100,
	0x29b6: 0x0100, 0x29b7: 0x0100, 0x29b8: 0x0100, 0x29b9: 0x0100, 0x29ba: 0x0100, 0x29bb: 0x0100,
	0x29bc: 0x0100, 0x29bd: 0x0100, 0x29be: 0x0100, 0x29bf: 0x0100,
	// Block 0xa7, offset 0x29c0
	0x29c0: 0x0100, 0x29c1: 0x0100, 0x29c2: 0x0100, 0x29c3: 0x0100, 0x29c4: 0x0100, 0x29c5: 0x0100,
	0x29c6: 0x0100, 0x29c7: 0x0100, 0x29c8: 0x0100, 0x29c9: 0x0100, 0x29ca: 0x0100, 0x29cb: 0x0100,
	0x29cc: 0x0100, 0x29cd: 0x0100, 0x29ce: 0x0100, 0x29cf: 0x0100, 0x29d0: 0x0100, 0x29d1: 0x0100,
	0x29d2: 0x0100, 0x29d3: 0x0100, 0x29d4: 0x0100, 0x29d5: 0x0100, 0x29d6: 0x0100, 0x29d7: 0x0100,
	0x29d8: 0x0100, 0x29d9: 0x0100,
	// Block 0xa8, offset 0x2a00
	0x2a00: 0x0040, 0x2a01: 0x0040, 0x2a02: 0x0040, 0x2a03: 0x0040, 0x2a04: 0x0040, 0x2a05: 0x0040,
	0x2a06: 0x0040,
	0x2a13: 0x0040, 0x2a14: 0x0040, 0x2a15: 0x0040, 0x2a16: 0x0040, 0x2a17: 0x0040,
	0x2a1d: 0x0100,
	0x2a1e: 0x0008, 0x2a1f: 0x0100, 0x2a20: 0x0100, 0x2a21: 0x0100, 0x2a22: 0x0100, 0x2a23: 0x0100,
	0x2a24: 0x0100, 0x2a25: 0x0100, 0x2a26: 0x0100, 0x2a27: 0x0100, 0x2a28: 0x0100,
	0x2a2a: 0x0100, 0x2a2b: 0x0100, 0x2a2c: 0x0100, 0x2a2d: 0x0100, 0x2a2e: 0x0100, 0x2a2f: 0x0100,
	0x2a30: 0x0100, 0x2a31: 0x0100, 0x2a32: 0x0100, 0x2a33: 0x0100, 0x2a34: 0x0100, 0x2a35: 0x0100,
	0x2a36: 0x0100, 0x2a38: 0x0100, 0x2a39: 0x0100, 0x2a3a: 0x0100, 0x2a3b: 0x0100,
	0x2a3c: 0x0100, 0x2a3e: 0x0100,
	// Block 0xa9, offset 0x2a40
	0x2a40: 0x0100, 0x2a41: 0x0100, 0x2a43: 0x0100, 0x2a44: 0x0100,
	0x2a46: 0x0100, 0x2a47: 0x0100, 0x2a48: 0x0100, 0x2a49: 0x0100, 0x2a4a: 0x0100, 0x2a4b: 0x0100,
	0x2a4c: 0x0100, 0x2a4d: 0x0100, 0x2a4e: 0x0100, 0x2a4f: 0x0100, 0x2a50: 0x0100, 0x2a51: 0x0100,
	0x2a52: 0x0100, 0x2a53: 0x0100, 0x2a54: 0x0100, 0x2a55: 0x0100, 0x2a56: 0x0100, 0x2a57: 0x0100,
	0x2a58: 0x0100, 0x2a59: 0x0100, 0x2a5a: 0x0100, 0x2a5b: 0x0100, 0x2a5c: 0x0100, 0x2a5d: 0x0100,
	0x2a5e: 0x0100, 0x2a5f: 0x0100, 0x2a60: 0x0100, 0x2a61: 0x0100, 0x2a62: 0x0100, 0x2a63: 0x0100,
	0x2a64: 0x0100, 0x2a65: 0x0100, 0x2a66: 0x0100, 0x2a67: 0x0100, 0x2a68: 0x0100, 0x2a69: 0x0100,
	0x2a6a: 0x0100, 0x2a6b: 0x0100, 0x2a6c: 0x0100, 0x2a6d: 0x0100, 0x2a6e: 0x0100, 0x2a6f: 0x0100,
	0x2a70: 0x0100, 0x2a71: 0x0100, 0x2a72: 0x0100, 0x2a73: 0x0100, 0x2a74: 0x0100, 0x2a75: 0x0100,
	0x2a76: 0x0100, 0x2a77: 0x0100, 0x2a78: 0x0100, 0x2a79: 0x0100, 0x2a7a: 0x0100, 0x2a7b: 0x0100,
	0x2a7c: 0x0100, 0x2a7d: 0x0100, 0x2a7e: 0x0100, 0x2a7f: 0x0100,
	// Block 0xaa, offset 0x2a80
	0x2a80: 0x0100, 0x2a81: 0x0100, 0x2a82: 0x0100, 0x2a83: 0x0100, 0x2a84: 0x0100, 0x2a85: 0x0100,
	0x2a86: 0x0100, 0x2a87: 0x0100, 0x2a88: 0x0100, 0x2a89: 0x0100, 0x2a8a: 0x0100, 0x2a8b: 0x0100,
	0x2a8c: 0x0100, 0x2a8d: 0x0100, 0x2a8e: 0x0100, 0x2a8f: 0x0100, 0x2a90: 0x0100, 0x2a91: 0x0100,
	0x2a92: 0x0100, 0x2a93: 0x0100, 0x2a94: 0x0100, 0x2a95: 0x0100, 0x2a96: 0x0100, 0x2a97: 0x0100,
	0x2a98: 0x0100, 0x2a99: 0x0100, 0x2a9a: 0x0100, 0x2a9b: 0x0100, 0x2a9c: 0x0100, 0x2a9d: 0x0100,
	0x2a9e: 0x0100, 0x2a9f: 0x0100, 0x2aa0: 0x0100, 0x2aa1: 0x0100, 0x2aa2: 0x0100, 0x2aa3: 0x0100,
	0x2aa4: 0x0100, 0x2aa5: 0x0100, 0x2aa6: 0x0100, 0x2aa7: 0x0100, 0x2aa8: 0x0100, 0x2aa9: 0x0100,
	0x2aaa: 0x0100, 0x2aab: 0x0100, 0x2aac: 0x0100, 0x2aad: 0x0100, 0x2aae: 0x0100, 0x2aaf: 0x0100,
	0x2ab0: 0x0100, 0x2ab1: 0x0100,
	// Block 0xab, offset 0x2ac0
	0x2ad3: 0x0100, 0x2ad4: 0x0100, 0x2ad5: 0x0100, 0x2ad6: 0x0100, 0x2ad7: 0x0100,
	0x2ad8: 0x0100, 0x2ad9: 0x0100, 0x2ada: 0x0100, 0x2adb: 0x0100, 0x2adc: 0x0100, 0x2add: 0x0100,
	0x2ade: 0x0100, 0x2adf: 0x0100, 0x2ae0: 0x0100, 0x2ae1: 0x0100, 0x2ae2: 0x0100, 0x2ae3: 0x0100,
	0x2ae4: 0x0100, 0x2ae5: 0x0100, 0x2ae6: 0x0100, 0x2ae7: 0x0100, 0x2ae8: 0x0100, 0x2ae9: 0x0100,
	0x2aea: 0x0100, 0x2aeb: 0x0100, 0x2aec: 0x0100, 0x2aed: 0x0100, 0x2aee: 0x0100, 0x2aef: 0x0100,
	0x2af0: 0x0100, 0x2af1: 0x0100, 0x2af2: 0x0100, 0x2af3: 0x0100, 0x2af4: 0x0100, 0x2af5: 0x0100,
	0x2af6: 0x0100, 0x2af7: 0x0100, 0x2af8: 0x0100, 0x2af9: 0x0100, 0x2afa: 0x0100, 0x2afb: 0x0100,
	0x2afc: 0x0100, 0x2afd: 0x0100, 0x2afe: 0x0100, 0x2aff: 0x0100,
	// Block 0xac, offset 0x2b00
	0x2b00: 0x0100, 0x2b01: 0x0100, 0x2b02: 0x0100, 0x2b03: 0x0100, 0x2b04: 0x0100, 0x2b05: 0x0100,
	0x2b06: 0x0100, 0x2b07: 0x0100, 0x2b08: 0x0100, 0x2b09: 0x0100, 0x2b0a: 0x0100, 0x2b0b: 0x0100,
	0x2b0c: 0x0100, 0x2b0d: 0x0100, 0x2b0e: 0x0100, 0x2b0f: 0x0100, 0x2b10: 0x0100, 0x2b11: 0x0100,
	0x2b12: 0x0100, 0x2b13: 0x0100, 0x2b14: 0x0100, 0x2b15: 0x0100, 0x2b16: 0x0100, 0x2b17: 0x0100,
	0x2b18: 0x0100, 0x2b19: 0x0100, 0x2b1a: 0x0100, 0x2b1b: 0x0100, 0x2b1c: 0x0100, 0x2b1d: 0x0100,
	0x2b1e: 0x0100, 0x2b1f: 0x0100, 0x2b20: 0x0100, 0x2b21: 0x0100, 0x2b22: 0x0100, 0x2b23: 0x0100,
	0x2b24: 0x0100, 0x2b25: 0x0100, 0x2b26: 0x0100, 0x2b27: 0x0100, 0x2b28: 0x0100, 0x2b29: 0x0100,
	0x2b2a: 0x0100, 0x2b2b: 0x0100, 0x2b2c: 0x0100, 0x2b2d: 0x0100, 0x2b2e: 0x0100, 0x2b2f: 0x0100,
	0x2b30: 0x0100, 0x2b31: 0x0100, 0x2b32: 0x0100, 0x2b33: 0x0100, 0x2b34: 0x0100, 0x2b35: 0x0100,
	0x2b36: 0x0100, 0x2b37: 0x0100, 0x2b38: 0x0100, 0x2b39: 0x0100, 0x2b3a: 0x0100, 0x2b3b: 0x0100,
	0x2b3c: 0x0100, 0x2b3d: 0x0100, 0x2b3e: 0x0004, 0x2b3f: 0x0004,
	// Block 0xad, offset 0x2b40
	0x2b50: 0x0100, 0x2b51: 0x0100,
	0x2b52: 0x0100, 0x2b53: 0x0100, 0x2b54: 0x0100, 0x2b55: 0x0100, 0x2b56: 0x0100, 0x2b57: 0x0100,
	0x2b58: 0x0100, 0x2b59: 0x0100, 0x2b5a: 0x0100, 0x2b5b: 0x0100, 0x2b5c: 0x0100, 0x2b5d: 0x0100,
	0x2b5e: 0x0100, 0x2b5f: 0x0100, 0x2b60: 0x0100, 0x2b61: 0x0100, 0x2b62: 0x0100, 0x2b63: 0x0100,
	0x2b64: 0x0100, 0x2b65: 0x0100, 0x2b66: 0x0100, 0x2b67: 0x0100, 0x2b68: 0x0100, 0x2b69: 0x0100,
	0x2b6a: 0x0100, 0x2b6b: 0x0100, 0x2b6c: 0x0100, 0x2b6d: 0x0100, 0x2b6e: 0x0100, 0x2b6f: 0x0100,
	0x2b70: 0x0100, 0x2b71: 0x0100, 0x2b72: 0x0100, 0x2b73: 0x0100, 0x2b74: 0x0100, 0x2b75: 0x0100,
	0x2b76: 0x0100, 0x2b77: 0x0100, 0x2b78: 0x0100, 0x2b79: 0x0100, 0x2b7a: 0x0100, 0x2b7b: 0x0100,
	0x2b7c: 0x0100, 0x2b7d: 0x0100, 0x2b7e: 0x0100, 0x2b7f: 0x0100,
	// Block 0xae, offset 0x2b80
	0x2b80: 0x0100, 0x2b81: 0x0100, 0x2b82: 0x0100, 0x2b83: 0x0100, 0x2b84: 0x0100, 0x2b85: 0x0100,
	0x2b86: 0x0100, 0x2b87: 0x0100, 0x2b88: 0x0100, 0x2b89: 0x0100, 0x2b8a: 0x0100, 0x2b8b: 0x0100,
	0x2b8c: 0x0100, 0x2b8d: 0x0100, 0x2b8e: 0x0100, 0x2b8f: 0x0100,
	0x2b92: 0x0100, 0x2b93: 0x0100, 0x2b94: 0x0100, 0x2b95: 0x0100, 0x2b96: 0x0100, 0x2b97: 0x0100,
	0x2b98: 0x0100, 0x2b99: 0x0100, 0x2b9a: 0x0100, 0x2b9b: 0x0100, 0x2b9c: 0x0100, 0x2b9d: 0x0100,
	0x2b9e: 0x0100, 0x2b9f: 0x0100, 0x2ba0: 0x0100, 0x2ba1: 0x0100, 0x2ba2: 0x0100, 0x2ba3: 0x0100,
	0x2ba4: 0x0100, 0x2ba5: 0x0100, 0x2ba6: 0x0100, 0x2ba7: 0x0100, 0x2ba8: 0x0100, 0x2ba9: 0x0100,
	0x2baa: 0x0100, 0x2bab: 0x0100, 0x2bac: 0x0100, 0x2bad: 0x0100, 0x2bae: 0x0100, 0x2baf: 0x0100,
	0x2bb0: 0x0100, 0x2bb1: 0x0100, 0x2bb2: 0x0100, 0x2bb3: 0x0100, 0x2bb4: 0x0100, 0x2bb5: 0x0100,
	0x2bb6: 0x0100, 0x2bb7: 0x0100, 0x2bb8: 0x0100, 0x2bb9: 0x0100, 0x2bba: 0x0100, 0x2bbb: 0x0100,
	0x2bbc: 0x0100, 0x2bbd: 0x0100, 0x2bbe: 0x0100, 0x2bbf: 0x0100,
	// Block 0xaf, offset 0x2bc0
	0x2bc0: 0x0100, 0x2bc1: 0x0100, 0x2bc2: 0x0100, 0x2bc3: 0x0100, 0x2bc4: 0x0100, 0x2bc5: 0x0100,
	0x2bc6: 0x0100, 0x2bc7: 0x0100,
	0x2bf0: 0x0100, 0x2bf1: 0x0100, 0x2bf2: 0x0100, 0x2bf3: 0x0100, 0x2bf4: 0x0100, 0x2bf5: 0x0100,
	0x2bf6: 0x0100, 0x2bf7: 0x0100, 0x2bf8: 0x0100, 0x2bf9: 0x0100, 0x2bfa: 0x0100, 0x2bfb: 0x0100,
	// Block 0xb0, offset 0x2c00
	0x2c00: 0x0008, 0x2c01: 0x0008, 0x2c02: 0x0008, 0x2c03: 0x0008, 0x2c04: 0x0008, 0x2c05: 0x0008,
	0x2c06: 0x0008, 0x2c07: 0x0008, 0x2c08: 0x0008, 0x2c09: 0x0008, 0x2c0a: 0x0008, 0x2c0b: 0x0008,
	0x2c0c: 0x0008, 0x2c0d: 0x0008, 0x2c0e: 0x0008, 0x2c0f: 0x0008, 0x2c10: 0x0200, 0x2c11: 0x0200,
	0x2c13: 0x0200, 0x2c17: 0x0004,
	0x2c18: 0x0004,
	0x2c20: 0x0008, 0x2c21: 0x0008, 0x2c22: 0x0008, 0x2c23: 0x0008,
	0x2c24: 0x0008, 0x2c25: 0x0008, 0x2c26: 0x0008, 0x2c27: 0x0008, 0x2c28: 0x0008, 0x2c29: 0x0008,
	0x2c2a: 0x0008, 0x2c2b: 0x0008, 0x2c2c: 0x0008, 0x2c2d: 0x0008, 0x2c2e: 0x0008, 0x2c2f: 0x0008,
	0x2c31: 0x0200, 0x2c32: 0x0200, 0x2c35: 0x0004,
	0x2c36: 0x0004, 0x2c37: 0x0004, 0x2c38: 0x0004, 0x2c39: 0x0004, 0x2c3a: 0x0004, 0x2c3b: 0x0004,
	0x2c3c: 0x0004, 0x2c3d: 0x0004, 0x2c3e: 0x0004, 0x2c3f: 0x0004,
	// Block 0xb1, offset 0x2c40
	0x2c40: 0x0004, 0x2c41: 0x0004, 0x2c42: 0x0004, 0x2c43: 0x0004, 0x2c44: 0x0004,
	0x2c47: 0x0004, 0x2c48: 0x0004,
	0x2c50: 0x0200, 0x2c51: 0x0200,
	0x2c52: 0x0001, 0x2c55: 0x0200, 0x2c56: 0x0400, 0x2c57: 0x0400,
	0x2c58: 0x0200, 0x2c59: 0x0004, 0x2c5a: 0x0004, 0x2c5b: 0x0004, 0x2c5c: 0x0004, 0x2c5d: 0x0004,
	0x2c5e: 0x0004, 0x2c63: 0x0200,
	0x2c70: 0x0100, 0x2c71: 0x0100, 0x2c72: 0x0100, 0x2c73: 0x0100, 0x2c74: 0x0100,
	0x2c76: 0x0100, 0x2c77: 0x0100, 0x2c78: 0x0100, 0x2c79: 0x0100, 0x2c7a: 0x0100, 0x2c7b: 0x0100,
	0x2c7c: 0x0100, 0x2c7d: 0x0100, 0x2c7e: 0x0100, 0x2c7f: 0x0100,
	// Block 0xb2, offset 0x2c80
	0x2c80: 0x0100, 0x2c81: 0x0100, 0x2c82: 0x0100, 0x2c83: 0x0100, 0x2c84: 0x0100, 0x2c85: 0x0100,
	0x2c86: 0x0100, 0x2c87: 0x0100, 0x2c88: 0x0100, 0x2c89: 0x0100, 0x2c8a: 0x0100, 0x2c8b: 0x0100,
	0x2c8c: 0x0100, 0x2c8d: 0x0100, 0x2c8e: 0x0100, 0x2c8f: 0x0100, 0x2c90: 0x0100, 0x2c91: 0x0100,
	0x2c92: 0x0100, 0x2c93: 0x0100, 0x2c94: 0x0100, 0x2c95: 0x0100, 0x2c96: 0x0100, 0x2c97: 0x0100,
	0x2c98: 0x0100, 0x2c99: 0x0100, 0x2c9a: 0x0100, 0x2c9b: 0x0100, 0x2c9c: 0x0100, 0x2c9d: 0x0100,
	0x2c9e: 0x0100, 0x2c9f: 0x0100, 0x2ca0: 0x0100, 0x2ca1: 0x0100, 0x2ca2: 0x0100, 0x2ca3: 0x0100,
	0x2ca4: 0x0100, 0x2ca5: 0x0100, 0x2ca6: 0x0100, 0x2ca7: 0x0100, 0x2ca8: 0x0100, 0x2ca9: 0x0100,
	0x2caa: 0x0100, 0x2cab: 0x0100, 0x2cac: 0x0100, 0x2cad: 0x0100, 0x2cae: 0x0100, 0x2caf: 0x0100,
	0x2cb0: 0x0100, 0x2cb1: 0x0100, 0x2cb2: 0x0100, 0x2cb3: 0x0100, 0x2cb4: 0x0100, 0x2cb5: 0x0100,
	0x2cb6: 0x0100, 0x2cb7: 0x0100, 0x2cb8: 0x0100, 0x2cb9: 0x0100, 0x2cba: 0x0100, 0x2cbb: 0x0100,
	0x2cbc: 0x0100, 0x2cbf: 0x0010,
	// Block 0xb3, offset 0x2cc0
	0x2cc1: 0x0400,
	0x2cc8: 0x0004, 0x2cc9: 0x0004,
	0x2ccc: 0x0200, 0x2ccd: 0x0200, 0x2cce: 0x0001, 0x2cd0: 0x0080, 0x2cd1: 0x0080,
	0x2cd2: 0x0080, 0x2cd3: 0x0080, 0x2cd4: 0x0080, 0x2cd5: 0x0080, 0x2cd6: 0x0080, 0x2cd7: 0x0080,
	0x2cd8: 0x0080, 0x2cd9: 0x0080, 0x2cda: 0x0200,
	0x2cdf: 0x0400, 0x2ce1: 0x2000, 0x2ce2: 0x2000, 0x2ce3: 0x2000,
	0x2ce4: 0x2000, 0x2ce5: 0x2000, 0x2ce6: 0x2000, 0x2ce7: 0x2000, 0x2ce8: 0x2000, 0x2ce9: 0x2000,
	0x2cea: 0x2000, 0x2ceb: 0x2000, 0x2cec: 0x2000, 0x2ced: 0x2000, 0x2cee: 0x2000, 0x2cef: 0x2000,
	0x2cf0: 0x2000, 0x2cf1: 0x2000, 0x2cf2: 0x2000, 0x2cf3: 0x2000, 0x2cf4: 0x2000, 0x2cf5: 0x2000,
	0x2cf6: 0x2000, 0x2cf7: 0x2000, 0x2cf8: 0x2000, 0x2cf9: 0x2000, 0x2cfa: 0x2000, 0x2cfb: 0x0004,
	0x2cfd: 0x0004,
	// Block 0xb4, offset 0x2d00
	0x2d01: 0x0040, 0x2d02: 0x0040, 0x2d03: 0x0040, 0x2d04: 0x0040, 0x2d05: 0x0040,
	0x2d06: 0x0040, 0x2d07: 0x0040, 0x2d08: 0x0040, 0x2d09: 0x0040, 0x2d0a: 0x0040, 0x2d0b: 0x0040,
	0x2d0c: 0x0040, 0x2d0d: 0x0040, 0x2d0e: 0x0040, 0x2d0f: 0x0040, 0x2d10: 0x0040, 0x2d11: 0x0040,
	0x2d12: 0x0040, 0x2d13: 0x0040, 0x2d14: 0x0040, 0x2d15: 0x0040, 0x2d16: 0x0040, 0x2d17: 0x0040,
	0x2d18: 0x0040, 0x2d19: 0x0040, 0x2d1a: 0x0040, 0x2d1b: 0x0004, 0x2d1d: 0x0004,
	0x2d1f: 0x0004, 0x2d20: 0x0004, 0x2d21: 0x0400, 0x2d22: 0x0004, 0x2d23: 0x0004,
	0x2d24: 0x0200, 0x2d26: 0x0100, 0x2d27: 0x0100, 0x2d28: 0x0100, 0x2d29: 0x0100,
	0x2d2a: 0x0100, 0x2d2b: 0x0100, 0x2d2c: 0x0100, 0x2d2d: 0x0100, 0x2d2e: 0x0100, 0x2d2f: 0x0100,
	0x2d30: 0x0100, 0x2d31: 0x0100, 0x2d32: 0x0100, 0x2d33: 0x0100, 0x2d34: 0x0100, 0x2d35: 0x0100,
	0x2d36: 0x0100, 0x2d37: 0x0100, 0x2d38: 0x0100, 0x2d39: 0x0100, 0x2d3a: 0x0100, 0x2d3b: 0x0100,
	0x2d3c: 0x0100, 0x2d3d: 0x0100, 0x2d3e: 0x0100, 0x2d3f: 0x0100,
	// Block 0xb5, offset 0x2d40
	0x2d40: 0x0100, 0x2d41: 0x0100, 0x2d42: 0x0100, 0x2d43: 0x0100, 0x2d44: 0x0100, 0x2d45: 0x0100,
	0x2d46: 0x0100, 0x2d47: 0x0100, 0x2d48: 0x0100, 0x2d49: 0x0100, 0x2d4a: 0x0100, 0x2d4b: 0x0100,
	0x2d4c: 0x0100, 0x2d4d: 0x0100, 0x2d4e: 0x0100, 0x2d4f: 0x0100, 0x2d50: 0x0100, 0x2d51: 0x0100,
	0x2d52: 0x0100, 0x2d53: 0x0100, 0x2d54: 0x0100, 0x2d55: 0x0100, 0x2d56: 0x0100, 0x2d57: 0x0100,
	0x2d58: 0x0100, 0x2d59: 0x0100, 0x2d5a: 0x0100, 0x2d5b: 0x0100, 0x2d5c: 0x0100, 0x2d5d: 0x0100,
	0x2d5e: 0x0008, 0x2d5f: 0x0008, 0x2d60: 0x0100, 0x2d61: 0x0100, 0x2d62: 0x0100, 0x2d63: 0x0100,
	0x2d64: 0x0100, 0x2d65: 0x0100, 0x2d66: 0x0100, 0x2d67: 0x0100, 0x2d68: 0x0100, 0x2d69: 0x0100,
	0x2d6a: 0x0100, 0x2d6b: 0x0100, 0x2d6c: 0x0100, 0x2d6d: 0x0100, 0x2d6e: 0x0100, 0x2d6f: 0x0100,
	0x2d70: 0x0100, 0x2d71: 0x0100, 0x2d72: 0x0100, 0x2d73: 0x0100, 0x2d74: 0x0100, 0x2d75: 0x0100,
	0x2d76: 0x0100, 0x2d77: 0x0100, 0x2d78: 0x0100, 0x2d79: 0x0100, 0x2d7a: 0x0100, 0x2d7b: 0x0100,
	0x2d7c: 0x0100, 0x2d7d: 0x0100, 0x2d7e: 0x0100,
	// Block 0xb6, offset 0x2d80
	0x2d82: 0x0100, 0x2d83: 0x0100, 0x2d84: 0x0100, 0x2d85: 0x0100,
	0x2d86: 0x0100, 0x2d87: 0x0100, 0x2d8a: 0x0100, 0x2d8b: 0x0100,
	0x2d8c: 0x0100, 0x2d8d: 0x0100, 0x2d8e: 0x0100, 0x2d8f: 0x0100,
	0x2d92: 0x0100, 0x2d93: 0x0100, 0x2d94: 0x0100, 0x2d95: 0x0100, 0x2d96: 0x0100, 0x2d97: 0x0100,
	0x2d9a: 0x0100, 0x2d9b: 0x0100, 0x2d9c: 0x0100,
	0x2db9: 0x0010, 0x2dba: 0x0010, 0x2dbb: 0x0010,
	// Block 0xb7, offset 0x2dc0
	0x2dc0: 0x0100, 0x2dc1: 0x0100, 0x2dc2: 0x0100, 0x2dc3: 0x0100, 0x2dc4: 0x0100, 0x2dc5: 0x0100,
	0x2dc6: 0x0100, 0x2dc7: 0x0100, 0x2dc8: 0x0100, 0x2dc9: 0x0100, 0x2dca: 0x0100, 0x2dcb: 0x0100,
	0x2dcd: 0x0100, 0x2dce: 0x0100, 0x2dcf: 0x0100, 0x2dd0: 0x0100, 0x2dd1: 0x0100,
	0x2dd2: 0x0100, 0x2dd3: 0x0100, 0x2dd4: 0x0100, 0x2dd5: 0x0100, 0x2dd6: 0x0100, 0x2dd7: 0x0100,
	0x2dd8: 0x0100, 0x2dd9: 0x0100, 0x2dda: 0x0100, 0x2ddb: 0x0100, 0x2ddc: 0x0100, 0x2ddd: 0x0100,
	0x2dde: 0x0100, 0x2ddf: 0x0100, 0x2de0: 0x0100, 0x2de1: 0x0100, 0x2de2: 0x0100, 0x2de3: 0x0100,
	0x2de4: 0x0100, 0x2de5: 0x0100, 0x2de6: 0x0100, 0x2de8: 0x0100, 0x2de9: 0x0100,
	0x2dea: 0x0100, 0x2deb: 0x0100, 0x2dec: 0x0100, 0x2ded: 0x0100, 0x2dee: 0x0100, 0x2def: 0x0100,
	0x2df0: 0x0100, 0x2df1: 0x0100, 0x2df2: 0x0100, 0x2df3: 0x0100, 0x2df4: 0x0100, 0x2df5: 0x0100,
	0x2df6: 0x0100, 0x2df7: 0x0100, 0x2df8: 0x0100, 0x2df9: 0x0100, 0x2dfa: 0x0100,
	0x2dfc: 0x0100, 0x2dfd: 0x0100, 0x2dff: 0x0100,
	// Block 0xb8, offset 0x2e00
	0x2e00: 0x0100, 0x2e01: 0x0100, 0x2e02: 0x0100, 0x2e03: 0x0100, 0x2e04: 0x0100, 0x2e05: 0x0100,
	0x2e06: 0x0100, 0x2e07: 0x0100, 0x2e08: 0x0100, 0x2e09: 0x0100, 0x2e0a: 0x0100, 0x2e0b: 0x0100,
	0x2e0c: 0x0100, 0x2e0d: 0x0100, 0x2e10: 0x0100, 0x2e11: 0x0100,
	0x2e12: 0x0100, 0x2e13: 0x0100, 0x2e14: 0x0100, 0x2e15: 0x0100, 0x2e16: 0x0100, 0x2e17: 0x0100,
	0x2e18: 0x0100, 0x2e19: 0x0100, 0x2e1a: 0x0100, 0x2e1b: 0x0100, 0x2e1c: 0x0100, 0x2e1d: 0x0100,
	// Block 0xb9, offset 0x2e40
	0x2e40: 0x0100, 0x2e41: 0x0100, 0x2e42: 0x0100, 0x2e43: 0x0100, 0x2e44: 0x0100, 0x2e45: 0x0100,
	0x2e46: 0x0100, 0x2e47: 0x0100, 0x2e48: 0x0100, 0x2e49: 0x0100, 0x2e4a: 0x0100, 0x2e4b: 0x0100,
	0x2e4c: 0x0100, 0x2e4d: 0x0100, 0x2e4e: 0x0100, 0x2e4f: 0x0100, 0x2e50: 0x0100, 0x2e51: 0x0100,
	0x2e52: 0x0100, 0x2e53: 0x0100, 0x2e54: 0x0100, 0x2e55: 0x0100, 0x2e56: 0x0100, 0x2e57: 0x0100,
	0x2e58: 0x0100, 0x2e59: 0x0100, 0x2e5a: 0x0100, 0x2e5b: 0x0100, 0x2e5c: 0x0100, 0x2e5d: 0x0100,
	0x2e5e: 0x0100, 0x2e5f: 0x0100, 0x2e60: 0x0100, 0x2e61: 0x0100, 0x2e62: 0x0100, 0x2e63: 0x0100,
	0x2e64: 0x0100, 0x2e65: 0x0100, 0x2e66: 0x0100, 0x2e67: 0x0100, 0x2e68: 0x0100, 0x2e69: 0x0100,
	0x2e6a: 0x0100, 0x2e6b: 0x0100, 0x2e6c: 0x0100, 0x2e6d: 0x0100, 0x2e6e: 0x0100, 0x2e6f: 0x0100,
	0x2e70: 0x0100, 0x2e71: 0x0100, 0x2e72: 0x0100, 0x2e73: 0x0100, 0x2e74: 0x0100, 0x2e75: 0x0100,
	0x2e76: 0x0100, 0x2e77: 0x0100, 0x2e78: 0x0100, 0x2e79: 0x0100, 0x2e7a: 0x0100,
	// Block 0xba, offset 0x2e80
	0x2e80: 0x0100, 0x2e81: 0x0100, 0x2e82: 0x0100, 0x2e83: 0x0100, 0x2e84: 0x0100, 0x2e85: 0x0100,
	0x2e86: 0x0100, 0x2e87: 0x0100, 0x2e88: 0x0100, 0x2e89: 0x0100, 0x2e8a: 0x0100, 0x2e8b: 0x0100,
	0x2e8c: 0x0100, 0x2e8d: 0x0100, 0x2e8e: 0x0100, 0x2e8f: 0x0100, 0x2e90: 0x0100, 0x2e91: 0x0100,
	0x2e92: 0x0100, 0x2e93: 0x0100, 0x2e94: 0x0100, 0x2e95: 0x0100, 0x2e96: 0x0100, 0x2e97: 0x0100,
	0x2e98: 0x0100, 0x2e99: 0x0100, 0x2e9a: 0x0100, 0x2e9b: 0x0100, 0x2e9c: 0x0100, 0x2e9d: 0x0100,
	0x2e9e: 0x0100, 0x2e9f: 0x0100, 0x2ea0: 0x0100, 0x2ea1: 0x0100, 0x2ea2: 0x0100, 0x2ea3: 0x0100,
	0x2ea4: 0x0100, 0x2ea5: 0x0100, 0x2ea6: 0x0100, 0x2ea7: 0x0100, 0x2ea8: 0x0100, 0x2ea9: 0x0100,
	0x2eaa: 0x0100, 0x2eab: 0x0100, 0x2eac: 0x0100, 0x2ead: 0x0100, 0x2eae: 0x0100, 0x2eaf: 0x0100,
	0x2eb0: 0x0100, 0x2eb1: 0x0100, 0x2eb2: 0x0100, 0x2eb3: 0x0100, 0x2eb4: 0x0100,
	// Block 0xbb, offset 0x2ec0
	0x2efd: 0x0008,
	// Block 0xbc, offset 0x2f00
	0x2f00: 0x0100, 0x2f01: 0x0100, 0x2f02: 0x0100, 0x2f03: 0x0100, 0x2f04: 0x0100, 0x2f05: 0x0100,
	0x2f06: 0x0100, 0x2f07: 0x0100, 0x2f08: 0x0100, 0x2f09: 0x0100, 0x2f0a: 0x0100, 0x2f0b: 0x0100,
	0x2f0c: 0x0100, 0x2f0d: 0x0100, 0x2f0e: 0x0100, 0x2f0f: 0x0100, 0x2f10: 0x0100, 0x2f11: 0x0100,
	0x2f12: 0x0100, 0x2f13: 0x0100, 0x2f14: 0x0100, 0x2f15: 0x0100, 0x2f16: 0x0100, 0x2f17: 0x0100,
	0x2f18: 0x0100, 0x2f19: 0x0100, 0x2f1a: 0x0100, 0x2f1b: 0x0100, 0x2f1c: 0x0100,
	0x2f20: 0x0100, 0x2f21: 0x0100, 0x2f22: 0x0100, 0x2f23: 0x0100,
	0x2f24: 0x0100, 0x2f25: 0x0100, 0x2f26: 0x0100, 0x2f27: 0x0100, 0x2f28: 0x0100, 0x2f29: 0x0100,
	0x2f2a: 0x0100, 0x2f2b: 0x0100, 0x2f2c: 0x0100, 0x2f2d: 0x0100, 0x2f2e: 0x0100, 0x2f2f: 0x0100,
	0x2f30: 0x0100, 0x2f31: 0x0100, 0x2f32: 0x0100, 0x2f33: 0x0100, 0x2f34: 0x0100, 0x2f35: 0x0100,
	0x2f36: 0x0100, 0x2f37: 0x0100, 0x2f38: 0x0100, 0x2f39: 0x0100, 0x2f3a: 0x0100, 0x2f3b: 0x0100,
	0x2f3c: 0x0100, 0x2f3d: 0x0100, 0x2f3e: 0x0100, 0x2f3f: 0x0100,
	// Block 0xbd, offset 0x2f40
	0x2f40: 0x0100, 0x2f41: 0x0100, 0x2f42: 0x0100, 0x2f43: 0x0100, 0x2f44: 0x0100, 0x2f45: 0x0100,
	0x2f46: 0x0100, 0x2f47: 0x0100, 0x2f48: 0x0100, 0x2f49: 0x0100, 0x2f4a: 0x0100, 0x2f4b: 0x0100,
	0x2f4c: 0x0100, 0x2f4d: 0x0100, 0x2f4e: 0x0100, 0x2f4f: 0x0100, 0x2f50: 0x0100,
	0x2f60: 0x0008,
	// Block 0xbe, offset 0x2f80
	0x2f80: 0x0100, 0x2f81: 0x0100, 0x2f82: 0x0100, 0x2f83: 0x0100, 0x2f84: 0x0100, 0x2f85: 0x0100,
	0x2f86: 0x0100, 0x2f87: 0x0100, 0x2f88: 0x0100, 0x2f89: 0x0100, 0x2f8a: 0x0100, 0x2f8b: 0x0100,
	0x2f8c: 0x0100, 0x2f8d: 0x0100, 0x2f8e: 0x0100, 0x2f8f: 0x0100, 0x2f90: 0x0100, 0x2f91: 0x0100,
	0x2f92: 0x0100, 0x2f93: 0x0100, 0x2f94: 0x0100, 0x2f95: 0x0100, 0x2f96: 0x0100, 0x2f97: 0x0100,
	0x2f98: 0x0100, 0x2f99: 0x0100, 0x2f9a: 0x0100, 0x2f9b: 0x0100, 0x2f9c: 0x0100, 0x2f9d: 0x0100,
	0x2f9e: 0x0100, 0x2f9f: 0x0100,
	0x2fad: 0x0100, 0x2fae: 0x0100, 0x2faf: 0x0100,
	0x2fb0: 0x0100, 0x2fb1: 0x0100, 0x2fb2: 0x0100, 0x2fb3: 0x0100, 0x2fb4: 0x0100, 0x2fb5: 0x0100,
	0x2fb6: 0x0100, 0x2fb7: 0x0100, 0x2fb8: 0x0100, 0x2fb9: 0x0100, 0x2fba: 0x0100, 0x2fbb: 0x0100,
	0x2fbc: 0x0100, 0x2fbd: 0x0100, 0x2fbe: 0x0100, 0x2fbf: 0x0100,
	// Block 0xbf, offset 0x2fc0
	0x2fc0: 0x0100, 0x2fc1: 0x0100, 0x2fc2: 0x0100, 0x2fc3: 0x0100, 0x2fc4: 0x0100, 0x2fc5: 0x0100,
	0x2fc6: 0x0100, 0x2fc7: 0x0100, 0x2fc8: 0x0100, 0x2fc9: 0x0100, 0x2fca: 0x0100,
	0x2fd0: 0x0100, 0x2fd1: 0x0100,
	0x2fd2: 0x0100, 0x2fd3: 0x0100, 0x2fd4: 0x0100, 0x2fd5: 0x0100, 0x2fd6: 0x0100, 0x2fd7: 0x0100,
	0x2fd8: 0x0100, 0x2fd9: 0x0100, 0x2fda: 0x0100, 0x2fdb: 0x0100, 0x2fdc: 0x0100, 0x2fdd: 0x0100,
	0x2fde: 0x0100, 0x2fdf: 0x0100, 0x2fe0: 0x0100, 0x2fe1: 0x0100, 0x2fe2: 0x0100, 0x2fe3: 0x0100,
	0x2fe4: 0x0100, 0x2fe5: 0x0100, 0x2fe6: 0x0100, 0x2fe7: 0x0100, 0x2fe8: 0x0100, 0x2fe9: 0x0100,
	0x2fea: 0x0100, 0x2feb: 0x0100, 0x2fec: 0x0100, 0x2fed: 0x0100, 0x2fee: 0x0100, 0x2fef: 0x0100,
	0x2ff0: 0x0100, 0x2ff1: 0x0100, 0x2ff2: 0x0100, 0x2ff3: 0x0100, 0x2ff4: 0x0100, 0x2ff5: 0x0100,
	0x2ff6: 0x0008, 0x2ff7: 0x0008, 0x2ff8: 0x0008, 0x2ff9: 0x0008, 0x2ffa: 0x0008,
	// Block 0xc0, offset 0x3000
	0x3000: 0x0100, 0x3001: 0x0100, 0x3002: 0x0100, 0x3003: 0x0100, 0x3004: 0x0100, 0x3005: 0x0100,
	0x3006: 0x0100, 0x3007: 0x0100, 0x3008: 0x0100, 0x3009: 0x0100, 0x300a: 0x0100, 0x300b: 0x0100,
	0x300c: 0x0100, 0x300d: 0x0100, 0x300e: 0x0100, 0x300f: 0x0100, 0x3010: 0x0100, 0x3011: 0x0100,
	0x3012: 0x0100, 0x3013: 0x0100, 0x3014: 0x0100, 0x3015: 0x0100, 0x3016: 0x0100, 0x3017: 0x0100,
	0x3018: 0x0100, 0x3019: 0x0100, 0x301a: 0x0100, 0x301b: 0x0100, 0x301c: 0x0100, 0x301d: 0x0100,
	0x3020: 0x0100, 0x3021: 0x0100, 0x3022: 0x0100, 0x3023: 0x0100,
	0x3024: 0x0100, 0x3025: 0x0100, 0x3026: 0x0100, 0x3027: 0x0100, 0x3028: 0x0100, 0x3029: 0x0100,
	0x302a: 0x0100, 0x302b: 0x0100, 0x302c: 0x0100, 0x302d: 0x0100, 0x302e: 0x0100, 0x302f: 0x0100,
	0x3030: 0x0100, 0x3031: 0x0100, 0x3032: 0x0100, 0x3033: 0x0100, 0x3034: 0x0100, 0x3035: 0x0100,
	0x3036: 0x0100, 0x3037: 0x0100, 0x3038: 0x0100, 0x3039: 0x0100, 0x303a: 0x0100, 0x303b: 0x0100,
	0x303c: 0x0100, 0x303d: 0x0100, 0x303e: 0x0100, 0x303f: 0x0100,
	// Block 0xc1, offset 0x3040
	0x3040: 0x0100, 0x3041: 0x0100, 0x3042: 0x0100, 0x3043: 0x0100,
	0x3048: 0x0100, 0x3049: 0x0100, 0x304a: 0x0100, 0x304b: 0x0100,
	0x304c: 0x0100, 0x304d: 0x0100, 0x304e: 0x0100, 0x304f: 0x0100, 0x3051: 0x0100,
	0x3052: 0x0100, 0x3053: 0x0100, 0x3054: 0x0100, 0x3055: 0x0100,
	// Block 0xc2, offset 0x3080
	0x3080: 0x2000, 0x3081: 0x2000, 0x3082: 0x2000, 0x3083: 0x2000, 0x3084: 0x2000, 0x3085: 0x2000,
	0x3086: 0x2000, 0x3087: 0x2000, 0x3088: 0x2000, 0x3089: 0x2000, 0x308a: 0x2000, 0x308b: 0x2000,
	0x308c: 0x2000, 0x308d: 0x2000, 0x308e: 0x2000, 0x308f: 0x2000, 0x3090: 0x2000, 0x3091: 0x2000,
	0x3092: 0x2000, 0x3093: 0x2000, 0x3094: 0x2000, 0x3095: 0x2000, 0x3096: 0x2000, 0x3097: 0x2000,
	0x3098: 0x2000, 0x3099: 0x2000, 0x309a: 0x2000, 0x309b: 0x2000, 0x309c: 0x2000, 0x309d: 0x2000,
	0x309e: 0x2000, 0x309f: 0x2000, 0x30a0: 0x2000, 0x30a1: 0x2000, 0x30a2: 0x2000, 0x30a3: 0x2000,
	0x30a4: 0x2000, 0x30a5: 0x2000, 0x30a6: 0x2000, 0x30a7: 0x2000, 0x30a8: 0x0040, 0x30a9: 0x0040,
	0x30aa: 0x0040, 0x30ab: 0x0040, 0x30ac: 0x0040, 0x30ad: 0x0040, 0x30ae: 0x0040, 0x30af: 0x0040,
	0x30b0: 0x0040, 0x30b1: 0x0040, 0x30b2: 0x0040, 0x30b3: 0x0040, 0x30b4: 0x0040, 0x30b5: 0x0040,
	0x30b6: 0x0040, 0x30b7: 0x0040, 0x30b8: 0x0040, 0x30b9: 0x0040, 0x30ba: 0x0040, 0x30bb: 0x0040,
	0x30bc: 0x0040, 0x30bd: 0x0040, 0x30be: 0x0040, 0x30bf: 0x0040,
	// Block 0xc3, offset 0x30c0
	0x30c0: 0x0040, 0x30c1: 0x0040, 0x30c2: 0x0040, 0x30c3: 0x0040, 0x30c4: 0x0040, 0x30c5: 0x0040,
	0x30c6: 0x0040, 0x30c7: 0x0040, 0x30c8: 0x0040, 0x30c9: 0x0040, 0x30ca: 0x0040, 0x30cb: 0x0040,
	0x30cc: 0x0040, 0x30cd: 0x0040, 0x30ce: 0x0040, 0x30cf: 0x0040, 0x30d0: 0x0100, 0x30d1: 0x0100,
	0x30d2: 0x0100, 0x30d3: 0x0100, 0x30d4: 0x0100, 0x30d5: 0x0100, 0x30d6: 0x0100, 0x30d7: 0x0100,
	0x30d8: 0x0100, 0x30d9: 0x0100, 0x30da: 0x0100, 0x30db: 0x0100, 0x30dc: 0x0100, 0x30dd: 0x0100,
	0x30de: 0x0100, 0x30df: 0x0100, 0x30e0: 0x0100, 0x30e1: 0x0100, 0x30e2: 0x0100, 0x30e3: 0x0100,
	0x30e4: 0x0100, 0x30e5: 0x0100, 0x30e6: 0x0100, 0x30e7: 0x0100, 0x30e8: 0x0100, 0x30e9: 0x0100,
	0x30ea: 0x0100, 0x30eb: 0x0100, 0x30ec: 0x0100, 0x30ed: 0x0100, 0x30ee: 0x0100, 0x30ef: 0x0100,
	0x30f0: 0x0100, 0x30f1: 0x0100, 0x30f2: 0x0100, 0x30f3: 0x0100, 0x30f4: 0x0100, 0x30f5: 0x0100,
	0x30f6: 0x0100, 0x30f7: 0x0100, 0x30f8: 0x0100, 0x30f9: 0x0100, 0x30fa: 0x0100, 0x30fb: 0x0100,
	0x30fc: 0x0100, 0x30fd: 0x0100, 0x30fe: 0x0100, 0x30ff: 0x0100,
	// Block 0xc4, offset 0x3100
	0x3100: 0x0100, 0x3101: 0x0100, 0x3102: 0x0100, 0x3103: 0x0100, 0x3104: 0x0100, 0x3105: 0x0100,
	0x3106: 0x0100, 0x3107: 0x0100, 0x3108: 0x0100, 0x3109: 0x0100, 0x310a: 0x0100, 0x310b: 0x0100,
	0x310c: 0x0100, 0x310d: 0x0100, 0x310e: 0x0100, 0x310f: 0x0100, 0x3110: 0x0100, 0x3111: 0x0100,
	0x3112: 0x0100, 0x3113: 0x0100, 0x3114: 0x0100, 0x3115: 0x0100, 0x3116: 0x0100, 0x3117: 0x0100,
	0x3118: 0x0100, 0x3119: 0x0100, 0x311a: 0x0100, 0x311b: 0x0100, 0x311c: 0x0100, 0x311d: 0x0100,
	0x3120: 0x0080, 0x3121: 0x0080, 0x3122: 0x0080, 0x3123: 0x0080,
	0x3124: 0x0080, 0x3125: 0x0080, 0x3126: 0x0080, 0x3127: 0x0080, 0x3128: 0x0080, 0x3129: 0x0080,
	0x3130: 0x2000, 0x3131: 0x2000, 0x3132: 0x2000, 0x3133: 0x2000, 0x3134: 0x2000, 0x3135: 0x2000,
	0x3136: 0x2000, 0x3137: 0x2000, 0x3138: 0x2000, 0x3139: 0x2000, 0x313a: 0x2000, 0x313b: 0x2000,
	0x313c: 0x2000, 0x313d: 0x2000, 0x313e: 0x2000, 0x313f: 0x2000,
	// Block 0xc5, offset 0x3140
	0x3140: 0x2000, 0x3141: 0x2000, 0x3142: 0x2000, 0x3143: 0x2000, 0x3144: 0x2000, 0x3145: 0x2000,
	0x3146: 0x2000, 0x3147: 0x2000, 0x3148: 0x2000, 0x3149: 0x2000, 0x314a: 0x2000, 0x314b: 0x2000,
	0x314c: 0x2000, 0x314d: 0x2000, 0x314e: 0x2000, 0x314f: 0x2000, 0x3150: 0x2000, 0x3151: 0x2000,
	0x3152: 0x2000, 0x3153: 0x2000,
	0x3158: 0x0040, 0x3159: 0x0040, 0x315a: 0x0040, 0x315b: 0x0040, 0x315c: 0x0040, 0x315d: 0x0040,
	0x315e: 0x0040, 0x315f: 0x0040, 0x3160: 0x0040, 0x3161: 0x0040, 0x3162: 0x0040, 0x3163: 0x0040,
	0x3164: 0x0040, 0x3165: 0x0040, 0x3166: 0x0040, 0x3167: 0x0040, 0x3168: 0x0040, 0x3169: 0x0040,
	0x316a: 0x0040, 0x316b: 0x0040, 0x316c: 0x0040, 0x316d: 0x0040, 0x316e: 0x0040, 0x316f: 0x0040,
	0x3170: 0x0040, 0x3171: 0x0040, 0x3172: 0x0040, 0x3173: 0x0040, 0x3174: 0x0040, 0x3175: 0x0040,
	0x3176: 0x0040, 0x3177: 0x0040, 0x3178: 0x0040, 0x3179: 0x0040, 0x317a: 0x0040, 0x317b: 0x0040,
	// Block 0xc6, offset 0x3180
	0x3180: 0x0100, 0x3181: 0x0100, 0x3182: 0x0100, 0x3183: 0x0100, 0x3184: 0x0100, 0x3185: 0x0100,
	0x3186: 0x0100, 0x3187: 0x0100, 0x3188: 0x0100, 0x3189: 0x0100, 0x318a: 0x0100, 0x318b: 0x0100,
	0x318c: 0x0100, 0x318d: 0x0100, 0x318e: 0x0100, 0x318f: 0x0100, 0x3190: 0x0100, 0x3191: 0x0100,
	0x3192: 0x0100, 0x3193: 0x0100, 0x3194: 0x0100, 0x3195: 0x0100, 0x3196: 0x0100, 0x3197: 0x0100,
	0x3198: 0x0100, 0x3199: 0x0100, 0x319a: 0x0100, 0x319b: 0x0100, 0x319c: 0x0100, 0x319d: 0x0100,
	0x319e: 0x0100, 0x319f: 0x0100, 0x31a0: 0x0100, 0x31a1: 0x0100, 0x31a2: 0x0100, 0x31a3: 0x0100,
	0x31a4: 0x0100, 0x31a5: 0x0100, 0x31a6: 0x0100, 0x31a7: 0x0100,
	0x31b0: 0x0100, 0x31b1: 0x0100, 0x31b2: 0x0100, 0x31b3: 0x0100, 0x31b4: 0x0100, 0x31b5: 0x0100,
	0x31b6: 0x0100, 0x31b7: 0x0100, 0x31b8: 0x0100, 0x31b9: 0x0100, 0x31ba: 0x0100, 0x31bb: 0x0100,
	0x31bc: 0x0100, 0x31bd: 0x0100, 0x31be: 0x0100, 0x31bf: 0x0100,
	// Block 0xc7, offset 0x31c0
	0x31c0: 0x0100, 0x31c1: 0x0100, 0x31c2: 0x0100, 0x31c3: 0x0100, 0x31c4: 0x0100, 0x31c5: 0x0100,
	0x31c6: 0x0100, 0x31c7: 0x0100, 0x31c8: 0x0100, 0x31c9: 0x0100, 0x31ca: 0x0100, 0x31cb: 0x0100,
	0x31cc: 0x0100, 0x31cd: 0x0100, 0x31ce: 0x0100, 0x31cf: 0x0100, 0x31d0: 0x0100, 0x31d1: 0x0100,
	0x31d2: 0x0100, 0x31d3: 0x0100, 0x31d4: 0x0100, 0x31d5: 0x0100, 0x31d6: 0x0100, 0x31d7: 0x0100,
	0x31d8: 0x0100, 0x31d9: 0x0100, 0x31da: 0x0100, 0x31db: 0x0100, 0x31dc: 0x0100, 0x31dd: 0x0100,
	0x31de: 0x0100, 0x31df: 0x0100, 0x31e0: 0x0100, 0x31e1: 0x0100, 0x31e2: 0x0100, 0x31e3: 0x0100,
	0x31f0: 0x2000, 0x31f1: 0x2000, 0x31f2: 0x2000, 0x31f3: 0x2000, 0x31f4: 0x2000, 0x31f5: 0x2000,
	0x31f6: 0x2000, 0x31f7: 0x2000, 0x31f8: 0x2000, 0x31f9: 0x2000, 0x31fa: 0x2000,
	0x31fc: 0x2000, 0x31fd: 0x2000, 0x31fe: 0x2000, 0x31ff: 0x2000,
	// Block 0xc8, offset 0x3200
	0x3200: 0x2000, 0x3201: 0x2000, 0x3202: 0x2000, 0x3203: 0x2000, 0x3204: 0x2000, 0x3205: 0x2000,
	0x3206: 0x2000, 0x3207: 0x2000, 0x3208: 0x2000, 0x3209: 0x2000, 0x320a: 0x2000,
	0x320c: 0x2000, 0x320d: 0x2000, 0x320e: 0x2000, 0x320f: 0x2000, 0x3210: 0x2000, 0x3211: 0x2000,
	0x3212: 0x2000, 0x3214: 0x2000, 0x3215: 0x2000, 0x3217: 0x0040,
	0x3218: 0x0040, 0x3219: 0x0040, 0x321a: 0x0040, 0x321b: 0x0040, 0x321c: 0x0040, 0x321d: 0x0040,
	0x321e: 0x0040, 0x321f: 0x0040, 0x3220: 0x0040, 0x3221: 0x0040, 0x3223: 0x0040,
	0x3224: 0x0040, 0x3225: 0x0040, 0x3226: 0x0040, 0x3227: 0x0040, 0x3228: 0x0040, 0x3229: 0x0040,
	0x322a: 0x0040, 0x322b: 0x0040, 0x322c: 0x0040, 0x322d: 0x0040, 0x322e: 0x0040, 0x322f: 0x0040,
	0x3230: 0x0040, 0x3231: 0x0040, 0x3233: 0x0040, 0x3234: 0x0040, 0x3235: 0x0040,
	0x3236: 0x0040, 0x3237: 0x0040, 0x3238: 0x0040, 0x3239: 0x0040, 0x323b: 0x0040,
	0x323c: 0x0040,
	// Block 0xc9, offset 0x3240
	0x3240: 0x0100, 0x3241: 0x0100, 0x3242: 0x0100, 0x3243: 0x0100, 0x3244: 0x0100, 0x3245: 0x0100,
	0x3246: 0x0100, 0x3247: 0x0100, 0x3248: 0x0100, 0x3249: 0x0100, 0x324a: 0x0100, 0x324b: 0x0100,
	0x324c: 0x0100, 0x324d: 0x0100, 0x324e: 0x0100, 0x324f: 0x0100, 0x3250: 0x0100, 0x3251: 0x0100,
	0x3252: 0x0100, 0x3253: 0x0100, 0x3254: 0x0100, 0x3255: 0x0100, 0x3256: 0x0100, 0x3257: 0x0100,
	0x3258: 0x0100, 0x3259: 0x0100, 0x325a: 0x0100, 0x325b: 0x0100, 0x325c: 0x0100, 0x325d: 0x0100,
	0x325e: 0x0100, 0x325f: 0x0100, 0x3260: 0x0100, 0x3261: 0x0100, 0x3262: 0x0100, 0x3263: 0x0100,
	0x3264: 0x0100, 0x3265: 0x0100, 0x3266: 0x0100, 0x3267: 0x0100, 0x3268: 0x0100, 0x3269: 0x0100,
	0x326a: 0x0100, 0x326b: 0x0100, 0x326c: 0x0100, 0x326d: 0x0100, 0x326e: 0x0100, 0x326f: 0x0100,
	0x3270: 0x0100, 0x3271: 0x0100, 0x3272: 0x0100, 0x3273: 0x0100, 0x3274: 0x0100, 0x3275: 0x0100,
	0x3276: 0x0100,
	// Block 0xca, offset 0x3280
	0x3280: 0x0100, 0x3281: 0x0100, 0x3282: 0x0100, 0x3283: 0x0100, 0x3284: 0x0100, 0x3285: 0x0100,
	0x3286: 0x0100, 0x3287: 0x0100, 0x3288: 0x0100, 0x3289: 0x0100, 0x328a: 0x0100, 0x328b: 0x0100,
	0x328c: 0x0100, 0x328d: 0x0100, 0x328e: 0x0100, 0x328f: 0x0100, 0x3290: 0x0100, 0x3291: 0x0100,
	0x3292: 0x0100, 0x3293: 0x0100, 0x3294: 0x0100, 0x3295: 0x0100,
	0x32a0: 0x0100, 0x32a1: 0x0100, 0x32a2: 0x0100, 0x32a3: 0x0100,
	0x32a4: 0x0100, 0x32a5: 0x0100, 0x32a6: 0x0100, 0x32a7: 0x0100,
	// Block 0xcb, offset 0x32c0
	0x32c0: 0x0040, 0x32c1: 0x0100, 0x32c2: 0x0100, 0x32c3: 0x0040, 0x32c4: 0x0040, 0x32c5: 0x0040,
	0x32c7: 0x0040, 0x32c8: 0x0040, 0x32c9: 0x0040, 0x32ca: 0x0040, 0x32cb: 0x0040,
	0x32cc: 0x0040, 0x32cd: 0x0040, 0x32ce: 0x0040, 0x32cf: 0x0040, 0x32d0: 0x0040, 0x32d1: 0x0040,
	0x32d2: 0x0040, 0x32d3: 0x0040, 0x32d4: 0x0040, 0x32d5: 0x0040, 0x32d6: 0x0040, 0x32d7: 0x0040,
	0x32d8: 0x0040, 0x32d9: 0x0040, 0x32da: 0x0040, 0x32db: 0x0040, 0x32dc: 0x0040, 0x32dd: 0x0040,
	0x32de: 0x0040, 0x32df: 0x0040, 0x32e0: 0x0040, 0x32e1: 0x0040, 0x32e2: 0x0040, 0x32e3: 0x0040,
	0x32e4: 0x0040, 0x32e5: 0x0040, 0x32e6: 0x0040, 0x32e7: 0x0040, 0x32e8: 0x0040, 0x32e9: 0x0040,
	0x32ea: 0x0040, 0x32eb: 0x0040, 0x32ec: 0x0040, 0x32ed: 0x0040, 0x32ee: 0x0040, 0x32ef: 0x0040,
	0x32f0: 0x0040, 0x32f2: 0x0040, 0x32f3: 0x0040, 0x32f4: 0x0040, 0x32f5: 0x0040,
	0x32f6: 0x0040, 0x32f7: 0x0040, 0x32f8: 0x0040, 0x32f9: 0x0040, 0x32fa: 0x0040,
	// Block 0xcc, offset 0x3300
	0x3300: 0x0100, 0x3301: 0x0100, 0x3302: 0x0100, 0x3303: 0x0100, 0x3304: 0x0100, 0x3305: 0x0100,
	0x3308: 0x0100, 0x330a: 0x0100, 0x330b: 0x0100,
	0x330c: 0x0100, 0x330d: 0x0100, 0x330e: 0x0100, 0x330f: 0x0100, 0x3310: 0x0100, 0x3311: 0x0100,
	0x3312: 0x0100, 0x3313: 0x0100, 0x3314: 0x0100, 0x3315: 0x0100, 0x3316: 0x0100, 0x3317: 0x0100,
	0x3318: 0x0100, 0x3319: 0x0100, 0x331a: 0x0100, 0x331b: 0x0100, 0x331c: 0x0100, 0x331d: 0x0100,
	0x331e: 0x0100, 0x331f: 0x0100, 0x3320: 0x0100, 0x3321: 0x0100, 0x3322: 0x0100, 0x3323: 0x0100,
	0x3324: 0x0100, 0x3325: 0x0100, 0x3326: 0x0100, 0x3327: 0x0100, 0x3328: 0x0100, 0x3329: 0x0100,
	0x332a: 0x0100, 0x332b: 0x0100, 0x332c: 0x0100, 0x332d: 0x0100, 0x332e: 0x0100, 0x332f: 0x0100,
	0x3330: 0x0100, 0x3331: 0x0100, 0x3332: 0x0100, 0x3333: 0x0100, 0x3334: 0x0100, 0x3335: 0x0100,
	0x3337: 0x0100, 0x3338: 0x0100,
	0x333c: 0x0100, 0x333f: 0x0100,
	// Block 0xcd, offset 0x3340
	0x3340: 0x0100, 0x3341: 0x0100, 0x3342: 0x0100, 0x3343: 0x0100, 0x3344: 0x0100, 0x3345: 0x0100,
	0x3346: 0x0100, 0x3347: 0x0100, 0x3348: 0x0100, 0x3349: 0x0100, 0x334a: 0x0100, 0x334b: 0x0100,
	0x334c: 0x0100, 0x334d: 0x0100, 0x334e: 0x0100, 0x334f: 0x0100, 0x3350: 0x0100, 0x3351: 0x0100,
	0x3352: 0x0100, 0x3353: 0x0100, 0x3354: 0x0100, 0x3355: 0x0100,
	0x3360: 0x0100, 0x3361: 0x0100, 0x3362: 0x0100, 0x3363: 0x0100,
	0x3364: 0x0100, 0x3365: 0x0100, 0x3366: 0x0100, 0x3367: 0x0100, 0x3368: 0x0100, 0x3369: 0x0100,
	0x336a: 0x0100, 0x336b: 0x0100, 0x336c: 0x0100, 0x336d: 0x0100, 0x336e: 0x0100, 0x336f: 0x0100,
	0x3370: 0x0100, 0x3371: 0x0100, 0x3372: 0x0100, 0x3373: 0x0100, 0x3374: 0x0100, 0x3375: 0x0100,
	0x3376: 0x0100,
	// Block 0xce, offset 0x3380
	0x3380: 0x0100, 0x3381: 0x0100, 0x3382: 0x0100, 0x3383: 0x0100, 0x3384: 0x0100, 0x3385: 0x0100,
	0x3386: 0x0100, 0x3387: 0x0100, 0x3388: 0x0100, 0x3389: 0x0100, 0x338a: 0x0100, 0x338b: 0x0100,
	0x338c: 0x0100, 0x338d: 0x0100, 0x338e: 0x0100, 0x338f: 0x0100, 0x3390: 0x0100, 0x3391: 0x0100,
	0x3392: 0x0100, 0x3393: 0x0100, 0x3394: 0x0100, 0x3395: 0x0100, 0x3396: 0x0100, 0x3397: 0x0100,
	0x3398: 0x0100, 0x3399: 0x0100, 0x339a: 0x0100, 0x339b: 0x0100, 0x339c: 0x0100, 0x339d: 0x0100,
	0x339e: 0x0100,
	// Block 0xcf, offset 0x33c0
	0x33e0: 0x0100, 0x33e1: 0x0100, 0x33e2: 0x0100, 0x33e3: 0x0100,
	0x33e4: 0x0100, 0x33e5: 0x0100, 0x33e6: 0x0100, 0x33e7: 0x0100, 0x33e8: 0x0100, 0x33e9: 0x0100,
	0x33ea: 0x0100, 0x33eb: 0x0100, 0x33ec: 0x0100, 0x33ed: 0x0100, 0x33ee: 0x0100, 0x33ef: 0x0100,
	0x33f0: 0x0100, 0x33f1: 0x0100, 0x33f2: 0x0100, 0x33f4: 0x0100, 0x33f5: 0x0100,
	// Block 0xd0, offset 0x3400
	0x3400: 0x0100, 0x3401: 0x0100, 0x3402: 0x0100, 0x3403: 0x0100, 0x3404: 0x0100, 0x3405: 0x0100,
	0x3406: 0x0100, 0x3407: 0x0100, 0x3408: 0x0100, 0x3409: 0x0100, 0x340a: 0x0100, 0x340b: 0x0100,
	0x340c: 0x0100, 0x340d: 0x0100, 0x340e: 0x0100, 0x340f: 0x0100, 0x3410: 0x0100, 0x3411: 0x0100,
	0x3412: 0x0100, 0x3413: 0x0100, 0x3414: 0x0100, 0x3415: 0x0100,
	0x3420: 0x0100, 0x3421: 0x0100, 0x3422: 0x0100, 0x3423: 0x0100,
	0x3424: 0x0100, 0x3425: 0x0100, 0x3426: 0x0100, 0x3427: 0x0100, 0x3428: 0x0100, 0x3429: 0x0100,
	0x342a: 0x0100, 0x342b: 0x0100, 0x342c: 0x0100, 0x342d: 0x0100, 0x342e: 0x0100, 0x342f: 0x0100,
	0x3430: 0x0100, 0x3431: 0x0100, 0x3432: 0x0100, 0x3433: 0x0100, 0x3434: 0x0100, 0x3435: 0x0100,
	0x3436: 0x0100, 0x3437: 0x0100, 0x3438: 0x0100, 0x3439: 0x0100,
	// Block 0xd1, offset 0x3440
	0x3440: 0x0100, 0x3441: 0x0100, 0x3442: 0x0100, 0x3443: 0x0100, 0x3444: 0x0100, 0x3445: 0x0100,
	0x3446: 0x0100, 0x3447: 0x0100, 0x3448: 0x0100, 0x3449: 0x0100, 0x344a: 0x0100, 0x344b: 0x0100,
	0x344c: 0x0100, 0x344d: 0x0100, 0x344e: 0x0100, 0x344f: 0x0100, 0x3450: 0x0100, 0x3451: 0x0100,
	0x3452: 0x0100, 0x3453: 0x0100, 0x3454: 0x0100, 0x3455: 0x0100, 0x3456: 0x0100, 0x3457: 0x0100,
	0x3458: 0x0100, 0x3459: 0x0100, 0x345a: 0x0100, 0x345b: 0x0100, 0x345c: 0x0100, 0x345d: 0x0100,
	0x345e: 0x0100, 0x345f: 0x0100, 0x3460: 0x0100, 0x3461: 0x0100, 0x3462: 0x0100, 0x3463: 0x0100,
	0x3464: 0x0100, 0x3465: 0x0100, 0x3466: 0x0100, 0x3467: 0x0100, 0x3468: 0x0100, 0x3469: 0x0100,
	0x346a: 0x0100, 0x346b: 0x0100, 0x346c: 0x0100, 0x346d: 0x0100, 0x346e: 0x0100, 0x346f: 0x0100,
	0x3470: 0x0100, 0x3471: 0x0100, 0x3472: 0x0100, 0x3473: 0x0100, 0x3474: 0x0100, 0x3475: 0x0100,
	0x3476: 0x0100, 0x3477: 0x0100,
	0x347e: 0x0100, 0x347f: 0x0100,
	// Block 0xd2, offset 0x3480
	0x3480: 0x0100, 0x3481: 0x0008, 0x3482: 0x0008, 0x3483: 0x0008, 0x3485: 0x0008,
	0x3486: 0x0008,
	0x348c: 0x0008, 0x348d: 0x0008, 0x348e: 0x0008, 0x348f: 0x0008, 0x3490: 0x0100, 0x3491: 0x0100,
	0x3492: 0x0100, 0x3493: 0x0100, 0x3495: 0x0100, 0x3496: 0x0100, 0x3497: 0x0100,
	0x3499: 0x0100, 0x349a: 0x0100, 0x349b: 0x0100, 0x349c: 0x0100, 0x349d: 0x0100,
	0x349e: 0x0100, 0x349f: 0x0100, 0x34a0: 0x0100, 0x34a1: 0x0100, 0x34a2: 0x0100, 0x34a3: 0x0100,
	0x34a4: 0x0100, 0x34a5: 0x0100, 0x34a6: 0x0100, 0x34a7: 0x0100, 0x34a8: 0x0100, 0x34a9: 0x0100,
	0x34aa: 0x0100, 0x34ab: 0x0100, 0x34ac: 0x0100, 0x34ad: 0x0100, 0x34ae: 0x0100, 0x34af: 0x0100,
	0x34b0: 0x0100, 0x34b1: 0x0100, 0x34b2: 0x0100, 0x34b3: 0x0100, 0x34b4: 0x0100, 0x34b5: 0x0100,
	0x34b8: 0x0008, 0x34b9: 0x0008, 0x34ba: 0x0008,
	0x34bf: 0x0008,
	// Block 0xd3, offset 0x34c0
	0x34d6: 0x0400, 0x34d7: 0x0400,
	0x34e0: 0x0100, 0x34e1: 0x0100, 0x34e2: 0x0100, 0x34e3: 0x0100,
	0x34e4: 0x0100, 0x34e5: 0x0100, 0x34e6: 0x0100, 0x34e7: 0x0100, 0x34e8: 0x0100, 0x34e9: 0x0100,
	0x34ea: 0x0100, 0x34eb: 0x0100, 0x34ec: 0x0100, 0x34ed: 0x0100, 0x34ee: 0x0100, 0x34ef: 0x0100,
	0x34f0: 0x0100, 0x34f1: 0x0100, 0x34f2: 0x0100, 0x34f3: 0x0100, 0x34f4: 0x0100, 0x34f5: 0x0100,
	0x34f6: 0x0100, 0x34f7: 0x0100, 0x34f8: 0x0100, 0x34f9: 0x0100, 0x34fa: 0x0100, 0x34fb: 0x0100,
	0x34fc: 0x0100,
	// Block 0xd4, offset 0x3500
	0x3500: 0x0100, 0x3501: 0x0100, 0x3502: 0x0100, 0x3503: 0x0100, 0x3504: 0x0100, 0x3505: 0x0100,
	0x3506: 0x0100, 0x3507: 0x0100, 0x3508: 0x0100, 0x3509: 0x0100, 0x350a: 0x0100, 0x350b: 0x0100,
	0x350c: 0x0100, 0x350d: 0x0100, 0x350e: 0x0100, 0x350f: 0x0100, 0x3510: 0x0100, 0x3511: 0x0100,
	0x3512: 0x0100, 0x3513: 0x0100, 0x3514: 0x0100, 0x3515: 0x0100, 0x3516: 0x0100, 0x3517: 0x0100,
	0x3518: 0x0100, 0x3519: 0x0100, 0x351a: 0x0100, 0x351b: 0x0100, 0x351c: 0x0100,
	// Block 0xd5, offset 0x3540
	0x3540: 0x0100, 0x3541: 0x0100, 0x3542: 0x0100, 0x3543: 0x0100, 0x3544: 0x0100, 0x3545: 0x0100,
	0x3546: 0x0100, 0x3547: 0x0100, 0x3549: 0x0100, 0x354a: 0x0100, 0x354b: 0x0100,
	0x354c: 0x0100, 0x354d: 0x0100, 0x354e: 0x0100, 0x354f: 0x0100, 0x3550: 0x0100, 0x3551: 0x0100,
	0x3552: 0x0100, 0x3553: 0x0100, 0x3554: 0x0100, 0x3555: 0x0100, 0x3556: 0x0100, 0x3557: 0x0100,
	0x3558: 0x0100, 0x3559: 0x0100, 0x355a: 0x0100, 0x355b: 0x0100, 0x355c: 0x0100, 0x355d: 0x0100,
	0x355e: 0x0100, 0x355f: 0x0100, 0x3560: 0x0100, 0x3561: 0x0100, 0x3562: 0x0100, 0x3563: 0x0100,
	0x3564: 0x0100, 0x3565: 0x0008, 0x3566: 0x0008,
	// Block 0xd6, offset 0x3580
	0x3580: 0x0100, 0x3581: 0x0100, 0x3582: 0x0100, 0x3583: 0x0100, 0x3584: 0x0100, 0x3585: 0x0100,
	0x3586: 0x0100, 0x3587: 0x0100, 0x3588: 0x0100, 0x3589: 0x0100, 0x358a: 0x0100, 0x358b: 0x0100,
	0x358c: 0x0100, 0x358d: 0x0100, 0x358e: 0x0100, 0x358f: 0x0100, 0x3590: 0x0100, 0x3591: 0x0100,
	0x3592: 0x0100, 0x3593: 0x0100, 0x3594: 0x0100, 0x3595: 0x0100,
	0x35a0: 0x0100, 0x35a1: 0x0100, 0x35a2: 0x0100, 0x35a3: 0x0100,
	0x35a4: 0x0100, 0x35a5: 0x0100, 0x35a6: 0x0100, 0x35a7: 0x0100, 0x35a8: 0x0100, 0x35a9: 0x0100,
	0x35aa: 0x0100, 0x35ab: 0x0100, 0x35ac: 0x0100, 0x35ad: 0x0100, 0x35ae: 0x0100, 0x35af: 0x0100,
	0x35b0: 0x0100, 0x35b1: 0x0100, 0x35b2: 0x0100,
	// Block 0xd7, offset 0x35c0
	0x35c0: 0x0100, 0x35c1: 0x0100, 0x35c2: 0x0100, 0x35c3: 0x0100, 0x35c4: 0x0100, 0x35c5: 0x0100,
	0x35c6: 0x0100, 0x35c7: 0x0100, 0x35c8: 0x0100, 0x35c9: 0x0100, 0x35ca: 0x0100, 0x35cb: 0x0100,
	0x35cc: 0x0100, 0x35cd: 0x0100, 0x35ce: 0x0100, 0x35cf: 0x0100, 0x35d0: 0x0100, 0x35d1: 0x0100,
	// Block 0xd8, offset 0x3600
	0x3600: 0x0100, 0x3601: 0x0100, 0x3602: 0x0100, 0x3603: 0x0100, 0x3604: 0x0100, 0x3605: 0x0100,
	0x3606: 0x0100, 0x3607: 0x0100, 0x3608: 0x0100,
	// Block 0xd9, offset 0x3640
	0x3640: 0x2000, 0x3641: 0x2000, 0x3642: 0x2000, 0x3643: 0x2000, 0x3644: 0x2000, 0x3645: 0x2000,
	0x3646: 0x2000, 0x3647: 0x2000, 0x3648: 0x2000, 0x3649: 0x2000, 0x364a: 0x2000, 0x364b: 0x2000,
	0x364c: 0x2000, 0x364d: 0x2000, 0x364e: 0x2000, 0x364f: 0x2000, 0x3650: 0x2000, 0x3651: 0x2000,
	0x3652: 0x2000, 0x3653: 0x2000, 0x3654: 0x2000, 0x3655: 0x2000, 0x3656: 0x2000, 0x3657: 0x2000,
	0x3658: 0x2000, 0x3659: 0x2000, 0x365a: 0x2000, 0x365b: 0x2000, 0x365c: 0x2000, 0x365d: 0x2000,
	0x365e: 0x2000, 0x365f: 0x2000, 0x3660: 0x2000, 0x3661: 0x2000, 0x3662: 0x2000, 0x3663: 0x2000,
	0x3664: 0x2000, 0x3665: 0x2000, 0x3666: 0x2000, 0x3667: 0x2000, 0x3668: 0x2000, 0x3669: 0x2000,
	0x366a: 0x2000, 0x366b: 0x2000, 0x366c: 0x2000, 0x366d: 0x2000, 0x366e: 0x2000, 0x366f: 0x2000,
	0x3670: 0x2000, 0x3671: 0x2000, 0x3672: 0x2000,
	// Block 0xda, offset 0x3680
	0x3680: 0x0040, 0x3681: 0x0040, 0x3682: 0x0040, 0x3683: 0x0040, 0x3684: 0x0040, 0x3685: 0x0040,
	0x3686: 0x0040, 0x3687: 0x0040, 0x3688: 0x0040, 0x3689: 0x0040, 0x368a: 0x0040, 0x368b: 0x0040,
	0x368c: 0x0040, 0x368d: 0x0040, 0x368e: 0x0040, 0x368f: 0x0040, 0x3690: 0x0040, 0x3691: 0x0040,
	0x3692: 0x0040, 0x3693: 0x0040, 0x3694: 0x0040, 0x3695: 0x0040, 0x3696: 0x0040, 0x3697: 0x0040,
	0x3698: 0x0040, 0x3699: 0x0040, 0x369a: 0x0040, 0x369b: 0x0040, 0x369c: 0x0040, 0x369d: 0x0040,
	0x369e: 0x0040, 0x369f: 0x0040, 0x36a0: 0x0040, 0x36a1: 0x0040, 0x36a2: 0x0040, 0x36a3: 0x0040,
	0x36a4: 0x0040, 0x36a5: 0x0040, 0x36a6: 0x0040, 0x36a7: 0x0040, 0x36a8: 0x0040, 0x36a9: 0x0040,
	0x36aa: 0x0040, 0x36ab: 0x0040, 0x36ac: 0x0040, 0x36ad: 0x0040, 0x36ae: 0x0040, 0x36af: 0x0040,
	0x36b0: 0x0040, 0x36b1: 0x0040, 0x36b2: 0x0040,
	// Block 0xdb, offset 0x36c0
	0x36c0: 0x0100, 0x36c1: 0x0100, 0x36c2: 0x0100, 0x36c3: 0x0100, 0x36c4: 0x0100, 0x36c5: 0x0100,
	0x36c6: 0x0100, 0x36c7: 0x0100, 0x36c8: 0x0100, 0x36c9: 0x0100, 0x36ca: 0x0100, 0x36cb: 0x0100,
	0x36cc: 0x0100, 0x36cd: 0x0100, 0x36ce: 0x0100, 0x36cf: 0x0100, 0x36d0: 0x0100, 0x36d1: 0x0100,
	0x36d2: 0x0100, 0x36d3: 0x0100, 0x36d4: 0x0100, 0x36d5: 0x0100, 0x36d6: 0x0100, 0x36d7: 0x0100,
	0x36d8: 0x0100, 0x36d9: 0x0100, 0x36da: 0x0100, 0x36db: 0x0100, 0x36dc: 0x0100, 0x36dd: 0x0100,
	0x36de: 0x0100, 0x36df: 0x0100, 0x36e0: 0x0100, 0x36e1: 0x0100, 0x36e2: 0x0100, 0x36e3: 0x0100,
	0x36e4: 0x0008, 0x36e5: 0x0008, 0x36e6: 0x0008, 0x36e7: 0x0008,
	0x36f0: 0x0080, 0x36f1: 0x0080, 0x36f2: 0x0080, 0x36f3: 0x0080, 0x36f4: 0x0080, 0x36f5: 0x0080,
	0x36f6: 0x0080, 0x36f7: 0x0080, 0x36f8: 0x0080, 0x36f9: 0x0080,
	// Block 0xdc, offset 0x3700
	0x3700: 0x0100, 0x3701: 0x0100, 0x3702: 0x0100, 0x3703: 0x0100, 0x3704: 0x0100, 0x3705: 0x0100,
	0x3706: 0x0100, 0x3707: 0x0100, 0x3708: 0x0100, 0x3709: 0x0100, 0x370a: 0x0100, 0x370b: 0x0100,
	0x370c: 0x0100, 0x370d: 0x0100, 0x370e: 0x0100, 0x370f: 0x0100, 0x3710: 0x0100, 0x3711: 0x0100,
	0x3712: 0x0100, 0x3713: 0x0100, 0x3714: 0x0100, 0x3715: 0x0100, 0x3716: 0x0100, 0x3717: 0x0100,
	0x3718: 0x0100, 0x3719: 0x0100, 0x371a: 0x0100, 0x371b: 0x0100, 0x371c: 0x0100, 0x371d: 0x0100,
	0x371e: 0x0100, 0x371f: 0x0100, 0x3720: 0x0100, 0x3721: 0x0100, 0x3722: 0x0100, 0x3723: 0x0100,
	0x3724: 0x0100, 0x3725: 0x0100, 0x3726: 0x0100, 0x3727: 0x0100, 0x3728: 0x0100, 0x3729: 0x0100,
	0x372b: 0x0008, 0x372c: 0x0008,
	0x3730: 0x0100, 0x3731: 0x0100,
	// Block 0xdd, offset 0x3740
	0x377d: 0x0008, 0x377e: 0x0008, 0x377f: 0x0008,
	// Block 0xde, offset 0x3780
	0x3780: 0x0100, 0x3781: 0x0100, 0x3782: 0x0100, 0x3783: 0x0100, 0x3784: 0x0100, 0x3785: 0x0100,
	0x3786: 0x0100, 0x3787: 0x0100, 0x3788: 0x0100, 0x3789: 0x0100, 0x378a: 0x0100, 0x378b: 0x0100,
	0x378c: 0x0100, 0x378d: 0x0100, 0x378e: 0x0100, 0x378f: 0x0100, 0x3790: 0x0100, 0x3791: 0x0100,
	0x3792: 0x0100, 0x3793: 0x0100, 0x3794: 0x0100, 0x3795: 0x0100, 0x3796: 0x0100, 0x3797: 0x0100,
	0x3798: 0x0100, 0x3799: 0x0100, 0x379a: 0x0100, 0x379b: 0x0100, 0x379c: 0x0100,
	0x37a7: 0x0100,
	0x37b0: 0x0100, 0x37b1: 0x0100, 0x37b2: 0x0100, 0x37b3: 0x0100, 0x37b4: 0x0100, 0x37b5: 0x0100,
	0x37b6: 0x0100, 0x37b7: 0x0100, 0x37b8: 0x0100, 0x37b9: 0x0100, 0x37ba: 0x0100, 0x37bb: 0x0100,
	0x37bc: 0x0100, 0x37bd: 0x0100, 0x37be: 0x0100, 0x37bf: 0x0100,
	// Block 0xdf, offset 0x37c0
	0x37c0: 0x0100, 0x37c1: 0x0100, 0x37c2: 0x0100, 0x37c3: 0x0100, 0x37c4: 0x0100, 0x37c5: 0x0100,
	0x37c6: 0x0008, 0x37c7: 0x0008, 0x37c8: 0x0008, 0x37c9: 0x0008, 0x37ca: 0x0008, 0x37cb: 0x0008,
	0x37cc: 0x0008, 0x37cd: 0x0008, 0x37ce: 0x0008, 0x37cf: 0x0008, 0x37d0: 0x0008,
	0x37d5: 0x0400, 0x37d6: 0x0400, 0x37d7: 0x0400,
	0x37d8: 0x0400, 0x37d9: 0x0400,
	0x37f0: 0x0100, 0x37f1: 0x0100, 0x37f2: 0x0100, 0x37f3: 0x0100, 0x37f4: 0x0100, 0x37f5: 0x0100,
	0x37f6: 0x0100, 0x37f7: 0x0100, 0x37f8: 0x0100, 0x37f9: 0x0100, 0x37fa: 0x0100, 0x37fb: 0x0100,
	0x37fc: 0x0100, 0x37fd: 0x0100, 0x37fe: 0x0100, 0x37ff: 0x0100,
	// Block 0xe0, offset 0x3800
	0x3800: 0x0100, 0x3801: 0x0100, 0x3802: 0x0008, 0x3803: 0x0008, 0x3804: 0x0008, 0x3805: 0x0008,
	0x3806: 0x0400, 0x3807: 0x0400, 0x3808: 0x0400, 0x3809: 0x0400,
	0x3830: 0x0100, 0x3831: 0x0100, 0x3832: 0x0100, 0x3833: 0x0100, 0x3834: 0x0100, 0x3835: 0x0100,
	0x3836: 0x0100, 0x3837: 0x0100, 0x3838: 0x0100, 0x3839: 0x0100, 0x383a: 0x0100, 0x383b: 0x0100,
	0x383c: 0x0100, 0x383d: 0x0100, 0x383e: 0x0100, 0x383f: 0x0100,
	// Block 0xe1, offset 0x3840
	0x3840: 0x0100, 0x3841: 0x0100, 0x3842: 0x0100, 0x3843: 0x0100, 0x3844: 0x0100,
	0x3860: 0x0100, 0x3861: 0x0100, 0x3862: 0x0100, 0x3863: 0x0100,
	0x3864: 0x0100, 0x3865: 0x0100, 0x3866: 0x0100, 0x3867: 0x0100, 0x3868: 0x0100, 0x3869: 0x0100,
	0x386a: 0x0100, 0x386b: 0x0100, 0x386c: 0x0100, 0x386d: 0x0100, 0x386e: 0x0100, 0x386f: 0x0100,
	0x3870: 0x0100, 0x3871: 0x0100, 0x3872: 0x0100, 0x3873: 0x0100, 0x3874: 0x0100, 0x3875: 0x0100,
	0x3876: 0x0100,
	// Block 0xe2, offset 0x3880
	0x3880: 0x0008, 0x3881: 0x0008, 0x3882: 0x0008, 0x3883: 0x0100, 0x3884: 0x0100, 0x3885: 0x0100,
	0x3886: 0x0100, 0x3887: 0x0100, 0x3888: 0x0100, 0x3889: 0x0100, 0x388a: 0x0100, 0x388b: 0x0100,
	0x388c: 0x0100, 0x388d: 0x0100, 0x388e: 0x0100, 0x388f: 0x0100, 0x3890: 0x0100, 0x3891: 0x0100,
	0x3892: 0x0100, 0x3893: 0x0100, 0x3894: 0x0100, 0x3895: 0x0100, 0x3896: 0x0100, 0x3897: 0x0100,
	0x3898: 0x0100, 0x3899: 0x0100, 0x389a: 0x0100, 0x389b: 0x0100, 0x389c: 0x0100, 0x389d: 0x0100,
	0x389e: 0x0100, 0x389f: 0x0100, 0x38a0: 0x0100, 0x38a1: 0x0100, 0x38a2: 0x0100, 0x38a3: 0x0100,
	0x38a4: 0x0100, 0x38a5: 0x0100, 0x38a6: 0x0100, 0x38a7: 0x0100, 0x38a8: 0x0100, 0x38a9: 0x0100,
	0x38aa: 0x0100, 0x38ab: 0x0100, 0x38ac: 0x0100, 0x38ad: 0x0100, 0x38ae: 0x0100, 0x38af: 0x0100,
	0x38b0: 0x0100, 0x38b1: 0x0100, 0x38b2: 0x0100, 0x38b3: 0x0100, 0x38b4: 0x0100, 0x38b5: 0x0100,
	0x38b6: 0x0100, 0x38b7: 0x0100, 0x38b8: 0x0008, 0x38b9: 0x0008, 0x38ba: 0x0008, 0x38bb: 0x0008,
	0x38bc: 0x0008, 0x38bd: 0x0008, 0x38be: 0x0008, 0x38bf: 0x0008,
	// Block 0xe3, offset 0x38c0
	0x38c0: 0x0008, 0x38c1: 0x0008, 0x38c2: 0x0008, 0x38c3: 0x0008, 0x38c4: 0x0008, 0x38c5: 0x0008,
	0x38c6: 0x0008, 0x38c7: 0x0400, 0x38c8: 0x0400,
	0x38e6: 0x0080, 0x38e7: 0x0080, 0x38e8: 0x0080, 0x38e9: 0x0080,
	0x38ea: 0x0080, 0x38eb: 0x0080, 0x38ec: 0x0080, 0x38ed: 0x0080, 0x38ee: 0x0080, 0x38ef: 0x0080,
	0x38f0: 0x0008, 0x38f1: 0x0100, 0x38f2: 0x0100, 0x38f3: 0x0008, 0x38f4: 0x0008, 0x38f5: 0x0100,
	0x38ff: 0x0008,
	// Block 0xe4, offset 0x3900
	0x3900: 0x0008, 0x3901: 0x0008, 0x3902: 0x0008, 0x3903: 0x0100, 0x3904: 0x0100, 0x3905: 0x0100,
	0x3906: 0x0100, 0x3907: 0x0100, 0x3908: 0x0100, 0x3909: 0x0100, 0x390a: 0x0100, 0x390b: 0x0100,
	0x390c: 0x0100, 0x390d: 0x0100, 0x390e: 0x0100, 0x390f: 0x0100, 0x3910: 0x0100, 0x3911: 0x0100,
	0x3912: 0x0100, 0x3913: 0x0100, 0x3914: 0x0100, 0x3915: 0x0100, 0x3916: 0x0100, 0x3917: 0x0100,
	0x3918: 0x0100, 0x3919: 0x0100, 0x391a: 0x0100, 0x391b: 0x0100, 0x391c: 0x0100, 0x391d: 0x0100,
	0x391e: 0x0100, 0x391f: 0x0100, 0x3920: 0x0100, 0x3921: 0x0100, 0x3922: 0x0100, 0x3923: 0x0100,
	0x3924: 0x0100, 0x3925: 0x0100, 0x3926: 0x0100, 0x3927: 0x0100, 0x3928: 0x0100, 0x3929: 0x0100,
	0x392a: 0x0100, 0x392b: 0x0100, 0x392c: 0x0100, 0x392d: 0x0100, 0x392e: 0x0100, 0x392f: 0x0100,
	0x3930: 0x0008, 0x3931: 0x0008, 0x3932: 0x0008, 0x3933: 0x0008, 0x3934: 0x0008, 0x3935: 0x0008,
	0x3936: 0x0008, 0x3937: 0x0008, 0x3938: 0x0008, 0x3939: 0x0008, 0x393a: 0x0008,
	0x393d: 0x0010, 0x393e: 0x0400, 0x393f: 0x0400,
	// Block 0xe5, offset 0x3940
	0x3940: 0x0400, 0x3941: 0x0400, 0x3942: 0x0008,
	0x394d: 0x0010, 0x3950: 0x0100, 0x3951: 0x0100,
	0x3952: 0x0100, 0x3953: 0x0100, 0x3954: 0x0100, 0x3955: 0x0100, 0x3956: 0x0100, 0x3957: 0x0100,
	0x3958: 0x0100, 0x3959: 0x0100, 0x395a: 0x0100, 0x395b: 0x0100, 0x395c: 0x0100, 0x395d: 0x0100,
	0x395e: 0x0100, 0x395f: 0x0100, 0x3960: 0x0100, 0x3961: 0x0100, 0x3962: 0x0100, 0x3963: 0x0100,
	0x3964: 0x0100, 0x3965: 0x0100, 0x3966: 0x0100, 0x3967: 0x0100, 0x3968: 0x0100,
	0x3970: 0x0080, 0x3971: 0x0080, 0x3972: 0x0080, 0x3973: 0x0080, 0x3974: 0x0080, 0x3975: 0x0080,
	0x3976: 0x0080, 0x3977: 0x0080, 0x3978: 0x0080, 0x3979: 0x0080,
	// Block 0xe6, offset 0x3980
	0x3980: 0x0008, 0x3981: 0x0008, 0x3982: 0x0008, 0x3983: 0x0100, 0x3984: 0x0100, 0x3985: 0x0100,
	0x3986: 0x0100, 0x3987: 0x0100, 0x3988: 0x0100, 0x3989: 0x0100, 0x398a: 0x0100, 0x398b: 0x0100,
	0x398c: 0x0100, 0x398d: 0x0100, 0x398e: 0x0100, 0x398f: 0x0100, 0x3990: 0x0100, 0x3991: 0x0100,
	0x3992: 0x0100, 0x3993: 0x0100, 0x3994: 0x0100, 0x3995: 0x0100, 0x3996: 0x0100, 0x3997: 0x0100,
	0x3998: 0x0100, 0x3999: 0x0100, 0x399a: 0x0100, 0x399b: 0x0100, 0x399c: 0x0100, 0x399d: 0x0100,
	0x399e: 0x0100, 0x399f: 0x0100, 0x39a0: 0x0100, 0x39a1: 0x0100, 0x39a2: 0x0100, 0x39a3: 0x0100,
	0x39a4: 0x0100, 0x39a5: 0x0100, 0x39a6: 0x0100, 0x39a7: 0x0008, 0x39a8: 0x0008, 0x39a9: 0x0008,
	0x39aa: 0x0008, 0x39ab: 0x0008, 0x39ac: 0x0008, 0x39ad: 0x0008, 0x39ae: 0x0008, 0x39af: 0x0008,
	0x39b0: 0x0008, 0x39b1: 0x0008, 0x39b2: 0x0008, 0x39b3: 0x0008, 0x39b4: 0x0008,
	0x39b6: 0x0080, 0x39b7: 0x0080, 0x39b8: 0x0080, 0x39b9: 0x0080, 0x39ba: 0x0080, 0x39bb: 0x0080,
	0x39bc: 0x0080, 0x39bd: 0x0080, 0x39be: 0x0080, 0x39bf: 0x0080,
	// Block 0xe7, offset 0x39c0
	0x39c1: 0x0400, 0x39c2: 0x0400, 0x39c3: 0x0400, 0x39c4: 0x0100, 0x39c5: 0x0008,
	0x39c6: 0x0008, 0x39c7: 0x0100,
	0x39d0: 0x0100, 0x39d1: 0x0100,
	0x39d2: 0x0100, 0x39d3: 0x0100, 0x39d4: 0x0100, 0x39d5: 0x0100, 0x39d6: 0x0100, 0x39d7: 0x0100,
	0x39d8: 0x0100, 0x39d9: 0x0100, 0x39da: 0x0100, 0x39db: 0x0100, 0x39dc: 0x0100, 0x39dd: 0x0100,
	0x39de: 0x0100, 0x39df: 0x0100, 0x39e0: 0x0100, 0x39e1: 0x0100, 0x39e2: 0x0100, 0x39e3: 0x0100,
	0x39e4: 0x0100, 0x39e5: 0x0100, 0x39e6: 0x0100, 0x39e7: 0x0100, 0x39e8: 0x0100, 0x39e9: 0x0100,
	0x39ea: 0x0100, 0x39eb: 0x0100, 0x39ec: 0x0100, 0x39ed: 0x0100, 0x39ee: 0x0100, 0x39ef: 0x0100,
	0x39f0: 0x0100, 0x39f1: 0x0100, 0x39f2: 0x0100, 0x39f3: 0x0008,
	0x39f6: 0x0100,
	// Block 0xe8, offset 0x3a00
	0x3a00: 0x0008, 0x3a01: 0x0008, 0x3a02: 0x0008, 0x3a03: 0x0100, 0x3a04: 0x0100, 0x3a05: 0x0100,
	0x3a06: 0x0100, 0x3a07: 0x0100, 0x3a08: 0x0100, 0x3a09: 0x0100, 0x3a0a: 0x0100, 0x3a0b: 0x0100,
	0x3a0c: 0x0100, 0x3a0d: 0x0100, 0x3a0e: 0x0100, 0x3a0f: 0x0100, 0x3a10: 0x0100, 0x3a11: 0x0100,
	0x3a12: 0x0100, 0x3a13: 0x0100, 0x3a14: 0x0100, 0x3a15: 0x0100, 0x3a16: 0x0100, 0x3a17: 0x0100,
	0x3a18: 0x0100, 0x3a19: 0x0100, 0x3a1a: 0x0100, 0x3a1b: 0x0100, 0x3a1c: 0x0100, 0x3a1d: 0x0100,
	0x3a1e: 0x0100, 0x3a1f: 0x0100, 0x3a20: 0x0100, 0x3a21: 0x0100, 0x3a22: 0x0100, 0x3a23: 0x0100,
	0x3a24: 0x0100, 0x3a25: 0x0100, 0x3a26: 0x0100, 0x3a27: 0x0100, 0x3a28: 0x0100, 0x3a29: 0x0100,
	0x3a2a: 0x0100, 0x3a2b: 0x0100, 0x3a2c: 0x0100, 0x3a2d: 0x0100, 0x3a2e: 0x0100, 0x3a2f: 0x0100,
	0x3a30: 0x0100, 0x3a31: 0x0100, 0x3a32: 0x0100, 0x3a33: 0x0008, 0x3a34: 0x0008, 0x3a35: 0x0008,
	0x3a36: 0x0008, 0x3a37: 0x0008, 0x3a38: 0x0008, 0x3a39: 0x0008, 0x3a3a: 0x0008, 0x3a3b: 0x0008,
	0x3a3c: 0x0008, 0x3a3d: 0x0008, 0x3a3e: 0x0008, 0x3a3f: 0x0008,
	// Block 0xe9, offset 0x3a40
	0x3a40: 0x0008, 0x3a41: 0x0100, 0x3a42: 0x0100, 0x3a43: 0x0100, 0x3a44: 0x0100, 0x3a45: 0x0400,
	0x3a46: 0x0400, 0x3a49: 0x0008, 0x3a4a: 0x0008, 0x3a4b: 0x0008,
	0x3a4c: 0x0008, 0x3a4d: 0x0400, 0x3a4e: 0x0008, 0x3a4f: 0x0008, 0x3a50: 0x0080, 0x3a51: 0x0080,
	0x3a52: 0x0080, 0x3a53: 0x0080, 0x3a54: 0x0080, 0x3a55: 0x0080, 0x3a56: 0x0080, 0x3a57: 0x0080,
	0x3a58: 0x0080, 0x3a59: 0x0080, 0x3a5a: 0x0100, 0x3a5c: 0x0100,
	0x3a5e: 0x0400, 0x3a5f: 0x0400,
	// Block 0xea, offset 0x3a80
	0x3a80: 0x0100, 0x3a81: 0x0100, 0x3a82: 0x0100, 0x3a83: 0x0100, 0x3a84: 0x0100, 0x3a85: 0x0100,
	0x3a86: 0x0100, 0x3a87: 0x0100, 0x3a88: 0x0100, 0x3a89: 0x0100, 0x3a8a: 0x0100, 0x3a8b: 0x0100,
	0x3a8c: 0x0100, 0x3a8d: 0x0100, 0x3a8e: 0x0100, 0x3a8f: 0x0100, 0x3a90: 0x0100, 0x3a91: 0x0100,
	0x3a93: 0x0100, 0x3a94: 0x0100, 0x3a95: 0x0100, 0x3a96: 0x0100, 0x3a97: 0x0100,
	0x3a98: 0x0100, 0x3a99: 0x0100, 0x3a9a: 0x0100, 0x3a9b: 0x0100, 0x3a9c: 0x0100, 0x3a9d: 0x0100,
	0x3a9e: 0x0100, 0x3a9f: 0x0100, 0x3aa0: 0x0100, 0x3aa1: 0x0100, 0x3aa2: 0x0100, 0x3aa3: 0x0100,
	0x3aa4: 0x0100, 0x3aa5: 0x0100, 0x3aa6: 0x0100, 0x3aa7: 0x0100, 0x3aa8: 0x0100, 0x3aa9: 0x0100,
	0x3aaa: 0x0100, 0x3aab: 0x0100, 0x3aac: 0x0008, 0x3aad: 0x0008, 0x3aae: 0x0008, 0x3aaf: 0x0008,
	0x3ab0: 0x0008, 0x3ab1: 0x0008, 0x3ab2: 0x0008, 0x3ab3: 0x0008, 0x3ab4: 0x0008, 0x3ab5: 0x0008,
	0x3ab6: 0x0008, 0x3ab7: 0x0008, 0x3ab8: 0x0400, 0x3ab9: 0x0400, 0x3abb: 0x0400,
	0x3abc: 0x0400, 0x3abe: 0x0008, 0x3abf: 0x0100,
	// Block 0xeb, offset 0x3ac0
	0x3ac0: 0x0100, 0x3ac1: 0x0008,
	// Block 0xec, offset 0x3b00
	0x3b00: 0x0100, 0x3b01: 0x0100, 0x3b02: 0x0100, 0x3b03: 0x0100, 0x3b04: 0x0100, 0x3b05: 0x0100,
	0x3b06: 0x0100, 0x3b08: 0x0100, 0x3b0a: 0x0100, 0x3b0b: 0x0100,
	0x3b0c: 0x0100, 0x3b0d: 0x0100, 0x3b0f: 0x0100, 0x3b10: 0x0100, 0x3b11: 0x0100,
	0x3b12: 0x0100, 0x3b13: 0x0100, 0x3b14: 0x0100, 0x3b15: 0x0100, 0x3b16: 0x0100, 0x3b17: 0x0100,
	0x3b18: 0x0100, 0x3b19: 0x0100, 0x3b1a: 0x0100, 0x3b1b: 0x0100, 0x3b1c: 0x0100, 0x3b1d: 0x0100,
	0x3b1f: 0x0100, 0x3b20: 0x0100, 0x3b21: 0x0100, 0x3b22: 0x0100, 0x3b23: 0x0100,
	0x3b24: 0x0100, 0x3b25: 0x0100, 0x3b26: 0x0100, 0x3b27: 0x0100, 0x3b28: 0x0100, 0x3b29: 0x0400,
	0x3b30: 0x0100, 0x3b31: 0x0100, 0x3b32: 0x0100, 0x3b33: 0x0100, 0x3b34: 0x0100, 0x3b35: 0x0100,
	0x3b36: 0x0100, 0x3b37: 0x0100, 0x3b38: 0x0100, 0x3b39: 0x0100, 0x3b3a: 0x0100, 0x3b3b: 0x0100,
	0x3b3c: 0x0100, 0x3b3d: 0x0100, 0x3b3e: 0x0100, 0x3b3f: 0x0100,
	// Block 0xed, offset 0x3b40
	0x3b40: 0x0100, 0x3b41: 0x0100, 0x3b42: 0x0100, 0x3b43: 0x0100, 0x3b44: 0x0100, 0x3b45: 0x0100,
	0x3b46: 0x0100, 0x3b47: 0x0100, 0x3b48: 0x0100, 0x3b49: 0x0100, 0x3b4a: 0x0100, 0x3b4b: 0x0100,
	0x3b4c: 0x0100, 0x3b4d: 0x0100, 0x3b4e: 0x0100, 0x3b4f: 0x0100, 0x3b50: 0x0100, 0x3b51: 0x0100,
	0x3b52: 0x0100, 0x3b53: 0x0100, 0x3b54: 0x0100, 0x3b55: 0x0100, 0x3b56: 0x0100, 0x3b57: 0x0100,
	0x3b58: 0x0100, 0x3b59: 0x0100, 0x3b5a: 0x0100, 0x3b5b: 0x0100, 0x3b5c: 0x0100, 0x3b5d: 0x0100,
	0x3b5e: 0x0100, 0x3b5f: 0x0008, 0x3b60: 0x0008, 0x3b61: 0x0008, 0x3b62: 0x0008, 0x3b63: 0x0008,
	0x3b64: 0x0008, 0x3b65: 0x0008, 0x3b66: 0x0008, 0x3b67: 0x0008, 0x3b68: 0x0008, 0x3b69: 0x0008,
	0x3b6a: 0x0008,
	0x3b70: 0x0080, 0x3b71: 0x0080, 0x3b72: 0x0080, 0x3b73: 0x0080, 0x3b74: 0x0080, 0x3b75: 0x0080,
	0x3b76: 0x0080, 0x3b77: 0x0080, 0x3b78: 0x0080, 0x3b79: 0x0080,
	// Block 0xee, offset 0x3b80
	0x3b80: 0x0008, 0x3b81: 0x0008, 0x3b82: 0x0008, 0x3b83: 0x0008, 0x3b85: 0x0100,
	0x3b86: 0x0100, 0x3b87: 0x0100, 0x3b88: 0x0100, 0x3b89: 0x0100, 0x3b8a: 0x0100, 0x3b8b: 0x0100,
	0x3b8c: 0x0100, 0x3b8f: 0x0100, 0x3b90: 0x0100,
	0x3b93: 0x0100, 0x3b94: 0x0100, 0x3b95: 0x0100, 0x3b96: 0x0100, 0x3b97: 0x0100,
	0x3b98: 0x0100, 0x3b99: 0x0100, 0x3b9a: 0x0100, 0x3b9b: 0x0100, 0x3b9c: 0x0100, 0x3b9d: 0x0100,
	0x3b9e: 0x0100, 0x3b9f: 0x0100, 0x3ba0: 0x0100, 0x3ba1: 0x0100, 0x3ba2: 0x0100, 0x3ba3: 0x0100,
	0x3ba4: 0x0100, 0x3ba5: 0x0100, 0x3ba6: 0x0100, 0x3ba7: 0x0100, 0x3ba8: 0x0100,
	0x3baa: 0x0100, 0x3bab: 0x0100, 0x3bac: 0x0100, 0x3bad: 0x0100, 0x3bae: 0x0100, 0x3baf: 0x0100,
	0x3bb0: 0x0100, 0x3bb2: 0x0100, 0x3bb3: 0x0100, 0x3bb5: 0x0100,
	0x3bb6: 0x0100, 0x3bb7: 0x0100, 0x3bb8: 0x0100, 0x3bb9: 0x0100, 0x3bbb: 0x0008,
	0x3bbc: 0x0008, 0x3bbd: 0x0100, 0x3bbe: 0x0008, 0x3bbf: 0x0008,
	// Block 0xef, offset 0x3bc0
	0x3bc0: 0x0008, 0x3bc1: 0x0008, 0x3bc2: 0x0008, 0x3bc3: 0x0008, 0x3bc4: 0x0008,
	0x3bc7: 0x0008, 0x3bc8: 0x0008, 0x3bcb: 0x0008,
	0x3bcc: 0x0008, 0x3bcd: 0x0008, 0x3bd0: 0x0100,
	0x3bd7: 0x0008,
	0x3bdd: 0x0100,
	0x3bde: 0x0100, 0x3bdf: 0x0100, 0x3be0: 0x0100, 0x3be1: 0x0100, 0x3be2: 0x0008, 0x3be3: 0x0008,
	0x3be6: 0x0008, 0x3be7: 0x0008, 0x3be8: 0x0008, 0x3be9: 0x0008,
	0x3bea: 0x0008, 0x3beb: 0x0008, 0x3bec: 0x0008,
	0x3bf0: 0x0008, 0x3bf1: 0x0008, 0x3bf2: 0x0008, 0x3bf3: 0x0008, 0x3bf4: 0x0008,
	// Block 0xf0, offset 0x3c00
	0x3c00: 0x0100, 0x3c01: 0x0100, 0x3c02: 0x0100, 0x3c03: 0x0100, 0x3c04: 0x0100, 0x3c05: 0x0100,
	0x3c06: 0x0100, 0x3c07: 0x0100, 0x3c08: 0x0100, 0x3c09: 0x0100, 0x3c0a: 0x0100, 0x3c0b: 0x0100,
	0x3c0c: 0x0100, 0x3c0d: 0x0100, 0x3c0e: 0x0100, 0x3c0f: 0x0100, 0x3c10: 0x0100, 0x3c11: 0x0100,
	0x3c12: 0x0100, 0x3c13: 0x0100, 0x3c14: 0x0100, 0x3c15: 0x0100, 0x3c16: 0x0100, 0x3c17: 0x0100,
	0x3c18: 0x0100, 0x3c19: 0x0100, 0x3c1a: 0x0100, 0x3c1b: 0x0100, 0x3c1c: 0x0100, 0x3c1d: 0x0100,
	0x3c1e: 0x0100, 0x3c1f: 0x0100, 0x3c20: 0x0100, 0x3c21: 0x0100, 0x3c22: 0x0100, 0x3c23: 0x0100,
	0x3c24: 0x0100, 0x3c25: 0x0100, 0x3c26: 0x0100, 0x3c27: 0x0100, 0x3c28: 0x0100, 0x3c29: 0x0100,
	0x3c2a: 0x0100, 0x3c2b: 0x0100, 0x3c2c: 0x0100, 0x3c2d: 0x0100, 0x3c2e: 0x0100, 0x3c2f: 0x0100,
	0x3c30: 0x0100, 0x3c31: 0x0100, 0x3c32: 0x0100, 0x3c33: 0x0100, 0x3c34: 0x0100, 0x3c35: 0x0008,
	0x3c36: 0x0008, 0x3c37: 0x0008, 0x3c38: 0x0008, 0x3c39: 0x0008, 0x3c3a: 0x0008, 0x3c3b: 0x0008,
	0x3c3c: 0x0008, 0x3c3d: 0x0008, 0x3c3e: 0x0008, 0x3c3f: 0x0008,
	// Block 0xf1, offset 0x3c40
	0x3c40: 0x0008, 0x3c41: 0x0008, 0x3c42: 0x0008, 0x3c43: 0x0008, 0x3c44: 0x0008, 0x3c45: 0x0008,
	0x3c46: 0x0008, 0x3c47: 0x0100, 0x3c48: 0x0100, 0x3c49: 0x0100, 0x3c4a: 0x0100, 0x3c4b: 0x0400,
	0x3c4c: 0x0400, 0x3c50: 0x0080, 0x3c51: 0x0080,
	0x3c52: 0x0080, 0x3c53: 0x0080, 0x3c54: 0x0080, 0x3c55: 0x0080, 0x3c56: 0x0080, 0x3c57: 0x0080,
	0x3c58: 0x0080, 0x3c59: 0x0080,
	0x3c5e: 0x0008, 0x3c5f: 0x0100, 0x3c60: 0x0100, 0x3c61: 0x0100,
	// Block 0xf2, offset 0x3c80
	0x3c80: 0x0100, 0x3c81: 0x0100, 0x3c82: 0x0100, 0x3c83: 0x0100, 0x3c84: 0x0100, 0x3c85: 0x0100,
	0x3c86: 0x0100, 0x3c87: 0x0100, 0x3c88: 0x0100, 0x3c89: 0x0100, 0x3c8a: 0x0100, 0x3c8b: 0x0100,
	0x3c8c: 0x0100, 0x3c8d: 0x0100, 0x3c8e: 0x0100, 0x3c8f: 0x0100, 0x3c90: 0x0100, 0x3c91: 0x0100,
	0x3c92: 0x0100, 0x3c93: 0x0100, 0x3c94: 0x0100, 0x3c95: 0x0100, 0x3c96: 0x0100, 0x3c97: 0x0100,
	0x3c98: 0x0100, 0x3c99: 0x0100, 0x3c9a: 0x0100, 0x3c9b: 0x0100, 0x3c9c: 0x0100, 0x3c9d: 0x0100,
	0x3c9e: 0x0100, 0x3c9f: 0x0100, 0x3ca0: 0x0100, 0x3ca1: 0x0100, 0x3ca2: 0x0100, 0x3ca3: 0x0100,
	0x3ca4: 0x0100, 0x3ca5: 0x0100, 0x3ca6: 0x0100, 0x3ca7: 0x0100, 0x3ca8: 0x0100, 0x3ca9: 0x0100,
	0x3caa: 0x0100, 0x3cab: 0x0100, 0x3cac: 0x0100, 0x3cad: 0x0100, 0x3cae: 0x0100, 0x3caf: 0x0100,
	0x3cb0: 0x0008, 0x3cb1: 0x0008, 0x3cb2: 0x0008, 0x3cb3: 0x0008, 0x3cb4: 0x0008, 0x3cb5: 0x0008,
	0x3cb6: 0x0008, 0x3cb7: 0x0008, 0x3cb8: 0x0008, 0x3cb9: 0x0008, 0x3cba: 0x0008, 0x3cbb: 0x0008,
	0x3cbc: 0x0008, 0x3cbd: 0x0008, 0x3cbe: 0x0008, 0x3cbf: 0x0008,
	// Block 0xf3, offset 0x3cc0
	0x3cc0: 0x0008, 0x3cc1: 0x0008, 0x3cc2: 0x0008, 0x3cc3: 0x0008, 0x3cc4: 0x0100, 0x3cc5: 0x0100,
	0x3cc7: 0x0100,
	0x3cd0: 0x0080, 0x3cd1: 0x0080,
	0x3cd2: 0x0080, 0x3cd3: 0x0080, 0x3cd4: 0x0080, 0x3cd5: 0x0080, 0x3cd6: 0x0080, 0x3cd7: 0x0080,
	0x3cd8: 0x0080, 0x3cd9: 0x0080,
	// Block 0xf4, offset 0x3d00
	0x3d00: 0x0100, 0x3d01: 0x0100, 0x3d02: 0x0100, 0x3d03: 0x0100, 0x3d04: 0x0100, 0x3d05: 0x0100,
	0x3d06: 0x0100, 0x3d07: 0x0100, 0x3d08: 0x0100, 0x3d09: 0x0100, 0x3d0a: 0x0100, 0x3d0b: 0x0100,
	0x3d0c: 0x0100, 0x3d0d: 0x0100, 0x3d0e: 0x0100, 0x3d0f: 0x0100, 0x3d10: 0x0100, 0x3d11: 0x0100,
	0x3d12: 0x0100, 0x3d13: 0x0100, 0x3d14: 0x0100, 0x3d15: 0x0100, 0x3d16: 0x0100, 0x3d17: 0x0100,
	0x3d18: 0x0100, 0x3d19: 0x0100, 0x3d1a: 0x0100, 0x3d1b: 0x0100, 0x3d1c: 0x0100, 0x3d1d: 0x0100,
	0x3d1e: 0x0100, 0x3d1f: 0x0100, 0x3d20: 0x0100, 0x3d21: 0x0100, 0x3d22: 0x0100, 0x3d23: 0x0100,
	0x3d24: 0x0100, 0x3d25: 0x0100, 0x3d26: 0x0100, 0x3d27: 0x0100, 0x3d28: 0x0100, 0x3d29: 0x0100,
	0x3d2a: 0x0100, 0x3d2b: 0x0100, 0x3d2c: 0x0100, 0x3d2d: 0x0100, 0x3d2e: 0x0100, 0x3d2f: 0x0008,
	0x3d30: 0x0008, 0x3d31: 0x0008, 0x3d32: 0x0008, 0x3d33: 0x0008, 0x3d34: 0x0008, 0x3d35: 0x0008,
	0x3d38: 0x0008, 0x3d39: 0x0008, 0x3d3a: 0x0008, 0x3d3b: 0x0008,
	0x3d3c: 0x0008, 0x3d3d: 0x0008, 0x3d3e: 0x0008, 0x3d3f: 0x0008,
	// Block 0xf5, offset 0x3d40
	0x3d40: 0x0008, 0x3d42: 0x0400, 0x3d43: 0x0400,
	0x3d49: 0x0400, 0x3d4a: 0x0400, 0x3d4b: 0x0400,
	0x3d4c: 0x0400, 0x3d4d: 0x0400, 0x3d4e: 0x0400, 0x3d4f: 0x0400, 0x3d50: 0x0400, 0x3d51: 0x0400,
	0x3d52: 0x0400, 0x3d53: 0x0400, 0x3d54: 0x0400, 0x3d55: 0x0400, 0x3d56: 0x0400, 0x3d57: 0x0400,
	0x3d58: 0x0100, 0x3d59: 0x0100, 0x3d5a: 0x0100, 0x3d5b: 0x0100, 0x3d5c: 0x0008, 0x3d5d: 0x0008,
	// Block 0xf6, offset 0x3d80
	0x3d80: 0x0008, 0x3d81: 0x0400, 0x3d82: 0x0400, 0x3d84: 0x0100,
	0x3d90: 0x0080, 0x3d91: 0x0080,
	0x3d92: 0x0080, 0x3d93: 0x0080, 0x3d94: 0x0080, 0x3d95: 0x0080, 0x3d96: 0x0080, 0x3d97: 0x0080,
	0x3d98: 0x0080, 0x3d99: 0x0080,
	// Block 0xf7, offset 0x3dc0
	0x3dc0: 0x0100, 0x3dc1: 0x0100, 0x3dc2: 0x0100, 0x3dc3: 0x0100, 0x3dc4: 0x0100, 0x3dc5: 0x0100,
	0x3dc6: 0x0100, 0x3dc7: 0x0100, 0x3dc8: 0x0100, 0x3dc9: 0x0100, 0x3dca: 0x0100, 0x3dcb: 0x0100,
	0x3dcc: 0x0100, 0x3dcd: 0x0100, 0x3dce: 0x0100, 0x3dcf: 0x0100, 0x3dd0: 0x0100, 0x3dd1: 0x0100,
	0x3dd2: 0x0100, 0x3dd3: 0x0100, 0x3dd4: 0x0100, 0x3dd5: 0x0100, 0x3dd6: 0x0100, 0x3dd7: 0x0100,
	0x3dd8: 0x0100, 0x3dd9: 0x0100, 0x3dda: 0x0100, 0x3ddb: 0x0100, 0x3ddc: 0x0100, 0x3ddd: 0x0100,
	0x3dde: 0x0100, 0x3ddf: 0x0100, 0x3de0: 0x0100, 0x3de1: 0x0100, 0x3de2: 0x0100, 0x3de3: 0x0100,
	0x3de4: 0x0100, 0x3de5: 0x0100, 0x3de6: 0x0100, 0x3de7: 0x0100, 0x3de8: 0x0100, 0x3de9: 0x0100,
	0x3dea: 0x0100, 0x3deb: 0x0008, 0x3dec: 0x0008, 0x3ded: 0x0008, 0x3dee: 0x0008, 0x3def: 0x0008,
	0x3df0: 0x0008, 0x3df1: 0x0008, 0x3df2: 0x0008, 0x3df3: 0x0008, 0x3df4: 0x0008, 0x3df5: 0x0008,
	0x3df6: 0x0008, 0x3df7: 0x0008, 0x3df8: 0x0100,
	// Block 0xf8, offset 0x3e00
	0x3e00: 0x0080, 0x3e01: 0x0080, 0x3e02: 0x0080, 0x3e03: 0x0080, 0x3e04: 0x0080, 0x3e05: 0x0080,
	0x3e06: 0x0080, 0x3e07: 0x0080, 0x3e08: 0x0080, 0x3e09: 0x0080,
	// Block 0xf9, offset 0x3e40
	0x3e40: 0x0100, 0x3e41: 0x0100, 0x3e42: 0x0100, 0x3e43: 0x0100, 0x3e44: 0x0100, 0x3e45: 0x0100,
	0x3e46: 0x0100, 0x3e47: 0x0100, 0x3e48: 0x0100, 0x3e49: 0x0100, 0x3e4a: 0x0100, 0x3e4b: 0x0100,
	0x3e4c: 0x0100, 0x3e4d: 0x0100, 0x3e4e: 0x0100, 0x3e4f: 0x0100, 0x3e50: 0x0100, 0x3e51: 0x0100,
	0x3e52: 0x0100, 0x3e53: 0x0100, 0x3e54: 0x0100, 0x3e55: 0x0100, 0x3e56: 0x0100, 0x3e57: 0x0100,
	0x3e58: 0x0100, 0x3e59: 0x0100, 0x3e5a: 0x0100, 0x3e5d: 0x0008,
	0x3e5e: 0x0008, 0x3e5f: 0x0008, 0x3e60: 0x0008, 0x3e61: 0x0008, 0x3e62: 0x0008, 0x3e63: 0x0008,
	0x3e64: 0x0008, 0x3e65: 0x0008, 0x3e66: 0x0008, 0x3e67: 0x0008, 0x3e68: 0x0008, 0x3e69: 0x0008,
	0x3e6a: 0x0008, 0x3e6b: 0x0008,
	0x3e70: 0x0080, 0x3e71: 0x0080, 0x3e72: 0x0080, 0x3e73: 0x0080, 0x3e74: 0x0080, 0x3e75: 0x0080,
	0x3e76: 0x0080, 0x3e77: 0x0080, 0x3e78: 0x0080, 0x3e79: 0x0080,
	0x3e7c: 0x0400, 0x3e7d: 0x0400, 0x3e7e: 0x0400,
	// Block 0xfa, offset 0x3e80
	0x3e80: 0x0100, 0x3e81: 0x0100, 0x3e82: 0x0100, 0x3e83: 0x0100, 0x3e84: 0x0100, 0x3e85: 0x0100,
	0x3e86: 0x0100,
	// Block 0xfb, offset 0x3ec0
	0x3ec0: 0x0100, 0x3ec1: 0x0100, 0x3ec2: 0x0100, 0x3ec3: 0x0100, 0x3ec4: 0x0100, 0x3ec5: 0x0100,
	0x3ec6: 0x0100, 0x3ec7: 0x0100, 0x3ec8: 0x0100, 0x3ec9: 0x0100, 0x3eca: 0x0100, 0x3ecb: 0x0100,
	0x3ecc: 0x0100, 0x3ecd: 0x0100, 0x3ece: 0x0100, 0x3ecf: 0x0100, 0x3ed0: 0x0100, 0x3ed1: 0x0100,
	0x3ed2: 0x0100, 0x3ed3: 0x0100, 0x3ed4: 0x0100, 0x3ed5: 0x0100, 0x3ed6: 0x0100, 0x3ed7: 0x0100,
	0x3ed8: 0x0100, 0x3ed9: 0x0100, 0x3eda: 0x0100, 0x3edb: 0x0100, 0x3edc: 0x0100, 0x3edd: 0x0100,
	0x3ede: 0x0100, 0x3edf: 0x0100, 0x3ee0: 0x0100, 0x3ee1: 0x0100, 0x3ee2: 0x0100, 0x3ee3: 0x0100,
	0x3ee4: 0x0100, 0x3ee5: 0x0100, 0x3ee6: 0x0100, 0x3ee7: 0x0100, 0x3ee8: 0x0100, 0x3ee9: 0x0100,
	0x3eea: 0x0100, 0x3eeb: 0x0100, 0x3eec: 0x0008, 0x3eed: 0x0008, 0x3eee: 0x0008, 0x3eef: 0x0008,
	0x3ef0: 0x0008, 0x3ef1: 0x0008, 0x3ef2: 0x0008, 0x3ef3: 0x0008, 0x3ef4: 0x0008, 0x3ef5: 0x0008,
	0x3ef6: 0x0008, 0x3ef7: 0x0008, 0x3ef8: 0x0008, 0x3ef9: 0x0008, 0x3efa: 0x0008,
	// Block 0xfc, offset 0x3f00
	0x3f20: 0x2000, 0x3f21: 0x2000, 0x3f22: 0x2000, 0x3f23: 0x2000,
	0x3f24: 0x2000, 0x3f25: 0x2000, 0x3f26: 0x2000, 0x3f27: 0x2000, 0x3f28: 0x2000, 0x3f29: 0x2000,
	0x3f2a: 0x2000, 0x3f2b: 0x2000, 0x3f2c: 0x2000, 0x3f2d: 0x2000, 0x3f2e: 0x2000, 0x3f2f: 0x2000,
	0x3f30: 0x2000, 0x3f31: 0x2000, 0x3f32: 0x2000, 0x3f33: 0x2000, 0x3f34: 0x2000, 0x3f35: 0x2000,
	0x3f36: 0x2000, 0x3f37: 0x2000, 0x3f38: 0x2000, 0x3f39: 0x2000, 0x3f3a: 0x2000, 0x3f3b: 0x2000,
	0x3f3c: 0x2000, 0x3f3d: 0x2000, 0x3f3e: 0x2000, 0x3f3f: 0x2000,
	// Block 0xfd, offset 0x3f40
	0x3f40: 0x0040, 0x3f41: 0x0040, 0x3f42: 0x0040, 0x3f43: 0x0040, 0x3f44: 0x0040, 0x3f45: 0x0040,
	0x3f46: 0x0040, 0x3f47: 0x0040, 0x3f48: 0x0040, 0x3f49: 0x0040, 0x3f4a: 0x0040, 0x3f4b: 0x0040,
	0x3f4c: 0x0040, 0x3f4d: 0x0040, 0x3f4e: 0x0040, 0x3f4f: 0x0040, 0x3f50: 0x0040, 0x3f51: 0x0040,
	0x3f52: 0x0040, 0x3f53: 0x0040, 0x3f54: 0x0040, 0x3f55: 0x0040, 0x3f56: 0x0040, 0x3f57: 0x0040,
	0x3f58: 0x0040, 0x3f59: 0x0040, 0x3f5a: 0x0040, 0x3f5b: 0x0040, 0x3f5c: 0x0040, 0x3f5d: 0x0040,
	0x3f5e: 0x0040, 0x3f5f: 0x0040, 0x3f60: 0x0080, 0x3f61: 0x0080, 0x3f62: 0x0080, 0x3f63: 0x0080,
	0x3f64: 0x0080, 0x3f65: 0x0080, 0x3f66: 0x0080, 0x3f67: 0x0080, 0x3f68: 0x0080, 0x3f69: 0x0080,
	0x3f7f: 0x0100,
	// Block 0xfe, offset 0x3f80
	0x3f80: 0x0100, 0x3f81: 0x0100, 0x3f82: 0x0100, 0x3f83: 0x0100, 0x3f84: 0x0100, 0x3f85: 0x0100,
	0x3f86: 0x0100, 0x3f89: 0x0100,
	0x3f8c: 0x0100, 0x3f8d: 0x0100, 0x3f8e: 0x0100, 0x3f8f: 0x0100, 0x3f90: 0x0100, 0x3f91: 0x0100,
	0x3f92: 0x0100, 0x3f93: 0x0100, 0x3f95: 0x0100, 0x3f96: 0x0100,
	0x3f98: 0x0100, 0x3f99: 0x0100, 0x3f9a: 0x0100, 0x3f9b: 0x0100, 0x3f9c: 0x0100, 0x3f9d: 0x0100,
	0x3f9e: 0x0100, 0x3f9f: 0x0100, 0x3fa0: 0x0100, 0x3fa1: 0x0100, 0x3fa2: 0x0100, 0x3fa3: 0x0100,
	0x3fa4: 0x0100, 0x3fa5: 0x0100, 0x3fa6: 0x0100, 0x3fa7: 0x0100, 0x3fa8: 0x0100, 0x3fa9: 0x0100,
	0x3faa: 0x0100, 0x3fab: 0x0100, 0x3fac: 0x0100, 0x3fad: 0x0100, 0x3fae: 0x0100, 0x3faf: 0x0100,
	0x3fb0: 0x0008, 0x3fb1: 0x0008, 0x3fb2: 0x0008, 0x3fb3: 0x0008, 0x3fb4: 0x0008, 0x3fb5: 0x0008,
	0x3fb7: 0x0008, 0x3fb8: 0x0008, 0x3fbb: 0x0008,
	0x3fbc: 0x0008, 0x3fbd: 0x0008, 0x3fbe: 0x0008, 0x3fbf: 0x0100,
	// Block 0xff, offset 0x3fc0
	0x3fc0: 0x0008, 0x3fc1: 0x0100, 0x3fc2: 0x0008, 0x3fc3: 0x0008, 0x3fc4: 0x0400,
	0x3fc6: 0x0400,
	0x3fd0: 0x0080, 0x3fd1: 0x0080,
	0x3fd2: 0x0080, 0x3fd3: 0x0080, 0x3fd4: 0x0080, 0x3fd5: 0x0080, 0x3fd6: 0x0080, 0x3fd7: 0x0080,
	0x3fd8: 0x0080, 0x3fd9: 0x0080,
	// Block 0x100, offset 0x4000
	0x4020: 0x0100, 0x4021: 0x0100, 0x4022: 0x0100, 0x4023: 0x0100,
	0x4024: 0x0100, 0x4025: 0x0100, 0x4026: 0x0100, 0x4027: 0x0100,
	0x402a: 0x0100, 0x402b: 0x0100, 0x402c: 0x0100, 0x402d: 0x0100, 0x402e: 0x0100, 0x402f: 0x0100,
	0x4030: 0x0100, 0x4031: 0x0100, 0x4032: 0x0100, 0x4033: 0x0100, 0x4034: 0x0100, 0x4035: 0x0100,
	0x4036: 0x0100, 0x4037: 0x0100, 0x4038: 0x0100, 0x4039: 0x0100, 0x403a: 0x0100, 0x403b: 0x0100,
	0x403c: 0x0100, 0x403d: 0x0100, 0x403e: 0x0100, 0x403f: 0x0100,
	// Block 0x101, offset 0x4040
	0x4040: 0x0100, 0x4041: 0x0100, 0x4042: 0x0100, 0x4043: 0x0100, 0x4044: 0x0100, 0x4045: 0x0100,
	0x4046: 0x0100, 0x4047: 0x0100, 0x4048: 0x0100, 0x4049: 0x0100, 0x404a: 0x0100, 0x404b: 0x0100,
	0x404c: 0x0100, 0x404d: 0x0100, 0x404e: 0x0100, 0x404f: 0x0100, 0x4050: 0x0100, 0x4051: 0x0008,
	0x4052: 0x0008, 0x4053: 0x0008, 0x4054: 0x0008, 0x4055: 0x0008, 0x4056: 0x0008, 0x4057: 0x0008,
	0x405a: 0x0008, 0x405b: 0x0008, 0x405c: 0x0008, 0x405d: 0x0008,
	0x405e: 0x0008, 0x405f: 0x0008, 0x4060: 0x0008, 0x4061: 0x0100, 0x4063: 0x0100,
	0x4064: 0x0008,
	// Block 0x102, offset 0x4080
	0x4080: 0x0100, 0x4081: 0x0008, 0x4082: 0x0008, 0x4083: 0x0008, 0x4084: 0x0008, 0x4085: 0x0008,
	0x4086: 0x0008, 0x4087: 0x0008, 0x4088: 0x0008, 0x4089: 0x0008, 0x408a: 0x0008, 0x408b: 0x0100,
	0x408c: 0x0100, 0x408d: 0x0100, 0x408e: 0x0100, 0x408f: 0x0100, 0x4090: 0x0100, 0x4091: 0x0100,
	0x4092: 0x0100, 0x4093: 0x0100, 0x4094: 0x0100, 0x4095: 0x0100, 0x4096: 0x0100, 0x4097: 0x0100,
	0x4098: 0x0100, 0x4099: 0x0100, 0x409a: 0x0100, 0x409b: 0x0100, 0x409c: 0x0100, 0x409d: 0x0100,
	0x409e: 0x0100, 0x409f: 0x0100, 0x40a0: 0x0100, 0x40a1: 0x0100, 0x40a2: 0x0100, 0x40a3: 0x0100,
	0x40a4: 0x0100, 0x40a5: 0x0100, 0x40a6: 0x0100, 0x40a7: 0x0100, 0x40a8: 0x0100, 0x40a9: 0x0100,
	0x40aa: 0x0100, 0x40ab: 0x0100, 0x40ac: 0x0100, 0x40ad: 0x0100, 0x40ae: 0x0100, 0x40af: 0x0100,
	0x40b0: 0x0100, 0x40b1: 0x0100, 0x40b2: 0x0100, 0x40b3: 0x0008, 0x40b4: 0x0008, 0x40b5: 0x0008,
	0x40b6: 0x0008, 0x40b7: 0x0008, 0x40b8: 0x0008, 0x40b9: 0x0008, 0x40ba: 0x0100, 0x40bb: 0x0008,
	0x40bc: 0x0008, 0x40bd: 0x0008, 0x40be: 0x0008,
	// Block 0x103, offset 0x40c0
	0x40c2: 0x0400, 0x40c3: 0x0400,
	0x40c7: 0x0008,
	0x40d0: 0x0100, 0x40d1: 0x0008,
	0x40d2: 0x0008, 0x40d3: 0x0008, 0x40d4: 0x0008, 0x40d5: 0x0008, 0x40d6: 0x0008, 0x40d7: 0x0008,
	0x40d8: 0x0008, 0x40d9: 0x0008, 0x40da: 0x0008, 0x40db: 0x0008, 0x40dc: 0x0100, 0x40dd: 0x0100,
	0x40de: 0x0100, 0x40df: 0x0100, 0x40e0: 0x0100, 0x40e1: 0x0100, 0x40e2: 0x0100, 0x40e3: 0x0100,
	0x40e4: 0x0100, 0x40e5: 0x0100, 0x40e6: 0x0100, 0x40e7: 0x0100, 0x40e8: 0x0100, 0x40e9: 0x0100,
	0x40ea: 0x0100, 0x40eb: 0x0100, 0x40ec: 0x0100, 0x40ed: 0x0100, 0x40ee: 0x0100, 0x40ef: 0x0100,
	0x40f0: 0x0100, 0x40f1: 0x0100, 0x40f2: 0x0100, 0x40f3: 0x0100, 0x40f4: 0x0100, 0x40f5: 0x0100,
	0x40f6: 0x0100, 0x40f7: 0x0100, 0x40f8: 0x0100, 0x40f9: 0x0100, 0x40fa: 0x0100, 0x40fb: 0x0100,
	0x40fc: 0x0100, 0x40fd: 0x0100, 0x40fe: 0x0100, 0x40ff: 0x0100,
	// Block 0x104, offset 0x4100
	0x4100: 0x0100, 0x4101: 0x0100, 0x4102: 0x0100, 0x4103: 0x0100, 0x4104: 0x0100, 0x4105: 0x0100,
	0x4106: 0x0100, 0x4107: 0x0100, 0x4108: 0x0100, 0x4109: 0x0100, 0x410a: 0x0008, 0x410b: 0x0008,
	0x410c: 0x0008, 0x410d: 0x0008, 0x410e: 0x0008, 0x410f: 0x0008, 0x4110: 0x0008, 0x4111: 0x0008,
	0x4112: 0x0008, 0x4113: 0x0008, 0x4114: 0x0008, 0x4115: 0x0008, 0x4116: 0x0008, 0x4117: 0x0008,
	0x4118: 0x0008, 0x4119: 0x0008, 0x411b: 0x0400, 0x411c: 0x0400, 0x411d: 0x0100,
	0x4130: 0x0100, 0x4131: 0x0100, 0x4132: 0x0100, 0x4133: 0x0100, 0x4134: 0x0100, 0x4135: 0x0100,
	0x4136: 0x0100, 0x4137: 0x0100, 0x4138: 0x0100, 0x4139: 0x0100, 0x413a: 0x0100, 0x413b: 0x0100,
	0x413c: 0x0100, 0x413d: 0x0100, 0x413e: 0x0100, 0x413f: 0x0100,
	// Block 0x105, offset 0x4140
	0x4140: 0x0100, 0x4141: 0x0100, 0x4142: 0x0100, 0x4143: 0x0100, 0x4144: 0x0100, 0x4145: 0x0100,
	0x4146: 0x0100, 0x4147: 0x0100, 0x4148: 0x0100, 0x414a: 0x0100, 0x414b: 0x0100,
	0x414c: 0x0100, 0x414d: 0x0100, 0x414e: 0x0100, 0x414f: 0x0100, 0x4150: 0x0100, 0x4151: 0x0100,
	0x4152: 0x0100, 0x4153: 0x0100, 0x4154: 0x0100, 0x4155: 0x0100, 0x4156: 0x0100, 0x4157: 0x0100,
	0x4158: 0x0100, 0x4159: 0x0100, 0x415a: 0x0100, 0x415b: 0x0100, 0x415c: 0x0100, 0x415d: 0x0100,
	0x415e: 0x0100, 0x415f: 0x0100, 0x4160: 0x0100, 0x4161: 0x0100, 0x4162: 0x0100, 0x4163: 0x0100,
	0x4164: 0x0100, 0x4165: 0x0100, 0x4166: 0x0100, 0x4167: 0x0100, 0x4168: 0x0100, 0x4169: 0x0100,
	0x416a: 0x0100, 0x416b: 0x0100, 0x416c: 0x0100, 0x416d: 0x0100, 0x416e: 0x0100, 0x416f: 0x0008,
	0x4170: 0x0008, 0x4171: 0x0008, 0x4172: 0x0008, 0x4173: 0x0008, 0x4174: 0x0008, 0x4175: 0x0008,
	0x4176: 0x0008, 0x4178: 0x0008, 0x4179: 0x0008, 0x417a: 0x0008, 0x417b: 0x0008,
	0x417c: 0x0008, 0x417d: 0x0008, 0x417e: 0x0008, 0x417f: 0x0008,
	// Block 0x106, offset 0x4180
	0x4180: 0x0100, 0x4181: 0x0400, 0x4182: 0x0400,
	0x4190: 0x0080, 0x4191: 0x0080,
	0x4192: 0x0080, 0x4193: 0x0080, 0x4194: 0x0080, 0x4195: 0x0080, 0x4196: 0x0080, 0x4197: 0x0080,
	0x4198: 0x0080, 0x4199: 0x0080,
	0x41b2: 0x0100, 0x41b3: 0x0100, 0x41b4: 0x0100, 0x41b5: 0x0100,
	0x41b6: 0x0100, 0x41b7: 0x0100, 0x41b8: 0x0100, 0x41b9: 0x0100, 0x41ba: 0x0100, 0x41bb: 0x0100,
	0x41bc: 0x0100, 0x41bd: 0x0100, 0x41be: 0x0100, 0x41bf: 0x0100,
	// Block 0x107, offset 0x41c0
	0x41c0: 0x0100, 0x41c1: 0x0100, 0x41c2: 0x0100, 0x41c3: 0x0100, 0x41c4: 0x0100, 0x41c5: 0x0100,
	0x41c6: 0x0100, 0x41c7: 0x0100, 0x41c8: 0x0100, 0x41c9: 0x0100, 0x41ca: 0x0100, 0x41cb: 0x0100,
	0x41cc: 0x0100, 0x41cd: 0x0100, 0x41ce: 0x0100, 0x41cf: 0x0100,
	0x41d2: 0x0008, 0x41d3: 0x0008, 0x41d4: 0x0008, 0x41d5: 0x0008, 0x41d6: 0x0008, 0x41d7: 0x0008,
	0x41d8: 0x0008, 0x41d9: 0x0008, 0x41da: 0x0008, 0x41db: 0x0008, 0x41dc: 0x0008, 0x41dd: 0x0008,
	0x41de: 0x0008, 0x41df: 0x0008, 0x41e0: 0x0008, 0x41e1: 0x0008, 0x41e2: 0x0008, 0x41e3: 0x0008,
	0x41e4: 0x0008, 0x41e5: 0x0008, 0x41e6: 0x0008, 0x41e7: 0x0008, 0x41e9: 0x0008,
	0x41ea: 0x0008, 0x41eb: 0x0008, 0x41ec: 0x0008, 0x41ed: 0x0008, 0x41ee: 0x0008, 0x41ef: 0x0008,
	0x41f0: 0x0008, 0x41f1: 0x0008, 0x41f2: 0x0008, 0x41f3: 0x0008, 0x41f4: 0x0008, 0x41f5: 0x0008,
	0x41f6: 0x0008,
	// Block 0x108, offset 0x4200
	0x4200: 0x0100, 0x4201: 0x0100, 0x4202: 0x0100, 0x4203: 0x0100, 0x4204: 0x0100, 0x4205: 0x0100,
	0x4206: 0x0100, 0x4208: 0x0100, 0x4209: 0x0100, 0x420b: 0x0100,
	0x420c: 0x0100, 0x420d: 0x0100, 0x420e: 0x0100, 0x420f: 0x0100, 0x4210: 0x0100, 0x4211: 0x0100,
	0x4212: 0x0100, 0x4213: 0x0100, 0x4214: 0x0100, 0x4215: 0x0100, 0x4216: 0x0100, 0x4217: 0x0100,
	0x4218: 0x0100, 0x4219: 0x0100, 0x421a: 0x0100, 0x421b: 0x0100, 0x421c: 0x0100, 0x421d: 0x0100,
	0x421e: 0x0100, 0x421f: 0x0100, 0x4220: 0x0100, 0x4221: 0x0100, 0x4222: 0x0100, 0x4223: 0x0100,
	0x4224: 0x0100, 0x4225: 0x0100, 0x4226: 0x0100, 0x4227: 0x0100, 0x4228: 0x0100, 0x4229: 0x0100,
	0x422a: 0x0100, 0x422b: 0x0100, 0x422c: 0x0100, 0x422d: 0x0100, 0x422e: 0x0100, 0x422f: 0x0100,
	0x4230: 0x0100, 0x4231: 0x0008, 0x4232: 0x0008, 0x4233: 0x0008, 0x4234: 0x0008, 0x4235: 0x0008,
	0x4236: 0x0008, 0x423a: 0x0008,
	0x423c: 0x0008, 0x423d: 0x0008, 0x423f: 0x0008,
	// Block 0x109, offset 0x4240
	0x4240: 0x0008, 0x4241: 0x0008, 0x4242: 0x0008, 0x4243: 0x0008, 0x4244: 0x0008, 0x4245: 0x0008,
	0x4246: 0x0100, 0x4247: 0x0008,
	0x4250: 0x0080, 0x4251: 0x0080,
	0x4252: 0x0080, 0x4253: 0x0080, 0x4254: 0x0080, 0x4255: 0x0080, 0x4256: 0x0080, 0x4257: 0x0080,
	0x4258: 0x0080, 0x4259: 0x0080,
	0x4260: 0x0100, 0x4261: 0x0100, 0x4262: 0x0100, 0x4263: 0x0100,
	0x4264: 0x0100, 0x4265: 0x0100, 0x4267: 0x0100, 0x4268: 0x0100,
	0x426a: 0x0100, 0x426b: 0x0100, 0x426c: 0x0100, 0x426d: 0x0100, 0x426e: 0x0100, 0x426f: 0x0100,
	0x4270: 0x0100, 0x4271: 0x0100, 0x4272: 0x0100, 0x4273: 0x0100, 0x4274: 0x0100, 0x4275: 0x0100,
	0x4276: 0x0100, 0x4277: 0x0100, 0x4278: 0x0100, 0x4279: 0x0100, 0x427a: 0x0100, 0x427b: 0x0100,
	0x427c: 0x0100, 0x427d: 0x0100, 0x427e: 0x0100, 0x427f: 0x0100,
	// Block 0x10a, offset 0x4280
	0x4280: 0x0100, 0x4281: 0x0100, 0x4282: 0x0100, 0x4283: 0x0100, 0x4284: 0x0100, 0x4285: 0x0100,
	0x4286: 0x0100, 0x4287: 0x0100, 0x4288: 0x0100, 0x4289: 0x0100, 0x428a: 0x0008, 0x428b: 0x0008,
	0x428c: 0x0008, 0x428d: 0x0008, 0x428e: 0x0008, 0x4290: 0x0008, 0x4291: 0x0008,
	0x4293: 0x0008, 0x4294: 0x0008, 0x4295: 0x0008, 0x4296: 0x0008, 0x4297: 0x0008,
	0x4298: 0x0100,
	0x42a0: 0x0080, 0x42a1: 0x0080, 0x42a2: 0x0080, 0x42a3: 0x0080,
	0x42a4: 0x0080, 0x42a5: 0x0080, 0x42a6: 0x0080, 0x42a7: 0x0080, 0x42a8: 0x0080, 0x42a9: 0x0080,
	// Block 0x10b, offset 0x42c0
	0x42e0: 0x0100, 0x42e1: 0x0100, 0x42e2: 0x0100, 0x42e3: 0x0100,
	0x42e4: 0x0100, 0x42e5: 0x0100, 0x42e6: 0x0100, 0x42e7: 0x0100, 0x42e8: 0x0100, 0x42e9: 0x0100,
	0x42ea: 0x0100, 0x42eb: 0x0100, 0x42ec: 0x0100, 0x42ed: 0x0100, 0x42ee: 0x0100, 0x42ef: 0x0100,
	0x42f0: 0x0100, 0x42f1: 0x0100, 0x42f2: 0x0100, 0x42f3: 0x0008, 0x42f4: 0x0008, 0x42f5: 0x0008,
	0x42f6: 0x0008, 0x42f7: 0x0400, 0x42f8: 0x0400,
	// Block 0x10c, offset 0x4300
	0x4300: 0x0008, 0x4301: 0x0008, 0x4302: 0x0100, 0x4303: 0x0008, 0x4304: 0x0100, 0x4305: 0x0100,
	0x4306: 0x0100, 0x4307: 0x0100, 0x4308: 0x0100, 0x4309: 0x0100, 0x430a: 0x0100, 0x430b: 0x0100,
	0x430c: 0x0100, 0x430d: 0x0100, 0x430e: 0x0100, 0x430f: 0x0100, 0x4310: 0x0100,
	0x4312: 0x0100, 0x4313: 0x0100, 0x4314: 0x0100, 0x4315: 0x0100, 0x4316: 0x0100, 0x4317: 0x0100,
	0x4318: 0x0100, 0x4319: 0x0100, 0x431a: 0x0100, 0x431b: 0x0100, 0x431c: 0x0100, 0x431d: 0x0100,
	0x431e: 0x0100, 0x431f: 0x0100, 0x4320: 0x0100, 0x4321: 0x0100, 0x4322: 0x0100, 0x4323: 0x0100,
	0x4324: 0x0100, 0x4325: 0x0100, 0x4326: 0x0100, 0x4327: 0x0100, 0x4328: 0x0100, 0x4329: 0x0100,
	0x432a: 0x0100, 0x432b: 0x0100, 0x432c: 0x0100, 0x432d: 0x0100, 0x432e: 0x0100, 0x432f: 0x0100,
	0x4330: 0x0100, 0x4331: 0x0100, 0x4332: 0x0100, 0x4333: 0x0100, 0x4334: 0x0008, 0x4335: 0x0008,
	0x4336: 0x0008, 0x4337: 0x0008, 0x4338: 0x0008, 0x4339: 0x0008, 0x433a: 0x0008,
	0x433e: 0x0008, 0x433f: 0x0008,
	// Block 0x10d, offset 0x4340
	0x4340: 0x0008, 0x4341: 0x0008, 0x4342: 0x0008, 0x4343: 0x0400, 0x4344: 0x0400,
	0x4350: 0x0080, 0x4351: 0x0080,
	0x4352: 0x0080, 0x4353: 0x0080, 0x4354: 0x0080, 0x4355: 0x0080, 0x4356: 0x0080, 0x4357: 0x0080,
	0x4358: 0x0080, 0x4359: 0x0080,
	// Block 0x10e, offset 0x4380
	0x43b0: 0x0100,
	// Block 0x10f, offset 0x43c0
	0x43c0: 0x0100, 0x43c1: 0x0100, 0x43c2: 0x0100, 0x43c3: 0x0100, 0x43c4: 0x0100, 0x43c5: 0x0100,
	0x43c6: 0x0100, 0x43c7: 0x0100, 0x43c8: 0x0100, 0x43c9: 0x0100, 0x43ca: 0x0100, 0x43cb: 0x0100,
	0x43cc: 0x0100, 0x43cd: 0x0100, 0x43ce: 0x0100, 0x43cf: 0x0100, 0x43d0: 0x0100, 0x43d1: 0x0100,
	0x43d2: 0x0100, 0x43d3: 0x0100, 0x43d4: 0x0100, 0x43d5: 0x0100, 0x43d6: 0x0100, 0x43d7: 0x0100,
	0x43d8: 0x0100, 0x43d9: 0x0100, 0x43da: 0x0100, 0x43db: 0x0100, 0x43dc: 0x0100, 0x43dd: 0x0100,
	0x43de: 0x0100, 0x43df: 0x0100, 0x43e0: 0x0100, 0x43e1: 0x0100, 0x43e2: 0x0100, 0x43e3: 0x0100,
	0x43e4: 0x0100, 0x43e5: 0x0100, 0x43e6: 0x0100, 0x43e7: 0x0100, 0x43e8: 0x0100, 0x43e9: 0x0100,
	0x43ea: 0x0100, 0x43eb: 0x0100, 0x43ec: 0x0100, 0x43ed: 0x0100, 0x43ee: 0x0100,
	// Block 0x110, offset 0x4400
	0x4400: 0x0100, 0x4401: 0x0100, 0x4402: 0x0100, 0x4403: 0x0100,
	// Block 0x111, offset 0x4440
	0x4440: 0x0100, 0x4441: 0x0100, 0x4442: 0x0100, 0x4443: 0x0100, 0x4444: 0x0100, 0x4445: 0x0100,
	0x4446: 0x0100, 0x4447: 0x0100, 0x4448: 0x0100, 0x4449: 0x0100, 0x444a: 0x0100, 0x444b: 0x0100,
	0x444c: 0x0100, 0x444d: 0x0100, 0x444e: 0x0100, 0x444f: 0x0100, 0x4450: 0x0100, 0x4451: 0x0100,
	0x4452: 0x0100, 0x4453: 0x0100, 0x4454: 0x0100, 0x4455: 0x0100, 0x4456: 0x0100, 0x4457: 0x0100,
	0x4458: 0x0100, 0x4459: 0x0100, 0x445a: 0x0100, 0x445b: 0x0100, 0x445c: 0x0100, 0x445d: 0x0100,
	0x445e: 0x0100, 0x445f: 0x0100, 0x4460: 0x0100, 0x4461: 0x0100, 0x4462: 0x0100, 0x4463: 0x0100,
	0x4464: 0x0100, 0x4465: 0x0100, 0x4466: 0x0100, 0x4467: 0x0100, 0x4468: 0x0100, 0x4469: 0x0100,
	0x446a: 0x0100, 0x446b: 0x0100, 0x446c: 0x0100, 0x446d: 0x0100, 0x446e: 0x0100, 0x446f: 0x0100,
	0x4470: 0x0100,
	// Block 0x112, offset 0x4480
	0x4480: 0x0100, 0x4481: 0x0100, 0x4482: 0x0100, 0x4483: 0x0100, 0x4484: 0x0100, 0x4485: 0x0100,
	0x4486: 0x0100, 0x4487: 0x0100, 0x4488: 0x0100, 0x4489: 0x0100, 0x448a: 0x0100, 0x448b: 0x0100,
	0x448c: 0x0100, 0x448d: 0x0100, 0x448e: 0x0100, 0x448f: 0x0100, 0x4490: 0x0100, 0x4491: 0x0100,
	0x4492: 0x0100, 0x4493: 0x0100, 0x4494: 0x0100, 0x4495: 0x0100, 0x4496: 0x0100, 0x4497: 0x0100,
	0x4498: 0x0100, 0x4499: 0x0100, 0x449a: 0x0100, 0x449b: 0x0100, 0x449c: 0x0100, 0x449d: 0x0100,
	0x449e: 0x0100, 0x449f: 0x0100, 0x44a0: 0x0100, 0x44a1: 0x0100, 0x44a2: 0x0100, 0x44a3: 0x0100,
	0x44a4: 0x0100, 0x44a5: 0x0100, 0x44a6: 0x0100, 0x44a7: 0x0100, 0x44a8: 0x0100, 0x44a9: 0x0100,
	0x44aa: 0x0100, 0x44ab: 0x0100, 0x44ac: 0x0100, 0x44ad: 0x0100, 0x44ae: 0x0100, 0x44af: 0x0100,
	0x44b0: 0x0010, 0x44b1: 0x0010, 0x44b2: 0x0010, 0x44b3: 0x0010, 0x44b4: 0x0010, 0x44b5: 0x0010,
	0x44b6: 0x0010, 0x44b7: 0x0010, 0x44b8: 0x0010, 0x44b9: 0x0010, 0x44ba: 0x0010, 0x44bb: 0x0010,
	0x44bc: 0x0010, 0x44bd: 0x0010, 0x44be: 0x0010, 0x44bf: 0x0010,
	// Block 0x113, offset 0x44c0
	0x44c0: 0x0008, 0x44c1: 0x0100, 0x44c2: 0x0100, 0x44c3: 0x0100, 0x44c4: 0x0100, 0x44c5: 0x0100,
	0x44c6: 0x0100, 0x44c7: 0x0008, 0x44c8: 0x0008, 0x44c9: 0x0008, 0x44ca: 0x0008, 0x44cb: 0x0008,
	0x44cc: 0x0008, 0x44cd: 0x0008, 0x44ce: 0x0008, 0x44cf: 0x0008, 0x44d0: 0x0008, 0x44d1: 0x0008,
	0x44d2: 0x0008, 0x44d3: 0x0008, 0x44d4: 0x0008, 0x44d5: 0x0008,
	// Block 0x114, offset 0x4500
	0x4500: 0x0100, 0x4501: 0x0100, 0x4502: 0x0100, 0x4503: 0x0100, 0x4504: 0x0100, 0x4505: 0x0100,
	0x4506: 0x0100, 0x4507: 0x0100, 0x4508: 0x0100, 0x4509: 0x0100, 0x450a: 0x0100, 0x450b: 0x0100,
	0x450c: 0x0100, 0x450d: 0x0100, 0x450e: 0x0100, 0x450f: 0x0100, 0x4510: 0x0100, 0x4511: 0x0100,
	0x4512: 0x0100, 0x4513: 0x0100, 0x4514: 0x0100, 0x4515: 0x0100, 0x4516: 0x0100, 0x4517: 0x0100,
	0x4518: 0x0100, 0x4519: 0x0100, 0x451a: 0x0100, 0x451b: 0x0100, 0x451c: 0x0100, 0x451d: 0x0100,
	0x451e: 0x0100, 0x4520: 0x0080, 0x4521: 0x0080, 0x4522: 0x0080, 0x4523: 0x0080,
	0x4524: 0x0080, 0x4525: 0x0080, 0x4526: 0x0080, 0x4527: 0x0080, 0x4528: 0x0080, 0x4529: 0x0080,
	0x452e: 0x0400, 0x452f: 0x0400,
	0x4530: 0x0100, 0x4531: 0x0100, 0x4532: 0x0100, 0x4533: 0x0100, 0x4534: 0x0100, 0x4535: 0x0100,
	0x4536: 0x0100, 0x4537: 0x0100, 0x4538: 0x0100, 0x4539: 0x0100, 0x453a: 0x0100, 0x453b: 0x0100,
	0x453c: 0x0100, 0x453d: 0x0100, 0x453e: 0x0100, 0x453f: 0x0100,
	// Block 0x115, offset 0x4540
	0x4540: 0x0100, 0x4541: 0x0100, 0x4542: 0x0100, 0x4543: 0x0100, 0x4544: 0x0100, 0x4545: 0x0100,
	0x4546: 0x0100, 0x4547: 0x0100, 0x4548: 0x0100, 0x4549: 0x0100, 0x454a: 0x0100, 0x454b: 0x0100,
	0x454c: 0x0100, 0x454d: 0x0100, 0x454e: 0x0100, 0x454f: 0x0100, 0x4550: 0x0100, 0x4551: 0x0100,
	0x4552: 0x0100, 0x4553: 0x0100, 0x4554: 0x0100, 0x4555: 0x0100, 0x4556: 0x0100, 0x4557: 0x0100,
	0x4558: 0x0100, 0x4559: 0x0100, 0x455a: 0x0100, 0x455b: 0x0100, 0x455c: 0x0100, 0x455d: 0x0100,
	0x455e: 0x0100, 0x455f: 0x0100, 0x4560: 0x0100, 0x4561: 0x0100, 0x4562: 0x0100, 0x4563: 0x0100,
	0x4564: 0x0100, 0x4565: 0x0100, 0x4566: 0x0100, 0x4567: 0x0100, 0x4568: 0x0100, 0x4569: 0x0100,
	0x456a: 0x0100, 0x456b: 0x0100, 0x456c: 0x0100, 0x456d: 0x0100, 0x456e: 0x0100, 0x456f: 0x0100,
	0x4570: 0x0100, 0x4571: 0x0100, 0x4572: 0x0100, 0x4573: 0x0100, 0x4574: 0x0100, 0x4575: 0x0100,
	0x4576: 0x0100, 0x4577: 0x0100, 0x4578: 0x0100, 0x4579: 0x0100, 0x457a: 0x0100, 0x457b: 0x0100,
	0x457c: 0x0100, 0x457d: 0x0100, 0x457e: 0x0100,
	// Block 0x116, offset 0x4580
	0x4580: 0x0080, 0x4581: 0x0080, 0x4582: 0x0080, 0x4583: 0x0080, 0x4584: 0x0080, 0x4585: 0x0080,
	0x4586: 0x0080, 0x4587: 0x0080, 0x4588: 0x0080, 0x4589: 0x0080,
	0x4590: 0x0100, 0x4591: 0x0100,
	0x4592: 0x0100, 0x4593: 0x0100, 0x4594: 0x0100, 0x4595: 0x0100, 0x4596: 0x0100, 0x4597: 0x0100,
	0x4598: 0x0100, 0x4599: 0x0100, 0x459a: 0x0100, 0x459b: 0x0100, 0x459c: 0x0100, 0x459d: 0x0100,
	0x459e: 0x0100, 0x459f: 0x0100, 0x45a0: 0x0100, 0x45a1: 0x0100, 0x45a2: 0x0100, 0x45a3: 0x0100,
	0x45a4: 0x0100, 0x45a5: 0x0100, 0x45a6: 0x0100, 0x45a7: 0x0100, 0x45a8: 0x0100, 0x45a9: 0x0100,
	0x45aa: 0x0100, 0x45ab: 0x0100, 0x45ac: 0x0100, 0x45ad: 0x0100,
	0x45b0: 0x0008, 0x45b1: 0x0008, 0x45b2: 0x0008, 0x45b3: 0x0008, 0x45b4: 0x0008, 0x45b5: 0x0400,
	// Block 0x117, offset 0x45c0
	0x45c0: 0x0100, 0x45c1: 0x0100, 0x45c2: 0x0100, 0x45c3: 0x0100, 0x45c4: 0x0100, 0x45c5: 0x0100,
	0x45c6: 0x0100, 0x45c7: 0x0100, 0x45c8: 0x0100, 0x45c9: 0x0100, 0x45ca: 0x0100, 0x45cb: 0x0100,
	0x45cc: 0x0100, 0x45cd: 0x0100, 0x45ce: 0x0100, 0x45cf: 0x0100, 0x45d0: 0x0100, 0x45d1: 0x0100,
	0x45d2: 0x0100, 0x45d3: 0x0100, 0x45d4: 0x0100, 0x45d5: 0x0100, 0x45d6: 0x0100, 0x45d7: 0x0100,
	0x45d8: 0x0100, 0x45d9: 0x0100, 0x45da: 0x0100, 0x45db: 0x0100, 0x45dc: 0x0100, 0x45dd: 0x0100,
	0x45de: 0x0100, 0x45df: 0x0100, 0x45e0: 0x0100, 0x45e1: 0x0100, 0x45e2: 0x0100, 0x45e3: 0x0100,
	0x45e4: 0x0100, 0x45e5: 0x0100, 0x45e6: 0x0100, 0x45e7: 0x0100, 0x45e8: 0x0100, 0x45e9: 0x0100,
	0x45ea: 0x0100, 0x45eb: 0x0100, 0x45ec: 0x0100, 0x45ed: 0x0100, 0x45ee: 0x0100, 0x45ef: 0x0100,
	0x45f0: 0x0008, 0x45f1: 0x0008, 0x45f2: 0x0008, 0x45f3: 0x0008, 0x45f4: 0x0008, 0x45f5: 0x0008,
	0x45f6: 0x0008, 0x45f7: 0x0400, 0x45f8: 0x0400,
	// Block 0x118, offset 0x4600
	0x4600: 0x0100, 0x4601: 0x0100, 0x4602: 0x0100, 0x4603: 0x0100, 0x4604: 0x0400,
	0x4610: 0x0080, 0x4611: 0x0080,
	0x4612: 0x0080, 0x4613: 0x0080, 0x4614: 0x0080, 0x4615: 0x0080, 0x4616: 0x0080, 0x4617: 0x0080,
	0x4618: 0x0080, 0x4619: 0x0080,
	0x4623: 0x0100,
	0x4624: 0x0100, 0x4625: 0x0100, 0x4626: 0x0100, 0x4627: 0x0100, 0x4628: 0x0100, 0x4629: 0x0100,
	0x462a: 0x0100, 0x462b: 0x0100, 0x462c: 0x0100, 0x462d: 0x0100, 0x462e: 0x0100, 0x462f: 0x0100,
	0x4630: 0x0100, 0x4631: 0x0100, 0x4632: 0x0100, 0x4633: 0x0100, 0x4634: 0x0100, 0x4635: 0x0100,
	0x4636: 0x0100, 0x4637: 0x0100,
	0x463d: 0x0100, 0x463e: 0x0100, 0x463f: 0x0100,
	// Block 0x119, offset 0x4640
	0x4640: 0x0100, 0x4641: 0x0100, 0x4642: 0x0100, 0x4643: 0x0100, 0x4644: 0x0100, 0x4645: 0x0100,
	0x4646: 0x0100, 0x4647: 0x0100, 0x4648: 0x0100, 0x4649: 0x0100, 0x464a: 0x0100, 0x464b: 0x0100,
	0x464c: 0x0100, 0x464d: 0x0100, 0x464e: 0x0100, 0x464f: 0x0100,
	// Block 0x11a, offset 0x4680
	0x4680: 0x2000, 0x4681: 0x2000, 0x4682: 0x2000, 0x4683: 0x2000, 0x4684: 0x2000, 0x4685: 0x2000,
	0x4686: 0x2000, 0x4687: 0x2000, 0x4688: 0x2000, 0x4689: 0x2000, 0x468a: 0x2000, 0x468b: 0x2000,
	0x468c: 0x2000, 0x468d: 0x2000, 0x468e: 0x2000, 0x468f: 0x2000, 0x4690: 0x2000, 0x4691: 0x2000,
	0x4692: 0x2000, 0x4693: 0x2000, 0x4694: 0x2000, 0x4695: 0x2000, 0x4696: 0x2000, 0x4697: 0x2000,
	0x4698: 0x2000, 0x4699: 0x2000, 0x469a: 0x2000, 0x469b: 0x2000, 0x469c: 0x2000, 0x469d: 0x2000,
	0x469e: 0x2000, 0x469f: 0x2000, 0x46a0: 0x0040, 0x46a1: 0x0040, 0x46a2: 0x0040, 0x46a3: 0x0040,
	0x46a4: 0x0040, 0x46a5: 0x0040, 0x46a6: 0x0040, 0x46a7: 0x0040, 0x46a8: 0x0040, 0x46a9: 0x0040,
	0x46aa: 0x0040, 0x46ab: 0x0040, 0x46ac: 0x0040, 0x46ad: 0x0040, 0x46ae: 0x0040, 0x46af: 0x0040,
	0x46b0: 0x0040, 0x46b1: 0x0040, 0x46b2: 0x0040, 0x46b3: 0x0040, 0x46b4: 0x0040, 0x46b5: 0x0040,
	0x46b6: 0x0040, 0x46b7: 0x0040, 0x46b8: 0x0040, 0x46b9: 0x0040, 0x46ba: 0x0040, 0x46bb: 0x0040,
	0x46bc: 0x0040, 0x46bd: 0x0040, 0x46be: 0x0040, 0x46bf: 0x0040,
	// Block 0x11b, offset 0x46c0
	0x46d8: 0x0400,
	// Block 0x11c, offset 0x4700
	0x4700: 0x0100, 0x4701: 0x0100, 0x4702: 0x0100, 0x4703: 0x0100, 0x4704: 0x0100, 0x4705: 0x0100,
	0x4706: 0x0100, 0x4707: 0x0100, 0x4708: 0x0100, 0x4709: 0x0100, 0x470a: 0x0100,
	0x470f: 0x0008, 0x4710: 0x0100, 0x4711: 0x0008,
	0x4712: 0x0008, 0x4713: 0x0008, 0x4714: 0x0008, 0x4715: 0x0008, 0x4716: 0x0008, 0x4717: 0x0008,
	0x4718: 0x0008, 0x4719: 0x0008, 0x471a: 0x0008, 0x471b: 0x0008, 0x471c: 0x0008, 0x471d: 0x0008,
	0x471e: 0x0008, 0x471f: 0x0008, 0x4720: 0x0008, 0x4721: 0x0008, 0x4722: 0x0008, 0x4723: 0x0008,
	0x4724: 0x0008, 0x4725: 0x0008, 0x4726: 0x0008, 0x4727: 0x0008, 0x4728: 0x0008, 0x4729: 0x0008,
	0x472a: 0x0008, 0x472b: 0x0008, 0x472c: 0x0008, 0x472d: 0x0008, 0x472e: 0x0008, 0x472f: 0x0008,
	0x4730: 0x0008, 0x4731: 0x0008, 0x4732: 0x0008, 0x4733: 0x0008, 0x4734: 0x0008, 0x4735: 0x0008,
	0x4736: 0x0008, 0x4737: 0x0008, 0x4738: 0x0008, 0x4739: 0x0008, 0x473a: 0x0008, 0x473b: 0x0008,
	0x473c: 0x0008, 0x473d: 0x0008, 0x473e: 0x0008, 0x473f: 0x0008,
	// Block 0x11d, offset 0x4740
	0x4740: 0x0008, 0x4741: 0x0008, 0x4742: 0x0008, 0x4743: 0x0008, 0x4744: 0x0008, 0x4745: 0x0008,
	0x4746: 0x0008, 0x4747: 0x0008,
	0x474f: 0x0008, 0x4750: 0x0008, 0x4751: 0x0008,
	0x4752: 0x0008, 0x4753: 0x0100, 0x4754: 0x0100, 0x4755: 0x0100, 0x4756: 0x0100, 0x4757: 0x0100,
	0x4758: 0x0100, 0x4759: 0x0100, 0x475a: 0x0100, 0x475b: 0x0100, 0x475c: 0x0100, 0x475d: 0x0100,
	0x475e: 0x0100, 0x475f: 0x0100,
	// Block 0x11e, offset 0x4780
	0x47a0: 0x0100, 0x47a1: 0x0100, 0x47a3: 0x0100,
	0x47a4: 0x0008,
	0x47b0: 0x0008, 0x47b1: 0x0008,
	// Block 0x11f, offset 0x47c0
	0x47c0: 0x0100, 0x47c1: 0x0100, 0x47c2: 0x0100, 0x47c3: 0x0100, 0x47c4: 0x0100, 0x47c5: 0x0100,
	0x47c6: 0x0100, 0x47c7: 0x0100, 0x47c8: 0x0100, 0x47c9: 0x0100, 0x47ca: 0x0100, 0x47cb: 0x0100,
	0x47cc: 0x0100, 0x47cd: 0x0100, 0x47ce: 0x0100, 0x47cf: 0x0100, 0x47d0: 0x0100, 0x47d1: 0x0100,
	0x47d2: 0x0100, 0x47d3: 0x0100, 0x47d4: 0x0100, 0x47d5: 0x0100, 0x47d6: 0x0100, 0x47d7: 0x0100,
	0x47d8: 0x0100, 0x47d9: 0x0100, 0x47da: 0x0100, 0x47db: 0x0100, 0x47dc: 0x0100, 0x47dd: 0x0100,
	0x47de: 0x0100, 0x47df: 0x0100, 0x47e0: 0x0100, 0x47e1: 0x0100, 0x47e2: 0x0100, 0x47e3: 0x0100,
	0x47e4: 0x0100, 0x47e5: 0x0100, 0x47e6: 0x0100, 0x47e7: 0x0100, 0x47e8: 0x0100, 0x47e9: 0x0100,
	0x47ea: 0x0100, 0x47eb: 0x0100, 0x47ec: 0x0100, 0x47ed: 0x0100, 0x47ee: 0x0100, 0x47ef: 0x0100,
	0x47f0: 0x0100, 0x47f1: 0x0100, 0x47f2: 0x0100, 0x47f3: 0x0100, 0x47f4: 0x0100, 0x47f5: 0x0100,
	0x47f6: 0x0100, 0x47f7: 0x0100,
	// Block 0x120, offset 0x4800
	0x4800: 0x0100, 0x4801: 0x0100, 0x4802: 0x0100, 0x4803: 0x0100, 0x4804: 0x0100, 0x4805: 0x0100,
	0x4806: 0x0100, 0x4807: 0x0100, 0x4808: 0x0100, 0x4809: 0x0100, 0x480a: 0x0100, 0x480b: 0x0100,
	0x480c: 0x0100, 0x480d: 0x0100, 0x480e: 0x0100, 0x480f: 0x0100, 0x4810: 0x0100, 0x4811: 0x0100,
	0x4812: 0x0100, 0x4813: 0x0100, 0x4814: 0x0100, 0x4815: 0x0100,
	// Block 0x121, offset 0x4840
	0x4870: 0x0100, 0x4871: 0x0100, 0x4872: 0x0100, 0x4873: 0x0100, 0x4875: 0x0100,
	0x4876: 0x0100, 0x4877: 0x0100, 0x4878: 0x0100, 0x4879: 0x0100, 0x487a: 0x0100, 0x487b: 0x0100,
	0x487d: 0x0100, 0x487e: 0x0100,
	// Block 0x122, offset 0x4880
	0x4880: 0x0100, 0x4881: 0x0100, 0x4882: 0x0100, 0x4883: 0x0100, 0x4884: 0x0100, 0x4885: 0x0100,
	0x4886: 0x0100, 0x4887: 0x0100, 0x4888: 0x0100, 0x4889: 0x0100, 0x488a: 0x0100, 0x488b: 0x0100,
	0x488c: 0x0100, 0x488d: 0x0100, 0x488e: 0x0100, 0x488f: 0x0100, 0x4890: 0x0100, 0x4891: 0x0100,
	0x4892: 0x0100, 0x4893: 0x0100, 0x4894: 0x0100, 0x4895: 0x0100, 0x4896: 0x0100, 0x4897: 0x0100,
	0x4898: 0x0100, 0x4899: 0x0100, 0x489a: 0x0100, 0x489b: 0x0100, 0x489c: 0x0100, 0x489d: 0x0100,
	0x489e: 0x0100, 0x489f: 0x0100, 0x48a0: 0x0100, 0x48a1: 0x0100, 0x48a2: 0x0100,
	0x48b2: 0x0100,
	// Block 0x123, offset 0x48c0
	0x48d0: 0x0100, 0x48d1: 0x0100,
	0x48d2: 0x0100, 0x48d5: 0x0100,
	0x48e4: 0x0100, 0x48e5: 0x0100, 0x48e6: 0x0100, 0x48e7: 0x0100,
	0x48f0: 0x0100, 0x48f1: 0x0100, 0x48f2: 0x0100, 0x48f3: 0x0100, 0x48f4: 0x0100, 0x48f5: 0x0100,
	0x48f6: 0x0100, 0x48f7: 0x0100, 0x48f8: 0x0100, 0x48f9: 0x0100, 0x48fa: 0x0100, 0x48fb: 0x0100,
	0x48fc: 0x0100, 0x48fd: 0x0100, 0x48fe: 0x0100, 0x48ff: 0x0100,
	// Block 0x124, offset 0x4900
	0x4900: 0x0100, 0x4901: 0x0100, 0x4902: 0x0100, 0x4903: 0x0100, 0x4904: 0x0100, 0x4905: 0x0100,
	0x4906: 0x0100, 0x4907: 0x0100, 0x4908: 0x0100, 0x4909: 0x0100, 0x490a: 0x0100, 0x490b: 0x0100,
	0x490c: 0x0100, 0x490d: 0x0100, 0x490e: 0x0100, 0x490f: 0x0100, 0x4910: 0x0100, 0x4911: 0x0100,
	0x4912: 0x0100, 0x4913: 0x0100, 0x4914: 0x0100, 0x4915: 0x0100, 0x4916: 0x0100, 0x4917: 0x0100,
	0x4918: 0x0100, 0x4919: 0x0100, 0x491a: 0x0100, 0x491b: 0x0100, 0x491c: 0x0100, 0x491d: 0x0100,
	0x491e: 0x0100, 0x491f: 0x0100, 0x4920: 0x0100, 0x4921: 0x0100, 0x4922: 0x0100, 0x4923: 0x0100,
	0x4924: 0x0100, 0x4925: 0x0100, 0x4926: 0x0100, 0x4927: 0x0100, 0x4928: 0x0100, 0x4929: 0x0100,
	0x492a: 0x0100, 0x492b: 0x0100, 0x492c: 0x0100, 0x492d: 0x0100, 0x492e: 0x0100, 0x492f: 0x0100,
	0x4930: 0x0100, 0x4931: 0x0100, 0x4932: 0x0100, 0x4933: 0x0100, 0x4934: 0x0100, 0x4935: 0x0100,
	0x4936: 0x0100, 0x4937: 0x0100, 0x4938: 0x0100, 0x4939: 0x0100, 0x493a: 0x0100, 0x493b: 0x0100,
	// Block 0x125, offset 0x4940
	0x4940: 0x0100, 0x4941: 0x0100, 0x4942: 0x0100, 0x4943: 0x0100, 0x4944: 0x0100, 0x4945: 0x0100,
	0x4946: 0x0100, 0x4947: 0x0100, 0x4948: 0x0100, 0x4949: 0x0100, 0x494a: 0x0100, 0x494b: 0x0100,
	0x494c: 0x0100, 0x494d: 0x0100, 0x494e: 0x0100, 0x494f: 0x0100, 0x4950: 0x0100, 0x4951: 0x0100,
	0x4952: 0x0100, 0x4953: 0x0100, 0x4954: 0x0100, 0x4955: 0x0100, 0x4956: 0x0100, 0x4957: 0x0100,
	0x4958: 0x0100, 0x4959: 0x0100, 0x495a: 0x0100, 0x495b: 0x0100, 0x495c: 0x0100, 0x495d: 0x0100,
	0x495e: 0x0100, 0x495f: 0x0100, 0x4960: 0x0100, 0x4961: 0x0100, 0x4962: 0x0100, 0x4963: 0x0100,
	0x4964: 0x0100, 0x4965: 0x0100, 0x4966: 0x0100, 0x4967: 0x0100, 0x4968: 0x0100, 0x4969: 0x0100,
	0x496a: 0x0100,
	0x4970: 0x0100, 0x4971: 0x0100, 0x4972: 0x0100, 0x4973: 0x0100, 0x4974: 0x0100, 0x4975: 0x0100,
	0x4976: 0x0100, 0x4977: 0x0100, 0x4978: 0x0100, 0x4979: 0x0100, 0x497a: 0x0100, 0x497b: 0x0100,
	0x497c: 0x0100,
	// Block 0x126, offset 0x4980
	0x4980: 0x0100, 0x4981: 0x0100, 0x4982: 0x0100, 0x4983: 0x0100, 0x4984: 0x0100, 0x4985: 0x0100,
	0x4986: 0x0100, 0x4987: 0x0100, 0x4988: 0x0100,
	0x4990: 0x0100, 0x4991: 0x0100,
	0x4992: 0x0100, 0x4993: 0x0100, 0x4994: 0x0100, 0x4995: 0x0100, 0x4996: 0x0100, 0x4997: 0x0100,
	0x4998: 0x0100, 0x4999: 0x0100, 0x499d: 0x0008,
	0x499e: 0x0008, 0x499f: 0x0400, 0x49a0: 0x0010, 0x49a1: 0x0010, 0x49a2: 0x0010, 0x49a3: 0x0010,
	// Block 0x127, offset 0x49c0
	0x49c0: 0x0008, 0x49c1: 0x0008, 0x49c2: 0x0008, 0x49c3: 0x0008, 0x49c4: 0x0008, 0x49c5: 0x0008,
	0x49c6: 0x0008, 0x49c7: 0x0008, 0x49c8: 0x0008, 0x49c9: 0x0008, 0x49ca: 0x0008, 0x49cb: 0x0008,
	0x49cc: 0x0008, 0x49cd: 0x0008, 0x49ce: 0x0008, 0x49cf: 0x0008, 0x49d0: 0x0008, 0x49d1: 0x0008,
	0x49d2: 0x0008, 0x49d3: 0x0008, 0x49d4: 0x0008, 0x49d5: 0x0008, 0x49d6: 0x0008, 0x49d7: 0x0008,
	0x49d8: 0x0008, 0x49d9: 0x0008, 0x49da: 0x0008, 0x49db: 0x0008, 0x49dc: 0x0008, 0x49dd: 0x0008,
	0x49de: 0x0008, 0x49df: 0x0008, 0x49e0: 0x0008, 0x49e1: 0x0008, 0x49e2: 0x0008, 0x49e3: 0x0008,
	0x49e4: 0x0008, 0x49e5: 0x0008, 0x49e6: 0x0008, 0x49e7: 0x0008, 0x49e8: 0x0008, 0x49e9: 0x0008,
	0x49ea: 0x0008, 0x49eb: 0x0008, 0x49ec: 0x0008, 0x49ed: 0x0008,
	0x49f0: 0x0008, 0x49f1: 0x0008, 0x49f2: 0x0008, 0x49f3: 0x0008, 0x49f4: 0x0008, 0x49f5: 0x0008,
	0x49f6: 0x0008, 0x49f7: 0x0008, 0x49f8: 0x0008, 0x49f9: 0x0008, 0x49fa: 0x0008, 0x49fb: 0x0008,
	0x49fc: 0x0008, 0x49fd: 0x0008, 0x49fe: 0x0008, 0x49ff: 0x0008,
	// Block 0x128, offset 0x4a00
	0x4a00: 0x0008, 0x4a01: 0x0008, 0x4a02: 0x0008, 0x4a03: 0x0008, 0x4a04: 0x0008, 0x4a05: 0x0008,
	0x4a06: 0x0008,
	// Block 0x129, offset 0x4a40
	0x4a65: 0x0008, 0x4a66: 0x0008, 0x4a67: 0x0008, 0x4a68: 0x0008, 0x4a69: 0x0008,
	0x4a6d: 0x0008, 0x4a6e: 0x0008, 0x4a6f: 0x0008,
	0x4a70: 0x0008, 0x4a71: 0x0008, 0x4a72: 0x0008, 0x4a73: 0x0010, 0x4a74: 0x0010, 0x4a75: 0x0010,
	0x4a76: 0x0010, 0x4a77: 0x0010, 0x4a78: 0x0010, 0x4a79: 0x0010, 0x4a7a: 0x0010, 0x4a7b: 0x0008,
	0x4a7c: 0x0008, 0x4a7d: 0x0008, 0x4a7e: 0x0008, 0x4a7f: 0x0008,
	// Block 0x12a, offset 0x4a80
	0x4a80: 0x0008, 0x4a81: 0x0008, 0x4a82: 0x0008, 0x4a85: 0x0008,
	0x4a86: 0x0008, 0x4a87: 0x0008, 0x4a88: 0x0008, 0x4a89: 0x0008, 0x4a8a: 0x0008, 0x4a8b: 0x0008,
	0x4aaa: 0x0008, 0x4aab: 0x0008, 0x4aac: 0x0008, 0x4aad: 0x0008,
	// Block 0x12b, offset 0x4ac0
	0x4ac2: 0x0008, 0x4ac3: 0x0008, 0x4ac4: 0x0008,
	// Block 0x12c, offset 0x4b00
	0x4b00: 0x2000, 0x4b01: 0x2000, 0x4b02: 0x2000, 0x4b03: 0x2000, 0x4b04: 0x2000, 0x4b05: 0x2000,
	0x4b06: 0x2000, 0x4b07: 0x2000, 0x4b08: 0x2000, 0x4b09: 0x2000, 0x4b0a: 0x2000, 0x4b0b: 0x2000,
	0x4b0c: 0x2000, 0x4b0d: 0x2000, 0x4b0e: 0x2000, 0x4b0f: 0x2000, 0x4b10: 0x2000, 0x4b11: 0x2000,
	0x4b12: 0x2000, 0x4b13: 0x2000, 0x4b14: 0x2000, 0x4b15: 0x2000, 0x4b16: 0x2000, 0x4b17: 0x2000,
	0x4b18: 0x2000, 0x4b19: 0x2000, 0x4b1a: 0x0040, 0x4b1b: 0x0040, 0x4b1c: 0x0040, 0x4b1d: 0x0040,
	0x4b1e: 0x0040, 0x4b1f: 0x0040, 0x4b20: 0x0040, 0x4b21: 0x0040, 0x4b22: 0x0040, 0x4b23: 0x0040,
	0x4b24: 0x0040, 0x4b25: 0x0040, 0x4b26: 0x0040, 0x4b27: 0x0040, 0x4b28: 0x0040, 0x4b29: 0x0040,
	0x4b2a: 0x0040, 0x4b2b: 0x0040, 0x4b2c: 0x0040, 0x4b2d: 0x0040, 0x4b2e: 0x0040, 0x4b2f: 0x0040,
	0x4b30: 0x0040, 0x4b31: 0x0040, 0x4b32: 0x0040, 0x4b33: 0x0040, 0x4b34: 0x2000, 0x4b35: 0x2000,
	0x4b36: 0x2000, 0x4b37: 0x2000, 0x4b38: 0x2000, 0x4b39: 0x2000, 0x4b3a: 0x2000, 0x4b3b: 0x2000,
	0x4b3c: 0x2000, 0x4b3d: 0x2000, 0x4b3e: 0x2000, 0x4b3f: 0x2000,
	// Block 0x12d, offset 0x4b40
	0x4b40: 0x2000, 0x4b41: 0x2000, 0x4b42: 0x2000, 0x4b43: 0x2000, 0x4b44: 0x2000, 0x4b45: 0x2000,
	0x4b46: 0x2000, 0x4b47: 0x2000, 0x4b48: 0x2000, 0x4b49: 0x2000, 0x4b4a: 0x2000, 0x4b4b: 0x2000,
	0x4b4c: 0x2000, 0x4b4d: 0x2000, 0x4b4e: 0x0040, 0x4b4f: 0x0040, 0x4b50: 0x0040, 0x4b51: 0x0040,
	0x4b52: 0x0040, 0x4b53: 0x0040, 0x4b54: 0x0040, 0x4b56: 0x0040, 0x4b57: 0x0040,
	0x4b58: 0x0040, 0x4b59: 0x0040, 0x4b5a: 0x0040, 0x4b5b: 0x0040, 0x4b5c: 0x0040, 0x4b5d: 0x0040,
	0x4b5e: 0x0040, 0x4b5f: 0x0040, 0x4b60: 0x0040, 0x4b61: 0x0040, 0x4b62: 0x0040, 0x4b63: 0x0040,
	0x4b64: 0x0040, 0x4b65: 0x0040, 0x4b66: 0x0040, 0x4b67: 0x0040, 0x4b68: 0x2000, 0x4b69: 0x2000,
	0x4b6a: 0x2000, 0x4b6b: 0x2000, 0x4b6c: 0x2000, 0x4b6d: 0x2000, 0x4b6e: 0x2000, 0x4b6f: 0x2000,
	0x4b70: 0x2000, 0x4b71: 0x2000, 0x4b72: 0x2000, 0x4b73: 0x2000, 0x4b74: 0x2000, 0x4b75: 0x2000,
	0x4b76: 0x2000, 0x4b77: 0x2000, 0x4b78: 0x2000, 0x4b79: 0x2000, 0x4b7a: 0x2000, 0x4b7b: 0x2000,
	0x4b7c: 0x2000, 0x4b7d: 0x2000, 0x4b7e: 0x2000, 0x4b7f: 0x2000,
	// Block 0x12e, offset 0x4b80
	0x4b80: 0x2000, 0x4b81: 0x2000, 0x4b82: 0x0040, 0x4b83: 0x0040, 0x4b84: 0x0040, 0x4b85: 0x0040,
	0x4b86: 0x0040, 0x4b87: 0x0040, 0x4b88: 0x0040, 0x4b89: 0x0040, 0x4b8a: 0x0040, 0x4b8b: 0x0040,
	0x4b8c: 0x0040, 0x4b8d: 0x0040, 0x4b8e: 0x0040, 0x4b8f: 0x0040, 0x4b90: 0x0040, 0x4b91: 0x0040,
	0x4b92: 0x0040, 0x4b93: 0x0040, 0x4b94: 0x0040, 0x4b95: 0x0040, 0x4b96: 0x0040, 0x4b97: 0x0040,
	0x4b98: 0x0040, 0x4b99: 0x0040, 0x4b9a: 0x0040, 0x4b9b: 0x0040, 0x4b9c: 0x2000,
	0x4b9e: 0x2000, 0x4b9f: 0x2000, 0x4ba2: 0x2000,
	0x4ba5: 0x2000, 0x4ba6: 0x2000, 0x4ba9: 0x2000,
	0x4baa: 0x2000, 0x4bab: 0x2000, 0x4bac: 0x2000, 0x4bae: 0x2000, 0x4baf: 0x2000,
	0x4bb0: 0x2000, 0x4bb1: 0x2000, 0x4bb2: 0x2000, 0x4bb3: 0x2000, 0x4bb4: 0x2000, 0x4bb5: 0x2000,
	0x4bb6: 0x0040, 0x4bb7: 0x0040, 0x4bb8: 0x0040, 0x4bb9: 0x0040, 0x4bbb: 0x0040,
	0x4bbd: 0x0040, 0x4bbe: 0x0040, 0x4bbf: 0x0040,
	// Block 0x12f, offset 0x4bc0
	0x4bc0: 0x0040, 0x4bc1: 0x0040, 0x4bc2: 0x0040, 0x4bc3: 0x0040, 0x4bc5: 0x0040,
	0x4bc6: 0x0040, 0x4bc7: 0x0040, 0x4bc8: 0x0040, 0x4bc9: 0x0040, 0x4bca: 0x0040, 0x4bcb: 0x0040,
	0x4bcc: 0x0040, 0x4bcd: 0x0040, 0x4bce: 0x0040, 0x4bcf: 0x0040, 0x4bd0: 0x2000, 0x4bd1: 0x2000,
	0x4bd2: 0x2000, 0x4bd3: 0x2000, 0x4bd4: 0x2000, 0x4bd5: 0x2000, 0x4bd6: 0x2000, 0x4bd7: 0x2000,
	0x4bd8: 0x2000, 0x4bd9: 0x2000, 0x4bda: 0x2000, 0x4bdb: 0x2000, 0x4bdc: 0x2000, 0x4bdd: 0x2000,
	0x4bde: 0x2000, 0x4bdf: 0x2000, 0x4be0: 0x2000, 0x4be1: 0x2000, 0x4be2: 0x2000, 0x4be3: 0x2000,
	0x4be4: 0x2000, 0x4be5: 0x2000, 0x4be6: 0x2000, 0x4be7: 0x2000, 0x4be8: 0x2000, 0x4be9: 0x2000,
	0x4bea: 0x0040, 0x4beb: 0x0040, 0x4bec: 0x0040, 0x4bed: 0x0040, 0x4bee: 0x0040, 0x4bef: 0x0040,
	0x4bf0: 0x0040, 0x4bf1: 0x0040, 0x4bf2: 0x0040, 0x4bf3: 0x0040, 0x4bf4: 0x0040, 0x4bf5: 0x0040,
	0x4bf6: 0x0040, 0x4bf7: 0x0040, 0x4bf8: 0x0040, 0x4bf9: 0x0040, 0x4bfa: 0x0040, 0x4bfb: 0x0040,
	0x4bfc: 0x0040, 0x4bfd: 0x0040, 0x4bfe: 0x0040, 0x4bff: 0x0040,
	// Block 0x130, offset 0x4c00
	0x4c00: 0x0040, 0x4c01: 0x0040, 0x4c02: 0x0040, 0x4c03: 0x0040, 0x4c04: 0x2000, 0x4c05: 0x2000,
	0x4c07: 0x2000, 0x4c08: 0x2000, 0x4c09: 0x2000, 0x4c0a: 0x2000,
	0x4c0d: 0x2000, 0x4c0e: 0x2000, 0x4c0f: 0x2000, 0x4c10: 0x2000, 0x4c11: 0x2000,
	0x4c12: 0x2000, 0x4c13: 0x2000, 0x4c14: 0x2000, 0x4c16: 0x2000, 0x4c17: 0x2000,
	0x4c18: 0x2000, 0x4c19: 0x2000, 0x4c1a: 0x2000, 0x4c1b: 0x2000, 0x4c1c: 0x2000,
	0x4c1e: 0x0040, 0x4c1f: 0x0040, 0x4c20: 0x0040, 0x4c21: 0x0040, 0x4c22: 0x0040, 0x4c23: 0x0040,
	0x4c24: 0x0040, 0x4c25: 0x0040, 0x4c26: 0x0040, 0x4c27: 0x0040, 0x4c28: 0x0040, 0x4c29: 0x0040,
	0x4c2a: 0x0040, 0x4c2b: 0x0040, 0x4c2c: 0x0040, 0x4c2d: 0x0040, 0x4c2e: 0x0040, 0x4c2f: 0x0040,
	0x4c30: 0x0040, 0x4c31: 0x0040, 0x4c32: 0x0040, 0x4c33: 0x0040, 0x4c34: 0x0040, 0x4c35: 0x0040,
	0x4c36: 0x0040, 0x4c37: 0x0040, 0x4c38: 0x2000, 0x4c39: 0x2000, 0x4c3b: 0x2000,
	0x4c3c: 0x2000, 0x4c3d: 0x2000, 0x4c3e: 0x2000,
	// Block 0x131, offset 0x4c40
	0x4c40: 0x2000, 0x4c41: 0x2000, 0x4c42: 0x2000, 0x4c43: 0x2000, 0x4c44: 0x2000,
	0x4c46: 0x2000, 0x4c4a: 0x2000, 0x4c4b: 0x2000,
	0x4c4c: 0x2000, 0x4c4d: 0x2000, 0x4c4e: 0x2000, 0x4c4f: 0x2000, 0x4c50: 0x2000,
	0x4c52: 0x0040, 0x4c53: 0x0040, 0x4c54: 0x0040, 0x4c55: 0x0040, 0x4c56: 0x0040, 0x4c57: 0x0040,
	0x4c58: 0x0040, 0x4c59: 0x0040, 0x4c5a: 0x0040, 0x4c5b: 0x0040, 0x4c5c: 0x0040, 0x4c5d: 0x0040,
	0x4c5e: 0x0040, 0x4c5f: 0x0040, 0x4c60: 0x0040, 0x4c61: 0x0040, 0x4c62: 0x0040, 0x4c63: 0x0040,
	0x4c64: 0x0040, 0x4c65: 0x0040, 0x4c66: 0x0040, 0x4c67: 0x0040, 0x4c68: 0x0040, 0x4c69: 0x0040,
	0x4c6a: 0x0040, 0x4c6b: 0x0040, 0x4c6c: 0x2000, 0x4c6d: 0x2000, 0x4c6e: 0x2000, 0x4c6f: 0x2000,
	0x4c70: 0x2000, 0x4c71: 0x2000, 0x4c72: 0x2000, 0x4c73: 0x2000, 0x4c74: 0x2000, 0x4c75: 0x2000,
	0x4c76: 0x2000, 0x4c77: 0x2000, 0x4c78: 0x2000, 0x4c79: 0x2000, 0x4c7a: 0x2000, 0x4c7b: 0x2000,
	0x4c7c: 0x2000, 0x4c7d: 0x2000, 0x4c7e: 0x2000, 0x4c7f: 0x2000,
	// Block 0x132, offset 0x4c80
	0x4c80: 0x2000, 0x4c81: 0x2000, 0x4c82: 0x2000, 0x4c83: 0x2000, 0x4c84: 0x2000, 0x4c85: 0x2000,
	0x4c86: 0x0040, 0x4c87: 0x0040, 0x4c88: 0x0040, 0x4c89: 0x0040, 0x4c8a: 0x0040, 0x4c8b: 0x0040,
	0x4c8c: 0x0040, 0x4c8d: 0x0040, 0x4c8e: 0x0040, 0x4c8f: 0x0040, 0x4c90: 0x0040, 0x4c91: 0x0040,
	0x4c92: 0x0040, 0x4c93: 0x0040, 0x4c94: 0x0040, 0x4c95: 0x0040, 0x4c96: 0x0040, 0x4c97: 0x0040,
	0x4c98: 0x0040, 0x4c99: 0x0040, 0x4c9a: 0x0040, 0x4c9b: 0x0040, 0x4c9c: 0x0040, 0x4c9d: 0x0040,
	0x4c9e: 0x0040, 0x4c9f: 0x0040, 0x4ca0: 0x2000, 0x4ca1: 0x2000, 0x4ca2: 0x2000, 0x4ca3: 0x2000,
	0x4ca4: 0x2000, 0x4ca5: 0x2000, 0x4ca6: 0x2000, 0x4ca7: 0x2000, 0x4ca8: 0x2000, 0x4ca9: 0x2000,
	0x4caa: 0x2000, 0x4cab: 0x2000, 0x4cac: 0x2000, 0x4cad: 0x2000, 0x4cae: 0x2000, 0x4caf: 0x2000,
	0x4cb0: 0x2000, 0x4cb1: 0x2000, 0x4cb2: 0x2000, 0x4cb3: 0x2000, 0x4cb4: 0x2000, 0x4cb5: 0x2000,
	0x4cb6: 0x2000, 0x4cb7: 0x2000, 0x4cb8: 0x2000, 0x4cb9: 0x2000, 0x4cba: 0x0040, 0x4cbb: 0x0040,
	0x4cbc: 0x0040, 0x4cbd: 0x0040, 0x4cbe: 0x0040, 0x4cbf: 0x0040,
	// Block 0x133, offset 0x4cc0
	0x4cc0: 0x0040, 0x4cc1: 0x0040, 0x4cc2: 0x0040, 0x4cc3: 0x0040, 0x4cc4: 0x0040, 0x4cc5: 0x0040,
	0x4cc6: 0x0040, 0x4cc7: 0x0040, 0x4cc8: 0x0040, 0x4cc9: 0x0040, 0x4cca: 0x0040, 0x4ccb: 0x0040,
	0x4ccc: 0x0040, 0x4ccd: 0x0040, 0x4cce: 0x0040, 0x4ccf: 0x0040, 0x4cd0: 0x0040, 0x4cd1: 0x0040,
	0x4cd2: 0x0040, 0x4cd3: 0x0040, 0x4cd4: 0x2000, 0x4cd5: 0x2000, 0x4cd6: 0x2000, 0x4cd7: 0x2000,
	0x4cd8: 0x2000, 0x4cd9: 0x2000, 0x4cda: 0x2000, 0x4cdb: 0x2000, 0x4cdc: 0x2000, 0x4cdd: 0x2000,
	0x4cde: 0x2000, 0x4cdf: 0x2000, 0x4ce0: 0x2000, 0x4ce1: 0x2000, 0x4ce2: 0x2000, 0x4ce3: 0x2000,
	0x4ce4: 0x2000, 0x4ce5: 0x2000, 0x4ce6: 0x2000, 0x4ce7: 0x2000, 0x4ce8: 0x2000, 0x4ce9: 0x2000,
	0x4cea: 0x2000, 0x4ceb: 0x2000, 0x4cec: 0x2000, 0x4ced: 0x2000, 0x4cee: 0x0040, 0x4cef: 0x0040,
	0x4cf0: 0x0040, 0x4cf1: 0x0040, 0x4cf2: 0x0040, 0x4cf3: 0x0040, 0x4cf4: 0x0040, 0x4cf5: 0x0040,
	0x4cf6: 0x0040, 0x4cf7: 0x0040, 0x4cf8: 0x0040, 0x4cf9: 0x0040, 0x4cfa: 0x0040, 0x4cfb: 0x0040,
	0x4cfc: 0x0040, 0x4cfd: 0x0040, 0x4cfe: 0x0040, 0x4cff: 0x0040,
	// Block 0x134, offset 0x4d00
	0x4d00: 0x0040, 0x4d01: 0x0040, 0x4d02: 0x0040, 0x4d03: 0x0040, 0x4d04: 0x0040, 0x4d05: 0x0040,
	0x4d06: 0x0040, 0x4d07: 0x0040, 0x4d08: 0x2000, 0x4d09: 0x2000, 0x4d0a: 0x2000, 0x4d0b: 0x2000,
	0x4d0c: 0x2000, 0x4d0d: 0x2000, 0x4d0e: 0x2000, 0x4d0f: 0x2000, 0x4d10: 0x2000, 0x4d11: 0x2000,
	0x4d12: 0x2000, 0x4d13: 0x2000, 0x4d14: 0x2000, 0x4d15: 0x2000, 0x4d16: 0x2000, 0x4d17: 0x2000,
	0x4d18: 0x2000, 0x4d19: 0x2000, 0x4d1a: 0x2000, 0x4d1b: 0x2000, 0x4d1c: 0x2000, 0x4d1d: 0x2000,
	0x4d1e: 0x2000, 0x4d1f: 0x2000, 0x4d20: 0x2000, 0x4d21: 0x2000, 0x4d22: 0x0040, 0x4d23: 0x0040,
	0x4d24: 0x0040, 0x4d25: 0x0040, 0x4d26: 0x0040, 0x4d27: 0x0040, 0x4d28: 0x0040, 0x4d29: 0x0040,
	0x4d2a: 0x0040, 0x4d2b: 0x0040, 0x4d2c: 0x0040, 0x4d2d: 0x0040, 0x4d2e: 0x0040, 0x4d2f: 0x0040,
	0x4d30: 0x0040, 0x4d31: 0x0040, 0x4d32: 0x0040, 0x4d33: 0x0040, 0x4d34: 0x0040, 0x4d35: 0x0040,
	0x4d36: 0x0040, 0x4d37: 0x0040, 0x4d38: 0x0040, 0x4d39: 0x0040, 0x4d3a: 0x0040, 0x4d3b: 0x0040,
	0x4d3c: 0x2000, 0x4d3d: 0x2000, 0x4d3e: 0x2000, 0x4d3f: 0x2000,
	// Block 0x135, offset 0x4d40
	0x4d40: 0x2000, 0x4d41: 0x2000, 0x4d42: 0x2000, 0x4d43: 0x2000, 0x4d44: 0x2000, 0x4d45: 0x2000,
	0x4d46: 0x2000, 0x4d47: 0x2000, 0x4d48: 0x2000, 0x4d49: 0x2000, 0x4d4a: 0x2000, 0x4d4b: 0x2000,
	0x4d4c: 0x2000, 0x4d4d: 0x2000, 0x4d4e: 0x2000, 0x4d4f: 0x2000, 0x4d50: 0x2000, 0x4d51: 0x2000,
	0x4d52: 0x2000, 0x4d53: 0x2000, 0x4d54: 0x2000, 0x4d55: 0x2000, 0x4d56: 0x0040, 0x4d57: 0x0040,
	0x4d58: 0x0040, 0x4d59: 0x0040, 0x4d5a: 0x0040, 0x4d5b: 0x0040, 0x4d5c: 0x0040, 0x4d5d: 0x0040,
	0x4d5e: 0x0040, 0x4d5f: 0x0040, 0x4d60: 0x0040, 0x4d61: 0x0040, 0x4d62: 0x0040, 0x4d63: 0x0040,
	0x4d64: 0x0040, 0x4d65: 0x0040, 0x4d66: 0x0040, 0x4d67: 0x0040, 0x4d68: 0x0040, 0x4d69: 0x0040,
	0x4d6a: 0x0040, 0x4d6b: 0x0040, 0x4d6c: 0x0040, 0x4d6d: 0x0040, 0x4d6e: 0x0040, 0x4d6f: 0x0040,
	0x4d70: 0x2000, 0x4d71: 0x2000, 0x4d72: 0x2000, 0x4d73: 0x2000, 0x4d74: 0x2000, 0x4d75: 0x2000,
	0x4d76: 0x2000, 0x4d77: 0x2000, 0x4d78: 0x2000, 0x4d79: 0x2000, 0x4d7a: 0x2000, 0x4d7b: 0x2000,
	0x4d7c: 0x2000, 0x4d7d: 0x2000, 0x4d7e: 0x2000, 0x4d7f: 0x2000,
	// Block 0x136, offset 0x4d80
	0x4d80: 0x2000, 0x4d81: 0x2000, 0x4d82: 0x2000, 0x4d83: 0x2000, 0x4d84: 0x2000, 0x4d85: 0x2000,
	0x4d86: 0x2000, 0x4d87: 0x2000, 0x4d88: 0x2000, 0x4d89: 0x2000, 0x4d8a: 0x0040, 0x4d8b: 0x0040,
	0x4d8c: 0x0040, 0x4d8d: 0x0040, 0x4d8e: 0x0040, 0x4d8f: 0x0040, 0x4d90: 0x0040, 0x4d91: 0x0040,
	0x4d92: 0x0040, 0x4d93: 0x0040, 0x4d94: 0x0040, 0x4d95: 0x0040, 0x4d96: 0x0040, 0x4d97: 0x0040,
	0x4d98: 0x0040, 0x4d99: 0x0040, 0x4d9a: 0x0040, 0x4d9b: 0x0040, 0x4d9c: 0x0040, 0x4d9d: 0x0040,
	0x4d9e: 0x0040, 0x4d9f: 0x0040, 0x4da0: 0x0040, 0x4da1: 0x0040, 0x4da2: 0x0040, 0x4da3: 0x0040,
	0x4da4: 0x0040, 0x4da5: 0x0040, 0x4da8: 0x2000, 0x4da9: 0x2000,
	0x4daa: 0x2000, 0x4dab: 0x2000, 0x4dac: 0x2000, 0x4dad: 0x2000, 0x4dae: 0x2000, 0x4daf: 0x2000,
	0x4db0: 0x2000, 0x4db1: 0x2000, 0x4db2: 0x2000, 0x4db3: 0x2000, 0x4db4: 0x2000, 0x4db5: 0x2000,
	0x4db6: 0x2000, 0x4db7: 0x2000, 0x4db8: 0x2000, 0x4db9: 0x2000, 0x4dba: 0x2000, 0x4dbb: 0x2000,
	0x4dbc: 0x2000, 0x4dbd: 0x2000, 0x4dbe: 0x2000, 0x4dbf: 0x2000,
	// Block 0x137, offset 0x4dc0
	0x4dc0: 0x2000, 0x4dc2: 0x0040, 0x4dc3: 0x0040, 0x4dc4: 0x0040, 0x4dc5: 0x0040,
	0x4dc6: 0x0040, 0x4dc7: 0x0040, 0x4dc8: 0x0040, 0x4dc9: 0x0040, 0x4dca: 0x0040, 0x4dcb: 0x0040,
	0x4dcc: 0x0040, 0x4dcd: 0x0040, 0x4dce: 0x0040, 0x4dcf: 0x0040, 0x4dd0: 0x0040, 0x4dd1: 0x0040,
	0x4dd2: 0x0040, 0x4dd3: 0x0040, 0x4dd4: 0x0040, 0x4dd5: 0x0040, 0x4dd6: 0x0040, 0x4dd7: 0x0040,
	0x4dd8: 0x0040, 0x4dd9: 0x0040, 0x4dda: 0x0040, 0x4ddc: 0x0040, 0x4ddd: 0x0040,
	0x4dde: 0x0040, 0x4ddf: 0x0040, 0x4de0: 0x0040, 0x4de1: 0x0040, 0x4de2: 0x2000, 0x4de3: 0x2000,
	0x4de4: 0x2000, 0x4de5: 0x2000, 0x4de6: 0x2000, 0x4de7: 0x2000, 0x4de8: 0x2000, 0x4de9: 0x2000,
	0x4dea: 0x2000, 0x4deb: 0x2000, 0x4dec: 0x2000, 0x4ded: 0x2000, 0x4dee: 0x2000, 0x4def: 0x2000,
	0x4df0: 0x2000, 0x4df1: 0x2000, 0x4df2: 0x2000, 0x4df3: 0x2000, 0x4df4: 0x2000, 0x4df5: 0x2000,
	0x4df6: 0x2000, 0x4df7: 0x2000, 0x4df8: 0x2000, 0x4df9: 0x2000, 0x4dfa: 0x2000,
	0x4dfc: 0x0040, 0x4dfd: 0x0040, 0x4dfe: 0x0040, 0x4dff: 0x0040,
	// Block 0x138, offset 0x4e00
	0x4e00: 0x0040, 0x4e01: 0x0040, 0x4e02: 0x0040, 0x4e03: 0x0040, 0x4e04: 0x0040, 0x4e05: 0x0040,
	0x4e06: 0x0040, 0x4e07: 0x0040, 0x4e08: 0x0040, 0x4e09: 0x0040, 0x4e0a: 0x0040, 0x4e0b: 0x0040,
	0x4e0c: 0x0040, 0x4e0d: 0x0040, 0x4e0e: 0x0040, 0x4e0f: 0x0040, 0x4e10: 0x0040, 0x4e11: 0x0040,
	0x4e12: 0x0040, 0x4e13: 0x0040, 0x4e14: 0x0040, 0x4e16: 0x0040, 0x4e17: 0x0040,
	0x4e18: 0x0040, 0x4e19: 0x0040, 0x4e1a: 0x0040, 0x4e1b: 0x0040, 0x4e1c: 0x2000, 0x4e1d: 0x2000,
	0x4e1e: 0x2000, 0x4e1f: 0x2000, 0x4e20: 0x2000, 0x4e21: 0x2000, 0x4e22: 0x2000, 0x4e23: 0x2000,
	0x4e24: 0x2000, 0x4e25: 0x2000, 0x4e26: 0x2000, 0x4e27: 0x2000, 0x4e28: 0x2000, 0x4e29: 0x2000,
	0x4e2a: 0x2000, 0x4e2b: 0x2000, 0x4e2c: 0x2000, 0x4e2d: 0x2000, 0x4e2e: 0x2000, 0x4e2f: 0x2000,
	0x4e30: 0x2000, 0x4e31: 0x2000, 0x4e32: 0x2000, 0x4e33: 0x2000, 0x4e34: 0x2000,
	0x4e36: 0x0040, 0x4e37: 0x0040, 0x4e38: 0x0040, 0x4e39: 0x0040, 0x4e3a: 0x0040, 0x4e3b: 0x0040,
	0x4e3c: 0x0040, 0x4e3d: 0x0040, 0x4e3e: 0x0040, 0x4e3f: 0x0040,
	// Block 0x139, offset 0x4e40
	0x4e40: 0x0040, 0x4e41: 0x0040, 0x4e42: 0x0040, 0x4e43: 0x0040, 0x4e44: 0x0040, 0x4e45: 0x0040,
	0x4e46: 0x0040, 0x4e47: 0x0040, 0x4e48: 0x0040, 0x4e49: 0x0040, 0x4e4a: 0x0040, 0x4e4b: 0x0040,
	0x4e4c: 0x0040, 0x4e4d: 0x0040, 0x4e4e: 0x0040, 0x4e50: 0x0040, 0x4e51: 0x0040,
	0x4e52: 0x0040, 0x4e53: 0x0040, 0x4e54: 0x0040, 0x4e55: 0x0040, 0x4e56: 0x2000, 0x4e57: 0x2000,
	0x4e58: 0x2000, 0x4e59: 0x2000, 0x4e5a: 0x2000, 0x4e5b: 0x2000, 0x4e5c: 0x2000, 0x4e5d: 0x2000,
	0x4e5e: 0x2000, 0x4e5f: 0x2000, 0x4e60: 0x2000, 0x4e61: 0x2000, 0x4e62: 0x2000, 0x4e63: 0x2000,
	0x4e64: 0x2000, 0x4e65: 0x2000, 0x4e66: 0x2000, 0x4e67: 0x2000, 0x4e68: 0x2000, 0x4e69: 0x2000,
	0x4e6a: 0x2000, 0x4e6b: 0x2000, 0x4e6c: 0x2000, 0x4e6d: 0x2000, 0x4e6e: 0x2000,
	0x4e70: 0x0040, 0x4e71: 0x0040, 0x4e72: 0x0040, 0x4e73: 0x0040, 0x4e74: 0x0040, 0x4e75: 0x0040,
	0x4e76: 0x0040, 0x4e77: 0x0040, 0x4e78: 0x0040, 0x4e79: 0x0040, 0x4e7a: 0x0040, 0x4e7b: 0x0040,
	0x4e7c: 0x0040, 0x4e7d: 0x0040, 0x4e7e: 0x0040, 0x4e7f: 0x0040,
	// Block 0x13a, offset 0x4e80
	0x4e80: 0x0040, 0x4e81: 0x0040, 0x4e82: 0x0040, 0x4e83: 0x0040, 0x4e84: 0x0040, 0x4e85: 0x0040,
	0x4e86: 0x0040, 0x4e87: 0x0040, 0x4e88: 0x0040, 0x4e8a: 0x0040, 0x4e8b: 0x0040,
	0x4e8c: 0x0040, 0x4e8d: 0x0040, 0x4e8e: 0x0040, 0x4e8f: 0x0040, 0x4e90: 0x2000, 0x4e91: 0x2000,
	0x4e92: 0x2000, 0x4e93: 0x2000, 0x4e94: 0x2000, 0x4e95: 0x2000, 0x4e96: 0x2000, 0x4e97: 0x2000,
	0x4e98: 0x2000, 0x4e99: 0x2000, 0x4e9a: 0x2000, 0x4e9b: 0x2000, 0x4e9c: 0x2000, 0x4e9d: 0x2000,
	0x4e9e: 0x2000, 0x4e9f: 0x2000, 0x4ea0: 0x2000, 0x4ea1: 0x2000, 0x4ea2: 0x2000, 0x4ea3: 0x2000,
	0x4ea4: 0x2000, 0x4ea5: 0x2000, 0x4ea6: 0x2000, 0x4ea7: 0x2000, 0x4ea8: 0x2000,
	0x4eaa: 0x0040, 0x4eab: 0x0040, 0x4eac: 0x0040, 0x4ead: 0x0040, 0x4eae: 0x0040, 0x4eaf: 0x0040,
	0x4eb0: 0x0040, 0x4eb1: 0x0040, 0x4eb2: 0x0040, 0x4eb3: 0x0040, 0x4eb4: 0x0040, 0x4eb5: 0x0040,
	0x4eb6: 0x0040, 0x4eb7: 0x0040, 0x4eb8: 0x0040, 0x4eb9: 0x0040, 0x4eba: 0x0040, 0x4ebb: 0x0040,
	0x4ebc: 0x0040, 0x4ebd: 0x0040, 0x4ebe: 0x0040, 0x4ebf: 0x0040,
	// Block 0x13b, offset 0x4ec0
	0x4ec0: 0x0040, 0x4ec1: 0x0040, 0x4ec2: 0x0040, 0x4ec4: 0x0040, 0x4ec5: 0x0040,
	0x4ec6: 0x0040, 0x4ec7: 0x0040, 0x4ec8: 0x0040, 0x4ec9: 0x0040, 0x4eca: 0x2000, 0x4ecb: 0x0040,
	0x4ece: 0x0080, 0x4ecf: 0x0080, 0x4ed0: 0x0080, 0x4ed1: 0x0080,
	0x4ed2: 0x0080, 0x4ed3: 0x0080, 0x4ed4: 0x0080, 0x4ed5: 0x0080, 0x4ed6: 0x0080, 0x4ed7: 0x0080,
	0x4ed8: 0x0080, 0x4ed9: 0x0080, 0x4eda: 0x0080, 0x4edb: 0x0080, 0x4edc: 0x0080, 0x4edd: 0x0080,
	0x4ede: 0x0080, 0x4edf: 0x0080, 0x4ee0: 0x0080, 0x4ee1: 0x0080, 0x4ee2: 0x0080, 0x4ee3: 0x0080,
	0x4ee4: 0x0080, 0x4ee5: 0x0080, 0x4ee6: 0x0080, 0x4ee7: 0x0080, 0x4ee8: 0x0080, 0x4ee9: 0x0080,
	0x4eea: 0x0080, 0x4eeb: 0x0080, 0x4eec: 0x0080, 0x4eed: 0x0080, 0x4eee: 0x0080, 0x4eef: 0x0080,
	0x4ef0: 0x0080, 0x4ef1: 0x0080, 0x4ef2: 0x0080, 0x4ef3: 0x0080, 0x4ef4: 0x0080, 0x4ef5: 0x0080,
	0x4ef6: 0x0080, 0x4ef7: 0x0080, 0x4ef8: 0x0080, 0x4ef9: 0x0080, 0x4efa: 0x0080, 0x4efb: 0x0080,
	0x4efc: 0x0080, 0x4efd: 0x0080, 0x4efe: 0x0080, 0x4eff: 0x0080,
	// Block 0x13c, offset 0x4f00
	0x4f00: 0x0008, 0x4f01: 0x0008, 0x4f02: 0x0008, 0x4f03: 0x0008, 0x4f04: 0x0008, 0x4f05: 0x0008,
	0x4f06: 0x0008, 0x4f07: 0x0008, 0x4f08: 0x0008, 0x4f09: 0x0008, 0x4f0a: 0x0008, 0x4f0b: 0x0008,
	0x4f0c: 0x0008, 0x4f0d: 0x0008, 0x4f0e: 0x0008, 0x4f0f: 0x0008, 0x4f10: 0x0008, 0x4f11: 0x0008,
	0x4f12: 0x0008, 0x4f13: 0x0008, 0x4f14: 0x0008, 0x4f15: 0x0008, 0x4f16: 0x0008, 0x4f17: 0x0008,
	0x4f18: 0x0008, 0x4f19: 0x0008, 0x4f1a: 0x0008, 0x4f1b: 0x0008, 0x4f1c: 0x0008, 0x4f1d: 0x0008,
	0x4f1e: 0x0008, 0x4f1f: 0x0008, 0x4f20: 0x0008, 0x4f21: 0x0008, 0x4f22: 0x0008, 0x4f23: 0x0008,
	0x4f24: 0x0008, 0x4f25: 0x0008, 0x4f26: 0x0008, 0x4f27: 0x0008, 0x4f28: 0x0008, 0x4f29: 0x0008,
	0x4f2a: 0x0008, 0x4f2b: 0x0008, 0x4f2c: 0x0008, 0x4f2d: 0x0008, 0x4f2e: 0x0008, 0x4f2f: 0x0008,
	0x4f30: 0x0008, 0x4f31: 0x0008, 0x4f32: 0x0008, 0x4f33: 0x0008, 0x4f34: 0x0008, 0x4f35: 0x0008,
	0x4f36: 0x0008, 0x4f3b: 0x0008,
	0x4f3c: 0x0008, 0x4f3d: 0x0008, 0x4f3e: 0x0008, 0x4f3f: 0x0008,
	// Block 0x13d, offset 0x4f40
	0x4f40: 0x0008, 0x4f41: 0x0008, 0x4f42: 0x0008, 0x4f43: 0x0008, 0x4f44: 0x0008, 0x4f45: 0x0008,
	0x4f46: 0x0008, 0x4f47: 0x0008, 0x4f48: 0x0008, 0x4f49: 0x0008, 0x4f4a: 0x0008, 0x4f4b: 0x0008,
	0x4f4c: 0x0008, 0x4f4d: 0x0008, 0x4f4e: 0x0008, 0x4f4f: 0x0008, 0x4f50: 0x0008, 0x4f51: 0x0008,
	0x4f52: 0x0008, 0x4f53: 0x0008, 0x4f54: 0x0008, 0x4f55: 0x0008, 0x4f56: 0x0008, 0x4f57: 0x0008,
	0x4f58: 0x0008, 0x4f59: 0x0008, 0x4f5a: 0x0008, 0x4f5b: 0x0008, 0x4f5c: 0x0008, 0x4f5d: 0x0008,
	0x4f5e: 0x0008, 0x4f5f: 0x0008, 0x4f60: 0x0008, 0x4f61: 0x0008, 0x4f62: 0x0008, 0x4f63: 0x0008,
	0x4f64: 0x0008, 0x4f65: 0x0008, 0x4f66: 0x0008, 0x4f67: 0x0008, 0x4f68: 0x0008, 0x4f69: 0x0008,
	0x4f6a: 0x0008, 0x4f6b: 0x0008, 0x4f6c: 0x0008,
	0x4f75: 0x0008,
	// Block 0x13e, offset 0x4f80
	0x4f84: 0x0008,
	0x4f88: 0x0400,
	0x4f9b: 0x0008, 0x4f9c: 0x0008, 0x4f9d: 0x0008,
	0x4f9e: 0x0008, 0x4f9f: 0x0008, 0x4fa1: 0x0008, 0x4fa2: 0x0008, 0x4fa3: 0x0008,
	0x4fa4: 0x0008, 0x4fa5: 0x0008, 0x4fa6: 0x0008, 0x4fa7: 0x0008, 0x4fa8: 0x0008, 0x4fa9: 0x0008,
	0x4faa: 0x0008, 0x4fab: 0x0008, 0x4fac: 0x0008, 0x4fad: 0x0008, 0x4fae: 0x0008, 0x4faf: 0x0008,
	// Block 0x13f, offset 0x4fc0
	0x4fc0: 0x0040, 0x4fc1: 0x0040, 0x4fc2: 0x0040, 0x4fc3: 0x0040, 0x4fc4: 0x0040, 0x4fc5: 0x0040,
	0x4fc6: 0x0040, 0x4fc7: 0x0040, 0x4fc8: 0x0040, 0x4fc9: 0x0040, 0x4fca: 0x0100, 0x4fcb: 0x0040,
	0x4fcc: 0x0040, 0x4fcd: 0x0040, 0x4fce: 0x0040, 0x4fcf: 0x0040, 0x4fd0: 0x0040, 0x4fd1: 0x0040,
	0x4fd2: 0x0040, 0x4fd3: 0x0040, 0x4fd4: 0x0040, 0x4fd5: 0x0040, 0x4fd6: 0x0040, 0x4fd7: 0x0040,
	0x4fd8: 0x0040, 0x4fd9: 0x0040, 0x4fda: 0x0040, 0x4fdb: 0x0040, 0x4fdc: 0x0040, 0x4fdd: 0x0040,
	0x4fde: 0x0040,
	0x4fe5: 0x0040, 0x4fe6: 0x0040, 0x4fe7: 0x0040, 0x4fe8: 0x0040, 0x4fe9: 0x0040,
	0x4fea: 0x0040,
	// Block 0x140, offset 0x5000
	0x5000: 0x0008, 0x5001: 0x0008, 0x5002: 0x0008, 0x5003: 0x0008, 0x5004: 0x0008, 0x5005: 0x0008,
	0x5006: 0x0008, 0x5008: 0x0008, 0x5009: 0x0008, 0x500a: 0x0008, 0x500b: 0x0008,
	0x500c: 0x0008, 0x500d: 0x0008, 0x500e: 0x0008, 0x500f: 0x0008, 0x5010: 0x0008, 0x5011: 0x0008,
	0x5012: 0x0008, 0x5013: 0x0008, 0x5014: 0x0008, 0x5015: 0x0008, 0x5016: 0x0008, 0x5017: 0x0008,
	0x5018: 0x0008, 0x501b: 0x0008, 0x501c: 0x0008, 0x501d: 0x0008,
	0x501e: 0x0008, 0x501f: 0x0008, 0x5020: 0x0008, 0x5021: 0x0008, 0x5023: 0x0008,
	0x5024: 0x0008, 0x5026: 0x0008, 0x5027: 0x0008, 0x5028: 0x0008, 0x5029: 0x0008,
	0x502a: 0x0008,
	0x5030: 0x0040, 0x5031: 0x0040, 0x5032: 0x0040, 0x5033: 0x0040, 0x5034: 0x0040, 0x5035: 0x0040,
	0x5036: 0x0040, 0x5037: 0x0040, 0x5038: 0x0040, 0x5039: 0x0040, 0x503a: 0x0040, 0x503b: 0x0040,
	0x503c: 0x0040, 0x503d: 0x0040, 0x503e: 0x0040, 0x503f: 0x0040,
	// Block 0x141, offset 0x5040
	0x5040: 0x0040, 0x5041: 0x0040, 0x5042: 0x0040, 0x5043: 0x0040, 0x5044: 0x0040, 0x5045: 0x0040,
	0x5046: 0x0040, 0x5047: 0x0040, 0x5048: 0x0040, 0x5049: 0x0040, 0x504a: 0x0040, 0x504b: 0x0040,
	0x504c: 0x0040, 0x504d: 0x0040, 0x504e: 0x0040, 0x504f: 0x0040, 0x5050: 0x0040, 0x5051: 0x0040,
	0x5052: 0x0040, 0x5053: 0x0040, 0x5054: 0x0040, 0x5055: 0x0040, 0x5056: 0x0040, 0x5057: 0x0040,
	0x5058: 0x0040, 0x5059: 0x0040, 0x505a: 0x0040, 0x505b: 0x0040, 0x505c: 0x0040, 0x505d: 0x0040,
	0x505e: 0x0040, 0x505f: 0x0040, 0x5060: 0x0040, 0x5061: 0x0040, 0x5062: 0x0040, 0x5063: 0x0040,
	0x5064: 0x0040, 0x5065: 0x0040, 0x5066: 0x0040, 0x5067: 0x0040, 0x5068: 0x0040, 0x5069: 0x0040,
	0x506a: 0x0040, 0x506b: 0x0040, 0x506c: 0x0040, 0x506d: 0x0040,
	// Block 0x142, offset 0x5080
	0x508f: 0x0008,
	// Block 0x143, offset 0x50c0
	0x50c0: 0x0100, 0x50c1: 0x0100, 0x50c2: 0x0100, 0x50c3: 0x0100, 0x50c4: 0x0100, 0x50c5: 0x0100,
	0x50c6: 0x0100, 0x50c7: 0x0100, 0x50c8: 0x0100, 0x50c9: 0x0100, 0x50ca: 0x0100, 0x50cb: 0x0100,
	0x50cc: 0x0100, 0x50cd: 0x0100, 0x50ce: 0x0100, 0x50cf: 0x0100, 0x50d0: 0x0100, 0x50d1: 0x0100,
	0x50d2: 0x0100, 0x50d3: 0x0100, 0x50d4: 0x0100, 0x50d5: 0x0100, 0x50d6: 0x0100, 0x50d7: 0x0100,
	0x50d8: 0x0100, 0x50d9: 0x0100, 0x50da: 0x0100, 0x50db: 0x0100, 0x50dc: 0x0100, 0x50dd: 0x0100,
	0x50de: 0x0100, 0x50df: 0x0100, 0x50e0: 0x0100, 0x50e1: 0x0100, 0x50e2: 0x0100, 0x50e3: 0x0100,
	0x50e4: 0x0100, 0x50e5: 0x0100, 0x50e6: 0x0100, 0x50e7: 0x0100, 0x50e8: 0x0100, 0x50e9: 0x0100,
	0x50ea: 0x0100, 0x50eb: 0x0100, 0x50ec: 0x0100,
	0x50f0: 0x0008, 0x50f1: 0x0008, 0x50f2: 0x0008, 0x50f3: 0x0008, 0x50f4: 0x0008, 0x50f5: 0x0008,
	0x50f6: 0x0008, 0x50f7: 0x0100, 0x50f8: 0x0100, 0x50f9: 0x0100, 0x50fa: 0x0100, 0x50fb: 0x0100,
	0x50fc: 0x0100, 0x50fd: 0x0100,
	// Block 0x144, offset 0x5100
	0x5100: 0x0080, 0x5101: 0x0080, 0x5102: 0x0080, 0x5103: 0x0080, 0x5104: 0x0080, 0x5105: 0x0080,
	0x5106: 0x0080, 0x5107: 0x0080, 0x5108: 0x0080, 0x5109: 0x0080,
	0x510e: 0x0100,
	// Block 0x145, offset 0x5140
	0x5150: 0x0100, 0x5151: 0x0100,
	0x5152: 0x0100, 0x5153: 0x0100, 0x5154: 0x0100, 0x5155: 0x0100, 0x5156: 0x0100, 0x5157: 0x0100,
	0x5158: 0x0100, 0x5159: 0x0100, 0x515a: 0x0100, 0x515b: 0x0100, 0x515c: 0x0100, 0x515d: 0x0100,
	0x515e: 0x0100, 0x515f: 0x0100, 0x5160: 0x0100, 0x5161: 0x0100, 0x5162: 0x0100, 0x5163: 0x0100,
	0x5164: 0x0100, 0x5165: 0x0100, 0x5166: 0x0100, 0x5167: 0x0100, 0x5168: 0x0100, 0x5169: 0x0100,
	0x516a: 0x0100, 0x516b: 0x0100, 0x516c: 0x0100, 0x516d: 0x0100, 0x516e: 0x0008,
	// Block 0x146, offset 0x5180
	0x5180: 0x0100, 0x5181: 0x0100, 0x5182: 0x0100, 0x5183: 0x0100, 0x5184: 0x0100, 0x5185: 0x0100,
	0x5186: 0x0100, 0x5187: 0x0100, 0x5188: 0x0100, 0x5189: 0x0100, 0x518a: 0x0100, 0x518b: 0x0100,
	0x518c: 0x0100, 0x518d: 0x0100, 0x518e: 0x0100, 0x518f: 0x0100, 0x5190: 0x0100, 0x5191: 0x0100,
	0x5192: 0x0100, 0x5193: 0x0100, 0x5194: 0x0100, 0x5195: 0x0100, 0x5196: 0x0100, 0x5197: 0x0100,
	0x5198: 0x0100, 0x5199: 0x0100, 0x519a: 0x0100, 0x519b: 0x0100, 0x519c: 0x0100, 0x519d: 0x0100,
	0x519e: 0x0100, 0x519f: 0x0100, 0x51a0: 0x0100, 0x51a1: 0x0100, 0x51a2: 0x0100, 0x51a3: 0x0100,
	0x51a4: 0x0100, 0x51a5: 0x0100, 0x51a6: 0x0100, 0x51a7: 0x0100, 0x51a8: 0x0100, 0x51a9: 0x0100,
	0x51aa: 0x0100, 0x51ab: 0x0100, 0x51ac: 0x0008, 0x51ad: 0x0008, 0x51ae: 0x0008, 0x51af: 0x0008,
	0x51b0: 0x0080, 0x51b1: 0x0080, 0x51b2: 0x0080, 0x51b3: 0x0080, 0x51b4: 0x0080, 0x51b5: 0x0080,
	0x51b6: 0x0080, 0x51b7: 0x0080, 0x51b8: 0x0080, 0x51b9: 0x0080,
	// Block 0x147, offset 0x51c0
	0x51d0: 0x0100, 0x51d1: 0x0100,
	0x51d2: 0x0100, 0x51d3: 0x0100, 0x51d4: 0x0100, 0x51d5: 0x0100, 0x51d6: 0x0100, 0x51d7: 0x0100,
	0x51d8: 0x0100, 0x51d9: 0x0100, 0x51da: 0x0100, 0x51db: 0x0100, 0x51dc: 0x0100, 0x51dd: 0x0100,
	0x51de: 0x0100, 0x51df: 0x0100, 0x51e0: 0x0100, 0x51e1: 0x0100, 0x51e2: 0x0100, 0x51e3: 0x0100,
	0x51e4: 0x0100, 0x51e5: 0x0100, 0x51e6: 0x0100, 0x51e7: 0x0100, 0x51e8: 0x0100, 0x51e9: 0x0100,
	0x51ea: 0x0100, 0x51eb: 0x0100, 0x51ec: 0x0008, 0x51ed: 0x0008, 0x51ee: 0x0008, 0x51ef: 0x0008,
	0x51f0: 0x0080, 0x51f1: 0x0080, 0x51f2: 0x0080, 0x51f3: 0x0080, 0x51f4: 0x0080, 0x51f5: 0x0080,
	0x51f6: 0x0080, 0x51f7: 0x0080, 0x51f8: 0x0080, 0x51f9: 0x0080,
	// Block 0x148, offset 0x5200
	0x5220: 0x0100, 0x5221: 0x0100, 0x5222: 0x0100, 0x5223: 0x0100,
	0x5224: 0x0100, 0x5225: 0x0100, 0x5226: 0x0100, 0x5228: 0x0100, 0x5229: 0x0100,
	0x522a: 0x0100, 0x522b: 0x0100, 0x522d: 0x0100, 0x522e: 0x0100,
	0x5230: 0x0100, 0x5231: 0x0100, 0x5232: 0x0100, 0x5233: 0x0100, 0x5234: 0x0100, 0x5235: 0x0100,
	0x5236: 0x0100, 0x5237: 0x0100, 0x5238: 0x0100, 0x5239: 0x0100, 0x523a: 0x0100, 0x523b: 0x0100,
	0x523c: 0x0100, 0x523d: 0x0100, 0x523e: 0x0100,
	// Block 0x149, offset 0x5240
	0x5240: 0x0100, 0x5241: 0x0100, 0x5242: 0x0100, 0x5243: 0x0100, 0x5244: 0x0100,
	0x5250: 0x0008, 0x5251: 0x0008,
	0x5252: 0x0008, 0x5253: 0x0008, 0x5254: 0x0008, 0x5255: 0x0008, 0x5256: 0x0008,
	// Block 0x14a, offset 0x5280
	0x5280: 0x2000, 0x5281: 0x2000, 0x5282: 0x2000, 0x5283: 0x2000, 0x5284: 0x2000, 0x5285: 0x2000,
	0x5286: 0x2000, 0x5287: 0x2000, 0x5288: 0x2000, 0x5289: 0x2000, 0x528a: 0x2000, 0x528b: 0x2000,
	0x528c: 0x2000, 0x528d: 0x2000, 0x528e: 0x2000, 0x528f: 0x2000, 0x5290: 0x2000, 0x5291: 0x2000,
	0x5292: 0x2000, 0x5293: 0x2000, 0x5294: 0x2000, 0x5295: 0x2000, 0x5296: 0x2000, 0x5297: 0x2000,
	0x5298: 0x2000, 0x5299: 0x2000, 0x529a: 0x2000, 0x529b: 0x2000, 0x529c: 0x2000, 0x529d: 0x2000,
	0x529e: 0x2000, 0x529f: 0x2000, 0x52a0: 0x2000, 0x52a1: 0x2000, 0x52a2: 0x0040, 0x52a3: 0x0040,
	0x52a4: 0x0040, 0x52a5: 0x0040, 0x52a6: 0x0040, 0x52a7: 0x0040, 0x52a8: 0x0040, 0x52a9: 0x0040,
	0x52aa: 0x0040, 0x52ab: 0x0040, 0x52ac: 0x0040, 0x52ad: 0x0040, 0x52ae: 0x0040, 0x52af: 0x0040,
	0x52b0: 0x0040, 0x52b1: 0x0040, 0x52b2: 0x0040, 0x52b3: 0x0040, 0x52b4: 0x0040, 0x52b5: 0x0040,
	0x52b6: 0x0040, 0x52b7: 0x0040, 0x52b8: 0x0040, 0x52b9: 0x0040, 0x52ba: 0x0040, 0x52bb: 0x0040,
	0x52bc: 0x0040, 0x52bd: 0x0040, 0x52be: 0x0040, 0x52bf: 0x0040,
	// Block 0x14b, offset 0x52c0
	0x52c0: 0x0040, 0x52c1: 0x0040, 0x52c2: 0x0040, 0x52c3: 0x0040, 0x52c4: 0x0008, 0x52c5: 0x0008,
	0x52c6: 0x0008, 0x52c7: 0x0008, 0x52c8: 0x0008, 0x52c9: 0x0008, 0x52ca: 0x0008, 0x52cb: 0x0100,
	0x52d0: 0x0080, 0x52d1: 0x0080,
	0x52d2: 0x0080, 0x52d3: 0x0080, 0x52d4: 0x0080, 0x52d5: 0x0080, 0x52d6: 0x0080, 0x52d7: 0x0080,
	0x52d8: 0x0080, 0x52d9: 0x0080,
	// Block 0x14c, offset 0x5300
	0x5300: 0x0100, 0x5301: 0x0100, 0x5302: 0x0100, 0x5303: 0x0100, 0x5305: 0x0100,
	0x5306: 0x0100, 0x5307: 0x0100, 0x5308: 0x0100, 0x5309: 0x0100, 0x530a: 0x0100, 0x530b: 0x0100,
	0x530c: 0x0100, 0x530d: 0x0100, 0x530e: 0x0100, 0x530f: 0x0100, 0x5310: 0x0100, 0x5311: 0x0100,
	0x5312: 0x0100, 0x5313: 0x0100, 0x5314: 0x0100, 0x5315: 0x0100, 0x5316: 0x0100, 0x5317: 0x0100,
	0x5318: 0x0100, 0x5319: 0x0100, 0x531a: 0x0100, 0x531b: 0x0100, 0x531c: 0x0100, 0x531d: 0x0100,
	0x531e: 0x0100, 0x531f: 0x0100, 0x5321: 0x0100, 0x5322: 0x0100,
	0x5324: 0x0100, 0x5327: 0x0100, 0x5329: 0x0100,
	0x532a: 0x0100, 0x532b: 0x0100, 0x532c: 0x0100, 0x532d: 0x0100, 0x532e: 0x0100, 0x532f: 0x0100,
	0x5330: 0x0100, 0x5331: 0x0100, 0x5332: 0x0100, 0x5334: 0x0100, 0x5335: 0x0100,
	0x5336: 0x0100, 0x5337: 0x0100, 0x5339: 0x0100, 0x533b: 0x0100,
	// Block 0x14d, offset 0x5340
	0x5342: 0x0100,
	0x5347: 0x0100, 0x5349: 0x0100, 0x534b: 0x0100,
	0x534d: 0x0100, 0x534e: 0x0100, 0x534f: 0x0100, 0x5351: 0x0100,
	0x5352: 0x0100, 0x5354: 0x0100, 0x5357: 0x0100,
	0x5359: 0x0100, 0x535b: 0x0100, 0x535d: 0x0100,
	0x535f: 0x0100, 0x5361: 0x0100, 0x5362: 0x0100,
	0x5364: 0x0100, 0x5367: 0x0100, 0x5368: 0x0100, 0x5369: 0x0100,
	0x536a: 0x0100, 0x536c: 0x0100, 0x536d: 0x0100, 0x536e: 0x0100, 0x536f: 0x0100,
	0x5370: 0x0100, 0x5371: 0x0100, 0x5372: 0x0100, 0x5374: 0x0100, 0x5375: 0x0100,
	0x5376: 0x0100, 0x5377: 0x0100, 0x5379: 0x0100, 0x537a: 0x0100, 0x537b: 0x0100,
	0x537c: 0x0100, 0x537e: 0x0100,
	// Block 0x14e, offset 0x5380
	0x5380: 0x0100, 0x5381: 0x0100, 0x5382: 0x0100, 0x5383: 0x0100, 0x5384: 0x0100, 0x5385: 0x0100,
	0x5386: 0x0100, 0x5387: 0x0100, 0x5388: 0x0100, 0x5389: 0x0100, 0x538b: 0x0100,
	0x538c: 0x0100, 0x538d: 0x0100, 0x538e: 0x0100, 0x538f: 0x0100, 0x5390: 0x0100, 0x5391: 0x0100,
	0x5392: 0x0100, 0x5393: 0x0100, 0x5394: 0x0100, 0x5395: 0x0100, 0x5396: 0x0100, 0x5397: 0x0100,
	0x5398: 0x0100, 0x5399: 0x0100, 0x539a: 0x0100, 0x539b: 0x0100,
	0x53a1: 0x0100, 0x53a2: 0x0100, 0x53a3: 0x0100,
	0x53a5: 0x0100, 0x53a6: 0x0100, 0x53a7: 0x0100, 0x53a8: 0x0100, 0x53a9: 0x0100,
	0x53ab: 0x0100, 0x53ac: 0x0100, 0x53ad: 0x0100, 0x53ae: 0x0100, 0x53af: 0x0100,
	0x53b0: 0x0100, 0x53b1: 0x0100, 0x53b2: 0x0100, 0x53b3: 0x0100, 0x53b4: 0x0100, 0x53b5: 0x0100,
	0x53b6: 0x0100, 0x53b7: 0x0100, 0x53b8: 0x0100, 0x53b9: 0x0100, 0x53ba: 0x0100, 0x53bb: 0x0100,
	// Block 0x14f, offset 0x53c0
	0x53f0: 0x2000, 0x53f1: 0x2000, 0x53f2: 0x2000, 0x53f3: 0x2000, 0x53f4: 0x2000, 0x53f5: 0x2000,
	0x53f6: 0x2000, 0x53f7: 0x2000, 0x53f8: 0x2000, 0x53f9: 0x2000, 0x53fa: 0x2000, 0x53fb: 0x2000,
	0x53fc: 0x2000, 0x53fd: 0x2000, 0x53fe: 0x2000, 0x53ff: 0x2000,
	// Block 0x150, offset 0x5400
	0x5400: 0x2000, 0x5401: 0x2000, 0x5402: 0x2000, 0x5403: 0x2000, 0x5404: 0x2000, 0x5405: 0x2000,
	0x5406: 0x2000, 0x5407: 0x2000, 0x5408: 0x2000, 0x5409: 0x2000,
	0x5410: 0x2000, 0x5411: 0x2000,
	0x5412: 0x2000, 0x5413: 0x2000, 0x5414: 0x2000, 0x5415: 0x2000, 0x5416: 0x2000, 0x5417: 0x2000,
	0x5418: 0x2000, 0x5419: 0x2000, 0x541a: 0x2000, 0x541b: 0x2000, 0x541c: 0x2000, 0x541d: 0x2000,
	0x541e: 0x2000, 0x541f: 0x2000, 0x5420: 0x2000, 0x5421: 0x2000, 0x5422: 0x2000, 0x5423: 0x2000,
	0x5424: 0x2000, 0x5425: 0x2000, 0x5426: 0x2000, 0x5427: 0x2000, 0x5428: 0x2000, 0x5429: 0x2000,
	0x5430: 0x2000, 0x5431: 0x2000, 0x5432: 0x2000, 0x5433: 0x2000, 0x5434: 0x2000, 0x5435: 0x2000,
	0x5436: 0x2000, 0x5437: 0x2000, 0x5438: 0x2000, 0x5439: 0x2000, 0x543a: 0x2000, 0x543b: 0x2000,
	0x543c: 0x2000, 0x543d: 0x2000, 0x543e: 0x2000, 0x543f: 0x2000,
	// Block 0x151, offset 0x5440
	0x5440: 0x2000, 0x5441: 0x2000, 0x5442: 0x2000, 0x5443: 0x2000, 0x5444: 0x2000, 0x5445: 0x2000,
	0x5446: 0x2000, 0x5447: 0x2000, 0x5448: 0x2000, 0x5449: 0x2000,
	// Block 0x152, offset 0x5480
	0x54b6: 0x0004, 0x54b7: 0x0004, 0x54b8: 0x0004,
	// Block 0x153, offset 0x54c0
	0x54f0: 0x0080, 0x54f1: 0x0080, 0x54f2: 0x0080, 0x54f3: 0x0080, 0x54f4: 0x0080, 0x54f5: 0x0080,
	0x54f6: 0x0080, 0x54f7: 0x0080, 0x54f8: 0x0080, 0x54f9: 0x0080,
	// Block 0x154, offset 0x5500
	0x5500: 0x0100, 0x5501: 0x0100, 0x5502: 0x0100, 0x5503: 0x0100, 0x5504: 0x0100, 0x5505: 0x0100,
	0x5506: 0x0100, 0x5507: 0x0100, 0x5508: 0x0100, 0x5509: 0x0100, 0x550a: 0x0100, 0x550b: 0x0100,
	0x550c: 0x0100, 0x550d: 0x0100, 0x550e: 0x0100, 0x550f: 0x0100, 0x5510: 0x0100, 0x5511: 0x0100,
	0x5512: 0x0100, 0x5513: 0x0100, 0x5514: 0x0100, 0x5515: 0x0100, 0x5516: 0x0100, 0x5517: 0x0100,
	0x5518: 0x0100, 0x5519: 0x0100, 0x551a: 0x0100, 0x551b: 0x0100, 0x551c: 0x0100, 0x551d: 0x0100,
	0x551e: 0x0100, 0x551f: 0x0100,
	// Block 0x155, offset 0x5540
	0x5540: 0x0100, 0x5541: 0x0100, 0x5542: 0x0100, 0x5543: 0x0100, 0x5544: 0x0100, 0x5545: 0x0100,
	0x5546: 0x0100, 0x5547: 0x0100, 0x5548: 0x0100, 0x5549: 0x0100, 0x554a: 0x0100, 0x554b: 0x0100,
	0x554c: 0x0100, 0x554d: 0x0100, 0x554e: 0x0100, 0x554f: 0x0100, 0x5550: 0x0100, 0x5551: 0x0100,
	0x5552: 0x0100, 0x5553: 0x0100, 0x5554: 0x0100, 0x5555: 0x0100, 0x5556: 0x0100, 0x5557: 0x0100,
	0x5558: 0x0100, 0x5559: 0x0100, 0x555a: 0x0100, 0x555b: 0x0100, 0x555c: 0x0100, 0x555d: 0x0100,
	0x555e: 0x0100, 0x555f: 0x0100, 0x5560: 0x0100, 0x5561: 0x0100, 0x5562: 0x0100, 0x5563: 0x0100,
	0x5564: 0x0100, 0x5565: 0x0100, 0x5566: 0x0100, 0x5567: 0x0100, 0x5568: 0x0100, 0x5569: 0x0100,
	0x556a: 0x0100, 0x556b: 0x0100, 0x556c: 0x0100, 0x556d: 0x0100, 0x556e: 0x0100, 0x556f: 0x0100,
	0x5570: 0x0100, 0x5571: 0x0100, 0x5572: 0x0100, 0x5573: 0x0100, 0x5574: 0x0100, 0x5575: 0x0100,
	0x5576: 0x0100, 0x5577: 0x0100, 0x5578: 0x0100, 0x5579: 0x0100,
	// Block 0x156, offset 0x5580
	0x5580: 0x0100, 0x5581: 0x0100, 0x5582: 0x0100, 0x5583: 0x0100, 0x5584: 0x0100, 0x5585: 0x0100,
	0x5586: 0x0100, 0x5587: 0x0100, 0x5588: 0x0100, 0x5589: 0x0100, 0x558a: 0x0100, 0x558b: 0x0100,
	0x558c: 0x0100, 0x558d: 0x0100, 0x558e: 0x0100, 0x558f: 0x0100, 0x5590: 0x0100, 0x5591: 0x0100,
	0x5592: 0x0100, 0x5593: 0x0100, 0x5594: 0x0100, 0x5595: 0x0100, 0x5596: 0x0100, 0x5597: 0x0100,
	0x5598: 0x0100, 0x5599: 0x0100, 0x559a: 0x0100, 0x559b: 0x0100, 0x559c: 0x0100, 0x559d: 0x0100,
	0x559e: 0x0100, 0x559f: 0x0100, 0x55a0: 0x0100, 0x55a1: 0x0100,
	0x55b0: 0x0100, 0x55b1: 0x0100, 0x55b2: 0x0100, 0x55b3: 0x0100, 0x55b4: 0x0100, 0x55b5: 0x0100,
	0x55b6: 0x0100, 0x55b7: 0x0100, 0x55b8: 0x0100, 0x55b9: 0x0100, 0x55ba: 0x0100, 0x55bb: 0x0100,
	0x55bc: 0x0100, 0x55bd: 0x0100, 0x55be: 0x0100, 0x55bf: 0x0100,
	// Block 0x157, offset 0x55c0
	0x55c0: 0x0100, 0x55c1: 0x0100, 0x55c2: 0x0100, 0x55c3: 0x0100, 0x55c4: 0x0100, 0x55c5: 0x0100,
	0x55c6: 0x0100, 0x55c7: 0x0100, 0x55c8: 0x0100, 0x55c9: 0x0100, 0x55ca: 0x0100, 0x55cb: 0x0100,
	0x55cc: 0x0100, 0x55cd: 0x0100, 0x55ce: 0x0100, 0x55cf: 0x0100, 0x55d0: 0x0100, 0x55d1: 0x0100,
	0x55d2: 0x0100, 0x55d3: 0x0100, 0x55d4: 0x0100, 0x55d5: 0x0100, 0x55d6: 0x0100, 0x55d7: 0x0100,
	0x55d8: 0x0100, 0x55d9: 0x0100, 0x55da: 0x0100, 0x55db: 0x0100, 0x55dc: 0x0100, 0x55dd: 0x0100,
	0x55de: 0x0100, 0x55df: 0x0100, 0x55e0: 0x0100,
	// Block 0x158, offset 0x5600
	0x5600: 0x0100, 0x5601: 0x0100, 0x5602: 0x0100, 0x5603: 0x0100, 0x5604: 0x0100, 0x5605: 0x0100,
	0x5606: 0x0100, 0x5607: 0x0100, 0x5608: 0x0100, 0x5609: 0x0100, 0x560a: 0x0100, 0x560b: 0x0100,
	0x560c: 0x0100, 0x560d: 0x0100, 0x560e: 0x0100, 0x560f: 0x0100, 0x5610: 0x0100, 0x5611: 0x0100,
	0x5612: 0x0100, 0x5613: 0x0100, 0x5614: 0x0100, 0x5615: 0x0100, 0x5616: 0x0100, 0x5617: 0x0100,
	0x5618: 0x0100, 0x5619: 0x0100, 0x561a: 0x0100, 0x561b: 0x0100, 0x561c: 0x0100, 0x561d: 0x0100,
	// Block 0x159, offset 0x5640
	0x5640: 0x0100, 0x5641: 0x0100, 0x5642: 0x0100, 0x5643: 0x0100, 0x5644: 0x0100, 0x5645: 0x0100,
	0x5646: 0x0100, 0x5647: 0x0100, 0x5648: 0x0100, 0x5649: 0x0100, 0x564a: 0x0100,
	0x5650: 0x0100, 0x5651: 0x0100,
	0x5652: 0x0100, 0x5653: 0x0100, 0x5654: 0x0100, 0x5655: 0x0100, 0x5656: 0x0100, 0x5657: 0x0100,
	0x5658: 0x0100, 0x5659: 0x0100, 0x565a: 0x0100, 0x565b: 0x0100, 0x565c: 0x0100, 0x565d: 0x0100,
	0x565e: 0x0100, 0x565f: 0x0100, 0x5660: 0x0100, 0x5661: 0x0100, 0x5662: 0x0100, 0x5663: 0x0100,
	0x5664: 0x0100, 0x5665: 0x0100, 0x5666: 0x0100, 0x5667: 0x0100, 0x5668: 0x0100, 0x5669: 0x0100,
	0x566a: 0x0100, 0x566b: 0x0100, 0x566c: 0x0100, 0x566d: 0x0100, 0x566e: 0x0100, 0x566f: 0x0100,
	0x5670: 0x0100, 0x5671: 0x0100, 0x5672: 0x0100, 0x5673: 0x0100, 0x5674: 0x0100, 0x5675: 0x0100,
	0x5676: 0x0100, 0x5677: 0x0100, 0x5678: 0x0100, 0x5679: 0x0100, 0x567a: 0x0100, 0x567b: 0x0100,
	0x567c: 0x0100, 0x567d: 0x0100, 0x567e: 0x0100, 0x567f: 0x0100,
	// Block 0x15a, offset 0x5680
	0x5680: 0x0100, 0x5681: 0x0100, 0x5682: 0x0100, 0x5683: 0x0100, 0x5684: 0x0100, 0x5685: 0x0100,
	0x5686: 0x0100, 0x5687: 0x0100, 0x5688: 0x0100, 0x5689: 0x0100, 0x568a: 0x0100, 0x568b: 0x0100,
	0x568c: 0x0100, 0x568d: 0x0100, 0x568e: 0x0100, 0x568f: 0x0100, 0x5690: 0x0100, 0x5691: 0x0100,
	0x5692: 0x0100, 0x5693: 0x0100, 0x5694: 0x0100, 0x5695: 0x0100, 0x5696: 0x0100, 0x5697: 0x0100,
	0x5698: 0x0100, 0x5699: 0x0100, 0x569a: 0x0100, 0x569b: 0x0100, 0x569c: 0x0100, 0x569d: 0x0100,
	0x569e: 0x0100, 0x569f: 0x0100, 0x56a0: 0x0100, 0x56a1: 0x0100, 0x56a2: 0x0100, 0x56a3: 0x0100,
	0x56a4: 0x0100, 0x56a5: 0x0100, 0x56a6: 0x0100, 0x56a7: 0x0100, 0x56a8: 0x0100, 0x56a9: 0x0100,
	0x56aa: 0x0100, 0x56ab: 0x0100, 0x56ac: 0x0100, 0x56ad: 0x0100, 0x56ae: 0x0100, 0x56af: 0x0100,
	// Block 0x15b, offset 0x56c0
	0x56c1: 0x0010,
	0x56e0: 0x0008, 0x56e1: 0x0008, 0x56e2: 0x0008, 0x56e3: 0x0008,
	0x56e4: 0x0008, 0x56e5: 0x0008, 0x56e6: 0x0008, 0x56e7: 0x0008, 0x56e8: 0x0008, 0x56e9: 0x0008,
	0x56ea: 0x0008, 0x56eb: 0x0008, 0x56ec: 0x0008, 0x56ed: 0x0008, 0x56ee: 0x0008, 0x56ef: 0x0008,
	0x56f0: 0x0008, 0x56f1: 0x0008, 0x56f2: 0x0008, 0x56f3: 0x0008, 0x56f4: 0x0008, 0x56f5: 0x0008,
	0x56f6: 0x0008, 0x56f7: 0x0008, 0x56f8: 0x0008, 0x56f9: 0x0008, 0x56fa: 0x0008, 0x56fb: 0x0008,
	0x56fc: 0x0008, 0x56fd: 0x0008, 0x56fe: 0x0008, 0x56ff: 0x0008,
	// Block 0x15c, offset 0x5700
	0x5700: 0x0008, 0x5701: 0x0008, 0x5702: 0x0008, 0x5703: 0x0008, 0x5704: 0x0008, 0x5705: 0x0008,
	0x5706: 0x0008, 0x5707: 0x0008, 0x5708: 0x0008, 0x5709: 0x0008, 0x570a: 0x0008, 0x570b: 0x0008,
	0x570c: 0x0008, 0x570d: 0x0008, 0x570e: 0x0008, 0x570f: 0x0008, 0x5710: 0x0008, 0x5711: 0x0008,
	0x5712: 0x0008, 0x5713: 0x0008, 0x5714: 0x0008, 0x5715: 0x0008, 0x5716: 0x0008, 0x5717: 0x0008,
	0x5718: 0x0008, 0x5719: 0x0008, 0x571a: 0x0008, 0x571b: 0x0008, 0x571c: 0x0008, 0x571d: 0x0008,
	0x571e: 0x0008, 0x571f: 0x0008, 0x5720: 0x0008, 0x5721: 0x0008, 0x5722: 0x0008, 0x5723: 0x0008,
	0x5724: 0x0008, 0x5725: 0x0008, 0x5726: 0x0008, 0x5727: 0x0008, 0x5728: 0x0008, 0x5729: 0x0008,
	0x572a: 0x0008, 0x572b: 0x0008, 0x572c: 0x0008, 0x572d: 0x0008, 0x572e: 0x0008, 0x572f: 0x0008,
}

// sentencesIndex: 36 blocks, 2304 entries, 4608 bytes
// Block 0 is the zero block.
var sentencesIndex = [2304]property{
	// Block 0x0, offset 0x0
	// Block 0x1, offset 0x40
	// Block 0x2, offset 0x80
	// Block 0x3, offset 0xc0
	0xc2: 0x01, 0xc3: 0x02, 0xc4: 0x03, 0xc5: 0x04, 0xc6: 0x05, 0xc7: 0x06,
	0xc8: 0x07, 0xc9: 0x08, 0xca: 0x09, 0xcb: 0x0a, 0xcc: 0x0b, 0xcd: 0x0c, 0xce: 0x0d, 0xcf: 0x0e,
	0xd0: 0x0f, 0xd1: 0x10, 0xd2: 0x11, 0xd3: 0x12, 0xd4: 0x13, 0xd5: 0x14, 0xd6: 0x15, 0xd7: 0x16,
	0xd8: 0x17, 0xd9: 0x18, 0xda: 0x19, 0xdb: 0x1a, 0xdc: 0x1b, 0xdd: 0x1c, 0xde: 0x1d, 0xdf: 0x1e,
	0xe0: 0x02, 0xe1: 0x03, 0xe2: 0x04, 0xe3: 0x05, 0xe4: 0x06, 0xe5: 0x07, 0xe6: 0x07, 0xe7: 0x07,
	0xe8: 0x07, 0xe9: 0x07, 0xea: 0x08, 0xeb: 0x07, 0xec: 0x07, 0xed: 0x09, 0xef: 0x0a,
	0xf0: 0x1f, 0xf3: 0x21,
	// Block 0x4, offset 0x100
	0x120: 0x1f, 0x121: 0x20, 0x122: 0x21, 0x123: 0x22, 0x124: 0x23, 0x125: 0x24, 0x126: 0x25, 0x127: 0x26,
	0x128: 0x27, 0x129: 0x28, 0x12a: 0x29, 0x12b: 0x2a, 0x12c: 0x2b, 0x12d: 0x2c, 0x12e: 0x2d, 0x12f: 0x2e,
	0x130: 0x2f, 0x131: 0x30, 0x132: 0x31, 0x133: 0x32, 0x134: 0x33, 0x135: 0x34, 0x136: 0x35, 0x137: 0x36,
	0x138: 0x37, 0x139: 0x38, 0x13a: 0x39, 0x13b: 0x3a, 0x13c: 0x3b, 0x13d: 0x3c, 0x13e: 0x3d, 0x13f: 0x3e,
	// Block 0x5, offset 0x140
	0x140: 0x3f, 0x141: 0x40, 0x142: 0x41, 0x143: 0x42, 0x144: 0x19, 0x145: 0x19, 0x146: 0x19, 0x147: 0x19,
	0x148: 0x19, 0x149: 0x43, 0x14a: 0x44, 0x14b: 0x45, 0x14c: 0x46, 0x14d: 0x47, 0x14e: 0x48, 0x14f: 0x49,
	0x150: 0x4a, 0x151: 0x19, 0x152: 0x19, 0x153: 0x19, 0x154: 0x19, 0x155: 0x19, 0x156: 0x19, 0x157: 0x19,
	0x158: 0x19, 0x159: 0x4b, 0x15a: 0x4c, 0x15b: 0x4d, 0x15c: 0x4e, 0x15d: 0x4f, 0x15e: 0x50, 0x15f: 0x51,
	0x160: 0x52, 0x161: 0x53, 0x162: 0x54, 0x163: 0x55, 0x164: 0x56, 0x165: 0x57, 0x166: 0x58, 0x167: 0x59,
	0x168: 0x5a, 0x169: 0x5b, 0x16a: 0x5c, 0x16b: 0x5d, 0x16c: 0x5e, 0x16d: 0x5f, 0x16e: 0x60, 0x16f: 0x61,
	0x170: 0x62, 0x171: 0x63, 0x172: 0x64, 0x173: 0x65, 0x174: 0x66, 0x175: 0x66, 0x176: 0x66, 0x177: 0x0b,
	0x178: 0x67, 0x179: 0x67, 0x17a: 0x68, 0x17b: 0x67, 0x17c: 0x69, 0x17d: 0x6a, 0x17e: 0x6b, 0x17f: 0x6c,
	// Block 0x6, offset 0x180
	0x180: 0x6d, 0x181: 0x6e, 0x182: 0x6f, 0x183: 0x70, 0x184: 0x71, 0x185: 0x72, 0x186: 0x73,
	0x18c: 0x74,
	0x192: 0x75, 0x193: 0x76,
	0x19d: 0x77, 0x19f: 0x78,
	0x1a6: 0x79, 0x1a7: 0x7a,
	0x1b0: 0x0f, 0x1b1: 0x7b, 0x1b2: 0x67, 0x1b3: 0x7c, 0x1b4: 0x7d, 0x1b5: 0x7e, 0x1b6: 0x7f, 0x1b7: 0x80,
	0x1b8: 0x81, 0x1b9: 0x82,
	// Block 0x7, offset 0x1c0
	0x1c0: 0x83, 0x1c1: 0x4a, 0x1c2: 0x84, 0x1c3: 0x85, 0x1c4: 0x86, 0x1c5: 0x19, 0x1c6: 0x87, 0x1c7: 0x88,
	0x1d0: 0x19, 0x1d1: 0x19, 0x1d2: 0x19, 0x1d3: 0x19, 0x1d4: 0x19, 0x1d5: 0x19, 0x1d6: 0x19, 0x1d7: 0x19,
	0x1d8: 0x19, 0x1d9: 0x19, 0x1da: 0x19, 0x1db: 0x19, 0x1dc: 0x19, 0x1dd: 0x19, 0x1de: 0x19, 0x1df: 0x19,
	0x1e0: 0x19, 0x1e1: 0x19, 0x1e2: 0x19, 0x1e3: 0x19, 0x1e4: 0x19, 0x1e5: 0x19, 0x1e6: 0x19, 0x1e7: 0x19,
	0x1e8: 0x19, 0x1e9: 0x19, 0x1ea: 0x19, 0x1eb: 0x19, 0x1ec: 0x19, 0x1ed: 0x19, 0x1ee: 0x19, 0x1ef: 0x19,
	0x1f0: 0x19, 0x1f1: 0x19, 0x1f2: 0x19, 0x1f3: 0x19, 0x1f4: 0x19, 0x1f5: 0x19, 0x1f6: 0x19, 0x1f7: 0x19,
	0x1f8: 0x19, 0x1f9: 0x19, 0x1fa: 0x19, 0x1fb: 0x19, 0x1fc: 0x19, 0x1fd: 0x19, 0x1fe: 0x19, 0x1ff: 0x19,
	// Block 0x8, offset 0x200
	0x200: 0x19, 0x201: 0x19, 0x202: 0x19, 0x203: 0x19, 0x204: 0x19, 0x205: 0x19, 0x206: 0x19, 0x207: 0x19,
	0x208: 0x19, 0x209: 0x19, 0x20a: 0x19, 0x20b: 0x19, 0x20c: 0x19, 0x20d: 0x19, 0x20e: 0x19, 0x20f: 0x19,
	0x210: 0x19, 0x211: 0x19, 0x212: 0x19, 0x213: 0x19, 0x214: 0x19, 0x215: 0x19, 0x216: 0x19, 0x217: 0x19,
	0x218: 0x19, 0x219: 0x19, 0x21a: 0x19, 0x21b: 0x19, 0x21c: 0x19, 0x21d: 0x19, 0x21e: 0x19, 0x21f: 0x19,
	0x220: 0x19, 0x221: 0x19, 0x222: 0x19, 0x223: 0x19, 0x224: 0x19, 0x225: 0x19, 0x226: 0x19, 0x227: 0x19,
	0x228: 0x19, 0x229: 0x19, 0x22a: 0x19, 0x22b: 0x19, 0x22c: 0x19, 0x22d: 0x19, 0x22e: 0x19, 0x22f: 0x19,
	0x230: 0x19, 0x231: 0x19, 0x232: 0x19, 0x233: 0x19, 0x234: 0x19, 0x235: 0x19, 0x236: 0x19,
	0x238: 0x19, 0x239: 0x19, 0x23a: 0x19, 0x23b: 0x19, 0x23c: 0x19, 0x23d: 0x19, 0x23e: 0x19, 0x23f: 0x19,
	// Block 0x9, offset 0x240
	0x240: 0x19, 0x241: 0x19, 0x242: 0x19, 0x243: 0x19, 0x244: 0x19, 0x245: 0x19, 0x246: 0x19, 0x247: 0x19,
	0x248: 0x19, 0x249: 0x19, 0x24a: 0x19, 0x24b: 0x19, 0x24c: 0x19, 0x24d: 0x19, 0x24e: 0x19, 0x24f: 0x19,
	0x250: 0x19, 0x251: 0x19, 0x252: 0x19, 0x253: 0x19, 0x254: 0x19, 0x255: 0x19, 0x256: 0x19, 0x257: 0x19,
	0x258: 0x19, 0x259: 0x19, 0x25a: 0x19, 0x25b: 0x19, 0x25c: 0x19, 0x25d: 0x19, 0x25e: 0x19, 0x25f: 0x19,
	0x260: 0x19, 0x261: 0x19, 0x262: 0x19, 0x263: 0x19, 0x264: 0x19, 0x265: 0x19, 0x266: 0x19, 0x267: 0x19,
	0x268: 0x19, 0x269: 0x19, 0x26a: 0x19, 0x26b: 0x19, 0x26c: 0x19, 0x26d: 0x19, 0x26e: 0x19, 0x26f: 0x19,
	0x270: 0x19, 0x271: 0x19, 0x272: 0x19, 0x273: 0x19, 0x274: 0x19, 0x275: 0x19, 0x276: 0x19, 0x277: 0x19,
	0x278: 0x19, 0x279: 0x19, 0x27a: 0x19, 0x27b: 0x19, 0x27c: 0x19, 0x27d: 0x19, 0x27e: 0x19, 0x27f: 0x19,
	// Block 0xa, offset 0x280
	0x280: 0x19, 0x281: 0x19, 0x282: 0x19, 0x283: 0x19, 0x284: 0x19, 0x285: 0x19, 0x286: 0x19, 0x287: 0x19,
	0x288: 0x19, 0x289: 0x19, 0x28a: 0x19, 0x28b: 0x19, 0x28c: 0x19, 0x28d: 0x19, 0x28e: 0x19, 0x28f: 0x19,
	0x290: 0x19, 0x291: 0x19, 0x292: 0x89, 0x293: 0x8a, 0x294: 0x19, 0x295: 0x19, 0x296: 0x19, 0x297: 0x19,
	0x298: 0x8b, 0x299: 0x8c, 0x29a: 0x8d, 0x29b: 0x8e, 0x29c: 0x8f, 0x29d: 0x90, 0x29e: 0x91, 0x29f: 0x92,
	0x2a0: 0x93, 0x2a1: 0x94, 0x2a2: 0x95, 0x2a3: 0x96, 0x2a4: 0x97, 0x2a5: 0x98, 0x2a6: 0x99, 0x2a7: 0x9a,
	0x2a8: 0x9b, 0x2a9: 0x9c, 0x2aa: 0x9d, 0x2ab: 0x9e, 0x2ac: 0x9f, 0x2ad: 0xa0, 0x2ae: 0x66, 0x2af: 0xa1,
	0x2b0: 0x19, 0x2b1: 0x19, 0x2b2: 0x19, 0x2b3: 0x19, 0x2b4: 0x19, 0x2b5: 0x19, 0x2b6: 0x19, 0x2b7: 0x19,
	0x2b8: 0x19, 0x2b9: 0x19, 0x2ba: 0x19, 0x2bb: 0x19, 0x2bc: 0x19, 0x2bd: 0x19, 0x2be: 0x19, 0x2bf: 0x19,
	// Block 0xb, offset 0x2c0
	0x2c0: 0x19, 0x2c1: 0x19, 0x2c2: 0x19, 0x2c3: 0x19, 0x2c4: 0x19, 0x2c5: 0x19, 0x2c6: 0x19, 0x2c7: 0x19,
	0x2c8: 0x19, 0x2c9: 0x19, 0x2ca: 0x19, 0x2cb: 0x19, 0x2cc: 0x19, 0x2cd: 0x19, 0x2ce: 0x19, 0x2cf: 0x19,
	0x2d0: 0x19, 0x2d1: 0x19, 0x2d2: 0x19, 0x2d3: 0x19, 0x2d4: 0x19, 0x2d5: 0x19, 0x2d6: 0x19, 0x2d7: 0x19,
	0x2d8: 0x19, 0x2d9: 0x19, 0x2da: 0x19, 0x2db: 0x19, 0x2dc: 0x19, 0x2dd: 0x19, 0x2de: 0xa2, 0x2df: 0xa3,
	// Block 0xc, offset 0x300
	0x324: 0x19, 0x325: 0x19, 0x326: 0x19, 0x327: 0x19,
	0x328: 0x19, 0x329: 0xa4, 0x32a: 0x19, 0x32b: 0xa5, 0x32c: 0xa6, 0x32d: 0xa7, 0x32e: 0xa8, 0x32f: 0xa9,
	0x330: 0x19, 0x331: 0x19, 0x332: 0x19, 0x333: 0x19, 0x334: 0xaa, 0x335: 0xab, 0x336: 0xac, 0x337: 0xad,
	0x338: 0xae, 0x339: 0xaf, 0x33a: 0x19, 0x33b: 0xb0, 0x33c: 0xb1, 0x33d: 0xb2, 0x33e: 0xb3, 0x33f: 0xb4,
	// Block 0xd, offset 0x340
	0x340: 0xb5, 0x341: 0xb6, 0x342: 0x19, 0x343: 0xb7, 0x345: 0xb8, 0x347: 0xb9,
	0x34a: 0xba, 0x34b: 0xbb, 0x34c: 0xbc, 0x34d: 0xbd, 0x34e: 0xbe, 0x34f: 0xbf,
	0x350: 0xc0, 0x351: 0xc1, 0x352: 0xc2, 0x353: 0xc3, 0x354: 0xc4, 0x355: 0xc5, 0x356: 0xc6,
	0x358: 0x19, 0x359: 0x19, 0x35a: 0x19, 0x35b: 0x19, 0x35c: 0xc7, 0x35d: 0xc8, 0x35e: 0xc9,
	0x360: 0xca, 0x361: 0xcb, 0x362: 0xcc, 0x363: 0xcd, 0x364: 0xce, 0x366: 0xcf,
	0x368: 0xd0, 0x369: 0xd1, 0x36a: 0xd2, 0x36b: 0xd3, 0x36c: 0x55, 0x36d: 0xd4, 0x36e: 0xd5,
	0x370: 0x19, 0x371: 0xd6, 0x372: 0xd7, 0x373: 0xd8, 0x374: 0xd9,
	0x37a: 0xda, 0x37b: 0xdb, 0x37c: 0xdc, 0x37d: 0xdd, 0x37e: 0xde, 0x37f: 0xdf,
	// Block 0xe, offset 0x380
	0x380: 0xe0, 0x381: 0xe1, 0x382: 0xe2, 0x383: 0xe3, 0x384: 0xe4, 0x385: 0xe5, 0x386: 0xe6, 0x387: 0xe7,
	0x388: 0xe8, 0x389: 0xe9, 0x38a: 0xea, 0x38b: 0xeb, 0x38c: 0xec, 0x38d: 0xed,
	0x390: 0xee, 0x391: 0xef, 0x392: 0xf0, 0x393: 0xf1, 0x396: 0xf2, 0x397: 0xf3,
	0x398: 0xf0, 0x399: 0xf4, 0x39a: 0xf5, 0x39b: 0xf6, 0x39c: 0xf7, 0x39d: 0xf8,
	0x3a0: 0xf9, 0x3a2: 0xfa, 0x3a3: 0xfb, 0x3a4: 0xfc, 0x3a5: 0xfd, 0x3a6: 0xfe, 0x3a7: 0xff,
	0x3a8: 0x100, 0x3a9: 0x101, 0x3aa: 0x102, 0x3ab: 0x53,
	0x3b0: 0x103, 0x3b1: 0x104, 0x3b2: 0x105, 0x3b4: 0x106, 0x3b5: 0x107, 0x3b6: 0x108,
	0x3bb: 0x109, 0x3bc: 0x10a, 0x3bd: 0x10b, 0x3be: 0x10c,
	// Block 0xf, offset 0x3c0
	0x3c0: 0x19, 0x3c1: 0x19, 0x3c2: 0x19, 0x3c3: 0x19, 0x3c4: 0x19, 0x3c5: 0x19, 0x3c6: 0x19, 0x3c7: 0x19,
	0x3c8: 0x19, 0x3c9: 0x19, 0x3ca: 0x19, 0x3cb: 0x19, 0x3cc: 0x19, 0x3cd: 0x19, 0x3ce: 0xa5,
	0x3d0: 0x19, 0x3d1: 0x10d, 0x3d2: 0x19, 0x3d3: 0x19, 0x3d4: 0x19, 0x3d5: 0x10e,
	0x3fe: 0xab, 0x3ff: 0x10f,
	// Block 0x10, offset 0x400
	0x400: 0x19, 0x401: 0x19, 0x402: 0x19, 0x403: 0x19, 0x404: 0x19, 0x405: 0x19, 0x406: 0x19, 0x407: 0x19,
	0x408: 0x19, 0x409: 0x19, 0x40a: 0x19, 0x40b: 0x19, 0x40c: 0x19, 0x40d: 0x19, 0x40e: 0x19, 0x40f: 0x19,
	0x410: 0x110, 0x411: 0x111,
	// Block 0x11, offset 0x440
	0x450: 0x19, 0x451: 0x19, 0x452: 0x19, 0x453: 0x19, 0x454: 0x19, 0x455: 0x19, 0x456: 0x19, 0x457: 0x19,
	0x458: 0x19, 0x459: 0xf8,
	// Block 0x12, offset 0x480
	0x4a0: 0x19, 0x4a1: 0x19, 0x4a2: 0x19, 0x4a3: 0x19, 0x4a4: 0x19, 0x4a5: 0x19, 0x4a6: 0x19, 0x4a7: 0x19,
	0x4a8: 0x53, 0x4a9: 0x112, 0x4aa: 0x113, 0x4ab: 0x114, 0x4ac: 0x115, 0x4ad: 0x116, 0x4ae: 0x117,
	0x4b9: 0x118, 0x4ba: 0x119, 0x4bc: 0x19, 0x4bd: 0x11a, 0x4be: 0x11b, 0x4bf: 0x11c,
	// Block 0x13, offset 0x4c0
	0x4c0: 0x19, 0x4c1: 0x19, 0x4c2: 0x19, 0x4c3: 0x19, 0x4c4: 0x19, 0x4c5: 0x19, 0x4c6: 0x19, 0x4c7: 0x19,
	0x4c8: 0x19, 0x4c9: 0x19, 0x4ca: 0x19, 0x4cb: 0x19, 0x4cc: 0x19, 0x4cd: 0x19, 0x4ce: 0x19, 0x4cf: 0x19,
	0x4d0: 0x19, 0x4d1: 0x19, 0x4d2: 0x19, 0x4d3: 0x19, 0x4d4: 0x19, 0x4d5: 0x19, 0x4d6: 0x19, 0x4d7: 0x19,
	0x4d8: 0x19, 0x4d9: 0x19, 0x4da: 0x19, 0x4db: 0x19, 0x4dc: 0x19, 0x4dd: 0x19, 0x4de: 0x19, 0x4df: 0x11d,
	0x4e0: 0x19, 0x4e1: 0x19, 0x4e2: 0x19, 0x4e3: 0x19, 0x4e4: 0x19, 0x4e5: 0x19, 0x4e6: 0x19, 0x4e7: 0x19,
	0x4e8: 0x19, 0x4e9: 0x19, 0x4ea: 0x19, 0x4eb: 0x19, 0x4ec: 0x19, 0x4ed: 0x19, 0x4ee: 0x19, 0x4ef: 0x19,
	0x4f0: 0x19, 0x4f1: 0x19, 0x4f2: 0x19, 0x4f3: 0x11e, 0x4f4: 0xd6,
	// Block 0x14, offset 0x500
	0x53f: 0x11f,
	// Block 0x15, offset 0x540
	0x540: 0x19, 0x541: 0x19, 0x542: 0x19, 0x543: 0x19, 0x544: 0x120, 0x545: 0x121, 0x546: 0x19, 0x547: 0x19,
	0x548: 0x19, 0x549: 0x19, 0x54a: 0x19, 0x54b: 0x122,
	0x570: 0x19, 0x571: 0x123, 0x572: 0x124,
	// Block 0x16, offset 0x580
	0x5bc: 0x125, 0x5bd: 0x126,
	// Block 0x17, offset 0x5c0
	0x5c5: 0x127, 0x5c6: 0x128,
	0x5c9: 0x129,
	0x5d0: 0x12a, 0x5d1: 0x12b, 0x5d2: 0x12c, 0x5d3: 0x12d, 0x5d4: 0x12e, 0x5d5: 0x12f, 0x5d6: 0x130, 0x5d7: 0x131,
	0x5d8: 0x132, 0x5d9: 0x133, 0x5da: 0x134, 0x5db: 0x135, 0x5dc: 0x136, 0x5dd: 0x137, 0x5de: 0x138, 0x5df: 0x139,
	0x5e8: 0x13a, 0x5e9: 0x13b, 0x5ea: 0x13c,
	0x5fc: 0x13d,
	// Block 0x18, offset 0x600
	0x600: 0x13e, 0x601: 0x13f, 0x602: 0x140, 0x604: 0x141, 0x605: 0x142,
	0x60a: 0x143, 0x60b: 0x144,
	0x613: 0x145,
	0x61f: 0x146,
	0x620: 0x19, 0x621: 0x19, 0x622: 0x19, 0x623: 0x147, 0x624: 0x148, 0x625: 0x149,
	0x638: 0x14a, 0x639: 0x14b, 0x63a: 0x14c,
	// Block 0x19, offset 0x640
	0x644: 0x14d, 0x645: 0x14e, 0x646: 0x14f,
	0x659: 0x150,
	0x66f: 0x151,
	// Block 0x1a, offset 0x680
	0x680: 0x19, 0x681: 0x19, 0x682: 0x19, 0x683: 0x19, 0x684: 0x19, 0x685: 0x19, 0x686: 0x19, 0x687: 0x19,
	0x688: 0x19, 0x689: 0x19, 0x68a: 0x19, 0x68b: 0x19, 0x68c: 0x19, 0x68d: 0x19, 0x68e: 0x19, 0x68f: 0x19,
	0x690: 0x19, 0x691: 0x19, 0x692: 0x19, 0x693: 0x19, 0x694: 0x19, 0x695: 0x19, 0x696: 0x19, 0x697: 0x19,
	0x698: 0x19, 0x699: 0x19, 0x69a: 0x19, 0x69b: 0x152, 0x69c: 0x19, 0x69d: 0x19, 0x69e: 0x19, 0x69f: 0x19,
	0x6a0: 0x19, 0x6a1: 0x19, 0x6a2: 0x19, 0x6a3: 0x19, 0x6a4: 0x19, 0x6a5: 0x19, 0x6a6: 0x19, 0x6a7: 0x19,
	0x6a8: 0x19, 0x6a9: 0x19, 0x6aa: 0x19, 0x6ab: 0x19, 0x6ac: 0x19, 0x6ad: 0x19, 0x6ae: 0x19, 0x6af: 0x19,
	0x6b0: 0x19, 0x6b1: 0x19, 0x6b2: 0x19, 0x6b3: 0x19, 0x6b4: 0x19, 0x6b5: 0x19, 0x6b6: 0x19, 0x6b7: 0x19,
	0x6b8: 0x19, 0x6b9: 0x19, 0x6ba: 0x19, 0x6bb: 0x19, 0x6bc: 0x19, 0x6bd: 0x19, 0x6be: 0x19, 0x6bf: 0x19,
	// Block 0x1b, offset 0x6c0
	0x6c0: 0x19, 0x6c1: 0x19, 0x6c2: 0x19, 0x6c3: 0x19, 0x6c4: 0x19, 0x6c5: 0x19, 0x6c6: 0x19, 0x6c7: 0x19,
	0x6c8: 0x19, 0x6c9: 0x19, 0x6ca: 0x19, 0x6cb: 0x19, 0x6cc: 0x19, 0x6cd: 0x19, 0x6ce: 0x19, 0x6cf: 0x19,
	0x6d0: 0x19, 0x6d1: 0x19, 0x6d2: 0x19, 0x6d3: 0x19, 0x6d4: 0x19, 0x6d5: 0x19, 0x6d6: 0x19, 0x6d7: 0x19,
	0x6d8: 0x19, 0x6d9: 0x19, 0x6da: 0x19, 0x6db: 0x19, 0x6dc: 0x153, 0x6dd: 0x19, 0x6de: 0x19, 0x6df: 0x19,
	0x6e0: 0xbe, 0x6e1: 0x19, 0x6e2: 0x19, 0x6e3: 0x19, 0x6e4: 0x19, 0x6e5: 0x19, 0x6e6: 0x19, 0x6e7: 0x19,
	0x6e8: 0x19, 0x6e9: 0x19, 0x6ea: 0x19, 0x6eb: 0x19, 0x6ec: 0x19, 0x6ed: 0x19, 0x6ee: 0x19, 0x6ef: 0x19,
	0x6f0: 0x19, 0x6f1: 0x19, 0x6f2: 0x19, 0x6f3: 0x19, 0x6f4: 0x19, 0x6f5: 0x19, 0x6f6: 0x19, 0x6f7: 0x19,
	0x6f8: 0x19, 0x6f9: 0x19, 0x6fa: 0x19, 0x6fb: 0x19, 0x6fc: 0x19, 0x6fd: 0x19, 0x6fe: 0x19, 0x6ff: 0x19,
	// Block 0x1c, offset 0x700
	0x700: 0x19, 0x701: 0x19, 0x702: 0x19, 0x703: 0x19, 0x704: 0x19, 0x705: 0x19, 0x706: 0x19, 0x707: 0x19,
	0x708: 0x19, 0x709: 0x19, 0x70a: 0x19, 0x70b: 0x19, 0x70c: 0x19, 0x70d: 0x19, 0x70e: 0x19, 0x70f: 0x19,
	0x710: 0x19, 0x711: 0x19, 0x712: 0x19, 0x713: 0x19, 0x714: 0x19, 0x715: 0x19, 0x716: 0x19, 0x717: 0x19,
	0x718: 0x19, 0x719: 0x19, 0x71a: 0x19, 0x71b: 0x19, 0x71c: 0x19, 0x71d: 0x19, 0x71e: 0x19, 0x71f: 0x19,
	0x720: 0x19, 0x721: 0x19, 0x722: 0x19, 0x723: 0x19, 0x724: 0x19, 0x725: 0x19, 0x726: 0x19, 0x727: 0x19,
	0x728: 0x19, 0x729: 0x19, 0x72a: 0x19, 0x72b: 0x19, 0x72c: 0x19, 0x72d: 0x19, 0x72e: 0x19, 0x72f: 0x19,
	0x730: 0x19, 0x731: 0x19, 0x732: 0x19, 0x733: 0x19, 0x734: 0x19, 0x735: 0x19, 0x736: 0x19, 0x737: 0x19,
	0x738: 0x19, 0x739: 0x19, 0x73a: 0x154, 0x73b: 0x19, 0x73c: 0x19, 0x73d: 0x19, 0x73e: 0x19, 0x73f: 0x19,
	// Block 0x1d, offset 0x740
	0x740: 0x19, 0x741: 0x19, 0x742: 0x19, 0x743: 0x19, 0x744: 0x19, 0x745: 0x19, 0x746: 0x19, 0x747: 0x19,
	0x748: 0x19, 0x749: 0x19, 0x74a: 0x19, 0x74b: 0x19, 0x74c: 0x19, 0x74d: 0x19, 0x74e: 0x19, 0x74f: 0x19,
	0x750: 0x19, 0x751: 0x19, 0x752: 0x19, 0x753: 0x19, 0x754: 0x19, 0x755: 0x19, 0x756: 0x19, 0x757: 0x19,
	0x758: 0x19, 0x759: 0x19, 0x75a: 0x19, 0x75b: 0x19, 0x75c: 0x19, 0x75d: 0x19, 0x75e: 0x19, 0x75f: 0x19,
	0x760: 0x19, 0x761: 0x19, 0x762: 0x19, 0x763: 0x19, 0x764: 0x19, 0x765: 0x19, 0x766: 0x19, 0x767: 0x19,
	0x768: 0x19, 0x769: 0x19, 0x76a: 0x19, 0x76b: 0x19, 0x76c: 0x19, 0x76d: 0x19, 0x76e: 0x19, 0x76f: 0x155,
	// Block 0x1e, offset 0x780
	0x7a0: 0x19, 0x7a1: 0x19, 0x7a2: 0x19, 0x7a3: 0x19, 0x7a4: 0x19, 0x7a5: 0x19, 0x7a6: 0x19, 0x7a7: 0x19,
	0x7a8: 0x156,
	// Block 0x1f, offset 0x7c0
	0x7c0: 0x19, 0x7c1: 0x19, 0x7c2: 0x19, 0x7c3: 0x19, 0x7c4: 0x19, 0x7c5: 0x19, 0x7c6: 0x19, 0x7c7: 0x19,
	0x7c8: 0x19, 0x7c9: 0x19, 0x7ca: 0x19, 0x7cb: 0x19, 0x7cc: 0x19, 0x7cd: 0x157, 0x7ce: 0x19, 0x7cf: 0x19,
	0x7d0: 0x19, 0x7d1: 0x19, 0x7d2: 0x19, 0x7d3: 0x19, 0x7d4: 0x19, 0x7d5: 0x19, 0x7d6: 0x19, 0x7d7: 0x19,
	0x7d8: 0x19, 0x7d9: 0x19, 0x7da: 0x19, 0x7db: 0x19, 0x7dc: 0x19, 0x7dd: 0x19, 0x7de: 0x19, 0x7df: 0x19,
	0x7e0: 0x19, 0x7e1: 0x19, 0x7e2: 0x19, 0x7e3: 0x19, 0x7e4: 0x19, 0x7e5: 0x19, 0x7e6: 0x19, 0x7e7: 0x19,
	0x7e8: 0x19, 0x7e9: 0x19, 0x7ea: 0x19, 0x7eb: 0x19, 0x7ec: 0x19, 0x7ed: 0x19, 0x7ee: 0x19, 0x7ef: 0x19,
	0x7f0: 0x19, 0x7f1: 0x19, 0x7f2: 0x19, 0x7f3: 0x19, 0x7f4: 0x19, 0x7f5: 0x19, 0x7f6: 0x19, 0x7f7: 0x19,
	0x7f8: 0x19, 0x7f9: 0x19, 0x7fa: 0x19, 0x7fb: 0x19, 0x7fc: 0x19, 0x7fd: 0x19, 0x7fe: 0x19, 0x7ff: 0x19,
	// Block 0x20, offset 0x800
	0x800: 0x19, 0x801: 0x19, 0x802: 0x19, 0x803: 0x19, 0x804: 0x19, 0x805: 0x19, 0x806: 0x19, 0x807: 0x19,
	0x808: 0x19, 0x809: 0x19, 0x80a: 0x19, 0x80b: 0x19, 0x80c: 0x19, 0x80d: 0x19, 0x80e: 0x158,
	// Block 0x21, offset 0x840
	0x850: 0x0b, 0x851: 0x0c, 0x852: 0x0d, 0x853: 0x0e, 0x854: 0x0f, 0x856: 0x10, 0x857: 0x07,
	0x858: 0x11, 0x85a: 0x12, 0x85b: 0x13, 0x85c: 0x14, 0x85d: 0x15, 0x85e: 0x16, 0x85f: 0x17,
	0x860: 0x07, 0x861: 0x07, 0x862: 0x07, 0x863: 0x07, 0x864: 0x07, 0x865: 0x07, 0x866: 0x07, 0x867: 0x07,
	0x868: 0x07, 0x869: 0x07, 0x86a: 0x18, 0x86b: 0x19, 0x86c: 0x1a, 0x86d: 0x07, 0x86e: 0x1b, 0x86f: 0x1c,
	0x870: 0x07, 0x871: 0x1d, 0x872: 0x1e,
	// Block 0x22, offset 0x880
	0x880: 0x159, 0x881: 0x0b, 0x884: 0x0b, 0x885: 0x0b, 0x886: 0x0b, 0x887: 0x15a,
	// Block 0x23, offset 0x8c0
	0x8e0: 0x20,
}
