/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { HOST, NEXT, PARENT, T_HOST, TRANSPLANTED_VIEWS_TO_REFRESH } from './view';
/**
 * Special location which allows easy identification of type. If we have an array which was
 * retrieved from the `LView` and that array has `true` at `TYPE` location, we know it is
 * `LContainer`.
 */
export const TYPE = 1;
/**
 * Below are constants for LContainer indices to help us look up LContainer members
 * without having to remember the specific indices.
 * Uglify will inline these when minifying so there shouldn't be a cost.
 */
/**
 * Flag to signify that this `LContainer` may have transplanted views which need to be change
 * detected. (see: `LView[DECLARATION_COMPONENT_VIEW])`.
 *
 * This flag, once set, is never unset for the `LContainer`. This means that when unset we can skip
 * a lot of work in `refreshEmbeddedViews`. But when set we still need to verify
 * that the `MOVED_VIEWS` are transplanted and on-push.
 */
export const HAS_TRANSPLANTED_VIEWS = 2;
// PARENT, NEXT, TRANSPLANTED_VIEWS_TO_REFRESH are indices 3, 4, and 5
// As we already have these constants in LView, we don't need to re-create them.
// T_HOST is index 6
// We already have this constants in LView, we don't need to re-create it.
export const NATIVE = 7;
export const VIEW_REFS = 8;
export const MOVED_VIEWS = 9;
/**
 * Size of LContainer's header. Represents the index after which all views in the
 * container will be inserted. We need to keep a record of current views so we know
 * which views are already in the DOM (and don't need to be re-added) and so we can
 * remove views from the DOM when they are no longer required.
 */
export const CONTAINER_HEADER_OFFSET = 10;
// Note: This hack is necessary so we don't erroneously get a circular dependency
// failure based on types.
export const unusedValueExportToPlacateAjd = 1;
//# sourceMappingURL=data:application/json;base64,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