typedef __SIZE_TYPE__ size_t;
#ifdef __cplusplus
extern "C" {
#endif
  extern void exit (int);
  extern void *malloc (size_t);
  extern void free (void *);
  extern void *calloc (size_t, size_t);
  extern void *alloca (size_t);
  extern void *memcpy (void *, const void *, size_t);
  extern void *memset (void *, int, size_t);
  extern char *strcpy (char *, const char *);
  extern char *strdup (const char *);
  extern char *strndup (const char *, size_t);
#ifdef __cplusplus
}
#endif

unsigned nfails = 0;

#define FAIL() \
  do { \
    __builtin_printf ("Failure at line: %d\n", __LINE__);		      \
    nfails++;								      \
  } while (0)

#define DONE() \
  do {									      \
    if (nfails > 0)							      \
      __builtin_abort ();						      \
    return 0;								      \
  } while (0)

#define EXPECT(p, _v) do {						      \
  size_t v = _v;							      \
  if (p == v)								      \
    __builtin_printf ("ok:  %s == %zd\n", #p, p);			      \
  else									      \
    {									      \
      __builtin_printf ("WAT: %s == %zd (expected %zd)\n", #p, p, v);	      \
      FAIL ();								      \
    }									      \
} while (0);
