use rstest::rstest;
use time::Month::*;
use time::{util, Month};

#[rstest]
#[case(2019, January, 31)]
#[case(2019, February, 28)]
#[case(2019, March, 31)]
#[case(2019, April, 30)]
#[case(2019, May, 31)]
#[case(2019, June, 30)]
#[case(2019, July, 31)]
#[case(2019, August, 31)]
#[case(2019, September, 30)]
#[case(2019, October, 31)]
#[case(2019, November, 30)]
#[case(2019, December, 31)]
#[case(2020, January, 31)]
#[case(2020, February, 29)]
#[case(2020, March, 31)]
#[case(2020, April, 30)]
#[case(2020, May, 31)]
#[case(2020, June, 30)]
#[case(2020, July, 31)]
#[case(2020, August, 31)]
#[case(2020, September, 30)]
#[case(2020, October, 31)]
#[case(2020, November, 30)]
#[case(2020, December, 31)]
fn days_in_year_month(#[case] year: i32, #[case] month: Month, #[case] expected: u8) {
    #[expect(deprecated)]
    {
        assert_eq!(util::days_in_year_month(year, month), expected);
    }
}

#[rstest]
#[case(0, true)]
#[case(1, false)]
#[case(2, false)]
#[case(3, false)]
#[case(4, true)]
#[case(5, false)]
#[case(6, false)]
#[case(7, false)]
#[case(8, true)]
#[case(9, false)]
#[case(10, false)]
#[case(11, false)]
#[case(12, true)]
#[case(13, false)]
#[case(14, false)]
#[case(15, false)]
#[case(16, true)]
#[case(17, false)]
#[case(18, false)]
#[case(19, false)]
#[case(20, true)]
#[case(21, false)]
#[case(22, false)]
#[case(23, false)]
#[case(24, true)]
#[case(25, false)]
#[case(26, false)]
#[case(27, false)]
#[case(28, true)]
#[case(29, false)]
#[case(30, false)]
#[case(31, false)]
#[case(32, true)]
#[case(33, false)]
#[case(34, false)]
#[case(35, false)]
#[case(36, true)]
#[case(37, false)]
#[case(38, false)]
#[case(39, false)]
#[case(40, true)]
#[case(41, false)]
#[case(42, false)]
#[case(43, false)]
#[case(44, true)]
#[case(45, false)]
#[case(46, false)]
#[case(47, false)]
#[case(48, true)]
#[case(49, false)]
#[case(50, false)]
#[case(51, false)]
#[case(52, true)]
#[case(53, false)]
#[case(54, false)]
#[case(55, false)]
#[case(56, true)]
#[case(57, false)]
#[case(58, false)]
#[case(59, false)]
#[case(60, true)]
#[case(61, false)]
#[case(62, false)]
#[case(63, false)]
#[case(64, true)]
#[case(65, false)]
#[case(66, false)]
#[case(67, false)]
#[case(68, true)]
#[case(69, false)]
#[case(70, false)]
#[case(71, false)]
#[case(72, true)]
#[case(73, false)]
#[case(74, false)]
#[case(75, false)]
#[case(76, true)]
#[case(77, false)]
#[case(78, false)]
#[case(79, false)]
#[case(80, true)]
#[case(81, false)]
#[case(82, false)]
#[case(83, false)]
#[case(84, true)]
#[case(85, false)]
#[case(86, false)]
#[case(87, false)]
#[case(88, true)]
#[case(89, false)]
#[case(90, false)]
#[case(91, false)]
#[case(92, true)]
#[case(93, false)]
#[case(94, false)]
#[case(95, false)]
#[case(96, true)]
#[case(97, false)]
#[case(98, false)]
#[case(99, false)]
#[case(100, false)]
#[case(101, false)]
#[case(102, false)]
#[case(103, false)]
#[case(104, true)]
#[case(105, false)]
#[case(106, false)]
#[case(107, false)]
#[case(108, true)]
#[case(109, false)]
#[case(110, false)]
#[case(111, false)]
#[case(112, true)]
#[case(113, false)]
#[case(114, false)]
#[case(115, false)]
#[case(116, true)]
#[case(117, false)]
#[case(118, false)]
#[case(119, false)]
#[case(120, true)]
#[case(121, false)]
#[case(122, false)]
#[case(123, false)]
#[case(124, true)]
#[case(125, false)]
#[case(126, false)]
#[case(127, false)]
#[case(128, true)]
#[case(129, false)]
#[case(130, false)]
#[case(131, false)]
#[case(132, true)]
#[case(133, false)]
#[case(134, false)]
#[case(135, false)]
#[case(136, true)]
#[case(137, false)]
#[case(138, false)]
#[case(139, false)]
#[case(140, true)]
#[case(141, false)]
#[case(142, false)]
#[case(143, false)]
#[case(144, true)]
#[case(145, false)]
#[case(146, false)]
#[case(147, false)]
#[case(148, true)]
#[case(149, false)]
#[case(150, false)]
#[case(151, false)]
#[case(152, true)]
#[case(153, false)]
#[case(154, false)]
#[case(155, false)]
#[case(156, true)]
#[case(157, false)]
#[case(158, false)]
#[case(159, false)]
#[case(160, true)]
#[case(161, false)]
#[case(162, false)]
#[case(163, false)]
#[case(164, true)]
#[case(165, false)]
#[case(166, false)]
#[case(167, false)]
#[case(168, true)]
#[case(169, false)]
#[case(170, false)]
#[case(171, false)]
#[case(172, true)]
#[case(173, false)]
#[case(174, false)]
#[case(175, false)]
#[case(176, true)]
#[case(177, false)]
#[case(178, false)]
#[case(179, false)]
#[case(180, true)]
#[case(181, false)]
#[case(182, false)]
#[case(183, false)]
#[case(184, true)]
#[case(185, false)]
#[case(186, false)]
#[case(187, false)]
#[case(188, true)]
#[case(189, false)]
#[case(190, false)]
#[case(191, false)]
#[case(192, true)]
#[case(193, false)]
#[case(194, false)]
#[case(195, false)]
#[case(196, true)]
#[case(197, false)]
#[case(198, false)]
#[case(199, false)]
#[case(200, false)]
#[case(201, false)]
#[case(202, false)]
#[case(203, false)]
#[case(204, true)]
#[case(205, false)]
#[case(206, false)]
#[case(207, false)]
#[case(208, true)]
#[case(209, false)]
#[case(210, false)]
#[case(211, false)]
#[case(212, true)]
#[case(213, false)]
#[case(214, false)]
#[case(215, false)]
#[case(216, true)]
#[case(217, false)]
#[case(218, false)]
#[case(219, false)]
#[case(220, true)]
#[case(221, false)]
#[case(222, false)]
#[case(223, false)]
#[case(224, true)]
#[case(225, false)]
#[case(226, false)]
#[case(227, false)]
#[case(228, true)]
#[case(229, false)]
#[case(230, false)]
#[case(231, false)]
#[case(232, true)]
#[case(233, false)]
#[case(234, false)]
#[case(235, false)]
#[case(236, true)]
#[case(237, false)]
#[case(238, false)]
#[case(239, false)]
#[case(240, true)]
#[case(241, false)]
#[case(242, false)]
#[case(243, false)]
#[case(244, true)]
#[case(245, false)]
#[case(246, false)]
#[case(247, false)]
#[case(248, true)]
#[case(249, false)]
#[case(250, false)]
#[case(251, false)]
#[case(252, true)]
#[case(253, false)]
#[case(254, false)]
#[case(255, false)]
#[case(256, true)]
#[case(257, false)]
#[case(258, false)]
#[case(259, false)]
#[case(260, true)]
#[case(261, false)]
#[case(262, false)]
#[case(263, false)]
#[case(264, true)]
#[case(265, false)]
#[case(266, false)]
#[case(267, false)]
#[case(268, true)]
#[case(269, false)]
#[case(270, false)]
#[case(271, false)]
#[case(272, true)]
#[case(273, false)]
#[case(274, false)]
#[case(275, false)]
#[case(276, true)]
#[case(277, false)]
#[case(278, false)]
#[case(279, false)]
#[case(280, true)]
#[case(281, false)]
#[case(282, false)]
#[case(283, false)]
#[case(284, true)]
#[case(285, false)]
#[case(286, false)]
#[case(287, false)]
#[case(288, true)]
#[case(289, false)]
#[case(290, false)]
#[case(291, false)]
#[case(292, true)]
#[case(293, false)]
#[case(294, false)]
#[case(295, false)]
#[case(296, true)]
#[case(297, false)]
#[case(298, false)]
#[case(299, false)]
#[case(300, false)]
#[case(301, false)]
#[case(302, false)]
#[case(303, false)]
#[case(304, true)]
#[case(305, false)]
#[case(306, false)]
#[case(307, false)]
#[case(308, true)]
#[case(309, false)]
#[case(310, false)]
#[case(311, false)]
#[case(312, true)]
#[case(313, false)]
#[case(314, false)]
#[case(315, false)]
#[case(316, true)]
#[case(317, false)]
#[case(318, false)]
#[case(319, false)]
#[case(320, true)]
#[case(321, false)]
#[case(322, false)]
#[case(323, false)]
#[case(324, true)]
#[case(325, false)]
#[case(326, false)]
#[case(327, false)]
#[case(328, true)]
#[case(329, false)]
#[case(330, false)]
#[case(331, false)]
#[case(332, true)]
#[case(333, false)]
#[case(334, false)]
#[case(335, false)]
#[case(336, true)]
#[case(337, false)]
#[case(338, false)]
#[case(339, false)]
#[case(340, true)]
#[case(341, false)]
#[case(342, false)]
#[case(343, false)]
#[case(344, true)]
#[case(345, false)]
#[case(346, false)]
#[case(347, false)]
#[case(348, true)]
#[case(349, false)]
#[case(350, false)]
#[case(351, false)]
#[case(352, true)]
#[case(353, false)]
#[case(354, false)]
#[case(355, false)]
#[case(356, true)]
#[case(357, false)]
#[case(358, false)]
#[case(359, false)]
#[case(360, true)]
#[case(361, false)]
#[case(362, false)]
#[case(363, false)]
#[case(364, true)]
#[case(365, false)]
#[case(366, false)]
#[case(367, false)]
#[case(368, true)]
#[case(369, false)]
#[case(370, false)]
#[case(371, false)]
#[case(372, true)]
#[case(373, false)]
#[case(374, false)]
#[case(375, false)]
#[case(376, true)]
#[case(377, false)]
#[case(378, false)]
#[case(379, false)]
#[case(380, true)]
#[case(381, false)]
#[case(382, false)]
#[case(383, false)]
#[case(384, true)]
#[case(385, false)]
#[case(386, false)]
#[case(387, false)]
#[case(388, true)]
#[case(389, false)]
#[case(390, false)]
#[case(391, false)]
#[case(392, true)]
#[case(393, false)]
#[case(394, false)]
#[case(395, false)]
#[case(396, true)]
#[case(397, false)]
#[case(398, false)]
#[case(399, false)]
fn is_leap_year(#[case] year: i32, #[case] expected: bool) {
    assert_eq!(util::is_leap_year(year), expected, "year {year} failed");
}

#[rstest]
#[case(1900, 365)]
#[case(2000, 366)]
#[case(2004, 366)]
#[case(2005, 365)]
#[case(2100, 365)]
fn days_in_year(#[case] year: i32, #[case] expected: u16) {
    assert_eq!(util::days_in_year(year), expected);
}

#[rstest]
fn weeks_in_year() {
    let num_weeks_for_years = [
        52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52,
        52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52,
        52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52,
        52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52,
        52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52,
        52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52,
        52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52,
        53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52,
        53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52,
        53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 53,
        52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53,
        52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52,
        52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52,
        52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52,
        52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52,
        52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52,
        52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52, 52, 53, 52, 52, 52, 52, 52, 53, 52, 52, 52,
        52, 53, 52, 52, 52, 52, 52, 53, 52,
    ];

    for (year, &num_weeks) in (0..400).zip(&num_weeks_for_years) {
        assert_eq!(util::weeks_in_year(year), num_weeks);
    }
}

#[rstest]
#[expect(deprecated)]
fn local_offset_soundness() {
    use time::util::local_offset::*;

    // These functions no longer do anything so they always return `Sound`.
    assert_eq!(get_soundness(), Soundness::Sound);
    // Safety: This no longer has any safety requirements.
    unsafe { set_soundness(Soundness::Unsound) };
    assert_eq!(get_soundness(), Soundness::Sound);
    // Safety: See above.
    unsafe { set_soundness(Soundness::Sound) };
    assert_eq!(get_soundness(), Soundness::Sound);
}
