// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/scim_token.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SCIMToken struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id         string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_ExpireTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *SCIMToken) Reset() {
	*x = SCIMToken{}
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SCIMToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SCIMToken) ProtoMessage() {}

func (x *SCIMToken) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SCIMToken) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *SCIMToken) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *SCIMToken) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_ExpireTime
	}
	return nil
}

func (x *SCIMToken) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *SCIMToken) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *SCIMToken) SetExpireTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_ExpireTime = v
}

func (x *SCIMToken) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *SCIMToken) HasExpireTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ExpireTime != nil
}

func (x *SCIMToken) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

func (x *SCIMToken) ClearExpireTime() {
	x.xxx_hidden_ExpireTime = nil
}

type SCIMToken_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id         string
	CreateTime *timestamppb.Timestamp
	ExpireTime *timestamppb.Timestamp
}

func (b0 SCIMToken_builder) Build() *SCIMToken {
	m0 := &SCIMToken{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_ExpireTime = b.ExpireTime
	return m0
}

type CreateSCIMTokenRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ExpireTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=expire_time,json=expireTime,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *CreateSCIMTokenRequest) Reset() {
	*x = CreateSCIMTokenRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSCIMTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSCIMTokenRequest) ProtoMessage() {}

func (x *CreateSCIMTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateSCIMTokenRequest) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_ExpireTime
	}
	return nil
}

func (x *CreateSCIMTokenRequest) SetExpireTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_ExpireTime = v
}

func (x *CreateSCIMTokenRequest) HasExpireTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ExpireTime != nil
}

func (x *CreateSCIMTokenRequest) ClearExpireTime() {
	x.xxx_hidden_ExpireTime = nil
}

type CreateSCIMTokenRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The time until which the token should be valid.
	// Must be in the future. May be null for no expiry.
	ExpireTime *timestamppb.Timestamp
}

func (b0 CreateSCIMTokenRequest_builder) Build() *CreateSCIMTokenRequest {
	m0 := &CreateSCIMTokenRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ExpireTime = b.ExpireTime
	return m0
}

type CreateSCIMTokenResponse struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Token string                 `protobuf:"bytes,1,opt,name=token,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *CreateSCIMTokenResponse) Reset() {
	*x = CreateSCIMTokenResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSCIMTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSCIMTokenResponse) ProtoMessage() {}

func (x *CreateSCIMTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateSCIMTokenResponse) GetToken() string {
	if x != nil {
		return x.xxx_hidden_Token
	}
	return ""
}

func (x *CreateSCIMTokenResponse) SetToken(v string) {
	x.xxx_hidden_Token = v
}

type CreateSCIMTokenResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plaintext token to use for authentication.
	Token string
}

func (b0 CreateSCIMTokenResponse_builder) Build() *CreateSCIMTokenResponse {
	m0 := &CreateSCIMTokenResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Token = b.Token
	return m0
}

type ListSCIMTokensRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PageSize  uint32                 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                 `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse   bool                   `protobuf:"varint,3,opt,name=reverse,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListSCIMTokensRequest) Reset() {
	*x = ListSCIMTokensRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSCIMTokensRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSCIMTokensRequest) ProtoMessage() {}

func (x *ListSCIMTokensRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListSCIMTokensRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListSCIMTokensRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListSCIMTokensRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListSCIMTokensRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListSCIMTokensRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListSCIMTokensRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListSCIMTokensRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
}

func (b0 ListSCIMTokensRequest_builder) Build() *ListSCIMTokensRequest {
	m0 := &ListSCIMTokensRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListSCIMTokensResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Tokens        *[]*SCIMToken          `protobuf:"bytes,1,rep,name=tokens,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListSCIMTokensResponse) Reset() {
	*x = ListSCIMTokensResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSCIMTokensResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSCIMTokensResponse) ProtoMessage() {}

func (x *ListSCIMTokensResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListSCIMTokensResponse) GetTokens() []*SCIMToken {
	if x != nil {
		if x.xxx_hidden_Tokens != nil {
			return *x.xxx_hidden_Tokens
		}
	}
	return nil
}

func (x *ListSCIMTokensResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListSCIMTokensResponse) SetTokens(v []*SCIMToken) {
	x.xxx_hidden_Tokens = &v
}

func (x *ListSCIMTokensResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListSCIMTokensResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Tokens []*SCIMToken
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListSCIMTokensResponse_builder) Build() *ListSCIMTokensResponse {
	m0 := &ListSCIMTokensResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Tokens = &b.Tokens
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type DeleteSCIMTokenRequest struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_TokenId string                 `protobuf:"bytes,1,opt,name=token_id,json=tokenId,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *DeleteSCIMTokenRequest) Reset() {
	*x = DeleteSCIMTokenRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSCIMTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSCIMTokenRequest) ProtoMessage() {}

func (x *DeleteSCIMTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteSCIMTokenRequest) GetTokenId() string {
	if x != nil {
		return x.xxx_hidden_TokenId
	}
	return ""
}

func (x *DeleteSCIMTokenRequest) SetTokenId(v string) {
	x.xxx_hidden_TokenId = v
}

type DeleteSCIMTokenRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	TokenId string
}

func (b0 DeleteSCIMTokenRequest_builder) Build() *DeleteSCIMTokenRequest {
	m0 := &DeleteSCIMTokenRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_TokenId = b.TokenId
	return m0
}

type DeleteSCIMTokenResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteSCIMTokenResponse) Reset() {
	*x = DeleteSCIMTokenResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSCIMTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSCIMTokenResponse) ProtoMessage() {}

func (x *DeleteSCIMTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteSCIMTokenResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteSCIMTokenResponse_builder) Build() *DeleteSCIMTokenResponse {
	m0 := &DeleteSCIMTokenResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

var File_buf_alpha_registry_v1alpha1_scim_token_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_scim_token_proto_rawDesc = string([]byte{
	0x0a, 0x2c, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x73, 0x63,
	0x69, 0x6d, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x95, 0x01, 0x0a,
	0x09, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0x55, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x43,
	0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b,
	0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x2f, 0x0a, 0x17, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6d, 0x0a, 0x15,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x06, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x06,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x33,
	0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x49, 0x64, 0x22, 0x19, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x43, 0x49,
	0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0x94,
	0x03, 0x0a, 0x10, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x7c, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x43, 0x49,
	0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x43, 0x49, 0x4d, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x7e, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x73, 0x12, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02,
	0x01, 0x12, 0x81, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x43, 0x49, 0x4d,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x03, 0x90, 0x02, 0x02, 0x42, 0x9b, 0x02, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x42, 0x0e, 0x53, 0x63, 0x69, 0x6d, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67, 0x65, 0x6e,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x52, 0xaa, 0x02, 0x1b, 0x42,
	0x75, 0x66, 0x2e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1b, 0x42, 0x75, 0x66,
	0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c,
	0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02, 0x27, 0x42, 0x75, 0x66, 0x5c, 0x41,
	0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xea, 0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x3a,
	0x3a, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_buf_alpha_registry_v1alpha1_scim_token_proto_goTypes = []any{
	(*SCIMToken)(nil),               // 0: buf.alpha.registry.v1alpha1.SCIMToken
	(*CreateSCIMTokenRequest)(nil),  // 1: buf.alpha.registry.v1alpha1.CreateSCIMTokenRequest
	(*CreateSCIMTokenResponse)(nil), // 2: buf.alpha.registry.v1alpha1.CreateSCIMTokenResponse
	(*ListSCIMTokensRequest)(nil),   // 3: buf.alpha.registry.v1alpha1.ListSCIMTokensRequest
	(*ListSCIMTokensResponse)(nil),  // 4: buf.alpha.registry.v1alpha1.ListSCIMTokensResponse
	(*DeleteSCIMTokenRequest)(nil),  // 5: buf.alpha.registry.v1alpha1.DeleteSCIMTokenRequest
	(*DeleteSCIMTokenResponse)(nil), // 6: buf.alpha.registry.v1alpha1.DeleteSCIMTokenResponse
	(*timestamppb.Timestamp)(nil),   // 7: google.protobuf.Timestamp
}
var file_buf_alpha_registry_v1alpha1_scim_token_proto_depIdxs = []int32{
	7, // 0: buf.alpha.registry.v1alpha1.SCIMToken.create_time:type_name -> google.protobuf.Timestamp
	7, // 1: buf.alpha.registry.v1alpha1.SCIMToken.expire_time:type_name -> google.protobuf.Timestamp
	7, // 2: buf.alpha.registry.v1alpha1.CreateSCIMTokenRequest.expire_time:type_name -> google.protobuf.Timestamp
	0, // 3: buf.alpha.registry.v1alpha1.ListSCIMTokensResponse.tokens:type_name -> buf.alpha.registry.v1alpha1.SCIMToken
	1, // 4: buf.alpha.registry.v1alpha1.SCIMTokenService.CreateSCIMToken:input_type -> buf.alpha.registry.v1alpha1.CreateSCIMTokenRequest
	3, // 5: buf.alpha.registry.v1alpha1.SCIMTokenService.ListSCIMTokens:input_type -> buf.alpha.registry.v1alpha1.ListSCIMTokensRequest
	5, // 6: buf.alpha.registry.v1alpha1.SCIMTokenService.DeleteSCIMToken:input_type -> buf.alpha.registry.v1alpha1.DeleteSCIMTokenRequest
	2, // 7: buf.alpha.registry.v1alpha1.SCIMTokenService.CreateSCIMToken:output_type -> buf.alpha.registry.v1alpha1.CreateSCIMTokenResponse
	4, // 8: buf.alpha.registry.v1alpha1.SCIMTokenService.ListSCIMTokens:output_type -> buf.alpha.registry.v1alpha1.ListSCIMTokensResponse
	6, // 9: buf.alpha.registry.v1alpha1.SCIMTokenService.DeleteSCIMToken:output_type -> buf.alpha.registry.v1alpha1.DeleteSCIMTokenResponse
	7, // [7:10] is the sub-list for method output_type
	4, // [4:7] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_scim_token_proto_init() }
func file_buf_alpha_registry_v1alpha1_scim_token_proto_init() {
	if File_buf_alpha_registry_v1alpha1_scim_token_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_scim_token_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_scim_token_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_scim_token_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_scim_token_proto_depIdxs,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_scim_token_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_scim_token_proto = out.File
	file_buf_alpha_registry_v1alpha1_scim_token_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_scim_token_proto_depIdxs = nil
}
