// Package domain provides primitives to interact with the openapi HTTP API.
//
// Code generated by  version  DO NOT EDIT.
package domain

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"mime"
	"net/http"
	"net/url"
	"strings"

	"github.com/oapi-codegen/runtime"
)

// Doer performs HTTP requests.
//
// The standard http.Client implements this interface.
type HTTPRequestDoer interface {
	Do(req *http.Request) (*http.Response, error)
}

// Client which conforms to the OpenAPI3 specification for this service.
type Client struct {
	// The endpoint of the server conforming to this interface, with scheme,
	// https://api.deepmap.com for example. This can contain a path relative
	// to the server, such as https://api.deepmap.com/dev-test, and all the
	// paths in the swagger spec will be appended to the server.
	Server string

	// Server + /api/v2/
	APIEndpoint string

	// Doer for performing requests, typically a *http.Client with any
	// customized settings, such as certificate chains.
	Client HTTPRequestDoer
}

// Creates a new Client, with reasonable defaults
func NewClient(server string, doer HTTPRequestDoer) (*Client, error) {
	// create a client with sane default values
	client := Client{
		Server: server,
		Client: doer,
	}
	// ensure the server URL always has a trailing slash
	if !strings.HasSuffix(client.Server, "/") {
		client.Server += "/"
	}
	// API endpoint
	client.APIEndpoint = client.Server + "api/v2/"

	// create httpClient, if not already present
	if client.Client == nil {
		client.Client = &http.Client{}
	}
	return &client, nil
}

func (e *Error) Error() error {
	return fmt.Errorf("%s: %s", string(e.Code), *e.Message)
}

func unmarshalJSONResponse(bodyBytes []byte, obj interface{}) error {
	if err := json.Unmarshal(bodyBytes, obj); err != nil {
		return err
	}
	return nil
}

func isJSON(rsp *http.Response) bool {
	ctype, _, _ := mime.ParseMediaType(rsp.Header.Get("Content-Type"))
	return ctype == "application/json"
}

func decodeError(body []byte, rsp *http.Response) error {
	if isJSON(rsp) {
		var serverError struct {
			Error
			V1Error *string `json:"error,omitempty"`
		}
		err := json.Unmarshal(body, &serverError)
		if err != nil {
			message := fmt.Sprintf("cannot decode error response: %v", err)
			serverError.Message = &message
		}
		if serverError.V1Error != nil {
			serverError.Message = serverError.V1Error
			serverError.Code = ErrorCodeInvalid
		}
		if serverError.Message == nil && serverError.Code == "" {
			serverError.Message = &rsp.Status
		}
		return serverError.Error.Error()
	} else {
		message := rsp.Status
		if len(body) > 0 {
			message = message + ": " + string(body)
		}
		return errors.New(message)
	}
}

// GetAuthorizations calls the GET on /authorizations
// List authorizations
func (c *Client) GetAuthorizations(ctx context.Context, params *GetAuthorizationsParams) (*Authorizations, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./authorizations")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.UserID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "userID", runtime.ParamLocationQuery, *params.UserID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.User != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "user", runtime.ParamLocationQuery, *params.User); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Authorizations{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostAuthorizations calls the POST on /authorizations
// Create an authorization
func (c *Client) PostAuthorizations(ctx context.Context, params *PostAuthorizationsAllParams) (*Authorization, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./authorizations")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Authorization{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteAuthorizationsID calls the DELETE on /authorizations/{authID}
// Delete an authorization
func (c *Client) DeleteAuthorizationsID(ctx context.Context, params *DeleteAuthorizationsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "authID", runtime.ParamLocationPath, params.AuthID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./authorizations/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetAuthorizationsID calls the GET on /authorizations/{authID}
// Retrieve an authorization
func (c *Client) GetAuthorizationsID(ctx context.Context, params *GetAuthorizationsIDAllParams) (*Authorization, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "authID", runtime.ParamLocationPath, params.AuthID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./authorizations/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Authorization{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchAuthorizationsID calls the PATCH on /authorizations/{authID}
// Update an authorization to be active or inactive
func (c *Client) PatchAuthorizationsID(ctx context.Context, params *PatchAuthorizationsIDAllParams) (*Authorization, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "authID", runtime.ParamLocationPath, params.AuthID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./authorizations/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Authorization{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetBuckets calls the GET on /buckets
// List buckets
func (c *Client) GetBuckets(ctx context.Context, params *GetBucketsParams) (*Buckets, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./buckets")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "offset", runtime.ParamLocationQuery, *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "limit", runtime.ParamLocationQuery, *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.After != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "after", runtime.ParamLocationQuery, *params.After); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "name", runtime.ParamLocationQuery, *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Id != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "id", runtime.ParamLocationQuery, *params.Id); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Buckets{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostBuckets calls the POST on /buckets
// Create a bucket
func (c *Client) PostBuckets(ctx context.Context, params *PostBucketsAllParams) (*Bucket, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./buckets")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Bucket{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteBucketsID calls the DELETE on /buckets/{bucketID}
// Delete a bucket
func (c *Client) DeleteBucketsID(ctx context.Context, params *DeleteBucketsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucketID", runtime.ParamLocationPath, params.BucketID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./buckets/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetBucketsID calls the GET on /buckets/{bucketID}
// Retrieve a bucket
func (c *Client) GetBucketsID(ctx context.Context, params *GetBucketsIDAllParams) (*Bucket, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucketID", runtime.ParamLocationPath, params.BucketID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./buckets/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Bucket{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchBucketsID calls the PATCH on /buckets/{bucketID}
// Update a bucket
func (c *Client) PatchBucketsID(ctx context.Context, params *PatchBucketsIDAllParams) (*Bucket, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucketID", runtime.ParamLocationPath, params.BucketID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./buckets/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Bucket{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetBucketsIDLabels calls the GET on /buckets/{bucketID}/labels
// List all labels for a bucket
func (c *Client) GetBucketsIDLabels(ctx context.Context, params *GetBucketsIDLabelsAllParams) (*LabelsResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucketID", runtime.ParamLocationPath, params.BucketID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./buckets/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelsResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostBucketsIDLabels calls the POST on /buckets/{bucketID}/labels
// Add a label to a bucket
func (c *Client) PostBucketsIDLabels(ctx context.Context, params *PostBucketsIDLabelsAllParams) (*LabelResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucketID", runtime.ParamLocationPath, params.BucketID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./buckets/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelResponse{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteBucketsIDLabelsID calls the DELETE on /buckets/{bucketID}/labels/{labelID}
// Delete a label from a bucket
func (c *Client) DeleteBucketsIDLabelsID(ctx context.Context, params *DeleteBucketsIDLabelsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucketID", runtime.ParamLocationPath, params.BucketID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "labelID", runtime.ParamLocationPath, params.LabelID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./buckets/%s/labels/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetBucketsIDMembers calls the GET on /buckets/{bucketID}/members
// List all users with member privileges for a bucket
func (c *Client) GetBucketsIDMembers(ctx context.Context, params *GetBucketsIDMembersAllParams) (*ResourceMembers, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucketID", runtime.ParamLocationPath, params.BucketID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./buckets/%s/members", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceMembers{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostBucketsIDMembers calls the POST on /buckets/{bucketID}/members
// Add a member to a bucket
func (c *Client) PostBucketsIDMembers(ctx context.Context, params *PostBucketsIDMembersAllParams) (*ResourceMember, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucketID", runtime.ParamLocationPath, params.BucketID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./buckets/%s/members", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceMember{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteBucketsIDMembersID calls the DELETE on /buckets/{bucketID}/members/{userID}
// Remove a member from a bucket
func (c *Client) DeleteBucketsIDMembersID(ctx context.Context, params *DeleteBucketsIDMembersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucketID", runtime.ParamLocationPath, params.BucketID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./buckets/%s/members/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetBucketsIDOwners calls the GET on /buckets/{bucketID}/owners
// List all owners of a bucket
func (c *Client) GetBucketsIDOwners(ctx context.Context, params *GetBucketsIDOwnersAllParams) (*ResourceOwners, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucketID", runtime.ParamLocationPath, params.BucketID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./buckets/%s/owners", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceOwners{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostBucketsIDOwners calls the POST on /buckets/{bucketID}/owners
// Add an owner to a bucket
func (c *Client) PostBucketsIDOwners(ctx context.Context, params *PostBucketsIDOwnersAllParams) (*ResourceOwner, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucketID", runtime.ParamLocationPath, params.BucketID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./buckets/%s/owners", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceOwner{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteBucketsIDOwnersID calls the DELETE on /buckets/{bucketID}/owners/{userID}
// Remove an owner from a bucket
func (c *Client) DeleteBucketsIDOwnersID(ctx context.Context, params *DeleteBucketsIDOwnersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "bucketID", runtime.ParamLocationPath, params.BucketID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./buckets/%s/owners/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetConfig calls the GET on /config
// Retrieve runtime configuration
func (c *Client) GetConfig(ctx context.Context, params *GetConfigParams) (*Config, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./config")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Config{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetDashboards calls the GET on /dashboards
// List all dashboards
func (c *Client) GetDashboards(ctx context.Context, params *GetDashboardsParams) (*Dashboards, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "offset", runtime.ParamLocationQuery, *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "limit", runtime.ParamLocationQuery, *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Descending != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "descending", runtime.ParamLocationQuery, *params.Descending); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Owner != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "owner", runtime.ParamLocationQuery, *params.Owner); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.SortBy != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "sortBy", runtime.ParamLocationQuery, *params.SortBy); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Id != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "id", runtime.ParamLocationQuery, *params.Id); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Dashboards{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteDashboardsID calls the DELETE on /dashboards/{dashboardID}
// Delete a dashboard
func (c *Client) DeleteDashboardsID(ctx context.Context, params *DeleteDashboardsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./dashboards/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// PatchDashboardsID calls the PATCH on /dashboards/{dashboardID}
// Update a dashboard
func (c *Client) PatchDashboardsID(ctx context.Context, params *PatchDashboardsIDAllParams) (*Dashboard, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Dashboard{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostDashboardsIDCells calls the POST on /dashboards/{dashboardID}/cells
// Create a dashboard cell
func (c *Client) PostDashboardsIDCells(ctx context.Context, params *PostDashboardsIDCellsAllParams) (*Cell, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/cells", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Cell{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PutDashboardsIDCells calls the PUT on /dashboards/{dashboardID}/cells
// Replace cells in a dashboard
func (c *Client) PutDashboardsIDCells(ctx context.Context, params *PutDashboardsIDCellsAllParams) (*Dashboard, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/cells", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Dashboard{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteDashboardsIDCellsID calls the DELETE on /dashboards/{dashboardID}/cells/{cellID}
// Delete a dashboard cell
func (c *Client) DeleteDashboardsIDCellsID(ctx context.Context, params *DeleteDashboardsIDCellsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "cellID", runtime.ParamLocationPath, params.CellID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/cells/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// PatchDashboardsIDCellsID calls the PATCH on /dashboards/{dashboardID}/cells/{cellID}
// Update the non-positional information related to a cell
func (c *Client) PatchDashboardsIDCellsID(ctx context.Context, params *PatchDashboardsIDCellsIDAllParams) (*Cell, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "cellID", runtime.ParamLocationPath, params.CellID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/cells/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Cell{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetDashboardsIDCellsIDView calls the GET on /dashboards/{dashboardID}/cells/{cellID}/view
// Retrieve the view for a cell
func (c *Client) GetDashboardsIDCellsIDView(ctx context.Context, params *GetDashboardsIDCellsIDViewAllParams) (*View, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "cellID", runtime.ParamLocationPath, params.CellID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/cells/%s/view", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &View{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchDashboardsIDCellsIDView calls the PATCH on /dashboards/{dashboardID}/cells/{cellID}/view
// Update the view for a cell
func (c *Client) PatchDashboardsIDCellsIDView(ctx context.Context, params *PatchDashboardsIDCellsIDViewAllParams) (*View, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "cellID", runtime.ParamLocationPath, params.CellID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/cells/%s/view", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &View{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetDashboardsIDLabels calls the GET on /dashboards/{dashboardID}/labels
// List all labels for a dashboard
func (c *Client) GetDashboardsIDLabels(ctx context.Context, params *GetDashboardsIDLabelsAllParams) (*LabelsResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelsResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostDashboardsIDLabels calls the POST on /dashboards/{dashboardID}/labels
// Add a label to a dashboard
func (c *Client) PostDashboardsIDLabels(ctx context.Context, params *PostDashboardsIDLabelsAllParams) (*LabelResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelResponse{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteDashboardsIDLabelsID calls the DELETE on /dashboards/{dashboardID}/labels/{labelID}
// Delete a label from a dashboard
func (c *Client) DeleteDashboardsIDLabelsID(ctx context.Context, params *DeleteDashboardsIDLabelsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "labelID", runtime.ParamLocationPath, params.LabelID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/labels/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetDashboardsIDMembers calls the GET on /dashboards/{dashboardID}/members
// List all dashboard members
func (c *Client) GetDashboardsIDMembers(ctx context.Context, params *GetDashboardsIDMembersAllParams) (*ResourceMembers, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/members", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceMembers{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostDashboardsIDMembers calls the POST on /dashboards/{dashboardID}/members
// Add a member to a dashboard
func (c *Client) PostDashboardsIDMembers(ctx context.Context, params *PostDashboardsIDMembersAllParams) (*ResourceMember, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/members", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceMember{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteDashboardsIDMembersID calls the DELETE on /dashboards/{dashboardID}/members/{userID}
// Remove a member from a dashboard
func (c *Client) DeleteDashboardsIDMembersID(ctx context.Context, params *DeleteDashboardsIDMembersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/members/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetDashboardsIDOwners calls the GET on /dashboards/{dashboardID}/owners
// List all dashboard owners
func (c *Client) GetDashboardsIDOwners(ctx context.Context, params *GetDashboardsIDOwnersAllParams) (*ResourceOwners, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/owners", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceOwners{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostDashboardsIDOwners calls the POST on /dashboards/{dashboardID}/owners
// Add an owner to a dashboard
func (c *Client) PostDashboardsIDOwners(ctx context.Context, params *PostDashboardsIDOwnersAllParams) (*ResourceOwner, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/owners", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceOwner{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteDashboardsIDOwnersID calls the DELETE on /dashboards/{dashboardID}/owners/{userID}
// Remove an owner from a dashboard
func (c *Client) DeleteDashboardsIDOwnersID(ctx context.Context, params *DeleteDashboardsIDOwnersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dashboardID", runtime.ParamLocationPath, params.DashboardID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./dashboards/%s/owners/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetDBRPs calls the GET on /dbrps
// List database retention policy mappings
func (c *Client) GetDBRPs(ctx context.Context, params *GetDBRPsParams) (*DBRPs, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dbrps")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Id != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "id", runtime.ParamLocationQuery, *params.Id); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.BucketID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "bucketID", runtime.ParamLocationQuery, *params.BucketID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Default != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "default", runtime.ParamLocationQuery, *params.Default); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Db != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "db", runtime.ParamLocationQuery, *params.Db); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Rp != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "rp", runtime.ParamLocationQuery, *params.Rp); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DBRPs{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostDBRP calls the POST on /dbrps
// Add a database retention policy mapping
func (c *Client) PostDBRP(ctx context.Context, params *PostDBRPAllParams) (*DBRP, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dbrps")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DBRP{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteDBRPID calls the DELETE on /dbrps/{dbrpID}
// Delete a database retention policy
func (c *Client) DeleteDBRPID(ctx context.Context, params *DeleteDBRPIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dbrpID", runtime.ParamLocationPath, params.DbrpID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./dbrps/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	queryValues := queryURL.Query()

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetDBRPsID calls the GET on /dbrps/{dbrpID}
// Retrieve a database retention policy mapping
func (c *Client) GetDBRPsID(ctx context.Context, params *GetDBRPsIDAllParams) (*DBRPGet, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dbrpID", runtime.ParamLocationPath, params.DbrpID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dbrps/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DBRPGet{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchDBRPID calls the PATCH on /dbrps/{dbrpID}
// Update a database retention policy mapping
func (c *Client) PatchDBRPID(ctx context.Context, params *PatchDBRPIDAllParams) (*DBRPGet, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "dbrpID", runtime.ParamLocationPath, params.DbrpID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./dbrps/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &DBRPGet{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostDelete calls the POST on /delete
// Delete data
func (c *Client) PostDelete(ctx context.Context, params *PostDeleteAllParams) error {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./delete")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Bucket != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "bucket", runtime.ParamLocationQuery, *params.Bucket); err != nil {
			return err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.BucketID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "bucketID", runtime.ParamLocationQuery, *params.BucketID); err != nil {
			return err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetFlags calls the GET on /flags
// Return the feature flags for the currently authenticated user
func (c *Client) GetFlags(ctx context.Context, params *GetFlagsParams) (*Flags, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./flags")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Flags{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetHealth calls the GET on /health
// Retrieve the health of the instance
func (c *Client) GetHealth(ctx context.Context, params *GetHealthParams) (*HealthCheck, error) {
	var err error

	serverURL, err := url.Parse(c.Server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./health")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &HealthCheck{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetLabels calls the GET on /labels
// List all labels
func (c *Client) GetLabels(ctx context.Context, params *GetLabelsParams) (*LabelsResponse, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./labels")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelsResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostLabels calls the POST on /labels
// Create a label
func (c *Client) PostLabels(ctx context.Context, params *PostLabelsAllParams) (*LabelResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./labels")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelResponse{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteLabelsID calls the DELETE on /labels/{labelID}
// Delete a label
func (c *Client) DeleteLabelsID(ctx context.Context, params *DeleteLabelsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "labelID", runtime.ParamLocationPath, params.LabelID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./labels/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetLabelsID calls the GET on /labels/{labelID}
// Retrieve a label
func (c *Client) GetLabelsID(ctx context.Context, params *GetLabelsIDAllParams) (*LabelResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "labelID", runtime.ParamLocationPath, params.LabelID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./labels/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchLabelsID calls the PATCH on /labels/{labelID}
// Update a label
func (c *Client) PatchLabelsID(ctx context.Context, params *PatchLabelsIDAllParams) (*LabelResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "labelID", runtime.ParamLocationPath, params.LabelID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./labels/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetMe calls the GET on /me
// Retrieve the currently authenticated user
func (c *Client) GetMe(ctx context.Context, params *GetMeParams) (*UserResponse, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./me")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UserResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PutMePassword calls the PUT on /me/password
// Update a password
func (c *Client) PutMePassword(ctx context.Context, params *PutMePasswordAllParams) error {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./me/password")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), bodyReader)
	if err != nil {
		return err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetNotificationEndpoints calls the GET on /notificationEndpoints
// List all notification endpoints
func (c *Client) GetNotificationEndpoints(ctx context.Context, params *GetNotificationEndpointsParams) (*NotificationEndpoints, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationEndpoints")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "offset", runtime.ParamLocationQuery, *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "limit", runtime.ParamLocationQuery, *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &NotificationEndpoints{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// CreateNotificationEndpoint calls the POST on /notificationEndpoints
// Add a notification endpoint
func (c *Client) CreateNotificationEndpoint(ctx context.Context, params *CreateNotificationEndpointAllParams) (*NotificationEndpoint, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationEndpoints")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &NotificationEndpoint{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteNotificationEndpointsID calls the DELETE on /notificationEndpoints/{endpointID}
// Delete a notification endpoint
func (c *Client) DeleteNotificationEndpointsID(ctx context.Context, params *DeleteNotificationEndpointsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "endpointID", runtime.ParamLocationPath, params.EndpointID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./notificationEndpoints/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetNotificationEndpointsID calls the GET on /notificationEndpoints/{endpointID}
// Retrieve a notification endpoint
func (c *Client) GetNotificationEndpointsID(ctx context.Context, params *GetNotificationEndpointsIDAllParams) (*NotificationEndpoint, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "endpointID", runtime.ParamLocationPath, params.EndpointID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationEndpoints/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &NotificationEndpoint{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchNotificationEndpointsID calls the PATCH on /notificationEndpoints/{endpointID}
// Update a notification endpoint
func (c *Client) PatchNotificationEndpointsID(ctx context.Context, params *PatchNotificationEndpointsIDAllParams) (*NotificationEndpoint, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "endpointID", runtime.ParamLocationPath, params.EndpointID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationEndpoints/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &NotificationEndpoint{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PutNotificationEndpointsID calls the PUT on /notificationEndpoints/{endpointID}
// Update a notification endpoint
func (c *Client) PutNotificationEndpointsID(ctx context.Context, params *PutNotificationEndpointsIDAllParams) (*NotificationEndpoint, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "endpointID", runtime.ParamLocationPath, params.EndpointID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationEndpoints/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &NotificationEndpoint{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetNotificationEndpointsIDLabels calls the GET on /notificationEndpoints/{endpointID}/labels
// List all labels for a notification endpoint
func (c *Client) GetNotificationEndpointsIDLabels(ctx context.Context, params *GetNotificationEndpointsIDLabelsAllParams) (*LabelsResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "endpointID", runtime.ParamLocationPath, params.EndpointID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationEndpoints/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelsResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostNotificationEndpointIDLabels calls the POST on /notificationEndpoints/{endpointID}/labels
// Add a label to a notification endpoint
func (c *Client) PostNotificationEndpointIDLabels(ctx context.Context, params *PostNotificationEndpointIDLabelsAllParams) (*LabelResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "endpointID", runtime.ParamLocationPath, params.EndpointID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationEndpoints/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelResponse{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteNotificationEndpointsIDLabelsID calls the DELETE on /notificationEndpoints/{endpointID}/labels/{labelID}
// Delete a label from a notification endpoint
func (c *Client) DeleteNotificationEndpointsIDLabelsID(ctx context.Context, params *DeleteNotificationEndpointsIDLabelsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "endpointID", runtime.ParamLocationPath, params.EndpointID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "labelID", runtime.ParamLocationPath, params.LabelID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./notificationEndpoints/%s/labels/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetNotificationRules calls the GET on /notificationRules
// List all notification rules
func (c *Client) GetNotificationRules(ctx context.Context, params *GetNotificationRulesParams) (*NotificationRules, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationRules")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "offset", runtime.ParamLocationQuery, *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "limit", runtime.ParamLocationQuery, *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.CheckID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "checkID", runtime.ParamLocationQuery, *params.CheckID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Tag != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "tag", runtime.ParamLocationQuery, *params.Tag); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &NotificationRules{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// CreateNotificationRule calls the POST on /notificationRules
// Add a notification rule
func (c *Client) CreateNotificationRule(ctx context.Context, params *CreateNotificationRuleAllParams) (*NotificationRule, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationRules")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &NotificationRule{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteNotificationRulesID calls the DELETE on /notificationRules/{ruleID}
// Delete a notification rule
func (c *Client) DeleteNotificationRulesID(ctx context.Context, params *DeleteNotificationRulesIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "ruleID", runtime.ParamLocationPath, params.RuleID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./notificationRules/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetNotificationRulesID calls the GET on /notificationRules/{ruleID}
// Retrieve a notification rule
func (c *Client) GetNotificationRulesID(ctx context.Context, params *GetNotificationRulesIDAllParams) (*NotificationRule, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "ruleID", runtime.ParamLocationPath, params.RuleID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationRules/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &NotificationRule{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchNotificationRulesID calls the PATCH on /notificationRules/{ruleID}
// Update a notification rule
func (c *Client) PatchNotificationRulesID(ctx context.Context, params *PatchNotificationRulesIDAllParams) (*NotificationRule, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "ruleID", runtime.ParamLocationPath, params.RuleID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationRules/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &NotificationRule{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PutNotificationRulesID calls the PUT on /notificationRules/{ruleID}
// Update a notification rule
func (c *Client) PutNotificationRulesID(ctx context.Context, params *PutNotificationRulesIDAllParams) (*NotificationRule, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "ruleID", runtime.ParamLocationPath, params.RuleID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationRules/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &NotificationRule{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetNotificationRulesIDLabels calls the GET on /notificationRules/{ruleID}/labels
// List all labels for a notification rule
func (c *Client) GetNotificationRulesIDLabels(ctx context.Context, params *GetNotificationRulesIDLabelsAllParams) (*LabelsResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "ruleID", runtime.ParamLocationPath, params.RuleID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationRules/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelsResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostNotificationRuleIDLabels calls the POST on /notificationRules/{ruleID}/labels
// Add a label to a notification rule
func (c *Client) PostNotificationRuleIDLabels(ctx context.Context, params *PostNotificationRuleIDLabelsAllParams) (*LabelResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "ruleID", runtime.ParamLocationPath, params.RuleID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationRules/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelResponse{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteNotificationRulesIDLabelsID calls the DELETE on /notificationRules/{ruleID}/labels/{labelID}
// Delete label from a notification rule
func (c *Client) DeleteNotificationRulesIDLabelsID(ctx context.Context, params *DeleteNotificationRulesIDLabelsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "ruleID", runtime.ParamLocationPath, params.RuleID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "labelID", runtime.ParamLocationPath, params.LabelID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./notificationRules/%s/labels/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetNotificationRulesIDQuery calls the GET on /notificationRules/{ruleID}/query
// Retrieve a notification rule query
func (c *Client) GetNotificationRulesIDQuery(ctx context.Context, params *GetNotificationRulesIDQueryAllParams) (*FluxResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "ruleID", runtime.ParamLocationPath, params.RuleID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./notificationRules/%s/query", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &FluxResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetOrgs calls the GET on /orgs
// List organizations
func (c *Client) GetOrgs(ctx context.Context, params *GetOrgsParams) (*Organizations, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./orgs")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "offset", runtime.ParamLocationQuery, *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "limit", runtime.ParamLocationQuery, *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Descending != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "descending", runtime.ParamLocationQuery, *params.Descending); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.UserID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "userID", runtime.ParamLocationQuery, *params.UserID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Organizations{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostOrgs calls the POST on /orgs
// Create an organization
func (c *Client) PostOrgs(ctx context.Context, params *PostOrgsAllParams) (*Organization, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./orgs")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Organization{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteOrgsID calls the DELETE on /orgs/{orgID}
// Delete an organization
func (c *Client) DeleteOrgsID(ctx context.Context, params *DeleteOrgsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./orgs/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetOrgsID calls the GET on /orgs/{orgID}
// Retrieve an organization
func (c *Client) GetOrgsID(ctx context.Context, params *GetOrgsIDAllParams) (*Organization, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./orgs/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Organization{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchOrgsID calls the PATCH on /orgs/{orgID}
// Update an organization
func (c *Client) PatchOrgsID(ctx context.Context, params *PatchOrgsIDAllParams) (*Organization, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./orgs/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Organization{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetOrgsIDMembers calls the GET on /orgs/{orgID}/members
// List all members of an organization
func (c *Client) GetOrgsIDMembers(ctx context.Context, params *GetOrgsIDMembersAllParams) (*ResourceMembers, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./orgs/%s/members", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceMembers{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostOrgsIDMembers calls the POST on /orgs/{orgID}/members
// Add a member to an organization
func (c *Client) PostOrgsIDMembers(ctx context.Context, params *PostOrgsIDMembersAllParams) (*ResourceMember, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./orgs/%s/members", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceMember{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteOrgsIDMembersID calls the DELETE on /orgs/{orgID}/members/{userID}
// Remove a member from an organization
func (c *Client) DeleteOrgsIDMembersID(ctx context.Context, params *DeleteOrgsIDMembersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./orgs/%s/members/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetOrgsIDOwners calls the GET on /orgs/{orgID}/owners
// List all owners of an organization
func (c *Client) GetOrgsIDOwners(ctx context.Context, params *GetOrgsIDOwnersAllParams) (*ResourceOwners, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./orgs/%s/owners", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceOwners{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostOrgsIDOwners calls the POST on /orgs/{orgID}/owners
// Add an owner to an organization
func (c *Client) PostOrgsIDOwners(ctx context.Context, params *PostOrgsIDOwnersAllParams) (*ResourceOwner, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./orgs/%s/owners", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceOwner{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteOrgsIDOwnersID calls the DELETE on /orgs/{orgID}/owners/{userID}
// Remove an owner from an organization
func (c *Client) DeleteOrgsIDOwnersID(ctx context.Context, params *DeleteOrgsIDOwnersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./orgs/%s/owners/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetOrgsIDSecrets calls the GET on /orgs/{orgID}/secrets
// List all secret keys for an organization
func (c *Client) GetOrgsIDSecrets(ctx context.Context, params *GetOrgsIDSecretsAllParams) (*SecretKeysResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./orgs/%s/secrets", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &SecretKeysResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchOrgsIDSecrets calls the PATCH on /orgs/{orgID}/secrets
// Update secrets in an organization
func (c *Client) PatchOrgsIDSecrets(ctx context.Context, params *PatchOrgsIDSecretsAllParams) error {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./orgs/%s/secrets", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// PostOrgsIDSecrets calls the POST on /orgs/{orgID}/secrets/delete
// Delete secrets from an organization
func (c *Client) PostOrgsIDSecrets(ctx context.Context, params *PostOrgsIDSecretsAllParams) error {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./orgs/%s/secrets/delete", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// DeleteOrgsIDSecretsID calls the DELETE on /orgs/{orgID}/secrets/{secretID}
// Delete a secret from an organization
func (c *Client) DeleteOrgsIDSecretsID(ctx context.Context, params *DeleteOrgsIDSecretsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "orgID", runtime.ParamLocationPath, params.OrgID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "secretID", runtime.ParamLocationPath, params.SecretID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./orgs/%s/secrets/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetPing calls the GET on /ping
// Get the status and version of the instance
func (c *Client) GetPing(ctx context.Context) error {
	var err error

	serverURL, err := url.Parse(c.Server)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./ping")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return err
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// HeadPing calls the HEAD on /ping
// Get the status and version of the instance
func (c *Client) HeadPing(ctx context.Context) error {
	var err error

	serverURL, err := url.Parse(c.Server)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./ping")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("HEAD", queryURL.String(), nil)
	if err != nil {
		return err
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// PostQueryAnalyze calls the POST on /query/analyze
// Analyze a Flux query
func (c *Client) PostQueryAnalyze(ctx context.Context, params *PostQueryAnalyzeAllParams) (*AnalyzeQueryResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./query/analyze")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	if params.ContentType != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParamWithLocation("simple", false, "Content-Type", runtime.ParamLocationHeader, *params.ContentType)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Content-Type", headerParam1)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &AnalyzeQueryResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostQueryAst calls the POST on /query/ast
// Generate a query Abstract Syntax Tree (AST)
func (c *Client) PostQueryAst(ctx context.Context, params *PostQueryAstAllParams) (*ASTResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./query/ast")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	if params.ContentType != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParamWithLocation("simple", false, "Content-Type", runtime.ParamLocationHeader, *params.ContentType)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Content-Type", headerParam1)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ASTResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetQuerySuggestions calls the GET on /query/suggestions
// Retrieve Flux query suggestions
func (c *Client) GetQuerySuggestions(ctx context.Context, params *GetQuerySuggestionsParams) (*FluxSuggestions, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./query/suggestions")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &FluxSuggestions{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetQuerySuggestionsName calls the GET on /query/suggestions/{name}
// Retrieve a query suggestion for a branching suggestion
func (c *Client) GetQuerySuggestionsName(ctx context.Context, params *GetQuerySuggestionsNameAllParams) (*FluxSuggestion, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "name", runtime.ParamLocationPath, params.Name)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./query/suggestions/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &FluxSuggestion{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetReady calls the GET on /ready
// Get the readiness of an instance at startup
func (c *Client) GetReady(ctx context.Context, params *GetReadyParams) (*Ready, error) {
	var err error

	serverURL, err := url.Parse(c.Server)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./ready")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Ready{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetRemoteConnections calls the GET on /remotes
// List all remote connections
func (c *Client) GetRemoteConnections(ctx context.Context, params *GetRemoteConnectionsParams) (*RemoteConnections, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./remotes")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "name", runtime.ParamLocationQuery, *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.RemoteURL != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "remoteURL", runtime.ParamLocationQuery, *params.RemoteURL); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RemoteConnections{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostRemoteConnection calls the POST on /remotes
// Register a new remote connection
func (c *Client) PostRemoteConnection(ctx context.Context, params *PostRemoteConnectionAllParams) (*RemoteConnection, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./remotes")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RemoteConnection{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteRemoteConnectionByID calls the DELETE on /remotes/{remoteID}
// Delete a remote connection
func (c *Client) DeleteRemoteConnectionByID(ctx context.Context, params *DeleteRemoteConnectionByIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "remoteID", runtime.ParamLocationPath, params.RemoteID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./remotes/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetRemoteConnectionByID calls the GET on /remotes/{remoteID}
// Retrieve a remote connection
func (c *Client) GetRemoteConnectionByID(ctx context.Context, params *GetRemoteConnectionByIDAllParams) (*RemoteConnection, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "remoteID", runtime.ParamLocationPath, params.RemoteID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./remotes/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RemoteConnection{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchRemoteConnectionByID calls the PATCH on /remotes/{remoteID}
// Update a remote connection
func (c *Client) PatchRemoteConnectionByID(ctx context.Context, params *PatchRemoteConnectionByIDAllParams) (*RemoteConnection, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "remoteID", runtime.ParamLocationPath, params.RemoteID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./remotes/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RemoteConnection{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetReplications calls the GET on /replications
// List all replications
func (c *Client) GetReplications(ctx context.Context, params *GetReplicationsParams) (*Replications, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./replications")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "name", runtime.ParamLocationQuery, *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.RemoteID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "remoteID", runtime.ParamLocationQuery, *params.RemoteID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.LocalBucketID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "localBucketID", runtime.ParamLocationQuery, *params.LocalBucketID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Replications{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostReplication calls the POST on /replications
// Register a new replication
func (c *Client) PostReplication(ctx context.Context, params *PostReplicationAllParams) (*Replication, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./replications")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Validate != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "validate", runtime.ParamLocationQuery, *params.Validate); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Replication{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteReplicationByID calls the DELETE on /replications/{replicationID}
// Delete a replication
func (c *Client) DeleteReplicationByID(ctx context.Context, params *DeleteReplicationByIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "replicationID", runtime.ParamLocationPath, params.ReplicationID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./replications/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetReplicationByID calls the GET on /replications/{replicationID}
// Retrieve a replication
func (c *Client) GetReplicationByID(ctx context.Context, params *GetReplicationByIDAllParams) (*Replication, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "replicationID", runtime.ParamLocationPath, params.ReplicationID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./replications/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Replication{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchReplicationByID calls the PATCH on /replications/{replicationID}
// Update a replication
func (c *Client) PatchReplicationByID(ctx context.Context, params *PatchReplicationByIDAllParams) (*Replication, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "replicationID", runtime.ParamLocationPath, params.ReplicationID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./replications/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Validate != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "validate", runtime.ParamLocationQuery, *params.Validate); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Replication{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostValidateReplicationByID calls the POST on /replications/{replicationID}/validate
// Validate a replication
func (c *Client) PostValidateReplicationByID(ctx context.Context, params *PostValidateReplicationByIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "replicationID", runtime.ParamLocationPath, params.ReplicationID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./replications/%s/validate", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetResources calls the GET on /resources
// List all known resources
func (c *Client) GetResources(ctx context.Context, params *GetResourcesParams) (*[]string, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./resources")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &[]string{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostRestoreBucketMetadata calls the POST on /restore/bucketMetadata
// Create a new bucket pre-seeded with shard info from a backup.
func (c *Client) PostRestoreBucketMetadata(ctx context.Context, params *PostRestoreBucketMetadataAllParams) (*RestoredBucketMappings, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./restore/bucketMetadata")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &RestoredBucketMappings{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetScrapers calls the GET on /scrapers
// List all scraper targets
func (c *Client) GetScrapers(ctx context.Context, params *GetScrapersParams) (*ScraperTargetResponses, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./scrapers")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "name", runtime.ParamLocationQuery, *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Id != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "id", runtime.ParamLocationQuery, *params.Id); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ScraperTargetResponses{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostScrapers calls the POST on /scrapers
// Create a scraper target
func (c *Client) PostScrapers(ctx context.Context, params *PostScrapersAllParams) (*ScraperTargetResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./scrapers")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ScraperTargetResponse{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteScrapersID calls the DELETE on /scrapers/{scraperTargetID}
// Delete a scraper target
func (c *Client) DeleteScrapersID(ctx context.Context, params *DeleteScrapersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "scraperTargetID", runtime.ParamLocationPath, params.ScraperTargetID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./scrapers/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetScrapersID calls the GET on /scrapers/{scraperTargetID}
// Retrieve a scraper target
func (c *Client) GetScrapersID(ctx context.Context, params *GetScrapersIDAllParams) (*ScraperTargetResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "scraperTargetID", runtime.ParamLocationPath, params.ScraperTargetID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./scrapers/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ScraperTargetResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchScrapersID calls the PATCH on /scrapers/{scraperTargetID}
// Update a scraper target
func (c *Client) PatchScrapersID(ctx context.Context, params *PatchScrapersIDAllParams) (*ScraperTargetResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "scraperTargetID", runtime.ParamLocationPath, params.ScraperTargetID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./scrapers/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ScraperTargetResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetScrapersIDLabels calls the GET on /scrapers/{scraperTargetID}/labels
// List all labels for a scraper target
func (c *Client) GetScrapersIDLabels(ctx context.Context, params *GetScrapersIDLabelsAllParams) (*LabelsResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "scraperTargetID", runtime.ParamLocationPath, params.ScraperTargetID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./scrapers/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelsResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostScrapersIDLabels calls the POST on /scrapers/{scraperTargetID}/labels
// Add a label to a scraper target
func (c *Client) PostScrapersIDLabels(ctx context.Context, params *PostScrapersIDLabelsAllParams) (*LabelResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "scraperTargetID", runtime.ParamLocationPath, params.ScraperTargetID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./scrapers/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelResponse{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteScrapersIDLabelsID calls the DELETE on /scrapers/{scraperTargetID}/labels/{labelID}
// Delete a label from a scraper target
func (c *Client) DeleteScrapersIDLabelsID(ctx context.Context, params *DeleteScrapersIDLabelsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "scraperTargetID", runtime.ParamLocationPath, params.ScraperTargetID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "labelID", runtime.ParamLocationPath, params.LabelID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./scrapers/%s/labels/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetScrapersIDMembers calls the GET on /scrapers/{scraperTargetID}/members
// List all users with member privileges for a scraper target
func (c *Client) GetScrapersIDMembers(ctx context.Context, params *GetScrapersIDMembersAllParams) (*ResourceMembers, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "scraperTargetID", runtime.ParamLocationPath, params.ScraperTargetID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./scrapers/%s/members", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceMembers{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostScrapersIDMembers calls the POST on /scrapers/{scraperTargetID}/members
// Add a member to a scraper target
func (c *Client) PostScrapersIDMembers(ctx context.Context, params *PostScrapersIDMembersAllParams) (*ResourceMember, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "scraperTargetID", runtime.ParamLocationPath, params.ScraperTargetID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./scrapers/%s/members", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceMember{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteScrapersIDMembersID calls the DELETE on /scrapers/{scraperTargetID}/members/{userID}
// Remove a member from a scraper target
func (c *Client) DeleteScrapersIDMembersID(ctx context.Context, params *DeleteScrapersIDMembersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "scraperTargetID", runtime.ParamLocationPath, params.ScraperTargetID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./scrapers/%s/members/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetScrapersIDOwners calls the GET on /scrapers/{scraperTargetID}/owners
// List all owners of a scraper target
func (c *Client) GetScrapersIDOwners(ctx context.Context, params *GetScrapersIDOwnersAllParams) (*ResourceOwners, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "scraperTargetID", runtime.ParamLocationPath, params.ScraperTargetID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./scrapers/%s/owners", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceOwners{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostScrapersIDOwners calls the POST on /scrapers/{scraperTargetID}/owners
// Add an owner to a scraper target
func (c *Client) PostScrapersIDOwners(ctx context.Context, params *PostScrapersIDOwnersAllParams) (*ResourceOwner, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "scraperTargetID", runtime.ParamLocationPath, params.ScraperTargetID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./scrapers/%s/owners", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceOwner{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteScrapersIDOwnersID calls the DELETE on /scrapers/{scraperTargetID}/owners/{userID}
// Remove an owner from a scraper target
func (c *Client) DeleteScrapersIDOwnersID(ctx context.Context, params *DeleteScrapersIDOwnersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "scraperTargetID", runtime.ParamLocationPath, params.ScraperTargetID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./scrapers/%s/owners/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetSetup calls the GET on /setup
// Check if database has default user, org, bucket
func (c *Client) GetSetup(ctx context.Context, params *GetSetupParams) (*IsOnboarding, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./setup")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &IsOnboarding{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostSetup calls the POST on /setup
// Set up initial user, org and bucket
func (c *Client) PostSetup(ctx context.Context, params *PostSetupAllParams) (*OnboardingResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./setup")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &OnboardingResponse{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostSignin calls the POST on /signin
// Create a user session.
func (c *Client) PostSignin(ctx context.Context, params *PostSigninParams) error {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./signin")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// PostSignout calls the POST on /signout
// Expire the current UI session
func (c *Client) PostSignout(ctx context.Context, params *PostSignoutParams) error {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./signout")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetSources calls the GET on /sources
// List all sources
func (c *Client) GetSources(ctx context.Context, params *GetSourcesParams) (*Sources, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./sources")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Sources{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostSources calls the POST on /sources
// Create a source
func (c *Client) PostSources(ctx context.Context, params *PostSourcesAllParams) (*Source, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./sources")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Source{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteSourcesID calls the DELETE on /sources/{sourceID}
// Delete a source
func (c *Client) DeleteSourcesID(ctx context.Context, params *DeleteSourcesIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "sourceID", runtime.ParamLocationPath, params.SourceID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./sources/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetSourcesID calls the GET on /sources/{sourceID}
// Retrieve a source
func (c *Client) GetSourcesID(ctx context.Context, params *GetSourcesIDAllParams) (*Source, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "sourceID", runtime.ParamLocationPath, params.SourceID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./sources/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Source{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchSourcesID calls the PATCH on /sources/{sourceID}
// Update a Source
func (c *Client) PatchSourcesID(ctx context.Context, params *PatchSourcesIDAllParams) (*Source, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "sourceID", runtime.ParamLocationPath, params.SourceID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./sources/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Source{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetSourcesIDBuckets calls the GET on /sources/{sourceID}/buckets
// Get buckets in a source
func (c *Client) GetSourcesIDBuckets(ctx context.Context, params *GetSourcesIDBucketsAllParams) (*Buckets, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "sourceID", runtime.ParamLocationPath, params.SourceID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./sources/%s/buckets", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Buckets{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetSourcesIDHealth calls the GET on /sources/{sourceID}/health
// Get the health of a source
func (c *Client) GetSourcesIDHealth(ctx context.Context, params *GetSourcesIDHealthAllParams) (*HealthCheck, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "sourceID", runtime.ParamLocationPath, params.SourceID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./sources/%s/health", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &HealthCheck{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// ListStacks calls the GET on /stacks
// List installed stacks
func (c *Client) ListStacks(ctx context.Context, params *ListStacksParams) (*struct {
	Stacks *[]Stack `json:"stacks,omitempty"`
}, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./stacks")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "name", runtime.ParamLocationQuery, *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.StackID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "stackID", runtime.ParamLocationQuery, *params.StackID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &struct {
		Stacks *[]Stack `json:"stacks,omitempty"`
	}{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// CreateStack calls the POST on /stacks
// Create a stack
func (c *Client) CreateStack(ctx context.Context, params *CreateStackAllParams) (*Stack, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./stacks")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Stack{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteStack calls the DELETE on /stacks/{stack_id}
// Delete a stack and associated resources
func (c *Client) DeleteStack(ctx context.Context, params *DeleteStackAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "stack_id", runtime.ParamLocationPath, params.StackId)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./stacks/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, params.OrgID); err != nil {
		return err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// ReadStack calls the GET on /stacks/{stack_id}
// Retrieve a stack
func (c *Client) ReadStack(ctx context.Context, params *ReadStackAllParams) (*Stack, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "stack_id", runtime.ParamLocationPath, params.StackId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./stacks/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Stack{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// UpdateStack calls the PATCH on /stacks/{stack_id}
// Update a stack
func (c *Client) UpdateStack(ctx context.Context, params *UpdateStackAllParams) (*Stack, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "stack_id", runtime.ParamLocationPath, params.StackId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./stacks/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Stack{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// UninstallStack calls the POST on /stacks/{stack_id}/uninstall
// Uninstall a stack
func (c *Client) UninstallStack(ctx context.Context, params *UninstallStackAllParams) (*Stack, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "stack_id", runtime.ParamLocationPath, params.StackId)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./stacks/%s/uninstall", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Stack{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetTasks calls the GET on /tasks
// List tasks
func (c *Client) GetTasks(ctx context.Context, params *GetTasksParams) (*Tasks, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "name", runtime.ParamLocationQuery, *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.After != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "after", runtime.ParamLocationQuery, *params.After); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.User != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "user", runtime.ParamLocationQuery, *params.User); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Status != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "status", runtime.ParamLocationQuery, *params.Status); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "limit", runtime.ParamLocationQuery, *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Type != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "type", runtime.ParamLocationQuery, *params.Type); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Tasks{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostTasks calls the POST on /tasks
// Create a task
func (c *Client) PostTasks(ctx context.Context, params *PostTasksAllParams) (*Task, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Task{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteTasksID calls the DELETE on /tasks/{taskID}
// Delete a task
func (c *Client) DeleteTasksID(ctx context.Context, params *DeleteTasksIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./tasks/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetTasksID calls the GET on /tasks/{taskID}
// Retrieve a task
func (c *Client) GetTasksID(ctx context.Context, params *GetTasksIDAllParams) (*Task, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Task{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchTasksID calls the PATCH on /tasks/{taskID}
// Update a task
func (c *Client) PatchTasksID(ctx context.Context, params *PatchTasksIDAllParams) (*Task, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Task{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetTasksIDLabels calls the GET on /tasks/{taskID}/labels
// List labels for a task
func (c *Client) GetTasksIDLabels(ctx context.Context, params *GetTasksIDLabelsAllParams) (*LabelsResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelsResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostTasksIDLabels calls the POST on /tasks/{taskID}/labels
// Add a label to a task
func (c *Client) PostTasksIDLabels(ctx context.Context, params *PostTasksIDLabelsAllParams) (*LabelResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelResponse{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteTasksIDLabelsID calls the DELETE on /tasks/{taskID}/labels/{labelID}
// Delete a label from a task
func (c *Client) DeleteTasksIDLabelsID(ctx context.Context, params *DeleteTasksIDLabelsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "labelID", runtime.ParamLocationPath, params.LabelID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./tasks/%s/labels/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetTasksIDLogs calls the GET on /tasks/{taskID}/logs
// Retrieve all logs for a task
func (c *Client) GetTasksIDLogs(ctx context.Context, params *GetTasksIDLogsAllParams) (*Logs, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s/logs", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Logs{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetTasksIDMembers calls the GET on /tasks/{taskID}/members
// List all task members
func (c *Client) GetTasksIDMembers(ctx context.Context, params *GetTasksIDMembersAllParams) (*ResourceMembers, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s/members", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceMembers{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostTasksIDMembers calls the POST on /tasks/{taskID}/members
// Add a member to a task
func (c *Client) PostTasksIDMembers(ctx context.Context, params *PostTasksIDMembersAllParams) (*ResourceMember, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s/members", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceMember{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteTasksIDMembersID calls the DELETE on /tasks/{taskID}/members/{userID}
// Remove a member from a task
func (c *Client) DeleteTasksIDMembersID(ctx context.Context, params *DeleteTasksIDMembersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./tasks/%s/members/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetTasksIDOwners calls the GET on /tasks/{taskID}/owners
// List all owners of a task
func (c *Client) GetTasksIDOwners(ctx context.Context, params *GetTasksIDOwnersAllParams) (*ResourceOwners, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s/owners", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceOwners{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostTasksIDOwners calls the POST on /tasks/{taskID}/owners
// Add an owner for a task
func (c *Client) PostTasksIDOwners(ctx context.Context, params *PostTasksIDOwnersAllParams) (*ResourceOwner, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s/owners", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceOwner{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteTasksIDOwnersID calls the DELETE on /tasks/{taskID}/owners/{userID}
// Remove an owner from a task
func (c *Client) DeleteTasksIDOwnersID(ctx context.Context, params *DeleteTasksIDOwnersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./tasks/%s/owners/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetTasksIDRuns calls the GET on /tasks/{taskID}/runs
// List runs for a task
func (c *Client) GetTasksIDRuns(ctx context.Context, params *GetTasksIDRunsAllParams) (*Runs, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s/runs", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.After != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "after", runtime.ParamLocationQuery, *params.After); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "limit", runtime.ParamLocationQuery, *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.AfterTime != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "afterTime", runtime.ParamLocationQuery, *params.AfterTime); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.BeforeTime != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "beforeTime", runtime.ParamLocationQuery, *params.BeforeTime); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Runs{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostTasksIDRuns calls the POST on /tasks/{taskID}/runs
// Start a task run, overriding the schedule
func (c *Client) PostTasksIDRuns(ctx context.Context, params *PostTasksIDRunsAllParams) (*Run, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s/runs", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Run{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteTasksIDRunsID calls the DELETE on /tasks/{taskID}/runs/{runID}
// Cancel a running task
func (c *Client) DeleteTasksIDRunsID(ctx context.Context, params *DeleteTasksIDRunsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "runID", runtime.ParamLocationPath, params.RunID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./tasks/%s/runs/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetTasksIDRunsID calls the GET on /tasks/{taskID}/runs/{runID}
// Retrieve a run for a task.
func (c *Client) GetTasksIDRunsID(ctx context.Context, params *GetTasksIDRunsIDAllParams) (*Run, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "runID", runtime.ParamLocationPath, params.RunID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s/runs/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Run{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetTasksIDRunsIDLogs calls the GET on /tasks/{taskID}/runs/{runID}/logs
// Retrieve all logs for a run
func (c *Client) GetTasksIDRunsIDLogs(ctx context.Context, params *GetTasksIDRunsIDLogsAllParams) (*Logs, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "runID", runtime.ParamLocationPath, params.RunID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s/runs/%s/logs", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Logs{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostTasksIDRunsIDRetry calls the POST on /tasks/{taskID}/runs/{runID}/retry
// Retry a task run
func (c *Client) PostTasksIDRunsIDRetry(ctx context.Context, params *PostTasksIDRunsIDRetryAllParams) (*Run, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "taskID", runtime.ParamLocationPath, params.TaskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "runID", runtime.ParamLocationPath, params.RunID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./tasks/%s/runs/%s/retry", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json; charset=utf-8")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Run{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetTelegrafPlugins calls the GET on /telegraf/plugins
// List all Telegraf plugins
func (c *Client) GetTelegrafPlugins(ctx context.Context, params *GetTelegrafPluginsParams) (*TelegrafPlugins, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./telegraf/plugins")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Type != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "type", runtime.ParamLocationQuery, *params.Type); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &TelegrafPlugins{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetTelegrafs calls the GET on /telegrafs
// List all Telegraf configurations
func (c *Client) GetTelegrafs(ctx context.Context, params *GetTelegrafsParams) (*Telegrafs, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./telegrafs")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Telegrafs{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostTelegrafs calls the POST on /telegrafs
// Create a Telegraf configuration
func (c *Client) PostTelegrafs(ctx context.Context, params *PostTelegrafsAllParams) (*Telegraf, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./telegrafs")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Telegraf{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteTelegrafsID calls the DELETE on /telegrafs/{telegrafID}
// Delete a Telegraf configuration
func (c *Client) DeleteTelegrafsID(ctx context.Context, params *DeleteTelegrafsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "telegrafID", runtime.ParamLocationPath, params.TelegrafID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./telegrafs/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetTelegrafsID calls the GET on /telegrafs/{telegrafID}
// Retrieve a Telegraf configuration
func (c *Client) GetTelegrafsID(ctx context.Context, params *GetTelegrafsIDAllParams) (*Telegraf, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "telegrafID", runtime.ParamLocationPath, params.TelegrafID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./telegrafs/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	if params.Accept != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParamWithLocation("simple", false, "Accept", runtime.ParamLocationHeader, *params.Accept)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Accept", headerParam1)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Telegraf{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PutTelegrafsID calls the PUT on /telegrafs/{telegrafID}
// Update a Telegraf configuration
func (c *Client) PutTelegrafsID(ctx context.Context, params *PutTelegrafsIDAllParams) (*Telegraf, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "telegrafID", runtime.ParamLocationPath, params.TelegrafID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./telegrafs/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Telegraf{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetTelegrafsIDLabels calls the GET on /telegrafs/{telegrafID}/labels
// List all labels for a Telegraf config
func (c *Client) GetTelegrafsIDLabels(ctx context.Context, params *GetTelegrafsIDLabelsAllParams) (*LabelsResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "telegrafID", runtime.ParamLocationPath, params.TelegrafID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./telegrafs/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelsResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostTelegrafsIDLabels calls the POST on /telegrafs/{telegrafID}/labels
// Add a label to a Telegraf config
func (c *Client) PostTelegrafsIDLabels(ctx context.Context, params *PostTelegrafsIDLabelsAllParams) (*LabelResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "telegrafID", runtime.ParamLocationPath, params.TelegrafID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./telegrafs/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelResponse{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteTelegrafsIDLabelsID calls the DELETE on /telegrafs/{telegrafID}/labels/{labelID}
// Delete a label from a Telegraf config
func (c *Client) DeleteTelegrafsIDLabelsID(ctx context.Context, params *DeleteTelegrafsIDLabelsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "telegrafID", runtime.ParamLocationPath, params.TelegrafID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "labelID", runtime.ParamLocationPath, params.LabelID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./telegrafs/%s/labels/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetTelegrafsIDMembers calls the GET on /telegrafs/{telegrafID}/members
// List all users with member privileges for a Telegraf config
func (c *Client) GetTelegrafsIDMembers(ctx context.Context, params *GetTelegrafsIDMembersAllParams) (*ResourceMembers, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "telegrafID", runtime.ParamLocationPath, params.TelegrafID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./telegrafs/%s/members", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceMembers{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostTelegrafsIDMembers calls the POST on /telegrafs/{telegrafID}/members
// Add a member to a Telegraf config
func (c *Client) PostTelegrafsIDMembers(ctx context.Context, params *PostTelegrafsIDMembersAllParams) (*ResourceMember, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "telegrafID", runtime.ParamLocationPath, params.TelegrafID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./telegrafs/%s/members", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceMember{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteTelegrafsIDMembersID calls the DELETE on /telegrafs/{telegrafID}/members/{userID}
// Remove a member from a Telegraf config
func (c *Client) DeleteTelegrafsIDMembersID(ctx context.Context, params *DeleteTelegrafsIDMembersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "telegrafID", runtime.ParamLocationPath, params.TelegrafID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./telegrafs/%s/members/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetTelegrafsIDOwners calls the GET on /telegrafs/{telegrafID}/owners
// List all owners of a Telegraf configuration
func (c *Client) GetTelegrafsIDOwners(ctx context.Context, params *GetTelegrafsIDOwnersAllParams) (*ResourceOwners, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "telegrafID", runtime.ParamLocationPath, params.TelegrafID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./telegrafs/%s/owners", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceOwners{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostTelegrafsIDOwners calls the POST on /telegrafs/{telegrafID}/owners
// Add an owner to a Telegraf configuration
func (c *Client) PostTelegrafsIDOwners(ctx context.Context, params *PostTelegrafsIDOwnersAllParams) (*ResourceOwner, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "telegrafID", runtime.ParamLocationPath, params.TelegrafID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./telegrafs/%s/owners", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &ResourceOwner{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteTelegrafsIDOwnersID calls the DELETE on /telegrafs/{telegrafID}/owners/{userID}
// Remove an owner from a Telegraf config
func (c *Client) DeleteTelegrafsIDOwnersID(ctx context.Context, params *DeleteTelegrafsIDOwnersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "telegrafID", runtime.ParamLocationPath, params.TelegrafID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./telegrafs/%s/owners/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// ExportTemplate calls the POST on /templates/export
// Export a new template
func (c *Client) ExportTemplate(ctx context.Context, params *ExportTemplateAllParams) (*Template, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./templates/export")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Template{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetUsers calls the GET on /users
// List users
func (c *Client) GetUsers(ctx context.Context, params *GetUsersParams) (*Users, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./users")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "offset", runtime.ParamLocationQuery, *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "limit", runtime.ParamLocationQuery, *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.After != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "after", runtime.ParamLocationQuery, *params.After); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "name", runtime.ParamLocationQuery, *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Id != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "id", runtime.ParamLocationQuery, *params.Id); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Users{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostUsers calls the POST on /users
// Create a user
func (c *Client) PostUsers(ctx context.Context, params *PostUsersAllParams) (*UserResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./users")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UserResponse{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteUsersID calls the DELETE on /users/{userID}
// Delete a user
func (c *Client) DeleteUsersID(ctx context.Context, params *DeleteUsersIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./users/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetUsersID calls the GET on /users/{userID}
// Retrieve a user
func (c *Client) GetUsersID(ctx context.Context, params *GetUsersIDAllParams) (*UserResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./users/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UserResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchUsersID calls the PATCH on /users/{userID}
// Update a user
func (c *Client) PatchUsersID(ctx context.Context, params *PatchUsersIDAllParams) (*UserResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./users/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &UserResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostUsersIDPassword calls the POST on /users/{userID}/password
// Update a password
func (c *Client) PostUsersIDPassword(ctx context.Context, params *PostUsersIDPasswordAllParams) error {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "userID", runtime.ParamLocationPath, params.UserID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./users/%s/password", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetVariables calls the GET on /variables
// List all variables
func (c *Client) GetVariables(ctx context.Context, params *GetVariablesParams) (*Variables, error) {
	var err error

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./variables")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "org", runtime.ParamLocationQuery, *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParamWithLocation("form", true, "orgID", runtime.ParamLocationQuery, *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Variables{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostVariables calls the POST on /variables
// Create a variable
func (c *Client) PostVariables(ctx context.Context, params *PostVariablesAllParams) (*Variable, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./variables")

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Variable{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteVariablesID calls the DELETE on /variables/{variableID}
// Delete a variable
func (c *Client) DeleteVariablesID(ctx context.Context, params *DeleteVariablesIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "variableID", runtime.ParamLocationPath, params.VariableID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./variables/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

// GetVariablesID calls the GET on /variables/{variableID}
// Retrieve a variable
func (c *Client) GetVariablesID(ctx context.Context, params *GetVariablesIDAllParams) (*Variable, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "variableID", runtime.ParamLocationPath, params.VariableID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./variables/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Variable{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PatchVariablesID calls the PATCH on /variables/{variableID}
// Update a variable
func (c *Client) PatchVariablesID(ctx context.Context, params *PatchVariablesIDAllParams) (*Variable, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "variableID", runtime.ParamLocationPath, params.VariableID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./variables/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Variable{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PutVariablesID calls the PUT on /variables/{variableID}
// Replace a variable
func (c *Client) PutVariablesID(ctx context.Context, params *PutVariablesIDAllParams) (*Variable, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "variableID", runtime.ParamLocationPath, params.VariableID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./variables/%s", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &Variable{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// GetVariablesIDLabels calls the GET on /variables/{variableID}/labels
// List all labels for a variable
func (c *Client) GetVariablesIDLabels(ctx context.Context, params *GetVariablesIDLabelsAllParams) (*LabelsResponse, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "variableID", runtime.ParamLocationPath, params.VariableID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./variables/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelsResponse{}

	switch rsp.StatusCode {
	case 200:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// PostVariablesIDLabels calls the POST on /variables/{variableID}/labels
// Add a label to a variable
func (c *Client) PostVariablesIDLabels(ctx context.Context, params *PostVariablesIDLabelsAllParams) (*LabelResponse, error) {
	var err error
	var bodyReader io.Reader
	buf, err := json.Marshal(params.Body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "variableID", runtime.ParamLocationPath, params.VariableID)
	if err != nil {
		return nil, err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return nil, err
	}

	operationPath := fmt.Sprintf("./variables/%s/labels", pathParam0)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), bodyReader)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", "application/json")

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return nil, err
	}
	bodyBytes, err := io.ReadAll(rsp.Body)

	defer func() { _ = rsp.Body.Close() }()
	if err != nil {
		return nil, err
	}

	response := &LabelResponse{}

	switch rsp.StatusCode {
	case 201:
		if err := unmarshalJSONResponse(bodyBytes, &response); err != nil {
			return nil, err
		}
	default:
		return nil, decodeError(bodyBytes, rsp)
	}
	return response, nil

}

// DeleteVariablesIDLabelsID calls the DELETE on /variables/{variableID}/labels/{labelID}
// Delete a label from a variable
func (c *Client) DeleteVariablesIDLabelsID(ctx context.Context, params *DeleteVariablesIDLabelsIDAllParams) error {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParamWithLocation("simple", false, "variableID", runtime.ParamLocationPath, params.VariableID)
	if err != nil {
		return err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParamWithLocation("simple", false, "labelID", runtime.ParamLocationPath, params.LabelID)
	if err != nil {
		return err
	}

	serverURL, err := url.Parse(c.APIEndpoint)
	if err != nil {
		return err
	}

	operationPath := fmt.Sprintf("./variables/%s/labels/%s", pathParam0, pathParam1)

	queryURL, err := serverURL.Parse(operationPath)
	if err != nil {
		return err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParamWithLocation("simple", false, "Zap-Trace-Span", runtime.ParamLocationHeader, *params.ZapTraceSpan)
		if err != nil {
			return err
		}

		req.Header.Set("Zap-Trace-Span", headerParam0)
	}

	req = req.WithContext(ctx)
	rsp, err := c.Client.Do(req)
	if err != nil {
		return err
	}

	defer func() { _ = rsp.Body.Close() }()

	if rsp.StatusCode > 299 {
		bodyBytes, err := io.ReadAll(rsp.Body)
		if err != nil {
			return err
		}
		return decodeError(bodyBytes, rsp)
	}
	return nil

}

/*

 */
