;; Tests for i16x8 arithmetic operations on major boundary values and all special values.


(module
  (func (export "i16x8.add") (param v128 v128) (result v128) (i16x8.add (local.get 0) (local.get 1)))
  (func (export "i16x8.sub") (param v128 v128) (result v128) (i16x8.sub (local.get 0) (local.get 1)))
  (func (export "i16x8.mul") (param v128 v128) (result v128) (i16x8.mul (local.get 0) (local.get 1)))
  (func (export "i16x8.neg") (param v128) (result v128) (i16x8.neg (local.get 0)))
)


;; i16x8.add
(assert_return (invoke "i16x8.add" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.add" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.add" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.add" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.add" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766))
(assert_return (invoke "i16x8.add" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.add" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.add" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                   (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.add" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.add" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.add" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.add" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                   (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766))
(assert_return (invoke "i16x8.add" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                   (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff)
                                   (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000)
                                   (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add" (v128.const i16x8 -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff)
                                   (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.add" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                   (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                   (v128.const i16x8 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
                                   (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const i16x8 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                   (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                   (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                   (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i8x16 0 0x80 0 0x80 0 0x80 0 0x80 0 0x80 0 0x80 0 0x80 0 0x80))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.add" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i32x4 0x80008000 0x80008000 0x80008000 0x80008000))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.add" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 +0.0 +0.0 +0.0 +0.0))
                                   (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                   (v128.const i16x8 0x8000 0 0x8000 0 0x8000 0 0x8000 0))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
                                   (v128.const i16x8 0x8000 0xbf80 0x8000 0xbf80 0x8000 0xbf80 0x8000 0xbf80))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 -1.0 -1.0 -1.0 -1.0))
                                   (v128.const i16x8 0x8000 0x3f80 0x8000 0x3f80 0x8000 0x3f80 0x8000 0x3f80))
(assert_return (invoke "i16x8.add" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const f32x4 +inf +inf +inf +inf))
                                   (v128.const i16x8 0x01 0x7f81 0x01 0x7f81 0x01 0x7f81 0x01 0x7f81))
(assert_return (invoke "i16x8.add" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const i16x8 0x01 0xff81 0x01 0xff81 0x01 0xff81 0x01 0xff81))
(assert_return (invoke "i16x8.add" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const i16x8 0x01 0x7fc1 0x01 0x7fc1 0x01 0x7fc1 0x01 0x7fc1))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                   (v128.const i16x8 0 0xffff 0xfffe 0xfffd 0xfffc 0xfffb 0xfffa 0xfff9))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                   (v128.const i16x8 0 2 4 6 8 10 12 14))
                                   (v128.const i16x8 0 3 6 9 12 15 18 21))
(assert_return (invoke "i16x8.add" (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345)
                                   (v128.const i16x8 056_789 056_789 056_789 056_789 056_789 056_789 056_789 056_789))
                                   (v128.const i16x8 03_598 03_598 03_598 03_598 03_598 03_598 03_598 03_598))
(assert_return (invoke "i16x8.add" (v128.const i16x8 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234)
                                   (v128.const i16x8 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678))
                                   (v128.const i16x8 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac 0x0_68ac))

;; i16x8.sub
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 2 2 2 2 2 2 2 2))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 32764 32764 32764 32764 32764 32764 32764 32764))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 -32765 -32765 -32765 -32765 -32765 -32765 -32765 -32765))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff)
                                   (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000)
                                   (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff)
                                   (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                   (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                   (v128.const i16x8 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                   (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const i16x8 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01))
                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                   (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                   (v128.const i16x8 -2 -2 -2 -2 -2 -2 -2 -2))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                   (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i8x16 0 0x80 0 0x80 0 0x80 0 0x80 0 0x80 0 0x80 0 0x80 0 0x80))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                   (v128.const i16x8 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i32x4 0x80008000 0x80008000 0x80008000 0x80008000))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff))
                                   (v128.const i16x8 0x02 0x02 0x02 0x02 0x02 0x02 0x02 0x02))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 +0.0 +0.0 +0.0 +0.0))
                                   (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                   (v128.const i16x8 0x8000 0 0x8000 0 0x8000 0 0x8000 0))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
                                   (v128.const i16x8 0x8000 0x4080 0x8000 0x4080 0x8000 0x4080 0x8000 0x4080))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 -1.0 -1.0 -1.0 -1.0))
                                   (v128.const i16x8 0x8000 0xc080 0x8000 0xc080 0x8000 0xc080 0x8000 0xc080))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const f32x4 +inf +inf +inf +inf))
                                   (v128.const i16x8 0x01 0x8081 0x01 0x8081 0x01 0x8081 0x01 0x8081))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const i16x8 0x01 0x81 0x01 0x81 0x01 0x81 0x01 0x81))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const i16x8 0x01 0x8041 0x01 0x8041 0x01 0x8041 0x01 0x8041))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                   (v128.const i16x8 0 0xffff 0xfffe 0xfffd 0xfffc 0xfffb 0xfffa 0xfff9))
                                   (v128.const i16x8 0 0x02 0x04 0x06 0x08 0x0a 0x0c 0x0e))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                   (v128.const i16x8 0 2 4 6 8 10 12 14))
                                   (v128.const i16x8 0 -1 -2 -3 -4 -5 -6 -7))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 056_789 056_789 056_789 056_789 056_789 056_789 056_789 056_789)
                                   (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345))
                                   (v128.const i16x8 044_444 044_444 044_444 044_444 044_444 044_444 044_444 044_444))
(assert_return (invoke "i16x8.sub" (v128.const i16x8 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678)
                                   (v128.const i16x8 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234))
                                   (v128.const i16x8 0x0_4444 0x0_4444 0x0_4444 0x0_4444 0x0_4444 0x0_4444 0x0_4444 0x0_4444))

;; i16x8.mul
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff 0x3fff)
                                   (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000)
                                   (v128.const i16x8 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000 0x4000))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff -0x3fff)
                                   (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                   (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                   (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000 -0x4000)
                                   (v128.const i16x8 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001 -0x4001))
                                   (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const i16x8 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff)
                                   (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                   (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff)
                                   (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x1000 0x1000 0x1000 0x1000 0x1000 0x1000 0x1000 0x1000)
                                   (v128.const i8x16 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                   (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const i32x4 0x00020002 0x00020002 0x00020002 0x00020002))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                   (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff))
                                   (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 +0.0 +0.0 +0.0 +0.0))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 -1.0 -1.0 -1.0 -1.0))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const f32x4 +inf +inf +inf +inf))
                                   (v128.const i16x8 0 0x7f80 0 0x7f80 0 0x7f80 0 0x7f80))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const i16x8 0 0xff80 0 0xff80 0 0xff80 0 0xff80))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const i16x8 0 0x7fc0 0 0x7fc0 0 0x7fc0 0 0x7fc0))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                   (v128.const i16x8 0 0xffff 0xfffe 0xfffd 0xfffc 0xfffb 0xfffa 0xfff9))
                                   (v128.const i16x8 0 0xffff 0xfffc 0xfff7 0xfff0 0xffe7 0xffdc 0xffcf))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                   (v128.const i16x8 0 2 4 6 8 10 12 14))
                                   (v128.const i16x8 0 0x02 0x08 0x12 0x20 0x32 0x48 0x62))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345)
                                   (v128.const i16x8 056_789 056_789 056_789 056_789 056_789 056_789 056_789 056_789))
                                   (v128.const i16x8 021_613 021_613 021_613 021_613 021_613 021_613 021_613 021_613))
(assert_return (invoke "i16x8.mul" (v128.const i16x8 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234)
                                   (v128.const i16x8 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef 0x0_cdef))
                                   (v128.const i16x8 0x0_a28c 0x0_a28c 0x0_a28c 0x0_a28c 0x0_a28c 0x0_a28c 0x0_a28c 0x0_a28c))

;; i16x8.neg
(assert_return (invoke "i16x8.neg" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                   (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 1 1 1 1 1 1 1 1))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766))
                                   (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 0x01 0x01 0x01 0x01 0x01 0x01 0x01 0x01))
                                   (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01 -0x01))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 -0x7fff -0x7fff -0x7fff -0x7fff -0x7fff -0x7fff -0x7fff -0x7fff))
                                   (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
                                   (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
                                   (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
(assert_return (invoke "i16x8.neg" (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                   (v128.const i16x8 1 1 1 1 1 1 1 1))

;; type check
(assert_invalid (module (func (result v128) (i16x8.neg (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.add (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.sub (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.mul (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i16x8.neg-arg-empty (result v128)
      (i16x8.neg)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.add-1st-arg-empty (result v128)
      (i16x8.add (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.add-arg-empty (result v128)
      (i16x8.add)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.sub-1st-arg-empty (result v128)
      (i16x8.sub (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.sub-arg-empty (result v128)
      (i16x8.sub)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.mul-1st-arg-empty (result v128)
      (i16x8.mul (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.mul-arg-empty (result v128)
      (i16x8.mul)
    )
  )
  "type mismatch"
)

;; combination
(module
  (func (export "add-sub") (param v128 v128 v128) (result v128)
    (i16x8.add (i16x8.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "mul-add") (param v128 v128 v128) (result v128)
    (i16x8.mul (i16x8.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "mul-sub") (param v128 v128 v128) (result v128)
    (i16x8.mul (i16x8.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sub-add") (param v128 v128 v128) (result v128)
    (i16x8.sub (i16x8.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "add-neg") (param v128 v128) (result v128)
    (i16x8.add (i16x8.neg (local.get 0)) (local.get 1)))
  (func (export "mul-neg") (param v128 v128) (result v128)
    (i16x8.mul (i16x8.neg (local.get 0)) (local.get 1)))
  (func (export "sub-neg") (param v128 v128) (result v128)
    (i16x8.sub (i16x8.neg (local.get 0)) (local.get 1)))
)

(assert_return (invoke "add-sub" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                 (v128.const i16x8 0 2 4 6 8 10 12 14)
                                 (v128.const i16x8 0 2 4 6 8 10 12 14))
                                 (v128.const i16x8 0 1 2 3 4 5 6 7))
(assert_return (invoke "mul-add" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                 (v128.const i16x8 0 1 2 3 4 5 6 7)
                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                 (v128.const i16x8 0 4 8 12 16 20 24 28))
(assert_return (invoke "mul-sub" (v128.const i16x8 0 2 4 6 8 10 12 14)
                                 (v128.const i16x8 0 1 2 3 4 5 6 7)
                                 (v128.const i16x8 0 1 2 3 4 5 6 7))
                                 (v128.const i16x8 0 1 4 9 16 25 36 49))
(assert_return (invoke "sub-add" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                 (v128.const i16x8 0 2 4 6 8 10 12 14)
                                 (v128.const i16x8 0 2 4 6 8 10 12 14))
                                 (v128.const i16x8 0 1 2 3 4 5 6 7))
(assert_return (invoke "add-neg" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                 (v128.const i16x8 0 1 2 3 4 5 6 7))
                                 (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "mul-neg" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                 (v128.const i16x8 2 2 2 2 2 2 2 2))
                                 (v128.const i16x8 0 -2 -4 -6 -8 -10 -12 -14))
(assert_return (invoke "sub-neg" (v128.const i16x8 0 1 2 3 4 5 6 7)
                                 (v128.const i16x8 0 1 2 3 4 5 6 7))
                                 (v128.const i16x8 0 -2 -4 -6 -8 -10 -12 -14))