// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package networkmanagement provides access to the Network Management API.
//
// For product documentation, see: https://cloud.google.com/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/networkmanagement/v1"
//	...
//	ctx := context.Background()
//	networkmanagementService, err := networkmanagement.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	networkmanagementService, err := networkmanagement.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	networkmanagementService, err := networkmanagement.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package networkmanagement // import "google.golang.org/api/networkmanagement/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "networkmanagement:v1"
const apiName = "networkmanagement"
const apiVersion = "v1"
const basePath = "https://networkmanagement.googleapis.com/"
const basePathTemplate = "https://networkmanagement.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://networkmanagement.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Global = NewProjectsLocationsGlobalService(s)
	rs.VpcFlowLogsConfigs = NewProjectsLocationsVpcFlowLogsConfigsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Global *ProjectsLocationsGlobalService

	VpcFlowLogsConfigs *ProjectsLocationsVpcFlowLogsConfigsService
}

func NewProjectsLocationsGlobalService(s *Service) *ProjectsLocationsGlobalService {
	rs := &ProjectsLocationsGlobalService{s: s}
	rs.ConnectivityTests = NewProjectsLocationsGlobalConnectivityTestsService(s)
	rs.Operations = NewProjectsLocationsGlobalOperationsService(s)
	return rs
}

type ProjectsLocationsGlobalService struct {
	s *Service

	ConnectivityTests *ProjectsLocationsGlobalConnectivityTestsService

	Operations *ProjectsLocationsGlobalOperationsService
}

func NewProjectsLocationsGlobalConnectivityTestsService(s *Service) *ProjectsLocationsGlobalConnectivityTestsService {
	rs := &ProjectsLocationsGlobalConnectivityTestsService{s: s}
	return rs
}

type ProjectsLocationsGlobalConnectivityTestsService struct {
	s *Service
}

func NewProjectsLocationsGlobalOperationsService(s *Service) *ProjectsLocationsGlobalOperationsService {
	rs := &ProjectsLocationsGlobalOperationsService{s: s}
	return rs
}

type ProjectsLocationsGlobalOperationsService struct {
	s *Service
}

func NewProjectsLocationsVpcFlowLogsConfigsService(s *Service) *ProjectsLocationsVpcFlowLogsConfigsService {
	rs := &ProjectsLocationsVpcFlowLogsConfigsService{s: s}
	return rs
}

type ProjectsLocationsVpcFlowLogsConfigsService struct {
	s *Service
}

// AbortInfo: Details of the final state "abort" and associated resource.
type AbortInfo struct {
	// Cause: Causes that the analysis is aborted.
	//
	// Possible values:
	//   "CAUSE_UNSPECIFIED" - Cause is unspecified.
	//   "UNKNOWN_NETWORK" - Aborted due to unknown network. Deprecated, not used
	// in the new tests.
	//   "UNKNOWN_PROJECT" - Aborted because no project information can be derived
	// from the test input. Deprecated, not used in the new tests.
	//   "NO_EXTERNAL_IP" - Aborted because traffic is sent from a public IP to an
	// instance without an external IP. Deprecated, not used in the new tests.
	//   "UNINTENDED_DESTINATION" - Aborted because none of the traces matches
	// destination information specified in the input test request. Deprecated, not
	// used in the new tests.
	//   "SOURCE_ENDPOINT_NOT_FOUND" - Aborted because the source endpoint could
	// not be found. Deprecated, not used in the new tests.
	//   "MISMATCHED_SOURCE_NETWORK" - Aborted because the source network does not
	// match the source endpoint. Deprecated, not used in the new tests.
	//   "DESTINATION_ENDPOINT_NOT_FOUND" - Aborted because the destination
	// endpoint could not be found. Deprecated, not used in the new tests.
	//   "MISMATCHED_DESTINATION_NETWORK" - Aborted because the destination network
	// does not match the destination endpoint. Deprecated, not used in the new
	// tests.
	//   "UNKNOWN_IP" - Aborted because no endpoint with the packet's destination
	// IP address is found.
	//   "GOOGLE_MANAGED_SERVICE_UNKNOWN_IP" - Aborted because no endpoint with the
	// packet's destination IP is found in the Google-managed project.
	//   "SOURCE_IP_ADDRESS_NOT_IN_SOURCE_NETWORK" - Aborted because the source IP
	// address doesn't belong to any of the subnets of the source VPC network.
	//   "PERMISSION_DENIED" - Aborted because user lacks permission to access all
	// or part of the network configurations required to run the test.
	//   "PERMISSION_DENIED_NO_CLOUD_NAT_CONFIGS" - Aborted because user lacks
	// permission to access Cloud NAT configs required to run the test.
	//   "PERMISSION_DENIED_NO_NEG_ENDPOINT_CONFIGS" - Aborted because user lacks
	// permission to access Network endpoint group endpoint configs required to run
	// the test.
	//   "PERMISSION_DENIED_NO_CLOUD_ROUTER_CONFIGS" - Aborted because user lacks
	// permission to access Cloud Router configs required to run the test.
	//   "NO_SOURCE_LOCATION" - Aborted because no valid source or destination
	// endpoint is derived from the input test request.
	//   "INVALID_ARGUMENT" - Aborted because the source or destination endpoint
	// specified in the request is invalid. Some examples: - The request might
	// contain malformed resource URI, project ID, or IP address. - The request
	// might contain inconsistent information (for example, the request might
	// include both the instance and the network, but the instance might not have a
	// NIC in that network).
	//   "TRACE_TOO_LONG" - Aborted because the number of steps in the trace
	// exceeds a certain limit. It might be caused by a routing loop.
	//   "INTERNAL_ERROR" - Aborted due to internal server error.
	//   "UNSUPPORTED" - Aborted because the test scenario is not supported.
	//   "MISMATCHED_IP_VERSION" - Aborted because the source and destination
	// resources have no common IP version.
	//   "GKE_KONNECTIVITY_PROXY_UNSUPPORTED" - Aborted because the connection
	// between the control plane and the node of the source cluster is initiated by
	// the node and managed by the Konnectivity proxy.
	//   "RESOURCE_CONFIG_NOT_FOUND" - Aborted because expected resource
	// configuration was missing.
	//   "VM_INSTANCE_CONFIG_NOT_FOUND" - Aborted because expected VM instance
	// configuration was missing.
	//   "NETWORK_CONFIG_NOT_FOUND" - Aborted because expected network
	// configuration was missing.
	//   "FIREWALL_CONFIG_NOT_FOUND" - Aborted because expected firewall
	// configuration was missing.
	//   "ROUTE_CONFIG_NOT_FOUND" - Aborted because expected route configuration
	// was missing.
	//   "GOOGLE_MANAGED_SERVICE_AMBIGUOUS_PSC_ENDPOINT" - Aborted because a PSC
	// endpoint selection for the Google-managed service is ambiguous (several PSC
	// endpoints satisfy test input).
	//   "SOURCE_PSC_CLOUD_SQL_UNSUPPORTED" - Aborted because tests with a
	// PSC-based Cloud SQL instance as a source are not supported.
	//   "SOURCE_REDIS_CLUSTER_UNSUPPORTED" - Aborted because tests with a Redis
	// Cluster as a source are not supported.
	//   "SOURCE_REDIS_INSTANCE_UNSUPPORTED" - Aborted because tests with a Redis
	// Instance as a source are not supported.
	//   "SOURCE_FORWARDING_RULE_UNSUPPORTED" - Aborted because tests with a
	// forwarding rule as a source are not supported.
	//   "NON_ROUTABLE_IP_ADDRESS" - Aborted because one of the endpoints is a
	// non-routable IP address (loopback, link-local, etc).
	//   "UNKNOWN_ISSUE_IN_GOOGLE_MANAGED_PROJECT" - Aborted due to an unknown
	// issue in the Google-managed project.
	//   "UNSUPPORTED_GOOGLE_MANAGED_PROJECT_CONFIG" - Aborted due to an
	// unsupported configuration of the Google-managed project.
	//   "NO_SERVERLESS_IP_RANGES" - Aborted because the source endpoint is a Cloud
	// Run revision with direct VPC access enabled, but there are no reserved
	// serverless IP ranges.
	Cause string `json:"cause,omitempty"`
	// IpAddress: IP address that caused the abort.
	IpAddress string `json:"ipAddress,omitempty"`
	// ProjectsMissingPermission: List of project IDs the user specified in the
	// request but lacks access to. In this case, analysis is aborted with the
	// PERMISSION_DENIED cause.
	ProjectsMissingPermission []string `json:"projectsMissingPermission,omitempty"`
	// ResourceUri: URI of the resource that caused the abort.
	ResourceUri string `json:"resourceUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cause") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cause") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AbortInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AbortInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppEngineVersionEndpoint: Wrapper for the App Engine service version
// attributes.
type AppEngineVersionEndpoint struct {
	// Uri: An App Engine (https://cloud.google.com/appengine) [service
	// version](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/
	// apps.services.versions) name.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppEngineVersionEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod AppEngineVersionEndpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppEngineVersionInfo: For display only. Metadata associated with an App
// Engine version.
type AppEngineVersionInfo struct {
	// DisplayName: Name of an App Engine version.
	DisplayName string `json:"displayName,omitempty"`
	// Environment: App Engine execution environment for a version.
	Environment string `json:"environment,omitempty"`
	// Runtime: Runtime of the App Engine version.
	Runtime string `json:"runtime,omitempty"`
	// Uri: URI of an App Engine version.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppEngineVersionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppEngineVersionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// CloudFunctionEndpoint: Wrapper for Cloud Function attributes.
type CloudFunctionEndpoint struct {
	// Uri: A Cloud Function (https://cloud.google.com/functions) name.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudFunctionEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod CloudFunctionEndpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudFunctionInfo: For display only. Metadata associated with a Cloud
// Function.
type CloudFunctionInfo struct {
	// DisplayName: Name of a Cloud Function.
	DisplayName string `json:"displayName,omitempty"`
	// Location: Location in which the Cloud Function is deployed.
	Location string `json:"location,omitempty"`
	// Uri: URI of a Cloud Function.
	Uri string `json:"uri,omitempty"`
	// VersionId: Latest successfully deployed version id of the Cloud Function.
	VersionId int64 `json:"versionId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudFunctionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CloudFunctionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudRunRevisionEndpoint: Wrapper for Cloud Run revision attributes.
type CloudRunRevisionEndpoint struct {
	// Uri: A Cloud Run (https://cloud.google.com/run)
	// [revision](https://cloud.google.com/run/docs/reference/rest/v1/namespaces.rev
	// isions/get) URI. The format is:
	// projects/{project}/locations/{location}/revisions/{revision}
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudRunRevisionEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod CloudRunRevisionEndpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudRunRevisionInfo: For display only. Metadata associated with a Cloud Run
// revision.
type CloudRunRevisionInfo struct {
	// DisplayName: Name of a Cloud Run revision.
	DisplayName string `json:"displayName,omitempty"`
	// Location: Location in which this revision is deployed.
	Location string `json:"location,omitempty"`
	// ServiceUri: URI of Cloud Run service this revision belongs to.
	ServiceUri string `json:"serviceUri,omitempty"`
	// Uri: URI of a Cloud Run revision.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudRunRevisionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CloudRunRevisionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudSQLInstanceInfo: For display only. Metadata associated with a Cloud SQL
// instance.
type CloudSQLInstanceInfo struct {
	// DisplayName: Name of a Cloud SQL instance.
	DisplayName string `json:"displayName,omitempty"`
	// ExternalIp: External IP address of a Cloud SQL instance.
	ExternalIp string `json:"externalIp,omitempty"`
	// InternalIp: Internal IP address of a Cloud SQL instance.
	InternalIp string `json:"internalIp,omitempty"`
	// NetworkUri: URI of a Cloud SQL instance network or empty string if the
	// instance does not have one.
	NetworkUri string `json:"networkUri,omitempty"`
	// Region: Region in which the Cloud SQL instance is running.
	Region string `json:"region,omitempty"`
	// Uri: URI of a Cloud SQL instance.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudSQLInstanceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CloudSQLInstanceInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConnectivityTest: A Connectivity Test for a network reachability analysis.
type ConnectivityTest struct {
	// BypassFirewallChecks: Whether the analysis should skip firewall checking.
	// Default value is false.
	BypassFirewallChecks bool `json:"bypassFirewallChecks,omitempty"`
	// CreateTime: Output only. The time the test was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: The user-supplied description of the Connectivity Test. Maximum
	// of 512 characters.
	Description string `json:"description,omitempty"`
	// Destination: Required. Destination specification of the Connectivity Test.
	// You can use a combination of destination IP address, URI of a supported
	// endpoint, project ID, or VPC network to identify the destination location.
	// Reachability analysis proceeds even if the destination location is
	// ambiguous. However, the test result might include endpoints or use a
	// destination that you don't intend to test.
	Destination *Endpoint `json:"destination,omitempty"`
	// DisplayName: Output only. The display name of a Connectivity Test.
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Resource labels to represent user-provided metadata.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Unique name of the resource using the form:
	// `projects/{project_id}/locations/global/connectivityTests/{test_id}`
	Name string `json:"name,omitempty"`
	// ProbingDetails: Output only. The probing details of this test from the
	// latest run, present for applicable tests only. The details are updated when
	// creating a new test, updating an existing test, or triggering a one-time
	// rerun of an existing test.
	ProbingDetails *ProbingDetails `json:"probingDetails,omitempty"`
	// Protocol: IP Protocol of the test. When not provided, "TCP" is assumed.
	Protocol string `json:"protocol,omitempty"`
	// ReachabilityDetails: Output only. The reachability details of this test from
	// the latest run. The details are updated when creating a new test, updating
	// an existing test, or triggering a one-time rerun of an existing test.
	ReachabilityDetails *ReachabilityDetails `json:"reachabilityDetails,omitempty"`
	// RelatedProjects: Other projects that may be relevant for reachability
	// analysis. This is applicable to scenarios where a test can cross project
	// boundaries.
	RelatedProjects []string `json:"relatedProjects,omitempty"`
	// ReturnReachabilityDetails: Output only. The reachability details of this
	// test from the latest run for the return path. The details are updated when
	// creating a new test, updating an existing test, or triggering a one-time
	// rerun of an existing test.
	ReturnReachabilityDetails *ReachabilityDetails `json:"returnReachabilityDetails,omitempty"`
	// RoundTrip: Whether run analysis for the return path from destination to
	// source. Default value is false.
	RoundTrip bool `json:"roundTrip,omitempty"`
	// Source: Required. Source specification of the Connectivity Test. You can use
	// a combination of source IP address, URI of a supported endpoint, project ID,
	// or VPC network to identify the source location. Reachability analysis might
	// proceed even if the source location is ambiguous. However, the test result
	// might include endpoints or use a source that you don't intend to test.
	Source *Endpoint `json:"source,omitempty"`
	// UpdateTime: Output only. The time the test's configuration was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BypassFirewallChecks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BypassFirewallChecks") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConnectivityTest) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectivityTest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeliverInfo: Details of the final state "deliver" and associated resource.
type DeliverInfo struct {
	// IpAddress: IP address of the target (if applicable).
	IpAddress string `json:"ipAddress,omitempty"`
	// PscGoogleApiTarget: PSC Google API target the packet is delivered to (if
	// applicable).
	PscGoogleApiTarget string `json:"pscGoogleApiTarget,omitempty"`
	// ResourceUri: URI of the resource that the packet is delivered to.
	ResourceUri string `json:"resourceUri,omitempty"`
	// StorageBucket: Name of the Cloud Storage Bucket the packet is delivered to
	// (if applicable).
	StorageBucket string `json:"storageBucket,omitempty"`
	// Target: Target type where the packet is delivered to.
	//
	// Possible values:
	//   "TARGET_UNSPECIFIED" - Target not specified.
	//   "INSTANCE" - Target is a Compute Engine instance.
	//   "INTERNET" - Target is the internet.
	//   "GOOGLE_API" - Target is a Google API.
	//   "GKE_MASTER" - Target is a Google Kubernetes Engine cluster master.
	//   "CLOUD_SQL_INSTANCE" - Target is a Cloud SQL instance.
	//   "PSC_PUBLISHED_SERVICE" - Target is a published service that uses [Private
	// Service
	// Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-
	// services).
	//   "PSC_GOOGLE_API" - Target is Google APIs that use [Private Service
	// Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-
	// apis).
	//   "PSC_VPC_SC" - Target is a VPC-SC that uses [Private Service
	// Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-
	// apis).
	//   "SERVERLESS_NEG" - Target is a serverless network endpoint group.
	//   "STORAGE_BUCKET" - Target is a Cloud Storage bucket.
	//   "PRIVATE_NETWORK" - Target is a private network. Used only for return
	// traces.
	//   "CLOUD_FUNCTION" - Target is a Cloud Function. Used only for return
	// traces.
	//   "APP_ENGINE_VERSION" - Target is a App Engine service version. Used only
	// for return traces.
	//   "CLOUD_RUN_REVISION" - Target is a Cloud Run revision. Used only for
	// return traces.
	//   "GOOGLE_MANAGED_SERVICE" - Target is a Google-managed service. Used only
	// for return traces.
	//   "REDIS_INSTANCE" - Target is a Redis Instance.
	//   "REDIS_CLUSTER" - Target is a Redis Cluster.
	Target string `json:"target,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IpAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IpAddress") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeliverInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DeliverInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DirectVpcEgressConnectionInfo: For display only. Metadata associated with a
// serverless direct VPC egress connection.
type DirectVpcEgressConnectionInfo struct {
	// NetworkUri: URI of direct access network.
	NetworkUri string `json:"networkUri,omitempty"`
	// Region: Region in which the Direct VPC egress is deployed.
	Region string `json:"region,omitempty"`
	// SelectedIpAddress: Selected starting IP address, from the selected IP range.
	SelectedIpAddress string `json:"selectedIpAddress,omitempty"`
	// SelectedIpRange: Selected IP range.
	SelectedIpRange string `json:"selectedIpRange,omitempty"`
	// SubnetworkUri: URI of direct access subnetwork.
	SubnetworkUri string `json:"subnetworkUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NetworkUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NetworkUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DirectVpcEgressConnectionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DirectVpcEgressConnectionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DropInfo: Details of the final state "drop" and associated resource.
type DropInfo struct {
	// Cause: Cause that the packet is dropped.
	//
	// Possible values:
	//   "CAUSE_UNSPECIFIED" - Cause is unspecified.
	//   "UNKNOWN_EXTERNAL_ADDRESS" - Destination external address cannot be
	// resolved to a known target. If the address is used in a Google Cloud
	// project, provide the project ID as test input.
	//   "FOREIGN_IP_DISALLOWED" - A Compute Engine instance can only send or
	// receive a packet with a foreign IP address if ip_forward is enabled.
	//   "FIREWALL_RULE" - Dropped due to a firewall rule, unless allowed due to
	// connection tracking.
	//   "NO_ROUTE" - Dropped due to no matching routes.
	//   "ROUTE_BLACKHOLE" - Dropped due to invalid route. Route's next hop is a
	// blackhole.
	//   "ROUTE_WRONG_NETWORK" - Packet is sent to a wrong (unintended) network.
	// Example: you trace a packet from VM1:Network1 to VM2:Network2, however, the
	// route configured in Network1 sends the packet destined for VM2's IP address
	// to Network3.
	//   "ROUTE_NEXT_HOP_IP_ADDRESS_NOT_RESOLVED" - Route's next hop IP address
	// cannot be resolved to a GCP resource.
	//   "ROUTE_NEXT_HOP_RESOURCE_NOT_FOUND" - Route's next hop resource is not
	// found.
	//   "ROUTE_NEXT_HOP_INSTANCE_WRONG_NETWORK" - Route's next hop instance
	// doesn't have a NIC in the route's network.
	//   "ROUTE_NEXT_HOP_INSTANCE_NON_PRIMARY_IP" - Route's next hop IP address is
	// not a primary IP address of the next hop instance.
	//   "ROUTE_NEXT_HOP_FORWARDING_RULE_IP_MISMATCH" - Route's next hop forwarding
	// rule doesn't match next hop IP address.
	//   "ROUTE_NEXT_HOP_VPN_TUNNEL_NOT_ESTABLISHED" - Route's next hop VPN tunnel
	// is down (does not have valid IKE SAs).
	//   "ROUTE_NEXT_HOP_FORWARDING_RULE_TYPE_INVALID" - Route's next hop
	// forwarding rule type is invalid (it's not a forwarding rule of the internal
	// passthrough load balancer).
	//   "NO_ROUTE_FROM_INTERNET_TO_PRIVATE_IPV6_ADDRESS" - Packet is sent from the
	// Internet to the private IPv6 address.
	//   "VPN_TUNNEL_LOCAL_SELECTOR_MISMATCH" - The packet does not match a
	// policy-based VPN tunnel local selector.
	//   "VPN_TUNNEL_REMOTE_SELECTOR_MISMATCH" - The packet does not match a
	// policy-based VPN tunnel remote selector.
	//   "PRIVATE_TRAFFIC_TO_INTERNET" - Packet with internal destination address
	// sent to the internet gateway.
	//   "PRIVATE_GOOGLE_ACCESS_DISALLOWED" - Endpoint with only an internal IP
	// address tries to access Google API and services, but Private Google Access
	// is not enabled in the subnet or is not applicable.
	//   "PRIVATE_GOOGLE_ACCESS_VIA_VPN_TUNNEL_UNSUPPORTED" - Source endpoint tries
	// to access Google API and services through the VPN tunnel to another network,
	// but Private Google Access needs to be enabled in the source endpoint
	// network.
	//   "NO_EXTERNAL_ADDRESS" - Endpoint with only an internal IP address tries to
	// access external hosts, but there is no matching Cloud NAT gateway in the
	// subnet.
	//   "UNKNOWN_INTERNAL_ADDRESS" - Destination internal address cannot be
	// resolved to a known target. If this is a shared VPC scenario, verify if the
	// service project ID is provided as test input. Otherwise, verify if the IP
	// address is being used in the project.
	//   "FORWARDING_RULE_MISMATCH" - Forwarding rule's protocol and ports do not
	// match the packet header.
	//   "FORWARDING_RULE_NO_INSTANCES" - Forwarding rule does not have backends
	// configured.
	//   "FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK" - Firewalls block
	// the health check probes to the backends and cause the backends to be
	// unavailable for traffic from the load balancer. For more details, see
	// [Health check firewall
	// rules](https://cloud.google.com/load-balancing/docs/health-checks#firewall_ru
	// les).
	//   "INGRESS_FIREWALL_TAGS_UNSUPPORTED_BY_DIRECT_VPC_EGRESS" - Matching
	// ingress firewall rules by network tags for packets sent via serverless VPC
	// direct egress is unsupported. Behavior is undefined.
	// https://cloud.google.com/run/docs/configuring/vpc-direct-vpc#limitations
	//   "INSTANCE_NOT_RUNNING" - Packet is sent from or to a Compute Engine
	// instance that is not in a running state.
	//   "GKE_CLUSTER_NOT_RUNNING" - Packet sent from or to a GKE cluster that is
	// not in running state.
	//   "CLOUD_SQL_INSTANCE_NOT_RUNNING" - Packet sent from or to a Cloud SQL
	// instance that is not in running state.
	//   "REDIS_INSTANCE_NOT_RUNNING" - Packet sent from or to a Redis Instance
	// that is not in running state.
	//   "REDIS_CLUSTER_NOT_RUNNING" - Packet sent from or to a Redis Cluster that
	// is not in running state.
	//   "TRAFFIC_TYPE_BLOCKED" - The type of traffic is blocked and the user
	// cannot configure a firewall rule to enable it. See [Always blocked
	// traffic](https://cloud.google.com/vpc/docs/firewalls#blockedtraffic) for
	// more details.
	//   "GKE_MASTER_UNAUTHORIZED_ACCESS" - Access to Google Kubernetes Engine
	// cluster master's endpoint is not authorized. See [Access to the cluster
	// endpoints](https://cloud.google.com/kubernetes-engine/docs/how-to/private-clu
	// sters#access_to_the_cluster_endpoints) for more details.
	//   "CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS" - Access to the Cloud SQL
	// instance endpoint is not authorized. See [Authorizing with authorized
	// networks](https://cloud.google.com/sql/docs/mysql/authorize-networks) for
	// more details.
	//   "DROPPED_INSIDE_GKE_SERVICE" - Packet was dropped inside Google Kubernetes
	// Engine Service.
	//   "DROPPED_INSIDE_CLOUD_SQL_SERVICE" - Packet was dropped inside Cloud SQL
	// Service.
	//   "GOOGLE_MANAGED_SERVICE_NO_PEERING" - Packet was dropped because there is
	// no peering between the originating network and the Google Managed Services
	// Network.
	//   "GOOGLE_MANAGED_SERVICE_NO_PSC_ENDPOINT" - Packet was dropped because the
	// Google-managed service uses Private Service Connect (PSC), but the PSC
	// endpoint is not found in the project.
	//   "GKE_PSC_ENDPOINT_MISSING" - Packet was dropped because the GKE cluster
	// uses Private Service Connect (PSC), but the PSC endpoint is not found in the
	// project.
	//   "CLOUD_SQL_INSTANCE_NO_IP_ADDRESS" - Packet was dropped because the Cloud
	// SQL instance has neither a private nor a public IP address.
	//   "GKE_CONTROL_PLANE_REGION_MISMATCH" - Packet was dropped because a GKE
	// cluster private endpoint is unreachable from a region different from the
	// cluster's region.
	//   "PUBLIC_GKE_CONTROL_PLANE_TO_PRIVATE_DESTINATION" - Packet sent from a
	// public GKE cluster control plane to a private IP address.
	//   "GKE_CONTROL_PLANE_NO_ROUTE" - Packet was dropped because there is no
	// route from a GKE cluster control plane to a destination network.
	//   "CLOUD_SQL_INSTANCE_NOT_CONFIGURED_FOR_EXTERNAL_TRAFFIC" - Packet sent
	// from a Cloud SQL instance to an external IP address is not allowed. The
	// Cloud SQL instance is not configured to send packets to external IP
	// addresses.
	//   "PUBLIC_CLOUD_SQL_INSTANCE_TO_PRIVATE_DESTINATION" - Packet sent from a
	// Cloud SQL instance with only a public IP address to a private IP address.
	//   "CLOUD_SQL_INSTANCE_NO_ROUTE" - Packet was dropped because there is no
	// route from a Cloud SQL instance to a destination network.
	//   "CLOUD_SQL_CONNECTOR_REQUIRED" - Packet was dropped because the Cloud SQL
	// instance requires all connections to use Cloud SQL connectors and to target
	// the Cloud SQL proxy port (3307).
	//   "CLOUD_FUNCTION_NOT_ACTIVE" - Packet could be dropped because the Cloud
	// Function is not in an active status.
	//   "VPC_CONNECTOR_NOT_SET" - Packet could be dropped because no VPC connector
	// is set.
	//   "VPC_CONNECTOR_NOT_RUNNING" - Packet could be dropped because the VPC
	// connector is not in a running state.
	//   "VPC_CONNECTOR_SERVERLESS_TRAFFIC_BLOCKED" - Packet could be dropped
	// because the traffic from the serverless service to the VPC connector is not
	// allowed.
	//   "VPC_CONNECTOR_HEALTH_CHECK_TRAFFIC_BLOCKED" - Packet could be dropped
	// because the health check traffic to the VPC connector is not allowed.
	//   "FORWARDING_RULE_REGION_MISMATCH" - Packet could be dropped because it was
	// sent from a different region to a regional forwarding without global access.
	//   "PSC_CONNECTION_NOT_ACCEPTED" - The Private Service Connect endpoint is in
	// a project that is not approved to connect to the service.
	//   "PSC_ENDPOINT_ACCESSED_FROM_PEERED_NETWORK" - The packet is sent to the
	// Private Service Connect endpoint over the peering, but [it's not
	// supported](https://cloud.google.com/vpc/docs/configure-private-service-connec
	// t-services#on-premises).
	//   "PSC_NEG_PRODUCER_ENDPOINT_NO_GLOBAL_ACCESS" - The packet is sent to the
	// Private Service Connect backend (network endpoint group), but the producer
	// PSC forwarding rule does not have global access enabled.
	//   "PSC_NEG_PRODUCER_FORWARDING_RULE_MULTIPLE_PORTS" - The packet is sent to
	// the Private Service Connect backend (network endpoint group), but the
	// producer PSC forwarding rule has multiple ports specified.
	//   "CLOUD_SQL_PSC_NEG_UNSUPPORTED" - The packet is sent to the Private
	// Service Connect backend (network endpoint group) targeting a Cloud SQL
	// service attachment, but this configuration is not supported.
	//   "NO_NAT_SUBNETS_FOR_PSC_SERVICE_ATTACHMENT" - No NAT subnets are defined
	// for the PSC service attachment.
	//   "PSC_TRANSITIVITY_NOT_PROPAGATED" - PSC endpoint is accessed via NCC, but
	// PSC transitivity configuration is not yet propagated.
	//   "HYBRID_NEG_NON_DYNAMIC_ROUTE_MATCHED" - The packet sent from the hybrid
	// NEG proxy matches a non-dynamic route, but such a configuration is not
	// supported.
	//   "HYBRID_NEG_NON_LOCAL_DYNAMIC_ROUTE_MATCHED" - The packet sent from the
	// hybrid NEG proxy matches a dynamic route with a next hop in a different
	// region, but such a configuration is not supported.
	//   "CLOUD_RUN_REVISION_NOT_READY" - Packet sent from a Cloud Run revision
	// that is not ready.
	//   "DROPPED_INSIDE_PSC_SERVICE_PRODUCER" - Packet was dropped inside Private
	// Service Connect service producer.
	//   "LOAD_BALANCER_HAS_NO_PROXY_SUBNET" - Packet sent to a load balancer,
	// which requires a proxy-only subnet and the subnet is not found.
	//   "CLOUD_NAT_NO_ADDRESSES" - Packet sent to Cloud Nat without active NAT
	// IPs.
	//   "ROUTING_LOOP" - Packet is stuck in a routing loop.
	//   "DROPPED_INSIDE_GOOGLE_MANAGED_SERVICE" - Packet is dropped inside a
	// Google-managed service due to being delivered in return trace to an endpoint
	// that doesn't match the endpoint the packet was sent from in forward trace.
	// Used only for return traces.
	//   "LOAD_BALANCER_BACKEND_INVALID_NETWORK" - Packet is dropped due to a load
	// balancer backend instance not having a network interface in the network
	// expected by the load balancer.
	//   "BACKEND_SERVICE_NAMED_PORT_NOT_DEFINED" - Packet is dropped due to a
	// backend service named port not being defined on the instance group level.
	//   "DESTINATION_IS_PRIVATE_NAT_IP_RANGE" - Packet is dropped due to a
	// destination IP range being part of a Private NAT IP range.
	//   "DROPPED_INSIDE_REDIS_INSTANCE_SERVICE" - Generic drop cause for a packet
	// being dropped inside a Redis Instance service project.
	//   "REDIS_INSTANCE_UNSUPPORTED_PORT" - Packet is dropped due to an
	// unsupported port being used to connect to a Redis Instance. Port 6379 should
	// be used to connect to a Redis Instance.
	//   "REDIS_INSTANCE_CONNECTING_FROM_PUPI_ADDRESS" - Packet is dropped due to
	// connecting from PUPI address to a PSA based Redis Instance.
	//   "REDIS_INSTANCE_NO_ROUTE_TO_DESTINATION_NETWORK" - Packet is dropped due
	// to no route to the destination network.
	//   "REDIS_INSTANCE_NO_EXTERNAL_IP" - Redis Instance does not have an external
	// IP address.
	//   "REDIS_INSTANCE_UNSUPPORTED_PROTOCOL" - Packet is dropped due to an
	// unsupported protocol being used to connect to a Redis Instance. Only TCP
	// connections are accepted by a Redis Instance.
	//   "DROPPED_INSIDE_REDIS_CLUSTER_SERVICE" - Generic drop cause for a packet
	// being dropped inside a Redis Cluster service project.
	//   "REDIS_CLUSTER_UNSUPPORTED_PORT" - Packet is dropped due to an unsupported
	// port being used to connect to a Redis Cluster. Ports 6379 and 11000 to 13047
	// should be used to connect to a Redis Cluster.
	//   "REDIS_CLUSTER_NO_EXTERNAL_IP" - Redis Cluster does not have an external
	// IP address.
	//   "REDIS_CLUSTER_UNSUPPORTED_PROTOCOL" - Packet is dropped due to an
	// unsupported protocol being used to connect to a Redis Cluster. Only TCP
	// connections are accepted by a Redis Cluster.
	//   "NO_ADVERTISED_ROUTE_TO_GCP_DESTINATION" - Packet from the non-GCP
	// (on-prem) or unknown GCP network is dropped due to the destination IP
	// address not belonging to any IP prefix advertised via BGP by the Cloud
	// Router.
	//   "NO_TRAFFIC_SELECTOR_TO_GCP_DESTINATION" - Packet from the non-GCP
	// (on-prem) or unknown GCP network is dropped due to the destination IP
	// address not belonging to any IP prefix included to the local traffic
	// selector of the VPN tunnel.
	//   "NO_KNOWN_ROUTE_FROM_PEERED_NETWORK_TO_DESTINATION" - Packet from the
	// unknown peered network is dropped due to no known route from the source
	// network to the destination IP address.
	//   "PRIVATE_NAT_TO_PSC_ENDPOINT_UNSUPPORTED" - Sending packets processed by
	// the Private NAT Gateways to the Private Service Connect endpoints is not
	// supported.
	//   "PSC_PORT_MAPPING_PORT_MISMATCH" - Packet is sent to the PSC port mapping
	// service, but its destination port does not match any port mapping rules.
	//   "PSC_PORT_MAPPING_WITHOUT_PSC_CONNECTION_UNSUPPORTED" - Sending packets
	// directly to the PSC port mapping service without going through the PSC
	// connection is not supported.
	//   "UNSUPPORTED_ROUTE_MATCHED_FOR_NAT64_DESTINATION" - Packet with
	// destination IP address within the reserved NAT64 range is dropped due to
	// matching a route of an unsupported type.
	//   "TRAFFIC_FROM_HYBRID_ENDPOINT_TO_INTERNET_DISALLOWED" - Packet could be
	// dropped because hybrid endpoint like a VPN gateway or Interconnect is not
	// allowed to send traffic to the Internet.
	Cause string `json:"cause,omitempty"`
	// DestinationIp: Destination IP address of the dropped packet (if relevant).
	DestinationIp string `json:"destinationIp,omitempty"`
	// Region: Region of the dropped packet (if relevant).
	Region string `json:"region,omitempty"`
	// ResourceUri: URI of the resource that caused the drop.
	ResourceUri string `json:"resourceUri,omitempty"`
	// SourceIp: Source IP address of the dropped packet (if relevant).
	SourceIp string `json:"sourceIp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cause") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cause") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DropInfo) MarshalJSON() ([]byte, error) {
	type NoMethod DropInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EdgeLocation: Representation of a network edge location as per
// https://cloud.google.com/vpc/docs/edge-locations.
type EdgeLocation struct {
	// MetropolitanArea: Name of the metropolitan area.
	MetropolitanArea string `json:"metropolitanArea,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetropolitanArea") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetropolitanArea") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EdgeLocation) MarshalJSON() ([]byte, error) {
	type NoMethod EdgeLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Endpoint: Source or destination of the Connectivity Test.
type Endpoint struct {
	// AppEngineVersion: An App Engine (https://cloud.google.com/appengine)
	// [service
	// version](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/
	// apps.services.versions). Applicable only to source endpoint.
	AppEngineVersion *AppEngineVersionEndpoint `json:"appEngineVersion,omitempty"`
	// CloudFunction: A Cloud Function (https://cloud.google.com/functions).
	// Applicable only to source endpoint.
	CloudFunction *CloudFunctionEndpoint `json:"cloudFunction,omitempty"`
	// CloudRunRevision: A Cloud Run (https://cloud.google.com/run)
	// [revision](https://cloud.google.com/run/docs/reference/rest/v1/namespaces.rev
	// isions/get) Applicable only to source endpoint.
	CloudRunRevision *CloudRunRevisionEndpoint `json:"cloudRunRevision,omitempty"`
	// CloudSqlInstance: A Cloud SQL (https://cloud.google.com/sql) instance URI.
	CloudSqlInstance string `json:"cloudSqlInstance,omitempty"`
	// ForwardingRule: A forwarding rule and its corresponding IP address represent
	// the frontend configuration of a Google Cloud load balancer. Forwarding rules
	// are also used for protocol forwarding, Private Service Connect and other
	// network services to provide forwarding information in the control plane.
	// Applicable only to destination endpoint. Format:
	// projects/{project}/global/forwardingRules/{id} or
	// projects/{project}/regions/{region}/forwardingRules/{id}
	ForwardingRule string `json:"forwardingRule,omitempty"`
	// ForwardingRuleTarget: Output only. Specifies the type of the target of the
	// forwarding rule.
	//
	// Possible values:
	//   "FORWARDING_RULE_TARGET_UNSPECIFIED" - Forwarding rule target is unknown.
	//   "INSTANCE" - Compute Engine instance for protocol forwarding.
	//   "LOAD_BALANCER" - Load Balancer. The specific type can be found from
	// load_balancer_type.
	//   "VPN_GATEWAY" - Classic Cloud VPN Gateway.
	//   "PSC" - Forwarding Rule is a Private Service Connect endpoint.
	ForwardingRuleTarget string `json:"forwardingRuleTarget,omitempty"`
	// Fqdn: DNS endpoint of Google Kubernetes Engine cluster control plane
	// (https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
	// Requires gke_master_cluster to be set, can't be used simultaneoulsly with
	// ip_address or network. Applicable only to destination endpoint.
	Fqdn string `json:"fqdn,omitempty"`
	// GkeMasterCluster: A cluster URI for Google Kubernetes Engine cluster control
	// plane
	// (https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
	GkeMasterCluster string `json:"gkeMasterCluster,omitempty"`
	// Instance: A Compute Engine instance URI.
	Instance string `json:"instance,omitempty"`
	// IpAddress: The IP address of the endpoint, which can be an external or
	// internal IP.
	IpAddress string `json:"ipAddress,omitempty"`
	// LoadBalancerId: Output only. ID of the load balancer the forwarding rule
	// points to. Empty for forwarding rules not related to load balancers.
	LoadBalancerId string `json:"loadBalancerId,omitempty"`
	// LoadBalancerType: Output only. Type of the load balancer the forwarding rule
	// points to.
	//
	// Possible values:
	//   "LOAD_BALANCER_TYPE_UNSPECIFIED" - Forwarding rule points to a different
	// target than a load balancer or a load balancer type is unknown.
	//   "HTTPS_ADVANCED_LOAD_BALANCER" - Global external HTTP(S) load balancer.
	//   "HTTPS_LOAD_BALANCER" - Global external HTTP(S) load balancer (classic)
	//   "REGIONAL_HTTPS_LOAD_BALANCER" - Regional external HTTP(S) load balancer.
	//   "INTERNAL_HTTPS_LOAD_BALANCER" - Internal HTTP(S) load balancer.
	//   "SSL_PROXY_LOAD_BALANCER" - External SSL proxy load balancer.
	//   "TCP_PROXY_LOAD_BALANCER" - External TCP proxy load balancer.
	//   "INTERNAL_TCP_PROXY_LOAD_BALANCER" - Internal regional TCP proxy load
	// balancer.
	//   "NETWORK_LOAD_BALANCER" - External TCP/UDP Network load balancer.
	//   "LEGACY_NETWORK_LOAD_BALANCER" - Target-pool based external TCP/UDP
	// Network load balancer.
	//   "TCP_UDP_INTERNAL_LOAD_BALANCER" - Internal TCP/UDP load balancer.
	LoadBalancerType string `json:"loadBalancerType,omitempty"`
	// Network: A VPC network URI.
	Network string `json:"network,omitempty"`
	// NetworkType: Type of the network where the endpoint is located. Applicable
	// only to source endpoint, as destination network type can be inferred from
	// the source.
	//
	// Possible values:
	//   "NETWORK_TYPE_UNSPECIFIED" - Default type if unspecified.
	//   "GCP_NETWORK" - A network hosted within Google Cloud. To receive more
	// detailed output, specify the URI for the source or destination network.
	//   "NON_GCP_NETWORK" - A network hosted outside of Google Cloud. This can be
	// an on-premises network, an internet resource or a network hosted by another
	// cloud provider.
	NetworkType string `json:"networkType,omitempty"`
	// Port: The IP protocol port of the endpoint. Only applicable when protocol is
	// TCP or UDP.
	Port int64 `json:"port,omitempty"`
	// ProjectId: Project ID where the endpoint is located. The project ID can be
	// derived from the URI if you provide a endpoint or network URI. The following
	// are two cases where you may need to provide the project ID: 1. Only the IP
	// address is specified, and the IP address is within a Google Cloud project.
	// 2. When you are using Shared VPC and the IP address that you provide is from
	// the service project. In this case, the network that the IP address resides
	// in is defined in the host project.
	ProjectId string `json:"projectId,omitempty"`
	// RedisCluster: A Redis Cluster
	// (https://cloud.google.com/memorystore/docs/cluster) URI. Applicable only to
	// destination endpoint.
	RedisCluster string `json:"redisCluster,omitempty"`
	// RedisInstance: A Redis Instance
	// (https://cloud.google.com/memorystore/docs/redis) URI. Applicable only to
	// destination endpoint.
	RedisInstance string `json:"redisInstance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppEngineVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppEngineVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Endpoint) MarshalJSON() ([]byte, error) {
	type NoMethod Endpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EndpointInfo: For display only. The specification of the endpoints for the
// test. EndpointInfo is derived from source and destination Endpoint and
// validated by the backend data plane model.
type EndpointInfo struct {
	// DestinationIp: Destination IP address.
	DestinationIp string `json:"destinationIp,omitempty"`
	// DestinationNetworkUri: URI of the network where this packet is sent to.
	DestinationNetworkUri string `json:"destinationNetworkUri,omitempty"`
	// DestinationPort: Destination port. Only valid when protocol is TCP or UDP.
	DestinationPort int64 `json:"destinationPort,omitempty"`
	// Protocol: IP protocol in string format, for example: "TCP", "UDP", "ICMP".
	Protocol string `json:"protocol,omitempty"`
	// SourceAgentUri: URI of the source telemetry agent this packet originates
	// from.
	SourceAgentUri string `json:"sourceAgentUri,omitempty"`
	// SourceIp: Source IP address.
	SourceIp string `json:"sourceIp,omitempty"`
	// SourceNetworkUri: URI of the network where this packet originates from.
	SourceNetworkUri string `json:"sourceNetworkUri,omitempty"`
	// SourcePort: Source port. Only valid when protocol is TCP or UDP.
	SourcePort int64 `json:"sourcePort,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationIp") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationIp") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EndpointInfo) MarshalJSON() ([]byte, error) {
	type NoMethod EndpointInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FirewallInfo: For display only. Metadata associated with a VPC firewall
// rule, an implied VPC firewall rule, or a firewall policy rule.
type FirewallInfo struct {
	// Action: Possible values: ALLOW, DENY, APPLY_SECURITY_PROFILE_GROUP
	Action string `json:"action,omitempty"`
	// Direction: Possible values: INGRESS, EGRESS
	Direction string `json:"direction,omitempty"`
	// DisplayName: The display name of the firewall rule. This field might be
	// empty for firewall policy rules.
	DisplayName string `json:"displayName,omitempty"`
	// FirewallRuleType: The firewall rule's type.
	//
	// Possible values:
	//   "FIREWALL_RULE_TYPE_UNSPECIFIED" - Unspecified type.
	//   "HIERARCHICAL_FIREWALL_POLICY_RULE" - Hierarchical firewall policy rule.
	// For details, see [Hierarchical firewall policies
	// overview](https://cloud.google.com/vpc/docs/firewall-policies).
	//   "VPC_FIREWALL_RULE" - VPC firewall rule. For details, see [VPC firewall
	// rules overview](https://cloud.google.com/vpc/docs/firewalls).
	//   "IMPLIED_VPC_FIREWALL_RULE" - Implied VPC firewall rule. For details, see
	// [Implied
	// rules](https://cloud.google.com/vpc/docs/firewalls#default_firewall_rules).
	//   "SERVERLESS_VPC_ACCESS_MANAGED_FIREWALL_RULE" - Implicit firewall rules
	// that are managed by serverless VPC access to allow ingress access. They are
	// not visible in the Google Cloud console. For details, see [VPC connector's
	// implicit
	// rules](https://cloud.google.com/functions/docs/networking/connecting-vpc#rest
	// rict-access).
	//   "NETWORK_FIREWALL_POLICY_RULE" - Global network firewall policy rule. For
	// details, see [Network firewall
	// policies](https://cloud.google.com/vpc/docs/network-firewall-policies).
	//   "NETWORK_REGIONAL_FIREWALL_POLICY_RULE" - Regional network firewall policy
	// rule. For details, see [Regional network firewall
	// policies](https://cloud.google.com/firewall/docs/regional-firewall-policies).
	//   "UNSUPPORTED_FIREWALL_POLICY_RULE" - Firewall policy rule containing
	// attributes not yet supported in Connectivity tests. Firewall analysis is
	// skipped if such a rule can potentially be matched. Please see the [list of
	// unsupported
	// configurations](https://cloud.google.com/network-intelligence-center/docs/con
	// nectivity-tests/concepts/overview#unsupported-configs).
	//   "TRACKING_STATE" - Tracking state for response traffic created when
	// request traffic goes through allow firewall rule. For details, see [firewall
	// rules
	// specifications](https://cloud.google.com/firewall/docs/firewalls#specificatio
	// ns)
	//   "ANALYSIS_SKIPPED" - Firewall analysis was skipped due to executing
	// Connectivity Test in the BypassFirewallChecks mode
	FirewallRuleType string `json:"firewallRuleType,omitempty"`
	// NetworkUri: The URI of the VPC network that the firewall rule is associated
	// with. This field is not applicable to hierarchical firewall policy rules.
	NetworkUri string `json:"networkUri,omitempty"`
	// Policy: The name of the firewall policy that this rule is associated with.
	// This field is not applicable to VPC firewall rules and implied VPC firewall
	// rules.
	Policy string `json:"policy,omitempty"`
	// PolicyUri: The URI of the firewall policy that this rule is associated with.
	// This field is not applicable to VPC firewall rules and implied VPC firewall
	// rules.
	PolicyUri string `json:"policyUri,omitempty"`
	// Priority: The priority of the firewall rule.
	Priority int64 `json:"priority,omitempty"`
	// TargetServiceAccounts: The target service accounts specified by the firewall
	// rule.
	TargetServiceAccounts []string `json:"targetServiceAccounts,omitempty"`
	// TargetTags: The target tags defined by the VPC firewall rule. This field is
	// not applicable to firewall policy rules.
	TargetTags []string `json:"targetTags,omitempty"`
	// Uri: The URI of the firewall rule. This field is not applicable to implied
	// VPC firewall rules.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FirewallInfo) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ForwardInfo: Details of the final state "forward" and associated resource.
type ForwardInfo struct {
	// IpAddress: IP address of the target (if applicable).
	IpAddress string `json:"ipAddress,omitempty"`
	// ResourceUri: URI of the resource that the packet is forwarded to.
	ResourceUri string `json:"resourceUri,omitempty"`
	// Target: Target type where this packet is forwarded to.
	//
	// Possible values:
	//   "TARGET_UNSPECIFIED" - Target not specified.
	//   "PEERING_VPC" - Forwarded to a VPC peering network.
	//   "VPN_GATEWAY" - Forwarded to a Cloud VPN gateway.
	//   "INTERCONNECT" - Forwarded to a Cloud Interconnect connection.
	//   "GKE_MASTER" - Forwarded to a Google Kubernetes Engine Container cluster
	// master.
	//   "IMPORTED_CUSTOM_ROUTE_NEXT_HOP" - Forwarded to the next hop of a custom
	// route imported from a peering VPC.
	//   "CLOUD_SQL_INSTANCE" - Forwarded to a Cloud SQL instance.
	//   "ANOTHER_PROJECT" - Forwarded to a VPC network in another project.
	//   "NCC_HUB" - Forwarded to an NCC Hub.
	//   "ROUTER_APPLIANCE" - Forwarded to a router appliance.
	Target string `json:"target,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IpAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IpAddress") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ForwardInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ForwardingRuleInfo: For display only. Metadata associated with a Compute
// Engine forwarding rule.
type ForwardingRuleInfo struct {
	// DisplayName: Name of the forwarding rule.
	DisplayName string `json:"displayName,omitempty"`
	// LoadBalancerName: Name of the load balancer the forwarding rule belongs to.
	// Empty for forwarding rules not related to load balancers (like PSC
	// forwarding rules).
	LoadBalancerName string `json:"loadBalancerName,omitempty"`
	// MatchedPortRange: Port range defined in the forwarding rule that matches the
	// packet.
	MatchedPortRange string `json:"matchedPortRange,omitempty"`
	// MatchedProtocol: Protocol defined in the forwarding rule that matches the
	// packet.
	MatchedProtocol string `json:"matchedProtocol,omitempty"`
	// NetworkUri: Network URI.
	NetworkUri string `json:"networkUri,omitempty"`
	// PscGoogleApiTarget: PSC Google API target this forwarding rule targets (if
	// applicable).
	PscGoogleApiTarget string `json:"pscGoogleApiTarget,omitempty"`
	// PscServiceAttachmentUri: URI of the PSC service attachment this forwarding
	// rule targets (if applicable).
	PscServiceAttachmentUri string `json:"pscServiceAttachmentUri,omitempty"`
	// Region: Region of the forwarding rule. Set only for regional forwarding
	// rules.
	Region string `json:"region,omitempty"`
	// Target: Target type of the forwarding rule.
	Target string `json:"target,omitempty"`
	// Uri: URI of the forwarding rule.
	Uri string `json:"uri,omitempty"`
	// Vip: VIP of the forwarding rule.
	Vip string `json:"vip,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ForwardingRuleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GKEMasterInfo: For display only. Metadata associated with a Google
// Kubernetes Engine (GKE) cluster master.
type GKEMasterInfo struct {
	// ClusterNetworkUri: URI of a GKE cluster network.
	ClusterNetworkUri string `json:"clusterNetworkUri,omitempty"`
	// ClusterUri: URI of a GKE cluster.
	ClusterUri string `json:"clusterUri,omitempty"`
	// DnsEndpoint: DNS endpoint of a GKE cluster control plane.
	DnsEndpoint string `json:"dnsEndpoint,omitempty"`
	// ExternalIp: External IP address of a GKE cluster control plane.
	ExternalIp string `json:"externalIp,omitempty"`
	// InternalIp: Internal IP address of a GKE cluster control plane.
	InternalIp string `json:"internalIp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterNetworkUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterNetworkUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GKEMasterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GKEMasterInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleServiceInfo: For display only. Details of a Google Service sending
// packets to a VPC network. Although the source IP might be a publicly
// routable address, some Google Services use special routes within Google
// production infrastructure to reach Compute Engine Instances.
// https://cloud.google.com/vpc/docs/routes#special_return_paths
type GoogleServiceInfo struct {
	// GoogleServiceType: Recognized type of a Google Service.
	//
	// Possible values:
	//   "GOOGLE_SERVICE_TYPE_UNSPECIFIED" - Unspecified Google Service.
	//   "IAP" - Identity aware proxy.
	// https://cloud.google.com/iap/docs/using-tcp-forwarding
	//   "GFE_PROXY_OR_HEALTH_CHECK_PROBER" - One of two services sharing IP
	// ranges: * Load Balancer proxy * Centralized Health Check prober
	// https://cloud.google.com/load-balancing/docs/firewall-rules
	//   "CLOUD_DNS" - Connectivity from Cloud DNS to forwarding targets or
	// alternate name servers that use private routing.
	// https://cloud.google.com/dns/docs/zones/forwarding-zones#firewall-rules
	// https://cloud.google.com/dns/docs/policies#firewall-rules
	//   "GOOGLE_API" - private.googleapis.com and restricted.googleapis.com
	//   "GOOGLE_API_PSC" - Google API via Private Service Connect.
	// https://cloud.google.com/vpc/docs/configure-private-service-connect-apis
	//   "GOOGLE_API_VPC_SC" - Google API via VPC Service Controls.
	// https://cloud.google.com/vpc/docs/configure-private-service-connect-apis
	//   "SERVERLESS_VPC_ACCESS" - Google API via Serverless VPC Access.
	// https://cloud.google.com/vpc/docs/serverless-vpc-access
	GoogleServiceType string `json:"googleServiceType,omitempty"`
	// SourceIp: Source IP address.
	SourceIp string `json:"sourceIp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GoogleServiceType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GoogleServiceType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleServiceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleServiceInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstanceInfo: For display only. Metadata associated with a Compute Engine
// instance.
type InstanceInfo struct {
	// DisplayName: Name of a Compute Engine instance.
	DisplayName string `json:"displayName,omitempty"`
	// ExternalIp: External IP address of the network interface.
	ExternalIp string `json:"externalIp,omitempty"`
	// Interface: Name of the network interface of a Compute Engine instance.
	Interface string `json:"interface,omitempty"`
	// InternalIp: Internal IP address of the network interface.
	InternalIp string `json:"internalIp,omitempty"`
	// NetworkTags: Network tags configured on the instance.
	NetworkTags []string `json:"networkTags,omitempty"`
	// NetworkUri: URI of a Compute Engine network.
	NetworkUri string `json:"networkUri,omitempty"`
	// PscNetworkAttachmentUri: URI of the PSC network attachment the NIC is
	// attached to (if relevant).
	PscNetworkAttachmentUri string `json:"pscNetworkAttachmentUri,omitempty"`
	// ServiceAccount: Service account authorized for the instance.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// Uri: URI of a Compute Engine instance.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstanceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LatencyDistribution: Describes measured latency distribution.
type LatencyDistribution struct {
	// LatencyPercentiles: Representative latency percentiles.
	LatencyPercentiles []*LatencyPercentile `json:"latencyPercentiles,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LatencyPercentiles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LatencyPercentiles") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LatencyDistribution) MarshalJSON() ([]byte, error) {
	type NoMethod LatencyDistribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LatencyPercentile: Latency percentile rank and value.
type LatencyPercentile struct {
	// LatencyMicros: percent-th percentile of latency observed, in microseconds.
	// Fraction of percent/100 of samples have latency lower or equal to the value
	// of this field.
	LatencyMicros int64 `json:"latencyMicros,omitempty,string"`
	// Percent: Percentage of samples this data point applies to.
	Percent int64 `json:"percent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LatencyMicros") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LatencyMicros") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LatencyPercentile) MarshalJSON() ([]byte, error) {
	type NoMethod LatencyPercentile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListConnectivityTestsResponse: Response for the `ListConnectivityTests`
// method.
type ListConnectivityTestsResponse struct {
	// NextPageToken: Page token to fetch the next set of Connectivity Tests.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Resources: List of Connectivity Tests.
	Resources []*ConnectivityTest `json:"resources,omitempty"`
	// Unreachable: Locations that could not be reached (when querying all
	// locations with `-`).
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConnectivityTestsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConnectivityTestsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListVpcFlowLogsConfigsResponse: Response for the `ListVpcFlowLogsConfigs`
// method.
type ListVpcFlowLogsConfigsResponse struct {
	// NextPageToken: Page token to fetch the next set of configurations.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached (when querying all
	// locations with `-`).
	Unreachable []string `json:"unreachable,omitempty"`
	// VpcFlowLogsConfigs: List of VPC Flow Log configurations.
	VpcFlowLogsConfigs []*VpcFlowLogsConfig `json:"vpcFlowLogsConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListVpcFlowLogsConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListVpcFlowLogsConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LoadBalancerBackend: For display only. Metadata associated with a specific
// load balancer backend.
type LoadBalancerBackend struct {
	// DisplayName: Name of a Compute Engine instance or network endpoint.
	DisplayName string `json:"displayName,omitempty"`
	// HealthCheckAllowingFirewallRules: A list of firewall rule URIs allowing
	// probes from health check IP ranges.
	HealthCheckAllowingFirewallRules []string `json:"healthCheckAllowingFirewallRules,omitempty"`
	// HealthCheckBlockingFirewallRules: A list of firewall rule URIs blocking
	// probes from health check IP ranges.
	HealthCheckBlockingFirewallRules []string `json:"healthCheckBlockingFirewallRules,omitempty"`
	// HealthCheckFirewallState: State of the health check firewall configuration.
	//
	// Possible values:
	//   "HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED" - State is unspecified. Default
	// state if not populated.
	//   "CONFIGURED" - There are configured firewall rules to allow health check
	// probes to the backend.
	//   "MISCONFIGURED" - There are firewall rules configured to allow partial
	// health check ranges or block all health check ranges. If a health check
	// probe is sent from denied IP ranges, the health check to the backend will
	// fail. Then, the backend will be marked unhealthy and will not receive
	// traffic sent to the load balancer.
	HealthCheckFirewallState string `json:"healthCheckFirewallState,omitempty"`
	// Uri: URI of a Compute Engine instance or network endpoint.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoadBalancerBackend) MarshalJSON() ([]byte, error) {
	type NoMethod LoadBalancerBackend
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LoadBalancerBackendInfo: For display only. Metadata associated with the load
// balancer backend.
type LoadBalancerBackendInfo struct {
	// BackendBucketUri: URI of the backend bucket this backend targets (if
	// applicable).
	BackendBucketUri string `json:"backendBucketUri,omitempty"`
	// BackendServiceUri: URI of the backend service this backend belongs to (if
	// applicable).
	BackendServiceUri string `json:"backendServiceUri,omitempty"`
	// HealthCheckFirewallsConfigState: Output only. Health check firewalls
	// configuration state for the backend. This is a result of the static firewall
	// analysis (verifying that health check traffic from required IP ranges to the
	// backend is allowed or not). The backend might still be unhealthy even if
	// these firewalls are configured. Please refer to the documentation for more
	// information: https://cloud.google.com/load-balancing/docs/firewall-rules
	//
	// Possible values:
	//   "HEALTH_CHECK_FIREWALLS_CONFIG_STATE_UNSPECIFIED" - Configuration state
	// unspecified. It usually means that the backend has no health check attached,
	// or there was an unexpected configuration error preventing Connectivity tests
	// from verifying health check configuration.
	//   "FIREWALLS_CONFIGURED" - Firewall rules (policies) allowing health check
	// traffic from all required IP ranges to the backend are configured.
	//   "FIREWALLS_PARTIALLY_CONFIGURED" - Firewall rules (policies) allow health
	// check traffic only from a part of required IP ranges.
	//   "FIREWALLS_NOT_CONFIGURED" - Firewall rules (policies) deny health check
	// traffic from all required IP ranges to the backend.
	//   "FIREWALLS_UNSUPPORTED" - The network contains firewall rules of
	// unsupported types, so Connectivity tests were not able to verify health
	// check configuration status. Please refer to the documentation for the list
	// of unsupported configurations:
	// https://cloud.google.com/network-intelligence-center/docs/connectivity-tests/concepts/overview#unsupported-configs
	HealthCheckFirewallsConfigState string `json:"healthCheckFirewallsConfigState,omitempty"`
	// HealthCheckUri: URI of the health check attached to this backend (if
	// applicable).
	HealthCheckUri string `json:"healthCheckUri,omitempty"`
	// InstanceGroupUri: URI of the instance group this backend belongs to (if
	// applicable).
	InstanceGroupUri string `json:"instanceGroupUri,omitempty"`
	// InstanceUri: URI of the backend instance (if applicable). Populated for
	// instance group backends, and zonal NEG backends.
	InstanceUri string `json:"instanceUri,omitempty"`
	// Name: Display name of the backend. For example, it might be an instance name
	// for the instance group backends, or an IP address and port for zonal network
	// endpoint group backends.
	Name string `json:"name,omitempty"`
	// NetworkEndpointGroupUri: URI of the network endpoint group this backend
	// belongs to (if applicable).
	NetworkEndpointGroupUri string `json:"networkEndpointGroupUri,omitempty"`
	// PscGoogleApiTarget: PSC Google API target this PSC NEG backend targets (if
	// applicable).
	PscGoogleApiTarget string `json:"pscGoogleApiTarget,omitempty"`
	// PscServiceAttachmentUri: URI of the PSC service attachment this PSC NEG
	// backend targets (if applicable).
	PscServiceAttachmentUri string `json:"pscServiceAttachmentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackendBucketUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackendBucketUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoadBalancerBackendInfo) MarshalJSON() ([]byte, error) {
	type NoMethod LoadBalancerBackendInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LoadBalancerInfo: For display only. Metadata associated with a load
// balancer.
type LoadBalancerInfo struct {
	// BackendType: Type of load balancer's backend configuration.
	//
	// Possible values:
	//   "BACKEND_TYPE_UNSPECIFIED" - Type is unspecified.
	//   "BACKEND_SERVICE" - Backend Service as the load balancer's backend.
	//   "TARGET_POOL" - Target Pool as the load balancer's backend.
	//   "TARGET_INSTANCE" - Target Instance as the load balancer's backend.
	BackendType string `json:"backendType,omitempty"`
	// BackendUri: Backend configuration URI.
	BackendUri string `json:"backendUri,omitempty"`
	// Backends: Information for the loadbalancer backends.
	Backends []*LoadBalancerBackend `json:"backends,omitempty"`
	// HealthCheckUri: URI of the health check for the load balancer. Deprecated
	// and no longer populated as different load balancer backends might have
	// different health checks.
	HealthCheckUri string `json:"healthCheckUri,omitempty"`
	// LoadBalancerType: Type of the load balancer.
	//
	// Possible values:
	//   "LOAD_BALANCER_TYPE_UNSPECIFIED" - Type is unspecified.
	//   "INTERNAL_TCP_UDP" - Internal TCP/UDP load balancer.
	//   "NETWORK_TCP_UDP" - Network TCP/UDP load balancer.
	//   "HTTP_PROXY" - HTTP(S) proxy load balancer.
	//   "TCP_PROXY" - TCP proxy load balancer.
	//   "SSL_PROXY" - SSL proxy load balancer.
	LoadBalancerType string `json:"loadBalancerType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackendType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackendType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoadBalancerInfo) MarshalJSON() ([]byte, error) {
	type NoMethod LoadBalancerInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NatInfo: For display only. Metadata associated with NAT.
type NatInfo struct {
	// NatGatewayName: The name of Cloud NAT Gateway. Only valid when type is
	// CLOUD_NAT.
	NatGatewayName string `json:"natGatewayName,omitempty"`
	// NetworkUri: URI of the network where NAT translation takes place.
	NetworkUri string `json:"networkUri,omitempty"`
	// NewDestinationIp: Destination IP address after NAT translation.
	NewDestinationIp string `json:"newDestinationIp,omitempty"`
	// NewDestinationPort: Destination port after NAT translation. Only valid when
	// protocol is TCP or UDP.
	NewDestinationPort int64 `json:"newDestinationPort,omitempty"`
	// NewSourceIp: Source IP address after NAT translation.
	NewSourceIp string `json:"newSourceIp,omitempty"`
	// NewSourcePort: Source port after NAT translation. Only valid when protocol
	// is TCP or UDP.
	NewSourcePort int64 `json:"newSourcePort,omitempty"`
	// OldDestinationIp: Destination IP address before NAT translation.
	OldDestinationIp string `json:"oldDestinationIp,omitempty"`
	// OldDestinationPort: Destination port before NAT translation. Only valid when
	// protocol is TCP or UDP.
	OldDestinationPort int64 `json:"oldDestinationPort,omitempty"`
	// OldSourceIp: Source IP address before NAT translation.
	OldSourceIp string `json:"oldSourceIp,omitempty"`
	// OldSourcePort: Source port before NAT translation. Only valid when protocol
	// is TCP or UDP.
	OldSourcePort int64 `json:"oldSourcePort,omitempty"`
	// Protocol: IP protocol in string format, for example: "TCP", "UDP", "ICMP".
	Protocol string `json:"protocol,omitempty"`
	// RouterUri: Uri of the Cloud Router. Only valid when type is CLOUD_NAT.
	RouterUri string `json:"routerUri,omitempty"`
	// Type: Type of NAT.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Type is unspecified.
	//   "INTERNAL_TO_EXTERNAL" - From Compute Engine instance's internal address
	// to external address.
	//   "EXTERNAL_TO_INTERNAL" - From Compute Engine instance's external address
	// to internal address.
	//   "CLOUD_NAT" - Cloud NAT Gateway.
	//   "PRIVATE_SERVICE_CONNECT" - Private service connect NAT.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NatGatewayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NatGatewayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NatInfo) MarshalJSON() ([]byte, error) {
	type NoMethod NatInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NetworkInfo: For display only. Metadata associated with a Compute Engine
// network. Next ID: 7
type NetworkInfo struct {
	// DisplayName: Name of a Compute Engine network.
	DisplayName string `json:"displayName,omitempty"`
	// MatchedIpRange: The IP range of the subnet matching the source IP address of
	// the test.
	MatchedIpRange string `json:"matchedIpRange,omitempty"`
	// MatchedSubnetUri: URI of the subnet matching the source IP address of the
	// test.
	MatchedSubnetUri string `json:"matchedSubnetUri,omitempty"`
	// Region: The region of the subnet matching the source IP address of the test.
	Region string `json:"region,omitempty"`
	// Uri: URI of a Compute Engine network.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NetworkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod NetworkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Metadata describing an Operation
type OperationMetadata struct {
	// ApiVersion: API version.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CancelRequested: Specifies if cancellation was requested for the operation.
	CancelRequested bool `json:"cancelRequested,omitempty"`
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// StatusDetail: Human-readable status of the operation, if any.
	StatusDetail string `json:"statusDetail,omitempty"`
	// Target: Target of the operation - for example
	// projects/project-1/locations/global/connectivityTests/test-1
	Target string `json:"target,omitempty"`
	// Verb: Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources. A `Policy` is a collection of
// `bindings`. A `binding` binds one or more `members`, or principals, to a
// single `role`. Principals can be user accounts, service accounts, Google
// groups, and domains (such as G Suite). A `role` is a named list of
// permissions; each `role` can be an IAM predefined role or a user-created
// custom role. For some types of Google Cloud resources, a `binding` can also
// specify a `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or both. To
// learn which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProbingDetails: Results of active probing from the last run of the test.
type ProbingDetails struct {
	// AbortCause: The reason probing was aborted.
	//
	// Possible values:
	//   "PROBING_ABORT_CAUSE_UNSPECIFIED" - No reason was specified.
	//   "PERMISSION_DENIED" - The user lacks permission to access some of the
	// network resources required to run the test.
	//   "NO_SOURCE_LOCATION" - No valid source endpoint could be derived from the
	// request.
	AbortCause string `json:"abortCause,omitempty"`
	// DestinationEgressLocation: The EdgeLocation from which a packet, destined to
	// the internet, will egress the Google network. This will only be populated
	// for a connectivity test which has an internet destination address. The
	// absence of this field *must not* be used as an indication that the
	// destination is part of the Google network.
	DestinationEgressLocation *EdgeLocation `json:"destinationEgressLocation,omitempty"`
	// EdgeResponses: Probing results for all edge devices.
	EdgeResponses []*SingleEdgeResponse `json:"edgeResponses,omitempty"`
	// EndpointInfo: The source and destination endpoints derived from the test
	// input and used for active probing.
	EndpointInfo *EndpointInfo `json:"endpointInfo,omitempty"`
	// Error: Details about an internal failure or the cancellation of active
	// probing.
	Error *Status `json:"error,omitempty"`
	// ProbedAllDevices: Whether all relevant edge devices were probed.
	ProbedAllDevices bool `json:"probedAllDevices,omitempty"`
	// ProbingLatency: Latency as measured by active probing in one direction: from
	// the source to the destination endpoint.
	ProbingLatency *LatencyDistribution `json:"probingLatency,omitempty"`
	// Result: The overall result of active probing.
	//
	// Possible values:
	//   "PROBING_RESULT_UNSPECIFIED" - No result was specified.
	//   "REACHABLE" - At least 95% of packets reached the destination.
	//   "UNREACHABLE" - No packets reached the destination.
	//   "REACHABILITY_INCONSISTENT" - Less than 95% of packets reached the
	// destination.
	//   "UNDETERMINED" - Reachability could not be determined. Possible reasons
	// are: * The user lacks permission to access some of the network resources
	// required to run the test. * No valid source endpoint could be derived from
	// the request. * An internal error occurred.
	Result string `json:"result,omitempty"`
	// SentProbeCount: Number of probes sent.
	SentProbeCount int64 `json:"sentProbeCount,omitempty"`
	// SuccessfulProbeCount: Number of probes that reached the destination.
	SuccessfulProbeCount int64 `json:"successfulProbeCount,omitempty"`
	// VerifyTime: The time that reachability was assessed through active probing.
	VerifyTime string `json:"verifyTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AbortCause") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AbortCause") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProbingDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ProbingDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProxyConnectionInfo: For display only. Metadata associated with
// ProxyConnection.
type ProxyConnectionInfo struct {
	// NetworkUri: URI of the network where connection is proxied.
	NetworkUri string `json:"networkUri,omitempty"`
	// NewDestinationIp: Destination IP address of a new connection.
	NewDestinationIp string `json:"newDestinationIp,omitempty"`
	// NewDestinationPort: Destination port of a new connection. Only valid when
	// protocol is TCP or UDP.
	NewDestinationPort int64 `json:"newDestinationPort,omitempty"`
	// NewSourceIp: Source IP address of a new connection.
	NewSourceIp string `json:"newSourceIp,omitempty"`
	// NewSourcePort: Source port of a new connection. Only valid when protocol is
	// TCP or UDP.
	NewSourcePort int64 `json:"newSourcePort,omitempty"`
	// OldDestinationIp: Destination IP address of an original connection
	OldDestinationIp string `json:"oldDestinationIp,omitempty"`
	// OldDestinationPort: Destination port of an original connection. Only valid
	// when protocol is TCP or UDP.
	OldDestinationPort int64 `json:"oldDestinationPort,omitempty"`
	// OldSourceIp: Source IP address of an original connection.
	OldSourceIp string `json:"oldSourceIp,omitempty"`
	// OldSourcePort: Source port of an original connection. Only valid when
	// protocol is TCP or UDP.
	OldSourcePort int64 `json:"oldSourcePort,omitempty"`
	// Protocol: IP protocol in string format, for example: "TCP", "UDP", "ICMP".
	Protocol string `json:"protocol,omitempty"`
	// SubnetUri: Uri of proxy subnet.
	SubnetUri string `json:"subnetUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NetworkUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NetworkUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProxyConnectionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ProxyConnectionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReachabilityDetails: Results of the configuration analysis from the last run
// of the test.
type ReachabilityDetails struct {
	// Error: The details of a failure or a cancellation of reachability analysis.
	Error *Status `json:"error,omitempty"`
	// Result: The overall result of the test's configuration analysis.
	//
	// Possible values:
	//   "RESULT_UNSPECIFIED" - No result was specified.
	//   "REACHABLE" - Possible scenarios are: * The configuration analysis
	// determined that a packet originating from the source is expected to reach
	// the destination. * The analysis didn't complete because the user lacks
	// permission for some of the resources in the trace. However, at the time the
	// user's permission became insufficient, the trace had been successful so far.
	//   "UNREACHABLE" - A packet originating from the source is expected to be
	// dropped before reaching the destination.
	//   "AMBIGUOUS" - The source and destination endpoints do not uniquely
	// identify the test location in the network, and the reachability result
	// contains multiple traces. For some traces, a packet could be delivered, and
	// for others, it would not be. This result is also assigned to configuration
	// analysis of return path if on its own it should be REACHABLE, but
	// configuration analysis of forward path is AMBIGUOUS.
	//   "UNDETERMINED" - The configuration analysis did not complete. Possible
	// reasons are: * A permissions error occurred--for example, the user might not
	// have read permission for all of the resources named in the test. * An
	// internal error occurred. * The analyzer received an invalid or unsupported
	// argument or was unable to identify a known endpoint.
	Result string `json:"result,omitempty"`
	// Traces: Result may contain a list of traces if a test has multiple possible
	// paths in the network, such as when destination endpoint is a load balancer
	// with multiple backends.
	Traces []*Trace `json:"traces,omitempty"`
	// VerifyTime: The time of the configuration analysis.
	VerifyTime string `json:"verifyTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReachabilityDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ReachabilityDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RedisClusterInfo: For display only. Metadata associated with a Redis
// Cluster.
type RedisClusterInfo struct {
	// DiscoveryEndpointIpAddress: Discovery endpoint IP address of a Redis
	// Cluster.
	DiscoveryEndpointIpAddress string `json:"discoveryEndpointIpAddress,omitempty"`
	// DisplayName: Name of a Redis Cluster.
	DisplayName string `json:"displayName,omitempty"`
	// Location: Name of the region in which the Redis Cluster is defined. For
	// example, "us-central1".
	Location string `json:"location,omitempty"`
	// NetworkUri: URI of the network containing the Redis Cluster endpoints in
	// format "projects/{project_id}/global/networks/{network_id}".
	NetworkUri string `json:"networkUri,omitempty"`
	// SecondaryEndpointIpAddress: Secondary endpoint IP address of a Redis
	// Cluster.
	SecondaryEndpointIpAddress string `json:"secondaryEndpointIpAddress,omitempty"`
	// Uri: URI of a Redis Cluster in format
	// "projects/{project_id}/locations/{location}/clusters/{cluster_id}"
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiscoveryEndpointIpAddress")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiscoveryEndpointIpAddress") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RedisClusterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RedisClusterInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RedisInstanceInfo: For display only. Metadata associated with a Cloud Redis
// Instance.
type RedisInstanceInfo struct {
	// DisplayName: Name of a Cloud Redis Instance.
	DisplayName string `json:"displayName,omitempty"`
	// NetworkUri: URI of a Cloud Redis Instance network.
	NetworkUri string `json:"networkUri,omitempty"`
	// PrimaryEndpointIp: Primary endpoint IP address of a Cloud Redis Instance.
	PrimaryEndpointIp string `json:"primaryEndpointIp,omitempty"`
	// ReadEndpointIp: Read endpoint IP address of a Cloud Redis Instance (if
	// applicable).
	ReadEndpointIp string `json:"readEndpointIp,omitempty"`
	// Region: Region in which the Cloud Redis Instance is defined.
	Region string `json:"region,omitempty"`
	// Uri: URI of a Cloud Redis Instance.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RedisInstanceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RedisInstanceInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RerunConnectivityTestRequest: Request for the `RerunConnectivityTest`
// method.
type RerunConnectivityTestRequest struct {
}

// RouteInfo: For display only. Metadata associated with a Compute Engine
// route.
type RouteInfo struct {
	// AdvertisedRouteNextHopUri: For ADVERTISED routes, the URI of their next hop,
	// i.e. the URI of the hybrid endpoint (VPN tunnel, Interconnect attachment,
	// NCC router appliance) the advertised prefix is advertised through, or URI of
	// the source peered network. Deprecated in favor of the next_hop_uri field,
	// not used in new tests.
	AdvertisedRouteNextHopUri string `json:"advertisedRouteNextHopUri,omitempty"`
	// AdvertisedRouteSourceRouterUri: For ADVERTISED dynamic routes, the URI of
	// the Cloud Router that advertised the corresponding IP prefix.
	AdvertisedRouteSourceRouterUri string `json:"advertisedRouteSourceRouterUri,omitempty"`
	// DestIpRange: Destination IP range of the route.
	DestIpRange string `json:"destIpRange,omitempty"`
	// DestPortRanges: Destination port ranges of the route. POLICY_BASED routes
	// only.
	DestPortRanges []string `json:"destPortRanges,omitempty"`
	// DisplayName: Name of a route.
	DisplayName string `json:"displayName,omitempty"`
	// InstanceTags: Instance tags of the route.
	InstanceTags []string `json:"instanceTags,omitempty"`
	// NccHubRouteUri: For PEERING_SUBNET and PEERING_DYNAMIC routes that are
	// advertised by NCC Hub, the URI of the corresponding route in NCC Hub's
	// routing table.
	NccHubRouteUri string `json:"nccHubRouteUri,omitempty"`
	// NccHubUri: URI of the NCC Hub the route is advertised by. PEERING_SUBNET and
	// PEERING_DYNAMIC routes that are advertised by NCC Hub only.
	NccHubUri string `json:"nccHubUri,omitempty"`
	// NccSpokeUri: URI of the destination NCC Spoke. PEERING_SUBNET and
	// PEERING_DYNAMIC routes that are advertised by NCC Hub only.
	NccSpokeUri string `json:"nccSpokeUri,omitempty"`
	// NetworkUri: URI of a VPC network where route is located.
	NetworkUri string `json:"networkUri,omitempty"`
	// NextHop: String type of the next hop of the route (for example, "VPN
	// tunnel"). Deprecated in favor of the next_hop_type and next_hop_uri fields,
	// not used in new tests.
	NextHop string `json:"nextHop,omitempty"`
	// NextHopNetworkUri: URI of a VPC network where the next hop resource is
	// located.
	NextHopNetworkUri string `json:"nextHopNetworkUri,omitempty"`
	// NextHopType: Type of next hop.
	//
	// Possible values:
	//   "NEXT_HOP_TYPE_UNSPECIFIED" - Unspecified type. Default value.
	//   "NEXT_HOP_IP" - Next hop is an IP address.
	//   "NEXT_HOP_INSTANCE" - Next hop is a Compute Engine instance.
	//   "NEXT_HOP_NETWORK" - Next hop is a VPC network gateway.
	//   "NEXT_HOP_PEERING" - Next hop is a peering VPC. This scenario only happens
	// when the user doesn't have permissions to the project where the next hop
	// resource is located.
	//   "NEXT_HOP_INTERCONNECT" - Next hop is an interconnect.
	//   "NEXT_HOP_VPN_TUNNEL" - Next hop is a VPN tunnel.
	//   "NEXT_HOP_VPN_GATEWAY" - Next hop is a VPN gateway. This scenario only
	// happens when tracing connectivity from an on-premises network to Google
	// Cloud through a VPN. The analysis simulates a packet departing from the
	// on-premises network through a VPN tunnel and arriving at a Cloud VPN
	// gateway.
	//   "NEXT_HOP_INTERNET_GATEWAY" - Next hop is an internet gateway.
	//   "NEXT_HOP_BLACKHOLE" - Next hop is blackhole; that is, the next hop either
	// does not exist or is unusable.
	//   "NEXT_HOP_ILB" - Next hop is the forwarding rule of an Internal Load
	// Balancer.
	//   "NEXT_HOP_ROUTER_APPLIANCE" - Next hop is a [router appliance
	// instance](https://cloud.google.com/network-connectivity/docs/network-connecti
	// vity-center/concepts/ra-overview).
	//   "NEXT_HOP_NCC_HUB" - Next hop is an NCC hub. This scenario only happens
	// when the user doesn't have permissions to the project where the next hop
	// resource is located.
	NextHopType string `json:"nextHopType,omitempty"`
	// NextHopUri: URI of the next hop resource.
	NextHopUri string `json:"nextHopUri,omitempty"`
	// OriginatingRouteDisplayName: For PEERING_SUBNET, PEERING_STATIC and
	// PEERING_DYNAMIC routes, the name of the originating SUBNET/STATIC/DYNAMIC
	// route.
	OriginatingRouteDisplayName string `json:"originatingRouteDisplayName,omitempty"`
	// OriginatingRouteUri: For PEERING_SUBNET and PEERING_STATIC routes, the URI
	// of the originating SUBNET/STATIC route.
	OriginatingRouteUri string `json:"originatingRouteUri,omitempty"`
	// Priority: Priority of the route.
	Priority int64 `json:"priority,omitempty"`
	// Protocols: Protocols of the route. POLICY_BASED routes only.
	Protocols []string `json:"protocols,omitempty"`
	// Region: Region of the route. DYNAMIC, PEERING_DYNAMIC, POLICY_BASED and
	// ADVERTISED routes only. If set for POLICY_BASED route, this is a region of
	// VLAN attachments for Cloud Interconnect the route applies to.
	Region string `json:"region,omitempty"`
	// RouteScope: Indicates where route is applicable. Deprecated, routes with
	// NCC_HUB scope are not included in the trace in new tests.
	//
	// Possible values:
	//   "ROUTE_SCOPE_UNSPECIFIED" - Unspecified scope. Default value.
	//   "NETWORK" - Route is applicable to packets in Network.
	//   "NCC_HUB" - Route is applicable to packets using NCC Hub's routing table.
	RouteScope string `json:"routeScope,omitempty"`
	// RouteType: Type of route.
	//
	// Possible values:
	//   "ROUTE_TYPE_UNSPECIFIED" - Unspecified type. Default value.
	//   "SUBNET" - Route is a subnet route automatically created by the system.
	//   "STATIC" - Static route created by the user, including the default route
	// to the internet.
	//   "DYNAMIC" - Dynamic route exchanged between BGP peers.
	//   "PEERING_SUBNET" - A subnet route received from peering network or NCC
	// Hub.
	//   "PEERING_STATIC" - A static route received from peering network.
	//   "PEERING_DYNAMIC" - A dynamic route received from peering network or NCC
	// Hub.
	//   "POLICY_BASED" - Policy based route.
	//   "ADVERTISED" - Advertised route. Synthetic route which is used to
	// transition from the StartFromPrivateNetwork state in Connectivity tests.
	RouteType string `json:"routeType,omitempty"`
	// SrcIpRange: Source IP address range of the route. POLICY_BASED routes only.
	SrcIpRange string `json:"srcIpRange,omitempty"`
	// SrcPortRanges: Source port ranges of the route. POLICY_BASED routes only.
	SrcPortRanges []string `json:"srcPortRanges,omitempty"`
	// Uri: URI of a route. SUBNET, STATIC, PEERING_SUBNET (only for peering
	// network) and POLICY_BASED routes only.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvertisedRouteNextHopUri")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvertisedRouteNextHopUri") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RouteInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RouteInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServerlessExternalConnectionInfo: For display only. Metadata associated with
// a serverless public connection.
type ServerlessExternalConnectionInfo struct {
	// SelectedIpAddress: Selected starting IP address, from the Google dynamic
	// address pool.
	SelectedIpAddress string `json:"selectedIpAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SelectedIpAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SelectedIpAddress") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServerlessExternalConnectionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ServerlessExternalConnectionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServerlessNegInfo: For display only. Metadata associated with the serverless
// network endpoint group backend.
type ServerlessNegInfo struct {
	// NegUri: URI of the serverless network endpoint group.
	NegUri string `json:"negUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NegUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NegUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServerlessNegInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ServerlessNegInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used: `paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SingleEdgeResponse: Probing results for a single edge device.
type SingleEdgeResponse struct {
	// DestinationEgressLocation: The EdgeLocation from which a packet, destined to
	// the internet, will egress the Google network. This will only be populated
	// for a connectivity test which has an internet destination address. The
	// absence of this field *must not* be used as an indication that the
	// destination is part of the Google network.
	DestinationEgressLocation *EdgeLocation `json:"destinationEgressLocation,omitempty"`
	// DestinationRouter: Router name in the format '{router}.{metroshard}'. For
	// example: pf01.aaa01, pr02.aaa01.
	DestinationRouter string `json:"destinationRouter,omitempty"`
	// ProbingLatency: Latency as measured by active probing in one direction: from
	// the source to the destination endpoint.
	ProbingLatency *LatencyDistribution `json:"probingLatency,omitempty"`
	// Result: The overall result of active probing for this egress device.
	//
	// Possible values:
	//   "PROBING_RESULT_UNSPECIFIED" - No result was specified.
	//   "REACHABLE" - At least 95% of packets reached the destination.
	//   "UNREACHABLE" - No packets reached the destination.
	//   "REACHABILITY_INCONSISTENT" - Less than 95% of packets reached the
	// destination.
	//   "UNDETERMINED" - Reachability could not be determined. Possible reasons
	// are: * The user lacks permission to access some of the network resources
	// required to run the test. * No valid source endpoint could be derived from
	// the request. * An internal error occurred.
	Result string `json:"result,omitempty"`
	// SentProbeCount: Number of probes sent.
	SentProbeCount int64 `json:"sentProbeCount,omitempty"`
	// SuccessfulProbeCount: Number of probes that reached the destination.
	SuccessfulProbeCount int64 `json:"successfulProbeCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationEgressLocation")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationEgressLocation") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SingleEdgeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SingleEdgeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Step: A simulated forwarding path is composed of multiple steps. Each step
// has a well-defined state and an associated configuration.
type Step struct {
	// Abort: Display information of the final state "abort" and reason.
	Abort *AbortInfo `json:"abort,omitempty"`
	// AppEngineVersion: Display information of an App Engine service version.
	AppEngineVersion *AppEngineVersionInfo `json:"appEngineVersion,omitempty"`
	// CausesDrop: This is a step that leads to the final state Drop.
	CausesDrop bool `json:"causesDrop,omitempty"`
	// CloudFunction: Display information of a Cloud Function.
	CloudFunction *CloudFunctionInfo `json:"cloudFunction,omitempty"`
	// CloudRunRevision: Display information of a Cloud Run revision.
	CloudRunRevision *CloudRunRevisionInfo `json:"cloudRunRevision,omitempty"`
	// CloudSqlInstance: Display information of a Cloud SQL instance.
	CloudSqlInstance *CloudSQLInstanceInfo `json:"cloudSqlInstance,omitempty"`
	// Deliver: Display information of the final state "deliver" and reason.
	Deliver *DeliverInfo `json:"deliver,omitempty"`
	// Description: A description of the step. Usually this is a summary of the
	// state.
	Description string `json:"description,omitempty"`
	// DirectVpcEgressConnection: Display information of a serverless direct VPC
	// egress connection.
	DirectVpcEgressConnection *DirectVpcEgressConnectionInfo `json:"directVpcEgressConnection,omitempty"`
	// Drop: Display information of the final state "drop" and reason.
	Drop *DropInfo `json:"drop,omitempty"`
	// Endpoint: Display information of the source and destination under analysis.
	// The endpoint information in an intermediate state may differ with the
	// initial input, as it might be modified by state like NAT, or Connection
	// Proxy.
	Endpoint *EndpointInfo `json:"endpoint,omitempty"`
	// Firewall: Display information of a Compute Engine firewall rule.
	Firewall *FirewallInfo `json:"firewall,omitempty"`
	// Forward: Display information of the final state "forward" and reason.
	Forward *ForwardInfo `json:"forward,omitempty"`
	// ForwardingRule: Display information of a Compute Engine forwarding rule.
	ForwardingRule *ForwardingRuleInfo `json:"forwardingRule,omitempty"`
	// GkeMaster: Display information of a Google Kubernetes Engine cluster master.
	GkeMaster *GKEMasterInfo `json:"gkeMaster,omitempty"`
	// GoogleService: Display information of a Google service
	GoogleService *GoogleServiceInfo `json:"googleService,omitempty"`
	// Instance: Display information of a Compute Engine instance.
	Instance *InstanceInfo `json:"instance,omitempty"`
	// LoadBalancer: Display information of the load balancers. Deprecated in favor
	// of the `load_balancer_backend_info` field, not used in new tests.
	LoadBalancer *LoadBalancerInfo `json:"loadBalancer,omitempty"`
	// LoadBalancerBackendInfo: Display information of a specific load balancer
	// backend.
	LoadBalancerBackendInfo *LoadBalancerBackendInfo `json:"loadBalancerBackendInfo,omitempty"`
	// Nat: Display information of a NAT.
	Nat *NatInfo `json:"nat,omitempty"`
	// Network: Display information of a Google Cloud network.
	Network *NetworkInfo `json:"network,omitempty"`
	// ProjectId: Project ID that contains the configuration this step is
	// validating.
	ProjectId string `json:"projectId,omitempty"`
	// ProxyConnection: Display information of a ProxyConnection.
	ProxyConnection *ProxyConnectionInfo `json:"proxyConnection,omitempty"`
	// RedisCluster: Display information of a Redis Cluster.
	RedisCluster *RedisClusterInfo `json:"redisCluster,omitempty"`
	// RedisInstance: Display information of a Redis Instance.
	RedisInstance *RedisInstanceInfo `json:"redisInstance,omitempty"`
	// Route: Display information of a Compute Engine route.
	Route *RouteInfo `json:"route,omitempty"`
	// ServerlessExternalConnection: Display information of a serverless public
	// (external) connection.
	ServerlessExternalConnection *ServerlessExternalConnectionInfo `json:"serverlessExternalConnection,omitempty"`
	// ServerlessNeg: Display information of a Serverless network endpoint group
	// backend. Used only for return traces.
	ServerlessNeg *ServerlessNegInfo `json:"serverlessNeg,omitempty"`
	// State: Each step is in one of the pre-defined states.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "START_FROM_INSTANCE" - Initial state: packet originating from a Compute
	// Engine instance. An InstanceInfo is populated with starting instance
	// information.
	//   "START_FROM_INTERNET" - Initial state: packet originating from the
	// internet. The endpoint information is populated.
	//   "START_FROM_GOOGLE_SERVICE" - Initial state: packet originating from a
	// Google service. The google_service information is populated.
	//   "START_FROM_PRIVATE_NETWORK" - Initial state: packet originating from a
	// VPC or on-premises network with internal source IP. If the source is a VPC
	// network visible to the user, a NetworkInfo is populated with details of the
	// network.
	//   "START_FROM_GKE_MASTER" - Initial state: packet originating from a Google
	// Kubernetes Engine cluster master. A GKEMasterInfo is populated with starting
	// instance information.
	//   "START_FROM_CLOUD_SQL_INSTANCE" - Initial state: packet originating from a
	// Cloud SQL instance. A CloudSQLInstanceInfo is populated with starting
	// instance information.
	//   "START_FROM_REDIS_INSTANCE" - Initial state: packet originating from a
	// Redis instance. A RedisInstanceInfo is populated with starting instance
	// information.
	//   "START_FROM_REDIS_CLUSTER" - Initial state: packet originating from a
	// Redis Cluster. A RedisClusterInfo is populated with starting Cluster
	// information.
	//   "START_FROM_CLOUD_FUNCTION" - Initial state: packet originating from a
	// Cloud Function. A CloudFunctionInfo is populated with starting function
	// information.
	//   "START_FROM_APP_ENGINE_VERSION" - Initial state: packet originating from
	// an App Engine service version. An AppEngineVersionInfo is populated with
	// starting version information.
	//   "START_FROM_CLOUD_RUN_REVISION" - Initial state: packet originating from a
	// Cloud Run revision. A CloudRunRevisionInfo is populated with starting
	// revision information.
	//   "START_FROM_STORAGE_BUCKET" - Initial state: packet originating from a
	// Storage Bucket. Used only for return traces. The storage_bucket information
	// is populated.
	//   "START_FROM_PSC_PUBLISHED_SERVICE" - Initial state: packet originating
	// from a published service that uses Private Service Connect. Used only for
	// return traces.
	//   "START_FROM_SERVERLESS_NEG" - Initial state: packet originating from a
	// serverless network endpoint group backend. Used only for return traces. The
	// serverless_neg information is populated.
	//   "APPLY_INGRESS_FIREWALL_RULE" - Config checking state: verify ingress
	// firewall rule.
	//   "APPLY_EGRESS_FIREWALL_RULE" - Config checking state: verify egress
	// firewall rule.
	//   "APPLY_ROUTE" - Config checking state: verify route.
	//   "APPLY_FORWARDING_RULE" - Config checking state: match forwarding rule.
	//   "ANALYZE_LOAD_BALANCER_BACKEND" - Config checking state: verify load
	// balancer backend configuration.
	//   "SPOOFING_APPROVED" - Config checking state: packet sent or received under
	// foreign IP address and allowed.
	//   "ARRIVE_AT_INSTANCE" - Forwarding state: arriving at a Compute Engine
	// instance.
	//   "ARRIVE_AT_INTERNAL_LOAD_BALANCER" - Forwarding state: arriving at a
	// Compute Engine internal load balancer.
	//   "ARRIVE_AT_EXTERNAL_LOAD_BALANCER" - Forwarding state: arriving at a
	// Compute Engine external load balancer.
	//   "ARRIVE_AT_VPN_GATEWAY" - Forwarding state: arriving at a Cloud VPN
	// gateway.
	//   "ARRIVE_AT_VPN_TUNNEL" - Forwarding state: arriving at a Cloud VPN tunnel.
	//   "ARRIVE_AT_VPC_CONNECTOR" - Forwarding state: arriving at a VPC connector.
	//   "DIRECT_VPC_EGRESS_CONNECTION" - Forwarding state: for packets originating
	// from a serverless endpoint forwarded through Direct VPC egress.
	//   "SERVERLESS_EXTERNAL_CONNECTION" - Forwarding state: for packets
	// originating from a serverless endpoint forwarded through public (external)
	// connectivity.
	//   "NAT" - Transition state: packet header translated.
	//   "PROXY_CONNECTION" - Transition state: original connection is terminated
	// and a new proxied connection is initiated.
	//   "DELIVER" - Final state: packet could be delivered.
	//   "DROP" - Final state: packet could be dropped.
	//   "FORWARD" - Final state: packet could be forwarded to a network with an
	// unknown configuration.
	//   "ABORT" - Final state: analysis is aborted.
	//   "VIEWER_PERMISSION_MISSING" - Special state: viewer of the test result
	// does not have permission to see the configuration in this step.
	State string `json:"state,omitempty"`
	// StorageBucket: Display information of a Storage Bucket. Used only for return
	// traces.
	StorageBucket *StorageBucketInfo `json:"storageBucket,omitempty"`
	// VpcConnector: Display information of a VPC connector.
	VpcConnector *VpcConnectorInfo `json:"vpcConnector,omitempty"`
	// VpnGateway: Display information of a Compute Engine VPN gateway.
	VpnGateway *VpnGatewayInfo `json:"vpnGateway,omitempty"`
	// VpnTunnel: Display information of a Compute Engine VPN tunnel.
	VpnTunnel *VpnTunnelInfo `json:"vpnTunnel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Abort") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Abort") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Step) MarshalJSON() ([]byte, error) {
	type NoMethod Step
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StorageBucketInfo: For display only. Metadata associated with Storage
// Bucket.
type StorageBucketInfo struct {
	// Bucket: Cloud Storage Bucket name.
	Bucket string `json:"bucket,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StorageBucketInfo) MarshalJSON() ([]byte, error) {
	type NoMethod StorageBucketInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions` method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Trace: Trace represents one simulated packet forwarding path. * Each trace
// contains multiple ordered steps. * Each step is in a particular state with
// associated configuration. * State is categorized as final or non-final
// states. * Each final state has a reason associated. * Each trace must end
// with a final state (the last step). ```
// |---------------------Trace----------------------| Step1(State) Step2(State)
// --- StepN(State(final)) ```
type Trace struct {
	// EndpointInfo: Derived from the source and destination endpoints definition
	// specified by user request, and validated by the data plane model. If there
	// are multiple traces starting from different source locations, then the
	// endpoint_info may be different between traces.
	EndpointInfo *EndpointInfo `json:"endpointInfo,omitempty"`
	// ForwardTraceId: ID of trace. For forward traces, this ID is unique for each
	// trace. For return traces, it matches ID of associated forward trace. A
	// single forward trace can be associated with none, one or more than one
	// return trace.
	ForwardTraceId int64 `json:"forwardTraceId,omitempty"`
	// Steps: A trace of a test contains multiple steps from the initial state to
	// the final state (delivered, dropped, forwarded, or aborted). The steps are
	// ordered by the processing sequence within the simulated network state
	// machine. It is critical to preserve the order of the steps and avoid
	// reordering or sorting them.
	Steps []*Step `json:"steps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndpointInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndpointInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Trace) MarshalJSON() ([]byte, error) {
	type NoMethod Trace
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VpcConnectorInfo: For display only. Metadata associated with a VPC
// connector.
type VpcConnectorInfo struct {
	// DisplayName: Name of a VPC connector.
	DisplayName string `json:"displayName,omitempty"`
	// Location: Location in which the VPC connector is deployed.
	Location string `json:"location,omitempty"`
	// Uri: URI of a VPC connector.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VpcConnectorInfo) MarshalJSON() ([]byte, error) {
	type NoMethod VpcConnectorInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VpcFlowLogsConfig: A configuration to generate VPC Flow Logs.
type VpcFlowLogsConfig struct {
	// AggregationInterval: Optional. The aggregation interval for the logs.
	// Default value is INTERVAL_5_SEC.
	//
	// Possible values:
	//   "AGGREGATION_INTERVAL_UNSPECIFIED" - If not specified, will default to
	// INTERVAL_5_SEC.
	//   "INTERVAL_5_SEC" - Aggregate logs in 5s intervals.
	//   "INTERVAL_30_SEC" - Aggregate logs in 30s intervals.
	//   "INTERVAL_1_MIN" - Aggregate logs in 1m intervals.
	//   "INTERVAL_5_MIN" - Aggregate logs in 5m intervals.
	//   "INTERVAL_10_MIN" - Aggregate logs in 10m intervals.
	//   "INTERVAL_15_MIN" - Aggregate logs in 15m intervals.
	AggregationInterval string `json:"aggregationInterval,omitempty"`
	// CreateTime: Output only. The time the config was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. The user-supplied description of the VPC Flow Logs
	// configuration. Maximum of 512 characters.
	Description string `json:"description,omitempty"`
	// FilterExpr: Optional. Export filter used to define which VPC Flow Logs
	// should be logged.
	FilterExpr string `json:"filterExpr,omitempty"`
	// FlowSampling: Optional. The value of the field must be in (0, 1]. The
	// sampling rate of VPC Flow Logs where 1.0 means all collected logs are
	// reported. Setting the sampling rate to 0.0 is not allowed. If you want to
	// disable VPC Flow Logs, use the state field instead. Default value is 1.0.
	FlowSampling float64 `json:"flowSampling,omitempty"`
	// InterconnectAttachment: Traffic will be logged from the Interconnect
	// Attachment. Format:
	// projects/{project_id}/regions/{region}/interconnectAttachments/{name}
	InterconnectAttachment string `json:"interconnectAttachment,omitempty"`
	// Labels: Optional. Resource labels to represent user-provided metadata.
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: Optional. Configures whether all, none or a subset of metadata
	// fields should be added to the reported VPC flow logs. Default value is
	// INCLUDE_ALL_METADATA.
	//
	// Possible values:
	//   "METADATA_UNSPECIFIED" - If not specified, will default to
	// INCLUDE_ALL_METADATA.
	//   "INCLUDE_ALL_METADATA" - Include all metadata fields.
	//   "EXCLUDE_ALL_METADATA" - Exclude all metadata fields.
	//   "CUSTOM_METADATA" - Include only custom fields (specified in
	// metadata_fields).
	Metadata string `json:"metadata,omitempty"`
	// MetadataFields: Optional. Custom metadata fields to include in the reported
	// VPC flow logs. Can only be specified if "metadata" was set to
	// CUSTOM_METADATA.
	MetadataFields []string `json:"metadataFields,omitempty"`
	// Name: Identifier. Unique name of the configuration using the form:
	// `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_con
	// fig_id}`
	Name string `json:"name,omitempty"`
	// State: Optional. The state of the VPC Flow Log configuration. Default value
	// is ENABLED. When creating a new configuration, it must be enabled. Setting
	// state=DISABLED will pause the log generation for this config.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - If not specified, will default to ENABLED.
	//   "ENABLED" - When ENABLED, this configuration will generate logs.
	//   "DISABLED" - When DISABLED, this configuration will not generate logs.
	State string `json:"state,omitempty"`
	// TargetResourceState: Output only. A diagnostic bit - describes the state of
	// the configured target resource for diagnostic purposes.
	//
	// Possible values:
	//   "TARGET_RESOURCE_STATE_UNSPECIFIED" - Unspecified target resource state.
	//   "TARGET_RESOURCE_EXISTS" - Indicates that the target resource exists.
	//   "TARGET_RESOURCE_DOES_NOT_EXIST" - Indicates that the target resource does
	// not exist.
	TargetResourceState string `json:"targetResourceState,omitempty"`
	// UpdateTime: Output only. The time the config was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VpnTunnel: Traffic will be logged from the VPN Tunnel. Format:
	// projects/{project_id}/regions/{region}/vpnTunnels/{name}
	VpnTunnel string `json:"vpnTunnel,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AggregationInterval") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregationInterval") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VpcFlowLogsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VpcFlowLogsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *VpcFlowLogsConfig) UnmarshalJSON(data []byte) error {
	type NoMethod VpcFlowLogsConfig
	var s1 struct {
		FlowSampling gensupport.JSONFloat64 `json:"flowSampling"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FlowSampling = float64(s1.FlowSampling)
	return nil
}

// VpnGatewayInfo: For display only. Metadata associated with a Compute Engine
// VPN gateway.
type VpnGatewayInfo struct {
	// DisplayName: Name of a VPN gateway.
	DisplayName string `json:"displayName,omitempty"`
	// IpAddress: IP address of the VPN gateway.
	IpAddress string `json:"ipAddress,omitempty"`
	// NetworkUri: URI of a Compute Engine network where the VPN gateway is
	// configured.
	NetworkUri string `json:"networkUri,omitempty"`
	// Region: Name of a Google Cloud region where this VPN gateway is configured.
	Region string `json:"region,omitempty"`
	// Uri: URI of a VPN gateway.
	Uri string `json:"uri,omitempty"`
	// VpnTunnelUri: A VPN tunnel that is associated with this VPN gateway. There
	// may be multiple VPN tunnels configured on a VPN gateway, and only the one
	// relevant to the test is displayed.
	VpnTunnelUri string `json:"vpnTunnelUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VpnGatewayInfo) MarshalJSON() ([]byte, error) {
	type NoMethod VpnGatewayInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VpnTunnelInfo: For display only. Metadata associated with a Compute Engine
// VPN tunnel.
type VpnTunnelInfo struct {
	// DisplayName: Name of a VPN tunnel.
	DisplayName string `json:"displayName,omitempty"`
	// NetworkUri: URI of a Compute Engine network where the VPN tunnel is
	// configured.
	NetworkUri string `json:"networkUri,omitempty"`
	// Region: Name of a Google Cloud region where this VPN tunnel is configured.
	Region string `json:"region,omitempty"`
	// RemoteGateway: URI of a VPN gateway at remote end of the tunnel.
	RemoteGateway string `json:"remoteGateway,omitempty"`
	// RemoteGatewayIp: Remote VPN gateway's IP address.
	RemoteGatewayIp string `json:"remoteGatewayIp,omitempty"`
	// RoutingType: Type of the routing policy.
	//
	// Possible values:
	//   "ROUTING_TYPE_UNSPECIFIED" - Unspecified type. Default value.
	//   "ROUTE_BASED" - Route based VPN.
	//   "POLICY_BASED" - Policy based routing.
	//   "DYNAMIC" - Dynamic (BGP) routing.
	RoutingType string `json:"routingType,omitempty"`
	// SourceGateway: URI of the VPN gateway at local end of the tunnel.
	SourceGateway string `json:"sourceGateway,omitempty"`
	// SourceGatewayIp: Local VPN gateway's IP address.
	SourceGatewayIp string `json:"sourceGatewayIp,omitempty"`
	// Uri: URI of a VPN tunnel.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VpnTunnelInfo) MarshalJSON() ([]byte, error) {
	type NoMethod VpnTunnelInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": A list
// of extra location types that should be used as conditions for controlling
// the visibility of the locations.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGlobalConnectivityTestsCreateCall struct {
	s                *Service
	parent           string
	connectivitytest *ConnectivityTest
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Create: Creates a new Connectivity Test. After you create a test, the
// reachability analysis is performed as part of the long running operation,
// which completes when the analysis completes. If the endpoint specifications
// in `ConnectivityTest` are invalid (for example, containing non-existent
// resources in the network, or you don't have read permissions to the network
// configurations of listed projects), then the reachability result returns a
// value of `UNKNOWN`. If the endpoint specifications in `ConnectivityTest` are
// incomplete, the reachability result returns a value of AMBIGUOUS. For more
// information, see the Connectivity Test documentation.
//
//   - parent: The parent resource of the Connectivity Test to create:
//     `projects/{project_id}/locations/global`.
func (r *ProjectsLocationsGlobalConnectivityTestsService) Create(parent string, connectivitytest *ConnectivityTest) *ProjectsLocationsGlobalConnectivityTestsCreateCall {
	c := &ProjectsLocationsGlobalConnectivityTestsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.connectivitytest = connectivitytest
	return c
}

// TestId sets the optional parameter "testId": Required. The logical name of
// the Connectivity Test in your project with the following restrictions: *
// Must contain only lowercase letters, numbers, and hyphens. * Must start with
// a letter. * Must be between 1-40 characters. * Must end with a number or a
// letter. * Must be unique within the customer project
func (c *ProjectsLocationsGlobalConnectivityTestsCreateCall) TestId(testId string) *ProjectsLocationsGlobalConnectivityTestsCreateCall {
	c.urlParams_.Set("testId", testId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalConnectivityTestsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalConnectivityTestsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalConnectivityTestsCreateCall) Context(ctx context.Context) *ProjectsLocationsGlobalConnectivityTestsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalConnectivityTestsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalConnectivityTestsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.connectivitytest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/connectivityTests")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.connectivityTests.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalConnectivityTestsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlobalConnectivityTestsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a specific `ConnectivityTest`.
//
//   - name: Connectivity Test resource name using the form:
//     `projects/{project_id}/locations/global/connectivityTests/{test_id}`.
func (r *ProjectsLocationsGlobalConnectivityTestsService) Delete(name string) *ProjectsLocationsGlobalConnectivityTestsDeleteCall {
	c := &ProjectsLocationsGlobalConnectivityTestsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalConnectivityTestsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalConnectivityTestsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalConnectivityTestsDeleteCall) Context(ctx context.Context) *ProjectsLocationsGlobalConnectivityTestsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalConnectivityTestsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalConnectivityTestsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.connectivityTests.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalConnectivityTestsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlobalConnectivityTestsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a specific Connectivity Test.
//
//   - name: `ConnectivityTest` resource name using the form:
//     `projects/{project_id}/locations/global/connectivityTests/{test_id}`.
func (r *ProjectsLocationsGlobalConnectivityTestsService) Get(name string) *ProjectsLocationsGlobalConnectivityTestsGetCall {
	c := &ProjectsLocationsGlobalConnectivityTestsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalConnectivityTestsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalConnectivityTestsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGlobalConnectivityTestsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlobalConnectivityTestsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalConnectivityTestsGetCall) Context(ctx context.Context) *ProjectsLocationsGlobalConnectivityTestsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalConnectivityTestsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalConnectivityTestsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.connectivityTests.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConnectivityTest.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGlobalConnectivityTestsGetCall) Do(opts ...googleapi.CallOption) (*ConnectivityTest, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConnectivityTest{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsGlobalConnectivityTestsService) GetIamPolicy(resource string) *ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall {
	c := &ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.connectivityTests.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalConnectivityTestsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlobalConnectivityTestsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Connectivity Tests owned by a project.
//
//   - parent: The parent resource of the Connectivity Tests:
//     `projects/{project_id}/locations/global`.
func (r *ProjectsLocationsGlobalConnectivityTestsService) List(parent string) *ProjectsLocationsGlobalConnectivityTestsListCall {
	c := &ProjectsLocationsGlobalConnectivityTestsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Lists the `ConnectivityTests`
// that match the filter expression. A filter expression filters the resources
// listed in the response. The expression must be of the form ` ` where
// operators: `<`, `>`, `<=`, `>=`, `!=`, `=`, `:` are supported (colon `:`
// represents a HAS operator which is roughly synonymous with equality). can
// refer to a proto or JSON field, or a synthetic field. Field names can be
// camelCase or snake_case. Examples: - Filter by name: name =
// "projects/proj-1/locations/global/connectivityTests/test-1 - Filter by
// labels: - Resources that have a key called `foo` labels.foo:* - Resources
// that have a key called `foo` whose value is `bar` labels.foo = bar
func (c *ProjectsLocationsGlobalConnectivityTestsListCall) Filter(filter string) *ProjectsLocationsGlobalConnectivityTestsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to use to sort the
// list.
func (c *ProjectsLocationsGlobalConnectivityTestsListCall) OrderBy(orderBy string) *ProjectsLocationsGlobalConnectivityTestsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Number of
// `ConnectivityTests` to return.
func (c *ProjectsLocationsGlobalConnectivityTestsListCall) PageSize(pageSize int64) *ProjectsLocationsGlobalConnectivityTestsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token from an
// earlier query, as returned in `next_page_token`.
func (c *ProjectsLocationsGlobalConnectivityTestsListCall) PageToken(pageToken string) *ProjectsLocationsGlobalConnectivityTestsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalConnectivityTestsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalConnectivityTestsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGlobalConnectivityTestsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlobalConnectivityTestsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalConnectivityTestsListCall) Context(ctx context.Context) *ProjectsLocationsGlobalConnectivityTestsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalConnectivityTestsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalConnectivityTestsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/connectivityTests")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.connectivityTests.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConnectivityTestsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalConnectivityTestsListCall) Do(opts ...googleapi.CallOption) (*ListConnectivityTestsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConnectivityTestsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGlobalConnectivityTestsListCall) Pages(ctx context.Context, f func(*ListConnectivityTestsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGlobalConnectivityTestsPatchCall struct {
	s                *Service
	name             string
	connectivitytest *ConnectivityTest
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Patch: Updates the configuration of an existing `ConnectivityTest`. After
// you update a test, the reachability analysis is performed as part of the
// long running operation, which completes when the analysis completes. The
// Reachability state in the test resource is updated with the new result. If
// the endpoint specifications in `ConnectivityTest` are invalid (for example,
// they contain non-existent resources in the network, or the user does not
// have read permissions to the network configurations of listed projects),
// then the reachability result returns a value of UNKNOWN. If the endpoint
// specifications in `ConnectivityTest` are incomplete, the reachability result
// returns a value of `AMBIGUOUS`. See the documentation in `ConnectivityTest`
// for more details.
//
//   - name: Identifier. Unique name of the resource using the form:
//     `projects/{project_id}/locations/global/connectivityTests/{test_id}`.
func (r *ProjectsLocationsGlobalConnectivityTestsService) Patch(name string, connectivitytest *ConnectivityTest) *ProjectsLocationsGlobalConnectivityTestsPatchCall {
	c := &ProjectsLocationsGlobalConnectivityTestsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.connectivitytest = connectivitytest
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask of
// fields to update. At least one path must be supplied in this field.
func (c *ProjectsLocationsGlobalConnectivityTestsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsGlobalConnectivityTestsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalConnectivityTestsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalConnectivityTestsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalConnectivityTestsPatchCall) Context(ctx context.Context) *ProjectsLocationsGlobalConnectivityTestsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalConnectivityTestsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalConnectivityTestsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.connectivitytest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.connectivityTests.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalConnectivityTestsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlobalConnectivityTestsRerunCall struct {
	s                            *Service
	name                         string
	rerunconnectivitytestrequest *RerunConnectivityTestRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Rerun: Rerun an existing `ConnectivityTest`. After the user triggers the
// rerun, the reachability analysis is performed as part of the long running
// operation, which completes when the analysis completes. Even though the test
// configuration remains the same, the reachability result may change due to
// underlying network configuration changes. If the endpoint specifications in
// `ConnectivityTest` become invalid (for example, specified resources are
// deleted in the network, or you lost read permissions to the network
// configurations of listed projects), then the reachability result returns a
// value of `UNKNOWN`.
//
//   - name: Connectivity Test resource name using the form:
//     `projects/{project_id}/locations/global/connectivityTests/{test_id}`.
func (r *ProjectsLocationsGlobalConnectivityTestsService) Rerun(name string, rerunconnectivitytestrequest *RerunConnectivityTestRequest) *ProjectsLocationsGlobalConnectivityTestsRerunCall {
	c := &ProjectsLocationsGlobalConnectivityTestsRerunCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.rerunconnectivitytestrequest = rerunconnectivitytestrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalConnectivityTestsRerunCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalConnectivityTestsRerunCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalConnectivityTestsRerunCall) Context(ctx context.Context) *ProjectsLocationsGlobalConnectivityTestsRerunCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalConnectivityTestsRerunCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalConnectivityTestsRerunCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rerunconnectivitytestrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:rerun")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.rerun", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.connectivityTests.rerun" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalConnectivityTestsRerunCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.rerun", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlobalConnectivityTestsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsGlobalConnectivityTestsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsGlobalConnectivityTestsSetIamPolicyCall {
	c := &ProjectsLocationsGlobalConnectivityTestsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalConnectivityTestsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalConnectivityTestsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalConnectivityTestsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsGlobalConnectivityTestsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalConnectivityTestsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalConnectivityTestsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.connectivityTests.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalConnectivityTestsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlobalConnectivityTestsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsGlobalConnectivityTestsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsGlobalConnectivityTestsTestIamPermissionsCall {
	c := &ProjectsLocationsGlobalConnectivityTestsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalConnectivityTestsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalConnectivityTestsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalConnectivityTestsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsGlobalConnectivityTestsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalConnectivityTestsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalConnectivityTestsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.connectivityTests.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalConnectivityTestsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.connectivityTests.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlobalOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsGlobalOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsGlobalOperationsCancelCall {
	c := &ProjectsLocationsGlobalOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsGlobalOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlobalOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsGlobalOperationsService) Delete(name string) *ProjectsLocationsGlobalOperationsDeleteCall {
	c := &ProjectsLocationsGlobalOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsGlobalOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlobalOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsGlobalOperationsService) Get(name string) *ProjectsLocationsGlobalOperationsGetCall {
	c := &ProjectsLocationsGlobalOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGlobalOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlobalOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsGlobalOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlobalOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlobalOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsGlobalOperationsService) List(name string) *ProjectsLocationsGlobalOperationsListCall {
	c := &ProjectsLocationsGlobalOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsGlobalOperationsListCall) Filter(filter string) *ProjectsLocationsGlobalOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsGlobalOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsGlobalOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsGlobalOperationsListCall) PageToken(pageToken string) *ProjectsLocationsGlobalOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlobalOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlobalOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGlobalOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlobalOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlobalOperationsListCall) Context(ctx context.Context) *ProjectsLocationsGlobalOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlobalOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlobalOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.global.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGlobalOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.global.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGlobalOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsVpcFlowLogsConfigsCreateCall struct {
	s                 *Service
	parent            string
	vpcflowlogsconfig *VpcFlowLogsConfig
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Create: Creates a new `VpcFlowLogsConfig`. If a configuration with the exact
// same settings already exists (even if the ID is different), the creation
// fails. Notes: 1. Creating a configuration with state=DISABLED will fail 2.
// The following fields are not considered as `settings` for the purpose of the
// check mentioned above, therefore - creating another configuration with the
// same fields but different values for the following fields will fail as well:
// * name * create_time * update_time * labels * description
//
//   - parent: The parent resource of the VPC Flow Logs configuration to create:
//     `projects/{project_id}/locations/global`.
func (r *ProjectsLocationsVpcFlowLogsConfigsService) Create(parent string, vpcflowlogsconfig *VpcFlowLogsConfig) *ProjectsLocationsVpcFlowLogsConfigsCreateCall {
	c := &ProjectsLocationsVpcFlowLogsConfigsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.vpcflowlogsconfig = vpcflowlogsconfig
	return c
}

// VpcFlowLogsConfigId sets the optional parameter "vpcFlowLogsConfigId":
// Required. ID of the `VpcFlowLogsConfig`.
func (c *ProjectsLocationsVpcFlowLogsConfigsCreateCall) VpcFlowLogsConfigId(vpcFlowLogsConfigId string) *ProjectsLocationsVpcFlowLogsConfigsCreateCall {
	c.urlParams_.Set("vpcFlowLogsConfigId", vpcFlowLogsConfigId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVpcFlowLogsConfigsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsVpcFlowLogsConfigsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVpcFlowLogsConfigsCreateCall) Context(ctx context.Context) *ProjectsLocationsVpcFlowLogsConfigsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVpcFlowLogsConfigsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVpcFlowLogsConfigsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.vpcflowlogsconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vpcFlowLogsConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.vpcFlowLogsConfigs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.vpcFlowLogsConfigs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVpcFlowLogsConfigsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.vpcFlowLogsConfigs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVpcFlowLogsConfigsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a specific `VpcFlowLogsConfig`.
//
//   - name: `VpcFlowLogsConfig` resource name using the form:
//     `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_c
//     onfig}`.
func (r *ProjectsLocationsVpcFlowLogsConfigsService) Delete(name string) *ProjectsLocationsVpcFlowLogsConfigsDeleteCall {
	c := &ProjectsLocationsVpcFlowLogsConfigsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVpcFlowLogsConfigsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsVpcFlowLogsConfigsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVpcFlowLogsConfigsDeleteCall) Context(ctx context.Context) *ProjectsLocationsVpcFlowLogsConfigsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVpcFlowLogsConfigsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVpcFlowLogsConfigsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.vpcFlowLogsConfigs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.vpcFlowLogsConfigs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVpcFlowLogsConfigsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.vpcFlowLogsConfigs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVpcFlowLogsConfigsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a specific `VpcFlowLogsConfig`.
//
//   - name: `VpcFlowLogsConfig` resource name using the form:
//     `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_c
//     onfig}`.
func (r *ProjectsLocationsVpcFlowLogsConfigsService) Get(name string) *ProjectsLocationsVpcFlowLogsConfigsGetCall {
	c := &ProjectsLocationsVpcFlowLogsConfigsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVpcFlowLogsConfigsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsVpcFlowLogsConfigsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsVpcFlowLogsConfigsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsVpcFlowLogsConfigsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVpcFlowLogsConfigsGetCall) Context(ctx context.Context) *ProjectsLocationsVpcFlowLogsConfigsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVpcFlowLogsConfigsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVpcFlowLogsConfigsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.vpcFlowLogsConfigs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.vpcFlowLogsConfigs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *VpcFlowLogsConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsVpcFlowLogsConfigsGetCall) Do(opts ...googleapi.CallOption) (*VpcFlowLogsConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &VpcFlowLogsConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.vpcFlowLogsConfigs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsVpcFlowLogsConfigsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all `VpcFlowLogsConfigs` in a given project.
//
//   - parent: The parent resource of the VpcFlowLogsConfig:
//     `projects/{project_id}/locations/global`.
func (r *ProjectsLocationsVpcFlowLogsConfigsService) List(parent string) *ProjectsLocationsVpcFlowLogsConfigsListCall {
	c := &ProjectsLocationsVpcFlowLogsConfigsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Lists the `VpcFlowLogsConfigs`
// that match the filter expression. A filter expression must use the supported
// [CEL logic operators]
// (https://cloud.google.com/vpc/docs/about-flow-logs-records#supported_cel_logic_operators).
func (c *ProjectsLocationsVpcFlowLogsConfigsListCall) Filter(filter string) *ProjectsLocationsVpcFlowLogsConfigsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field to use to sort the
// list.
func (c *ProjectsLocationsVpcFlowLogsConfigsListCall) OrderBy(orderBy string) *ProjectsLocationsVpcFlowLogsConfigsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Number of
// `VpcFlowLogsConfigs` to return.
func (c *ProjectsLocationsVpcFlowLogsConfigsListCall) PageSize(pageSize int64) *ProjectsLocationsVpcFlowLogsConfigsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token from an
// earlier query, as returned in `next_page_token`.
func (c *ProjectsLocationsVpcFlowLogsConfigsListCall) PageToken(pageToken string) *ProjectsLocationsVpcFlowLogsConfigsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVpcFlowLogsConfigsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsVpcFlowLogsConfigsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsVpcFlowLogsConfigsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsVpcFlowLogsConfigsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVpcFlowLogsConfigsListCall) Context(ctx context.Context) *ProjectsLocationsVpcFlowLogsConfigsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVpcFlowLogsConfigsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVpcFlowLogsConfigsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vpcFlowLogsConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.vpcFlowLogsConfigs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.vpcFlowLogsConfigs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListVpcFlowLogsConfigsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVpcFlowLogsConfigsListCall) Do(opts ...googleapi.CallOption) (*ListVpcFlowLogsConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListVpcFlowLogsConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.vpcFlowLogsConfigs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsVpcFlowLogsConfigsListCall) Pages(ctx context.Context, f func(*ListVpcFlowLogsConfigsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsVpcFlowLogsConfigsPatchCall struct {
	s                 *Service
	name              string
	vpcflowlogsconfig *VpcFlowLogsConfig
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Patch: Updates an existing `VpcFlowLogsConfig`. If a configuration with the
// exact same settings already exists (even if the ID is different), the
// creation fails. Notes: 1. Updating a configuration with state=DISABLED will
// fail. 2. The following fields are not considered as `settings` for the
// purpose of the check mentioned above, therefore - updating another
// configuration with the same fields but different values for the following
// fields will fail as well: * name * create_time * update_time * labels *
// description
//
//   - name: Identifier. Unique name of the configuration using the form:
//     `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_c
//     onfig_id}`.
func (r *ProjectsLocationsVpcFlowLogsConfigsService) Patch(name string, vpcflowlogsconfig *VpcFlowLogsConfig) *ProjectsLocationsVpcFlowLogsConfigsPatchCall {
	c := &ProjectsLocationsVpcFlowLogsConfigsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.vpcflowlogsconfig = vpcflowlogsconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask of
// fields to update. At least one path must be supplied in this field.
func (c *ProjectsLocationsVpcFlowLogsConfigsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsVpcFlowLogsConfigsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsVpcFlowLogsConfigsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsVpcFlowLogsConfigsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsVpcFlowLogsConfigsPatchCall) Context(ctx context.Context) *ProjectsLocationsVpcFlowLogsConfigsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsVpcFlowLogsConfigsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVpcFlowLogsConfigsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.vpcflowlogsconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.vpcFlowLogsConfigs.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "networkmanagement.projects.locations.vpcFlowLogsConfigs.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsVpcFlowLogsConfigsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "networkmanagement.projects.locations.vpcFlowLogsConfigs.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
