//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicalendarselectionmultidate?language=objc)
    #[unsafe(super(UICalendarSelection, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UICalendarSelection")]
    pub struct UICalendarSelectionMultiDate;
);

#[cfg(feature = "UICalendarSelection")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UICalendarSelectionMultiDate {}
);

#[cfg(feature = "UICalendarSelection")]
impl UICalendarSelectionMultiDate {
    extern_methods!(
        /// The currently selected dates in the Calendar view.
        #[unsafe(method(selectedDates))]
        #[unsafe(method_family = none)]
        pub fn selectedDates(&self) -> Retained<NSArray<NSDateComponents>>;

        /// Setter for [`selectedDates`][Self::selectedDates].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSelectedDates:))]
        #[unsafe(method_family = none)]
        pub fn setSelectedDates(&self, selected_dates: &NSArray<NSDateComponents>);

        /// Sets the dates to display in the calendar, with an option to animate the setting.
        #[unsafe(method(setSelectedDates:animated:))]
        #[unsafe(method_family = none)]
        pub fn setSelectedDates_animated(
            &self,
            selected_dates: &NSArray<NSDateComponents>,
            animated: bool,
        );

        /// The object that acts as the delegate of the calendar view selection
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UICalendarSelectionMultiDateDelegate>>>;

        /// Creates a new multi-date selection with the specified delegate.
        #[unsafe(method(initWithDelegate:))]
        #[unsafe(method_family = init)]
        pub fn initWithDelegate(
            this: Allocated<Self>,
            delegate: Option<&ProtocolObject<dyn UICalendarSelectionMultiDateDelegate>>,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `UICalendarSelection`.
#[cfg(feature = "UICalendarSelection")]
impl UICalendarSelectionMultiDate {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicalendarselectionmultidatedelegate?language=objc)
    pub unsafe trait UICalendarSelectionMultiDateDelegate:
        NSObjectProtocol + MainThreadOnly
    {
        #[cfg(feature = "UICalendarSelection")]
        /// Called after the user selects a date in the calendar view.
        ///
        ///
        /// Parameter `selection`: The
        /// `UICalendarSelectionMultiDate`
        /// Parameter `dateComponents`: The date that was selected by the user.
        #[unsafe(method(multiDateSelection:didSelectDate:))]
        #[unsafe(method_family = none)]
        fn multiDateSelection_didSelectDate(
            &self,
            selection: &UICalendarSelectionMultiDate,
            date_components: &NSDateComponents,
        );

        #[cfg(feature = "UICalendarSelection")]
        /// Called after the user removes selection from one of hte selected dates the calendar view.
        ///
        ///
        /// Parameter `selection`: The
        /// `UICalendarSelectionMultiDate`
        /// Parameter `dateComponents`: The date that was deselected by the user.
        #[unsafe(method(multiDateSelection:didDeselectDate:))]
        #[unsafe(method_family = none)]
        fn multiDateSelection_didDeselectDate(
            &self,
            selection: &UICalendarSelectionMultiDate,
            date_components: &NSDateComponents,
        );

        #[cfg(feature = "UICalendarSelection")]
        /// Determines if a date is selectable. Dates that are not selectable will be disabled in the calendar view.
        ///
        ///
        /// Parameter `selection`: The
        /// `UICalendarSelectionMultiDate`
        /// Parameter `dateComponents`: The date to be checked by selection.
        ///
        ///
        /// Returns: YES if the date can be selected, NO otherwise.
        #[optional]
        #[unsafe(method(multiDateSelection:canSelectDate:))]
        #[unsafe(method_family = none)]
        fn multiDateSelection_canSelectDate(
            &self,
            selection: &UICalendarSelectionMultiDate,
            date_components: &NSDateComponents,
        ) -> bool;

        #[cfg(feature = "UICalendarSelection")]
        /// Determines if a date can be deselected.
        ///
        ///
        /// Parameter `selection`: The
        /// `UICalendarSelectionMultiDate`
        /// Parameter `dateComponents`: The date to be checked by selection.
        ///
        ///
        /// Returns: YES if the date can be deselected, NO otherwise.
        #[optional]
        #[unsafe(method(multiDateSelection:canDeselectDate:))]
        #[unsafe(method_family = none)]
        fn multiDateSelection_canDeselectDate(
            &self,
            selection: &UICalendarSelectionMultiDate,
            date_components: &NSDateComponents,
        ) -> bool;
    }
);
