//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "dispatch2")]
use dispatch2::*;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kauparameterlistener_anyparameter?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUParameterListener_AnyParameter: AudioUnitParameterID = 0xFFFFFFFF;

/// Types of Audio Unit Events.
///
///
/// The event is a change to a parameter value
///
/// The event signifies a gesture (e.g. mouse-down) beginning a potential series of
/// related parameter value change events.
///
/// The event signifies a gesture (e.g. mouse-up) ending a series of related
/// parameter value change events.
///
/// The event is a change to a property value.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiouniteventtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioUnitEventType(pub u32);
impl AudioUnitEventType {
    #[doc(alias = "kAudioUnitEvent_ParameterValueChange")]
    pub const ParameterValueChange: Self = Self(0);
    #[doc(alias = "kAudioUnitEvent_BeginParameterChangeGesture")]
    pub const BeginParameterChangeGesture: Self = Self(1);
    #[doc(alias = "kAudioUnitEvent_EndParameterChangeGesture")]
    pub const EndParameterChangeGesture: Self = Self(2);
    #[doc(alias = "kAudioUnitEvent_PropertyChange")]
    pub const PropertyChange: Self = Self(3);
}

unsafe impl Encode for AudioUnitEventType {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioUnitEventType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/aulistenerbase?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct AUListenerBase {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

unsafe impl RefEncode for AUListenerBase {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Encoding::Struct("AUListenerBase", &[]));
}

/// An object which receives notifications of Audio Unit parameter value changes.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auparameterlistenerref?language=objc)
pub type AUParameterListenerRef = *mut AUListenerBase;

/// An object which receives Audio Unit events.
///
/// An AUEventListenerRef may be passed to API's taking an AUEventListenerRef
/// as an argument.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/aueventlistenerref?language=objc)
pub type AUEventListenerRef = AUParameterListenerRef;

/// A block called when a parameter value changes.
///
/// Parameter `inObject`: The object which generated the parameter change.
///
/// Parameter `inParameter`: Signifies the parameter whose value changed.
///
/// Parameter `inValue`: The parameter's new value.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auparameterlistenerblock?language=objc)
#[cfg(all(
    feature = "AUComponent",
    feature = "AudioComponent",
    feature = "block2"
))]
pub type AUParameterListenerBlock = *mut block2::DynBlock<
    dyn Fn(*mut c_void, NonNull<AudioUnitParameter>, AudioUnitParameterValue),
>;

/// A function called when a parameter value changes.
///
/// Parameter `inUserData`: The value passed to AUListenerCreate when the callback function was installed.
///
/// Parameter `inObject`: The object which generated the parameter change.
///
/// Parameter `inParameter`: Signifies the parameter whose value changed.
///
/// Parameter `inValue`: The parameter's new value.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auparameterlistenerproc?language=objc)
#[cfg(all(feature = "AUComponent", feature = "AudioComponent"))]
pub type AUParameterListenerProc = Option<
    unsafe extern "C-unwind" fn(
        *mut c_void,
        *mut c_void,
        NonNull<AudioUnitParameter>,
        AudioUnitParameterValue,
    ),
>;

extern "C-unwind" {
    /// Create an object for fielding notifications when AudioUnit parameter values change.
    ///
    /// Parameter `outListener`: On successful return, an AUParameterListenerRef.
    ///
    /// Parameter `inNotificationInterval`: The minimum time interval, in seconds, at which the callback will be called.
    /// If multiple parameter value changes occur within this time interval, the
    /// listener will only receive a notification for the last value change that
    /// occurred before the callback.  If inNotificationInterval is 0, the inRunLoop
    /// and inRunLoopMode arguments are ignored, and the callback will be issued
    /// immediately, on the thread on which the parameter was changed.
    ///
    /// Parameter `inDispatchQueue`: Dispatch queue on which the callback is called.
    ///
    /// Parameter `inBlock`: Block called when the parameter's value changes.
    ///
    /// Note that only parameter changes issued through AUParameterSet will generate
    /// notifications to listeners; thus, in most cases, AudioUnit clients should use
    /// AUParameterSet in preference to AudioUnitSetParameterValue.
    #[cfg(all(
        feature = "AUComponent",
        feature = "AudioComponent",
        feature = "block2",
        feature = "dispatch2"
    ))]
    pub fn AUListenerCreateWithDispatchQueue(
        out_listener: NonNull<AUParameterListenerRef>,
        in_notification_interval: f32,
        in_dispatch_queue: &DispatchQueue,
        in_block: AUParameterListenerBlock,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Create an object for fielding notifications when AudioUnit parameter values change.
    ///
    /// Parameter `inProc`: Function called when the parameter's value changes.
    ///
    /// Parameter `inUserData`: A reference value for the use of the callback function.
    ///
    /// Parameter `inRunLoop`: The run loop on which the callback is called.  If NULL,
    /// CFRunLoopGetCurrent() is used.
    ///
    /// Parameter `inRunLoopMode`: The run loop mode in which the callback's underlying run loop source will be
    /// attached.  If NULL, kCFRunLoopDefaultMode is used.
    ///
    /// Parameter `inNotificationInterval`: The minimum time interval, in seconds, at which the callback will be called.
    /// If multiple parameter value changes occur within this time interval, the
    /// listener will only receive a notification for the last value change that
    /// occurred before the callback.  If inNotificationInterval is 0, the inRunLoop
    /// and inRunLoopMode arguments are ignored, and the callback will be issued
    /// immediately, on the thread on which the parameter was changed.
    ///
    /// Parameter `outListener`: On successful return, an AUParameterListenerRef.
    ///
    /// Note that only parameter changes issued through AUParameterSet will generate
    /// notifications to listeners; thus, in most cases, AudioUnit clients should use
    /// AUParameterSet in preference to AudioUnitSetParameter.
    #[cfg(all(
        feature = "AUComponent",
        feature = "AudioComponent",
        feature = "objc2-core-foundation"
    ))]
    pub fn AUListenerCreate(
        in_proc: AUParameterListenerProc,
        in_user_data: NonNull<c_void>,
        in_run_loop: Option<&CFRunLoop>,
        in_run_loop_mode: Option<&CFString>,
        in_notification_interval: f32,
        out_listener: NonNull<AUParameterListenerRef>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Dispose a parameter listener object.
    ///
    /// Parameter `inListener`: The parameter listener to dispose.
    pub fn AUListenerDispose(in_listener: AUParameterListenerRef) -> OSStatus;
}

extern "C-unwind" {
    /// Connect a parameter to a listener.
    ///
    /// Parameter `inListener`: The parameter listener which will receive the callback.
    ///
    /// Parameter `inObject`: The object which is interested in the value of the parameter.  This will be
    /// passed as the inObject parameter to the listener callback function when the
    /// parameter changes.
    ///
    /// Parameter `inParameter`: The parameter whose value changes are to generate callbacks.
    ///
    /// Associates an arbitrary object (often a user interface widget) with an
    /// AudioUnitParameter, and delivers notifications to the specified listener, telling it
    /// that the object needs to be informed of the parameter's value change.
    #[cfg(all(feature = "AUComponent", feature = "AudioComponent"))]
    pub fn AUListenerAddParameter(
        in_listener: AUParameterListenerRef,
        in_object: *mut c_void,
        in_parameter: NonNull<AudioUnitParameter>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Remove a parameter/listener connection.
    ///
    /// Parameter `inListener`: The parameter listener to stop receiving callbacks.
    ///
    /// Parameter `inObject`: The object which is no longer interested in the value of the parameter.
    ///
    /// Parameter `inParameter`: The parameter whose value changes are to stop generating callbacks.
    #[cfg(all(feature = "AUComponent", feature = "AudioComponent"))]
    pub fn AUListenerRemoveParameter(
        in_listener: AUParameterListenerRef,
        in_object: *mut c_void,
        in_parameter: NonNull<AudioUnitParameter>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Set an AudioUnit parameter value and notify listeners.
    ///
    /// Parameter `inSendingListener`: A parameter listener generating the change and which does not want to
    /// receive a callback as a result of it. May be NULL.
    ///
    /// Parameter `inSendingObject`: The object generating the change and which does not want to receive a
    /// callback as a result of it. NULL is treated specially when inListener is
    /// non-null; it signifies that none of the specified listener's objects will
    /// receive notifications.
    ///
    /// Parameter `inParameter`: The parameter being changed.
    ///
    /// Parameter `inValue`: The new value of the parameter.
    ///
    /// Parameter `inBufferOffsetInFrames`: The offset into the next rendered buffer at which the parameter change will take
    /// effect.
    ///
    /// Calls AudioUnitSetParameter, and performs/schedules notification callbacks to all
    /// parameter listeners, for that parameter -- except that no callback will be generated to
    /// the inListener/inObject pair.
    #[cfg(all(feature = "AUComponent", feature = "AudioComponent"))]
    pub fn AUParameterSet(
        in_sending_listener: AUParameterListenerRef,
        in_sending_object: *mut c_void,
        in_parameter: NonNull<AudioUnitParameter>,
        in_value: AudioUnitParameterValue,
        in_buffer_offset_in_frames: u32,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Notify listeners of a past parameter change.
    ///
    /// Parameter `inSendingListener`: A parameter listener generating the change and which does not want to
    /// receive a callback as a result of it. May be NULL.
    ///
    /// Parameter `inSendingObject`: The object generating the change and which does not want to receive a
    /// callback as a result of it. NULL is treated specially when inListener is
    /// non-null; it signifies that none of the specified listener's objects will
    /// receive notifications.
    ///
    /// Parameter `inParameter`: The parameter which was changed.
    ///
    /// Performs and schedules the notification callbacks of AUParameterSet, without
    /// actually setting an AudioUnit parameter value.
    ///
    /// Clients scheduling ramped parameter changes to AudioUnits must make this call
    /// dynamically during playback in order for AudioUnitViews to be updated.  When the view's
    /// listener receives a notification, it will be passed the current value of the parameter.
    ///
    /// A special meaning is applied if the mParameterID value of inParameter is equal to
    /// kAUParameterListener_AnyParameter. In this case, ANY listener for ANY parameter value
    /// changes on the specified AudioUnit will be notified of the current value of that
    /// parameter.
    #[cfg(all(feature = "AUComponent", feature = "AudioComponent"))]
    pub fn AUParameterListenerNotify(
        in_sending_listener: AUParameterListenerRef,
        in_sending_object: *mut c_void,
        in_parameter: NonNull<AudioUnitParameter>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Converts a linear value to a parameter value according to the parameter's units.
    ///
    ///
    /// Parameter `inLinearValue`: The linear value (0.0-1.0) to convert.
    ///
    /// Parameter `inParameter`: The parameter, including its Audio Unit, that will define the conversion of
    /// the supplied linear value to a value that is natural to that parameter.
    ///
    /// Returns: The converted parameter value, in the parameter's natural units.
    #[cfg(all(feature = "AUComponent", feature = "AudioComponent"))]
    pub fn AUParameterValueFromLinear(
        in_linear_value: f32,
        in_parameter: NonNull<AudioUnitParameter>,
    ) -> AudioUnitParameterValue;
}

extern "C-unwind" {
    /// Converts a parameter value to a linear value according to the parameter's units.
    ///
    ///
    /// Parameter `inParameterValue`: The value in the natural units of the specified parameter.
    ///
    ///
    /// Parameter `inParameter`: The parameter, including its Audio Unit, that will define the conversion of
    /// the supplied parameter value to a corresponding linear value.
    ///
    /// Returns: A number 0.0-1.0.
    #[cfg(all(feature = "AUComponent", feature = "AudioComponent"))]
    pub fn AUParameterValueToLinear(
        in_parameter_value: AudioUnitParameterValue,
        in_parameter: NonNull<AudioUnitParameter>,
    ) -> f32;
}

/// Format a parameter value into a string.
///
/// Parameter `inParameterValue`: The parameter value to be formatted.
///
/// Parameter `inParameter`: The Audio Unit, scope, element, and parameter whose value this is.
///
/// Parameter `inTextBuffer`: The character array to receive the formatted text.  Should be at least 32
/// characters.
///
/// Parameter `inDigits`: The resolution of the string (see example above).
///
/// Returns: `inTextBuffer`
///
///
/// Formats a floating point value into a string.  Computes a power of 10 to which the value
/// will be rounded and displayed as follows:  if the the parameter is logarithmic (Hertz),
/// the number of significant digits is inDigits - pow10(inParameterValue) + 1.  Otherwise,
/// it is inDigits - pow10(maxValue - minValue) + 1.
///
/// Example for inDigits=3:
///
/// pow10 | range        |  digits after decimal place display
/// ------|--------------|------------------------------------
/// -2    | .0100-.0999  |  4
/// -1    | .100-.999    |  3
/// 0     | 1.00-9.99    |  2
/// 1     | 10.0-99.9    |  1
/// 2     | 100-999      |  0
/// 3     | 1000-9990    |  -1
/// 4     | 10000-99900  |  -2
#[cfg(all(feature = "AUComponent", feature = "AudioComponent"))]
#[inline]
pub unsafe extern "C-unwind" fn AUParameterFormatValue(
    in_parameter_value: f64,
    in_parameter: NonNull<AudioUnitParameter>,
    in_text_buffer: NonNull<c_char>,
    in_digits: u32,
) -> NonNull<c_char> {
    extern "C-unwind" {
        fn AUParameterFormatValue(
            in_parameter_value: f64,
            in_parameter: NonNull<AudioUnitParameter>,
            in_text_buffer: NonNull<c_char>,
            in_digits: u32,
        ) -> Option<NonNull<c_char>>;
    }
    let ret = unsafe {
        AUParameterFormatValue(in_parameter_value, in_parameter, in_text_buffer, in_digits)
    };
    ret.expect("function was marked as returning non-null, but actually returned NULL")
}
