// Copyright 2024 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//go:build !windows
// +build !windows

package sanitizer

import (
	"path/filepath"
	"strings"
)

var (
	nixReplacer = strings.NewReplacer(`\`, `/`)
)

func sanitizePath(in string) string {

	// normalizing path separators (something filepath.Clean will do it for us on Windows, but not
	// on the other platforms)
	in = nixReplacer.Replace(in)

	return strings.TrimPrefix(filepath.Clean(nixPathSeparator+in), nixPathSeparator)
}
