#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1967
#define LARGE_STATE_COUNT 14
#define SYMBOL_COUNT 274
#define ALIAS_COUNT 1
#define TOKEN_COUNT 96
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 32
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 78

enum {
  sym_module_comment = 1,
  sym_statement_comment = 2,
  sym_comment = 3,
  anon_sym_if = 4,
  anon_sym_LBRACE = 5,
  anon_sym_RBRACE = 6,
  anon_sym_erlang = 7,
  anon_sym_javascript = 8,
  anon_sym_AT = 9,
  anon_sym_LPAREN = 10,
  anon_sym_COMMA = 11,
  anon_sym_RPAREN = 12,
  anon_sym_COLON = 13,
  anon_sym_import = 14,
  anon_sym_DOT = 15,
  anon_sym_as = 16,
  anon_sym_SLASH = 17,
  anon_sym_type = 18,
  anon_sym_const = 19,
  anon_sym_EQ = 20,
  anon_sym_POUND = 21,
  anon_sym_LBRACK = 22,
  anon_sym_RBRACK = 23,
  anon_sym_LT_LT = 24,
  anon_sym_GT_GT = 25,
  anon_sym_DASH = 26,
  anon_sym_size = 27,
  anon_sym_fn = 28,
  anon_sym_DASH_GT = 29,
  anon_sym_external = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_AMP_AMP = 32,
  anon_sym_EQ_EQ = 33,
  anon_sym_BANG_EQ = 34,
  anon_sym_LT = 35,
  anon_sym_LT_EQ = 36,
  anon_sym_LT_DOT = 37,
  anon_sym_LT_EQ_DOT = 38,
  anon_sym_GT = 39,
  anon_sym_GT_EQ = 40,
  anon_sym_GT_DOT = 41,
  anon_sym_GT_EQ_DOT = 42,
  anon_sym_PIPE_GT = 43,
  anon_sym_PLUS = 44,
  anon_sym_PLUS_DOT = 45,
  anon_sym_DASH_DOT = 46,
  anon_sym_STAR = 47,
  anon_sym_STAR_DOT = 48,
  anon_sym_SLASH_DOT = 49,
  anon_sym_PERCENT = 50,
  anon_sym_LT_GT = 51,
  anon_sym_todo = 52,
  anon_sym_panic = 53,
  anon_sym_echo = 54,
  anon_sym_DOT_DOT = 55,
  anon_sym_case = 56,
  anon_sym_PIPE = 57,
  anon_sym_let = 58,
  anon_sym_assert = 59,
  anon_sym_use = 60,
  anon_sym_LT_DASH = 61,
  anon_sym_BANG = 62,
  sym_visibility_modifier = 63,
  sym_opacity_modifier = 64,
  anon_sym_DQUOTE = 65,
  anon_sym_DQUOTE2 = 66,
  aux_sym_escape_sequence_token1 = 67,
  aux_sym_escape_sequence_token2 = 68,
  sym_float = 69,
  sym__hex = 70,
  sym__decimal = 71,
  sym__octal = 72,
  sym__binary = 73,
  anon_sym_binary = 74,
  anon_sym_bytes = 75,
  anon_sym_int = 76,
  anon_sym_float = 77,
  anon_sym_bit_string = 78,
  anon_sym_bits = 79,
  anon_sym_utf8 = 80,
  anon_sym_utf16 = 81,
  anon_sym_utf32 = 82,
  anon_sym_utf8_codepoint = 83,
  anon_sym_utf16_codepoint = 84,
  anon_sym_utf32_codepoint = 85,
  anon_sym_signed = 86,
  anon_sym_unsigned = 87,
  anon_sym_big = 88,
  anon_sym_little = 89,
  anon_sym_native = 90,
  anon_sym_unit = 91,
  sym__discard_name = 92,
  sym__name = 93,
  sym__upname = 94,
  sym_quoted_content = 95,
  sym_source_file = 96,
  sym__module_statement = 97,
  sym_target_group = 98,
  sym_target = 99,
  sym_attribute = 100,
  sym__attribute_arguments = 101,
  sym_attribute_value = 102,
  sym_import = 103,
  sym_module = 104,
  sym_unqualified_imports = 105,
  sym_unqualified_import = 106,
  sym_constant = 107,
  sym__constant_value = 108,
  sym_constant_tuple = 109,
  sym_constant_list = 110,
  sym__constant_bit_string = 111,
  sym_constant_bit_string_segment = 112,
  sym_constant_bit_string_segment_options = 113,
  sym__constant_bit_string_segment_option = 114,
  sym__constant_bit_string_named_segment_option = 115,
  sym__constant_bit_string_segment_option_size = 116,
  sym_constant_record = 117,
  sym_constant_record_arguments = 118,
  sym_constant_record_argument = 119,
  sym_constant_field_access = 120,
  sym__constant_type = 121,
  sym__constant_type_annotation = 122,
  sym_constant_tuple_type = 123,
  sym_constant_function_type = 124,
  sym_constant_function_parameter_types = 125,
  sym_constant_type = 126,
  sym_constant_type_arguments = 127,
  sym_constant_type_argument = 128,
  sym_external_type = 129,
  sym_external_function = 130,
  sym_external_function_parameters = 131,
  sym_external_function_parameter = 132,
  sym_external_function_body = 133,
  sym_function = 134,
  sym_function_parameters = 135,
  sym_function_parameter = 136,
  sym__labeled_discard_param = 137,
  sym__discard_param = 138,
  sym__labeled_name_param = 139,
  sym__name_param = 140,
  aux_sym__statement_seq = 141,
  sym__statement = 142,
  sym__expression = 143,
  sym_binary_expression = 144,
  sym__expression_unit = 145,
  sym_record = 146,
  sym_todo = 147,
  sym_panic = 148,
  sym_pipeline_echo = 149,
  sym_echo = 150,
  sym_tuple = 151,
  sym_list = 152,
  sym__expression_bit_string = 153,
  sym_expression_bit_string_segment = 154,
  sym_expression_bit_string_segment_options = 155,
  sym__expression_bit_string_segment_option = 156,
  sym__expression_bit_string_named_segment_option = 157,
  sym__expression_bit_string_segment_option_size = 158,
  sym_anonymous_function = 159,
  sym_anonymous_function_parameters = 160,
  sym_anonymous_function_parameter = 161,
  sym_block = 162,
  sym_case = 163,
  sym_case_subjects = 164,
  sym_case_clauses = 165,
  sym_case_clause = 166,
  sym_case_clause_patterns = 167,
  sym_case_clause_pattern = 168,
  sym_case_clause_guard = 169,
  sym__case_clause_guard_expression = 170,
  sym__case_clause_guard_binary_expression = 171,
  sym__case_clause_guard_unit = 172,
  sym__case_clause_tuple_access = 173,
  sym_let_assert = 174,
  sym_let = 175,
  sym_use = 176,
  sym_use_assignments = 177,
  sym_use_assignment = 178,
  sym_assert = 179,
  sym_boolean_negation = 180,
  sym_integer_negation = 181,
  sym__assignment = 182,
  sym_record_update = 183,
  sym_record_update_arguments = 184,
  sym_record_update_argument = 185,
  sym__maybe_tuple_expression = 186,
  sym_tuple_access = 187,
  sym__maybe_record_expression = 188,
  sym_field_access = 189,
  sym__maybe_function_expression = 190,
  sym_arguments = 191,
  sym_argument = 192,
  sym_hole = 193,
  sym_function_call = 194,
  sym__pattern_expression = 195,
  sym__pattern_binary_expression = 196,
  sym__pattern = 197,
  sym_record_pattern = 198,
  sym_record_pattern_arguments = 199,
  sym_record_pattern_argument = 200,
  sym_pattern_spread = 201,
  sym_tuple_pattern = 202,
  sym__pattern_bit_string = 203,
  sym_pattern_bit_string_segment = 204,
  sym_pattern_bit_string_segment_options = 205,
  sym__pattern_bit_string_segment_option = 206,
  sym__pattern_bit_string_named_segment_option = 207,
  sym__pattern_bit_string_segment_option_size = 208,
  sym__pattern_bit_string_segment_argument = 209,
  sym_list_pattern = 210,
  sym_list_pattern_tail = 211,
  sym_type_definition = 212,
  sym_data_constructors = 213,
  sym_data_constructor = 214,
  sym_data_constructor_arguments = 215,
  sym_data_constructor_argument = 216,
  sym_type_alias = 217,
  sym_string = 218,
  sym_escape_sequence = 219,
  sym_integer = 220,
  sym__bit_string_segment_option = 221,
  sym__type = 222,
  sym__type_annotation = 223,
  sym_type_hole = 224,
  sym_tuple_type = 225,
  sym_function_type = 226,
  sym_function_parameter_types = 227,
  sym_type = 228,
  sym_type_arguments = 229,
  sym_type_argument = 230,
  sym_type_var = 231,
  sym_type_name = 232,
  sym_type_parameters = 233,
  sym_type_parameter = 234,
  sym_identifier = 235,
  sym_label = 236,
  sym_discard = 237,
  sym_type_identifier = 238,
  sym_remote_type_identifier = 239,
  sym_constructor_name = 240,
  sym_remote_constructor_name = 241,
  aux_sym_source_file_repeat1 = 242,
  aux_sym_target_group_repeat1 = 243,
  aux_sym__attribute_arguments_repeat1 = 244,
  aux_sym_module_repeat1 = 245,
  aux_sym_unqualified_imports_repeat1 = 246,
  aux_sym_constant_tuple_repeat1 = 247,
  aux_sym__constant_bit_string_repeat1 = 248,
  aux_sym_constant_bit_string_segment_options_repeat1 = 249,
  aux_sym_constant_record_arguments_repeat1 = 250,
  aux_sym_constant_tuple_type_repeat1 = 251,
  aux_sym_constant_type_arguments_repeat1 = 252,
  aux_sym_external_function_parameters_repeat1 = 253,
  aux_sym_function_parameters_repeat1 = 254,
  aux_sym_tuple_repeat1 = 255,
  aux_sym__expression_bit_string_repeat1 = 256,
  aux_sym_expression_bit_string_segment_options_repeat1 = 257,
  aux_sym_anonymous_function_parameters_repeat1 = 258,
  aux_sym_case_clauses_repeat1 = 259,
  aux_sym_case_clause_patterns_repeat1 = 260,
  aux_sym_case_clause_pattern_repeat1 = 261,
  aux_sym_use_assignments_repeat1 = 262,
  aux_sym_record_update_arguments_repeat1 = 263,
  aux_sym_arguments_repeat1 = 264,
  aux_sym_record_pattern_arguments_repeat1 = 265,
  aux_sym__pattern_bit_string_repeat1 = 266,
  aux_sym_pattern_bit_string_segment_options_repeat1 = 267,
  aux_sym_data_constructors_repeat1 = 268,
  aux_sym_data_constructor_arguments_repeat1 = 269,
  aux_sym_string_repeat1 = 270,
  aux_sym_tuple_type_repeat1 = 271,
  aux_sym_type_arguments_repeat1 = 272,
  aux_sym_type_parameters_repeat1 = 273,
  alias_sym_function_body = 274,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_module_comment] = "module_comment",
  [sym_statement_comment] = "statement_comment",
  [sym_comment] = "comment",
  [anon_sym_if] = "if",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_erlang] = "erlang",
  [anon_sym_javascript] = "javascript",
  [anon_sym_AT] = "@",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COLON] = ":",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_as] = "as",
  [anon_sym_SLASH] = "/",
  [anon_sym_type] = "type",
  [anon_sym_const] = "const",
  [anon_sym_EQ] = "=",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_DASH] = "-",
  [anon_sym_size] = "size",
  [anon_sym_fn] = "fn",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_external] = "external",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT_DOT] = "<.",
  [anon_sym_LT_EQ_DOT] = "<=.",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT_DOT] = ">.",
  [anon_sym_GT_EQ_DOT] = ">=.",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_PLUS] = "+",
  [anon_sym_PLUS_DOT] = "+.",
  [anon_sym_DASH_DOT] = "-.",
  [anon_sym_STAR] = "*",
  [anon_sym_STAR_DOT] = "*.",
  [anon_sym_SLASH_DOT] = "/.",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_todo] = "todo",
  [anon_sym_panic] = "panic",
  [anon_sym_echo] = "echo",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_case] = "case",
  [anon_sym_PIPE] = "|",
  [anon_sym_let] = "let",
  [anon_sym_assert] = "assert",
  [anon_sym_use] = "use",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_BANG] = "!",
  [sym_visibility_modifier] = "visibility_modifier",
  [sym_opacity_modifier] = "opacity_modifier",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE2] = "\"",
  [aux_sym_escape_sequence_token1] = "escape_sequence_token1",
  [aux_sym_escape_sequence_token2] = "escape_sequence_token2",
  [sym_float] = "float",
  [sym__hex] = "_hex",
  [sym__decimal] = "_decimal",
  [sym__octal] = "_octal",
  [sym__binary] = "_binary",
  [anon_sym_binary] = "binary",
  [anon_sym_bytes] = "bytes",
  [anon_sym_int] = "int",
  [anon_sym_float] = "float",
  [anon_sym_bit_string] = "bit_string",
  [anon_sym_bits] = "bits",
  [anon_sym_utf8] = "utf8",
  [anon_sym_utf16] = "utf16",
  [anon_sym_utf32] = "utf32",
  [anon_sym_utf8_codepoint] = "utf8_codepoint",
  [anon_sym_utf16_codepoint] = "utf16_codepoint",
  [anon_sym_utf32_codepoint] = "utf32_codepoint",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_big] = "big",
  [anon_sym_little] = "little",
  [anon_sym_native] = "native",
  [anon_sym_unit] = "unit",
  [sym__discard_name] = "_discard_name",
  [sym__name] = "_name",
  [sym__upname] = "_upname",
  [sym_quoted_content] = "quoted_content",
  [sym_source_file] = "source_file",
  [sym__module_statement] = "_module_statement",
  [sym_target_group] = "target_group",
  [sym_target] = "target",
  [sym_attribute] = "attribute",
  [sym__attribute_arguments] = "arguments",
  [sym_attribute_value] = "attribute_value",
  [sym_import] = "import",
  [sym_module] = "module",
  [sym_unqualified_imports] = "unqualified_imports",
  [sym_unqualified_import] = "unqualified_import",
  [sym_constant] = "constant",
  [sym__constant_value] = "_constant_value",
  [sym_constant_tuple] = "tuple",
  [sym_constant_list] = "list",
  [sym__constant_bit_string] = "bit_string",
  [sym_constant_bit_string_segment] = "bit_string_segment",
  [sym_constant_bit_string_segment_options] = "bit_string_segment_options",
  [sym__constant_bit_string_segment_option] = "_constant_bit_string_segment_option",
  [sym__constant_bit_string_named_segment_option] = "_constant_bit_string_named_segment_option",
  [sym__constant_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_constant_record] = "record",
  [sym_constant_record_arguments] = "arguments",
  [sym_constant_record_argument] = "argument",
  [sym_constant_field_access] = "field_access",
  [sym__constant_type] = "_constant_type",
  [sym__constant_type_annotation] = "_constant_type_annotation",
  [sym_constant_tuple_type] = "tuple_type",
  [sym_constant_function_type] = "function_type",
  [sym_constant_function_parameter_types] = "function_parameter_types",
  [sym_constant_type] = "type",
  [sym_constant_type_arguments] = "type_arguments",
  [sym_constant_type_argument] = "type_argument",
  [sym_external_type] = "external_type",
  [sym_external_function] = "external_function",
  [sym_external_function_parameters] = "function_parameters",
  [sym_external_function_parameter] = "function_parameter",
  [sym_external_function_body] = "external_function_body",
  [sym_function] = "function",
  [sym_function_parameters] = "function_parameters",
  [sym_function_parameter] = "function_parameter",
  [sym__labeled_discard_param] = "_labeled_discard_param",
  [sym__discard_param] = "_discard_param",
  [sym__labeled_name_param] = "_labeled_name_param",
  [sym__name_param] = "_name_param",
  [aux_sym__statement_seq] = "_statement_seq",
  [sym__statement] = "_statement",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__expression_unit] = "_expression_unit",
  [sym_record] = "record",
  [sym_todo] = "todo",
  [sym_panic] = "panic",
  [sym_pipeline_echo] = "pipeline_echo",
  [sym_echo] = "echo",
  [sym_tuple] = "tuple",
  [sym_list] = "list",
  [sym__expression_bit_string] = "bit_string",
  [sym_expression_bit_string_segment] = "bit_string_segment",
  [sym_expression_bit_string_segment_options] = "bit_string_segment_options",
  [sym__expression_bit_string_segment_option] = "_expression_bit_string_segment_option",
  [sym__expression_bit_string_named_segment_option] = "_expression_bit_string_named_segment_option",
  [sym__expression_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_anonymous_function] = "anonymous_function",
  [sym_anonymous_function_parameters] = "function_parameters",
  [sym_anonymous_function_parameter] = "function_parameter",
  [sym_block] = "block",
  [sym_case] = "case",
  [sym_case_subjects] = "case_subjects",
  [sym_case_clauses] = "case_clauses",
  [sym_case_clause] = "case_clause",
  [sym_case_clause_patterns] = "case_clause_patterns",
  [sym_case_clause_pattern] = "case_clause_pattern",
  [sym_case_clause_guard] = "case_clause_guard",
  [sym__case_clause_guard_expression] = "_case_clause_guard_expression",
  [sym__case_clause_guard_binary_expression] = "binary_expression",
  [sym__case_clause_guard_unit] = "_case_clause_guard_unit",
  [sym__case_clause_tuple_access] = "tuple_access",
  [sym_let_assert] = "let_assert",
  [sym_let] = "let",
  [sym_use] = "use",
  [sym_use_assignments] = "use_assignments",
  [sym_use_assignment] = "use_assignment",
  [sym_assert] = "assert",
  [sym_boolean_negation] = "boolean_negation",
  [sym_integer_negation] = "integer_negation",
  [sym__assignment] = "_assignment",
  [sym_record_update] = "record_update",
  [sym_record_update_arguments] = "record_update_arguments",
  [sym_record_update_argument] = "record_update_argument",
  [sym__maybe_tuple_expression] = "_maybe_tuple_expression",
  [sym_tuple_access] = "tuple_access",
  [sym__maybe_record_expression] = "_maybe_record_expression",
  [sym_field_access] = "field_access",
  [sym__maybe_function_expression] = "_maybe_function_expression",
  [sym_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym_hole] = "hole",
  [sym_function_call] = "function_call",
  [sym__pattern_expression] = "_pattern_expression",
  [sym__pattern_binary_expression] = "binary_expression",
  [sym__pattern] = "_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_record_pattern_arguments] = "record_pattern_arguments",
  [sym_record_pattern_argument] = "record_pattern_argument",
  [sym_pattern_spread] = "pattern_spread",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym__pattern_bit_string] = "bit_string_pattern",
  [sym_pattern_bit_string_segment] = "bit_string_segment",
  [sym_pattern_bit_string_segment_options] = "bit_string_segment_options",
  [sym__pattern_bit_string_segment_option] = "_pattern_bit_string_segment_option",
  [sym__pattern_bit_string_named_segment_option] = "_pattern_bit_string_named_segment_option",
  [sym__pattern_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym__pattern_bit_string_segment_argument] = "_pattern_bit_string_segment_argument",
  [sym_list_pattern] = "list_pattern",
  [sym_list_pattern_tail] = "list_pattern_tail",
  [sym_type_definition] = "type_definition",
  [sym_data_constructors] = "data_constructors",
  [sym_data_constructor] = "data_constructor",
  [sym_data_constructor_arguments] = "data_constructor_arguments",
  [sym_data_constructor_argument] = "data_constructor_argument",
  [sym_type_alias] = "type_alias",
  [sym_string] = "string",
  [sym_escape_sequence] = "escape_sequence",
  [sym_integer] = "integer",
  [sym__bit_string_segment_option] = "bit_string_segment_option",
  [sym__type] = "_type",
  [sym__type_annotation] = "_type_annotation",
  [sym_type_hole] = "type_hole",
  [sym_tuple_type] = "tuple_type",
  [sym_function_type] = "function_type",
  [sym_function_parameter_types] = "function_parameter_types",
  [sym_type] = "type",
  [sym_type_arguments] = "type_arguments",
  [sym_type_argument] = "type_argument",
  [sym_type_var] = "type_var",
  [sym_type_name] = "type_name",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_identifier] = "identifier",
  [sym_label] = "label",
  [sym_discard] = "discard",
  [sym_type_identifier] = "type_identifier",
  [sym_remote_type_identifier] = "remote_type_identifier",
  [sym_constructor_name] = "constructor_name",
  [sym_remote_constructor_name] = "remote_constructor_name",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_target_group_repeat1] = "target_group_repeat1",
  [aux_sym__attribute_arguments_repeat1] = "_attribute_arguments_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_unqualified_imports_repeat1] = "unqualified_imports_repeat1",
  [aux_sym_constant_tuple_repeat1] = "constant_tuple_repeat1",
  [aux_sym__constant_bit_string_repeat1] = "_constant_bit_string_repeat1",
  [aux_sym_constant_bit_string_segment_options_repeat1] = "constant_bit_string_segment_options_repeat1",
  [aux_sym_constant_record_arguments_repeat1] = "constant_record_arguments_repeat1",
  [aux_sym_constant_tuple_type_repeat1] = "constant_tuple_type_repeat1",
  [aux_sym_constant_type_arguments_repeat1] = "constant_type_arguments_repeat1",
  [aux_sym_external_function_parameters_repeat1] = "external_function_parameters_repeat1",
  [aux_sym_function_parameters_repeat1] = "function_parameters_repeat1",
  [aux_sym_tuple_repeat1] = "tuple_repeat1",
  [aux_sym__expression_bit_string_repeat1] = "_expression_bit_string_repeat1",
  [aux_sym_expression_bit_string_segment_options_repeat1] = "expression_bit_string_segment_options_repeat1",
  [aux_sym_anonymous_function_parameters_repeat1] = "anonymous_function_parameters_repeat1",
  [aux_sym_case_clauses_repeat1] = "case_clauses_repeat1",
  [aux_sym_case_clause_patterns_repeat1] = "case_clause_patterns_repeat1",
  [aux_sym_case_clause_pattern_repeat1] = "case_clause_pattern_repeat1",
  [aux_sym_use_assignments_repeat1] = "use_assignments_repeat1",
  [aux_sym_record_update_arguments_repeat1] = "record_update_arguments_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_record_pattern_arguments_repeat1] = "record_pattern_arguments_repeat1",
  [aux_sym__pattern_bit_string_repeat1] = "_pattern_bit_string_repeat1",
  [aux_sym_pattern_bit_string_segment_options_repeat1] = "pattern_bit_string_segment_options_repeat1",
  [aux_sym_data_constructors_repeat1] = "data_constructors_repeat1",
  [aux_sym_data_constructor_arguments_repeat1] = "data_constructor_arguments_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [alias_sym_function_body] = "function_body",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_module_comment] = sym_module_comment,
  [sym_statement_comment] = sym_statement_comment,
  [sym_comment] = sym_comment,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_erlang] = anon_sym_erlang,
  [anon_sym_javascript] = anon_sym_javascript,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_size] = anon_sym_size,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT_DOT] = anon_sym_LT_DOT,
  [anon_sym_LT_EQ_DOT] = anon_sym_LT_EQ_DOT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT_DOT] = anon_sym_GT_DOT,
  [anon_sym_GT_EQ_DOT] = anon_sym_GT_EQ_DOT,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PLUS_DOT] = anon_sym_PLUS_DOT,
  [anon_sym_DASH_DOT] = anon_sym_DASH_DOT,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_STAR_DOT] = anon_sym_STAR_DOT,
  [anon_sym_SLASH_DOT] = anon_sym_SLASH_DOT,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_todo] = anon_sym_todo,
  [anon_sym_panic] = anon_sym_panic,
  [anon_sym_echo] = anon_sym_echo,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [sym_visibility_modifier] = sym_visibility_modifier,
  [sym_opacity_modifier] = sym_opacity_modifier,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [aux_sym_escape_sequence_token1] = aux_sym_escape_sequence_token1,
  [aux_sym_escape_sequence_token2] = aux_sym_escape_sequence_token2,
  [sym_float] = sym_float,
  [sym__hex] = sym__hex,
  [sym__decimal] = sym__decimal,
  [sym__octal] = sym__octal,
  [sym__binary] = sym__binary,
  [anon_sym_binary] = anon_sym_binary,
  [anon_sym_bytes] = anon_sym_bytes,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_bit_string] = anon_sym_bit_string,
  [anon_sym_bits] = anon_sym_bits,
  [anon_sym_utf8] = anon_sym_utf8,
  [anon_sym_utf16] = anon_sym_utf16,
  [anon_sym_utf32] = anon_sym_utf32,
  [anon_sym_utf8_codepoint] = anon_sym_utf8_codepoint,
  [anon_sym_utf16_codepoint] = anon_sym_utf16_codepoint,
  [anon_sym_utf32_codepoint] = anon_sym_utf32_codepoint,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_big] = anon_sym_big,
  [anon_sym_little] = anon_sym_little,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_unit] = anon_sym_unit,
  [sym__discard_name] = sym__discard_name,
  [sym__name] = sym__name,
  [sym__upname] = sym__upname,
  [sym_quoted_content] = sym_quoted_content,
  [sym_source_file] = sym_source_file,
  [sym__module_statement] = sym__module_statement,
  [sym_target_group] = sym_target_group,
  [sym_target] = sym_target,
  [sym_attribute] = sym_attribute,
  [sym__attribute_arguments] = sym_arguments,
  [sym_attribute_value] = sym_attribute_value,
  [sym_import] = sym_import,
  [sym_module] = sym_module,
  [sym_unqualified_imports] = sym_unqualified_imports,
  [sym_unqualified_import] = sym_unqualified_import,
  [sym_constant] = sym_constant,
  [sym__constant_value] = sym__constant_value,
  [sym_constant_tuple] = sym_tuple,
  [sym_constant_list] = sym_list,
  [sym__constant_bit_string] = sym__constant_bit_string,
  [sym_constant_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_constant_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__constant_bit_string_segment_option] = sym__constant_bit_string_segment_option,
  [sym__constant_bit_string_named_segment_option] = sym__constant_bit_string_named_segment_option,
  [sym__constant_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_constant_record] = sym_record,
  [sym_constant_record_arguments] = sym_arguments,
  [sym_constant_record_argument] = sym_argument,
  [sym_constant_field_access] = sym_field_access,
  [sym__constant_type] = sym__constant_type,
  [sym__constant_type_annotation] = sym__constant_type_annotation,
  [sym_constant_tuple_type] = sym_tuple_type,
  [sym_constant_function_type] = sym_function_type,
  [sym_constant_function_parameter_types] = sym_function_parameter_types,
  [sym_constant_type] = sym_type,
  [sym_constant_type_arguments] = sym_type_arguments,
  [sym_constant_type_argument] = sym_type_argument,
  [sym_external_type] = sym_external_type,
  [sym_external_function] = sym_external_function,
  [sym_external_function_parameters] = sym_function_parameters,
  [sym_external_function_parameter] = sym_function_parameter,
  [sym_external_function_body] = sym_external_function_body,
  [sym_function] = sym_function,
  [sym_function_parameters] = sym_function_parameters,
  [sym_function_parameter] = sym_function_parameter,
  [sym__labeled_discard_param] = sym__labeled_discard_param,
  [sym__discard_param] = sym__discard_param,
  [sym__labeled_name_param] = sym__labeled_name_param,
  [sym__name_param] = sym__name_param,
  [aux_sym__statement_seq] = aux_sym__statement_seq,
  [sym__statement] = sym__statement,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__expression_unit] = sym__expression_unit,
  [sym_record] = sym_record,
  [sym_todo] = sym_todo,
  [sym_panic] = sym_panic,
  [sym_pipeline_echo] = sym_pipeline_echo,
  [sym_echo] = sym_echo,
  [sym_tuple] = sym_tuple,
  [sym_list] = sym_list,
  [sym__expression_bit_string] = sym__constant_bit_string,
  [sym_expression_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_expression_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__expression_bit_string_segment_option] = sym__expression_bit_string_segment_option,
  [sym__expression_bit_string_named_segment_option] = sym__expression_bit_string_named_segment_option,
  [sym__expression_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_anonymous_function] = sym_anonymous_function,
  [sym_anonymous_function_parameters] = sym_function_parameters,
  [sym_anonymous_function_parameter] = sym_function_parameter,
  [sym_block] = sym_block,
  [sym_case] = sym_case,
  [sym_case_subjects] = sym_case_subjects,
  [sym_case_clauses] = sym_case_clauses,
  [sym_case_clause] = sym_case_clause,
  [sym_case_clause_patterns] = sym_case_clause_patterns,
  [sym_case_clause_pattern] = sym_case_clause_pattern,
  [sym_case_clause_guard] = sym_case_clause_guard,
  [sym__case_clause_guard_expression] = sym__case_clause_guard_expression,
  [sym__case_clause_guard_binary_expression] = sym_binary_expression,
  [sym__case_clause_guard_unit] = sym__case_clause_guard_unit,
  [sym__case_clause_tuple_access] = sym_tuple_access,
  [sym_let_assert] = sym_let_assert,
  [sym_let] = sym_let,
  [sym_use] = sym_use,
  [sym_use_assignments] = sym_use_assignments,
  [sym_use_assignment] = sym_use_assignment,
  [sym_assert] = sym_assert,
  [sym_boolean_negation] = sym_boolean_negation,
  [sym_integer_negation] = sym_integer_negation,
  [sym__assignment] = sym__assignment,
  [sym_record_update] = sym_record_update,
  [sym_record_update_arguments] = sym_record_update_arguments,
  [sym_record_update_argument] = sym_record_update_argument,
  [sym__maybe_tuple_expression] = sym__maybe_tuple_expression,
  [sym_tuple_access] = sym_tuple_access,
  [sym__maybe_record_expression] = sym__maybe_record_expression,
  [sym_field_access] = sym_field_access,
  [sym__maybe_function_expression] = sym__maybe_function_expression,
  [sym_arguments] = sym_arguments,
  [sym_argument] = sym_argument,
  [sym_hole] = sym_hole,
  [sym_function_call] = sym_function_call,
  [sym__pattern_expression] = sym__pattern_expression,
  [sym__pattern_binary_expression] = sym_binary_expression,
  [sym__pattern] = sym__pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_record_pattern_arguments] = sym_record_pattern_arguments,
  [sym_record_pattern_argument] = sym_record_pattern_argument,
  [sym_pattern_spread] = sym_pattern_spread,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym__pattern_bit_string] = sym__pattern_bit_string,
  [sym_pattern_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_pattern_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__pattern_bit_string_segment_option] = sym__pattern_bit_string_segment_option,
  [sym__pattern_bit_string_named_segment_option] = sym__pattern_bit_string_named_segment_option,
  [sym__pattern_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym__pattern_bit_string_segment_argument] = sym__pattern_bit_string_segment_argument,
  [sym_list_pattern] = sym_list_pattern,
  [sym_list_pattern_tail] = sym_list_pattern_tail,
  [sym_type_definition] = sym_type_definition,
  [sym_data_constructors] = sym_data_constructors,
  [sym_data_constructor] = sym_data_constructor,
  [sym_data_constructor_arguments] = sym_data_constructor_arguments,
  [sym_data_constructor_argument] = sym_data_constructor_argument,
  [sym_type_alias] = sym_type_alias,
  [sym_string] = sym_string,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_integer] = sym_integer,
  [sym__bit_string_segment_option] = sym__constant_bit_string_segment_option_size,
  [sym__type] = sym__type,
  [sym__type_annotation] = sym__type_annotation,
  [sym_type_hole] = sym_type_hole,
  [sym_tuple_type] = sym_tuple_type,
  [sym_function_type] = sym_function_type,
  [sym_function_parameter_types] = sym_function_parameter_types,
  [sym_type] = sym_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_type_argument] = sym_type_argument,
  [sym_type_var] = sym_type_var,
  [sym_type_name] = sym_type_name,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_identifier] = sym_identifier,
  [sym_label] = sym_label,
  [sym_discard] = sym_discard,
  [sym_type_identifier] = sym_type_identifier,
  [sym_remote_type_identifier] = sym_remote_type_identifier,
  [sym_constructor_name] = sym_constructor_name,
  [sym_remote_constructor_name] = sym_remote_constructor_name,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_target_group_repeat1] = aux_sym_target_group_repeat1,
  [aux_sym__attribute_arguments_repeat1] = aux_sym__attribute_arguments_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_unqualified_imports_repeat1] = aux_sym_unqualified_imports_repeat1,
  [aux_sym_constant_tuple_repeat1] = aux_sym_constant_tuple_repeat1,
  [aux_sym__constant_bit_string_repeat1] = aux_sym__constant_bit_string_repeat1,
  [aux_sym_constant_bit_string_segment_options_repeat1] = aux_sym_constant_bit_string_segment_options_repeat1,
  [aux_sym_constant_record_arguments_repeat1] = aux_sym_constant_record_arguments_repeat1,
  [aux_sym_constant_tuple_type_repeat1] = aux_sym_constant_tuple_type_repeat1,
  [aux_sym_constant_type_arguments_repeat1] = aux_sym_constant_type_arguments_repeat1,
  [aux_sym_external_function_parameters_repeat1] = aux_sym_external_function_parameters_repeat1,
  [aux_sym_function_parameters_repeat1] = aux_sym_function_parameters_repeat1,
  [aux_sym_tuple_repeat1] = aux_sym_tuple_repeat1,
  [aux_sym__expression_bit_string_repeat1] = aux_sym__expression_bit_string_repeat1,
  [aux_sym_expression_bit_string_segment_options_repeat1] = aux_sym_expression_bit_string_segment_options_repeat1,
  [aux_sym_anonymous_function_parameters_repeat1] = aux_sym_anonymous_function_parameters_repeat1,
  [aux_sym_case_clauses_repeat1] = aux_sym_case_clauses_repeat1,
  [aux_sym_case_clause_patterns_repeat1] = aux_sym_case_clause_patterns_repeat1,
  [aux_sym_case_clause_pattern_repeat1] = aux_sym_case_clause_pattern_repeat1,
  [aux_sym_use_assignments_repeat1] = aux_sym_use_assignments_repeat1,
  [aux_sym_record_update_arguments_repeat1] = aux_sym_record_update_arguments_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_record_pattern_arguments_repeat1] = aux_sym_record_pattern_arguments_repeat1,
  [aux_sym__pattern_bit_string_repeat1] = aux_sym__pattern_bit_string_repeat1,
  [aux_sym_pattern_bit_string_segment_options_repeat1] = aux_sym_pattern_bit_string_segment_options_repeat1,
  [aux_sym_data_constructors_repeat1] = aux_sym_data_constructors_repeat1,
  [aux_sym_data_constructor_arguments_repeat1] = aux_sym_data_constructor_arguments_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [alias_sym_function_body] = alias_sym_function_body,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_module_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_erlang] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_javascript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_size] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_todo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_panic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_echo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [sym_visibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_opacity_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_escape_sequence_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym__hex] = {
    .visible = false,
    .named = true,
  },
  [sym__decimal] = {
    .visible = false,
    .named = true,
  },
  [sym__octal] = {
    .visible = false,
    .named = true,
  },
  [sym__binary] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_binary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bit_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_big] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_little] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unit] = {
    .visible = true,
    .named = false,
  },
  [sym__discard_name] = {
    .visible = false,
    .named = true,
  },
  [sym__name] = {
    .visible = false,
    .named = true,
  },
  [sym__upname] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_content] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__module_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_target_group] = {
    .visible = true,
    .named = true,
  },
  [sym_target] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_import] = {
    .visible = true,
    .named = true,
  },
  [sym_constant] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_value] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_list] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_type] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_function_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_external_type] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__labeled_discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__labeled_name_param] = {
    .visible = false,
    .named = true,
  },
  [sym__name_param] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__statement_seq] = {
    .visible = false,
    .named = false,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_unit] = {
    .visible = false,
    .named = true,
  },
  [sym_record] = {
    .visible = true,
    .named = true,
  },
  [sym_todo] = {
    .visible = true,
    .named = true,
  },
  [sym_panic] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline_echo] = {
    .visible = true,
    .named = true,
  },
  [sym_echo] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_subjects] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clauses] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_patterns] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_guard] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_guard_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_unit] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym_let_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_use] = {
    .visible = true,
    .named = true,
  },
  [sym_use_assignments] = {
    .visible = true,
    .named = true,
  },
  [sym_use_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_negation] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_negation] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_record_update] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_tuple_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_record_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_function_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_spread] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern_tail] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructors] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym__bit_string_segment_option] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_type_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_var] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_discard] = {
    .visible = true,
    .named = true,
  },
  [sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_name] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_constructor_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_target_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unqualified_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__constant_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_record_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_external_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anonymous_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_assignments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_update_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pattern_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructor_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_function_body] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_arguments = 2,
  field_assign = 3,
  field_assignments = 4,
  field_body = 5,
  field_clauses = 6,
  field_constructor = 7,
  field_field = 8,
  field_function = 9,
  field_guard = 10,
  field_imports = 11,
  field_index = 12,
  field_label = 13,
  field_left = 14,
  field_message = 15,
  field_module = 16,
  field_name = 17,
  field_operator = 18,
  field_options = 19,
  field_parameter_types = 20,
  field_parameters = 21,
  field_pattern = 22,
  field_patterns = 23,
  field_record = 24,
  field_return_type = 25,
  field_right = 26,
  field_spread = 27,
  field_subjects = 28,
  field_target = 29,
  field_tuple = 30,
  field_type = 31,
  field_value = 32,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_arguments] = "arguments",
  [field_assign] = "assign",
  [field_assignments] = "assignments",
  [field_body] = "body",
  [field_clauses] = "clauses",
  [field_constructor] = "constructor",
  [field_field] = "field",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_imports] = "imports",
  [field_index] = "index",
  [field_label] = "label",
  [field_left] = "left",
  [field_message] = "message",
  [field_module] = "module",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_options] = "options",
  [field_parameter_types] = "parameter_types",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_patterns] = "patterns",
  [field_record] = "record",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_spread] = "spread",
  [field_subjects] = "subjects",
  [field_target] = "target",
  [field_tuple] = "tuple",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 4},
  [6] = {.index = 8, .length = 3},
  [7] = {.index = 11, .length = 1},
  [8] = {.index = 12, .length = 2},
  [9] = {.index = 14, .length = 2},
  [10] = {.index = 16, .length = 2},
  [11] = {.index = 18, .length = 2},
  [12] = {.index = 20, .length = 1},
  [13] = {.index = 21, .length = 2},
  [14] = {.index = 23, .length = 1},
  [15] = {.index = 24, .length = 2},
  [16] = {.index = 26, .length = 4},
  [17] = {.index = 30, .length = 1},
  [18] = {.index = 31, .length = 2},
  [19] = {.index = 33, .length = 3},
  [20] = {.index = 36, .length = 2},
  [21] = {.index = 38, .length = 2},
  [22] = {.index = 40, .length = 2},
  [23] = {.index = 42, .length = 1},
  [24] = {.index = 43, .length = 2},
  [25] = {.index = 45, .length = 2},
  [26] = {.index = 47, .length = 1},
  [27] = {.index = 48, .length = 2},
  [28] = {.index = 50, .length = 3},
  [29] = {.index = 53, .length = 2},
  [30] = {.index = 55, .length = 2},
  [31] = {.index = 57, .length = 1},
  [32] = {.index = 58, .length = 1},
  [33] = {.index = 59, .length = 2},
  [34] = {.index = 61, .length = 3},
  [35] = {.index = 64, .length = 2},
  [36] = {.index = 66, .length = 2},
  [37] = {.index = 68, .length = 2},
  [38] = {.index = 70, .length = 1},
  [39] = {.index = 71, .length = 3},
  [40] = {.index = 74, .length = 1},
  [41] = {.index = 75, .length = 2},
  [42] = {.index = 77, .length = 3},
  [43] = {.index = 80, .length = 2},
  [44] = {.index = 82, .length = 3},
  [45] = {.index = 85, .length = 1},
  [46] = {.index = 86, .length = 2},
  [47] = {.index = 88, .length = 2},
  [48] = {.index = 90, .length = 1},
  [49] = {.index = 91, .length = 2},
  [50] = {.index = 93, .length = 4},
  [51] = {.index = 97, .length = 5},
  [52] = {.index = 102, .length = 4},
  [53] = {.index = 106, .length = 2},
  [54] = {.index = 108, .length = 2},
  [55] = {.index = 110, .length = 3},
  [56] = {.index = 113, .length = 1},
  [57] = {.index = 114, .length = 1},
  [58] = {.index = 115, .length = 3},
  [59] = {.index = 118, .length = 2},
  [60] = {.index = 120, .length = 2},
  [61] = {.index = 122, .length = 2},
  [62] = {.index = 124, .length = 3},
  [63] = {.index = 127, .length = 3},
  [64] = {.index = 130, .length = 3},
  [65] = {.index = 133, .length = 2},
  [66] = {.index = 135, .length = 2},
  [67] = {.index = 137, .length = 1},
  [68] = {.index = 138, .length = 3},
  [69] = {.index = 141, .length = 2},
  [70] = {.index = 143, .length = 3},
  [71] = {.index = 146, .length = 3},
  [72] = {.index = 149, .length = 3},
  [73] = {.index = 152, .length = 2},
  [74] = {.index = 154, .length = 4},
  [75] = {.index = 158, .length = 4},
  [76] = {.index = 158, .length = 4},
  [77] = {.index = 162, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_name, 1},
  [2] =
    {field_module, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [8] =
    {field_left, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
    {field_right, 0, .inherited = true},
  [11] =
    {field_assign, 0, .inherited = true},
  [12] =
    {field_arguments, 1},
    {field_function, 0},
  [14] =
    {field_arguments, 1},
    {field_name, 0},
  [16] =
    {field_arguments, 2},
    {field_name, 1},
  [18] =
    {field_name, 0},
    {field_parameters, 1},
  [20] =
    {field_name, 0, .inherited = true},
  [21] =
    {field_name, 1},
    {field_parameters, 2},
  [23] =
    {field_message, 2},
  [24] =
    {field_assign, 0, .inherited = true},
    {field_value, 0},
  [26] =
    {field_assign, 2, .inherited = true},
    {field_pattern, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [30] =
    {field_value, 2},
  [31] =
    {field_assign, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [33] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [36] =
    {field_index, 2},
    {field_tuple, 0},
  [38] =
    {field_field, 2},
    {field_record, 0},
  [40] =
    {field_module, 0},
    {field_name, 2},
  [42] =
    {field_target, 1},
  [43] =
    {field_imports, 3},
    {field_module, 1},
  [45] =
    {field_alias, 3},
    {field_module, 1},
  [47] =
    {field_type, 1},
  [48] =
    {field_name, 1},
    {field_value, 3},
  [50] =
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [53] =
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [55] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [57] =
    {field_subjects, 1},
  [58] =
    {field_assign, 1, .inherited = true},
  [59] =
    {field_assign, 1},
    {field_assign, 2},
  [61] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_value, 2},
  [64] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
  [66] =
    {field_assignments, 1},
    {field_value, 3},
  [68] =
    {field_name, 2},
    {field_parameters, 3},
  [70] =
    {field_label, 0},
  [71] =
    {field_name, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [74] =
    {field_spread, 3},
  [75] =
    {field_body, 3},
    {field_parameters, 1},
  [77] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [80] =
    {field_label, 0},
    {field_name, 1},
  [82] =
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [85] =
    {field_type, 0},
  [86] =
    {field_clauses, 3},
    {field_subjects, 1},
  [88] =
    {field_assign, 0, .inherited = true},
    {field_assign, 1, .inherited = true},
  [90] =
    {field_assign, 2, .inherited = true},
  [91] =
    {field_assign, 1, .inherited = true},
    {field_assign, 2, .inherited = true},
  [93] =
    {field_assign, 0, .inherited = true},
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [97] =
    {field_assign, 2, .inherited = true},
    {field_message, 4},
    {field_pattern, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [102] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_type, 1, .inherited = true},
    {field_value, 3},
  [106] =
    {field_name, 2},
    {field_value, 4},
  [108] =
    {field_label, 0},
    {field_value, 2},
  [110] =
    {field_alias, 5},
    {field_imports, 3},
    {field_module, 1},
  [113] =
    {field_return_type, 2},
  [114] =
    {field_spread, 4},
  [115] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [118] =
    {field_index, 0, .inherited = true},
    {field_tuple, 0, .inherited = true},
  [120] =
    {field_patterns, 0},
    {field_value, 2},
  [122] =
    {field_assign, 2, .inherited = true},
    {field_assign, 3, .inherited = true},
  [124] =
    {field_assign, 2, .inherited = true},
    {field_label, 0},
    {field_pattern, 2},
  [127] =
    {field_name, 2},
    {field_type, 3, .inherited = true},
    {field_value, 5},
  [130] =
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [133] =
    {field_alias, 2},
    {field_name, 0},
  [135] =
    {field_parameter_types, 1},
    {field_return_type, 3},
  [137] =
    {field_spread, 5},
  [138] =
    {field_body, 5},
    {field_parameters, 1},
    {field_return_type, 3},
  [141] =
    {field_name, 0},
    {field_type, 2},
  [143] =
    {field_guard, 1},
    {field_patterns, 0},
    {field_value, 3},
  [146] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [149] =
    {field_arguments, 5},
    {field_constructor, 0},
    {field_spread, 3},
  [152] =
    {field_alias, 3},
    {field_name, 1},
  [154] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [158] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [162] =
    {field_body, 8},
    {field_name, 3},
    {field_parameters, 4},
    {field_return_type, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [41] = {
    [3] = alias_sym_function_body,
  },
  [58] = {
    [4] = alias_sym_function_body,
  },
  [68] = {
    [5] = alias_sym_function_body,
  },
  [71] = {
    [5] = alias_sym_function_body,
  },
  [74] = {
    [6] = alias_sym_function_body,
  },
  [76] = {
    [7] = alias_sym_function_body,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__statement_seq, 2,
    aux_sym__statement_seq,
    alias_sym_function_body,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(170)
      if (lookahead == '\r') SKIP(170)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(268);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(207);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '\\') ADVANCE(127);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(430);
      if (lookahead == 'b') ADVANCE(377);
      if (lookahead == 'c') ADVANCE(325);
      if (lookahead == 'e') ADVANCE(336);
      if (lookahead == 'f') ADVANCE(388);
      if (lookahead == 'i') ADVANCE(367);
      if (lookahead == 'j') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(359);
      if (lookahead == 'n') ADVANCE(333);
      if (lookahead == 'o') ADVANCE(416);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 's') ADVANCE(378);
      if (lookahead == 't') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(393);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(256);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 1:
      if (lookahead == '&') ADVANCE(228);
      END_STATE();
    case 2:
      if (lookahead == '-') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      END_STATE();
    case 3:
      if (lookahead == '-') ADVANCE(260);
      if (lookahead == '<') ADVANCE(211);
      END_STATE();
    case 4:
      if (lookahead == '-') ADVANCE(260);
      if (lookahead == '>') ADVANCE(249);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(253);
      END_STATE();
    case 6:
      if (lookahead == '.') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '/') ADVANCE(179);
      END_STATE();
    case 8:
      if (lookahead == '1') ADVANCE(10);
      if (lookahead == '3') ADVANCE(9);
      if (lookahead == '8') ADVANCE(292);
      END_STATE();
    case 9:
      if (lookahead == '2') ADVANCE(296);
      END_STATE();
    case 10:
      if (lookahead == '6') ADVANCE(294);
      END_STATE();
    case 11:
      if (lookahead == '<') ADVANCE(211);
      END_STATE();
    case 12:
      if (lookahead == '=') ADVANCE(230);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(229);
      END_STATE();
    case 14:
      if (lookahead == '>') ADVANCE(224);
      END_STATE();
    case 15:
      if (lookahead == '>') ADVANCE(212);
      END_STATE();
    case 16:
      if (lookahead == '>') ADVANCE(241);
      if (lookahead == '|') ADVANCE(227);
      END_STATE();
    case 17:
      if (lookahead == '_') ADVANCE(111);
      if (lookahead == 's') ADVANCE(290);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(109);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(124);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 26:
      if (lookahead == 'b') ADVANCE(263);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(86);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 29:
      if (lookahead == 'c') ADVANCE(91);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(92);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(304);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(306);
      END_STATE();
    case 33:
      if (lookahead == 'd') ADVANCE(45);
      END_STATE();
    case 34:
      if (lookahead == 'd') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 'd') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(220);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(312);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(265);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(103);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 48:
      if (lookahead == 'f') ADVANCE(8);
      END_STATE();
    case 49:
      if (lookahead == 'f') ADVANCE(181);
      END_STATE();
    case 50:
      if (lookahead == 'f') ADVANCE(181);
      if (lookahead == 'm') ADVANCE(93);
      END_STATE();
    case 51:
      if (lookahead == 'g') ADVANCE(308);
      if (lookahead == 'n') ADVANCE(20);
      if (lookahead == 't') ADVANCE(17);
      END_STATE();
    case 52:
      if (lookahead == 'g') ADVANCE(185);
      END_STATE();
    case 53:
      if (lookahead == 'g') ADVANCE(288);
      END_STATE();
    case 54:
      if (lookahead == 'g') ADVANCE(78);
      if (lookahead == 'z') ADVANCE(36);
      END_STATE();
    case 55:
      if (lookahead == 'g') ADVANCE(80);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(51);
      if (lookahead == 'y') ADVANCE(112);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(114);
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(81);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(82);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(83);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(225);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(87);
      if (lookahead == 'n') ADVANCE(222);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(21);
      END_STATE();
    case 70:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 71:
      if (lookahead == 'm') ADVANCE(93);
      END_STATE();
    case 72:
      if (lookahead == 'm') ADVANCE(93);
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(222);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(63);
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(110);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(52);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(38);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 80:
      if (lookahead == 'n') ADVANCE(43);
      END_STATE();
    case 81:
      if (lookahead == 'n') ADVANCE(119);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(120);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(121);
      END_STATE();
    case 84:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 85:
      if (lookahead == 'o') ADVANCE(106);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 89:
      if (lookahead == 'o') ADVANCE(65);
      END_STATE();
    case 90:
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 92:
      if (lookahead == 'o') ADVANCE(35);
      END_STATE();
    case 93:
      if (lookahead == 'p') ADVANCE(85);
      END_STATE();
    case 94:
      if (lookahead == 'p') ADVANCE(19);
      END_STATE();
    case 95:
      if (lookahead == 'p') ADVANCE(37);
      END_STATE();
    case 96:
      if (lookahead == 'p') ADVANCE(88);
      END_STATE();
    case 97:
      if (lookahead == 'p') ADVANCE(118);
      END_STATE();
    case 98:
      if (lookahead == 'p') ADVANCE(89);
      END_STATE();
    case 99:
      if (lookahead == 'p') ADVANCE(90);
      END_STATE();
    case 100:
      if (lookahead == 'q') ADVANCE(129);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(69);
      if (lookahead == 'x') ADVANCE(123);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 103:
      if (lookahead == 'r') ADVANCE(79);
      END_STATE();
    case 104:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 105:
      if (lookahead == 'r') ADVANCE(61);
      END_STATE();
    case 106:
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 107:
      if (lookahead == 's') ADVANCE(198);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(282);
      END_STATE();
    case 109:
      if (lookahead == 's') ADVANCE(28);
      END_STATE();
    case 110:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 111:
      if (lookahead == 's') ADVANCE(125);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(284);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(314);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(204);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(286);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 119:
      if (lookahead == 't') ADVANCE(298);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(302);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(104);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 127:
      if (lookahead == 'u') ADVANCE(135);
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'e' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(269);
      END_STATE();
    case 128:
      if (lookahead == 'u') ADVANCE(26);
      END_STATE();
    case 129:
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 130:
      if (lookahead == 'v') ADVANCE(23);
      END_STATE();
    case 131:
      if (lookahead == 'v') ADVANCE(40);
      END_STATE();
    case 132:
      if (lookahead == 'x') ADVANCE(123);
      END_STATE();
    case 133:
      if (lookahead == 'y') ADVANCE(280);
      END_STATE();
    case 134:
      if (lookahead == 'y') ADVANCE(95);
      END_STATE();
    case 135:
      if (lookahead == '{') ADVANCE(168);
      END_STATE();
    case 136:
      if (lookahead == '}') ADVANCE(270);
      END_STATE();
    case 137:
      if (lookahead == '}') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(136);
      END_STATE();
    case 138:
      if (lookahead == '}') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      END_STATE();
    case 139:
      if (lookahead == '}') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(138);
      END_STATE();
    case 140:
      if (lookahead == '}') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(139);
      END_STATE();
    case 141:
      if (lookahead == '}') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(140);
      END_STATE();
    case 142:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(142)
      if (lookahead == '\r') SKIP(142)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'p') ADVANCE(328);
      if (lookahead == 't') ADVANCE(405);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 143:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(143)
      if (lookahead == '\r') SKIP(143)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(430);
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'p') ADVANCE(328);
      if (lookahead == 't') ADVANCE(405);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 144:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(144)
      if (lookahead == '\r') SKIP(144)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'p') ADVANCE(328);
      if (lookahead == 't') ADVANCE(405);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 145:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(145)
      if (lookahead == '\r') SKIP(145)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'p') ADVANCE(328);
      if (lookahead == 't') ADVANCE(405);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 146:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(146)
      if (lookahead == '\r') SKIP(146)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'p') ADVANCE(328);
      if (lookahead == 't') ADVANCE(405);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 147:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(148)
      if (lookahead == '\r') SKIP(148)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(268);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(214);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(276);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(232);
      if (lookahead == '=') ADVANCE(207);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(127);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'b') ADVANCE(56);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(101);
      if (lookahead == 'f') ADVANCE(68);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'j') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(60);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 's') ADVANCE(57);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == 'u') ADVANCE(74);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(277);
      END_STATE();
    case 148:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(148)
      if (lookahead == '\r') SKIP(148)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(214);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(276);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(232);
      if (lookahead == '=') ADVANCE(207);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'b') ADVANCE(56);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(101);
      if (lookahead == 'f') ADVANCE(68);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'j') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(60);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 's') ADVANCE(57);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == 'u') ADVANCE(74);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(277);
      END_STATE();
    case 149:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(149)
      if (lookahead == '\r') SKIP(149)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(214);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(232);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      END_STATE();
    case 150:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(150)
      if (lookahead == '\r') SKIP(150)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 151:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(151)
      if (lookahead == '\r') SKIP(151)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(433);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 152:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(152)
      if (lookahead == '\r') SKIP(152)
      if (lookahead == '!') ADVANCE(261);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(219);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == '{') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 153:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(153)
      if (lookahead == '\r') SKIP(153)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '<') ADVANCE(232);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'i') ADVANCE(49);
      if (lookahead == '|') ADVANCE(256);
      END_STATE();
    case 154:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(154)
      if (lookahead == '\r') SKIP(154)
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'i') ADVANCE(369);
      if (lookahead == '|') ADVANCE(255);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 155:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(155)
      if (lookahead == '\r') SKIP(155)
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '-') ADVANCE(219);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(3);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 156:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(156)
      if (lookahead == '\r') SKIP(156)
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '-') ADVANCE(219);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(439);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 157:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(157)
      if (lookahead == '\r') SKIP(157)
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(213);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(4);
      if (lookahead == '=') ADVANCE(206);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '}') ADVANCE(184);
      END_STATE();
    case 158:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(158)
      if (lookahead == '\r') SKIP(158)
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(14);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(4);
      if (lookahead == '=') ADVANCE(206);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == '|') ADVANCE(255);
      if (lookahead == '}') ADVANCE(184);
      END_STATE();
    case 159:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(159)
      if (lookahead == '\r') SKIP(159)
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '_') ADVANCE(317);
      if (lookahead == 'f') ADVANCE(392);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 160:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(160)
      if (lookahead == '\r') SKIP(160)
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(317);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 161:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(161)
      if (lookahead == '\r') SKIP(161)
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '-') ADVANCE(213);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(276);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(277);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 162:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(162)
      if (lookahead == '\r') SKIP(162)
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == 't') ADVANCE(461);
      if (lookahead == '}') ADVANCE(184);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 163:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(163)
      if (lookahead == '\r') SKIP(163)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(207);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(338);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'p') ADVANCE(328);
      if (lookahead == 't') ADVANCE(405);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 164:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(164)
      if (lookahead == '\r') SKIP(164)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(232);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(184);
      END_STATE();
    case 165:
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(279);
      END_STATE();
    case 166:
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(278);
      END_STATE();
    case 167:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      END_STATE();
    case 168:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 169:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(273);
      END_STATE();
    case 170:
      if (eof) ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(170)
      if (lookahead == '\r') SKIP(170)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(197);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(207);
      if (lookahead == '>') ADVANCE(237);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(430);
      if (lookahead == 'b') ADVANCE(377);
      if (lookahead == 'c') ADVANCE(325);
      if (lookahead == 'e') ADVANCE(336);
      if (lookahead == 'f') ADVANCE(388);
      if (lookahead == 'i') ADVANCE(367);
      if (lookahead == 'j') ADVANCE(323);
      if (lookahead == 'l') ADVANCE(359);
      if (lookahead == 'n') ADVANCE(333);
      if (lookahead == 'o') ADVANCE(416);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 's') ADVANCE(378);
      if (lookahead == 't') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(393);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(256);
      if (lookahead == '}') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 171:
      if (eof) ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(171)
      if (lookahead == '\r') SKIP(171)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(325);
      if (lookahead == 'e') ADVANCE(337);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'i') ADVANCE(368);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'o') ADVANCE(416);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 't') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 172:
      if (eof) ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(172)
      if (lookahead == '\r') SKIP(172)
      if (lookahead == '!') ADVANCE(261);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == ')') ADVANCE(192);
      if (lookahead == ',') ADVANCE(191);
      if (lookahead == '-') ADVANCE(219);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(193);
      if (lookahead == '<') ADVANCE(3);
      if (lookahead == '=') ADVANCE(206);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(325);
      if (lookahead == 'e') ADVANCE(337);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'i') ADVANCE(368);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'o') ADVANCE(416);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 't') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 173:
      if (eof) ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(173)
      if (lookahead == '\r') SKIP(173)
      if (lookahead == '!') ADVANCE(261);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(439);
      if (lookahead == 'c') ADVANCE(325);
      if (lookahead == 'e') ADVANCE(337);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'i') ADVANCE(368);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'o') ADVANCE(416);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 't') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 174:
      if (eof) ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(174)
      if (lookahead == '\r') SKIP(174)
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(267);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '%') ADVANCE(248);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(190);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(242);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(209);
      if (lookahead == '_') ADVANCE(318);
      if (lookahead == 'a') ADVANCE(430);
      if (lookahead == 'c') ADVANCE(325);
      if (lookahead == 'e') ADVANCE(337);
      if (lookahead == 'f') ADVANCE(392);
      if (lookahead == 'i') ADVANCE(368);
      if (lookahead == 'l') ADVANCE(360);
      if (lookahead == 'o') ADVANCE(416);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 't') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(431);
      if (lookahead == '{') ADVANCE(183);
      if (lookahead == '|') ADVANCE(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_module_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(176);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(180);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_erlang);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_erlang);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_javascript);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_javascript);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(253);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(351);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_as);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '.') ADVANCE(247);
      if (lookahead == '/') ADVANCE(179);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_const);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(229);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(244);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(244);
      if (lookahead == '>') ADVANCE(224);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(244);
      if (lookahead == '>') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_size);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_size);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_fn);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_external);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(234);
      if (lookahead == '<') ADVANCE(211);
      if (lookahead == '=') ADVANCE(233);
      if (lookahead == '>') ADVANCE(249);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(234);
      if (lookahead == '=') ADVANCE(233);
      if (lookahead == '>') ADVANCE(249);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '.') ADVANCE(235);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_LT_DOT);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_LT_EQ_DOT);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(239);
      if (lookahead == '=') ADVANCE(238);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(239);
      if (lookahead == '=') ADVANCE(238);
      if (lookahead == '>') ADVANCE(212);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      if (lookahead == '.') ADVANCE(240);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_GT_DOT);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_GT_EQ_DOT);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(243);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_PLUS_DOT);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_DASH_DOT);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '.') ADVANCE(246);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_STAR_DOT);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_SLASH_DOT);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_todo);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_panic);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_echo);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_case);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(241);
      if (lookahead == '|') ADVANCE(227);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_assert);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_use);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(230);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_visibility_modifier);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_visibility_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_opacity_modifier);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_opacity_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token1);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token2);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'e') ADVANCE(2);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(271);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym__hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(273);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(271);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(166);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(275);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(275);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(166);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(277);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym__decimal);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(277);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym__octal);
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(278);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym__binary);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(279);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_binary);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_binary);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_bytes);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_bytes);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_int);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_bit_string);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_bit_string);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_bits);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_bits);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(27);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(340);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(29);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(342);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(30);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(343);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_signed);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_unsigned);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_big);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_big);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_little);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_little);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_native);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_unit);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_unit);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym__discard_name);
      if (lookahead == '.') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(316);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(317);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym__discard_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(317);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '.') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(318);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '1') ADVANCE(321);
      if (lookahead == '3') ADVANCE(320);
      if (lookahead == '8') ADVANCE(293);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '2') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '6') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '_') ADVANCE(438);
      if (lookahead == 's') ADVANCE(291);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(458);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(423);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(436);
      if (lookahead == 'o') ADVANCE(395);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(436);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(396);
      if (lookahead == 'u') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(396);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(424);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(394);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(435);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(451);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(444);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'b') ADVANCE(264);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(376);
      if (lookahead == 'r') ADVANCE(390);
      if (lookahead == 'x') ADVANCE(455);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(376);
      if (lookahead == 'x') ADVANCE(455);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(376);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(251);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(408);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(427);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(415);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(307);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(366);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(428);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(266);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(344);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(441);
      if (lookahead == 'i') ADVANCE(456);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(441);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(426);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(432);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(418);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(421);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(422);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(182);
      if (lookahead == 'm') ADVANCE(417);
      if (lookahead == 'n') ADVANCE(440);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(182);
      if (lookahead == 'm') ADVANCE(417);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(319);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(309);
      if (lookahead == 'n') ADVANCE(329);
      if (lookahead == 't') ADVANCE(322);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(289);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(399);
      if (lookahead == 'z') ADVANCE(353);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(462);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'h') ADVANCE(406);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(371);
      if (lookahead == 'y') ADVANCE(453);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(339);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(459);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(420);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(397);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(442);
      if (lookahead == 's') ADVANCE(380);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(402);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(403);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(410);
      if (lookahead == 'n') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(355);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(384);
      if (lookahead == 's') ADVANCE(350);
      if (lookahead == 't') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(437);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(358);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(361);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(448);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(449);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(450);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(346);
      if (lookahead == 'y') ADVANCE(419);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(346);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(429);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(334);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(386);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(348);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(349);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(324);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(409);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(411);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(354);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(447);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(413);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'q') ADVANCE(457);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(460);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(383);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(398);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(382);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(446);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(351);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(352);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(443);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(454);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(315);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(258);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(299);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(303);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(381);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(391);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(363);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(425);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(362);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(452);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'u') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(356);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(419);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym__name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(462);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym__upname);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(463);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 171},
  [2] = {.lex_state = 174},
  [3] = {.lex_state = 171},
  [4] = {.lex_state = 142},
  [5] = {.lex_state = 171},
  [6] = {.lex_state = 171},
  [7] = {.lex_state = 143},
  [8] = {.lex_state = 144},
  [9] = {.lex_state = 145},
  [10] = {.lex_state = 142},
  [11] = {.lex_state = 146},
  [12] = {.lex_state = 171},
  [13] = {.lex_state = 171},
  [14] = {.lex_state = 174},
  [15] = {.lex_state = 174},
  [16] = {.lex_state = 144},
  [17] = {.lex_state = 144},
  [18] = {.lex_state = 144},
  [19] = {.lex_state = 144},
  [20] = {.lex_state = 144},
  [21] = {.lex_state = 144},
  [22] = {.lex_state = 144},
  [23] = {.lex_state = 174},
  [24] = {.lex_state = 144},
  [25] = {.lex_state = 174},
  [26] = {.lex_state = 144},
  [27] = {.lex_state = 144},
  [28] = {.lex_state = 144},
  [29] = {.lex_state = 144},
  [30] = {.lex_state = 174},
  [31] = {.lex_state = 174},
  [32] = {.lex_state = 144},
  [33] = {.lex_state = 144},
  [34] = {.lex_state = 144},
  [35] = {.lex_state = 144},
  [36] = {.lex_state = 144},
  [37] = {.lex_state = 144},
  [38] = {.lex_state = 144},
  [39] = {.lex_state = 144},
  [40] = {.lex_state = 174},
  [41] = {.lex_state = 144},
  [42] = {.lex_state = 144},
  [43] = {.lex_state = 144},
  [44] = {.lex_state = 171},
  [45] = {.lex_state = 174},
  [46] = {.lex_state = 144},
  [47] = {.lex_state = 174},
  [48] = {.lex_state = 144},
  [49] = {.lex_state = 174},
  [50] = {.lex_state = 144},
  [51] = {.lex_state = 144},
  [52] = {.lex_state = 144},
  [53] = {.lex_state = 174},
  [54] = {.lex_state = 144},
  [55] = {.lex_state = 174},
  [56] = {.lex_state = 144},
  [57] = {.lex_state = 144},
  [58] = {.lex_state = 144},
  [59] = {.lex_state = 174},
  [60] = {.lex_state = 174},
  [61] = {.lex_state = 174},
  [62] = {.lex_state = 174},
  [63] = {.lex_state = 174},
  [64] = {.lex_state = 144},
  [65] = {.lex_state = 144},
  [66] = {.lex_state = 174},
  [67] = {.lex_state = 144},
  [68] = {.lex_state = 144},
  [69] = {.lex_state = 144},
  [70] = {.lex_state = 174},
  [71] = {.lex_state = 144},
  [72] = {.lex_state = 171},
  [73] = {.lex_state = 144},
  [74] = {.lex_state = 171},
  [75] = {.lex_state = 144},
  [76] = {.lex_state = 144},
  [77] = {.lex_state = 171},
  [78] = {.lex_state = 144},
  [79] = {.lex_state = 144},
  [80] = {.lex_state = 174},
  [81] = {.lex_state = 144},
  [82] = {.lex_state = 144},
  [83] = {.lex_state = 144},
  [84] = {.lex_state = 144},
  [85] = {.lex_state = 174},
  [86] = {.lex_state = 171},
  [87] = {.lex_state = 174},
  [88] = {.lex_state = 174},
  [89] = {.lex_state = 171},
  [90] = {.lex_state = 174},
  [91] = {.lex_state = 144},
  [92] = {.lex_state = 174},
  [93] = {.lex_state = 174},
  [94] = {.lex_state = 171},
  [95] = {.lex_state = 174},
  [96] = {.lex_state = 144},
  [97] = {.lex_state = 174},
  [98] = {.lex_state = 171},
  [99] = {.lex_state = 144},
  [100] = {.lex_state = 171},
  [101] = {.lex_state = 144},
  [102] = {.lex_state = 144},
  [103] = {.lex_state = 171},
  [104] = {.lex_state = 174},
  [105] = {.lex_state = 174},
  [106] = {.lex_state = 144},
  [107] = {.lex_state = 144},
  [108] = {.lex_state = 171},
  [109] = {.lex_state = 171},
  [110] = {.lex_state = 174},
  [111] = {.lex_state = 144},
  [112] = {.lex_state = 144},
  [113] = {.lex_state = 171},
  [114] = {.lex_state = 171},
  [115] = {.lex_state = 144},
  [116] = {.lex_state = 171},
  [117] = {.lex_state = 144},
  [118] = {.lex_state = 171},
  [119] = {.lex_state = 171},
  [120] = {.lex_state = 171},
  [121] = {.lex_state = 144},
  [122] = {.lex_state = 174},
  [123] = {.lex_state = 171},
  [124] = {.lex_state = 174},
  [125] = {.lex_state = 174},
  [126] = {.lex_state = 174},
  [127] = {.lex_state = 174},
  [128] = {.lex_state = 163},
  [129] = {.lex_state = 171},
  [130] = {.lex_state = 174},
  [131] = {.lex_state = 145},
  [132] = {.lex_state = 145},
  [133] = {.lex_state = 145},
  [134] = {.lex_state = 171},
  [135] = {.lex_state = 174},
  [136] = {.lex_state = 171},
  [137] = {.lex_state = 171},
  [138] = {.lex_state = 174},
  [139] = {.lex_state = 171},
  [140] = {.lex_state = 174},
  [141] = {.lex_state = 145},
  [142] = {.lex_state = 171},
  [143] = {.lex_state = 171},
  [144] = {.lex_state = 174},
  [145] = {.lex_state = 171},
  [146] = {.lex_state = 171},
  [147] = {.lex_state = 174},
  [148] = {.lex_state = 145},
  [149] = {.lex_state = 174},
  [150] = {.lex_state = 174},
  [151] = {.lex_state = 174},
  [152] = {.lex_state = 171},
  [153] = {.lex_state = 174},
  [154] = {.lex_state = 174},
  [155] = {.lex_state = 174},
  [156] = {.lex_state = 174},
  [157] = {.lex_state = 174},
  [158] = {.lex_state = 174},
  [159] = {.lex_state = 174},
  [160] = {.lex_state = 171},
  [161] = {.lex_state = 145},
  [162] = {.lex_state = 174},
  [163] = {.lex_state = 174},
  [164] = {.lex_state = 174},
  [165] = {.lex_state = 174},
  [166] = {.lex_state = 174},
  [167] = {.lex_state = 174},
  [168] = {.lex_state = 174},
  [169] = {.lex_state = 174},
  [170] = {.lex_state = 145},
  [171] = {.lex_state = 174},
  [172] = {.lex_state = 174},
  [173] = {.lex_state = 174},
  [174] = {.lex_state = 174},
  [175] = {.lex_state = 174},
  [176] = {.lex_state = 174},
  [177] = {.lex_state = 171},
  [178] = {.lex_state = 171},
  [179] = {.lex_state = 171},
  [180] = {.lex_state = 145},
  [181] = {.lex_state = 171},
  [182] = {.lex_state = 145},
  [183] = {.lex_state = 171},
  [184] = {.lex_state = 145},
  [185] = {.lex_state = 145},
  [186] = {.lex_state = 171},
  [187] = {.lex_state = 171},
  [188] = {.lex_state = 171},
  [189] = {.lex_state = 171},
  [190] = {.lex_state = 145},
  [191] = {.lex_state = 145},
  [192] = {.lex_state = 145},
  [193] = {.lex_state = 171},
  [194] = {.lex_state = 145},
  [195] = {.lex_state = 171},
  [196] = {.lex_state = 171},
  [197] = {.lex_state = 145},
  [198] = {.lex_state = 171},
  [199] = {.lex_state = 171},
  [200] = {.lex_state = 171},
  [201] = {.lex_state = 171},
  [202] = {.lex_state = 171},
  [203] = {.lex_state = 171},
  [204] = {.lex_state = 171},
  [205] = {.lex_state = 171},
  [206] = {.lex_state = 171},
  [207] = {.lex_state = 171},
  [208] = {.lex_state = 171},
  [209] = {.lex_state = 145},
  [210] = {.lex_state = 171},
  [211] = {.lex_state = 145},
  [212] = {.lex_state = 145},
  [213] = {.lex_state = 171},
  [214] = {.lex_state = 145},
  [215] = {.lex_state = 171},
  [216] = {.lex_state = 145},
  [217] = {.lex_state = 171},
  [218] = {.lex_state = 171},
  [219] = {.lex_state = 171},
  [220] = {.lex_state = 145},
  [221] = {.lex_state = 171},
  [222] = {.lex_state = 171},
  [223] = {.lex_state = 145},
  [224] = {.lex_state = 171},
  [225] = {.lex_state = 171},
  [226] = {.lex_state = 171},
  [227] = {.lex_state = 145},
  [228] = {.lex_state = 145},
  [229] = {.lex_state = 145},
  [230] = {.lex_state = 171},
  [231] = {.lex_state = 145},
  [232] = {.lex_state = 171},
  [233] = {.lex_state = 145},
  [234] = {.lex_state = 144},
  [235] = {.lex_state = 144},
  [236] = {.lex_state = 144},
  [237] = {.lex_state = 145},
  [238] = {.lex_state = 145},
  [239] = {.lex_state = 144},
  [240] = {.lex_state = 144},
  [241] = {.lex_state = 142},
  [242] = {.lex_state = 144},
  [243] = {.lex_state = 142},
  [244] = {.lex_state = 144},
  [245] = {.lex_state = 142},
  [246] = {.lex_state = 142},
  [247] = {.lex_state = 144},
  [248] = {.lex_state = 144},
  [249] = {.lex_state = 144},
  [250] = {.lex_state = 144},
  [251] = {.lex_state = 142},
  [252] = {.lex_state = 142},
  [253] = {.lex_state = 142},
  [254] = {.lex_state = 142},
  [255] = {.lex_state = 142},
  [256] = {.lex_state = 142},
  [257] = {.lex_state = 144},
  [258] = {.lex_state = 142},
  [259] = {.lex_state = 144},
  [260] = {.lex_state = 144},
  [261] = {.lex_state = 144},
  [262] = {.lex_state = 144},
  [263] = {.lex_state = 144},
  [264] = {.lex_state = 142},
  [265] = {.lex_state = 142},
  [266] = {.lex_state = 144},
  [267] = {.lex_state = 144},
  [268] = {.lex_state = 142},
  [269] = {.lex_state = 142},
  [270] = {.lex_state = 142},
  [271] = {.lex_state = 142},
  [272] = {.lex_state = 144},
  [273] = {.lex_state = 144},
  [274] = {.lex_state = 144},
  [275] = {.lex_state = 142},
  [276] = {.lex_state = 142},
  [277] = {.lex_state = 142},
  [278] = {.lex_state = 142},
  [279] = {.lex_state = 142},
  [280] = {.lex_state = 142},
  [281] = {.lex_state = 142},
  [282] = {.lex_state = 142},
  [283] = {.lex_state = 144},
  [284] = {.lex_state = 142},
  [285] = {.lex_state = 144},
  [286] = {.lex_state = 142},
  [287] = {.lex_state = 142},
  [288] = {.lex_state = 142},
  [289] = {.lex_state = 142},
  [290] = {.lex_state = 142},
  [291] = {.lex_state = 144},
  [292] = {.lex_state = 142},
  [293] = {.lex_state = 142},
  [294] = {.lex_state = 144},
  [295] = {.lex_state = 144},
  [296] = {.lex_state = 144},
  [297] = {.lex_state = 144},
  [298] = {.lex_state = 144},
  [299] = {.lex_state = 142},
  [300] = {.lex_state = 142},
  [301] = {.lex_state = 142},
  [302] = {.lex_state = 142},
  [303] = {.lex_state = 142},
  [304] = {.lex_state = 142},
  [305] = {.lex_state = 142},
  [306] = {.lex_state = 142},
  [307] = {.lex_state = 142},
  [308] = {.lex_state = 142},
  [309] = {.lex_state = 142},
  [310] = {.lex_state = 142},
  [311] = {.lex_state = 142},
  [312] = {.lex_state = 142},
  [313] = {.lex_state = 142},
  [314] = {.lex_state = 142},
  [315] = {.lex_state = 143},
  [316] = {.lex_state = 142},
  [317] = {.lex_state = 142},
  [318] = {.lex_state = 142},
  [319] = {.lex_state = 142},
  [320] = {.lex_state = 142},
  [321] = {.lex_state = 142},
  [322] = {.lex_state = 142},
  [323] = {.lex_state = 142},
  [324] = {.lex_state = 142},
  [325] = {.lex_state = 142},
  [326] = {.lex_state = 142},
  [327] = {.lex_state = 142},
  [328] = {.lex_state = 142},
  [329] = {.lex_state = 142},
  [330] = {.lex_state = 142},
  [331] = {.lex_state = 142},
  [332] = {.lex_state = 142},
  [333] = {.lex_state = 142},
  [334] = {.lex_state = 142},
  [335] = {.lex_state = 142},
  [336] = {.lex_state = 142},
  [337] = {.lex_state = 142},
  [338] = {.lex_state = 142},
  [339] = {.lex_state = 142},
  [340] = {.lex_state = 142},
  [341] = {.lex_state = 142},
  [342] = {.lex_state = 144},
  [343] = {.lex_state = 142},
  [344] = {.lex_state = 144},
  [345] = {.lex_state = 142},
  [346] = {.lex_state = 144},
  [347] = {.lex_state = 144},
  [348] = {.lex_state = 142},
  [349] = {.lex_state = 142},
  [350] = {.lex_state = 142},
  [351] = {.lex_state = 142},
  [352] = {.lex_state = 144},
  [353] = {.lex_state = 142},
  [354] = {.lex_state = 143},
  [355] = {.lex_state = 144},
  [356] = {.lex_state = 142},
  [357] = {.lex_state = 142},
  [358] = {.lex_state = 142},
  [359] = {.lex_state = 144},
  [360] = {.lex_state = 142},
  [361] = {.lex_state = 142},
  [362] = {.lex_state = 144},
  [363] = {.lex_state = 142},
  [364] = {.lex_state = 142},
  [365] = {.lex_state = 142},
  [366] = {.lex_state = 142},
  [367] = {.lex_state = 142},
  [368] = {.lex_state = 142},
  [369] = {.lex_state = 142},
  [370] = {.lex_state = 142},
  [371] = {.lex_state = 142},
  [372] = {.lex_state = 142},
  [373] = {.lex_state = 142},
  [374] = {.lex_state = 142},
  [375] = {.lex_state = 142},
  [376] = {.lex_state = 144},
  [377] = {.lex_state = 144},
  [378] = {.lex_state = 142},
  [379] = {.lex_state = 142},
  [380] = {.lex_state = 142},
  [381] = {.lex_state = 142},
  [382] = {.lex_state = 142},
  [383] = {.lex_state = 142},
  [384] = {.lex_state = 142},
  [385] = {.lex_state = 142},
  [386] = {.lex_state = 142},
  [387] = {.lex_state = 142},
  [388] = {.lex_state = 142},
  [389] = {.lex_state = 142},
  [390] = {.lex_state = 142},
  [391] = {.lex_state = 142},
  [392] = {.lex_state = 142},
  [393] = {.lex_state = 142},
  [394] = {.lex_state = 142},
  [395] = {.lex_state = 142},
  [396] = {.lex_state = 142},
  [397] = {.lex_state = 142},
  [398] = {.lex_state = 142},
  [399] = {.lex_state = 142},
  [400] = {.lex_state = 142},
  [401] = {.lex_state = 142},
  [402] = {.lex_state = 142},
  [403] = {.lex_state = 142},
  [404] = {.lex_state = 142},
  [405] = {.lex_state = 142},
  [406] = {.lex_state = 142},
  [407] = {.lex_state = 142},
  [408] = {.lex_state = 142},
  [409] = {.lex_state = 142},
  [410] = {.lex_state = 142},
  [411] = {.lex_state = 142},
  [412] = {.lex_state = 142},
  [413] = {.lex_state = 143},
  [414] = {.lex_state = 143},
  [415] = {.lex_state = 142},
  [416] = {.lex_state = 143},
  [417] = {.lex_state = 142},
  [418] = {.lex_state = 142},
  [419] = {.lex_state = 142},
  [420] = {.lex_state = 142},
  [421] = {.lex_state = 142},
  [422] = {.lex_state = 142},
  [423] = {.lex_state = 142},
  [424] = {.lex_state = 142},
  [425] = {.lex_state = 143},
  [426] = {.lex_state = 142},
  [427] = {.lex_state = 142},
  [428] = {.lex_state = 143},
  [429] = {.lex_state = 142},
  [430] = {.lex_state = 143},
  [431] = {.lex_state = 142},
  [432] = {.lex_state = 142},
  [433] = {.lex_state = 142},
  [434] = {.lex_state = 142},
  [435] = {.lex_state = 142},
  [436] = {.lex_state = 143},
  [437] = {.lex_state = 142},
  [438] = {.lex_state = 142},
  [439] = {.lex_state = 143},
  [440] = {.lex_state = 142},
  [441] = {.lex_state = 142},
  [442] = {.lex_state = 142},
  [443] = {.lex_state = 142},
  [444] = {.lex_state = 144},
  [445] = {.lex_state = 142},
  [446] = {.lex_state = 142},
  [447] = {.lex_state = 142},
  [448] = {.lex_state = 143},
  [449] = {.lex_state = 143},
  [450] = {.lex_state = 143},
  [451] = {.lex_state = 143},
  [452] = {.lex_state = 142},
  [453] = {.lex_state = 144},
  [454] = {.lex_state = 142},
  [455] = {.lex_state = 144},
  [456] = {.lex_state = 142},
  [457] = {.lex_state = 142},
  [458] = {.lex_state = 142},
  [459] = {.lex_state = 142},
  [460] = {.lex_state = 142},
  [461] = {.lex_state = 142},
  [462] = {.lex_state = 142},
  [463] = {.lex_state = 142},
  [464] = {.lex_state = 142},
  [465] = {.lex_state = 142},
  [466] = {.lex_state = 143},
  [467] = {.lex_state = 142},
  [468] = {.lex_state = 142},
  [469] = {.lex_state = 142},
  [470] = {.lex_state = 142},
  [471] = {.lex_state = 142},
  [472] = {.lex_state = 142},
  [473] = {.lex_state = 142},
  [474] = {.lex_state = 142},
  [475] = {.lex_state = 143},
  [476] = {.lex_state = 142},
  [477] = {.lex_state = 143},
  [478] = {.lex_state = 142},
  [479] = {.lex_state = 142},
  [480] = {.lex_state = 142},
  [481] = {.lex_state = 142},
  [482] = {.lex_state = 142},
  [483] = {.lex_state = 142},
  [484] = {.lex_state = 142},
  [485] = {.lex_state = 142},
  [486] = {.lex_state = 142},
  [487] = {.lex_state = 142},
  [488] = {.lex_state = 142},
  [489] = {.lex_state = 142},
  [490] = {.lex_state = 144},
  [491] = {.lex_state = 142},
  [492] = {.lex_state = 142},
  [493] = {.lex_state = 142},
  [494] = {.lex_state = 144},
  [495] = {.lex_state = 142},
  [496] = {.lex_state = 142},
  [497] = {.lex_state = 143},
  [498] = {.lex_state = 143},
  [499] = {.lex_state = 142},
  [500] = {.lex_state = 144},
  [501] = {.lex_state = 142},
  [502] = {.lex_state = 144},
  [503] = {.lex_state = 142},
  [504] = {.lex_state = 142},
  [505] = {.lex_state = 142},
  [506] = {.lex_state = 143},
  [507] = {.lex_state = 143},
  [508] = {.lex_state = 143},
  [509] = {.lex_state = 143},
  [510] = {.lex_state = 143},
  [511] = {.lex_state = 143},
  [512] = {.lex_state = 143},
  [513] = {.lex_state = 144},
  [514] = {.lex_state = 143},
  [515] = {.lex_state = 142},
  [516] = {.lex_state = 143},
  [517] = {.lex_state = 143},
  [518] = {.lex_state = 143},
  [519] = {.lex_state = 143},
  [520] = {.lex_state = 143},
  [521] = {.lex_state = 143},
  [522] = {.lex_state = 143},
  [523] = {.lex_state = 143},
  [524] = {.lex_state = 143},
  [525] = {.lex_state = 143},
  [526] = {.lex_state = 142},
  [527] = {.lex_state = 143},
  [528] = {.lex_state = 143},
  [529] = {.lex_state = 143},
  [530] = {.lex_state = 142},
  [531] = {.lex_state = 142},
  [532] = {.lex_state = 143},
  [533] = {.lex_state = 143},
  [534] = {.lex_state = 142},
  [535] = {.lex_state = 143},
  [536] = {.lex_state = 143},
  [537] = {.lex_state = 142},
  [538] = {.lex_state = 142},
  [539] = {.lex_state = 142},
  [540] = {.lex_state = 142},
  [541] = {.lex_state = 143},
  [542] = {.lex_state = 143},
  [543] = {.lex_state = 142},
  [544] = {.lex_state = 143},
  [545] = {.lex_state = 143},
  [546] = {.lex_state = 143},
  [547] = {.lex_state = 142},
  [548] = {.lex_state = 143},
  [549] = {.lex_state = 142},
  [550] = {.lex_state = 143},
  [551] = {.lex_state = 143},
  [552] = {.lex_state = 143},
  [553] = {.lex_state = 142},
  [554] = {.lex_state = 143},
  [555] = {.lex_state = 143},
  [556] = {.lex_state = 143},
  [557] = {.lex_state = 143},
  [558] = {.lex_state = 143},
  [559] = {.lex_state = 143},
  [560] = {.lex_state = 143},
  [561] = {.lex_state = 143},
  [562] = {.lex_state = 143},
  [563] = {.lex_state = 142},
  [564] = {.lex_state = 143},
  [565] = {.lex_state = 142},
  [566] = {.lex_state = 143},
  [567] = {.lex_state = 142},
  [568] = {.lex_state = 142},
  [569] = {.lex_state = 143},
  [570] = {.lex_state = 142},
  [571] = {.lex_state = 143},
  [572] = {.lex_state = 142},
  [573] = {.lex_state = 144},
  [574] = {.lex_state = 144},
  [575] = {.lex_state = 144},
  [576] = {.lex_state = 144},
  [577] = {.lex_state = 144},
  [578] = {.lex_state = 144},
  [579] = {.lex_state = 144},
  [580] = {.lex_state = 144},
  [581] = {.lex_state = 144},
  [582] = {.lex_state = 144},
  [583] = {.lex_state = 144},
  [584] = {.lex_state = 144},
  [585] = {.lex_state = 144},
  [586] = {.lex_state = 144},
  [587] = {.lex_state = 144},
  [588] = {.lex_state = 144},
  [589] = {.lex_state = 144},
  [590] = {.lex_state = 147},
  [591] = {.lex_state = 147},
  [592] = {.lex_state = 147},
  [593] = {.lex_state = 147},
  [594] = {.lex_state = 147},
  [595] = {.lex_state = 147},
  [596] = {.lex_state = 149},
  [597] = {.lex_state = 150},
  [598] = {.lex_state = 150},
  [599] = {.lex_state = 150},
  [600] = {.lex_state = 150},
  [601] = {.lex_state = 150},
  [602] = {.lex_state = 150},
  [603] = {.lex_state = 150},
  [604] = {.lex_state = 164},
  [605] = {.lex_state = 150},
  [606] = {.lex_state = 150},
  [607] = {.lex_state = 150},
  [608] = {.lex_state = 150},
  [609] = {.lex_state = 150},
  [610] = {.lex_state = 150},
  [611] = {.lex_state = 150},
  [612] = {.lex_state = 150},
  [613] = {.lex_state = 150},
  [614] = {.lex_state = 150},
  [615] = {.lex_state = 150},
  [616] = {.lex_state = 150},
  [617] = {.lex_state = 151},
  [618] = {.lex_state = 151},
  [619] = {.lex_state = 150},
  [620] = {.lex_state = 150},
  [621] = {.lex_state = 150},
  [622] = {.lex_state = 150},
  [623] = {.lex_state = 150},
  [624] = {.lex_state = 150},
  [625] = {.lex_state = 150},
  [626] = {.lex_state = 150},
  [627] = {.lex_state = 150},
  [628] = {.lex_state = 150},
  [629] = {.lex_state = 150},
  [630] = {.lex_state = 150},
  [631] = {.lex_state = 150},
  [632] = {.lex_state = 164},
  [633] = {.lex_state = 150},
  [634] = {.lex_state = 164},
  [635] = {.lex_state = 150},
  [636] = {.lex_state = 150},
  [637] = {.lex_state = 164},
  [638] = {.lex_state = 164},
  [639] = {.lex_state = 150},
  [640] = {.lex_state = 150},
  [641] = {.lex_state = 150},
  [642] = {.lex_state = 164},
  [643] = {.lex_state = 164},
  [644] = {.lex_state = 150},
  [645] = {.lex_state = 150},
  [646] = {.lex_state = 150},
  [647] = {.lex_state = 150},
  [648] = {.lex_state = 150},
  [649] = {.lex_state = 164},
  [650] = {.lex_state = 150},
  [651] = {.lex_state = 164},
  [652] = {.lex_state = 150},
  [653] = {.lex_state = 150},
  [654] = {.lex_state = 150},
  [655] = {.lex_state = 150},
  [656] = {.lex_state = 150},
  [657] = {.lex_state = 164},
  [658] = {.lex_state = 164},
  [659] = {.lex_state = 150},
  [660] = {.lex_state = 150},
  [661] = {.lex_state = 150},
  [662] = {.lex_state = 150},
  [663] = {.lex_state = 150},
  [664] = {.lex_state = 150},
  [665] = {.lex_state = 150},
  [666] = {.lex_state = 150},
  [667] = {.lex_state = 150},
  [668] = {.lex_state = 150},
  [669] = {.lex_state = 150},
  [670] = {.lex_state = 150},
  [671] = {.lex_state = 150},
  [672] = {.lex_state = 150},
  [673] = {.lex_state = 150},
  [674] = {.lex_state = 164},
  [675] = {.lex_state = 164},
  [676] = {.lex_state = 164},
  [677] = {.lex_state = 164},
  [678] = {.lex_state = 164},
  [679] = {.lex_state = 164},
  [680] = {.lex_state = 164},
  [681] = {.lex_state = 164},
  [682] = {.lex_state = 174},
  [683] = {.lex_state = 174},
  [684] = {.lex_state = 174},
  [685] = {.lex_state = 174},
  [686] = {.lex_state = 149},
  [687] = {.lex_state = 172},
  [688] = {.lex_state = 171},
  [689] = {.lex_state = 149},
  [690] = {.lex_state = 149},
  [691] = {.lex_state = 172},
  [692] = {.lex_state = 174},
  [693] = {.lex_state = 149},
  [694] = {.lex_state = 149},
  [695] = {.lex_state = 149},
  [696] = {.lex_state = 149},
  [697] = {.lex_state = 171},
  [698] = {.lex_state = 172},
  [699] = {.lex_state = 149},
  [700] = {.lex_state = 149},
  [701] = {.lex_state = 149},
  [702] = {.lex_state = 149},
  [703] = {.lex_state = 149},
  [704] = {.lex_state = 149},
  [705] = {.lex_state = 149},
  [706] = {.lex_state = 171},
  [707] = {.lex_state = 174},
  [708] = {.lex_state = 172},
  [709] = {.lex_state = 171},
  [710] = {.lex_state = 150},
  [711] = {.lex_state = 150},
  [712] = {.lex_state = 172},
  [713] = {.lex_state = 171},
  [714] = {.lex_state = 149},
  [715] = {.lex_state = 174},
  [716] = {.lex_state = 173},
  [717] = {.lex_state = 149},
  [718] = {.lex_state = 173},
  [719] = {.lex_state = 150},
  [720] = {.lex_state = 150},
  [721] = {.lex_state = 149},
  [722] = {.lex_state = 174},
  [723] = {.lex_state = 174},
  [724] = {.lex_state = 149},
  [725] = {.lex_state = 174},
  [726] = {.lex_state = 149},
  [727] = {.lex_state = 149},
  [728] = {.lex_state = 173},
  [729] = {.lex_state = 150},
  [730] = {.lex_state = 149},
  [731] = {.lex_state = 173},
  [732] = {.lex_state = 172},
  [733] = {.lex_state = 150},
  [734] = {.lex_state = 172},
  [735] = {.lex_state = 173},
  [736] = {.lex_state = 174},
  [737] = {.lex_state = 149},
  [738] = {.lex_state = 173},
  [739] = {.lex_state = 149},
  [740] = {.lex_state = 149},
  [741] = {.lex_state = 150},
  [742] = {.lex_state = 172},
  [743] = {.lex_state = 149},
  [744] = {.lex_state = 149},
  [745] = {.lex_state = 172},
  [746] = {.lex_state = 149},
  [747] = {.lex_state = 172},
  [748] = {.lex_state = 171},
  [749] = {.lex_state = 149},
  [750] = {.lex_state = 171},
  [751] = {.lex_state = 149},
  [752] = {.lex_state = 171},
  [753] = {.lex_state = 171},
  [754] = {.lex_state = 171},
  [755] = {.lex_state = 171},
  [756] = {.lex_state = 171},
  [757] = {.lex_state = 171},
  [758] = {.lex_state = 171},
  [759] = {.lex_state = 149},
  [760] = {.lex_state = 171},
  [761] = {.lex_state = 171},
  [762] = {.lex_state = 150},
  [763] = {.lex_state = 149},
  [764] = {.lex_state = 171},
  [765] = {.lex_state = 171},
  [766] = {.lex_state = 171},
  [767] = {.lex_state = 171},
  [768] = {.lex_state = 171},
  [769] = {.lex_state = 150},
  [770] = {.lex_state = 171},
  [771] = {.lex_state = 171},
  [772] = {.lex_state = 171},
  [773] = {.lex_state = 149},
  [774] = {.lex_state = 149},
  [775] = {.lex_state = 171},
  [776] = {.lex_state = 149},
  [777] = {.lex_state = 171},
  [778] = {.lex_state = 149},
  [779] = {.lex_state = 171},
  [780] = {.lex_state = 171},
  [781] = {.lex_state = 171},
  [782] = {.lex_state = 149},
  [783] = {.lex_state = 171},
  [784] = {.lex_state = 147},
  [785] = {.lex_state = 171},
  [786] = {.lex_state = 171},
  [787] = {.lex_state = 171},
  [788] = {.lex_state = 171},
  [789] = {.lex_state = 171},
  [790] = {.lex_state = 171},
  [791] = {.lex_state = 171},
  [792] = {.lex_state = 171},
  [793] = {.lex_state = 150},
  [794] = {.lex_state = 171},
  [795] = {.lex_state = 149},
  [796] = {.lex_state = 171},
  [797] = {.lex_state = 171},
  [798] = {.lex_state = 171},
  [799] = {.lex_state = 147},
  [800] = {.lex_state = 171},
  [801] = {.lex_state = 171},
  [802] = {.lex_state = 171},
  [803] = {.lex_state = 171},
  [804] = {.lex_state = 171},
  [805] = {.lex_state = 171},
  [806] = {.lex_state = 171},
  [807] = {.lex_state = 171},
  [808] = {.lex_state = 171},
  [809] = {.lex_state = 171},
  [810] = {.lex_state = 147},
  [811] = {.lex_state = 171},
  [812] = {.lex_state = 171},
  [813] = {.lex_state = 147},
  [814] = {.lex_state = 171},
  [815] = {.lex_state = 171},
  [816] = {.lex_state = 171},
  [817] = {.lex_state = 150},
  [818] = {.lex_state = 149},
  [819] = {.lex_state = 149},
  [820] = {.lex_state = 171},
  [821] = {.lex_state = 171},
  [822] = {.lex_state = 147},
  [823] = {.lex_state = 150},
  [824] = {.lex_state = 149},
  [825] = {.lex_state = 171},
  [826] = {.lex_state = 149},
  [827] = {.lex_state = 149},
  [828] = {.lex_state = 171},
  [829] = {.lex_state = 149},
  [830] = {.lex_state = 171},
  [831] = {.lex_state = 149},
  [832] = {.lex_state = 149},
  [833] = {.lex_state = 171},
  [834] = {.lex_state = 171},
  [835] = {.lex_state = 149},
  [836] = {.lex_state = 147},
  [837] = {.lex_state = 171},
  [838] = {.lex_state = 171},
  [839] = {.lex_state = 171},
  [840] = {.lex_state = 171},
  [841] = {.lex_state = 171},
  [842] = {.lex_state = 171},
  [843] = {.lex_state = 171},
  [844] = {.lex_state = 147},
  [845] = {.lex_state = 152},
  [846] = {.lex_state = 152},
  [847] = {.lex_state = 152},
  [848] = {.lex_state = 152},
  [849] = {.lex_state = 149},
  [850] = {.lex_state = 152},
  [851] = {.lex_state = 152},
  [852] = {.lex_state = 153},
  [853] = {.lex_state = 149},
  [854] = {.lex_state = 152},
  [855] = {.lex_state = 152},
  [856] = {.lex_state = 152},
  [857] = {.lex_state = 152},
  [858] = {.lex_state = 152},
  [859] = {.lex_state = 152},
  [860] = {.lex_state = 152},
  [861] = {.lex_state = 149},
  [862] = {.lex_state = 149},
  [863] = {.lex_state = 149},
  [864] = {.lex_state = 149},
  [865] = {.lex_state = 152},
  [866] = {.lex_state = 152},
  [867] = {.lex_state = 147},
  [868] = {.lex_state = 147},
  [869] = {.lex_state = 149},
  [870] = {.lex_state = 149},
  [871] = {.lex_state = 149},
  [872] = {.lex_state = 149},
  [873] = {.lex_state = 149},
  [874] = {.lex_state = 149},
  [875] = {.lex_state = 147},
  [876] = {.lex_state = 150},
  [877] = {.lex_state = 147},
  [878] = {.lex_state = 147},
  [879] = {.lex_state = 150},
  [880] = {.lex_state = 154},
  [881] = {.lex_state = 154},
  [882] = {.lex_state = 154},
  [883] = {.lex_state = 150},
  [884] = {.lex_state = 150},
  [885] = {.lex_state = 155},
  [886] = {.lex_state = 154},
  [887] = {.lex_state = 155},
  [888] = {.lex_state = 155},
  [889] = {.lex_state = 150},
  [890] = {.lex_state = 150},
  [891] = {.lex_state = 155},
  [892] = {.lex_state = 150},
  [893] = {.lex_state = 150},
  [894] = {.lex_state = 156},
  [895] = {.lex_state = 156},
  [896] = {.lex_state = 150},
  [897] = {.lex_state = 150},
  [898] = {.lex_state = 149},
  [899] = {.lex_state = 149},
  [900] = {.lex_state = 150},
  [901] = {.lex_state = 150},
  [902] = {.lex_state = 150},
  [903] = {.lex_state = 150},
  [904] = {.lex_state = 150},
  [905] = {.lex_state = 150},
  [906] = {.lex_state = 149},
  [907] = {.lex_state = 150},
  [908] = {.lex_state = 150},
  [909] = {.lex_state = 164},
  [910] = {.lex_state = 149},
  [911] = {.lex_state = 149},
  [912] = {.lex_state = 150},
  [913] = {.lex_state = 150},
  [914] = {.lex_state = 150},
  [915] = {.lex_state = 149},
  [916] = {.lex_state = 150},
  [917] = {.lex_state = 150},
  [918] = {.lex_state = 149},
  [919] = {.lex_state = 149},
  [920] = {.lex_state = 149},
  [921] = {.lex_state = 150},
  [922] = {.lex_state = 150},
  [923] = {.lex_state = 149},
  [924] = {.lex_state = 152},
  [925] = {.lex_state = 152},
  [926] = {.lex_state = 152},
  [927] = {.lex_state = 164},
  [928] = {.lex_state = 164},
  [929] = {.lex_state = 149},
  [930] = {.lex_state = 164},
  [931] = {.lex_state = 149},
  [932] = {.lex_state = 164},
  [933] = {.lex_state = 149},
  [934] = {.lex_state = 164},
  [935] = {.lex_state = 152},
  [936] = {.lex_state = 164},
  [937] = {.lex_state = 164},
  [938] = {.lex_state = 164},
  [939] = {.lex_state = 149},
  [940] = {.lex_state = 152},
  [941] = {.lex_state = 164},
  [942] = {.lex_state = 149},
  [943] = {.lex_state = 149},
  [944] = {.lex_state = 164},
  [945] = {.lex_state = 152},
  [946] = {.lex_state = 164},
  [947] = {.lex_state = 164},
  [948] = {.lex_state = 164},
  [949] = {.lex_state = 164},
  [950] = {.lex_state = 150},
  [951] = {.lex_state = 152},
  [952] = {.lex_state = 164},
  [953] = {.lex_state = 164},
  [954] = {.lex_state = 149},
  [955] = {.lex_state = 152},
  [956] = {.lex_state = 164},
  [957] = {.lex_state = 164},
  [958] = {.lex_state = 152},
  [959] = {.lex_state = 164},
  [960] = {.lex_state = 152},
  [961] = {.lex_state = 150},
  [962] = {.lex_state = 152},
  [963] = {.lex_state = 149},
  [964] = {.lex_state = 152},
  [965] = {.lex_state = 152},
  [966] = {.lex_state = 152},
  [967] = {.lex_state = 164},
  [968] = {.lex_state = 152},
  [969] = {.lex_state = 150},
  [970] = {.lex_state = 164},
  [971] = {.lex_state = 152},
  [972] = {.lex_state = 164},
  [973] = {.lex_state = 152},
  [974] = {.lex_state = 164},
  [975] = {.lex_state = 149},
  [976] = {.lex_state = 149},
  [977] = {.lex_state = 164},
  [978] = {.lex_state = 152},
  [979] = {.lex_state = 149},
  [980] = {.lex_state = 149},
  [981] = {.lex_state = 149},
  [982] = {.lex_state = 149},
  [983] = {.lex_state = 149},
  [984] = {.lex_state = 149},
  [985] = {.lex_state = 164},
  [986] = {.lex_state = 150},
  [987] = {.lex_state = 152},
  [988] = {.lex_state = 152},
  [989] = {.lex_state = 152},
  [990] = {.lex_state = 164},
  [991] = {.lex_state = 164},
  [992] = {.lex_state = 152},
  [993] = {.lex_state = 152},
  [994] = {.lex_state = 164},
  [995] = {.lex_state = 149},
  [996] = {.lex_state = 152},
  [997] = {.lex_state = 150},
  [998] = {.lex_state = 164},
  [999] = {.lex_state = 152},
  [1000] = {.lex_state = 149},
  [1001] = {.lex_state = 152},
  [1002] = {.lex_state = 152},
  [1003] = {.lex_state = 149},
  [1004] = {.lex_state = 149},
  [1005] = {.lex_state = 149},
  [1006] = {.lex_state = 164},
  [1007] = {.lex_state = 149},
  [1008] = {.lex_state = 149},
  [1009] = {.lex_state = 164},
  [1010] = {.lex_state = 164},
  [1011] = {.lex_state = 164},
  [1012] = {.lex_state = 149},
  [1013] = {.lex_state = 149},
  [1014] = {.lex_state = 164},
  [1015] = {.lex_state = 149},
  [1016] = {.lex_state = 152},
  [1017] = {.lex_state = 149},
  [1018] = {.lex_state = 149},
  [1019] = {.lex_state = 149},
  [1020] = {.lex_state = 149},
  [1021] = {.lex_state = 149},
  [1022] = {.lex_state = 164},
  [1023] = {.lex_state = 152},
  [1024] = {.lex_state = 152},
  [1025] = {.lex_state = 149},
  [1026] = {.lex_state = 149},
  [1027] = {.lex_state = 149},
  [1028] = {.lex_state = 149},
  [1029] = {.lex_state = 149},
  [1030] = {.lex_state = 164},
  [1031] = {.lex_state = 152},
  [1032] = {.lex_state = 149},
  [1033] = {.lex_state = 152},
  [1034] = {.lex_state = 149},
  [1035] = {.lex_state = 149},
  [1036] = {.lex_state = 149},
  [1037] = {.lex_state = 149},
  [1038] = {.lex_state = 152},
  [1039] = {.lex_state = 152},
  [1040] = {.lex_state = 152},
  [1041] = {.lex_state = 152},
  [1042] = {.lex_state = 164},
  [1043] = {.lex_state = 152},
  [1044] = {.lex_state = 152},
  [1045] = {.lex_state = 164},
  [1046] = {.lex_state = 149},
  [1047] = {.lex_state = 164},
  [1048] = {.lex_state = 164},
  [1049] = {.lex_state = 164},
  [1050] = {.lex_state = 164},
  [1051] = {.lex_state = 152},
  [1052] = {.lex_state = 164},
  [1053] = {.lex_state = 164},
  [1054] = {.lex_state = 152},
  [1055] = {.lex_state = 149},
  [1056] = {.lex_state = 152},
  [1057] = {.lex_state = 164},
  [1058] = {.lex_state = 149},
  [1059] = {.lex_state = 149},
  [1060] = {.lex_state = 149},
  [1061] = {.lex_state = 149},
  [1062] = {.lex_state = 152},
  [1063] = {.lex_state = 149},
  [1064] = {.lex_state = 164},
  [1065] = {.lex_state = 164},
  [1066] = {.lex_state = 152},
  [1067] = {.lex_state = 164},
  [1068] = {.lex_state = 164},
  [1069] = {.lex_state = 164},
  [1070] = {.lex_state = 164},
  [1071] = {.lex_state = 164},
  [1072] = {.lex_state = 149},
  [1073] = {.lex_state = 149},
  [1074] = {.lex_state = 164},
  [1075] = {.lex_state = 164},
  [1076] = {.lex_state = 164},
  [1077] = {.lex_state = 164},
  [1078] = {.lex_state = 164},
  [1079] = {.lex_state = 152},
  [1080] = {.lex_state = 149},
  [1081] = {.lex_state = 149},
  [1082] = {.lex_state = 164},
  [1083] = {.lex_state = 164},
  [1084] = {.lex_state = 164},
  [1085] = {.lex_state = 164},
  [1086] = {.lex_state = 152},
  [1087] = {.lex_state = 149},
  [1088] = {.lex_state = 143},
  [1089] = {.lex_state = 164},
  [1090] = {.lex_state = 152},
  [1091] = {.lex_state = 144},
  [1092] = {.lex_state = 152},
  [1093] = {.lex_state = 152},
  [1094] = {.lex_state = 152},
  [1095] = {.lex_state = 152},
  [1096] = {.lex_state = 152},
  [1097] = {.lex_state = 152},
  [1098] = {.lex_state = 149},
  [1099] = {.lex_state = 152},
  [1100] = {.lex_state = 152},
  [1101] = {.lex_state = 152},
  [1102] = {.lex_state = 164},
  [1103] = {.lex_state = 144},
  [1104] = {.lex_state = 152},
  [1105] = {.lex_state = 164},
  [1106] = {.lex_state = 149},
  [1107] = {.lex_state = 164},
  [1108] = {.lex_state = 164},
  [1109] = {.lex_state = 164},
  [1110] = {.lex_state = 164},
  [1111] = {.lex_state = 157},
  [1112] = {.lex_state = 158},
  [1113] = {.lex_state = 164},
  [1114] = {.lex_state = 164},
  [1115] = {.lex_state = 164},
  [1116] = {.lex_state = 149},
  [1117] = {.lex_state = 149},
  [1118] = {.lex_state = 149},
  [1119] = {.lex_state = 149},
  [1120] = {.lex_state = 149},
  [1121] = {.lex_state = 164},
  [1122] = {.lex_state = 149},
  [1123] = {.lex_state = 149},
  [1124] = {.lex_state = 149},
  [1125] = {.lex_state = 149},
  [1126] = {.lex_state = 149},
  [1127] = {.lex_state = 149},
  [1128] = {.lex_state = 149},
  [1129] = {.lex_state = 149},
  [1130] = {.lex_state = 149},
  [1131] = {.lex_state = 149},
  [1132] = {.lex_state = 149},
  [1133] = {.lex_state = 149},
  [1134] = {.lex_state = 149},
  [1135] = {.lex_state = 149},
  [1136] = {.lex_state = 164},
  [1137] = {.lex_state = 164},
  [1138] = {.lex_state = 149},
  [1139] = {.lex_state = 149},
  [1140] = {.lex_state = 149},
  [1141] = {.lex_state = 149},
  [1142] = {.lex_state = 149},
  [1143] = {.lex_state = 149},
  [1144] = {.lex_state = 149},
  [1145] = {.lex_state = 149},
  [1146] = {.lex_state = 149},
  [1147] = {.lex_state = 149},
  [1148] = {.lex_state = 147},
  [1149] = {.lex_state = 147},
  [1150] = {.lex_state = 147},
  [1151] = {.lex_state = 159},
  [1152] = {.lex_state = 159},
  [1153] = {.lex_state = 159},
  [1154] = {.lex_state = 159},
  [1155] = {.lex_state = 159},
  [1156] = {.lex_state = 159},
  [1157] = {.lex_state = 159},
  [1158] = {.lex_state = 159},
  [1159] = {.lex_state = 159},
  [1160] = {.lex_state = 159},
  [1161] = {.lex_state = 157},
  [1162] = {.lex_state = 157},
  [1163] = {.lex_state = 157},
  [1164] = {.lex_state = 159},
  [1165] = {.lex_state = 159},
  [1166] = {.lex_state = 159},
  [1167] = {.lex_state = 157},
  [1168] = {.lex_state = 159},
  [1169] = {.lex_state = 159},
  [1170] = {.lex_state = 159},
  [1171] = {.lex_state = 159},
  [1172] = {.lex_state = 159},
  [1173] = {.lex_state = 159},
  [1174] = {.lex_state = 159},
  [1175] = {.lex_state = 159},
  [1176] = {.lex_state = 159},
  [1177] = {.lex_state = 159},
  [1178] = {.lex_state = 159},
  [1179] = {.lex_state = 159},
  [1180] = {.lex_state = 158},
  [1181] = {.lex_state = 159},
  [1182] = {.lex_state = 159},
  [1183] = {.lex_state = 159},
  [1184] = {.lex_state = 159},
  [1185] = {.lex_state = 157},
  [1186] = {.lex_state = 159},
  [1187] = {.lex_state = 159},
  [1188] = {.lex_state = 159},
  [1189] = {.lex_state = 157},
  [1190] = {.lex_state = 159},
  [1191] = {.lex_state = 159},
  [1192] = {.lex_state = 159},
  [1193] = {.lex_state = 159},
  [1194] = {.lex_state = 159},
  [1195] = {.lex_state = 159},
  [1196] = {.lex_state = 157},
  [1197] = {.lex_state = 159},
  [1198] = {.lex_state = 157},
  [1199] = {.lex_state = 157},
  [1200] = {.lex_state = 159},
  [1201] = {.lex_state = 159},
  [1202] = {.lex_state = 159},
  [1203] = {.lex_state = 159},
  [1204] = {.lex_state = 159},
  [1205] = {.lex_state = 157},
  [1206] = {.lex_state = 159},
  [1207] = {.lex_state = 159},
  [1208] = {.lex_state = 159},
  [1209] = {.lex_state = 159},
  [1210] = {.lex_state = 159},
  [1211] = {.lex_state = 159},
  [1212] = {.lex_state = 159},
  [1213] = {.lex_state = 159},
  [1214] = {.lex_state = 159},
  [1215] = {.lex_state = 157},
  [1216] = {.lex_state = 159},
  [1217] = {.lex_state = 159},
  [1218] = {.lex_state = 157},
  [1219] = {.lex_state = 159},
  [1220] = {.lex_state = 159},
  [1221] = {.lex_state = 157},
  [1222] = {.lex_state = 159},
  [1223] = {.lex_state = 159},
  [1224] = {.lex_state = 159},
  [1225] = {.lex_state = 157},
  [1226] = {.lex_state = 157},
  [1227] = {.lex_state = 159},
  [1228] = {.lex_state = 159},
  [1229] = {.lex_state = 159},
  [1230] = {.lex_state = 157},
  [1231] = {.lex_state = 159},
  [1232] = {.lex_state = 158},
  [1233] = {.lex_state = 158},
  [1234] = {.lex_state = 158},
  [1235] = {.lex_state = 158},
  [1236] = {.lex_state = 158},
  [1237] = {.lex_state = 158},
  [1238] = {.lex_state = 158},
  [1239] = {.lex_state = 158},
  [1240] = {.lex_state = 158},
  [1241] = {.lex_state = 158},
  [1242] = {.lex_state = 158},
  [1243] = {.lex_state = 158},
  [1244] = {.lex_state = 158},
  [1245] = {.lex_state = 159},
  [1246] = {.lex_state = 158},
  [1247] = {.lex_state = 157},
  [1248] = {.lex_state = 158},
  [1249] = {.lex_state = 158},
  [1250] = {.lex_state = 147},
  [1251] = {.lex_state = 158},
  [1252] = {.lex_state = 159},
  [1253] = {.lex_state = 158},
  [1254] = {.lex_state = 158},
  [1255] = {.lex_state = 158},
  [1256] = {.lex_state = 158},
  [1257] = {.lex_state = 158},
  [1258] = {.lex_state = 147},
  [1259] = {.lex_state = 158},
  [1260] = {.lex_state = 158},
  [1261] = {.lex_state = 147},
  [1262] = {.lex_state = 158},
  [1263] = {.lex_state = 159},
  [1264] = {.lex_state = 158},
  [1265] = {.lex_state = 158},
  [1266] = {.lex_state = 158},
  [1267] = {.lex_state = 147},
  [1268] = {.lex_state = 157},
  [1269] = {.lex_state = 157},
  [1270] = {.lex_state = 164},
  [1271] = {.lex_state = 158},
  [1272] = {.lex_state = 160},
  [1273] = {.lex_state = 157},
  [1274] = {.lex_state = 157},
  [1275] = {.lex_state = 160},
  [1276] = {.lex_state = 147},
  [1277] = {.lex_state = 157},
  [1278] = {.lex_state = 160},
  [1279] = {.lex_state = 160},
  [1280] = {.lex_state = 164},
  [1281] = {.lex_state = 147},
  [1282] = {.lex_state = 157},
  [1283] = {.lex_state = 164},
  [1284] = {.lex_state = 164},
  [1285] = {.lex_state = 164},
  [1286] = {.lex_state = 157},
  [1287] = {.lex_state = 160},
  [1288] = {.lex_state = 164},
  [1289] = {.lex_state = 160},
  [1290] = {.lex_state = 157},
  [1291] = {.lex_state = 147},
  [1292] = {.lex_state = 147},
  [1293] = {.lex_state = 147},
  [1294] = {.lex_state = 147},
  [1295] = {.lex_state = 147},
  [1296] = {.lex_state = 161},
  [1297] = {.lex_state = 147},
  [1298] = {.lex_state = 160},
  [1299] = {.lex_state = 147},
  [1300] = {.lex_state = 161},
  [1301] = {.lex_state = 147},
  [1302] = {.lex_state = 147},
  [1303] = {.lex_state = 147},
  [1304] = {.lex_state = 158},
  [1305] = {.lex_state = 147},
  [1306] = {.lex_state = 158},
  [1307] = {.lex_state = 147},
  [1308] = {.lex_state = 158},
  [1309] = {.lex_state = 157},
  [1310] = {.lex_state = 147},
  [1311] = {.lex_state = 147},
  [1312] = {.lex_state = 147},
  [1313] = {.lex_state = 147},
  [1314] = {.lex_state = 147},
  [1315] = {.lex_state = 147},
  [1316] = {.lex_state = 157},
  [1317] = {.lex_state = 147},
  [1318] = {.lex_state = 147},
  [1319] = {.lex_state = 147},
  [1320] = {.lex_state = 147},
  [1321] = {.lex_state = 158},
  [1322] = {.lex_state = 147},
  [1323] = {.lex_state = 147},
  [1324] = {.lex_state = 147},
  [1325] = {.lex_state = 147},
  [1326] = {.lex_state = 147},
  [1327] = {.lex_state = 147},
  [1328] = {.lex_state = 147},
  [1329] = {.lex_state = 161},
  [1330] = {.lex_state = 147},
  [1331] = {.lex_state = 147},
  [1332] = {.lex_state = 147},
  [1333] = {.lex_state = 147},
  [1334] = {.lex_state = 147},
  [1335] = {.lex_state = 147},
  [1336] = {.lex_state = 147},
  [1337] = {.lex_state = 147},
  [1338] = {.lex_state = 160},
  [1339] = {.lex_state = 160},
  [1340] = {.lex_state = 158},
  [1341] = {.lex_state = 160},
  [1342] = {.lex_state = 158},
  [1343] = {.lex_state = 158},
  [1344] = {.lex_state = 158},
  [1345] = {.lex_state = 162},
  [1346] = {.lex_state = 160},
  [1347] = {.lex_state = 162},
  [1348] = {.lex_state = 162},
  [1349] = {.lex_state = 162},
  [1350] = {.lex_state = 162},
  [1351] = {.lex_state = 158},
  [1352] = {.lex_state = 162},
  [1353] = {.lex_state = 147, .external_lex_state = 1},
  [1354] = {.lex_state = 147},
  [1355] = {.lex_state = 161},
  [1356] = {.lex_state = 147, .external_lex_state = 1},
  [1357] = {.lex_state = 147, .external_lex_state = 1},
  [1358] = {.lex_state = 147},
  [1359] = {.lex_state = 161},
  [1360] = {.lex_state = 147, .external_lex_state = 1},
  [1361] = {.lex_state = 147, .external_lex_state = 1},
  [1362] = {.lex_state = 147, .external_lex_state = 1},
  [1363] = {.lex_state = 147},
  [1364] = {.lex_state = 161},
  [1365] = {.lex_state = 147, .external_lex_state = 1},
  [1366] = {.lex_state = 147},
  [1367] = {.lex_state = 147},
  [1368] = {.lex_state = 161},
  [1369] = {.lex_state = 147, .external_lex_state = 1},
  [1370] = {.lex_state = 161},
  [1371] = {.lex_state = 161},
  [1372] = {.lex_state = 161},
  [1373] = {.lex_state = 147, .external_lex_state = 1},
  [1374] = {.lex_state = 147, .external_lex_state = 1},
  [1375] = {.lex_state = 147},
  [1376] = {.lex_state = 161},
  [1377] = {.lex_state = 147, .external_lex_state = 1},
  [1378] = {.lex_state = 147, .external_lex_state = 1},
  [1379] = {.lex_state = 147, .external_lex_state = 1},
  [1380] = {.lex_state = 0},
  [1381] = {.lex_state = 147},
  [1382] = {.lex_state = 147, .external_lex_state = 1},
  [1383] = {.lex_state = 161},
  [1384] = {.lex_state = 161},
  [1385] = {.lex_state = 147, .external_lex_state = 1},
  [1386] = {.lex_state = 158},
  [1387] = {.lex_state = 147, .external_lex_state = 1},
  [1388] = {.lex_state = 147, .external_lex_state = 1},
  [1389] = {.lex_state = 147},
  [1390] = {.lex_state = 161},
  [1391] = {.lex_state = 147},
  [1392] = {.lex_state = 147},
  [1393] = {.lex_state = 161},
  [1394] = {.lex_state = 162},
  [1395] = {.lex_state = 160},
  [1396] = {.lex_state = 0},
  [1397] = {.lex_state = 0},
  [1398] = {.lex_state = 0},
  [1399] = {.lex_state = 160},
  [1400] = {.lex_state = 0},
  [1401] = {.lex_state = 147},
  [1402] = {.lex_state = 0},
  [1403] = {.lex_state = 0},
  [1404] = {.lex_state = 0},
  [1405] = {.lex_state = 0},
  [1406] = {.lex_state = 158},
  [1407] = {.lex_state = 0},
  [1408] = {.lex_state = 158},
  [1409] = {.lex_state = 0},
  [1410] = {.lex_state = 158},
  [1411] = {.lex_state = 147},
  [1412] = {.lex_state = 0},
  [1413] = {.lex_state = 0},
  [1414] = {.lex_state = 0},
  [1415] = {.lex_state = 157},
  [1416] = {.lex_state = 147},
  [1417] = {.lex_state = 147},
  [1418] = {.lex_state = 0},
  [1419] = {.lex_state = 172},
  [1420] = {.lex_state = 0},
  [1421] = {.lex_state = 160},
  [1422] = {.lex_state = 0},
  [1423] = {.lex_state = 147},
  [1424] = {.lex_state = 147},
  [1425] = {.lex_state = 147},
  [1426] = {.lex_state = 147},
  [1427] = {.lex_state = 161},
  [1428] = {.lex_state = 161},
  [1429] = {.lex_state = 147},
  [1430] = {.lex_state = 0},
  [1431] = {.lex_state = 0},
  [1432] = {.lex_state = 147},
  [1433] = {.lex_state = 158},
  [1434] = {.lex_state = 147},
  [1435] = {.lex_state = 161},
  [1436] = {.lex_state = 147},
  [1437] = {.lex_state = 0},
  [1438] = {.lex_state = 0},
  [1439] = {.lex_state = 161},
  [1440] = {.lex_state = 161},
  [1441] = {.lex_state = 160},
  [1442] = {.lex_state = 0},
  [1443] = {.lex_state = 147},
  [1444] = {.lex_state = 0},
  [1445] = {.lex_state = 161},
  [1446] = {.lex_state = 160},
  [1447] = {.lex_state = 0},
  [1448] = {.lex_state = 0},
  [1449] = {.lex_state = 0},
  [1450] = {.lex_state = 161},
  [1451] = {.lex_state = 147},
  [1452] = {.lex_state = 161},
  [1453] = {.lex_state = 160},
  [1454] = {.lex_state = 172},
  [1455] = {.lex_state = 0},
  [1456] = {.lex_state = 158},
  [1457] = {.lex_state = 161},
  [1458] = {.lex_state = 161},
  [1459] = {.lex_state = 0},
  [1460] = {.lex_state = 158},
  [1461] = {.lex_state = 147},
  [1462] = {.lex_state = 147},
  [1463] = {.lex_state = 147, .external_lex_state = 1},
  [1464] = {.lex_state = 0},
  [1465] = {.lex_state = 147},
  [1466] = {.lex_state = 161},
  [1467] = {.lex_state = 147},
  [1468] = {.lex_state = 0},
  [1469] = {.lex_state = 147},
  [1470] = {.lex_state = 0},
  [1471] = {.lex_state = 161},
  [1472] = {.lex_state = 160},
  [1473] = {.lex_state = 161},
  [1474] = {.lex_state = 147},
  [1475] = {.lex_state = 147},
  [1476] = {.lex_state = 0},
  [1477] = {.lex_state = 172},
  [1478] = {.lex_state = 0},
  [1479] = {.lex_state = 171},
  [1480] = {.lex_state = 172},
  [1481] = {.lex_state = 0},
  [1482] = {.lex_state = 0},
  [1483] = {.lex_state = 0},
  [1484] = {.lex_state = 0},
  [1485] = {.lex_state = 0},
  [1486] = {.lex_state = 0},
  [1487] = {.lex_state = 0},
  [1488] = {.lex_state = 0},
  [1489] = {.lex_state = 0},
  [1490] = {.lex_state = 0},
  [1491] = {.lex_state = 0},
  [1492] = {.lex_state = 0},
  [1493] = {.lex_state = 172},
  [1494] = {.lex_state = 172},
  [1495] = {.lex_state = 0},
  [1496] = {.lex_state = 0},
  [1497] = {.lex_state = 0},
  [1498] = {.lex_state = 0},
  [1499] = {.lex_state = 147},
  [1500] = {.lex_state = 0},
  [1501] = {.lex_state = 0},
  [1502] = {.lex_state = 147},
  [1503] = {.lex_state = 161},
  [1504] = {.lex_state = 0},
  [1505] = {.lex_state = 0},
  [1506] = {.lex_state = 0},
  [1507] = {.lex_state = 172},
  [1508] = {.lex_state = 0},
  [1509] = {.lex_state = 0},
  [1510] = {.lex_state = 172},
  [1511] = {.lex_state = 0},
  [1512] = {.lex_state = 0},
  [1513] = {.lex_state = 0},
  [1514] = {.lex_state = 0},
  [1515] = {.lex_state = 0},
  [1516] = {.lex_state = 0},
  [1517] = {.lex_state = 0},
  [1518] = {.lex_state = 0},
  [1519] = {.lex_state = 161},
  [1520] = {.lex_state = 0},
  [1521] = {.lex_state = 0},
  [1522] = {.lex_state = 0},
  [1523] = {.lex_state = 0},
  [1524] = {.lex_state = 164},
  [1525] = {.lex_state = 0},
  [1526] = {.lex_state = 172},
  [1527] = {.lex_state = 172},
  [1528] = {.lex_state = 0},
  [1529] = {.lex_state = 0},
  [1530] = {.lex_state = 0},
  [1531] = {.lex_state = 0},
  [1532] = {.lex_state = 0},
  [1533] = {.lex_state = 0},
  [1534] = {.lex_state = 0},
  [1535] = {.lex_state = 147},
  [1536] = {.lex_state = 171},
  [1537] = {.lex_state = 161},
  [1538] = {.lex_state = 147},
  [1539] = {.lex_state = 0},
  [1540] = {.lex_state = 0},
  [1541] = {.lex_state = 0},
  [1542] = {.lex_state = 147},
  [1543] = {.lex_state = 161},
  [1544] = {.lex_state = 0},
  [1545] = {.lex_state = 172},
  [1546] = {.lex_state = 171},
  [1547] = {.lex_state = 0},
  [1548] = {.lex_state = 172},
  [1549] = {.lex_state = 0},
  [1550] = {.lex_state = 0},
  [1551] = {.lex_state = 147},
  [1552] = {.lex_state = 172},
  [1553] = {.lex_state = 172},
  [1554] = {.lex_state = 158},
  [1555] = {.lex_state = 171},
  [1556] = {.lex_state = 0},
  [1557] = {.lex_state = 0},
  [1558] = {.lex_state = 0},
  [1559] = {.lex_state = 0},
  [1560] = {.lex_state = 172},
  [1561] = {.lex_state = 0},
  [1562] = {.lex_state = 147},
  [1563] = {.lex_state = 0},
  [1564] = {.lex_state = 172},
  [1565] = {.lex_state = 172},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 172},
  [1568] = {.lex_state = 0},
  [1569] = {.lex_state = 0},
  [1570] = {.lex_state = 172},
  [1571] = {.lex_state = 0},
  [1572] = {.lex_state = 161},
  [1573] = {.lex_state = 0},
  [1574] = {.lex_state = 0},
  [1575] = {.lex_state = 0},
  [1576] = {.lex_state = 147},
  [1577] = {.lex_state = 0},
  [1578] = {.lex_state = 0},
  [1579] = {.lex_state = 0},
  [1580] = {.lex_state = 0},
  [1581] = {.lex_state = 0},
  [1582] = {.lex_state = 0},
  [1583] = {.lex_state = 0},
  [1584] = {.lex_state = 0},
  [1585] = {.lex_state = 0},
  [1586] = {.lex_state = 161},
  [1587] = {.lex_state = 0},
  [1588] = {.lex_state = 172},
  [1589] = {.lex_state = 0},
  [1590] = {.lex_state = 0},
  [1591] = {.lex_state = 147},
  [1592] = {.lex_state = 0},
  [1593] = {.lex_state = 172},
  [1594] = {.lex_state = 0},
  [1595] = {.lex_state = 0},
  [1596] = {.lex_state = 0},
  [1597] = {.lex_state = 0},
  [1598] = {.lex_state = 0},
  [1599] = {.lex_state = 0},
  [1600] = {.lex_state = 0},
  [1601] = {.lex_state = 0},
  [1602] = {.lex_state = 0},
  [1603] = {.lex_state = 0},
  [1604] = {.lex_state = 0},
  [1605] = {.lex_state = 0},
  [1606] = {.lex_state = 0},
  [1607] = {.lex_state = 0},
  [1608] = {.lex_state = 0},
  [1609] = {.lex_state = 0},
  [1610] = {.lex_state = 0},
  [1611] = {.lex_state = 0},
  [1612] = {.lex_state = 0},
  [1613] = {.lex_state = 0},
  [1614] = {.lex_state = 0},
  [1615] = {.lex_state = 0},
  [1616] = {.lex_state = 0},
  [1617] = {.lex_state = 0},
  [1618] = {.lex_state = 0},
  [1619] = {.lex_state = 0},
  [1620] = {.lex_state = 172},
  [1621] = {.lex_state = 172},
  [1622] = {.lex_state = 0},
  [1623] = {.lex_state = 0},
  [1624] = {.lex_state = 0},
  [1625] = {.lex_state = 0},
  [1626] = {.lex_state = 0},
  [1627] = {.lex_state = 172},
  [1628] = {.lex_state = 0},
  [1629] = {.lex_state = 0},
  [1630] = {.lex_state = 0},
  [1631] = {.lex_state = 0},
  [1632] = {.lex_state = 0},
  [1633] = {.lex_state = 147},
  [1634] = {.lex_state = 172},
  [1635] = {.lex_state = 0},
  [1636] = {.lex_state = 0},
  [1637] = {.lex_state = 0},
  [1638] = {.lex_state = 0},
  [1639] = {.lex_state = 172},
  [1640] = {.lex_state = 0},
  [1641] = {.lex_state = 0},
  [1642] = {.lex_state = 161},
  [1643] = {.lex_state = 0},
  [1644] = {.lex_state = 0},
  [1645] = {.lex_state = 0},
  [1646] = {.lex_state = 0},
  [1647] = {.lex_state = 0},
  [1648] = {.lex_state = 0},
  [1649] = {.lex_state = 0},
  [1650] = {.lex_state = 0},
  [1651] = {.lex_state = 0},
  [1652] = {.lex_state = 172},
  [1653] = {.lex_state = 0},
  [1654] = {.lex_state = 0},
  [1655] = {.lex_state = 0},
  [1656] = {.lex_state = 172},
  [1657] = {.lex_state = 0},
  [1658] = {.lex_state = 0},
  [1659] = {.lex_state = 0},
  [1660] = {.lex_state = 0},
  [1661] = {.lex_state = 147},
  [1662] = {.lex_state = 147},
  [1663] = {.lex_state = 172},
  [1664] = {.lex_state = 0},
  [1665] = {.lex_state = 0},
  [1666] = {.lex_state = 0},
  [1667] = {.lex_state = 161},
  [1668] = {.lex_state = 161},
  [1669] = {.lex_state = 0},
  [1670] = {.lex_state = 0},
  [1671] = {.lex_state = 161},
  [1672] = {.lex_state = 161},
  [1673] = {.lex_state = 0},
  [1674] = {.lex_state = 0},
  [1675] = {.lex_state = 0},
  [1676] = {.lex_state = 161},
  [1677] = {.lex_state = 0},
  [1678] = {.lex_state = 171},
  [1679] = {.lex_state = 0},
  [1680] = {.lex_state = 161},
  [1681] = {.lex_state = 0},
  [1682] = {.lex_state = 172},
  [1683] = {.lex_state = 0},
  [1684] = {.lex_state = 161},
  [1685] = {.lex_state = 0},
  [1686] = {.lex_state = 0},
  [1687] = {.lex_state = 161},
  [1688] = {.lex_state = 0},
  [1689] = {.lex_state = 0},
  [1690] = {.lex_state = 172},
  [1691] = {.lex_state = 161},
  [1692] = {.lex_state = 172},
  [1693] = {.lex_state = 0},
  [1694] = {.lex_state = 0},
  [1695] = {.lex_state = 0},
  [1696] = {.lex_state = 0},
  [1697] = {.lex_state = 0},
  [1698] = {.lex_state = 0},
  [1699] = {.lex_state = 161},
  [1700] = {.lex_state = 0},
  [1701] = {.lex_state = 0},
  [1702] = {.lex_state = 0},
  [1703] = {.lex_state = 0},
  [1704] = {.lex_state = 161},
  [1705] = {.lex_state = 0},
  [1706] = {.lex_state = 147},
  [1707] = {.lex_state = 172},
  [1708] = {.lex_state = 0},
  [1709] = {.lex_state = 0},
  [1710] = {.lex_state = 0},
  [1711] = {.lex_state = 0},
  [1712] = {.lex_state = 0},
  [1713] = {.lex_state = 0},
  [1714] = {.lex_state = 0},
  [1715] = {.lex_state = 161},
  [1716] = {.lex_state = 0},
  [1717] = {.lex_state = 0},
  [1718] = {.lex_state = 0},
  [1719] = {.lex_state = 0},
  [1720] = {.lex_state = 0},
  [1721] = {.lex_state = 161},
  [1722] = {.lex_state = 0},
  [1723] = {.lex_state = 0},
  [1724] = {.lex_state = 0},
  [1725] = {.lex_state = 172},
  [1726] = {.lex_state = 0},
  [1727] = {.lex_state = 0},
  [1728] = {.lex_state = 0},
  [1729] = {.lex_state = 0},
  [1730] = {.lex_state = 0},
  [1731] = {.lex_state = 0},
  [1732] = {.lex_state = 0},
  [1733] = {.lex_state = 0},
  [1734] = {.lex_state = 0},
  [1735] = {.lex_state = 0},
  [1736] = {.lex_state = 0},
  [1737] = {.lex_state = 0},
  [1738] = {.lex_state = 0},
  [1739] = {.lex_state = 0},
  [1740] = {.lex_state = 0},
  [1741] = {.lex_state = 0},
  [1742] = {.lex_state = 171},
  [1743] = {.lex_state = 171},
  [1744] = {.lex_state = 0},
  [1745] = {.lex_state = 161},
  [1746] = {.lex_state = 0},
  [1747] = {.lex_state = 0},
  [1748] = {.lex_state = 0},
  [1749] = {.lex_state = 0},
  [1750] = {.lex_state = 0},
  [1751] = {.lex_state = 0},
  [1752] = {.lex_state = 0},
  [1753] = {.lex_state = 0},
  [1754] = {.lex_state = 0},
  [1755] = {.lex_state = 0},
  [1756] = {.lex_state = 0},
  [1757] = {.lex_state = 0},
  [1758] = {.lex_state = 0},
  [1759] = {.lex_state = 0},
  [1760] = {.lex_state = 171},
  [1761] = {.lex_state = 171},
  [1762] = {.lex_state = 0},
  [1763] = {.lex_state = 161},
  [1764] = {.lex_state = 161},
  [1765] = {.lex_state = 161},
  [1766] = {.lex_state = 0},
  [1767] = {.lex_state = 161},
  [1768] = {.lex_state = 0},
  [1769] = {.lex_state = 171},
  [1770] = {.lex_state = 0},
  [1771] = {.lex_state = 171},
  [1772] = {.lex_state = 171},
  [1773] = {.lex_state = 161},
  [1774] = {.lex_state = 171},
  [1775] = {.lex_state = 161},
  [1776] = {.lex_state = 0},
  [1777] = {.lex_state = 171},
  [1778] = {.lex_state = 0},
  [1779] = {.lex_state = 171},
  [1780] = {.lex_state = 0},
  [1781] = {.lex_state = 171},
  [1782] = {.lex_state = 0},
  [1783] = {.lex_state = 0},
  [1784] = {.lex_state = 0},
  [1785] = {.lex_state = 0},
  [1786] = {.lex_state = 171},
  [1787] = {.lex_state = 171},
  [1788] = {.lex_state = 0},
  [1789] = {.lex_state = 161},
  [1790] = {.lex_state = 147},
  [1791] = {.lex_state = 0},
  [1792] = {.lex_state = 147},
  [1793] = {.lex_state = 172},
  [1794] = {.lex_state = 0},
  [1795] = {.lex_state = 0},
  [1796] = {.lex_state = 161},
  [1797] = {.lex_state = 171},
  [1798] = {.lex_state = 171},
  [1799] = {.lex_state = 161},
  [1800] = {.lex_state = 0},
  [1801] = {.lex_state = 161},
  [1802] = {.lex_state = 161},
  [1803] = {.lex_state = 0},
  [1804] = {.lex_state = 161},
  [1805] = {.lex_state = 0},
  [1806] = {.lex_state = 0},
  [1807] = {.lex_state = 0},
  [1808] = {.lex_state = 0},
  [1809] = {.lex_state = 0},
  [1810] = {.lex_state = 0},
  [1811] = {.lex_state = 0},
  [1812] = {.lex_state = 147},
  [1813] = {.lex_state = 161},
  [1814] = {.lex_state = 0},
  [1815] = {.lex_state = 161},
  [1816] = {.lex_state = 172},
  [1817] = {.lex_state = 0},
  [1818] = {.lex_state = 0},
  [1819] = {.lex_state = 0},
  [1820] = {.lex_state = 172},
  [1821] = {.lex_state = 147},
  [1822] = {.lex_state = 0},
  [1823] = {.lex_state = 0},
  [1824] = {.lex_state = 0},
  [1825] = {.lex_state = 172},
  [1826] = {.lex_state = 0},
  [1827] = {.lex_state = 172},
  [1828] = {.lex_state = 0},
  [1829] = {.lex_state = 0},
  [1830] = {.lex_state = 0},
  [1831] = {.lex_state = 0},
  [1832] = {.lex_state = 0},
  [1833] = {.lex_state = 0},
  [1834] = {.lex_state = 0},
  [1835] = {.lex_state = 172},
  [1836] = {.lex_state = 0},
  [1837] = {.lex_state = 0},
  [1838] = {.lex_state = 0},
  [1839] = {.lex_state = 172},
  [1840] = {.lex_state = 0},
  [1841] = {.lex_state = 0},
  [1842] = {.lex_state = 0},
  [1843] = {.lex_state = 0},
  [1844] = {.lex_state = 0},
  [1845] = {.lex_state = 0},
  [1846] = {.lex_state = 161},
  [1847] = {.lex_state = 0},
  [1848] = {.lex_state = 0},
  [1849] = {.lex_state = 0},
  [1850] = {.lex_state = 161},
  [1851] = {.lex_state = 0},
  [1852] = {.lex_state = 0},
  [1853] = {.lex_state = 0},
  [1854] = {.lex_state = 0},
  [1855] = {.lex_state = 0},
  [1856] = {.lex_state = 0},
  [1857] = {.lex_state = 0},
  [1858] = {.lex_state = 0},
  [1859] = {.lex_state = 0},
  [1860] = {.lex_state = 0},
  [1861] = {.lex_state = 172},
  [1862] = {.lex_state = 0},
  [1863] = {.lex_state = 0},
  [1864] = {.lex_state = 0},
  [1865] = {.lex_state = 0},
  [1866] = {.lex_state = 0},
  [1867] = {.lex_state = 0},
  [1868] = {.lex_state = 0},
  [1869] = {.lex_state = 172},
  [1870] = {.lex_state = 172},
  [1871] = {.lex_state = 0},
  [1872] = {.lex_state = 0},
  [1873] = {.lex_state = 0},
  [1874] = {.lex_state = 0},
  [1875] = {.lex_state = 172},
  [1876] = {.lex_state = 0},
  [1877] = {.lex_state = 172},
  [1878] = {.lex_state = 0},
  [1879] = {.lex_state = 0},
  [1880] = {.lex_state = 0},
  [1881] = {.lex_state = 0},
  [1882] = {.lex_state = 0},
  [1883] = {.lex_state = 0},
  [1884] = {.lex_state = 0},
  [1885] = {.lex_state = 0},
  [1886] = {.lex_state = 0},
  [1887] = {.lex_state = 172},
  [1888] = {.lex_state = 0},
  [1889] = {.lex_state = 172},
  [1890] = {.lex_state = 0},
  [1891] = {.lex_state = 0},
  [1892] = {.lex_state = 0},
  [1893] = {.lex_state = 0},
  [1894] = {.lex_state = 0},
  [1895] = {.lex_state = 0},
  [1896] = {.lex_state = 0},
  [1897] = {.lex_state = 0},
  [1898] = {.lex_state = 0},
  [1899] = {.lex_state = 0},
  [1900] = {.lex_state = 0},
  [1901] = {.lex_state = 0},
  [1902] = {.lex_state = 0},
  [1903] = {.lex_state = 147},
  [1904] = {.lex_state = 0},
  [1905] = {.lex_state = 147},
  [1906] = {.lex_state = 0},
  [1907] = {.lex_state = 0},
  [1908] = {.lex_state = 0},
  [1909] = {.lex_state = 0},
  [1910] = {.lex_state = 0},
  [1911] = {.lex_state = 0},
  [1912] = {.lex_state = 0},
  [1913] = {.lex_state = 0},
  [1914] = {.lex_state = 172},
  [1915] = {.lex_state = 0},
  [1916] = {.lex_state = 0},
  [1917] = {.lex_state = 0},
  [1918] = {.lex_state = 0},
  [1919] = {.lex_state = 147},
  [1920] = {.lex_state = 0},
  [1921] = {.lex_state = 0},
  [1922] = {.lex_state = 0},
  [1923] = {.lex_state = 0},
  [1924] = {.lex_state = 0},
  [1925] = {.lex_state = 0},
  [1926] = {.lex_state = 0},
  [1927] = {.lex_state = 0},
  [1928] = {.lex_state = 0},
  [1929] = {.lex_state = 0},
  [1930] = {.lex_state = 0},
  [1931] = {.lex_state = 0},
  [1932] = {.lex_state = 0},
  [1933] = {.lex_state = 0},
  [1934] = {.lex_state = 0},
  [1935] = {.lex_state = 0},
  [1936] = {.lex_state = 0},
  [1937] = {.lex_state = 0},
  [1938] = {.lex_state = 0},
  [1939] = {.lex_state = 172},
  [1940] = {.lex_state = 0},
  [1941] = {.lex_state = 0},
  [1942] = {.lex_state = 172},
  [1943] = {.lex_state = 0},
  [1944] = {.lex_state = 0},
  [1945] = {.lex_state = 172},
  [1946] = {.lex_state = 0},
  [1947] = {.lex_state = 0},
  [1948] = {.lex_state = 172},
  [1949] = {.lex_state = 0},
  [1950] = {.lex_state = 0},
  [1951] = {.lex_state = 0},
  [1952] = {.lex_state = 0},
  [1953] = {.lex_state = 0},
  [1954] = {.lex_state = 0},
  [1955] = {.lex_state = 0},
  [1956] = {.lex_state = 0},
  [1957] = {.lex_state = 0},
  [1958] = {.lex_state = 0},
  [1959] = {.lex_state = 0},
  [1960] = {.lex_state = 0},
  [1961] = {.lex_state = 0},
  [1962] = {.lex_state = 0},
  [1963] = {.lex_state = 172},
  [1964] = {.lex_state = 0},
  [1965] = {.lex_state = 0},
  [1966] = {.lex_state = 0},
};

enum {
  ts_external_token_quoted_content = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_quoted_content] = sym_quoted_content,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_quoted_content] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_erlang] = ACTIONS(1),
    [anon_sym_javascript] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_size] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT_DOT] = ACTIONS(1),
    [anon_sym_LT_EQ_DOT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_DOT] = ACTIONS(1),
    [anon_sym_GT_EQ_DOT] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PLUS_DOT] = ACTIONS(1),
    [anon_sym_DASH_DOT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_STAR_DOT] = ACTIONS(1),
    [anon_sym_SLASH_DOT] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_todo] = ACTIONS(1),
    [anon_sym_panic] = ACTIONS(1),
    [anon_sym_echo] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [sym_visibility_modifier] = ACTIONS(1),
    [sym_opacity_modifier] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [aux_sym_escape_sequence_token1] = ACTIONS(1),
    [aux_sym_escape_sequence_token2] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym__hex] = ACTIONS(1),
    [sym__decimal] = ACTIONS(1),
    [sym__octal] = ACTIONS(1),
    [sym__binary] = ACTIONS(1),
    [anon_sym_binary] = ACTIONS(1),
    [anon_sym_bytes] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_bit_string] = ACTIONS(1),
    [anon_sym_bits] = ACTIONS(1),
    [anon_sym_utf8] = ACTIONS(1),
    [anon_sym_utf16] = ACTIONS(1),
    [anon_sym_utf32] = ACTIONS(1),
    [anon_sym_utf8_codepoint] = ACTIONS(1),
    [anon_sym_utf16_codepoint] = ACTIONS(1),
    [anon_sym_utf32_codepoint] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_big] = ACTIONS(1),
    [anon_sym_little] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_unit] = ACTIONS(1),
    [sym__discard_name] = ACTIONS(1),
    [sym__name] = ACTIONS(1),
    [sym__upname] = ACTIONS(1),
    [sym_quoted_content] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(1915),
    [sym__module_statement] = STATE(6),
    [sym_target_group] = STATE(6),
    [sym_attribute] = STATE(6),
    [sym_import] = STATE(6),
    [sym_constant] = STATE(6),
    [sym_external_type] = STATE(6),
    [sym_external_function] = STATE(6),
    [sym_function] = STATE(6),
    [aux_sym__statement_seq] = STATE(13),
    [sym__statement] = STATE(761),
    [sym__expression] = STATE(230),
    [sym_binary_expression] = STATE(230),
    [sym__expression_unit] = STATE(230),
    [sym_record] = STATE(137),
    [sym_todo] = STATE(230),
    [sym_panic] = STATE(230),
    [sym_echo] = STATE(230),
    [sym_tuple] = STATE(142),
    [sym_list] = STATE(230),
    [sym__expression_bit_string] = STATE(230),
    [sym_anonymous_function] = STATE(143),
    [sym_block] = STATE(114),
    [sym_case] = STATE(114),
    [sym_let_assert] = STATE(761),
    [sym_let] = STATE(761),
    [sym_use] = STATE(761),
    [sym_assert] = STATE(230),
    [sym_boolean_negation] = STATE(230),
    [sym_integer_negation] = STATE(230),
    [sym_record_update] = STATE(137),
    [sym__maybe_tuple_expression] = STATE(1913),
    [sym_tuple_access] = STATE(114),
    [sym__maybe_record_expression] = STATE(1902),
    [sym_field_access] = STATE(114),
    [sym__maybe_function_expression] = STATE(1666),
    [sym_function_call] = STATE(114),
    [sym_type_definition] = STATE(6),
    [sym_type_alias] = STATE(6),
    [sym_string] = STATE(230),
    [sym_integer] = STATE(230),
    [sym_identifier] = STATE(109),
    [sym_constructor_name] = STATE(44),
    [sym_remote_constructor_name] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LT_LT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_todo] = ACTIONS(33),
    [anon_sym_panic] = ACTIONS(35),
    [anon_sym_echo] = ACTIONS(37),
    [anon_sym_case] = ACTIONS(39),
    [anon_sym_let] = ACTIONS(41),
    [anon_sym_assert] = ACTIONS(43),
    [anon_sym_use] = ACTIONS(45),
    [anon_sym_BANG] = ACTIONS(47),
    [sym_visibility_modifier] = ACTIONS(49),
    [sym_opacity_modifier] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [sym__hex] = ACTIONS(57),
    [sym__decimal] = ACTIONS(59),
    [sym__octal] = ACTIONS(57),
    [sym__binary] = ACTIONS(57),
    [sym__name] = ACTIONS(61),
    [sym__upname] = ACTIONS(63),
  },
  [2] = {
    [sym__expression] = STATE(163),
    [sym_binary_expression] = STATE(163),
    [sym__expression_unit] = STATE(163),
    [sym_record] = STATE(92),
    [sym_todo] = STATE(163),
    [sym_panic] = STATE(163),
    [sym_echo] = STATE(163),
    [sym_tuple] = STATE(85),
    [sym_list] = STATE(163),
    [sym__expression_bit_string] = STATE(163),
    [sym_anonymous_function] = STATE(80),
    [sym_block] = STATE(66),
    [sym_case] = STATE(66),
    [sym_assert] = STATE(163),
    [sym_boolean_negation] = STATE(163),
    [sym_integer_negation] = STATE(163),
    [sym_record_update] = STATE(92),
    [sym__maybe_tuple_expression] = STATE(1957),
    [sym_tuple_access] = STATE(66),
    [sym__maybe_record_expression] = STATE(1856),
    [sym_field_access] = STATE(66),
    [sym__maybe_function_expression] = STATE(1719),
    [sym_function_call] = STATE(66),
    [sym_string] = STATE(163),
    [sym_integer] = STATE(163),
    [sym_identifier] = STATE(70),
    [sym_constructor_name] = STATE(14),
    [sym_remote_constructor_name] = STATE(14),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(65),
    [anon_sym_import] = ACTIONS(67),
    [anon_sym_as] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_type] = ACTIONS(67),
    [anon_sym_const] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(67),
    [anon_sym_external] = ACTIONS(67),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(67),
    [anon_sym_panic] = ACTIONS(67),
    [anon_sym_echo] = ACTIONS(67),
    [anon_sym_case] = ACTIONS(67),
    [anon_sym_let] = ACTIONS(67),
    [anon_sym_assert] = ACTIONS(67),
    [anon_sym_use] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [sym_visibility_modifier] = ACTIONS(67),
    [sym_opacity_modifier] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(65),
    [sym_float] = ACTIONS(65),
    [sym__hex] = ACTIONS(65),
    [sym__decimal] = ACTIONS(67),
    [sym__octal] = ACTIONS(65),
    [sym__binary] = ACTIONS(65),
    [sym__name] = ACTIONS(67),
    [sym__upname] = ACTIONS(65),
  },
  [3] = {
    [sym__expression] = STATE(201),
    [sym_binary_expression] = STATE(201),
    [sym__expression_unit] = STATE(201),
    [sym_record] = STATE(137),
    [sym_todo] = STATE(201),
    [sym_panic] = STATE(201),
    [sym_echo] = STATE(201),
    [sym_tuple] = STATE(142),
    [sym_list] = STATE(201),
    [sym__expression_bit_string] = STATE(201),
    [sym_anonymous_function] = STATE(143),
    [sym_block] = STATE(114),
    [sym_case] = STATE(114),
    [sym_assert] = STATE(201),
    [sym_boolean_negation] = STATE(201),
    [sym_integer_negation] = STATE(201),
    [sym_record_update] = STATE(137),
    [sym__maybe_tuple_expression] = STATE(1913),
    [sym_tuple_access] = STATE(114),
    [sym__maybe_record_expression] = STATE(1902),
    [sym_field_access] = STATE(114),
    [sym__maybe_function_expression] = STATE(1666),
    [sym_function_call] = STATE(114),
    [sym_string] = STATE(201),
    [sym_integer] = STATE(201),
    [sym_identifier] = STATE(109),
    [sym_constructor_name] = STATE(44),
    [sym_remote_constructor_name] = STATE(44),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(65),
    [anon_sym_import] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_type] = ACTIONS(67),
    [anon_sym_const] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(67),
    [anon_sym_external] = ACTIONS(67),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(67),
    [anon_sym_panic] = ACTIONS(67),
    [anon_sym_echo] = ACTIONS(67),
    [anon_sym_case] = ACTIONS(67),
    [anon_sym_let] = ACTIONS(67),
    [anon_sym_assert] = ACTIONS(67),
    [anon_sym_use] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [sym_visibility_modifier] = ACTIONS(67),
    [sym_opacity_modifier] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(65),
    [sym_float] = ACTIONS(65),
    [sym__hex] = ACTIONS(65),
    [sym__decimal] = ACTIONS(67),
    [sym__octal] = ACTIONS(65),
    [sym__binary] = ACTIONS(65),
    [sym__name] = ACTIONS(67),
    [sym__upname] = ACTIONS(65),
  },
  [4] = {
    [sym__expression] = STATE(861),
    [sym_binary_expression] = STATE(861),
    [sym__expression_unit] = STATE(861),
    [sym_record] = STATE(740),
    [sym_todo] = STATE(861),
    [sym_panic] = STATE(861),
    [sym_echo] = STATE(861),
    [sym_tuple] = STATE(743),
    [sym_list] = STATE(861),
    [sym__expression_bit_string] = STATE(861),
    [sym_anonymous_function] = STATE(744),
    [sym_block] = STATE(705),
    [sym_case] = STATE(705),
    [sym_assert] = STATE(861),
    [sym_boolean_negation] = STATE(861),
    [sym_integer_negation] = STATE(861),
    [sym_record_update] = STATE(740),
    [sym__maybe_tuple_expression] = STATE(1819),
    [sym_tuple_access] = STATE(705),
    [sym__maybe_record_expression] = STATE(1842),
    [sym_field_access] = STATE(705),
    [sym__maybe_function_expression] = STATE(1808),
    [sym_function_call] = STATE(705),
    [sym_string] = STATE(861),
    [sym_integer] = STATE(861),
    [sym_identifier] = STATE(696),
    [sym_constructor_name] = STATE(686),
    [sym_remote_constructor_name] = STATE(686),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(69),
    [anon_sym_RBRACE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(75),
    [anon_sym_GT_GT] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(79),
    [anon_sym_panic] = ACTIONS(81),
    [anon_sym_echo] = ACTIONS(83),
    [anon_sym_DOT_DOT] = ACTIONS(65),
    [anon_sym_case] = ACTIONS(85),
    [anon_sym_assert] = ACTIONS(87),
    [anon_sym_BANG] = ACTIONS(89),
    [anon_sym_DQUOTE] = ACTIONS(91),
    [sym_float] = ACTIONS(93),
    [sym__hex] = ACTIONS(95),
    [sym__decimal] = ACTIONS(97),
    [sym__octal] = ACTIONS(95),
    [sym__binary] = ACTIONS(95),
    [sym__name] = ACTIONS(99),
    [sym__upname] = ACTIONS(101),
  },
  [5] = {
    [sym__module_statement] = STATE(5),
    [sym_target_group] = STATE(5),
    [sym_attribute] = STATE(5),
    [sym_import] = STATE(5),
    [sym_constant] = STATE(5),
    [sym_external_type] = STATE(5),
    [sym_external_function] = STATE(5),
    [sym_function] = STATE(5),
    [aux_sym__statement_seq] = STATE(13),
    [sym__statement] = STATE(761),
    [sym__expression] = STATE(230),
    [sym_binary_expression] = STATE(230),
    [sym__expression_unit] = STATE(230),
    [sym_record] = STATE(137),
    [sym_todo] = STATE(230),
    [sym_panic] = STATE(230),
    [sym_echo] = STATE(230),
    [sym_tuple] = STATE(142),
    [sym_list] = STATE(230),
    [sym__expression_bit_string] = STATE(230),
    [sym_anonymous_function] = STATE(143),
    [sym_block] = STATE(114),
    [sym_case] = STATE(114),
    [sym_let_assert] = STATE(761),
    [sym_let] = STATE(761),
    [sym_use] = STATE(761),
    [sym_assert] = STATE(230),
    [sym_boolean_negation] = STATE(230),
    [sym_integer_negation] = STATE(230),
    [sym_record_update] = STATE(137),
    [sym__maybe_tuple_expression] = STATE(1913),
    [sym_tuple_access] = STATE(114),
    [sym__maybe_record_expression] = STATE(1902),
    [sym_field_access] = STATE(114),
    [sym__maybe_function_expression] = STATE(1666),
    [sym_function_call] = STATE(114),
    [sym_type_definition] = STATE(5),
    [sym_type_alias] = STATE(5),
    [sym_string] = STATE(230),
    [sym_integer] = STATE(230),
    [sym_identifier] = STATE(109),
    [sym_constructor_name] = STATE(44),
    [sym_remote_constructor_name] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(5),
    [ts_builtin_sym_end] = ACTIONS(103),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(108),
    [anon_sym_AT] = ACTIONS(111),
    [anon_sym_import] = ACTIONS(114),
    [anon_sym_type] = ACTIONS(117),
    [anon_sym_const] = ACTIONS(120),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_LBRACK] = ACTIONS(126),
    [anon_sym_LT_LT] = ACTIONS(129),
    [anon_sym_DASH] = ACTIONS(132),
    [anon_sym_fn] = ACTIONS(135),
    [anon_sym_external] = ACTIONS(138),
    [anon_sym_todo] = ACTIONS(141),
    [anon_sym_panic] = ACTIONS(144),
    [anon_sym_echo] = ACTIONS(147),
    [anon_sym_case] = ACTIONS(150),
    [anon_sym_let] = ACTIONS(153),
    [anon_sym_assert] = ACTIONS(156),
    [anon_sym_use] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(162),
    [sym_visibility_modifier] = ACTIONS(165),
    [sym_opacity_modifier] = ACTIONS(168),
    [anon_sym_DQUOTE] = ACTIONS(171),
    [sym_float] = ACTIONS(174),
    [sym__hex] = ACTIONS(177),
    [sym__decimal] = ACTIONS(180),
    [sym__octal] = ACTIONS(177),
    [sym__binary] = ACTIONS(177),
    [sym__name] = ACTIONS(183),
    [sym__upname] = ACTIONS(186),
  },
  [6] = {
    [sym__module_statement] = STATE(5),
    [sym_target_group] = STATE(5),
    [sym_attribute] = STATE(5),
    [sym_import] = STATE(5),
    [sym_constant] = STATE(5),
    [sym_external_type] = STATE(5),
    [sym_external_function] = STATE(5),
    [sym_function] = STATE(5),
    [aux_sym__statement_seq] = STATE(13),
    [sym__statement] = STATE(761),
    [sym__expression] = STATE(230),
    [sym_binary_expression] = STATE(230),
    [sym__expression_unit] = STATE(230),
    [sym_record] = STATE(137),
    [sym_todo] = STATE(230),
    [sym_panic] = STATE(230),
    [sym_echo] = STATE(230),
    [sym_tuple] = STATE(142),
    [sym_list] = STATE(230),
    [sym__expression_bit_string] = STATE(230),
    [sym_anonymous_function] = STATE(143),
    [sym_block] = STATE(114),
    [sym_case] = STATE(114),
    [sym_let_assert] = STATE(761),
    [sym_let] = STATE(761),
    [sym_use] = STATE(761),
    [sym_assert] = STATE(230),
    [sym_boolean_negation] = STATE(230),
    [sym_integer_negation] = STATE(230),
    [sym_record_update] = STATE(137),
    [sym__maybe_tuple_expression] = STATE(1913),
    [sym_tuple_access] = STATE(114),
    [sym__maybe_record_expression] = STATE(1902),
    [sym_field_access] = STATE(114),
    [sym__maybe_function_expression] = STATE(1666),
    [sym_function_call] = STATE(114),
    [sym_type_definition] = STATE(5),
    [sym_type_alias] = STATE(5),
    [sym_string] = STATE(230),
    [sym_integer] = STATE(230),
    [sym_identifier] = STATE(109),
    [sym_constructor_name] = STATE(44),
    [sym_remote_constructor_name] = STATE(44),
    [aux_sym_source_file_repeat1] = STATE(5),
    [ts_builtin_sym_end] = ACTIONS(189),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LT_LT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_todo] = ACTIONS(33),
    [anon_sym_panic] = ACTIONS(35),
    [anon_sym_echo] = ACTIONS(37),
    [anon_sym_case] = ACTIONS(39),
    [anon_sym_let] = ACTIONS(41),
    [anon_sym_assert] = ACTIONS(43),
    [anon_sym_use] = ACTIONS(45),
    [anon_sym_BANG] = ACTIONS(47),
    [sym_visibility_modifier] = ACTIONS(49),
    [sym_opacity_modifier] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [sym__hex] = ACTIONS(57),
    [sym__decimal] = ACTIONS(59),
    [sym__octal] = ACTIONS(57),
    [sym__binary] = ACTIONS(57),
    [sym__name] = ACTIONS(61),
    [sym__upname] = ACTIONS(63),
  },
  [7] = {
    [sym__expression] = STATE(525),
    [sym_binary_expression] = STATE(525),
    [sym__expression_unit] = STATE(525),
    [sym_record] = STATE(507),
    [sym_todo] = STATE(525),
    [sym_panic] = STATE(525),
    [sym_echo] = STATE(525),
    [sym_tuple] = STATE(510),
    [sym_list] = STATE(525),
    [sym__expression_bit_string] = STATE(525),
    [sym_anonymous_function] = STATE(511),
    [sym_block] = STATE(498),
    [sym_case] = STATE(498),
    [sym_assert] = STATE(525),
    [sym_boolean_negation] = STATE(525),
    [sym_integer_negation] = STATE(525),
    [sym_record_update] = STATE(507),
    [sym__maybe_tuple_expression] = STATE(1936),
    [sym_tuple_access] = STATE(498),
    [sym__maybe_record_expression] = STATE(1868),
    [sym_field_access] = STATE(498),
    [sym__maybe_function_expression] = STATE(1686),
    [sym_function_call] = STATE(498),
    [sym_string] = STATE(525),
    [sym_integer] = STATE(525),
    [sym_identifier] = STATE(497),
    [sym_constructor_name] = STATE(315),
    [sym_remote_constructor_name] = STATE(315),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACE] = ACTIONS(65),
    [anon_sym_as] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(67),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(67),
    [anon_sym_panic] = ACTIONS(67),
    [anon_sym_echo] = ACTIONS(67),
    [anon_sym_case] = ACTIONS(67),
    [anon_sym_let] = ACTIONS(67),
    [anon_sym_assert] = ACTIONS(67),
    [anon_sym_use] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(65),
    [sym_float] = ACTIONS(65),
    [sym__hex] = ACTIONS(65),
    [sym__decimal] = ACTIONS(67),
    [sym__octal] = ACTIONS(65),
    [sym__binary] = ACTIONS(65),
    [sym__name] = ACTIONS(67),
    [sym__upname] = ACTIONS(65),
  },
  [8] = {
    [sym__expression] = STATE(585),
    [sym_binary_expression] = STATE(585),
    [sym__expression_unit] = STATE(585),
    [sym_record] = STATE(272),
    [sym_todo] = STATE(585),
    [sym_panic] = STATE(585),
    [sym_echo] = STATE(585),
    [sym_tuple] = STATE(273),
    [sym_list] = STATE(585),
    [sym__expression_bit_string] = STATE(585),
    [sym_anonymous_function] = STATE(274),
    [sym_block] = STATE(266),
    [sym_case] = STATE(266),
    [sym_assert] = STATE(585),
    [sym_boolean_negation] = STATE(585),
    [sym_integer_negation] = STATE(585),
    [sym_record_update] = STATE(272),
    [sym__maybe_tuple_expression] = STATE(1830),
    [sym_tuple_access] = STATE(266),
    [sym__maybe_record_expression] = STATE(1817),
    [sym_field_access] = STATE(266),
    [sym__maybe_function_expression] = STATE(1805),
    [sym_function_call] = STATE(266),
    [sym_string] = STATE(585),
    [sym_integer] = STATE(585),
    [sym_identifier] = STATE(263),
    [sym_constructor_name] = STATE(240),
    [sym_remote_constructor_name] = STATE(240),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_RBRACE] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(67),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(67),
    [anon_sym_panic] = ACTIONS(67),
    [anon_sym_echo] = ACTIONS(67),
    [anon_sym_case] = ACTIONS(67),
    [anon_sym_let] = ACTIONS(67),
    [anon_sym_assert] = ACTIONS(67),
    [anon_sym_use] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(65),
    [sym_float] = ACTIONS(65),
    [sym__hex] = ACTIONS(65),
    [sym__decimal] = ACTIONS(67),
    [sym__octal] = ACTIONS(65),
    [sym__binary] = ACTIONS(65),
    [sym__name] = ACTIONS(67),
    [sym__upname] = ACTIONS(65),
  },
  [9] = {
    [sym__expression] = STATE(668),
    [sym_binary_expression] = STATE(668),
    [sym__expression_unit] = STATE(668),
    [sym_record] = STATE(620),
    [sym_todo] = STATE(668),
    [sym_panic] = STATE(668),
    [sym_echo] = STATE(668),
    [sym_tuple] = STATE(629),
    [sym_list] = STATE(668),
    [sym__expression_bit_string] = STATE(668),
    [sym_anonymous_function] = STATE(628),
    [sym_block] = STATE(598),
    [sym_case] = STATE(598),
    [sym_assert] = STATE(668),
    [sym_boolean_negation] = STATE(668),
    [sym_integer_negation] = STATE(668),
    [sym_record_update] = STATE(620),
    [sym__maybe_tuple_expression] = STATE(1886),
    [sym_tuple_access] = STATE(598),
    [sym__maybe_record_expression] = STATE(1880),
    [sym_field_access] = STATE(598),
    [sym__maybe_function_expression] = STATE(1713),
    [sym_function_call] = STATE(598),
    [sym_string] = STATE(668),
    [sym_integer] = STATE(668),
    [sym_identifier] = STATE(615),
    [sym_constructor_name] = STATE(597),
    [sym_remote_constructor_name] = STATE(597),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(191),
    [anon_sym_RBRACE] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(65),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(195),
    [anon_sym_panic] = ACTIONS(197),
    [anon_sym_echo] = ACTIONS(199),
    [anon_sym_case] = ACTIONS(201),
    [anon_sym_assert] = ACTIONS(203),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(65),
    [sym_float] = ACTIONS(65),
    [sym__hex] = ACTIONS(65),
    [sym__decimal] = ACTIONS(67),
    [sym__octal] = ACTIONS(65),
    [sym__binary] = ACTIONS(65),
    [sym__discard_name] = ACTIONS(67),
    [sym__name] = ACTIONS(67),
    [sym__upname] = ACTIONS(65),
  },
  [10] = {
    [sym__expression] = STATE(1004),
    [sym_binary_expression] = STATE(1004),
    [sym__expression_unit] = STATE(1004),
    [sym_record] = STATE(740),
    [sym_todo] = STATE(1004),
    [sym_panic] = STATE(1004),
    [sym_echo] = STATE(1004),
    [sym_tuple] = STATE(743),
    [sym_list] = STATE(1004),
    [sym__expression_bit_string] = STATE(1004),
    [sym_anonymous_function] = STATE(744),
    [sym_block] = STATE(705),
    [sym_case] = STATE(705),
    [sym_assert] = STATE(1004),
    [sym_boolean_negation] = STATE(1004),
    [sym_integer_negation] = STATE(1004),
    [sym_record_update] = STATE(740),
    [sym__maybe_tuple_expression] = STATE(1819),
    [sym_tuple_access] = STATE(705),
    [sym__maybe_record_expression] = STATE(1842),
    [sym_field_access] = STATE(705),
    [sym__maybe_function_expression] = STATE(1808),
    [sym_function_call] = STATE(705),
    [sym_string] = STATE(1004),
    [sym_integer] = STATE(1004),
    [sym_identifier] = STATE(696),
    [sym_constructor_name] = STATE(686),
    [sym_remote_constructor_name] = STATE(686),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_LT_LT] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(207),
    [anon_sym_panic] = ACTIONS(209),
    [anon_sym_echo] = ACTIONS(211),
    [anon_sym_case] = ACTIONS(85),
    [anon_sym_assert] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(215),
    [anon_sym_DQUOTE] = ACTIONS(91),
    [sym_float] = ACTIONS(217),
    [sym__hex] = ACTIONS(95),
    [sym__decimal] = ACTIONS(97),
    [sym__octal] = ACTIONS(95),
    [sym__binary] = ACTIONS(95),
    [sym__name] = ACTIONS(99),
    [sym__upname] = ACTIONS(101),
  },
  [11] = {
    [sym__expression] = STATE(1052),
    [sym_binary_expression] = STATE(1052),
    [sym__expression_unit] = STATE(1052),
    [sym_record] = STATE(967),
    [sym_todo] = STATE(1052),
    [sym_panic] = STATE(1052),
    [sym_echo] = STATE(1052),
    [sym_tuple] = STATE(1006),
    [sym_list] = STATE(1052),
    [sym__expression_bit_string] = STATE(1052),
    [sym_anonymous_function] = STATE(998),
    [sym_block] = STATE(938),
    [sym_case] = STATE(938),
    [sym_assert] = STATE(1052),
    [sym_boolean_negation] = STATE(1052),
    [sym_integer_negation] = STATE(1052),
    [sym_record_update] = STATE(967),
    [sym__maybe_tuple_expression] = STATE(1836),
    [sym_tuple_access] = STATE(938),
    [sym__maybe_record_expression] = STATE(1892),
    [sym_field_access] = STATE(938),
    [sym__maybe_function_expression] = STATE(1755),
    [sym_function_call] = STATE(938),
    [sym_string] = STATE(1052),
    [sym_integer] = STATE(1052),
    [sym_identifier] = STATE(937),
    [sym_constructor_name] = STATE(909),
    [sym_remote_constructor_name] = STATE(909),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(219),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_POUND] = ACTIONS(221),
    [anon_sym_LBRACK] = ACTIONS(223),
    [anon_sym_LT_LT] = ACTIONS(225),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_fn] = ACTIONS(227),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(65),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_LT_DOT] = ACTIONS(65),
    [anon_sym_LT_EQ_DOT] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_DOT] = ACTIONS(65),
    [anon_sym_GT_EQ_DOT] = ACTIONS(65),
    [anon_sym_PIPE_GT] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_PLUS_DOT] = ACTIONS(65),
    [anon_sym_DASH_DOT] = ACTIONS(65),
    [anon_sym_STAR] = ACTIONS(67),
    [anon_sym_STAR_DOT] = ACTIONS(65),
    [anon_sym_SLASH_DOT] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_LT_GT] = ACTIONS(65),
    [anon_sym_todo] = ACTIONS(229),
    [anon_sym_panic] = ACTIONS(231),
    [anon_sym_echo] = ACTIONS(233),
    [anon_sym_case] = ACTIONS(235),
    [anon_sym_assert] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(239),
    [anon_sym_DQUOTE] = ACTIONS(241),
    [sym_float] = ACTIONS(243),
    [sym__hex] = ACTIONS(245),
    [sym__decimal] = ACTIONS(247),
    [sym__octal] = ACTIONS(245),
    [sym__binary] = ACTIONS(245),
    [sym__name] = ACTIONS(249),
    [sym__upname] = ACTIONS(251),
  },
  [12] = {
    [aux_sym__statement_seq] = STATE(12),
    [sym__statement] = STATE(761),
    [sym__expression] = STATE(230),
    [sym_binary_expression] = STATE(230),
    [sym__expression_unit] = STATE(230),
    [sym_record] = STATE(137),
    [sym_todo] = STATE(230),
    [sym_panic] = STATE(230),
    [sym_echo] = STATE(230),
    [sym_tuple] = STATE(142),
    [sym_list] = STATE(230),
    [sym__expression_bit_string] = STATE(230),
    [sym_anonymous_function] = STATE(143),
    [sym_block] = STATE(114),
    [sym_case] = STATE(114),
    [sym_let_assert] = STATE(761),
    [sym_let] = STATE(761),
    [sym_use] = STATE(761),
    [sym_assert] = STATE(230),
    [sym_boolean_negation] = STATE(230),
    [sym_integer_negation] = STATE(230),
    [sym_record_update] = STATE(137),
    [sym__maybe_tuple_expression] = STATE(1913),
    [sym_tuple_access] = STATE(114),
    [sym__maybe_record_expression] = STATE(1902),
    [sym_field_access] = STATE(114),
    [sym__maybe_function_expression] = STATE(1666),
    [sym_function_call] = STATE(114),
    [sym_string] = STATE(230),
    [sym_integer] = STATE(230),
    [sym_identifier] = STATE(109),
    [sym_constructor_name] = STATE(44),
    [sym_remote_constructor_name] = STATE(44),
    [ts_builtin_sym_end] = ACTIONS(253),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_LBRACE] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(253),
    [anon_sym_import] = ACTIONS(255),
    [anon_sym_type] = ACTIONS(255),
    [anon_sym_const] = ACTIONS(255),
    [anon_sym_POUND] = ACTIONS(260),
    [anon_sym_LBRACK] = ACTIONS(263),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_DASH] = ACTIONS(269),
    [anon_sym_fn] = ACTIONS(272),
    [anon_sym_external] = ACTIONS(255),
    [anon_sym_todo] = ACTIONS(275),
    [anon_sym_panic] = ACTIONS(278),
    [anon_sym_echo] = ACTIONS(281),
    [anon_sym_case] = ACTIONS(284),
    [anon_sym_let] = ACTIONS(287),
    [anon_sym_assert] = ACTIONS(290),
    [anon_sym_use] = ACTIONS(293),
    [anon_sym_BANG] = ACTIONS(296),
    [sym_visibility_modifier] = ACTIONS(255),
    [sym_opacity_modifier] = ACTIONS(255),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [sym_float] = ACTIONS(302),
    [sym__hex] = ACTIONS(305),
    [sym__decimal] = ACTIONS(308),
    [sym__octal] = ACTIONS(305),
    [sym__binary] = ACTIONS(305),
    [sym__name] = ACTIONS(311),
    [sym__upname] = ACTIONS(314),
  },
  [13] = {
    [aux_sym__statement_seq] = STATE(12),
    [sym__statement] = STATE(761),
    [sym__expression] = STATE(230),
    [sym_binary_expression] = STATE(230),
    [sym__expression_unit] = STATE(230),
    [sym_record] = STATE(137),
    [sym_todo] = STATE(230),
    [sym_panic] = STATE(230),
    [sym_echo] = STATE(230),
    [sym_tuple] = STATE(142),
    [sym_list] = STATE(230),
    [sym__expression_bit_string] = STATE(230),
    [sym_anonymous_function] = STATE(143),
    [sym_block] = STATE(114),
    [sym_case] = STATE(114),
    [sym_let_assert] = STATE(761),
    [sym_let] = STATE(761),
    [sym_use] = STATE(761),
    [sym_assert] = STATE(230),
    [sym_boolean_negation] = STATE(230),
    [sym_integer_negation] = STATE(230),
    [sym_record_update] = STATE(137),
    [sym__maybe_tuple_expression] = STATE(1913),
    [sym_tuple_access] = STATE(114),
    [sym__maybe_record_expression] = STATE(1902),
    [sym_field_access] = STATE(114),
    [sym__maybe_function_expression] = STATE(1666),
    [sym_function_call] = STATE(114),
    [sym_string] = STATE(230),
    [sym_integer] = STATE(230),
    [sym_identifier] = STATE(109),
    [sym_constructor_name] = STATE(44),
    [sym_remote_constructor_name] = STATE(44),
    [ts_builtin_sym_end] = ACTIONS(317),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(319),
    [anon_sym_type] = ACTIONS(319),
    [anon_sym_const] = ACTIONS(319),
    [anon_sym_POUND] = ACTIONS(324),
    [anon_sym_LBRACK] = ACTIONS(327),
    [anon_sym_LT_LT] = ACTIONS(330),
    [anon_sym_DASH] = ACTIONS(333),
    [anon_sym_fn] = ACTIONS(336),
    [anon_sym_external] = ACTIONS(319),
    [anon_sym_todo] = ACTIONS(339),
    [anon_sym_panic] = ACTIONS(342),
    [anon_sym_echo] = ACTIONS(345),
    [anon_sym_case] = ACTIONS(348),
    [anon_sym_let] = ACTIONS(351),
    [anon_sym_assert] = ACTIONS(354),
    [anon_sym_use] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(360),
    [sym_visibility_modifier] = ACTIONS(319),
    [sym_opacity_modifier] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [sym_float] = ACTIONS(366),
    [sym__hex] = ACTIONS(369),
    [sym__decimal] = ACTIONS(372),
    [sym__octal] = ACTIONS(369),
    [sym__binary] = ACTIONS(369),
    [sym__name] = ACTIONS(375),
    [sym__upname] = ACTIONS(378),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(385), 1,
      anon_sym_LPAREN,
    STATE(90), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(383), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(381), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [73] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(389), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(387), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [141] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(393), 1,
      anon_sym_RBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [271] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(433), 1,
      anon_sym_RBRACE,
    STATE(19), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [401] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(435), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [531] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(437), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [661] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(253), 1,
      anon_sym_RBRACE,
    ACTIONS(439), 1,
      anon_sym_LBRACE,
    ACTIONS(442), 1,
      anon_sym_POUND,
    ACTIONS(445), 1,
      anon_sym_LBRACK,
    ACTIONS(448), 1,
      anon_sym_LT_LT,
    ACTIONS(451), 1,
      anon_sym_DASH,
    ACTIONS(454), 1,
      anon_sym_fn,
    ACTIONS(457), 1,
      anon_sym_todo,
    ACTIONS(460), 1,
      anon_sym_panic,
    ACTIONS(463), 1,
      anon_sym_echo,
    ACTIONS(466), 1,
      anon_sym_case,
    ACTIONS(469), 1,
      anon_sym_let,
    ACTIONS(472), 1,
      anon_sym_assert,
    ACTIONS(475), 1,
      anon_sym_use,
    ACTIONS(478), 1,
      anon_sym_BANG,
    ACTIONS(481), 1,
      anon_sym_DQUOTE,
    ACTIONS(484), 1,
      sym_float,
    ACTIONS(490), 1,
      sym__decimal,
    ACTIONS(493), 1,
      sym__name,
    ACTIONS(496), 1,
      sym__upname,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(487), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [791] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(499), 1,
      anon_sym_RBRACE,
    STATE(22), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [921] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(501), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1051] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(505), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(503), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1119] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(507), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1249] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(511), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(509), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1317] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(513), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1447] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(515), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1577] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(517), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1707] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(519), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1837] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(523), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(521), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1905] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(527), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(525), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1973] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(529), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2103] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(531), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2233] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(533), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2363] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(535), 1,
      anon_sym_RBRACE,
    STATE(69), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2493] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(537), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2623] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(539), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2753] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(541), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2883] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(543), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3013] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(547), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(545), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3081] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(549), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3211] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(551), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3341] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(553), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3471] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(555), 1,
      anon_sym_LPAREN,
    STATE(139), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(383), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(381), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3543] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(559), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(557), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3611] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(561), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3741] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(565), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(563), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3809] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(567), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3939] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(571), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(569), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4007] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(573), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4137] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(575), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4267] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(577), 1,
      anon_sym_RBRACE,
    STATE(18), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4397] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(581), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(579), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4465] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(583), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4595] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(587), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(585), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4663] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(589), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4793] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(591), 1,
      anon_sym_RBRACE,
    STATE(50), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4923] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(593), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5053] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(597), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(595), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5121] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(601), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(599), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5189] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(605), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(603), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5257] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(609), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(607), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5325] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(613), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(611), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5393] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(615), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5523] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(617), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5653] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(623), 1,
      anon_sym_LPAREN,
    ACTIONS(625), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(619), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(621), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [5725] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(628), 1,
      anon_sym_RBRACE,
    STATE(65), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5855] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(630), 1,
      anon_sym_RBRACE,
    STATE(43), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5985] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(632), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6115] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(623), 1,
      anon_sym_LPAREN,
    ACTIONS(634), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(619), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(621), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [6187] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(638), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6317] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(527), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(525), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6384] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(32), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6511] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(389), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(387), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6578] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(58), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6705] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(51), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6832] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(587), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(585), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6899] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(38), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7026] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(37), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7153] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(623), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(619), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(621), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7222] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(56), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7349] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7476] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(54), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7603] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(28), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7730] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(640), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(619), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(621), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7799] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(523), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(521), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7866] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(644), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(642), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7933] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(648), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(646), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8000] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(511), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(509), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8067] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(650), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8134] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(46), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [8261] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(654), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(619), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(621), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8330] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(658), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(656), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8397] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(505), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(503), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8464] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(664), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(660), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(662), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8533] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(71), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [8660] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(668), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(666), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8727] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(547), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(545), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8794] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(16), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [8921] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(559), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(557), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8988] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(33), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [9115] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(36), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [9242] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(571), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(569), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9309] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(672), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(670), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9376] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(676), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(674), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9443] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(26), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [9570] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(24), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [9697] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(565), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(563), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9764] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(623), 1,
      anon_sym_LPAREN,
    ACTIONS(678), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(619), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9835] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(686), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(682), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(684), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9904] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(29), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10031] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(39), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10158] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(601), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(599), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10225] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(623), 1,
      anon_sym_LPAREN,
    ACTIONS(625), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(619), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10296] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(41), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10423] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(613), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(611), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10490] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(48), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10617] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(609), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(607), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10684] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(597), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(595), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10751] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(605), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(603), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10818] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(413), 1,
      anon_sym_let,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_float,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    STATE(64), 1,
      aux_sym__statement_seq,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1091), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(582), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10945] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(690), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(688), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11012] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(581), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(579), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11079] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(692), 1,
      anon_sym_LPAREN,
    ACTIONS(694), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(662), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(660), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11150] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(684), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(682), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11221] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(700), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(702), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [11287] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(704), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(706), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [11353] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(609), 21,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(607), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11419] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(690), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(688), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11485] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(708), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(710), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [11551] = 36,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(712), 1,
      anon_sym_RPAREN,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_DOT_DOT,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11681] = 36,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(726), 1,
      anon_sym_RPAREN,
    ACTIONS(728), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1584), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11811] = 36,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(730), 1,
      anon_sym_RPAREN,
    ACTIONS(732), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1585), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11941] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(658), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(656), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12007] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(734), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [12073] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(644), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(642), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12139] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(654), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(619), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12207] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(738), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(740), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [12273] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(650), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12339] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(742), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(744), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [12405] = 36,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(746), 1,
      anon_sym_RPAREN,
    ACTIONS(748), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1654), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12535] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(640), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(619), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12603] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(623), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(619), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12671] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(758), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(760), 1,
      anon_sym_AMP_AMP,
    ACTIONS(768), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(756), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(762), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(770), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(764), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(766), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(772), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(750), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(752), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [12757] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(676), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(674), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12823] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(672), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(670), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12889] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(756), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(770), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(772), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 21,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [12963] = 36,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(774), 1,
      anon_sym_RPAREN,
    ACTIONS(776), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13093] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(768), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(756), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(770), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(772), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [13169] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(768), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(756), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(770), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(764), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(766), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(772), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [13249] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(768), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(756), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(762), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(770), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(764), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(766), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(772), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [13331] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(648), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(646), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13397] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(778), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(780), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [13463] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(782), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(784), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [13529] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(786), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(788), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [13595] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(790), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(792), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [13661] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(794), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(796), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [13727] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(798), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(800), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [13793] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(802), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(804), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [13859] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(668), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(666), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13925] = 36,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(806), 1,
      anon_sym_RPAREN,
    ACTIONS(808), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1623), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14055] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(760), 1,
      anon_sym_AMP_AMP,
    ACTIONS(768), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(756), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(762), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(770), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(764), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(766), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(772), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [14139] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(758), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(760), 1,
      anon_sym_AMP_AMP,
    ACTIONS(768), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(756), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(762), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(770), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(764), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(766), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(772), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(810), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(812), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [14225] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(772), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 23,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [14295] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(734), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [14361] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(758), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(760), 1,
      anon_sym_AMP_AMP,
    ACTIONS(768), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(756), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(762), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(770), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(764), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(766), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(772), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(814), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(816), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [14447] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(818), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(821), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [14513] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(758), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(760), 1,
      anon_sym_AMP_AMP,
    ACTIONS(768), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(756), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(762), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(770), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(764), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(766), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(772), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(824), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(826), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [14599] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(758), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(760), 1,
      anon_sym_AMP_AMP,
    ACTIONS(768), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(754), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(756), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(762), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(770), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(764), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(766), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(772), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(828), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(830), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [14685] = 36,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(832), 1,
      anon_sym_RPAREN,
    ACTIONS(834), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1660), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14815] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(836), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(838), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [14881] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(840), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(842), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [14947] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(844), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(846), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [15013] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(848), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(850), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [15079] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(852), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(854), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [15145] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(856), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(858), 27,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [15211] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(864), 1,
      anon_sym_AMP_AMP,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(866), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(868), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(870), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [15294] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(788), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(786), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15359] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(864), 1,
      anon_sym_AMP_AMP,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(878), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(866), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(868), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(870), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(828), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(830), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [15444] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(880), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15571] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(864), 1,
      anon_sym_AMP_AMP,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(878), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(866), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(868), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(870), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(824), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(826), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [15656] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(806), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1623), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15783] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(858), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(856), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15848] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(882), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15975] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(884), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16102] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(792), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(790), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16167] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(702), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(700), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16232] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(800), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(798), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16297] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(864), 1,
      anon_sym_AMP_AMP,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(878), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(866), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(868), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(870), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(886), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(888), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [16382] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(890), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16509] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(832), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1660), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16636] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(892), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16763] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(706), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(704), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16828] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(894), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16955] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(736), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(734), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17020] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 23,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [17089] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(896), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17216] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(866), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(868), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(870), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [17297] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(868), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(870), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [17376] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 22,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [17451] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(864), 1,
      anon_sym_AMP_AMP,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(878), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(866), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(868), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(870), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(810), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(812), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [17536] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 21,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(736), 22,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [17609] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(736), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(734), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17674] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(710), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(708), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17739] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(796), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(794), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17804] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(821), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(818), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17869] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(846), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(844), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17934] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(804), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(802), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17999] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(898), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18126] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(854), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(852), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18191] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(900), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18318] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(726), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1584), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18445] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(864), 1,
      anon_sym_AMP_AMP,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(878), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(866), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(868), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(870), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(814), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(816), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [18530] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(712), 1,
      anon_sym_RPAREN,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18657] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(864), 1,
      anon_sym_AMP_AMP,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(878), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(866), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(868), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(870), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(902), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(904), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [18742] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(730), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1585), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18869] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(740), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(738), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18934] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(744), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(742), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18999] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(850), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(848), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19064] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(774), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1648), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19191] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(864), 1,
      anon_sym_AMP_AMP,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(878), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(866), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(868), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(870), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(750), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(752), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [19276] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(864), 1,
      anon_sym_AMP_AMP,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(878), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(866), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(868), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(870), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(906), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(908), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [19361] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(910), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19488] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(838), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(836), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19553] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(784), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(782), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19618] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(780), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(778), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19683] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(912), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19810] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(746), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1654), 1,
      sym_argument,
    STATE(1675), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19937] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(914), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20064] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(864), 1,
      anon_sym_AMP_AMP,
    ACTIONS(872), 1,
      anon_sym_PIPE_GT,
    ACTIONS(878), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(862), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(866), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(874), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(868), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(870), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(876), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(916), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(918), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [20149] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(920), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20276] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(842), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(840), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20341] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    ACTIONS(922), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20468] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(571), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(569), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20532] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(605), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(603), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20596] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(613), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(611), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20660] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(720), 1,
      sym_float,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(724), 1,
      sym__name,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1675), 1,
      sym_hole,
    STATE(1739), 1,
      sym_argument,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1961), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(995), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20784] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(722), 1,
      sym__discard_name,
    ACTIONS(926), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1746), 1,
      sym_hole,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(924), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1000), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20906] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(511), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(509), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20970] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(928), 1,
      anon_sym_LPAREN,
    STATE(283), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(383), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(381), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [21037] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(930), 1,
      anon_sym_RBRACK,
    ACTIONS(932), 1,
      anon_sym_DOT_DOT,
    ACTIONS(934), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21155] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(523), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(521), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [21217] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(936), 1,
      anon_sym_RBRACK,
    ACTIONS(938), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21335] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(565), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(563), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [21397] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(940), 1,
      anon_sym_RBRACK,
    ACTIONS(942), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21515] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(944), 1,
      anon_sym_RBRACK,
    ACTIONS(946), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21633] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(587), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(585), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [21695] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(527), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(525), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [21757] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(505), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(503), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [21819] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(389), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(387), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [21881] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(948), 1,
      anon_sym_RBRACK,
    ACTIONS(950), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21999] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(952), 1,
      anon_sym_RBRACK,
    ACTIONS(954), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22117] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(956), 1,
      anon_sym_RBRACK,
    ACTIONS(958), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22235] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(960), 1,
      anon_sym_RBRACK,
    ACTIONS(962), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22353] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(964), 1,
      anon_sym_RBRACK,
    ACTIONS(966), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22471] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(968), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1005), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22587] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(706), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(704), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22649] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(972), 1,
      anon_sym_RBRACK,
    ACTIONS(974), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22767] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(597), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(595), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22829] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(601), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(599), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22891] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(858), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(856), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22953] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(559), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(557), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23015] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(623), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(619), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23081] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(980), 1,
      anon_sym_RBRACK,
    ACTIONS(982), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23199] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(984), 1,
      anon_sym_RBRACK,
    ACTIONS(986), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23317] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(623), 1,
      anon_sym_LPAREN,
    ACTIONS(625), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(619), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23383] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(547), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(545), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23445] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(988), 1,
      anon_sym_RBRACK,
    ACTIONS(990), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23563] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(992), 1,
      anon_sym_RBRACK,
    ACTIONS(994), 1,
      anon_sym_DOT_DOT,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23681] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(996), 1,
      anon_sym_RPAREN,
    ACTIONS(998), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(942), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23796] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1008), 1,
      anon_sym_echo,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1014), 1,
      sym_float,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(650), 1,
      sym_pipeline_echo,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(652), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23911] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(654), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(619), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23974] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(640), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(619), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24037] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(623), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(621), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(619), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [24100] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1026), 1,
      anon_sym_echo,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1030), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(818), 1,
      sym_pipeline_echo,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1008), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24215] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1032), 1,
      anon_sym_RBRACK,
    ACTIONS(1034), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(911), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24330] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1036), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24445] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1038), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1895), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(929), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24560] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1040), 1,
      anon_sym_echo,
    ACTIONS(1042), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(588), 1,
      sym_pipeline_echo,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(586), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24675] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1038), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1883), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(929), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24790] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1044), 1,
      anon_sym_RBRACK,
    ACTIONS(1046), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(915), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24905] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1048), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25020] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(650), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25081] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1050), 1,
      anon_sym_RPAREN,
    ACTIONS(1052), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(963), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25196] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(658), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(656), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25257] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1038), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1866), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(929), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25372] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1054), 1,
      anon_sym_RPAREN,
    ACTIONS(1056), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(954), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25487] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1038), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1871), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(929), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25602] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1038), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1859), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(929), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25717] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1038), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    STATE(1845), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(929), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25832] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(690), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(688), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [25893] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1058), 1,
      anon_sym_RBRACK,
    ACTIONS(1060), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(923), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26008] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1038), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1828), 1,
      sym_case_subjects,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(929), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26123] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(676), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(674), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26184] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(672), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(670), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26245] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(668), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(666), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26306] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(648), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(646), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26367] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(644), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(642), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [26428] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1062), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26543] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1064), 1,
      anon_sym_echo,
    ACTIONS(1066), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(818), 1,
      sym_pipeline_echo,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(862), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26658] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1068), 1,
      anon_sym_RPAREN,
    ACTIONS(1070), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(933), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26773] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1072), 1,
      anon_sym_LBRACE,
    ACTIONS(1074), 1,
      anon_sym_POUND,
    ACTIONS(1076), 1,
      anon_sym_LBRACK,
    ACTIONS(1078), 1,
      anon_sym_LT_LT,
    ACTIONS(1080), 1,
      anon_sym_DASH,
    ACTIONS(1082), 1,
      anon_sym_fn,
    ACTIONS(1084), 1,
      anon_sym_todo,
    ACTIONS(1086), 1,
      anon_sym_panic,
    ACTIONS(1088), 1,
      anon_sym_echo,
    ACTIONS(1090), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_assert,
    ACTIONS(1094), 1,
      anon_sym_BANG,
    ACTIONS(1096), 1,
      anon_sym_DQUOTE,
    ACTIONS(1098), 1,
      sym_float,
    ACTIONS(1102), 1,
      sym__decimal,
    ACTIONS(1104), 1,
      sym__name,
    ACTIONS(1106), 1,
      sym__upname,
    STATE(70), 1,
      sym_identifier,
    STATE(80), 1,
      sym_anonymous_function,
    STATE(85), 1,
      sym_tuple,
    STATE(135), 1,
      sym_pipeline_echo,
    STATE(1719), 1,
      sym__maybe_function_expression,
    STATE(1856), 1,
      sym__maybe_record_expression,
    STATE(1957), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(92), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1100), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(66), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(147), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26888] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1108), 1,
      anon_sym_fn,
    ACTIONS(1110), 1,
      anon_sym_echo,
    ACTIONS(1112), 1,
      sym_float,
    STATE(109), 1,
      sym_identifier,
    STATE(142), 1,
      sym_tuple,
    STATE(143), 1,
      sym_anonymous_function,
    STATE(203), 1,
      sym_pipeline_echo,
    STATE(1666), 1,
      sym__maybe_function_expression,
    STATE(1902), 1,
      sym__maybe_record_expression,
    STATE(1913), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(44), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(137), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(114), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(202), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27003] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1114), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27118] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1116), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27233] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(219), 1,
      anon_sym_LBRACE,
    ACTIONS(221), 1,
      anon_sym_POUND,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    ACTIONS(225), 1,
      anon_sym_LT_LT,
    ACTIONS(227), 1,
      anon_sym_fn,
    ACTIONS(229), 1,
      anon_sym_todo,
    ACTIONS(231), 1,
      anon_sym_panic,
    ACTIONS(235), 1,
      anon_sym_case,
    ACTIONS(237), 1,
      anon_sym_assert,
    ACTIONS(241), 1,
      anon_sym_DQUOTE,
    ACTIONS(247), 1,
      sym__decimal,
    ACTIONS(249), 1,
      sym__name,
    ACTIONS(251), 1,
      sym__upname,
    ACTIONS(1118), 1,
      anon_sym_DASH,
    ACTIONS(1120), 1,
      anon_sym_echo,
    ACTIONS(1122), 1,
      anon_sym_BANG,
    ACTIONS(1124), 1,
      sym_float,
    STATE(937), 1,
      sym_identifier,
    STATE(998), 1,
      sym_anonymous_function,
    STATE(1006), 1,
      sym_tuple,
    STATE(1078), 1,
      sym_pipeline_echo,
    STATE(1755), 1,
      sym__maybe_function_expression,
    STATE(1836), 1,
      sym__maybe_tuple_expression,
    STATE(1892), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(909), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(967), 2,
      sym_record,
      sym_record_update,
    ACTIONS(245), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(938), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1077), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27348] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1126), 1,
      anon_sym_RPAREN,
    ACTIONS(1128), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(931), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27463] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1130), 1,
      anon_sym_RBRACK,
    ACTIONS(1132), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(899), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27578] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1134), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27693] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1136), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27808] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1138), 1,
      anon_sym_RPAREN,
    ACTIONS(1140), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(939), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27923] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1142), 1,
      anon_sym_RBRACK,
    ACTIONS(1144), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(898), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28038] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1146), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28153] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1148), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28268] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1150), 1,
      anon_sym_LPAREN,
    STATE(506), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(383), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(381), 27,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28333] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1152), 1,
      anon_sym_LBRACE,
    ACTIONS(1154), 1,
      anon_sym_POUND,
    ACTIONS(1156), 1,
      anon_sym_LBRACK,
    ACTIONS(1158), 1,
      anon_sym_LT_LT,
    ACTIONS(1160), 1,
      anon_sym_DASH,
    ACTIONS(1162), 1,
      anon_sym_fn,
    ACTIONS(1164), 1,
      anon_sym_todo,
    ACTIONS(1166), 1,
      anon_sym_panic,
    ACTIONS(1168), 1,
      anon_sym_echo,
    ACTIONS(1170), 1,
      anon_sym_case,
    ACTIONS(1172), 1,
      anon_sym_assert,
    ACTIONS(1174), 1,
      anon_sym_BANG,
    ACTIONS(1176), 1,
      anon_sym_DQUOTE,
    ACTIONS(1178), 1,
      sym_float,
    ACTIONS(1182), 1,
      sym__decimal,
    ACTIONS(1184), 1,
      sym__name,
    ACTIONS(1186), 1,
      sym__upname,
    STATE(497), 1,
      sym_identifier,
    STATE(510), 1,
      sym_tuple,
    STATE(511), 1,
      sym_anonymous_function,
    STATE(550), 1,
      sym_pipeline_echo,
    STATE(1686), 1,
      sym__maybe_function_expression,
    STATE(1868), 1,
      sym__maybe_record_expression,
    STATE(1936), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(315), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(507), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1180), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(498), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(548), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28448] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1188), 1,
      anon_sym_RBRACK,
    ACTIONS(1190), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(906), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28563] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1192), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28678] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1194), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28793] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1196), 1,
      anon_sym_RPAREN,
    ACTIONS(1198), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(943), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28908] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1200), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29023] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1202), 1,
      anon_sym_RBRACK,
    ACTIONS(1204), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(910), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29138] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1206), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29253] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1208), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29368] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1210), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(869), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29480] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(219), 1,
      anon_sym_LBRACE,
    ACTIONS(221), 1,
      anon_sym_POUND,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    ACTIONS(225), 1,
      anon_sym_LT_LT,
    ACTIONS(227), 1,
      anon_sym_fn,
    ACTIONS(229), 1,
      anon_sym_todo,
    ACTIONS(231), 1,
      anon_sym_panic,
    ACTIONS(233), 1,
      anon_sym_echo,
    ACTIONS(235), 1,
      anon_sym_case,
    ACTIONS(237), 1,
      anon_sym_assert,
    ACTIONS(241), 1,
      anon_sym_DQUOTE,
    ACTIONS(247), 1,
      sym__decimal,
    ACTIONS(249), 1,
      sym__name,
    ACTIONS(251), 1,
      sym__upname,
    ACTIONS(1118), 1,
      anon_sym_DASH,
    ACTIONS(1122), 1,
      anon_sym_BANG,
    ACTIONS(1212), 1,
      sym_float,
    STATE(937), 1,
      sym_identifier,
    STATE(998), 1,
      sym_anonymous_function,
    STATE(1006), 1,
      sym_tuple,
    STATE(1755), 1,
      sym__maybe_function_expression,
    STATE(1836), 1,
      sym__maybe_tuple_expression,
    STATE(1892), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(909), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(967), 2,
      sym_record,
      sym_record_update,
    ACTIONS(245), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(938), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1030), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29592] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1214), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(864), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29704] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1216), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(585), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29816] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1218), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(872), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29928] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1108), 1,
      anon_sym_fn,
    ACTIONS(1220), 1,
      sym_float,
    STATE(109), 1,
      sym_identifier,
    STATE(142), 1,
      sym_tuple,
    STATE(143), 1,
      sym_anonymous_function,
    STATE(1666), 1,
      sym__maybe_function_expression,
    STATE(1902), 1,
      sym__maybe_record_expression,
    STATE(1913), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(44), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(137), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(114), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(215), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30040] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1222), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1026), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30152] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1224), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30264] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1226), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(849), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30376] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1228), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1032), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30488] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1230), 1,
      anon_sym_GT_GT,
    ACTIONS(1232), 1,
      anon_sym_DASH,
    ACTIONS(1234), 1,
      anon_sym_todo,
    ACTIONS(1236), 1,
      anon_sym_panic,
    ACTIONS(1238), 1,
      anon_sym_assert,
    ACTIONS(1240), 1,
      anon_sym_BANG,
    ACTIONS(1242), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1730), 1,
      sym_expression_bit_string_segment,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1925), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1528), 11,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30604] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1244), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(874), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30716] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1246), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1035), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30828] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1232), 1,
      anon_sym_DASH,
    ACTIONS(1234), 1,
      anon_sym_todo,
    ACTIONS(1236), 1,
      anon_sym_panic,
    ACTIONS(1238), 1,
      anon_sym_assert,
    ACTIONS(1240), 1,
      anon_sym_BANG,
    ACTIONS(1242), 1,
      sym_float,
    ACTIONS(1248), 1,
      anon_sym_GT_GT,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1730), 1,
      sym_expression_bit_string_segment,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1925), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1528), 11,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30944] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1232), 1,
      anon_sym_DASH,
    ACTIONS(1234), 1,
      anon_sym_todo,
    ACTIONS(1236), 1,
      anon_sym_panic,
    ACTIONS(1238), 1,
      anon_sym_assert,
    ACTIONS(1240), 1,
      anon_sym_BANG,
    ACTIONS(1242), 1,
      sym_float,
    ACTIONS(1250), 1,
      anon_sym_GT_GT,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1730), 1,
      sym_expression_bit_string_segment,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1925), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1528), 11,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31060] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1252), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1055), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31172] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1232), 1,
      anon_sym_DASH,
    ACTIONS(1234), 1,
      anon_sym_todo,
    ACTIONS(1236), 1,
      anon_sym_panic,
    ACTIONS(1238), 1,
      anon_sym_assert,
    ACTIONS(1240), 1,
      anon_sym_BANG,
    ACTIONS(1242), 1,
      sym_float,
    ACTIONS(1254), 1,
      anon_sym_GT_GT,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1530), 1,
      sym_expression_bit_string_segment,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1925), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1528), 11,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31288] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(804), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(802), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31348] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1256), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(871), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31460] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(846), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(844), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31520] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1258), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(636), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31632] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(821), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(818), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31692] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(796), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(794), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31752] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1260), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(795), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31864] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1262), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(580), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31976] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1264), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(579), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32088] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1266), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(853), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32200] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(800), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(798), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32260] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1268), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(576), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32372] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(571), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(569), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32432] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(792), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(790), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32492] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1270), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(863), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32604] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1272), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1025), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32716] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(93), 1,
      sym_float,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(861), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32828] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(854), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(852), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32888] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1232), 1,
      anon_sym_DASH,
    ACTIONS(1234), 1,
      anon_sym_todo,
    ACTIONS(1236), 1,
      anon_sym_panic,
    ACTIONS(1238), 1,
      anon_sym_assert,
    ACTIONS(1240), 1,
      anon_sym_BANG,
    ACTIONS(1242), 1,
      sym_float,
    ACTIONS(1274), 1,
      anon_sym_GT_GT,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1730), 1,
      sym_expression_bit_string_segment,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1925), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1528), 11,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33004] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1276), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(575), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33116] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(838), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(836), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33176] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1278), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(574), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33288] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1280), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(577), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33400] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1282), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(581), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33512] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1284), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(583), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33624] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1286), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(573), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33736] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1288), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1080), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33848] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1290), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1036), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33960] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1292), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(644), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34072] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1294), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1034), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34184] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1232), 1,
      anon_sym_DASH,
    ACTIONS(1234), 1,
      anon_sym_todo,
    ACTIONS(1236), 1,
      anon_sym_panic,
    ACTIONS(1238), 1,
      anon_sym_assert,
    ACTIONS(1240), 1,
      anon_sym_BANG,
    ACTIONS(1242), 1,
      sym_float,
    ACTIONS(1296), 1,
      anon_sym_GT_GT,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1568), 1,
      sym_expression_bit_string_segment,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1925), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1528), 11,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34300] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1072), 1,
      anon_sym_LBRACE,
    ACTIONS(1074), 1,
      anon_sym_POUND,
    ACTIONS(1076), 1,
      anon_sym_LBRACK,
    ACTIONS(1078), 1,
      anon_sym_LT_LT,
    ACTIONS(1080), 1,
      anon_sym_DASH,
    ACTIONS(1082), 1,
      anon_sym_fn,
    ACTIONS(1084), 1,
      anon_sym_todo,
    ACTIONS(1086), 1,
      anon_sym_panic,
    ACTIONS(1090), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_assert,
    ACTIONS(1094), 1,
      anon_sym_BANG,
    ACTIONS(1096), 1,
      anon_sym_DQUOTE,
    ACTIONS(1102), 1,
      sym__decimal,
    ACTIONS(1104), 1,
      sym__name,
    ACTIONS(1106), 1,
      sym__upname,
    ACTIONS(1298), 1,
      anon_sym_echo,
    ACTIONS(1300), 1,
      sym_float,
    STATE(70), 1,
      sym_identifier,
    STATE(80), 1,
      sym_anonymous_function,
    STATE(85), 1,
      sym_tuple,
    STATE(1719), 1,
      sym__maybe_function_expression,
    STATE(1856), 1,
      sym__maybe_record_expression,
    STATE(1957), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(92), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1100), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(66), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(163), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34412] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1108), 1,
      anon_sym_fn,
    ACTIONS(1302), 1,
      sym_float,
    STATE(109), 1,
      sym_identifier,
    STATE(142), 1,
      sym_tuple,
    STATE(143), 1,
      sym_anonymous_function,
    STATE(1666), 1,
      sym__maybe_function_expression,
    STATE(1902), 1,
      sym__maybe_record_expression,
    STATE(1913), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(44), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(137), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(114), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(201), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34524] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1304), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1027), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34636] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(850), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(848), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34696] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(842), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(840), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34756] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1306), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1015), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34868] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1308), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1013), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [34980] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1108), 1,
      anon_sym_fn,
    ACTIONS(1310), 1,
      sym_float,
    STATE(109), 1,
      sym_identifier,
    STATE(142), 1,
      sym_tuple,
    STATE(143), 1,
      sym_anonymous_function,
    STATE(1666), 1,
      sym__maybe_function_expression,
    STATE(1902), 1,
      sym__maybe_record_expression,
    STATE(1913), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(44), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(137), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(114), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(179), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35092] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1312), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1012), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35204] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1314), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(653), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35316] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1232), 1,
      anon_sym_DASH,
    ACTIONS(1234), 1,
      anon_sym_todo,
    ACTIONS(1236), 1,
      anon_sym_panic,
    ACTIONS(1238), 1,
      anon_sym_assert,
    ACTIONS(1240), 1,
      anon_sym_BANG,
    ACTIONS(1242), 1,
      sym_float,
    ACTIONS(1316), 1,
      anon_sym_GT_GT,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1730), 1,
      sym_expression_bit_string_segment,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1925), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1528), 11,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35432] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1108), 1,
      anon_sym_fn,
    ACTIONS(1318), 1,
      sym_float,
    STATE(109), 1,
      sym_identifier,
    STATE(142), 1,
      sym_tuple,
    STATE(143), 1,
      sym_anonymous_function,
    STATE(1666), 1,
      sym__maybe_function_expression,
    STATE(1902), 1,
      sym__maybe_record_expression,
    STATE(1913), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(44), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(137), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(114), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(181), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35544] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1320), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1072), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35656] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(918), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35768] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1322), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1073), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35880] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1324), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(631), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [35992] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1326), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(654), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36104] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1328), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(630), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36216] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1330), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1017), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36328] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1332), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(655), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36440] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1334), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(656), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36552] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1336), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1020), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36664] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1338), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(578), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36776] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1232), 1,
      anon_sym_DASH,
    ACTIONS(1234), 1,
      anon_sym_todo,
    ACTIONS(1236), 1,
      anon_sym_panic,
    ACTIONS(1238), 1,
      anon_sym_assert,
    ACTIONS(1240), 1,
      anon_sym_BANG,
    ACTIONS(1242), 1,
      sym_float,
    ACTIONS(1340), 1,
      anon_sym_GT_GT,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1632), 1,
      sym_expression_bit_string_segment,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1925), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1528), 11,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [36892] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1342), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1021), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37004] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1344), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1059), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37116] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(401), 1,
      anon_sym_DASH,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(405), 1,
      anon_sym_todo,
    ACTIONS(407), 1,
      anon_sym_panic,
    ACTIONS(409), 1,
      anon_sym_echo,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(415), 1,
      anon_sym_assert,
    ACTIONS(419), 1,
      anon_sym_BANG,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1346), 1,
      sym_float,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1830), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(589), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37228] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1348), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(661), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37340] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1350), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(663), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37452] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1352), 1,
      anon_sym_LBRACE,
    ACTIONS(1355), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1003), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37564] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1357), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1063), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37676] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1359), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1087), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37788] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1361), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(984), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [37900] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1363), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(983), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38012] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1108), 1,
      anon_sym_fn,
    ACTIONS(1365), 1,
      sym_float,
    STATE(109), 1,
      sym_identifier,
    STATE(142), 1,
      sym_tuple,
    STATE(143), 1,
      sym_anonymous_function,
    STATE(1666), 1,
      sym__maybe_function_expression,
    STATE(1902), 1,
      sym__maybe_record_expression,
    STATE(1913), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(44), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(137), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(114), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(189), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38124] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1367), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(982), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38236] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1072), 1,
      anon_sym_LBRACE,
    ACTIONS(1074), 1,
      anon_sym_POUND,
    ACTIONS(1076), 1,
      anon_sym_LBRACK,
    ACTIONS(1078), 1,
      anon_sym_LT_LT,
    ACTIONS(1080), 1,
      anon_sym_DASH,
    ACTIONS(1082), 1,
      anon_sym_fn,
    ACTIONS(1084), 1,
      anon_sym_todo,
    ACTIONS(1086), 1,
      anon_sym_panic,
    ACTIONS(1090), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_assert,
    ACTIONS(1094), 1,
      anon_sym_BANG,
    ACTIONS(1096), 1,
      anon_sym_DQUOTE,
    ACTIONS(1102), 1,
      sym__decimal,
    ACTIONS(1104), 1,
      sym__name,
    ACTIONS(1106), 1,
      sym__upname,
    ACTIONS(1298), 1,
      anon_sym_echo,
    ACTIONS(1369), 1,
      sym_float,
    STATE(70), 1,
      sym_identifier,
    STATE(80), 1,
      sym_anonymous_function,
    STATE(85), 1,
      sym_tuple,
    STATE(1719), 1,
      sym__maybe_function_expression,
    STATE(1856), 1,
      sym__maybe_record_expression,
    STATE(1957), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(92), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1100), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(66), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(165), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38348] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1072), 1,
      anon_sym_LBRACE,
    ACTIONS(1074), 1,
      anon_sym_POUND,
    ACTIONS(1076), 1,
      anon_sym_LBRACK,
    ACTIONS(1078), 1,
      anon_sym_LT_LT,
    ACTIONS(1080), 1,
      anon_sym_DASH,
    ACTIONS(1082), 1,
      anon_sym_fn,
    ACTIONS(1084), 1,
      anon_sym_todo,
    ACTIONS(1086), 1,
      anon_sym_panic,
    ACTIONS(1090), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_assert,
    ACTIONS(1094), 1,
      anon_sym_BANG,
    ACTIONS(1096), 1,
      anon_sym_DQUOTE,
    ACTIONS(1102), 1,
      sym__decimal,
    ACTIONS(1104), 1,
      sym__name,
    ACTIONS(1106), 1,
      sym__upname,
    ACTIONS(1298), 1,
      anon_sym_echo,
    ACTIONS(1371), 1,
      sym_float,
    STATE(70), 1,
      sym_identifier,
    STATE(80), 1,
      sym_anonymous_function,
    STATE(85), 1,
      sym_tuple,
    STATE(1719), 1,
      sym__maybe_function_expression,
    STATE(1856), 1,
      sym__maybe_record_expression,
    STATE(1957), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(92), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1100), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(66), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(164), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38460] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1072), 1,
      anon_sym_LBRACE,
    ACTIONS(1074), 1,
      anon_sym_POUND,
    ACTIONS(1076), 1,
      anon_sym_LBRACK,
    ACTIONS(1078), 1,
      anon_sym_LT_LT,
    ACTIONS(1080), 1,
      anon_sym_DASH,
    ACTIONS(1082), 1,
      anon_sym_fn,
    ACTIONS(1084), 1,
      anon_sym_todo,
    ACTIONS(1086), 1,
      anon_sym_panic,
    ACTIONS(1090), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_assert,
    ACTIONS(1094), 1,
      anon_sym_BANG,
    ACTIONS(1096), 1,
      anon_sym_DQUOTE,
    ACTIONS(1102), 1,
      sym__decimal,
    ACTIONS(1104), 1,
      sym__name,
    ACTIONS(1106), 1,
      sym__upname,
    ACTIONS(1298), 1,
      anon_sym_echo,
    ACTIONS(1373), 1,
      sym_float,
    STATE(70), 1,
      sym_identifier,
    STATE(80), 1,
      sym_anonymous_function,
    STATE(85), 1,
      sym_tuple,
    STATE(1719), 1,
      sym__maybe_function_expression,
    STATE(1856), 1,
      sym__maybe_record_expression,
    STATE(1957), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(92), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1100), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(66), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(162), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38572] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1072), 1,
      anon_sym_LBRACE,
    ACTIONS(1074), 1,
      anon_sym_POUND,
    ACTIONS(1076), 1,
      anon_sym_LBRACK,
    ACTIONS(1078), 1,
      anon_sym_LT_LT,
    ACTIONS(1080), 1,
      anon_sym_DASH,
    ACTIONS(1082), 1,
      anon_sym_fn,
    ACTIONS(1084), 1,
      anon_sym_todo,
    ACTIONS(1086), 1,
      anon_sym_panic,
    ACTIONS(1090), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_assert,
    ACTIONS(1094), 1,
      anon_sym_BANG,
    ACTIONS(1096), 1,
      anon_sym_DQUOTE,
    ACTIONS(1102), 1,
      sym__decimal,
    ACTIONS(1104), 1,
      sym__name,
    ACTIONS(1106), 1,
      sym__upname,
    ACTIONS(1298), 1,
      anon_sym_echo,
    ACTIONS(1375), 1,
      sym_float,
    STATE(70), 1,
      sym_identifier,
    STATE(80), 1,
      sym_anonymous_function,
    STATE(85), 1,
      sym_tuple,
    STATE(1719), 1,
      sym__maybe_function_expression,
    STATE(1856), 1,
      sym__maybe_record_expression,
    STATE(1957), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(92), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1100), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(66), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(151), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38684] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(613), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(611), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [38744] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(609), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(607), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [38804] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(391), 1,
      anon_sym_LBRACE,
    ACTIONS(395), 1,
      anon_sym_POUND,
    ACTIONS(397), 1,
      anon_sym_LBRACK,
    ACTIONS(399), 1,
      anon_sym_LT_LT,
    ACTIONS(403), 1,
      anon_sym_fn,
    ACTIONS(411), 1,
      anon_sym_case,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      sym__decimal,
    ACTIONS(429), 1,
      sym__name,
    ACTIONS(431), 1,
      sym__upname,
    ACTIONS(1232), 1,
      anon_sym_DASH,
    ACTIONS(1234), 1,
      anon_sym_todo,
    ACTIONS(1236), 1,
      anon_sym_panic,
    ACTIONS(1238), 1,
      anon_sym_assert,
    ACTIONS(1240), 1,
      anon_sym_BANG,
    ACTIONS(1242), 1,
      sym_float,
    ACTIONS(1377), 1,
      anon_sym_GT_GT,
    STATE(263), 1,
      sym_identifier,
    STATE(273), 1,
      sym_tuple,
    STATE(274), 1,
      sym_anonymous_function,
    STATE(1730), 1,
      sym_expression_bit_string_segment,
    STATE(1805), 1,
      sym__maybe_function_expression,
    STATE(1817), 1,
      sym__maybe_record_expression,
    STATE(1925), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(240), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(272), 2,
      sym_record,
      sym_record_update,
    ACTIONS(425), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(266), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1528), 11,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [38920] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(605), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(603), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [38980] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1379), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(662), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39092] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1072), 1,
      anon_sym_LBRACE,
    ACTIONS(1074), 1,
      anon_sym_POUND,
    ACTIONS(1076), 1,
      anon_sym_LBRACK,
    ACTIONS(1078), 1,
      anon_sym_LT_LT,
    ACTIONS(1080), 1,
      anon_sym_DASH,
    ACTIONS(1082), 1,
      anon_sym_fn,
    ACTIONS(1084), 1,
      anon_sym_todo,
    ACTIONS(1086), 1,
      anon_sym_panic,
    ACTIONS(1090), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_assert,
    ACTIONS(1094), 1,
      anon_sym_BANG,
    ACTIONS(1096), 1,
      anon_sym_DQUOTE,
    ACTIONS(1102), 1,
      sym__decimal,
    ACTIONS(1104), 1,
      sym__name,
    ACTIONS(1106), 1,
      sym__upname,
    ACTIONS(1298), 1,
      anon_sym_echo,
    ACTIONS(1381), 1,
      sym_float,
    STATE(70), 1,
      sym_identifier,
    STATE(80), 1,
      sym_anonymous_function,
    STATE(85), 1,
      sym_tuple,
    STATE(1719), 1,
      sym__maybe_function_expression,
    STATE(1856), 1,
      sym__maybe_record_expression,
    STATE(1957), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(92), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1100), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(66), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(150), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39204] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1383), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(668), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39316] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1072), 1,
      anon_sym_LBRACE,
    ACTIONS(1074), 1,
      anon_sym_POUND,
    ACTIONS(1076), 1,
      anon_sym_LBRACK,
    ACTIONS(1078), 1,
      anon_sym_LT_LT,
    ACTIONS(1080), 1,
      anon_sym_DASH,
    ACTIONS(1082), 1,
      anon_sym_fn,
    ACTIONS(1084), 1,
      anon_sym_todo,
    ACTIONS(1086), 1,
      anon_sym_panic,
    ACTIONS(1090), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_assert,
    ACTIONS(1094), 1,
      anon_sym_BANG,
    ACTIONS(1096), 1,
      anon_sym_DQUOTE,
    ACTIONS(1102), 1,
      sym__decimal,
    ACTIONS(1104), 1,
      sym__name,
    ACTIONS(1106), 1,
      sym__upname,
    ACTIONS(1298), 1,
      anon_sym_echo,
    ACTIONS(1385), 1,
      sym_float,
    STATE(70), 1,
      sym_identifier,
    STATE(80), 1,
      sym_anonymous_function,
    STATE(85), 1,
      sym_tuple,
    STATE(1719), 1,
      sym__maybe_function_expression,
    STATE(1856), 1,
      sym__maybe_record_expression,
    STATE(1957), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(92), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1100), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(66), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(149), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39428] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1387), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1058), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39540] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1389), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(981), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39652] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1391), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(980), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39764] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1393), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(979), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [39876] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(389), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(387), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [39936] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1395), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(976), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40048] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1397), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(975), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40160] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(587), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(585), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [40220] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(207), 1,
      anon_sym_todo,
    ACTIONS(209), 1,
      anon_sym_panic,
    ACTIONS(211), 1,
      anon_sym_echo,
    ACTIONS(213), 1,
      anon_sym_assert,
    ACTIONS(1024), 1,
      anon_sym_DASH,
    ACTIONS(1028), 1,
      anon_sym_BANG,
    ACTIONS(1355), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1003), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40332] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(565), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(563), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [40392] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1399), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1019), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40504] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1401), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1037), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40616] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1108), 1,
      anon_sym_fn,
    ACTIONS(1403), 1,
      sym_float,
    STATE(109), 1,
      sym_identifier,
    STATE(142), 1,
      sym_tuple,
    STATE(143), 1,
      sym_anonymous_function,
    STATE(1666), 1,
      sym__maybe_function_expression,
    STATE(1902), 1,
      sym__maybe_record_expression,
    STATE(1913), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(44), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(137), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(114), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(195), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40728] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1072), 1,
      anon_sym_LBRACE,
    ACTIONS(1074), 1,
      anon_sym_POUND,
    ACTIONS(1076), 1,
      anon_sym_LBRACK,
    ACTIONS(1078), 1,
      anon_sym_LT_LT,
    ACTIONS(1080), 1,
      anon_sym_DASH,
    ACTIONS(1082), 1,
      anon_sym_fn,
    ACTIONS(1084), 1,
      anon_sym_todo,
    ACTIONS(1086), 1,
      anon_sym_panic,
    ACTIONS(1090), 1,
      anon_sym_case,
    ACTIONS(1092), 1,
      anon_sym_assert,
    ACTIONS(1094), 1,
      anon_sym_BANG,
    ACTIONS(1096), 1,
      anon_sym_DQUOTE,
    ACTIONS(1102), 1,
      sym__decimal,
    ACTIONS(1104), 1,
      sym__name,
    ACTIONS(1106), 1,
      sym__upname,
    ACTIONS(1298), 1,
      anon_sym_echo,
    ACTIONS(1405), 1,
      sym_float,
    STATE(70), 1,
      sym_identifier,
    STATE(80), 1,
      sym_anonymous_function,
    STATE(85), 1,
      sym_tuple,
    STATE(1719), 1,
      sym__maybe_function_expression,
    STATE(1856), 1,
      sym__maybe_record_expression,
    STATE(1957), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(14), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(92), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1100), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(66), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(144), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40840] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1108), 1,
      anon_sym_fn,
    ACTIONS(1407), 1,
      sym_float,
    STATE(109), 1,
      sym_identifier,
    STATE(142), 1,
      sym_tuple,
    STATE(143), 1,
      sym_anonymous_function,
    STATE(1666), 1,
      sym__maybe_function_expression,
    STATE(1902), 1,
      sym__maybe_record_expression,
    STATE(1913), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(44), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(137), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(114), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(196), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [40952] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(559), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(557), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [41012] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1152), 1,
      anon_sym_LBRACE,
    ACTIONS(1154), 1,
      anon_sym_POUND,
    ACTIONS(1156), 1,
      anon_sym_LBRACK,
    ACTIONS(1158), 1,
      anon_sym_LT_LT,
    ACTIONS(1160), 1,
      anon_sym_DASH,
    ACTIONS(1162), 1,
      anon_sym_fn,
    ACTIONS(1164), 1,
      anon_sym_todo,
    ACTIONS(1166), 1,
      anon_sym_panic,
    ACTIONS(1170), 1,
      anon_sym_case,
    ACTIONS(1172), 1,
      anon_sym_assert,
    ACTIONS(1174), 1,
      anon_sym_BANG,
    ACTIONS(1176), 1,
      anon_sym_DQUOTE,
    ACTIONS(1182), 1,
      sym__decimal,
    ACTIONS(1184), 1,
      sym__name,
    ACTIONS(1186), 1,
      sym__upname,
    ACTIONS(1409), 1,
      anon_sym_echo,
    ACTIONS(1411), 1,
      sym_float,
    STATE(497), 1,
      sym_identifier,
    STATE(510), 1,
      sym_tuple,
    STATE(511), 1,
      sym_anonymous_function,
    STATE(1686), 1,
      sym__maybe_function_expression,
    STATE(1868), 1,
      sym__maybe_record_expression,
    STATE(1936), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(315), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(507), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1180), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(498), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(524), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41124] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1108), 1,
      anon_sym_fn,
    ACTIONS(1413), 1,
      sym_float,
    STATE(109), 1,
      sym_identifier,
    STATE(142), 1,
      sym_tuple,
    STATE(143), 1,
      sym_anonymous_function,
    STATE(1666), 1,
      sym__maybe_function_expression,
    STATE(1902), 1,
      sym__maybe_record_expression,
    STATE(1913), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(44), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(137), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(114), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(177), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41236] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(547), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(545), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [41296] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1108), 1,
      anon_sym_fn,
    ACTIONS(1415), 1,
      sym_float,
    STATE(109), 1,
      sym_identifier,
    STATE(142), 1,
      sym_tuple,
    STATE(143), 1,
      sym_anonymous_function,
    STATE(1666), 1,
      sym__maybe_function_expression,
    STATE(1902), 1,
      sym__maybe_record_expression,
    STATE(1913), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(44), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(137), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(114), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(198), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41408] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1108), 1,
      anon_sym_fn,
    ACTIONS(1417), 1,
      sym_float,
    STATE(109), 1,
      sym_identifier,
    STATE(142), 1,
      sym_tuple,
    STATE(143), 1,
      sym_anonymous_function,
    STATE(1666), 1,
      sym__maybe_function_expression,
    STATE(1902), 1,
      sym__maybe_record_expression,
    STATE(1913), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(44), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(137), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(114), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(199), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41520] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(191), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_fn,
    ACTIONS(195), 1,
      anon_sym_todo,
    ACTIONS(197), 1,
      anon_sym_panic,
    ACTIONS(199), 1,
      anon_sym_echo,
    ACTIONS(201), 1,
      anon_sym_case,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(1000), 1,
      anon_sym_POUND,
    ACTIONS(1002), 1,
      anon_sym_LBRACK,
    ACTIONS(1004), 1,
      anon_sym_LT_LT,
    ACTIONS(1006), 1,
      anon_sym_DASH,
    ACTIONS(1010), 1,
      anon_sym_BANG,
    ACTIONS(1012), 1,
      anon_sym_DQUOTE,
    ACTIONS(1018), 1,
      sym__decimal,
    ACTIONS(1020), 1,
      sym__name,
    ACTIONS(1022), 1,
      sym__upname,
    ACTIONS(1419), 1,
      sym_float,
    STATE(615), 1,
      sym_identifier,
    STATE(628), 1,
      sym_anonymous_function,
    STATE(629), 1,
      sym_tuple,
    STATE(1713), 1,
      sym__maybe_function_expression,
    STATE(1880), 1,
      sym__maybe_record_expression,
    STATE(1886), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(597), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(620), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1016), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(598), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(660), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41632] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS(83), 1,
      anon_sym_echo,
    ACTIONS(85), 1,
      anon_sym_case,
    ACTIONS(87), 1,
      anon_sym_assert,
    ACTIONS(91), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__decimal,
    ACTIONS(99), 1,
      sym__name,
    ACTIONS(101), 1,
      sym__upname,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(718), 1,
      anon_sym_BANG,
    ACTIONS(1421), 1,
      sym_float,
    STATE(696), 1,
      sym_identifier,
    STATE(743), 1,
      sym_tuple,
    STATE(744), 1,
      sym_anonymous_function,
    STATE(1808), 1,
      sym__maybe_function_expression,
    STATE(1819), 1,
      sym__maybe_tuple_expression,
    STATE(1842), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(686), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(740), 2,
      sym_record,
      sym_record_update,
    ACTIONS(95), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(705), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1029), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41744] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(788), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(786), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [41804] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_echo,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(1108), 1,
      anon_sym_fn,
    ACTIONS(1423), 1,
      sym_float,
    STATE(109), 1,
      sym_identifier,
    STATE(142), 1,
      sym_tuple,
    STATE(143), 1,
      sym_anonymous_function,
    STATE(1666), 1,
      sym__maybe_function_expression,
    STATE(1902), 1,
      sym__maybe_record_expression,
    STATE(1913), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(44), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(137), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(114), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(200), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [41916] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(219), 1,
      anon_sym_LBRACE,
    ACTIONS(221), 1,
      anon_sym_POUND,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    ACTIONS(225), 1,
      anon_sym_LT_LT,
    ACTIONS(227), 1,
      anon_sym_fn,
    ACTIONS(229), 1,
      anon_sym_todo,
    ACTIONS(231), 1,
      anon_sym_panic,
    ACTIONS(233), 1,
      anon_sym_echo,
    ACTIONS(235), 1,
      anon_sym_case,
    ACTIONS(237), 1,
      anon_sym_assert,
    ACTIONS(241), 1,
      anon_sym_DQUOTE,
    ACTIONS(247), 1,
      sym__decimal,
    ACTIONS(249), 1,
      sym__name,
    ACTIONS(251), 1,
      sym__upname,
    ACTIONS(1118), 1,
      anon_sym_DASH,
    ACTIONS(1122), 1,
      anon_sym_BANG,
    ACTIONS(1425), 1,
      sym_float,
    STATE(937), 1,
      sym_identifier,
    STATE(998), 1,
      sym_anonymous_function,
    STATE(1006), 1,
      sym_tuple,
    STATE(1755), 1,
      sym__maybe_function_expression,
    STATE(1836), 1,
      sym__maybe_tuple_expression,
    STATE(1892), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(909), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(967), 2,
      sym_record,
      sym_record_update,
    ACTIONS(245), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(938), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1014), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [42028] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(219), 1,
      anon_sym_LBRACE,
    ACTIONS(221), 1,
      anon_sym_POUND,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    ACTIONS(225), 1,
      anon_sym_LT_LT,
    ACTIONS(227), 1,
      anon_sym_fn,
    ACTIONS(229), 1,
      anon_sym_todo,
    ACTIONS(231), 1,
      anon_sym_panic,
    ACTIONS(233), 1,
      anon_sym_echo,
    ACTIONS(235), 1,
      anon_sym_case,
    ACTIONS(237), 1,
      anon_sym_assert,
    ACTIONS(241), 1,
      anon_sym_DQUOTE,
    ACTIONS(243), 1,
      sym_float,
    ACTIONS(247), 1,
      sym__decimal,
    ACTIONS(249), 1,
      sym__name,
    ACTIONS(251), 1,
      sym__upname,
    ACTIONS(1118), 1,
      anon_sym_DASH,
    ACTIONS(1122), 1,
      anon_sym_BANG,
    STATE(937), 1,
      sym_identifier,
    STATE(998), 1,
      sym_anonymous_function,
    STATE(1006), 1,
      sym_tuple,
    STATE(1755), 1,
      sym__maybe_function_expression,
    STATE(1836), 1,
      sym__maybe_tuple_expression,
    STATE(1892), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(909), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(967), 2,
      sym_record,
      sym_record_update,
    ACTIONS(245), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(938), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1052), 13,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_echo,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [42140] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(527), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(525), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [42200] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(505), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(503), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [42260] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(511), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(509), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [42320] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(523), 20,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_echo,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(521), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [42380] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_LT_LT,
    ACTIONS(77), 1,
      anon_sym_fn,
    ACTIONS(79), 1,
      anon_sym_todo,
    ACTIONS(81), 1,
      anon_sym_panic,
    ACTIONS