/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "engines/agds/detection.h"

namespace AGDS {

static const ADGameDescription gameDescriptions[] = {

	// Black Mirror Windows
	{
		"black-mirror",
		0,
		AD_ENTRY1s("gfx1.grp", "6665ce103cf12a362fd55f863d1ec9e6", 907820240),
		Common::EN_USA,
		Common::kPlatformWindows,
		ADGF_DROPPLATFORM,
		GUIO1(GUIO_NONE)},
	{"black-mirror",
	 0,
	 AD_ENTRY1s("gfx1.grp", "652f931f02c5a79fb9bcbe32abafbdf7", 907732355),
	 Common::RU_RUS,
	 Common::kPlatformWindows,
	 ADGF_DROPPLATFORM,
	 GUIO1(GUIO_NONE)},

	{"nibiru",
	 0,
	 AD_ENTRY1s("gfx1.grp", "40a7a88f77c35305b6aba0329ed8a9ac", 381768750),
	 Common::EN_USA,
	 Common::kPlatformWindows,
	 ADGF_DROPPLATFORM | AGDS_V2 | ADGF_UNSTABLE,
	 GUIO1(GUIO_NONE)},

	{"nibiru",
	 0,
	 AD_ENTRY1s("gfx1.grp", "c8e711bc01b16cd82849cbd996d02642", 381768360),
	 Common::RU_RUS,
	 Common::kPlatformWindows,
	 ADGF_DROPPLATFORM | AGDS_V2 | ADGF_UNSTABLE,
	 GUIO1(GUIO_NONE)},

	AD_TABLE_END_MARKER};

} // End of namespace AGDS
