// Code generated by 'ccgo -lmodernc.org/z/lib -o internal\minigzip_windows_arm64.go -trace-translation-units C:\Users\jnml\AppData\Local\Temp\go-generate-2743941486\cdb.json minigzip.exe', DO NOT EDIT.

package main

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"

	"modernc.org/libc"
	"modernc.org/libc/sys/types"
	"modernc.org/z/lib"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer
var _ *libc.TLS
var _ types.Size_t

func main() { libc.Start(main1) }

type ptrdiff_t = int64 /* <builtin>:3:26 */

type size_t = uint64 /* <builtin>:9:23 */

type wchar_t = uint16 /* <builtin>:15:24 */

type va_list = uintptr /* <builtin>:50:27 */

// ===---- __stddef_max_align_t.h - Definition of max_align_t for modules ---===
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===-----------------------------------------------------------------------===

// Define 'max_align_t' to match the GCC definition.
type max_align_t = struct {
	__clang_max_align_nonce1 int64
	__clang_max_align_nonce2 float64
} /* __stddef_max_align_t.h:24:3 */

// Some C libraries expect to see a wint_t here. Others (notably MinGW) will use
// __WINT_TYPE__ directly; accommodate both by requiring __need_wint_t

type z_size_t = size_t /* zconf.h:248:21 */

// Maximum value for memLevel in deflateInit2

// Maximum value for windowBits in deflateInit2 and inflateInit2.
// WARNING: reducing MAX_WBITS makes minigzip unable to extract .gz files
// created by gzip. (Files created by minigzip can still be extracted by
// gzip.)

// The memory requirements for deflate are (in bytes):
//             (1 << (windowBits+2)) +  (1 << (memLevel+9))
//  that is: 128K for windowBits=15  +  128K for memLevel = 8  (default values)
//  plus a few kilobytes for small objects. For example, if you want to reduce
//  the default memory requirements from 256K to 128K, compile with
//      make CFLAGS="-O -DMAX_WBITS=14 -DMAX_MEM_LEVEL=7"
//  Of course this will generally degrade compression (there's no free lunch).
//
//    The memory requirements for inflate are (in bytes) 1 << windowBits
//  that is, 32K for windowBits=15 (default value) plus about 7 kilobytes
//  for small objects.

// Type declarations

// The following definitions for FAR are needed only for MSDOS mixed
// model programming (small or medium model with some far allocations).
// This was tested only with MSC; for other MSDOS compilers you may have
// to define NO_MEMCPY in zutil.h.  If you don't need the mixed model,
// just define FAR to be empty.

// If building or using zlib as a DLL, define ZLIB_DLL.
// This is not mandatory, but it offers a little performance increase.
// If building or using zlib with the WINAPI/WINAPIV calling convention,
// define ZLIB_WINAPI.
// Caution: the standard ZLIB1.DLL is NOT compiled using ZLIB_WINAPI.

type Byte = uint8   /* zconf.h:391:24 */ // 8 bits
type uInt = uint32  /* zconf.h:393:24 */ // 16 bits or more
type uLong = uint32 /* zconf.h:394:24 */ // 32 bits or more

type Bytef = Byte   /* zconf.h:400:22 */
type charf = int8   /* zconf.h:402:19 */
type intf = int32   /* zconf.h:403:19 */
type uIntf = uInt   /* zconf.h:404:19 */
type uLongf = uLong /* zconf.h:405:19 */

type voidpc = uintptr /* zconf.h:408:23 */
type voidpf = uintptr /* zconf.h:409:23 */
type voidp = uintptr  /* zconf.h:410:23 */

//===---- limits.h - Standard header for integer sizes --------------------===* *
//  Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
//  See https://llvm.org/LICENSE.txt for license information.
//  SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
// \*===----------------------------------------------------------------------===

// The system's limits.h may, in turn, try to #include_next GCC's limits.h.
//    Avert this #include_next madness.

// System headers include a number of constants from POSIX in <limits.h>.
//    Include it if we're hosted.

// Many system headers try to "help us out" by defining these.  No really, we
//    know how big each datatype is.

// C90/99 5.2.4.2.1

// C2x 5.2.4.2.1
// FIXME: This is using the placeholder dates Clang produces for these macros
//    in C2x mode; switch to the correct values once they've been published.

// C99 5.2.4.2.1: Added long long.
//    C++11 18.3.3.2: same contents as the Standard C Library header <limits.h>.
//

// LONG_LONG_MIN/LONG_LONG_MAX/ULONG_LONG_MAX are a GNU extension.  It's too bad
//    that we don't have something like #pragma poison that could be used to
//    deprecate a macro - the code should just use LLONG_MAX and friends.
//

type z_crc_t = uint32 /* zconf.h:429:17 */

type ssize_t = int64 /* corecrt.h:45:35 */

type rsize_t = size_t /* corecrt.h:52:16 */

type intptr_t = int64 /* corecrt.h:62:35 */

type uintptr_t = uint64 /* corecrt.h:75:44 */

type wint_t = uint16   /* corecrt.h:106:24 */
type wctype_t = uint16 /* corecrt.h:107:24 */

type errno_t = int32 /* corecrt.h:113:13 */

type time_t = int64 /* corecrt.h:138:20 */

type threadlocaleinfostruct = struct {
	_locale_pctype      uintptr
	_locale_mb_cur_max  int32
	_locale_lc_codepage uint32
} /* corecrt.h:430:1 */

type pthreadlocinfo = uintptr /* corecrt.h:432:39 */
type pthreadmbcinfo = uintptr /* corecrt.h:433:36 */

type localeinfo_struct = struct {
	locinfo pthreadlocinfo
	mbcinfo pthreadmbcinfo
} /* corecrt.h:436:9 */

type _locale_tstruct = localeinfo_struct /* corecrt.h:439:3 */
type _locale_t = uintptr                 /* corecrt.h:439:19 */

type tagLC_ID = struct {
	wLanguage uint16
	wCountry  uint16
	wCodePage uint16
} /* corecrt.h:443:9 */

type LC_ID = tagLC_ID  /* corecrt.h:447:3 */
type LPLC_ID = uintptr /* corecrt.h:447:9 */

type threadlocinfo = threadlocaleinfostruct /* corecrt.h:482:3 */

type _ino_t = uint16 /* types.h:43:24 */
type ino_t = uint16  /* types.h:45:24 */

type _dev_t = uint32 /* types.h:51:22 */
type dev_t = uint32  /* types.h:53:22 */

type _pid_t = int64 /* types.h:63:17 */

type pid_t = _pid_t /* types.h:68:16 */

type _mode_t = uint16 /* types.h:74:24 */

type mode_t = _mode_t /* types.h:77:17 */

type _off_t = int32  /* _mingw_off_t.h:5:16 */
type off32_t = int32 /* _mingw_off_t.h:7:16 */

type _off64_t = int64 /* _mingw_off_t.h:13:39 */
type off64_t = int64  /* _mingw_off_t.h:15:39 */

type off_t = off64_t /* _mingw_off_t.h:24:17 */

type useconds_t = uint32 /* types.h:84:22 */

type timespec = struct {
	tv_sec  time_t
	tv_nsec int32
	_       [4]byte
} /* types.h:89:1 */

type itimerspec = struct {
	it_interval struct {
		tv_sec  time_t
		tv_nsec int32
		_       [4]byte
	}
	it_value struct {
		tv_sec  time_t
		tv_nsec int32
		_       [4]byte
	}
} /* types.h:94:1 */

type _sigset_t = uint64 /* types.h:104:28 */

// GCC always defines __va_copy, but does not define va_copy unless in c99 mode
// or -ansi is not specified, since it was not part of C90.

// ===---- stddef.h - Basic type definitions --------------------------------===
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===-----------------------------------------------------------------------===

// a little trick to accommodate both "#define _LARGEFILE64_SOURCE" and
// "#define _LARGEFILE64_SOURCE 1" as requesting 64-bit operations, (even
// though the former does not conform to the LFS document), but considering
// both "#undef _LARGEFILE64_SOURCE" and "#define _LARGEFILE64_SOURCE 0" as
// equivalently requesting no 64-bit operations

// MVS linker does not support external names larger than 8 bytes

//
//     The 'zlib' compression library provides in-memory compression and
//   decompression functions, including integrity checks of the uncompressed data.
//   This version of the library supports only one compression method (deflation)
//   but other algorithms will be added later and will have the same stream
//   interface.
//
//     Compression can be done in a single step if the buffers are large enough,
//   or can be done by repeated calls of the compression function.  In the latter
//   case, the application must provide more input and/or consume the output
//   (providing more output space) before each call.
//
//     The compressed data format used by default by the in-memory functions is
//   the zlib format, which is a zlib wrapper documented in RFC 1950, wrapped
//   around a deflate stream, which is itself documented in RFC 1951.
//
//     The library also supports reading and writing files in gzip (.gz) format
//   with an interface similar to that of stdio using the functions that start
//   with "gz".  The gzip format is different from the zlib format.  gzip is a
//   gzip wrapper, documented in RFC 1952, wrapped around a deflate stream.
//
//     This library can optionally read and write gzip and raw deflate streams in
//   memory as well.
//
//     The zlib format was designed to be compact and fast for use in memory
//   and on communications channels.  The gzip format was designed for single-
//   file compression on file systems, has a larger header than zlib to maintain
//   directory information, and uses a different, slower check method than zlib.
//
//     The library does not install any signal handler.  The decoder checks
//   the consistency of the compressed data, so the library should never crash
//   even in the case of corrupted input.

type alloc_func = uintptr /* zlib.h:81:16 */
type free_func = uintptr  /* zlib.h:82:16 */

type z_stream_s = struct {
	next_in   uintptr
	avail_in  uInt
	total_in  uLong
	next_out  uintptr
	avail_out uInt
	total_out uLong
	msg       uintptr
	state     uintptr
	zalloc    alloc_func
	zfree     free_func
	opaque    voidpf
	data_type int32
	adler     uLong
	reserved  uLong
	_         [4]byte
} /* zlib.h:86:9 */

type z_stream = z_stream_s /* zlib.h:106:3 */

type z_streamp = uintptr /* zlib.h:108:22 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header_s = struct {
	text      int32
	time      uLong
	xflags    int32
	os        int32
	extra     uintptr
	extra_len uInt
	extra_max uInt
	name      uintptr
	name_max  uInt
	_         [4]byte
	comment   uintptr
	comm_max  uInt
	hcrc      int32
	done      int32
	_         [4]byte
} /* zlib.h:114:9 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header = gz_header_s /* zlib.h:129:3 */

type gz_headerp = uintptr /* zlib.h:131:23 */
//
//      inflateGetHeader() requests that gzip header information be stored in the
//    provided gz_header structure.  inflateGetHeader() may be called after
//    inflateInit2() or inflateReset(), and before the first call of inflate().
//    As inflate() processes the gzip stream, head->done is zero until the header
//    is completed, at which time head->done is set to one.  If a zlib stream is
//    being decoded, then head->done is set to -1 to indicate that there will be
//    no gzip header information forthcoming.  Note that Z_BLOCK or Z_TREES can be
//    used to force inflate() to return immediately after header processing is
//    complete and before any actual data is decompressed.
//
//      The text, time, xflags, and os fields are filled in with the gzip header
//    contents.  hcrc is set to true if there is a header CRC.  (The header CRC
//    was valid if done is set to one.) If extra is not Z_NULL, then extra_max
//    contains the maximum number of bytes to write to extra.  Once done is true,
//    extra_len contains the actual extra field length, and extra contains the
//    extra field, or that field truncated if extra_max is less than extra_len.
//    If name is not Z_NULL, then up to name_max characters are written there,
//    terminated with a zero unless the length is greater than name_max.  If
//    comment is not Z_NULL, then up to comm_max characters are written there,
//    terminated with a zero unless the length is greater than comm_max.  When any
//    of extra, name, or comment are not Z_NULL and the respective field is not
//    present in the header, then that field is set to Z_NULL to signal its
//    absence.  This allows the use of deflateSetHeader() with the returned
//    structure to duplicate the header.  However if those fields are set to
//    allocated memory, then the application will need to save those pointers
//    elsewhere so that they can be eventually freed.
//
//      If inflateGetHeader is not used, then the header information is simply
//    discarded.  The header is always checked for validity, including the header
//    CRC if present.  inflateReset() will reset the process to discard the header
//    information.  The application would need to call inflateGetHeader() again to
//    retrieve the header from the next gzip stream.
//
//      inflateGetHeader returns Z_OK if success, or Z_STREAM_ERROR if the source
//    stream state was inconsistent.

//
// ZEXTERN int ZEXPORT inflateBackInit OF((z_streamp strm, int windowBits,
//                                         unsigned char FAR *window));
//
//      Initialize the internal stream state for decompression using inflateBack()
//    calls.  The fields zalloc, zfree and opaque in strm must be initialized
//    before the call.  If zalloc and zfree are Z_NULL, then the default library-
//    derived memory allocation routines are used.  windowBits is the base two
//    logarithm of the window size, in the range 8..15.  window is a caller
//    supplied buffer of that size.  Except for special applications where it is
//    assured that deflate was used with small window sizes, windowBits must be 15
//    and a 32K byte window must be supplied to be able to decompress general
//    deflate streams.
//
//      See inflateBack() for the usage of these routines.
//
//      inflateBackInit will return Z_OK on success, Z_STREAM_ERROR if any of
//    the parameters are invalid, Z_MEM_ERROR if the internal state could not be
//    allocated, or Z_VERSION_ERROR if the version of the library does not match
//    the version of the header file.

type in_func = uintptr  /* zlib.h:1092:18 */
type out_func = uintptr /* zlib.h:1094:13 */
//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile_s = struct {
	have uint32
	_    [4]byte
	next uintptr
	pos  int32
	_    [4]byte
} /* zlib.h:1300:9 */

//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile = uintptr /* zlib.h:1300:25 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the Wine project.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

type _iobuf = struct{ _Placeholder uintptr } /* stdio.h:33:3 */

type FILE = _iobuf /* stdio.h:47:25 */

type fpos_t = int64 /* stdio.h:115:37 */

func vsnwprintf(tls *libc.TLS, s uintptr, n size_t, format uintptr, arg va_list) int32 { /* stdio.h:1321:15: */
	var __ret int32 = libc.X__stdio_common_vswprintf(tls, 0x0004, s, n, format, uintptr(0), arg)
	if __ret < 0 {
		return -1
	}
	return __ret

}

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// ===-------- vadefs.h ---------------------------------------------------===
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===-----------------------------------------------------------------------===

// Only include this if we are aiming for MSVC compatibility.
// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

func vswprintf(tls *libc.TLS, __stream uintptr, __count size_t, __format uintptr, __local_argv uintptr) int32 { /* swprintf.inl:27:5: */
	return vsnwprintf(tls, __stream, __count, __format, __local_argv)
}

func _vfscanf_s_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:40:27: */
	return libc.X__stdio_common_vfscanf(tls, 0x0001, _File, _Format, _Locale, _ArgList)

}

func _vfscanf_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:85:27: */
	return libc.X__stdio_common_vfscanf(tls, uint64(0), _File, _Format, _Locale, _ArgList)

}

func _vsscanf_s_l(tls *libc.TLS, _Src uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:108:27: */
	return libc.X__stdio_common_vsscanf(tls, 0x0001, _Src, libc.Uint64(libc.Uint64FromInt32(-1)), _Format, _Locale, _ArgList)

}

func _vsscanf_l(tls *libc.TLS, _Src uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:135:27: */
	return libc.X__stdio_common_vsscanf(tls, uint64(0), _Src, libc.Uint64(libc.Uint64FromInt32(-1)), _Format, _Locale, _ArgList)

}

func _vfprintf_s_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:181:27: */
	return libc.X__stdio_common_vfprintf_s(tls, uint64(0), _File, _Format, _Locale, _ArgList)

}

func _vsnprintf_c_l(tls *libc.TLS, _DstBuf uintptr, _MaxCount size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:234:27: */
	return libc.X__stdio_common_vsprintf(tls, uint64(0), _DstBuf, _MaxCount, _Format, _Locale, _ArgList)

}

func _vsnprintf_s_l(tls *libc.TLS, _DstBuf uintptr, _DstSize size_t, _MaxCount size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:261:27: */
	return libc.X__stdio_common_vsnprintf_s(tls, uint64(0), _DstBuf, _DstSize, _MaxCount, _Format, _Locale, _ArgList)

}

func _vsprintf_s_l(tls *libc.TLS, _DstBuf uintptr, _DstSize size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:292:27: */
	return libc.X__stdio_common_vsprintf_s(tls, uint64(0), _DstBuf, _DstSize, _Format, _Locale, _ArgList)

}

func _vfprintf_p_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:319:27: */
	return libc.X__stdio_common_vfprintf_p(tls, uint64(0), _File, _Format, _Locale, _ArgList)

}

func _vsprintf_p_l(tls *libc.TLS, _DstBuf uintptr, _MaxCount size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:372:27: */
	return libc.X__stdio_common_vsprintf_p(tls, uint64(0), _DstBuf, _MaxCount, _Format, _Locale, _ArgList)

}

func _vscprintf_p_l(tls *libc.TLS, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:399:27: */
	return libc.X__stdio_common_vsprintf_p(tls, 0x0002, uintptr(0), uint64(0), _Format, _Locale, _ArgList)

}

func _vfprintf_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:426:27: */
	return libc.X__stdio_common_vfprintf(tls, uint64(0), _File, _Format, _Locale, _ArgList)

}

func _vsnprintf_l(tls *libc.TLS, _DstBuf uintptr, _MaxCount size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:453:27: */
	return libc.X__stdio_common_vsprintf(tls, 0x0001, _DstBuf, _MaxCount, _Format, _Locale, _ArgList)

}

func _vsprintf_l(tls *libc.TLS, _DstBuf uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:466:27: */
	return _vsnprintf_l(tls, _DstBuf, libc.Uint64(libc.Uint64FromInt32(-1)), _Format, _Locale, _ArgList)

}

func _vscprintf_l(tls *libc.TLS, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:480:27: */
	return libc.X__stdio_common_vsprintf(tls, 0x0002, uintptr(0), uint64(0), _Format, _Locale, _ArgList)

}

func _vfwscanf_s_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:588:27: */
	return libc.X__stdio_common_vfwscanf(tls, 0x0002|0x0001, _File, _Format, _Locale, _ArgList)

}

func _vswscanf_s_l(tls *libc.TLS, _Src uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:633:27: */
	return libc.X__stdio_common_vswscanf(tls, 0x0002|0x0001, _Src, libc.Uint64(libc.Uint64FromInt32(-1)), _Format, _Locale, _ArgList)

}

func _vsnwscanf_s_l(tls *libc.TLS, _Src uintptr, _MaxCount size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:656:27: */
	return libc.X__stdio_common_vswscanf(tls, 0x0002|0x0001, _Src, _MaxCount, _Format, _Locale, _ArgList)

}

func _vfwprintf_s_l(tls *libc.TLS, _File uintptr, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:679:27: */
	return libc.X__stdio_common_vfwprintf_s(tls, 0x0004, _File, _Format, _Locale, _ArgList)

}

func _vswprintf_s_l(tls *libc.TLS, _DstBuf uintptr, _DstSize size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:732:27: */
	return libc.X__stdio_common_vswprintf_s(tls, 0x0004, _DstBuf, _DstSize, _Format, _Locale, _ArgList)

}

func _vsnwprintf_s_l(tls *libc.TLS, _DstBuf uintptr, _DstSize size_t, _MaxCount size_t, _Format uintptr, _Locale _locale_t, _ArgList va_list) int32 { /* stdio_s.h:759:27: */
	return libc.X__stdio_common_vsnwprintf_s(tls, 0x0004, _DstBuf, _DstSize, _MaxCount, _Format, _Locale, _ArgList)

}

//===---- limits.h - Standard header for integer sizes --------------------===* *
//  Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
//  See https://llvm.org/LICENSE.txt for license information.
//  SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
// \*===----------------------------------------------------------------------===

type _onexit_t = uintptr /* stdlib.h:50:15 */

type _div_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:60:11 */

type div_t = _div_t /* stdlib.h:63:5 */

type _ldiv_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:65:11 */

type ldiv_t = _ldiv_t /* stdlib.h:68:5 */

type _LDOUBLE = struct{ ld [10]uint8 } /* stdlib.h:77:5 */

type _CRT_DOUBLE = struct{ x float64 } /* stdlib.h:84:5 */

type _CRT_FLOAT = struct{ f float32 } /* stdlib.h:88:5 */

type _LONGDOUBLE = struct{ x float64 } /* stdlib.h:95:5 */

type _LDBL12 = struct{ ld12 [12]uint8 } /* stdlib.h:102:5 */

type _purecall_handler = uintptr /* stdlib.h:143:16 */

type _invalid_parameter_handler = uintptr /* stdlib.h:148:16 */

type lldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:724:61 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Return codes for _heapwalk()

// Values for _heapinfo.useflag

// The structure used to walk through the heap with _heapwalk.
type _heapinfo = struct {
	_pentry  uintptr
	_size    size_t
	_useflag int32
	_        [4]byte
} /* malloc.h:46:11 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Return codes for _heapwalk()

// Values for _heapinfo.useflag

// The structure used to walk through the heap with _heapwalk.
type _HEAPINFO = _heapinfo /* malloc.h:50:5 */
type _fsize_t = uint32     /* io.h:29:25 */

type _finddata32_t = struct {
	attrib      uint32
	time_create int32
	time_access int32
	time_write  int32
	size        _fsize_t
	name        [260]int8
} /* io.h:35:3 */

type _finddata32i64_t = struct {
	attrib      uint32
	time_create int32
	time_access int32
	time_write  int32
	size        int64
	name        [260]int8
	_           [4]byte
} /* io.h:44:3 */

type _finddata64i32_t = struct {
	attrib      uint32
	_           [4]byte
	time_create int64
	time_access int64
	time_write  int64
	size        _fsize_t
	name        [260]int8
} /* io.h:53:3 */

type __finddata64_t = struct {
	attrib      uint32
	_           [4]byte
	time_create int64
	time_access int64
	time_write  int64
	size        int64
	name        [260]int8
	_           [4]byte
} /* io.h:62:3 */

type _wfinddata32_t = struct {
	attrib      uint32
	time_create int32
	time_access int32
	time_write  int32
	size        _fsize_t
	name        [260]wchar_t
} /* io.h:94:3 */

type _wfinddata32i64_t = struct {
	attrib      uint32
	time_create int32
	time_access int32
	time_write  int32
	size        int64
	name        [260]wchar_t
} /* io.h:103:3 */

type _wfinddata64i32_t = struct {
	attrib      uint32
	_           [4]byte
	time_create int64
	time_access int64
	time_write  int64
	size        _fsize_t
	name        [260]wchar_t
	_           [4]byte
} /* io.h:112:3 */

type _wfinddata64_t = struct {
	attrib      uint32
	_           [4]byte
	time_create int64
	time_access int64
	time_write  int64
	size        int64
	name        [260]wchar_t
} /* io.h:121:3 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

var prog uintptr /* minigzip.c:336:13: */

// ===========================================================================
// Display error message and exit
func error(tls *libc.TLS, msg uintptr) { /* minigzip.c:351:6: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts, libc.VaList(bp, prog, msg))
	libc.Xexit(tls, 1)
}

// ===========================================================================
// Compress input to output then close both files.

func gz_compress(tls *libc.TLS, in uintptr, out gzFile) { /* minigzip.c:362:6: */
	bp := tls.Alloc(16388)
	defer tls.Free(16388)

	// var buf [16384]int8 at bp, 16384

	var len int32
	// var err int32 at bp+16384, 4

	for {
		len = int32(libc.Xfread(tls, bp, uint64(1), uint64(unsafe.Sizeof([16384]int8{})), in))
		if libc.Xferror(tls, in) != 0 {
			libc.Xperror(tls, ts+8)
			libc.Xexit(tls, 1)
		}
		if len == 0 {
			break
		}

		if z.Xgzwrite(tls, out, bp, uint32(len)) != len {
			error(tls, z.Xgzerror(tls, out, bp+16384))
		}
	}
	libc.Xfclose(tls, in)
	if z.Xgzclose(tls, out) != 0 {
		error(tls, ts+14)
	}
}

// ===========================================================================
// Uncompress input to output then close both files.
func gz_uncompress(tls *libc.TLS, in gzFile, out uintptr) { /* minigzip.c:430:6: */
	bp := tls.Alloc(16388)
	defer tls.Free(16388)

	// var buf [16384]int8 at bp, 16384

	var len int32
	// var err int32 at bp+16384, 4

	for {
		len = z.Xgzread(tls, in, bp, uint32(unsafe.Sizeof([16384]int8{})))
		if len < 0 {
			error(tls, z.Xgzerror(tls, in, bp+16384))
		}
		if len == 0 {
			break
		}

		if int32(libc.Xfwrite(tls, bp, uint64(1), uint64(uint32(len)), out)) != len {
			error(tls, ts+29)
		}
	}
	if libc.Xfclose(tls, out) != 0 {
		error(tls, ts+43)
	}

	if z.Xgzclose(tls, in) != 0 {
		error(tls, ts+14)
	}
}

// ===========================================================================
// Compress the given file: create a corresponding .gz file and remove the
// original.
func file_compress(tls *libc.TLS, file uintptr, mode uintptr) { /* minigzip.c:457:6: */
	bp := tls.Alloc(1064)
	defer tls.Free(1064)

	// var outfile [1024]int8 at bp+40, 1024

	var in uintptr
	var out gzFile

	if libc.Xstrlen(tls, file)+libc.Xstrlen(tls, ts+57) >= size_t(unsafe.Sizeof([1024]int8{})) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+61, libc.VaList(bp, prog))
		libc.Xexit(tls, 1)
	}

	libc.Xsnprintf(tls, bp+40, uint64(unsafe.Sizeof([1024]int8{})), ts+84, libc.VaList(bp+8, file, ts+57))

	in = libc.Xfopen(tls, file, ts+89)
	if in == uintptr(0) {
		libc.Xperror(tls, file)
		libc.Xexit(tls, 1)
	}
	out = z.Xgzopen(tls, bp+40, mode)
	if out == uintptr(0) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+92, libc.VaList(bp+24, prog, bp+40))
		libc.Xexit(tls, 1)
	}
	gz_compress(tls, in, out)

	libc.Xunlink(tls, file)
}

// ===========================================================================
// Uncompress the given file and remove the original.
func file_uncompress(tls *libc.TLS, file uintptr) { /* minigzip.c:496:6: */
	bp := tls.Alloc(1064)
	defer tls.Free(1064)

	// var buf [1024]int8 at bp+40, 1024

	var infile uintptr
	var outfile uintptr
	var out uintptr
	var in gzFile
	var len uint32 = uint32(libc.Xstrlen(tls, file))

	if size_t(len)+libc.Xstrlen(tls, ts+57) >= size_t(unsafe.Sizeof([1024]int8{})) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+61, libc.VaList(bp, prog))
		libc.Xexit(tls, 1)
	}

	libc.Xsnprintf(tls, bp+40, uint64(unsafe.Sizeof([1024]int8{})), ts+113, libc.VaList(bp+8, file))

	if uint64(len) > uint64(unsafe.Sizeof([4]int8{}))-uint64(1) && libc.Xstrcmp(tls, file+uintptr(len)-uintptr(uint64(unsafe.Sizeof([4]int8{}))-uint64(1)), ts+57) == 0 {
		infile = file
		outfile = bp + 40 /* &buf[0] */
		*(*int8)(unsafe.Pointer(outfile + uintptr(len-uint32(3)))) = int8(0)
	} else {
		outfile = file
		infile = bp + 40 /* &buf[0] */
		libc.Xsnprintf(tls, bp+40+uintptr(len), uint64(unsafe.Sizeof([1024]int8{}))-uint64(len), ts+113, libc.VaList(bp+16, ts+57 /* ".gz" */))
	}
	in = z.Xgzopen(tls, infile, ts+89)
	if in == uintptr(0) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+92, libc.VaList(bp+24, prog, infile))
		libc.Xexit(tls, 1)
	}
	out = libc.Xfopen(tls, outfile, ts+116)
	if out == uintptr(0) {
		libc.Xperror(tls, file)
		libc.Xexit(tls, 1)
	}

	gz_uncompress(tls, in, out)

	libc.Xunlink(tls, infile)
}

// ===========================================================================
// Usage:  minigzip [-c] [-d] [-f] [-h] [-r] [-1 to -9] [files...]
//   -c : write to standard output
//   -d : decompress
//   -f : compress with Z_FILTERED
//   -h : compress with Z_HUFFMAN_ONLY
//   -r : compress with Z_RLE
//   -1 to -9 : compression level

func main1(tls *libc.TLS, argc int32, argv uintptr) int32 { /* minigzip.c:556:5: */
	bp := tls.Alloc(44)
	defer tls.Free(44)

	var copyout int32 = 0
	var uncompr int32 = 0
	var file gzFile
	var bname uintptr
	// var outmode [20]int8 at bp+24, 20

	libc.Xsnprintf(tls, bp+24, uint64(unsafe.Sizeof([20]int8{})), ts+113, libc.VaList(bp, ts+119))

	prog = *(*uintptr)(unsafe.Pointer(argv))
	bname = libc.Xstrrchr(tls, *(*uintptr)(unsafe.Pointer(argv)), '/')
	if bname != 0 {
		bname++
	} else {
		bname = *(*uintptr)(unsafe.Pointer(argv))
	}
	argc--
	argv += 8

	if !(libc.Xstrcmp(tls, bname, ts+124) != 0) {
		uncompr = 1
	} else if !(libc.Xstrcmp(tls, bname, ts+131) != 0) {
		copyout = libc.AssignInt32(&uncompr, 1)
	}

	for argc > 0 {
		if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+136) == 0 {
			copyout = 1
		} else if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+139) == 0 {
			uncompr = 1
		} else if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+142) == 0 {
			*(*int8)(unsafe.Pointer(bp + 24 + 3)) = int8('f')
		} else if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+145) == 0 {
			*(*int8)(unsafe.Pointer(bp + 24 + 3)) = int8('h')
		} else if libc.Xstrcmp(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+148) == 0 {
			*(*int8)(unsafe.Pointer(bp + 24 + 3)) = int8('R')
		} else if int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv))))) == '-' && int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv)) + 1))) >= '1' && int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv)) + 1))) <= '9' && int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv)) + 2))) == 0 {
			*(*int8)(unsafe.Pointer(bp + 24 + 2)) = *(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(argv)) + 1))
		} else {
			break
		}
		argc--
		argv += 8
	}
	if int32(*(*int8)(unsafe.Pointer(bp + 24 + 3))) == ' ' {
		*(*int8)(unsafe.Pointer(bp + 24 + 3)) = int8(0)
	}
	if argc == 0 {
		libc.Xsetmode(tls, libc.Xfileno(tls, libc.X__acrt_iob_func(tls, uint32(0))), 0x8000)
		libc.Xsetmode(tls, libc.Xfileno(tls, libc.X__acrt_iob_func(tls, uint32(1))), 0x8000)
		if uncompr != 0 {
			file = z.Xgzdopen(tls, libc.Xfileno(tls, libc.X__acrt_iob_func(tls, uint32(0))), ts+89)
			if file == uintptr(0) {
				error(tls, ts+151)
			}
			gz_uncompress(tls, file, libc.X__acrt_iob_func(tls, uint32(1)))
		} else {
			file = z.Xgzdopen(tls, libc.Xfileno(tls, libc.X__acrt_iob_func(tls, uint32(1))), bp+24)
			if file == uintptr(0) {
				error(tls, ts+171)
			}
			gz_compress(tls, libc.X__acrt_iob_func(tls, uint32(0)), file)
		}
	} else {
		if copyout != 0 {
			libc.Xsetmode(tls, libc.Xfileno(tls, libc.X__acrt_iob_func(tls, uint32(1))), 0x8000)
		}
		for __ccgo := true; __ccgo; __ccgo = func() bool { argv += 8; return libc.PreDecInt32(&argc, 1) != 0 }() {
			if uncompr != 0 {
				if copyout != 0 {
					file = z.Xgzopen(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+89)
					if file == uintptr(0) {
						libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+92, libc.VaList(bp+8, prog, *(*uintptr)(unsafe.Pointer(argv))))
					} else {
						gz_uncompress(tls, file, libc.X__acrt_iob_func(tls, uint32(1)))
					}
				} else {
					file_uncompress(tls, *(*uintptr)(unsafe.Pointer(argv)))
				}
			} else {
				if copyout != 0 {
					var in uintptr = libc.Xfopen(tls, *(*uintptr)(unsafe.Pointer(argv)), ts+89)

					if in == uintptr(0) {
						libc.Xperror(tls, *(*uintptr)(unsafe.Pointer(argv)))
					} else {
						file = z.Xgzdopen(tls, libc.Xfileno(tls, libc.X__acrt_iob_func(tls, uint32(1))), bp+24)
						if file == uintptr(0) {
							error(tls, ts+171)
						}

						gz_compress(tls, in, file)
					}

				} else {
					file_compress(tls, *(*uintptr)(unsafe.Pointer(argv)), bp+24)
				}
			}
		}
	}
	return 0
}

var ts1 = "%s: %s\n\x00fread\x00failed gzclose\x00failed fwrite\x00failed fclose\x00.gz\x00%s: filename too long\n\x00%s%s\x00rb\x00%s: can't gzopen %s\n\x00%s\x00wb\x00wb6 \x00gunzip\x00zcat\x00-c\x00-d\x00-f\x00-h\x00-r\x00can't gzdopen stdin\x00can't gzdopen stdout\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
