// SPDX-License-Identifier: Apache-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        (unknown)
// source: substrait/algebra.proto

package proto

import (
	extensions "github.com/substrait-io/substrait-go/proto/extensions"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Describes which part of an aggregation or window function to perform within
// the context of distributed algorithms.
type AggregationPhase int32

const (
	// Implies `INTERMEDIATE_TO_RESULT`.
	AggregationPhase_AGGREGATION_PHASE_UNSPECIFIED AggregationPhase = 0
	// Specifies that the function should be run only up to the point of
	// generating an intermediate value, to be further aggregated later using
	// INTERMEDIATE_TO_INTERMEDIATE or INTERMEDIATE_TO_RESULT.
	AggregationPhase_AGGREGATION_PHASE_INITIAL_TO_INTERMEDIATE AggregationPhase = 1
	// Specifies that the inputs of the aggregate or window function are the
	// intermediate values of the function, and that the output should also be
	// an intermediate value, to be further aggregated later using
	// INTERMEDIATE_TO_INTERMEDIATE or INTERMEDIATE_TO_RESULT.
	AggregationPhase_AGGREGATION_PHASE_INTERMEDIATE_TO_INTERMEDIATE AggregationPhase = 2
	// A complete invocation: the function should aggregate the given set of
	// inputs to yield a single return value. This style must be used for
	// aggregate or window functions that are not decomposable.
	AggregationPhase_AGGREGATION_PHASE_INITIAL_TO_RESULT AggregationPhase = 3
	// Specifies that the inputs of the aggregate or window function are the
	// intermediate values of the function, generated previously using
	// INITIAL_TO_INTERMEDIATE and possibly INTERMEDIATE_TO_INTERMEDIATE calls.
	// This call should combine the intermediate values to yield the final
	// return value.
	AggregationPhase_AGGREGATION_PHASE_INTERMEDIATE_TO_RESULT AggregationPhase = 4
)

// Enum value maps for AggregationPhase.
var (
	AggregationPhase_name = map[int32]string{
		0: "AGGREGATION_PHASE_UNSPECIFIED",
		1: "AGGREGATION_PHASE_INITIAL_TO_INTERMEDIATE",
		2: "AGGREGATION_PHASE_INTERMEDIATE_TO_INTERMEDIATE",
		3: "AGGREGATION_PHASE_INITIAL_TO_RESULT",
		4: "AGGREGATION_PHASE_INTERMEDIATE_TO_RESULT",
	}
	AggregationPhase_value = map[string]int32{
		"AGGREGATION_PHASE_UNSPECIFIED":                  0,
		"AGGREGATION_PHASE_INITIAL_TO_INTERMEDIATE":      1,
		"AGGREGATION_PHASE_INTERMEDIATE_TO_INTERMEDIATE": 2,
		"AGGREGATION_PHASE_INITIAL_TO_RESULT":            3,
		"AGGREGATION_PHASE_INTERMEDIATE_TO_RESULT":       4,
	}
)

func (x AggregationPhase) Enum() *AggregationPhase {
	p := new(AggregationPhase)
	*p = x
	return p
}

func (x AggregationPhase) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AggregationPhase) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[0].Descriptor()
}

func (AggregationPhase) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[0]
}

func (x AggregationPhase) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AggregationPhase.Descriptor instead.
func (AggregationPhase) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{0}
}

type JoinRel_JoinType int32

const (
	JoinRel_JOIN_TYPE_UNSPECIFIED JoinRel_JoinType = 0
	JoinRel_JOIN_TYPE_INNER       JoinRel_JoinType = 1
	JoinRel_JOIN_TYPE_OUTER       JoinRel_JoinType = 2
	JoinRel_JOIN_TYPE_LEFT        JoinRel_JoinType = 3
	JoinRel_JOIN_TYPE_RIGHT       JoinRel_JoinType = 4
	JoinRel_JOIN_TYPE_SEMI        JoinRel_JoinType = 5
	JoinRel_JOIN_TYPE_ANTI        JoinRel_JoinType = 6
	// This join is useful for nested sub-queries where we need exactly one tuple in output (or throw exception)
	// See Section 3.2 of https://15721.courses.cs.cmu.edu/spring2018/papers/16-optimizer2/hyperjoins-btw2017.pdf
	JoinRel_JOIN_TYPE_SINGLE JoinRel_JoinType = 7
)

// Enum value maps for JoinRel_JoinType.
var (
	JoinRel_JoinType_name = map[int32]string{
		0: "JOIN_TYPE_UNSPECIFIED",
		1: "JOIN_TYPE_INNER",
		2: "JOIN_TYPE_OUTER",
		3: "JOIN_TYPE_LEFT",
		4: "JOIN_TYPE_RIGHT",
		5: "JOIN_TYPE_SEMI",
		6: "JOIN_TYPE_ANTI",
		7: "JOIN_TYPE_SINGLE",
	}
	JoinRel_JoinType_value = map[string]int32{
		"JOIN_TYPE_UNSPECIFIED": 0,
		"JOIN_TYPE_INNER":       1,
		"JOIN_TYPE_OUTER":       2,
		"JOIN_TYPE_LEFT":        3,
		"JOIN_TYPE_RIGHT":       4,
		"JOIN_TYPE_SEMI":        5,
		"JOIN_TYPE_ANTI":        6,
		"JOIN_TYPE_SINGLE":      7,
	}
)

func (x JoinRel_JoinType) Enum() *JoinRel_JoinType {
	p := new(JoinRel_JoinType)
	*p = x
	return p
}

func (x JoinRel_JoinType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JoinRel_JoinType) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[1].Descriptor()
}

func (JoinRel_JoinType) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[1]
}

func (x JoinRel_JoinType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JoinRel_JoinType.Descriptor instead.
func (JoinRel_JoinType) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{3, 0}
}

type SetRel_SetOp int32

const (
	SetRel_SET_OP_UNSPECIFIED           SetRel_SetOp = 0
	SetRel_SET_OP_MINUS_PRIMARY         SetRel_SetOp = 1
	SetRel_SET_OP_MINUS_MULTISET        SetRel_SetOp = 2
	SetRel_SET_OP_INTERSECTION_PRIMARY  SetRel_SetOp = 3
	SetRel_SET_OP_INTERSECTION_MULTISET SetRel_SetOp = 4
	SetRel_SET_OP_UNION_DISTINCT        SetRel_SetOp = 5
	SetRel_SET_OP_UNION_ALL             SetRel_SetOp = 6
)

// Enum value maps for SetRel_SetOp.
var (
	SetRel_SetOp_name = map[int32]string{
		0: "SET_OP_UNSPECIFIED",
		1: "SET_OP_MINUS_PRIMARY",
		2: "SET_OP_MINUS_MULTISET",
		3: "SET_OP_INTERSECTION_PRIMARY",
		4: "SET_OP_INTERSECTION_MULTISET",
		5: "SET_OP_UNION_DISTINCT",
		6: "SET_OP_UNION_ALL",
	}
	SetRel_SetOp_value = map[string]int32{
		"SET_OP_UNSPECIFIED":           0,
		"SET_OP_MINUS_PRIMARY":         1,
		"SET_OP_MINUS_MULTISET":        2,
		"SET_OP_INTERSECTION_PRIMARY":  3,
		"SET_OP_INTERSECTION_MULTISET": 4,
		"SET_OP_UNION_DISTINCT":        5,
		"SET_OP_UNION_ALL":             6,
	}
)

func (x SetRel_SetOp) Enum() *SetRel_SetOp {
	p := new(SetRel_SetOp)
	*p = x
	return p
}

func (x SetRel_SetOp) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SetRel_SetOp) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[2].Descriptor()
}

func (SetRel_SetOp) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[2]
}

func (x SetRel_SetOp) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SetRel_SetOp.Descriptor instead.
func (SetRel_SetOp) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{9, 0}
}

type DdlRel_DdlObject int32

const (
	DdlRel_DDL_OBJECT_UNSPECIFIED DdlRel_DdlObject = 0
	// A Table object in the system
	DdlRel_DDL_OBJECT_TABLE DdlRel_DdlObject = 1
	// A View object in the system
	DdlRel_DDL_OBJECT_VIEW DdlRel_DdlObject = 2
)

// Enum value maps for DdlRel_DdlObject.
var (
	DdlRel_DdlObject_name = map[int32]string{
		0: "DDL_OBJECT_UNSPECIFIED",
		1: "DDL_OBJECT_TABLE",
		2: "DDL_OBJECT_VIEW",
	}
	DdlRel_DdlObject_value = map[string]int32{
		"DDL_OBJECT_UNSPECIFIED": 0,
		"DDL_OBJECT_TABLE":       1,
		"DDL_OBJECT_VIEW":        2,
	}
)

func (x DdlRel_DdlObject) Enum() *DdlRel_DdlObject {
	p := new(DdlRel_DdlObject)
	*p = x
	return p
}

func (x DdlRel_DdlObject) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DdlRel_DdlObject) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[3].Descriptor()
}

func (DdlRel_DdlObject) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[3]
}

func (x DdlRel_DdlObject) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DdlRel_DdlObject.Descriptor instead.
func (DdlRel_DdlObject) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{18, 0}
}

type DdlRel_DdlOp int32

const (
	DdlRel_DDL_OP_UNSPECIFIED DdlRel_DdlOp = 0
	// A create operation (for any object)
	DdlRel_DDL_OP_CREATE DdlRel_DdlOp = 1
	// A create operation if the object does not exist, or replaces it (equivalent to a DROP + CREATE) if the object already exists
	DdlRel_DDL_OP_CREATE_OR_REPLACE DdlRel_DdlOp = 2
	// An operation that modifies the schema (e.g., column names, types, default values) for the target object
	DdlRel_DDL_OP_ALTER DdlRel_DdlOp = 3
	// An operation that removes an object from the system
	DdlRel_DDL_OP_DROP DdlRel_DdlOp = 4
	// An operation that removes an object from the system (without throwing an exception if the object did not exist)
	DdlRel_DDL_OP_DROP_IF_EXIST DdlRel_DdlOp = 5
)

// Enum value maps for DdlRel_DdlOp.
var (
	DdlRel_DdlOp_name = map[int32]string{
		0: "DDL_OP_UNSPECIFIED",
		1: "DDL_OP_CREATE",
		2: "DDL_OP_CREATE_OR_REPLACE",
		3: "DDL_OP_ALTER",
		4: "DDL_OP_DROP",
		5: "DDL_OP_DROP_IF_EXIST",
	}
	DdlRel_DdlOp_value = map[string]int32{
		"DDL_OP_UNSPECIFIED":       0,
		"DDL_OP_CREATE":            1,
		"DDL_OP_CREATE_OR_REPLACE": 2,
		"DDL_OP_ALTER":             3,
		"DDL_OP_DROP":              4,
		"DDL_OP_DROP_IF_EXIST":     5,
	}
)

func (x DdlRel_DdlOp) Enum() *DdlRel_DdlOp {
	p := new(DdlRel_DdlOp)
	*p = x
	return p
}

func (x DdlRel_DdlOp) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DdlRel_DdlOp) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[4].Descriptor()
}

func (DdlRel_DdlOp) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[4]
}

func (x DdlRel_DdlOp) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DdlRel_DdlOp.Descriptor instead.
func (DdlRel_DdlOp) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{18, 1}
}

type WriteRel_WriteOp int32

const (
	WriteRel_WRITE_OP_UNSPECIFIED WriteRel_WriteOp = 0
	// The insert of new tuples in a table
	WriteRel_WRITE_OP_INSERT WriteRel_WriteOp = 1
	// The removal of tuples from a table
	WriteRel_WRITE_OP_DELETE WriteRel_WriteOp = 2
	// The modification of existing tuples within a table
	WriteRel_WRITE_OP_UPDATE WriteRel_WriteOp = 3
	// The Creation of a new table, and the insert of new tuples in the table
	WriteRel_WRITE_OP_CTAS WriteRel_WriteOp = 4
)

// Enum value maps for WriteRel_WriteOp.
var (
	WriteRel_WriteOp_name = map[int32]string{
		0: "WRITE_OP_UNSPECIFIED",
		1: "WRITE_OP_INSERT",
		2: "WRITE_OP_DELETE",
		3: "WRITE_OP_UPDATE",
		4: "WRITE_OP_CTAS",
	}
	WriteRel_WriteOp_value = map[string]int32{
		"WRITE_OP_UNSPECIFIED": 0,
		"WRITE_OP_INSERT":      1,
		"WRITE_OP_DELETE":      2,
		"WRITE_OP_UPDATE":      3,
		"WRITE_OP_CTAS":        4,
	}
)

func (x WriteRel_WriteOp) Enum() *WriteRel_WriteOp {
	p := new(WriteRel_WriteOp)
	*p = x
	return p
}

func (x WriteRel_WriteOp) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WriteRel_WriteOp) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[5].Descriptor()
}

func (WriteRel_WriteOp) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[5]
}

func (x WriteRel_WriteOp) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WriteRel_WriteOp.Descriptor instead.
func (WriteRel_WriteOp) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{19, 0}
}

type WriteRel_OutputMode int32

const (
	WriteRel_OUTPUT_MODE_UNSPECIFIED WriteRel_OutputMode = 0
	// return no tuples at all
	WriteRel_OUTPUT_MODE_NO_OUTPUT WriteRel_OutputMode = 1
	// this mode makes the operator return all the tuple INSERTED/DELETED/UPDATED by the operator.
	// The operator returns the AFTER-image of any change. This can be further manipulated by operators upstreams
	// (e.g., retunring the typical "count of modified tuples").
	// For scenarios in which the BEFORE image is required, the user must implement a spool (via references to
	// subplans in the body of the Rel input) and return those with anounter PlanRel.relations.
	WriteRel_OUTPUT_MODE_MODIFIED_TUPLES WriteRel_OutputMode = 2
)

// Enum value maps for WriteRel_OutputMode.
var (
	WriteRel_OutputMode_name = map[int32]string{
		0: "OUTPUT_MODE_UNSPECIFIED",
		1: "OUTPUT_MODE_NO_OUTPUT",
		2: "OUTPUT_MODE_MODIFIED_TUPLES",
	}
	WriteRel_OutputMode_value = map[string]int32{
		"OUTPUT_MODE_UNSPECIFIED":     0,
		"OUTPUT_MODE_NO_OUTPUT":       1,
		"OUTPUT_MODE_MODIFIED_TUPLES": 2,
	}
)

func (x WriteRel_OutputMode) Enum() *WriteRel_OutputMode {
	p := new(WriteRel_OutputMode)
	*p = x
	return p
}

func (x WriteRel_OutputMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WriteRel_OutputMode) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[6].Descriptor()
}

func (WriteRel_OutputMode) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[6]
}

func (x WriteRel_OutputMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WriteRel_OutputMode.Descriptor instead.
func (WriteRel_OutputMode) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{19, 1}
}

type HashJoinRel_JoinType int32

const (
	HashJoinRel_JOIN_TYPE_UNSPECIFIED HashJoinRel_JoinType = 0
	HashJoinRel_JOIN_TYPE_INNER       HashJoinRel_JoinType = 1
	HashJoinRel_JOIN_TYPE_OUTER       HashJoinRel_JoinType = 2
	HashJoinRel_JOIN_TYPE_LEFT        HashJoinRel_JoinType = 3
	HashJoinRel_JOIN_TYPE_RIGHT       HashJoinRel_JoinType = 4
	HashJoinRel_JOIN_TYPE_LEFT_SEMI   HashJoinRel_JoinType = 5
	HashJoinRel_JOIN_TYPE_RIGHT_SEMI  HashJoinRel_JoinType = 6
	HashJoinRel_JOIN_TYPE_LEFT_ANTI   HashJoinRel_JoinType = 7
	HashJoinRel_JOIN_TYPE_RIGHT_ANTI  HashJoinRel_JoinType = 8
)

// Enum value maps for HashJoinRel_JoinType.
var (
	HashJoinRel_JoinType_name = map[int32]string{
		0: "JOIN_TYPE_UNSPECIFIED",
		1: "JOIN_TYPE_INNER",
		2: "JOIN_TYPE_OUTER",
		3: "JOIN_TYPE_LEFT",
		4: "JOIN_TYPE_RIGHT",
		5: "JOIN_TYPE_LEFT_SEMI",
		6: "JOIN_TYPE_RIGHT_SEMI",
		7: "JOIN_TYPE_LEFT_ANTI",
		8: "JOIN_TYPE_RIGHT_ANTI",
	}
	HashJoinRel_JoinType_value = map[string]int32{
		"JOIN_TYPE_UNSPECIFIED": 0,
		"JOIN_TYPE_INNER":       1,
		"JOIN_TYPE_OUTER":       2,
		"JOIN_TYPE_LEFT":        3,
		"JOIN_TYPE_RIGHT":       4,
		"JOIN_TYPE_LEFT_SEMI":   5,
		"JOIN_TYPE_RIGHT_SEMI":  6,
		"JOIN_TYPE_LEFT_ANTI":   7,
		"JOIN_TYPE_RIGHT_ANTI":  8,
	}
)

func (x HashJoinRel_JoinType) Enum() *HashJoinRel_JoinType {
	p := new(HashJoinRel_JoinType)
	*p = x
	return p
}

func (x HashJoinRel_JoinType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HashJoinRel_JoinType) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[7].Descriptor()
}

func (HashJoinRel_JoinType) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[7]
}

func (x HashJoinRel_JoinType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HashJoinRel_JoinType.Descriptor instead.
func (HashJoinRel_JoinType) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{20, 0}
}

type MergeJoinRel_JoinType int32

const (
	MergeJoinRel_JOIN_TYPE_UNSPECIFIED MergeJoinRel_JoinType = 0
	MergeJoinRel_JOIN_TYPE_INNER       MergeJoinRel_JoinType = 1
	MergeJoinRel_JOIN_TYPE_OUTER       MergeJoinRel_JoinType = 2
	MergeJoinRel_JOIN_TYPE_LEFT        MergeJoinRel_JoinType = 3
	MergeJoinRel_JOIN_TYPE_RIGHT       MergeJoinRel_JoinType = 4
	MergeJoinRel_JOIN_TYPE_LEFT_SEMI   MergeJoinRel_JoinType = 5
	MergeJoinRel_JOIN_TYPE_RIGHT_SEMI  MergeJoinRel_JoinType = 6
	MergeJoinRel_JOIN_TYPE_LEFT_ANTI   MergeJoinRel_JoinType = 7
	MergeJoinRel_JOIN_TYPE_RIGHT_ANTI  MergeJoinRel_JoinType = 8
)

// Enum value maps for MergeJoinRel_JoinType.
var (
	MergeJoinRel_JoinType_name = map[int32]string{
		0: "JOIN_TYPE_UNSPECIFIED",
		1: "JOIN_TYPE_INNER",
		2: "JOIN_TYPE_OUTER",
		3: "JOIN_TYPE_LEFT",
		4: "JOIN_TYPE_RIGHT",
		5: "JOIN_TYPE_LEFT_SEMI",
		6: "JOIN_TYPE_RIGHT_SEMI",
		7: "JOIN_TYPE_LEFT_ANTI",
		8: "JOIN_TYPE_RIGHT_ANTI",
	}
	MergeJoinRel_JoinType_value = map[string]int32{
		"JOIN_TYPE_UNSPECIFIED": 0,
		"JOIN_TYPE_INNER":       1,
		"JOIN_TYPE_OUTER":       2,
		"JOIN_TYPE_LEFT":        3,
		"JOIN_TYPE_RIGHT":       4,
		"JOIN_TYPE_LEFT_SEMI":   5,
		"JOIN_TYPE_RIGHT_SEMI":  6,
		"JOIN_TYPE_LEFT_ANTI":   7,
		"JOIN_TYPE_RIGHT_ANTI":  8,
	}
)

func (x MergeJoinRel_JoinType) Enum() *MergeJoinRel_JoinType {
	p := new(MergeJoinRel_JoinType)
	*p = x
	return p
}

func (x MergeJoinRel_JoinType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MergeJoinRel_JoinType) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[8].Descriptor()
}

func (MergeJoinRel_JoinType) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[8]
}

func (x MergeJoinRel_JoinType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MergeJoinRel_JoinType.Descriptor instead.
func (MergeJoinRel_JoinType) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{21, 0}
}

type Expression_Cast_FailureBehavior int32

const (
	Expression_Cast_FAILURE_BEHAVIOR_UNSPECIFIED     Expression_Cast_FailureBehavior = 0
	Expression_Cast_FAILURE_BEHAVIOR_RETURN_NULL     Expression_Cast_FailureBehavior = 1
	Expression_Cast_FAILURE_BEHAVIOR_THROW_EXCEPTION Expression_Cast_FailureBehavior = 2
)

// Enum value maps for Expression_Cast_FailureBehavior.
var (
	Expression_Cast_FailureBehavior_name = map[int32]string{
		0: "FAILURE_BEHAVIOR_UNSPECIFIED",
		1: "FAILURE_BEHAVIOR_RETURN_NULL",
		2: "FAILURE_BEHAVIOR_THROW_EXCEPTION",
	}
	Expression_Cast_FailureBehavior_value = map[string]int32{
		"FAILURE_BEHAVIOR_UNSPECIFIED":     0,
		"FAILURE_BEHAVIOR_RETURN_NULL":     1,
		"FAILURE_BEHAVIOR_THROW_EXCEPTION": 2,
	}
)

func (x Expression_Cast_FailureBehavior) Enum() *Expression_Cast_FailureBehavior {
	p := new(Expression_Cast_FailureBehavior)
	*p = x
	return p
}

func (x Expression_Cast_FailureBehavior) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Expression_Cast_FailureBehavior) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[9].Descriptor()
}

func (Expression_Cast_FailureBehavior) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[9]
}

func (x Expression_Cast_FailureBehavior) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Expression_Cast_FailureBehavior.Descriptor instead.
func (Expression_Cast_FailureBehavior) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 6, 0}
}

type Expression_Subquery_SetPredicate_PredicateOp int32

const (
	Expression_Subquery_SetPredicate_PREDICATE_OP_UNSPECIFIED Expression_Subquery_SetPredicate_PredicateOp = 0
	Expression_Subquery_SetPredicate_PREDICATE_OP_EXISTS      Expression_Subquery_SetPredicate_PredicateOp = 1
	Expression_Subquery_SetPredicate_PREDICATE_OP_UNIQUE      Expression_Subquery_SetPredicate_PredicateOp = 2
)

// Enum value maps for Expression_Subquery_SetPredicate_PredicateOp.
var (
	Expression_Subquery_SetPredicate_PredicateOp_name = map[int32]string{
		0: "PREDICATE_OP_UNSPECIFIED",
		1: "PREDICATE_OP_EXISTS",
		2: "PREDICATE_OP_UNIQUE",
	}
	Expression_Subquery_SetPredicate_PredicateOp_value = map[string]int32{
		"PREDICATE_OP_UNSPECIFIED": 0,
		"PREDICATE_OP_EXISTS":      1,
		"PREDICATE_OP_UNIQUE":      2,
	}
)

func (x Expression_Subquery_SetPredicate_PredicateOp) Enum() *Expression_Subquery_SetPredicate_PredicateOp {
	p := new(Expression_Subquery_SetPredicate_PredicateOp)
	*p = x
	return p
}

func (x Expression_Subquery_SetPredicate_PredicateOp) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Expression_Subquery_SetPredicate_PredicateOp) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[10].Descriptor()
}

func (Expression_Subquery_SetPredicate_PredicateOp) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[10]
}

func (x Expression_Subquery_SetPredicate_PredicateOp) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Expression_Subquery_SetPredicate_PredicateOp.Descriptor instead.
func (Expression_Subquery_SetPredicate_PredicateOp) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 14, 2, 0}
}

type Expression_Subquery_SetComparison_ComparisonOp int32

const (
	Expression_Subquery_SetComparison_COMPARISON_OP_UNSPECIFIED Expression_Subquery_SetComparison_ComparisonOp = 0
	Expression_Subquery_SetComparison_COMPARISON_OP_EQ          Expression_Subquery_SetComparison_ComparisonOp = 1
	Expression_Subquery_SetComparison_COMPARISON_OP_NE          Expression_Subquery_SetComparison_ComparisonOp = 2
	Expression_Subquery_SetComparison_COMPARISON_OP_LT          Expression_Subquery_SetComparison_ComparisonOp = 3
	Expression_Subquery_SetComparison_COMPARISON_OP_GT          Expression_Subquery_SetComparison_ComparisonOp = 4
	Expression_Subquery_SetComparison_COMPARISON_OP_LE          Expression_Subquery_SetComparison_ComparisonOp = 5
	Expression_Subquery_SetComparison_COMPARISON_OP_GE          Expression_Subquery_SetComparison_ComparisonOp = 6
)

// Enum value maps for Expression_Subquery_SetComparison_ComparisonOp.
var (
	Expression_Subquery_SetComparison_ComparisonOp_name = map[int32]string{
		0: "COMPARISON_OP_UNSPECIFIED",
		1: "COMPARISON_OP_EQ",
		2: "COMPARISON_OP_NE",
		3: "COMPARISON_OP_LT",
		4: "COMPARISON_OP_GT",
		5: "COMPARISON_OP_LE",
		6: "COMPARISON_OP_GE",
	}
	Expression_Subquery_SetComparison_ComparisonOp_value = map[string]int32{
		"COMPARISON_OP_UNSPECIFIED": 0,
		"COMPARISON_OP_EQ":          1,
		"COMPARISON_OP_NE":          2,
		"COMPARISON_OP_LT":          3,
		"COMPARISON_OP_GT":          4,
		"COMPARISON_OP_LE":          5,
		"COMPARISON_OP_GE":          6,
	}
)

func (x Expression_Subquery_SetComparison_ComparisonOp) Enum() *Expression_Subquery_SetComparison_ComparisonOp {
	p := new(Expression_Subquery_SetComparison_ComparisonOp)
	*p = x
	return p
}

func (x Expression_Subquery_SetComparison_ComparisonOp) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Expression_Subquery_SetComparison_ComparisonOp) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[11].Descriptor()
}

func (Expression_Subquery_SetComparison_ComparisonOp) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[11]
}

func (x Expression_Subquery_SetComparison_ComparisonOp) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Expression_Subquery_SetComparison_ComparisonOp.Descriptor instead.
func (Expression_Subquery_SetComparison_ComparisonOp) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 14, 3, 0}
}

type Expression_Subquery_SetComparison_ReductionOp int32

const (
	Expression_Subquery_SetComparison_REDUCTION_OP_UNSPECIFIED Expression_Subquery_SetComparison_ReductionOp = 0
	Expression_Subquery_SetComparison_REDUCTION_OP_ANY         Expression_Subquery_SetComparison_ReductionOp = 1
	Expression_Subquery_SetComparison_REDUCTION_OP_ALL         Expression_Subquery_SetComparison_ReductionOp = 2
)

// Enum value maps for Expression_Subquery_SetComparison_ReductionOp.
var (
	Expression_Subquery_SetComparison_ReductionOp_name = map[int32]string{
		0: "REDUCTION_OP_UNSPECIFIED",
		1: "REDUCTION_OP_ANY",
		2: "REDUCTION_OP_ALL",
	}
	Expression_Subquery_SetComparison_ReductionOp_value = map[string]int32{
		"REDUCTION_OP_UNSPECIFIED": 0,
		"REDUCTION_OP_ANY":         1,
		"REDUCTION_OP_ALL":         2,
	}
)

func (x Expression_Subquery_SetComparison_ReductionOp) Enum() *Expression_Subquery_SetComparison_ReductionOp {
	p := new(Expression_Subquery_SetComparison_ReductionOp)
	*p = x
	return p
}

func (x Expression_Subquery_SetComparison_ReductionOp) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Expression_Subquery_SetComparison_ReductionOp) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[12].Descriptor()
}

func (Expression_Subquery_SetComparison_ReductionOp) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[12]
}

func (x Expression_Subquery_SetComparison_ReductionOp) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Expression_Subquery_SetComparison_ReductionOp.Descriptor instead.
func (Expression_Subquery_SetComparison_ReductionOp) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 14, 3, 1}
}

type SortField_SortDirection int32

const (
	SortField_SORT_DIRECTION_UNSPECIFIED      SortField_SortDirection = 0
	SortField_SORT_DIRECTION_ASC_NULLS_FIRST  SortField_SortDirection = 1
	SortField_SORT_DIRECTION_ASC_NULLS_LAST   SortField_SortDirection = 2
	SortField_SORT_DIRECTION_DESC_NULLS_FIRST SortField_SortDirection = 3
	SortField_SORT_DIRECTION_DESC_NULLS_LAST  SortField_SortDirection = 4
	SortField_SORT_DIRECTION_CLUSTERED        SortField_SortDirection = 5
)

// Enum value maps for SortField_SortDirection.
var (
	SortField_SortDirection_name = map[int32]string{
		0: "SORT_DIRECTION_UNSPECIFIED",
		1: "SORT_DIRECTION_ASC_NULLS_FIRST",
		2: "SORT_DIRECTION_ASC_NULLS_LAST",
		3: "SORT_DIRECTION_DESC_NULLS_FIRST",
		4: "SORT_DIRECTION_DESC_NULLS_LAST",
		5: "SORT_DIRECTION_CLUSTERED",
	}
	SortField_SortDirection_value = map[string]int32{
		"SORT_DIRECTION_UNSPECIFIED":      0,
		"SORT_DIRECTION_ASC_NULLS_FIRST":  1,
		"SORT_DIRECTION_ASC_NULLS_LAST":   2,
		"SORT_DIRECTION_DESC_NULLS_FIRST": 3,
		"SORT_DIRECTION_DESC_NULLS_LAST":  4,
		"SORT_DIRECTION_CLUSTERED":        5,
	}
)

func (x SortField_SortDirection) Enum() *SortField_SortDirection {
	p := new(SortField_SortDirection)
	*p = x
	return p
}

func (x SortField_SortDirection) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SortField_SortDirection) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[13].Descriptor()
}

func (SortField_SortDirection) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[13]
}

func (x SortField_SortDirection) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SortField_SortDirection.Descriptor instead.
func (SortField_SortDirection) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{25, 0}
}

// Method in which equivalent records are merged before being aggregated.
type AggregateFunction_AggregationInvocation int32

const (
	// This default value implies AGGREGATION_INVOCATION_ALL.
	AggregateFunction_AGGREGATION_INVOCATION_UNSPECIFIED AggregateFunction_AggregationInvocation = 0
	// Use all values in the aggregation calculation.
	AggregateFunction_AGGREGATION_INVOCATION_ALL AggregateFunction_AggregationInvocation = 1
	// Use only distinct values in the aggregation calculation.
	AggregateFunction_AGGREGATION_INVOCATION_DISTINCT AggregateFunction_AggregationInvocation = 2
)

// Enum value maps for AggregateFunction_AggregationInvocation.
var (
	AggregateFunction_AggregationInvocation_name = map[int32]string{
		0: "AGGREGATION_INVOCATION_UNSPECIFIED",
		1: "AGGREGATION_INVOCATION_ALL",
		2: "AGGREGATION_INVOCATION_DISTINCT",
	}
	AggregateFunction_AggregationInvocation_value = map[string]int32{
		"AGGREGATION_INVOCATION_UNSPECIFIED": 0,
		"AGGREGATION_INVOCATION_ALL":         1,
		"AGGREGATION_INVOCATION_DISTINCT":    2,
	}
)

func (x AggregateFunction_AggregationInvocation) Enum() *AggregateFunction_AggregationInvocation {
	p := new(AggregateFunction_AggregationInvocation)
	*p = x
	return p
}

func (x AggregateFunction_AggregationInvocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AggregateFunction_AggregationInvocation) Descriptor() protoreflect.EnumDescriptor {
	return file_substrait_algebra_proto_enumTypes[14].Descriptor()
}

func (AggregateFunction_AggregationInvocation) Type() protoreflect.EnumType {
	return &file_substrait_algebra_proto_enumTypes[14]
}

func (x AggregateFunction_AggregationInvocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AggregateFunction_AggregationInvocation.Descriptor instead.
func (AggregateFunction_AggregationInvocation) EnumDescriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{26, 0}
}

// Common fields for all relational operators
type RelCommon struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to EmitKind:
	//	*RelCommon_Direct_
	//	*RelCommon_Emit_
	EmitKind          isRelCommon_EmitKind          `protobuf_oneof:"emit_kind"`
	Hint              *RelCommon_Hint               `protobuf:"bytes,3,opt,name=hint,proto3" json:"hint,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,4,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *RelCommon) Reset() {
	*x = RelCommon{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelCommon) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelCommon) ProtoMessage() {}

func (x *RelCommon) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelCommon.ProtoReflect.Descriptor instead.
func (*RelCommon) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{0}
}

func (m *RelCommon) GetEmitKind() isRelCommon_EmitKind {
	if m != nil {
		return m.EmitKind
	}
	return nil
}

func (x *RelCommon) GetDirect() *RelCommon_Direct {
	if x, ok := x.GetEmitKind().(*RelCommon_Direct_); ok {
		return x.Direct
	}
	return nil
}

func (x *RelCommon) GetEmit() *RelCommon_Emit {
	if x, ok := x.GetEmitKind().(*RelCommon_Emit_); ok {
		return x.Emit
	}
	return nil
}

func (x *RelCommon) GetHint() *RelCommon_Hint {
	if x != nil {
		return x.Hint
	}
	return nil
}

func (x *RelCommon) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

type isRelCommon_EmitKind interface {
	isRelCommon_EmitKind()
}

type RelCommon_Direct_ struct {
	// The underlying relation is output as is (no reordering or projection of columns)
	Direct *RelCommon_Direct `protobuf:"bytes,1,opt,name=direct,proto3,oneof"`
}

type RelCommon_Emit_ struct {
	// Allows to control for order and inclusion of fields
	Emit *RelCommon_Emit `protobuf:"bytes,2,opt,name=emit,proto3,oneof"`
}

func (*RelCommon_Direct_) isRelCommon_EmitKind() {}

func (*RelCommon_Emit_) isRelCommon_EmitKind() {}

// The scan operator of base data (physical or virtual), including filtering and projection.
type ReadRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common            *RelCommon                    `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	BaseSchema        *NamedStruct                  `protobuf:"bytes,2,opt,name=base_schema,json=baseSchema,proto3" json:"base_schema,omitempty"`
	Filter            *Expression                   `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	BestEffortFilter  *Expression                   `protobuf:"bytes,11,opt,name=best_effort_filter,json=bestEffortFilter,proto3" json:"best_effort_filter,omitempty"`
	Projection        *Expression_MaskExpression    `protobuf:"bytes,4,opt,name=projection,proto3" json:"projection,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
	// Definition of which type of scan operation is to be performed
	//
	// Types that are assignable to ReadType:
	//	*ReadRel_VirtualTable_
	//	*ReadRel_LocalFiles_
	//	*ReadRel_NamedTable_
	//	*ReadRel_ExtensionTable_
	ReadType isReadRel_ReadType `protobuf_oneof:"read_type"`
}

func (x *ReadRel) Reset() {
	*x = ReadRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRel) ProtoMessage() {}

func (x *ReadRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRel.ProtoReflect.Descriptor instead.
func (*ReadRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{1}
}

func (x *ReadRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *ReadRel) GetBaseSchema() *NamedStruct {
	if x != nil {
		return x.BaseSchema
	}
	return nil
}

func (x *ReadRel) GetFilter() *Expression {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *ReadRel) GetBestEffortFilter() *Expression {
	if x != nil {
		return x.BestEffortFilter
	}
	return nil
}

func (x *ReadRel) GetProjection() *Expression_MaskExpression {
	if x != nil {
		return x.Projection
	}
	return nil
}

func (x *ReadRel) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

func (m *ReadRel) GetReadType() isReadRel_ReadType {
	if m != nil {
		return m.ReadType
	}
	return nil
}

func (x *ReadRel) GetVirtualTable() *ReadRel_VirtualTable {
	if x, ok := x.GetReadType().(*ReadRel_VirtualTable_); ok {
		return x.VirtualTable
	}
	return nil
}

func (x *ReadRel) GetLocalFiles() *ReadRel_LocalFiles {
	if x, ok := x.GetReadType().(*ReadRel_LocalFiles_); ok {
		return x.LocalFiles
	}
	return nil
}

func (x *ReadRel) GetNamedTable() *ReadRel_NamedTable {
	if x, ok := x.GetReadType().(*ReadRel_NamedTable_); ok {
		return x.NamedTable
	}
	return nil
}

func (x *ReadRel) GetExtensionTable() *ReadRel_ExtensionTable {
	if x, ok := x.GetReadType().(*ReadRel_ExtensionTable_); ok {
		return x.ExtensionTable
	}
	return nil
}

type isReadRel_ReadType interface {
	isReadRel_ReadType()
}

type ReadRel_VirtualTable_ struct {
	VirtualTable *ReadRel_VirtualTable `protobuf:"bytes,5,opt,name=virtual_table,json=virtualTable,proto3,oneof"`
}

type ReadRel_LocalFiles_ struct {
	LocalFiles *ReadRel_LocalFiles `protobuf:"bytes,6,opt,name=local_files,json=localFiles,proto3,oneof"`
}

type ReadRel_NamedTable_ struct {
	NamedTable *ReadRel_NamedTable `protobuf:"bytes,7,opt,name=named_table,json=namedTable,proto3,oneof"`
}

type ReadRel_ExtensionTable_ struct {
	ExtensionTable *ReadRel_ExtensionTable `protobuf:"bytes,8,opt,name=extension_table,json=extensionTable,proto3,oneof"`
}

func (*ReadRel_VirtualTable_) isReadRel_ReadType() {}

func (*ReadRel_LocalFiles_) isReadRel_ReadType() {}

func (*ReadRel_NamedTable_) isReadRel_ReadType() {}

func (*ReadRel_ExtensionTable_) isReadRel_ReadType() {}

// This operator allows to represent calculated expressions of fields (e.g., a+b). Direct/Emit are used to represent classical relational projections
type ProjectRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common            *RelCommon                    `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	Input             *Rel                          `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	Expressions       []*Expression                 `protobuf:"bytes,3,rep,name=expressions,proto3" json:"expressions,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *ProjectRel) Reset() {
	*x = ProjectRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProjectRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProjectRel) ProtoMessage() {}

func (x *ProjectRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProjectRel.ProtoReflect.Descriptor instead.
func (*ProjectRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{2}
}

func (x *ProjectRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *ProjectRel) GetInput() *Rel {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *ProjectRel) GetExpressions() []*Expression {
	if x != nil {
		return x.Expressions
	}
	return nil
}

func (x *ProjectRel) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// The binary JOIN relational operator left-join-right, including various join types, a join condition and post_join_filter expression
type JoinRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common            *RelCommon                    `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	Left              *Rel                          `protobuf:"bytes,2,opt,name=left,proto3" json:"left,omitempty"`
	Right             *Rel                          `protobuf:"bytes,3,opt,name=right,proto3" json:"right,omitempty"`
	Expression        *Expression                   `protobuf:"bytes,4,opt,name=expression,proto3" json:"expression,omitempty"`
	PostJoinFilter    *Expression                   `protobuf:"bytes,5,opt,name=post_join_filter,json=postJoinFilter,proto3" json:"post_join_filter,omitempty"`
	Type              JoinRel_JoinType              `protobuf:"varint,6,opt,name=type,proto3,enum=substrait.JoinRel_JoinType" json:"type,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *JoinRel) Reset() {
	*x = JoinRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JoinRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinRel) ProtoMessage() {}

func (x *JoinRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinRel.ProtoReflect.Descriptor instead.
func (*JoinRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{3}
}

func (x *JoinRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *JoinRel) GetLeft() *Rel {
	if x != nil {
		return x.Left
	}
	return nil
}

func (x *JoinRel) GetRight() *Rel {
	if x != nil {
		return x.Right
	}
	return nil
}

func (x *JoinRel) GetExpression() *Expression {
	if x != nil {
		return x.Expression
	}
	return nil
}

func (x *JoinRel) GetPostJoinFilter() *Expression {
	if x != nil {
		return x.PostJoinFilter
	}
	return nil
}

func (x *JoinRel) GetType() JoinRel_JoinType {
	if x != nil {
		return x.Type
	}
	return JoinRel_JOIN_TYPE_UNSPECIFIED
}

func (x *JoinRel) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// Cartesian product relational operator of two tables (left and right)
type CrossRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common            *RelCommon                    `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	Left              *Rel                          `protobuf:"bytes,2,opt,name=left,proto3" json:"left,omitempty"`
	Right             *Rel                          `protobuf:"bytes,3,opt,name=right,proto3" json:"right,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *CrossRel) Reset() {
	*x = CrossRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CrossRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CrossRel) ProtoMessage() {}

func (x *CrossRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CrossRel.ProtoReflect.Descriptor instead.
func (*CrossRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{4}
}

func (x *CrossRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *CrossRel) GetLeft() *Rel {
	if x != nil {
		return x.Left
	}
	return nil
}

func (x *CrossRel) GetRight() *Rel {
	if x != nil {
		return x.Right
	}
	return nil
}

func (x *CrossRel) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// The relational operator representing LIMIT/OFFSET or TOP type semantics.
type FetchRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common *RelCommon `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	Input  *Rel       `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	// the offset expressed in number of records
	Offset int64 `protobuf:"varint,3,opt,name=offset,proto3" json:"offset,omitempty"`
	// the amount of records to return
	Count             int64                         `protobuf:"varint,4,opt,name=count,proto3" json:"count,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *FetchRel) Reset() {
	*x = FetchRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchRel) ProtoMessage() {}

func (x *FetchRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchRel.ProtoReflect.Descriptor instead.
func (*FetchRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{5}
}

func (x *FetchRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *FetchRel) GetInput() *Rel {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *FetchRel) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *FetchRel) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *FetchRel) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// The relational operator representing a GROUP BY Aggregate
type AggregateRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common *RelCommon `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	// Input of the aggregation
	Input *Rel `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	// A list of expression grouping that the aggregation measured should be calculated for.
	Groupings []*AggregateRel_Grouping `protobuf:"bytes,3,rep,name=groupings,proto3" json:"groupings,omitempty"`
	// A list of one or more aggregate expressions along with an optional filter.
	Measures          []*AggregateRel_Measure       `protobuf:"bytes,4,rep,name=measures,proto3" json:"measures,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *AggregateRel) Reset() {
	*x = AggregateRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregateRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregateRel) ProtoMessage() {}

func (x *AggregateRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregateRel.ProtoReflect.Descriptor instead.
func (*AggregateRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{6}
}

func (x *AggregateRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *AggregateRel) GetInput() *Rel {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *AggregateRel) GetGroupings() []*AggregateRel_Grouping {
	if x != nil {
		return x.Groupings
	}
	return nil
}

func (x *AggregateRel) GetMeasures() []*AggregateRel_Measure {
	if x != nil {
		return x.Measures
	}
	return nil
}

func (x *AggregateRel) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// The ORDERY BY (or sorting) relational operator. Beside describing a base relation, it includes a list of fields to sort on
type SortRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common            *RelCommon                    `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	Input             *Rel                          `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	Sorts             []*SortField                  `protobuf:"bytes,3,rep,name=sorts,proto3" json:"sorts,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *SortRel) Reset() {
	*x = SortRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SortRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SortRel) ProtoMessage() {}

func (x *SortRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SortRel.ProtoReflect.Descriptor instead.
func (*SortRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{7}
}

func (x *SortRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *SortRel) GetInput() *Rel {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *SortRel) GetSorts() []*SortField {
	if x != nil {
		return x.Sorts
	}
	return nil
}

func (x *SortRel) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// The relational operator capturing simple FILTERs (as in the WHERE clause of SQL)
type FilterRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common            *RelCommon                    `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	Input             *Rel                          `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	Condition         *Expression                   `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *FilterRel) Reset() {
	*x = FilterRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilterRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterRel) ProtoMessage() {}

func (x *FilterRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterRel.ProtoReflect.Descriptor instead.
func (*FilterRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{8}
}

func (x *FilterRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *FilterRel) GetInput() *Rel {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *FilterRel) GetCondition() *Expression {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *FilterRel) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// The relational set operators (intersection/union/etc..)
type SetRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common *RelCommon `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	// The first input is the primary input, the remaining are secondary
	// inputs.  There must be at least two inputs.
	Inputs            []*Rel                        `protobuf:"bytes,2,rep,name=inputs,proto3" json:"inputs,omitempty"`
	Op                SetRel_SetOp                  `protobuf:"varint,3,opt,name=op,proto3,enum=substrait.SetRel_SetOp" json:"op,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *SetRel) Reset() {
	*x = SetRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetRel) ProtoMessage() {}

func (x *SetRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetRel.ProtoReflect.Descriptor instead.
func (*SetRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{9}
}

func (x *SetRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *SetRel) GetInputs() []*Rel {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *SetRel) GetOp() SetRel_SetOp {
	if x != nil {
		return x.Op
	}
	return SetRel_SET_OP_UNSPECIFIED
}

func (x *SetRel) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// Stub to support extension with a single input
type ExtensionSingleRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common *RelCommon `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	Input  *Rel       `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	Detail *anypb.Any `protobuf:"bytes,3,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (x *ExtensionSingleRel) Reset() {
	*x = ExtensionSingleRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExtensionSingleRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionSingleRel) ProtoMessage() {}

func (x *ExtensionSingleRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtensionSingleRel.ProtoReflect.Descriptor instead.
func (*ExtensionSingleRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{10}
}

func (x *ExtensionSingleRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *ExtensionSingleRel) GetInput() *Rel {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *ExtensionSingleRel) GetDetail() *anypb.Any {
	if x != nil {
		return x.Detail
	}
	return nil
}

// Stub to support extension with a zero inputs
type ExtensionLeafRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common *RelCommon `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	Detail *anypb.Any `protobuf:"bytes,2,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (x *ExtensionLeafRel) Reset() {
	*x = ExtensionLeafRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExtensionLeafRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionLeafRel) ProtoMessage() {}

func (x *ExtensionLeafRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtensionLeafRel.ProtoReflect.Descriptor instead.
func (*ExtensionLeafRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{11}
}

func (x *ExtensionLeafRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *ExtensionLeafRel) GetDetail() *anypb.Any {
	if x != nil {
		return x.Detail
	}
	return nil
}

// Stub to support extension with multiple inputs
type ExtensionMultiRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common *RelCommon `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	Inputs []*Rel     `protobuf:"bytes,2,rep,name=inputs,proto3" json:"inputs,omitempty"`
	Detail *anypb.Any `protobuf:"bytes,3,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (x *ExtensionMultiRel) Reset() {
	*x = ExtensionMultiRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExtensionMultiRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionMultiRel) ProtoMessage() {}

func (x *ExtensionMultiRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtensionMultiRel.ProtoReflect.Descriptor instead.
func (*ExtensionMultiRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{12}
}

func (x *ExtensionMultiRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *ExtensionMultiRel) GetInputs() []*Rel {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *ExtensionMultiRel) GetDetail() *anypb.Any {
	if x != nil {
		return x.Detail
	}
	return nil
}

// A redistribution operation
type ExchangeRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common         *RelCommon                    `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	Input          *Rel                          `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	PartitionCount int32                         `protobuf:"varint,3,opt,name=partition_count,json=partitionCount,proto3" json:"partition_count,omitempty"`
	Targets        []*ExchangeRel_ExchangeTarget `protobuf:"bytes,4,rep,name=targets,proto3" json:"targets,omitempty"`
	// the type of exchange used
	//
	// Types that are assignable to ExchangeKind:
	//	*ExchangeRel_ScatterByFields
	//	*ExchangeRel_SingleTarget
	//	*ExchangeRel_MultiTarget
	//	*ExchangeRel_RoundRobin_
	//	*ExchangeRel_Broadcast_
	ExchangeKind      isExchangeRel_ExchangeKind    `protobuf_oneof:"exchange_kind"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *ExchangeRel) Reset() {
	*x = ExchangeRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExchangeRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeRel) ProtoMessage() {}

func (x *ExchangeRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeRel.ProtoReflect.Descriptor instead.
func (*ExchangeRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{13}
}

func (x *ExchangeRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *ExchangeRel) GetInput() *Rel {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *ExchangeRel) GetPartitionCount() int32 {
	if x != nil {
		return x.PartitionCount
	}
	return 0
}

func (x *ExchangeRel) GetTargets() []*ExchangeRel_ExchangeTarget {
	if x != nil {
		return x.Targets
	}
	return nil
}

func (m *ExchangeRel) GetExchangeKind() isExchangeRel_ExchangeKind {
	if m != nil {
		return m.ExchangeKind
	}
	return nil
}

func (x *ExchangeRel) GetScatterByFields() *ExchangeRel_ScatterFields {
	if x, ok := x.GetExchangeKind().(*ExchangeRel_ScatterByFields); ok {
		return x.ScatterByFields
	}
	return nil
}

func (x *ExchangeRel) GetSingleTarget() *ExchangeRel_SingleBucketExpression {
	if x, ok := x.GetExchangeKind().(*ExchangeRel_SingleTarget); ok {
		return x.SingleTarget
	}
	return nil
}

func (x *ExchangeRel) GetMultiTarget() *ExchangeRel_MultiBucketExpression {
	if x, ok := x.GetExchangeKind().(*ExchangeRel_MultiTarget); ok {
		return x.MultiTarget
	}
	return nil
}

func (x *ExchangeRel) GetRoundRobin() *ExchangeRel_RoundRobin {
	if x, ok := x.GetExchangeKind().(*ExchangeRel_RoundRobin_); ok {
		return x.RoundRobin
	}
	return nil
}

func (x *ExchangeRel) GetBroadcast() *ExchangeRel_Broadcast {
	if x, ok := x.GetExchangeKind().(*ExchangeRel_Broadcast_); ok {
		return x.Broadcast
	}
	return nil
}

func (x *ExchangeRel) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

type isExchangeRel_ExchangeKind interface {
	isExchangeRel_ExchangeKind()
}

type ExchangeRel_ScatterByFields struct {
	ScatterByFields *ExchangeRel_ScatterFields `protobuf:"bytes,5,opt,name=scatter_by_fields,json=scatterByFields,proto3,oneof"`
}

type ExchangeRel_SingleTarget struct {
	SingleTarget *ExchangeRel_SingleBucketExpression `protobuf:"bytes,6,opt,name=single_target,json=singleTarget,proto3,oneof"`
}

type ExchangeRel_MultiTarget struct {
	MultiTarget *ExchangeRel_MultiBucketExpression `protobuf:"bytes,7,opt,name=multi_target,json=multiTarget,proto3,oneof"`
}

type ExchangeRel_RoundRobin_ struct {
	RoundRobin *ExchangeRel_RoundRobin `protobuf:"bytes,8,opt,name=round_robin,json=roundRobin,proto3,oneof"`
}

type ExchangeRel_Broadcast_ struct {
	Broadcast *ExchangeRel_Broadcast `protobuf:"bytes,9,opt,name=broadcast,proto3,oneof"`
}

func (*ExchangeRel_ScatterByFields) isExchangeRel_ExchangeKind() {}

func (*ExchangeRel_SingleTarget) isExchangeRel_ExchangeKind() {}

func (*ExchangeRel_MultiTarget) isExchangeRel_ExchangeKind() {}

func (*ExchangeRel_RoundRobin_) isExchangeRel_ExchangeKind() {}

func (*ExchangeRel_Broadcast_) isExchangeRel_ExchangeKind() {}

// A relation with output field names.
//
// This is for use at the root of a `Rel` tree.
type RelRoot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A relation
	Input *Rel `protobuf:"bytes,1,opt,name=input,proto3" json:"input,omitempty"`
	// Field names in depth-first order
	Names []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *RelRoot) Reset() {
	*x = RelRoot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelRoot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelRoot) ProtoMessage() {}

func (x *RelRoot) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelRoot.ProtoReflect.Descriptor instead.
func (*RelRoot) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{14}
}

func (x *RelRoot) GetInput() *Rel {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *RelRoot) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// A relation (used internally in a plan)
type Rel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to RelType:
	//	*Rel_Read
	//	*Rel_Filter
	//	*Rel_Fetch
	//	*Rel_Aggregate
	//	*Rel_Sort
	//	*Rel_Join
	//	*Rel_Project
	//	*Rel_Set
	//	*Rel_ExtensionSingle
	//	*Rel_ExtensionMulti
	//	*Rel_ExtensionLeaf
	//	*Rel_Cross
	//	*Rel_HashJoin
	//	*Rel_MergeJoin
	RelType isRel_RelType `protobuf_oneof:"rel_type"`
}

func (x *Rel) Reset() {
	*x = Rel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rel) ProtoMessage() {}

func (x *Rel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rel.ProtoReflect.Descriptor instead.
func (*Rel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{15}
}

func (m *Rel) GetRelType() isRel_RelType {
	if m != nil {
		return m.RelType
	}
	return nil
}

func (x *Rel) GetRead() *ReadRel {
	if x, ok := x.GetRelType().(*Rel_Read); ok {
		return x.Read
	}
	return nil
}

func (x *Rel) GetFilter() *FilterRel {
	if x, ok := x.GetRelType().(*Rel_Filter); ok {
		return x.Filter
	}
	return nil
}

func (x *Rel) GetFetch() *FetchRel {
	if x, ok := x.GetRelType().(*Rel_Fetch); ok {
		return x.Fetch
	}
	return nil
}

func (x *Rel) GetAggregate() *AggregateRel {
	if x, ok := x.GetRelType().(*Rel_Aggregate); ok {
		return x.Aggregate
	}
	return nil
}

func (x *Rel) GetSort() *SortRel {
	if x, ok := x.GetRelType().(*Rel_Sort); ok {
		return x.Sort
	}
	return nil
}

func (x *Rel) GetJoin() *JoinRel {
	if x, ok := x.GetRelType().(*Rel_Join); ok {
		return x.Join
	}
	return nil
}

func (x *Rel) GetProject() *ProjectRel {
	if x, ok := x.GetRelType().(*Rel_Project); ok {
		return x.Project
	}
	return nil
}

func (x *Rel) GetSet() *SetRel {
	if x, ok := x.GetRelType().(*Rel_Set); ok {
		return x.Set
	}
	return nil
}

func (x *Rel) GetExtensionSingle() *ExtensionSingleRel {
	if x, ok := x.GetRelType().(*Rel_ExtensionSingle); ok {
		return x.ExtensionSingle
	}
	return nil
}

func (x *Rel) GetExtensionMulti() *ExtensionMultiRel {
	if x, ok := x.GetRelType().(*Rel_ExtensionMulti); ok {
		return x.ExtensionMulti
	}
	return nil
}

func (x *Rel) GetExtensionLeaf() *ExtensionLeafRel {
	if x, ok := x.GetRelType().(*Rel_ExtensionLeaf); ok {
		return x.ExtensionLeaf
	}
	return nil
}

func (x *Rel) GetCross() *CrossRel {
	if x, ok := x.GetRelType().(*Rel_Cross); ok {
		return x.Cross
	}
	return nil
}

func (x *Rel) GetHashJoin() *HashJoinRel {
	if x, ok := x.GetRelType().(*Rel_HashJoin); ok {
		return x.HashJoin
	}
	return nil
}

func (x *Rel) GetMergeJoin() *MergeJoinRel {
	if x, ok := x.GetRelType().(*Rel_MergeJoin); ok {
		return x.MergeJoin
	}
	return nil
}

type isRel_RelType interface {
	isRel_RelType()
}

type Rel_Read struct {
	Read *ReadRel `protobuf:"bytes,1,opt,name=read,proto3,oneof"`
}

type Rel_Filter struct {
	Filter *FilterRel `protobuf:"bytes,2,opt,name=filter,proto3,oneof"`
}

type Rel_Fetch struct {
	Fetch *FetchRel `protobuf:"bytes,3,opt,name=fetch,proto3,oneof"`
}

type Rel_Aggregate struct {
	Aggregate *AggregateRel `protobuf:"bytes,4,opt,name=aggregate,proto3,oneof"`
}

type Rel_Sort struct {
	Sort *SortRel `protobuf:"bytes,5,opt,name=sort,proto3,oneof"`
}

type Rel_Join struct {
	Join *JoinRel `protobuf:"bytes,6,opt,name=join,proto3,oneof"`
}

type Rel_Project struct {
	Project *ProjectRel `protobuf:"bytes,7,opt,name=project,proto3,oneof"`
}

type Rel_Set struct {
	Set *SetRel `protobuf:"bytes,8,opt,name=set,proto3,oneof"`
}

type Rel_ExtensionSingle struct {
	ExtensionSingle *ExtensionSingleRel `protobuf:"bytes,9,opt,name=extension_single,json=extensionSingle,proto3,oneof"`
}

type Rel_ExtensionMulti struct {
	ExtensionMulti *ExtensionMultiRel `protobuf:"bytes,10,opt,name=extension_multi,json=extensionMulti,proto3,oneof"`
}

type Rel_ExtensionLeaf struct {
	ExtensionLeaf *ExtensionLeafRel `protobuf:"bytes,11,opt,name=extension_leaf,json=extensionLeaf,proto3,oneof"`
}

type Rel_Cross struct {
	Cross *CrossRel `protobuf:"bytes,12,opt,name=cross,proto3,oneof"`
}

type Rel_HashJoin struct {
	//Physical relations
	HashJoin *HashJoinRel `protobuf:"bytes,13,opt,name=hash_join,json=hashJoin,proto3,oneof"`
}

type Rel_MergeJoin struct {
	MergeJoin *MergeJoinRel `protobuf:"bytes,14,opt,name=merge_join,json=mergeJoin,proto3,oneof"`
}

func (*Rel_Read) isRel_RelType() {}

func (*Rel_Filter) isRel_RelType() {}

func (*Rel_Fetch) isRel_RelType() {}

func (*Rel_Aggregate) isRel_RelType() {}

func (*Rel_Sort) isRel_RelType() {}

func (*Rel_Join) isRel_RelType() {}

func (*Rel_Project) isRel_RelType() {}

func (*Rel_Set) isRel_RelType() {}

func (*Rel_ExtensionSingle) isRel_RelType() {}

func (*Rel_ExtensionMulti) isRel_RelType() {}

func (*Rel_ExtensionLeaf) isRel_RelType() {}

func (*Rel_Cross) isRel_RelType() {}

func (*Rel_HashJoin) isRel_RelType() {}

func (*Rel_MergeJoin) isRel_RelType() {}

// A base object for writing (e.g., a table or a view).
type NamedObjectWrite struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of string is used to represent namespacing (e.g., mydb.mytable).
	// This assumes shared catalog between systems exchanging a message.
	Names             []string                      `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *NamedObjectWrite) Reset() {
	*x = NamedObjectWrite{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamedObjectWrite) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamedObjectWrite) ProtoMessage() {}

func (x *NamedObjectWrite) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamedObjectWrite.ProtoReflect.Descriptor instead.
func (*NamedObjectWrite) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{16}
}

func (x *NamedObjectWrite) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

func (x *NamedObjectWrite) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// A stub type that can be used to extend/introduce new table types outside
// the specification.
type ExtensionObject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Detail *anypb.Any `protobuf:"bytes,1,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (x *ExtensionObject) Reset() {
	*x = ExtensionObject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExtensionObject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtensionObject) ProtoMessage() {}

func (x *ExtensionObject) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtensionObject.ProtoReflect.Descriptor instead.
func (*ExtensionObject) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{17}
}

func (x *ExtensionObject) GetDetail() *anypb.Any {
	if x != nil {
		return x.Detail
	}
	return nil
}

type DdlRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Definition of which type of object we are operating on
	//
	// Types that are assignable to WriteType:
	//	*DdlRel_NamedObject
	//	*DdlRel_ExtensionObject
	WriteType isDdlRel_WriteType `protobuf_oneof:"write_type"`
	// The columns that will be modified (representing after-image of a schema change)
	TableSchema *NamedStruct `protobuf:"bytes,3,opt,name=table_schema,json=tableSchema,proto3" json:"table_schema,omitempty"`
	// The default values for the columns (representing after-image of a schema change)
	// E.g., in case of an ALTER TABLE that changes some of the column default values, we expect
	// the table_defaults Struct to report a full list of default values reflecting the result of applying
	// the ALTER TABLE operator successfully
	TableDefaults *Expression_Literal_Struct `protobuf:"bytes,4,opt,name=table_defaults,json=tableDefaults,proto3" json:"table_defaults,omitempty"`
	// Which type of object we operate on
	Object DdlRel_DdlObject `protobuf:"varint,5,opt,name=object,proto3,enum=substrait.DdlRel_DdlObject" json:"object,omitempty"`
	// The type of operation to perform
	Op DdlRel_DdlOp `protobuf:"varint,6,opt,name=op,proto3,enum=substrait.DdlRel_DdlOp" json:"op,omitempty"`
	// The body of the CREATE VIEW
	ViewDefinition *Rel `protobuf:"bytes,7,opt,name=view_definition,json=viewDefinition,proto3" json:"view_definition,omitempty"`
}

func (x *DdlRel) Reset() {
	*x = DdlRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DdlRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DdlRel) ProtoMessage() {}

func (x *DdlRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DdlRel.ProtoReflect.Descriptor instead.
func (*DdlRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{18}
}

func (m *DdlRel) GetWriteType() isDdlRel_WriteType {
	if m != nil {
		return m.WriteType
	}
	return nil
}

func (x *DdlRel) GetNamedObject() *NamedObjectWrite {
	if x, ok := x.GetWriteType().(*DdlRel_NamedObject); ok {
		return x.NamedObject
	}
	return nil
}

func (x *DdlRel) GetExtensionObject() *ExtensionObject {
	if x, ok := x.GetWriteType().(*DdlRel_ExtensionObject); ok {
		return x.ExtensionObject
	}
	return nil
}

func (x *DdlRel) GetTableSchema() *NamedStruct {
	if x != nil {
		return x.TableSchema
	}
	return nil
}

func (x *DdlRel) GetTableDefaults() *Expression_Literal_Struct {
	if x != nil {
		return x.TableDefaults
	}
	return nil
}

func (x *DdlRel) GetObject() DdlRel_DdlObject {
	if x != nil {
		return x.Object
	}
	return DdlRel_DDL_OBJECT_UNSPECIFIED
}

func (x *DdlRel) GetOp() DdlRel_DdlOp {
	if x != nil {
		return x.Op
	}
	return DdlRel_DDL_OP_UNSPECIFIED
}

func (x *DdlRel) GetViewDefinition() *Rel {
	if x != nil {
		return x.ViewDefinition
	}
	return nil
}

type isDdlRel_WriteType interface {
	isDdlRel_WriteType()
}

type DdlRel_NamedObject struct {
	NamedObject *NamedObjectWrite `protobuf:"bytes,1,opt,name=named_object,json=namedObject,proto3,oneof"`
}

type DdlRel_ExtensionObject struct {
	ExtensionObject *ExtensionObject `protobuf:"bytes,2,opt,name=extension_object,json=extensionObject,proto3,oneof"`
}

func (*DdlRel_NamedObject) isDdlRel_WriteType() {}

func (*DdlRel_ExtensionObject) isDdlRel_WriteType() {}

// The operator that modifies the content of a database (operates on 1 table at a time, but tuple-selection/source can be
// based on joining of multiple tables).
type WriteRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Definition of which TABLE we are operating on
	//
	// Types that are assignable to WriteType:
	//	*WriteRel_NamedTable
	//	*WriteRel_ExtensionTable
	WriteType isWriteRel_WriteType `protobuf_oneof:"write_type"`
	// The schema of the table (must align with Rel input (e.g., number of leaf fields must match))
	TableSchema *NamedStruct `protobuf:"bytes,3,opt,name=table_schema,json=tableSchema,proto3" json:"table_schema,omitempty"`
	// The type of operation to perform
	Op WriteRel_WriteOp `protobuf:"varint,4,opt,name=op,proto3,enum=substrait.WriteRel_WriteOp" json:"op,omitempty"`
	// The relation that determines the tuples to add/remove/modify
	// the schema must match with table_schema. Default values must be explicitly stated
	// in a ProjectRel at the top of the input. The match must also
	// occur in case of DELETE to ensure multi-engine plans are unequivocal.
	Input *Rel `protobuf:"bytes,5,opt,name=input,proto3" json:"input,omitempty"`
	// Output mode determines what is the output of executing this rel
	Output WriteRel_OutputMode `protobuf:"varint,6,opt,name=output,proto3,enum=substrait.WriteRel_OutputMode" json:"output,omitempty"`
}

func (x *WriteRel) Reset() {
	*x = WriteRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteRel) ProtoMessage() {}

func (x *WriteRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteRel.ProtoReflect.Descriptor instead.
func (*WriteRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{19}
}

func (m *WriteRel) GetWriteType() isWriteRel_WriteType {
	if m != nil {
		return m.WriteType
	}
	return nil
}

func (x *WriteRel) GetNamedTable() *NamedObjectWrite {
	if x, ok := x.GetWriteType().(*WriteRel_NamedTable); ok {
		return x.NamedTable
	}
	return nil
}

func (x *WriteRel) GetExtensionTable() *ExtensionObject {
	if x, ok := x.GetWriteType().(*WriteRel_ExtensionTable); ok {
		return x.ExtensionTable
	}
	return nil
}

func (x *WriteRel) GetTableSchema() *NamedStruct {
	if x != nil {
		return x.TableSchema
	}
	return nil
}

func (x *WriteRel) GetOp() WriteRel_WriteOp {
	if x != nil {
		return x.Op
	}
	return WriteRel_WRITE_OP_UNSPECIFIED
}

func (x *WriteRel) GetInput() *Rel {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *WriteRel) GetOutput() WriteRel_OutputMode {
	if x != nil {
		return x.Output
	}
	return WriteRel_OUTPUT_MODE_UNSPECIFIED
}

type isWriteRel_WriteType interface {
	isWriteRel_WriteType()
}

type WriteRel_NamedTable struct {
	NamedTable *NamedObjectWrite `protobuf:"bytes,1,opt,name=named_table,json=namedTable,proto3,oneof"`
}

type WriteRel_ExtensionTable struct {
	ExtensionTable *ExtensionObject `protobuf:"bytes,2,opt,name=extension_table,json=extensionTable,proto3,oneof"`
}

func (*WriteRel_NamedTable) isWriteRel_WriteType() {}

func (*WriteRel_ExtensionTable) isWriteRel_WriteType() {}

// The hash equijoin join operator will build a hash table out of the right input based on a set of join keys.
// It will then probe that hash table for incoming inputs, finding matches.
type HashJoinRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common            *RelCommon                    `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	Left              *Rel                          `protobuf:"bytes,2,opt,name=left,proto3" json:"left,omitempty"`
	Right             *Rel                          `protobuf:"bytes,3,opt,name=right,proto3" json:"right,omitempty"`
	LeftKeys          []*Expression_FieldReference  `protobuf:"bytes,4,rep,name=left_keys,json=leftKeys,proto3" json:"left_keys,omitempty"`
	RightKeys         []*Expression_FieldReference  `protobuf:"bytes,5,rep,name=right_keys,json=rightKeys,proto3" json:"right_keys,omitempty"`
	PostJoinFilter    *Expression                   `protobuf:"bytes,6,opt,name=post_join_filter,json=postJoinFilter,proto3" json:"post_join_filter,omitempty"`
	Type              HashJoinRel_JoinType          `protobuf:"varint,7,opt,name=type,proto3,enum=substrait.HashJoinRel_JoinType" json:"type,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *HashJoinRel) Reset() {
	*x = HashJoinRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HashJoinRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HashJoinRel) ProtoMessage() {}

func (x *HashJoinRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HashJoinRel.ProtoReflect.Descriptor instead.
func (*HashJoinRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{20}
}

func (x *HashJoinRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *HashJoinRel) GetLeft() *Rel {
	if x != nil {
		return x.Left
	}
	return nil
}

func (x *HashJoinRel) GetRight() *Rel {
	if x != nil {
		return x.Right
	}
	return nil
}

func (x *HashJoinRel) GetLeftKeys() []*Expression_FieldReference {
	if x != nil {
		return x.LeftKeys
	}
	return nil
}

func (x *HashJoinRel) GetRightKeys() []*Expression_FieldReference {
	if x != nil {
		return x.RightKeys
	}
	return nil
}

func (x *HashJoinRel) GetPostJoinFilter() *Expression {
	if x != nil {
		return x.PostJoinFilter
	}
	return nil
}

func (x *HashJoinRel) GetType() HashJoinRel_JoinType {
	if x != nil {
		return x.Type
	}
	return HashJoinRel_JOIN_TYPE_UNSPECIFIED
}

func (x *HashJoinRel) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// The merge equijoin does a join by taking advantage of two sets that are sorted on the join keys.
// This allows the join operation to be done in a streaming fashion.
type MergeJoinRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Common            *RelCommon                    `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	Left              *Rel                          `protobuf:"bytes,2,opt,name=left,proto3" json:"left,omitempty"`
	Right             *Rel                          `protobuf:"bytes,3,opt,name=right,proto3" json:"right,omitempty"`
	LeftKeys          []*Expression_FieldReference  `protobuf:"bytes,4,rep,name=left_keys,json=leftKeys,proto3" json:"left_keys,omitempty"`
	RightKeys         []*Expression_FieldReference  `protobuf:"bytes,5,rep,name=right_keys,json=rightKeys,proto3" json:"right_keys,omitempty"`
	PostJoinFilter    *Expression                   `protobuf:"bytes,6,opt,name=post_join_filter,json=postJoinFilter,proto3" json:"post_join_filter,omitempty"`
	Type              MergeJoinRel_JoinType         `protobuf:"varint,7,opt,name=type,proto3,enum=substrait.MergeJoinRel_JoinType" json:"type,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *MergeJoinRel) Reset() {
	*x = MergeJoinRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MergeJoinRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeJoinRel) ProtoMessage() {}

func (x *MergeJoinRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeJoinRel.ProtoReflect.Descriptor instead.
func (*MergeJoinRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{21}
}

func (x *MergeJoinRel) GetCommon() *RelCommon {
	if x != nil {
		return x.Common
	}
	return nil
}

func (x *MergeJoinRel) GetLeft() *Rel {
	if x != nil {
		return x.Left
	}
	return nil
}

func (x *MergeJoinRel) GetRight() *Rel {
	if x != nil {
		return x.Right
	}
	return nil
}

func (x *MergeJoinRel) GetLeftKeys() []*Expression_FieldReference {
	if x != nil {
		return x.LeftKeys
	}
	return nil
}

func (x *MergeJoinRel) GetRightKeys() []*Expression_FieldReference {
	if x != nil {
		return x.RightKeys
	}
	return nil
}

func (x *MergeJoinRel) GetPostJoinFilter() *Expression {
	if x != nil {
		return x.PostJoinFilter
	}
	return nil
}

func (x *MergeJoinRel) GetType() MergeJoinRel_JoinType {
	if x != nil {
		return x.Type
	}
	return MergeJoinRel_JOIN_TYPE_UNSPECIFIED
}

func (x *MergeJoinRel) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// The argument of a function
type FunctionArgument struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ArgType:
	//	*FunctionArgument_Enum
	//	*FunctionArgument_Type
	//	*FunctionArgument_Value
	ArgType isFunctionArgument_ArgType `protobuf_oneof:"arg_type"`
}

func (x *FunctionArgument) Reset() {
	*x = FunctionArgument{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionArgument) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionArgument) ProtoMessage() {}

func (x *FunctionArgument) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionArgument.ProtoReflect.Descriptor instead.
func (*FunctionArgument) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{22}
}

func (m *FunctionArgument) GetArgType() isFunctionArgument_ArgType {
	if m != nil {
		return m.ArgType
	}
	return nil
}

func (x *FunctionArgument) GetEnum() string {
	if x, ok := x.GetArgType().(*FunctionArgument_Enum); ok {
		return x.Enum
	}
	return ""
}

func (x *FunctionArgument) GetType() *Type {
	if x, ok := x.GetArgType().(*FunctionArgument_Type); ok {
		return x.Type
	}
	return nil
}

func (x *FunctionArgument) GetValue() *Expression {
	if x, ok := x.GetArgType().(*FunctionArgument_Value); ok {
		return x.Value
	}
	return nil
}

type isFunctionArgument_ArgType interface {
	isFunctionArgument_ArgType()
}

type FunctionArgument_Enum struct {
	Enum string `protobuf:"bytes,1,opt,name=enum,proto3,oneof"`
}

type FunctionArgument_Type struct {
	Type *Type `protobuf:"bytes,2,opt,name=type,proto3,oneof"`
}

type FunctionArgument_Value struct {
	Value *Expression `protobuf:"bytes,3,opt,name=value,proto3,oneof"`
}

func (*FunctionArgument_Enum) isFunctionArgument_ArgType() {}

func (*FunctionArgument_Type) isFunctionArgument_ArgType() {}

func (*FunctionArgument_Value) isFunctionArgument_ArgType() {}

// An optional function argument.  Typically used for specifying behavior in
// invalid or corner cases.
type FunctionOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the option to set. If the consumer does not recognize the
	// option, it must reject the plan. The name is matched case-insensitively
	// with option names defined for the function.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// List of behavior options allowed by the producer. At least one must be
	// specified; to leave an option unspecified, simply don't add an entry to
	// `options`. The consumer must use the first option from the list that it
	// supports. If the consumer supports none of the specified options, it
	// must reject the plan. The name is matched case-insensitively and must
	// match one of the option values defined for the option.
	Preference []string `protobuf:"bytes,2,rep,name=preference,proto3" json:"preference,omitempty"`
}

func (x *FunctionOption) Reset() {
	*x = FunctionOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionOption) ProtoMessage() {}

func (x *FunctionOption) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionOption.ProtoReflect.Descriptor instead.
func (*FunctionOption) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{23}
}

func (x *FunctionOption) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FunctionOption) GetPreference() []string {
	if x != nil {
		return x.Preference
	}
	return nil
}

type Expression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to RexType:
	//	*Expression_Literal_
	//	*Expression_Selection
	//	*Expression_ScalarFunction_
	//	*Expression_WindowFunction_
	//	*Expression_IfThen_
	//	*Expression_SwitchExpression_
	//	*Expression_SingularOrList_
	//	*Expression_MultiOrList_
	//	*Expression_Cast_
	//	*Expression_Subquery_
	//	*Expression_Nested_
	//	*Expression_Enum_
	RexType isExpression_RexType `protobuf_oneof:"rex_type"`
}

func (x *Expression) Reset() {
	*x = Expression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression) ProtoMessage() {}

func (x *Expression) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression.ProtoReflect.Descriptor instead.
func (*Expression) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24}
}

func (m *Expression) GetRexType() isExpression_RexType {
	if m != nil {
		return m.RexType
	}
	return nil
}

func (x *Expression) GetLiteral() *Expression_Literal {
	if x, ok := x.GetRexType().(*Expression_Literal_); ok {
		return x.Literal
	}
	return nil
}

func (x *Expression) GetSelection() *Expression_FieldReference {
	if x, ok := x.GetRexType().(*Expression_Selection); ok {
		return x.Selection
	}
	return nil
}

func (x *Expression) GetScalarFunction() *Expression_ScalarFunction {
	if x, ok := x.GetRexType().(*Expression_ScalarFunction_); ok {
		return x.ScalarFunction
	}
	return nil
}

func (x *Expression) GetWindowFunction() *Expression_WindowFunction {
	if x, ok := x.GetRexType().(*Expression_WindowFunction_); ok {
		return x.WindowFunction
	}
	return nil
}

func (x *Expression) GetIfThen() *Expression_IfThen {
	if x, ok := x.GetRexType().(*Expression_IfThen_); ok {
		return x.IfThen
	}
	return nil
}

func (x *Expression) GetSwitchExpression() *Expression_SwitchExpression {
	if x, ok := x.GetRexType().(*Expression_SwitchExpression_); ok {
		return x.SwitchExpression
	}
	return nil
}

func (x *Expression) GetSingularOrList() *Expression_SingularOrList {
	if x, ok := x.GetRexType().(*Expression_SingularOrList_); ok {
		return x.SingularOrList
	}
	return nil
}

func (x *Expression) GetMultiOrList() *Expression_MultiOrList {
	if x, ok := x.GetRexType().(*Expression_MultiOrList_); ok {
		return x.MultiOrList
	}
	return nil
}

func (x *Expression) GetCast() *Expression_Cast {
	if x, ok := x.GetRexType().(*Expression_Cast_); ok {
		return x.Cast
	}
	return nil
}

func (x *Expression) GetSubquery() *Expression_Subquery {
	if x, ok := x.GetRexType().(*Expression_Subquery_); ok {
		return x.Subquery
	}
	return nil
}

func (x *Expression) GetNested() *Expression_Nested {
	if x, ok := x.GetRexType().(*Expression_Nested_); ok {
		return x.Nested
	}
	return nil
}

// Deprecated: Do not use.
func (x *Expression) GetEnum() *Expression_Enum {
	if x, ok := x.GetRexType().(*Expression_Enum_); ok {
		return x.Enum
	}
	return nil
}

type isExpression_RexType interface {
	isExpression_RexType()
}

type Expression_Literal_ struct {
	Literal *Expression_Literal `protobuf:"bytes,1,opt,name=literal,proto3,oneof"`
}

type Expression_Selection struct {
	Selection *Expression_FieldReference `protobuf:"bytes,2,opt,name=selection,proto3,oneof"`
}

type Expression_ScalarFunction_ struct {
	ScalarFunction *Expression_ScalarFunction `protobuf:"bytes,3,opt,name=scalar_function,json=scalarFunction,proto3,oneof"`
}

type Expression_WindowFunction_ struct {
	WindowFunction *Expression_WindowFunction `protobuf:"bytes,5,opt,name=window_function,json=windowFunction,proto3,oneof"`
}

type Expression_IfThen_ struct {
	IfThen *Expression_IfThen `protobuf:"bytes,6,opt,name=if_then,json=ifThen,proto3,oneof"`
}

type Expression_SwitchExpression_ struct {
	SwitchExpression *Expression_SwitchExpression `protobuf:"bytes,7,opt,name=switch_expression,json=switchExpression,proto3,oneof"`
}

type Expression_SingularOrList_ struct {
	SingularOrList *Expression_SingularOrList `protobuf:"bytes,8,opt,name=singular_or_list,json=singularOrList,proto3,oneof"`
}

type Expression_MultiOrList_ struct {
	MultiOrList *Expression_MultiOrList `protobuf:"bytes,9,opt,name=multi_or_list,json=multiOrList,proto3,oneof"`
}

type Expression_Cast_ struct {
	Cast *Expression_Cast `protobuf:"bytes,11,opt,name=cast,proto3,oneof"`
}

type Expression_Subquery_ struct {
	Subquery *Expression_Subquery `protobuf:"bytes,12,opt,name=subquery,proto3,oneof"`
}

type Expression_Nested_ struct {
	Nested *Expression_Nested `protobuf:"bytes,13,opt,name=nested,proto3,oneof"`
}

type Expression_Enum_ struct {
	// deprecated: enum literals are only sensible in the context of
	// function arguments, for which FunctionArgument should now be
	// used
	//
	// Deprecated: Do not use.
	Enum *Expression_Enum `protobuf:"bytes,10,opt,name=enum,proto3,oneof"`
}

func (*Expression_Literal_) isExpression_RexType() {}

func (*Expression_Selection) isExpression_RexType() {}

func (*Expression_ScalarFunction_) isExpression_RexType() {}

func (*Expression_WindowFunction_) isExpression_RexType() {}

func (*Expression_IfThen_) isExpression_RexType() {}

func (*Expression_SwitchExpression_) isExpression_RexType() {}

func (*Expression_SingularOrList_) isExpression_RexType() {}

func (*Expression_MultiOrList_) isExpression_RexType() {}

func (*Expression_Cast_) isExpression_RexType() {}

func (*Expression_Subquery_) isExpression_RexType() {}

func (*Expression_Nested_) isExpression_RexType() {}

func (*Expression_Enum_) isExpression_RexType() {}

// The description of a field to sort on (including the direction of sorting and null semantics)
type SortField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Expr *Expression `protobuf:"bytes,1,opt,name=expr,proto3" json:"expr,omitempty"`
	// Types that are assignable to SortKind:
	//	*SortField_Direction
	//	*SortField_ComparisonFunctionReference
	SortKind isSortField_SortKind `protobuf_oneof:"sort_kind"`
}

func (x *SortField) Reset() {
	*x = SortField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SortField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SortField) ProtoMessage() {}

func (x *SortField) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SortField.ProtoReflect.Descriptor instead.
func (*SortField) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{25}
}

func (x *SortField) GetExpr() *Expression {
	if x != nil {
		return x.Expr
	}
	return nil
}

func (m *SortField) GetSortKind() isSortField_SortKind {
	if m != nil {
		return m.SortKind
	}
	return nil
}

func (x *SortField) GetDirection() SortField_SortDirection {
	if x, ok := x.GetSortKind().(*SortField_Direction); ok {
		return x.Direction
	}
	return SortField_SORT_DIRECTION_UNSPECIFIED
}

func (x *SortField) GetComparisonFunctionReference() uint32 {
	if x, ok := x.GetSortKind().(*SortField_ComparisonFunctionReference); ok {
		return x.ComparisonFunctionReference
	}
	return 0
}

type isSortField_SortKind interface {
	isSortField_SortKind()
}

type SortField_Direction struct {
	Direction SortField_SortDirection `protobuf:"varint,2,opt,name=direction,proto3,enum=substrait.SortField_SortDirection,oneof"`
}

type SortField_ComparisonFunctionReference struct {
	ComparisonFunctionReference uint32 `protobuf:"varint,3,opt,name=comparison_function_reference,json=comparisonFunctionReference,proto3,oneof"`
}

func (*SortField_Direction) isSortField_SortKind() {}

func (*SortField_ComparisonFunctionReference) isSortField_SortKind() {}

// An aggregate function.
type AggregateFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Points to a function_anchor defined in this plan, which must refer
	// to an aggregate function in the associated YAML file. Required; 0 is
	// considered to be a valid anchor/reference.
	FunctionReference uint32 `protobuf:"varint,1,opt,name=function_reference,json=functionReference,proto3" json:"function_reference,omitempty"`
	// The arguments to be bound to the function. This must have exactly the
	// number of arguments specified in the function definition, and the
	// argument types must also match exactly:
	//
	//  - Value arguments must be bound using FunctionArgument.value, and
	//    the expression in that must yield a value of a type that a function
	//    overload is defined for.
	//  - Type arguments must be bound using FunctionArgument.type, and a
	//    function overload must be defined for that type.
	//  - Enum arguments must be bound using FunctionArgument.enum
	//    followed by Enum.specified, with a string that case-insensitively
	//    matches one of the allowed options.
	//  - Optional enum arguments must be bound using FunctionArgument.enum
	//    followed by either Enum.specified or Enum.unspecified. If specified,
	//    the string must case-insensitively match one of the allowed options.
	Arguments []*FunctionArgument `protobuf:"bytes,7,rep,name=arguments,proto3" json:"arguments,omitempty"`
	// Options to specify behavior for corner cases, or leave behavior
	// unspecified if the consumer does not need specific behavior in these
	// cases.
	Options []*FunctionOption `protobuf:"bytes,8,rep,name=options,proto3" json:"options,omitempty"`
	// Must be set to the return type of the function, exactly as derived
	// using the declaration in the extension.
	OutputType *Type `protobuf:"bytes,5,opt,name=output_type,json=outputType,proto3" json:"output_type,omitempty"`
	// Describes which part of the aggregation to perform within the context of
	// distributed algorithms. Required. Must be set to INITIAL_TO_RESULT for
	// aggregate functions that are not decomposable.
	Phase AggregationPhase `protobuf:"varint,4,opt,name=phase,proto3,enum=substrait.AggregationPhase" json:"phase,omitempty"`
	// If specified, the aggregated records are ordered according to this list
	// before they are aggregated. The first sort field has the highest
	// priority; only if a sort field determines two records to be equivalent is
	// the next field queried. This field is optional.
	Sorts []*SortField `protobuf:"bytes,3,rep,name=sorts,proto3" json:"sorts,omitempty"`
	// Specifies whether equivalent records are merged before being aggregated.
	// Optional, defaults to AGGREGATION_INVOCATION_ALL.
	Invocation AggregateFunction_AggregationInvocation `protobuf:"varint,6,opt,name=invocation,proto3,enum=substrait.AggregateFunction_AggregationInvocation" json:"invocation,omitempty"`
	// deprecated; use arguments instead
	//
	// Deprecated: Do not use.
	Args []*Expression `protobuf:"bytes,2,rep,name=args,proto3" json:"args,omitempty"`
}

func (x *AggregateFunction) Reset() {
	*x = AggregateFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregateFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregateFunction) ProtoMessage() {}

func (x *AggregateFunction) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregateFunction.ProtoReflect.Descriptor instead.
func (*AggregateFunction) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{26}
}

func (x *AggregateFunction) GetFunctionReference() uint32 {
	if x != nil {
		return x.FunctionReference
	}
	return 0
}

func (x *AggregateFunction) GetArguments() []*FunctionArgument {
	if x != nil {
		return x.Arguments
	}
	return nil
}

func (x *AggregateFunction) GetOptions() []*FunctionOption {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *AggregateFunction) GetOutputType() *Type {
	if x != nil {
		return x.OutputType
	}
	return nil
}

func (x *AggregateFunction) GetPhase() AggregationPhase {
	if x != nil {
		return x.Phase
	}
	return AggregationPhase_AGGREGATION_PHASE_UNSPECIFIED
}

func (x *AggregateFunction) GetSorts() []*SortField {
	if x != nil {
		return x.Sorts
	}
	return nil
}

func (x *AggregateFunction) GetInvocation() AggregateFunction_AggregationInvocation {
	if x != nil {
		return x.Invocation
	}
	return AggregateFunction_AGGREGATION_INVOCATION_UNSPECIFIED
}

// Deprecated: Do not use.
func (x *AggregateFunction) GetArgs() []*Expression {
	if x != nil {
		return x.Args
	}
	return nil
}

// Direct indicates no change on presence and ordering of fields in the output
type RelCommon_Direct struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RelCommon_Direct) Reset() {
	*x = RelCommon_Direct{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelCommon_Direct) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelCommon_Direct) ProtoMessage() {}

func (x *RelCommon_Direct) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelCommon_Direct.ProtoReflect.Descriptor instead.
func (*RelCommon_Direct) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{0, 0}
}

// Remap which fields are output and in which order
type RelCommon_Emit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OutputMapping []int32 `protobuf:"varint,1,rep,packed,name=output_mapping,json=outputMapping,proto3" json:"output_mapping,omitempty"`
}

func (x *RelCommon_Emit) Reset() {
	*x = RelCommon_Emit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelCommon_Emit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelCommon_Emit) ProtoMessage() {}

func (x *RelCommon_Emit) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelCommon_Emit.ProtoReflect.Descriptor instead.
func (*RelCommon_Emit) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{0, 1}
}

func (x *RelCommon_Emit) GetOutputMapping() []int32 {
	if x != nil {
		return x.OutputMapping
	}
	return nil
}

// Changes to the operation that can influence efficiency/performance but
// should not impact correctness.
type RelCommon_Hint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Stats             *RelCommon_Hint_Stats             `protobuf:"bytes,1,opt,name=stats,proto3" json:"stats,omitempty"`
	Constraint        *RelCommon_Hint_RuntimeConstraint `protobuf:"bytes,2,opt,name=constraint,proto3" json:"constraint,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension     `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *RelCommon_Hint) Reset() {
	*x = RelCommon_Hint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelCommon_Hint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelCommon_Hint) ProtoMessage() {}

func (x *RelCommon_Hint) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelCommon_Hint.ProtoReflect.Descriptor instead.
func (*RelCommon_Hint) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{0, 2}
}

func (x *RelCommon_Hint) GetStats() *RelCommon_Hint_Stats {
	if x != nil {
		return x.Stats
	}
	return nil
}

func (x *RelCommon_Hint) GetConstraint() *RelCommon_Hint_RuntimeConstraint {
	if x != nil {
		return x.Constraint
	}
	return nil
}

func (x *RelCommon_Hint) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// The statistics related to a hint (physical properties of records)
type RelCommon_Hint_Stats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RowCount          float64                       `protobuf:"fixed64,1,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	RecordSize        float64                       `protobuf:"fixed64,2,opt,name=record_size,json=recordSize,proto3" json:"record_size,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *RelCommon_Hint_Stats) Reset() {
	*x = RelCommon_Hint_Stats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelCommon_Hint_Stats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelCommon_Hint_Stats) ProtoMessage() {}

func (x *RelCommon_Hint_Stats) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelCommon_Hint_Stats.ProtoReflect.Descriptor instead.
func (*RelCommon_Hint_Stats) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *RelCommon_Hint_Stats) GetRowCount() float64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *RelCommon_Hint_Stats) GetRecordSize() float64 {
	if x != nil {
		return x.RecordSize
	}
	return 0
}

func (x *RelCommon_Hint_Stats) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

type RelCommon_Hint_RuntimeConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *RelCommon_Hint_RuntimeConstraint) Reset() {
	*x = RelCommon_Hint_RuntimeConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelCommon_Hint_RuntimeConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelCommon_Hint_RuntimeConstraint) ProtoMessage() {}

func (x *RelCommon_Hint_RuntimeConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelCommon_Hint_RuntimeConstraint.ProtoReflect.Descriptor instead.
func (*RelCommon_Hint_RuntimeConstraint) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{0, 2, 1}
}

func (x *RelCommon_Hint_RuntimeConstraint) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// A base table. The list of string is used to represent namespacing (e.g., mydb.mytable).
// This assumes shared catalog between systems exchanging a message.
type ReadRel_NamedTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Names             []string                      `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *ReadRel_NamedTable) Reset() {
	*x = ReadRel_NamedTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRel_NamedTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRel_NamedTable) ProtoMessage() {}

func (x *ReadRel_NamedTable) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRel_NamedTable.ProtoReflect.Descriptor instead.
func (*ReadRel_NamedTable) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ReadRel_NamedTable) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

func (x *ReadRel_NamedTable) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// A table composed of literals.
type ReadRel_VirtualTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Values []*Expression_Literal_Struct `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *ReadRel_VirtualTable) Reset() {
	*x = ReadRel_VirtualTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRel_VirtualTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRel_VirtualTable) ProtoMessage() {}

func (x *ReadRel_VirtualTable) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRel_VirtualTable.ProtoReflect.Descriptor instead.
func (*ReadRel_VirtualTable) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{1, 1}
}

func (x *ReadRel_VirtualTable) GetValues() []*Expression_Literal_Struct {
	if x != nil {
		return x.Values
	}
	return nil
}

// A stub type that can be used to extend/introduce new table types outside
// the specification.
type ReadRel_ExtensionTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Detail *anypb.Any `protobuf:"bytes,1,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (x *ReadRel_ExtensionTable) Reset() {
	*x = ReadRel_ExtensionTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRel_ExtensionTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRel_ExtensionTable) ProtoMessage() {}

func (x *ReadRel_ExtensionTable) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRel_ExtensionTable.ProtoReflect.Descriptor instead.
func (*ReadRel_ExtensionTable) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{1, 2}
}

func (x *ReadRel_ExtensionTable) GetDetail() *anypb.Any {
	if x != nil {
		return x.Detail
	}
	return nil
}

// Represents a list of files in input of a scan operation
type ReadRel_LocalFiles struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Items             []*ReadRel_LocalFiles_FileOrFiles `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	AdvancedExtension *extensions.AdvancedExtension     `protobuf:"bytes,10,opt,name=advanced_extension,json=advancedExtension,proto3" json:"advanced_extension,omitempty"`
}

func (x *ReadRel_LocalFiles) Reset() {
	*x = ReadRel_LocalFiles{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRel_LocalFiles) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRel_LocalFiles) ProtoMessage() {}

func (x *ReadRel_LocalFiles) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRel_LocalFiles.ProtoReflect.Descriptor instead.
func (*ReadRel_LocalFiles) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{1, 3}
}

func (x *ReadRel_LocalFiles) GetItems() []*ReadRel_LocalFiles_FileOrFiles {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *ReadRel_LocalFiles) GetAdvancedExtension() *extensions.AdvancedExtension {
	if x != nil {
		return x.AdvancedExtension
	}
	return nil
}

// Many files consist of indivisible chunks (e.g. parquet row groups
// or CSV rows).  If a slice partially selects an indivisible chunk
// then the consumer should employ some rule to decide which slice to
// include the chunk in (e.g. include it in the slice that contains
// the midpoint of the chunk)
type ReadRel_LocalFiles_FileOrFiles struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to PathType:
	//	*ReadRel_LocalFiles_FileOrFiles_UriPath
	//	*ReadRel_LocalFiles_FileOrFiles_UriPathGlob
	//	*ReadRel_LocalFiles_FileOrFiles_UriFile
	//	*ReadRel_LocalFiles_FileOrFiles_UriFolder
	PathType isReadRel_LocalFiles_FileOrFiles_PathType `protobuf_oneof:"path_type"`
	// The index of the partition this item belongs to
	PartitionIndex uint64 `protobuf:"varint,6,opt,name=partition_index,json=partitionIndex,proto3" json:"partition_index,omitempty"`
	// The start position in byte to read from this item
	Start uint64 `protobuf:"varint,7,opt,name=start,proto3" json:"start,omitempty"`
	// The length in byte to read from this item
	Length uint64 `protobuf:"varint,8,opt,name=length,proto3" json:"length,omitempty"`
	// The format of the files.
	//
	// Types that are assignable to FileFormat:
	//	*ReadRel_LocalFiles_FileOrFiles_Parquet
	//	*ReadRel_LocalFiles_FileOrFiles_Arrow
	//	*ReadRel_LocalFiles_FileOrFiles_Orc
	//	*ReadRel_LocalFiles_FileOrFiles_Extension
	//	*ReadRel_LocalFiles_FileOrFiles_Dwrf
	FileFormat isReadRel_LocalFiles_FileOrFiles_FileFormat `protobuf_oneof:"file_format"`
}

func (x *ReadRel_LocalFiles_FileOrFiles) Reset() {
	*x = ReadRel_LocalFiles_FileOrFiles{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRel_LocalFiles_FileOrFiles) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRel_LocalFiles_FileOrFiles) ProtoMessage() {}

func (x *ReadRel_LocalFiles_FileOrFiles) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRel_LocalFiles_FileOrFiles.ProtoReflect.Descriptor instead.
func (*ReadRel_LocalFiles_FileOrFiles) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{1, 3, 0}
}

func (m *ReadRel_LocalFiles_FileOrFiles) GetPathType() isReadRel_LocalFiles_FileOrFiles_PathType {
	if m != nil {
		return m.PathType
	}
	return nil
}

func (x *ReadRel_LocalFiles_FileOrFiles) GetUriPath() string {
	if x, ok := x.GetPathType().(*ReadRel_LocalFiles_FileOrFiles_UriPath); ok {
		return x.UriPath
	}
	return ""
}

func (x *ReadRel_LocalFiles_FileOrFiles) GetUriPathGlob() string {
	if x, ok := x.GetPathType().(*ReadRel_LocalFiles_FileOrFiles_UriPathGlob); ok {
		return x.UriPathGlob
	}
	return ""
}

func (x *ReadRel_LocalFiles_FileOrFiles) GetUriFile() string {
	if x, ok := x.GetPathType().(*ReadRel_LocalFiles_FileOrFiles_UriFile); ok {
		return x.UriFile
	}
	return ""
}

func (x *ReadRel_LocalFiles_FileOrFiles) GetUriFolder() string {
	if x, ok := x.GetPathType().(*ReadRel_LocalFiles_FileOrFiles_UriFolder); ok {
		return x.UriFolder
	}
	return ""
}

func (x *ReadRel_LocalFiles_FileOrFiles) GetPartitionIndex() uint64 {
	if x != nil {
		return x.PartitionIndex
	}
	return 0
}

func (x *ReadRel_LocalFiles_FileOrFiles) GetStart() uint64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *ReadRel_LocalFiles_FileOrFiles) GetLength() uint64 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (m *ReadRel_LocalFiles_FileOrFiles) GetFileFormat() isReadRel_LocalFiles_FileOrFiles_FileFormat {
	if m != nil {
		return m.FileFormat
	}
	return nil
}

func (x *ReadRel_LocalFiles_FileOrFiles) GetParquet() *ReadRel_LocalFiles_FileOrFiles_ParquetReadOptions {
	if x, ok := x.GetFileFormat().(*ReadRel_LocalFiles_FileOrFiles_Parquet); ok {
		return x.Parquet
	}
	return nil
}

func (x *ReadRel_LocalFiles_FileOrFiles) GetArrow() *ReadRel_LocalFiles_FileOrFiles_ArrowReadOptions {
	if x, ok := x.GetFileFormat().(*ReadRel_LocalFiles_FileOrFiles_Arrow); ok {
		return x.Arrow
	}
	return nil
}

func (x *ReadRel_LocalFiles_FileOrFiles) GetOrc() *ReadRel_LocalFiles_FileOrFiles_OrcReadOptions {
	if x, ok := x.GetFileFormat().(*ReadRel_LocalFiles_FileOrFiles_Orc); ok {
		return x.Orc
	}
	return nil
}

func (x *ReadRel_LocalFiles_FileOrFiles) GetExtension() *anypb.Any {
	if x, ok := x.GetFileFormat().(*ReadRel_LocalFiles_FileOrFiles_Extension); ok {
		return x.Extension
	}
	return nil
}

func (x *ReadRel_LocalFiles_FileOrFiles) GetDwrf() *ReadRel_LocalFiles_FileOrFiles_DwrfReadOptions {
	if x, ok := x.GetFileFormat().(*ReadRel_LocalFiles_FileOrFiles_Dwrf); ok {
		return x.Dwrf
	}
	return nil
}

type isReadRel_LocalFiles_FileOrFiles_PathType interface {
	isReadRel_LocalFiles_FileOrFiles_PathType()
}

type ReadRel_LocalFiles_FileOrFiles_UriPath struct {
	// A URI that can refer to either a single folder or a single file
	UriPath string `protobuf:"bytes,1,opt,name=uri_path,json=uriPath,proto3,oneof"`
}

type ReadRel_LocalFiles_FileOrFiles_UriPathGlob struct {
	// A URI where the path portion is a glob expression that can
	// identify zero or more paths.
	// Consumers should support the POSIX syntax.  The recursive
	// globstar (**) may not be supported.
	UriPathGlob string `protobuf:"bytes,2,opt,name=uri_path_glob,json=uriPathGlob,proto3,oneof"`
}

type ReadRel_LocalFiles_FileOrFiles_UriFile struct {
	// A URI that refers to a single file
	UriFile string `protobuf:"bytes,3,opt,name=uri_file,json=uriFile,proto3,oneof"`
}

type ReadRel_LocalFiles_FileOrFiles_UriFolder struct {
	// A URI that refers to a single folder
	UriFolder string `protobuf:"bytes,4,opt,name=uri_folder,json=uriFolder,proto3,oneof"`
}

func (*ReadRel_LocalFiles_FileOrFiles_UriPath) isReadRel_LocalFiles_FileOrFiles_PathType() {}

func (*ReadRel_LocalFiles_FileOrFiles_UriPathGlob) isReadRel_LocalFiles_FileOrFiles_PathType() {}

func (*ReadRel_LocalFiles_FileOrFiles_UriFile) isReadRel_LocalFiles_FileOrFiles_PathType() {}

func (*ReadRel_LocalFiles_FileOrFiles_UriFolder) isReadRel_LocalFiles_FileOrFiles_PathType() {}

type isReadRel_LocalFiles_FileOrFiles_FileFormat interface {
	isReadRel_LocalFiles_FileOrFiles_FileFormat()
}

type ReadRel_LocalFiles_FileOrFiles_Parquet struct {
	Parquet *ReadRel_LocalFiles_FileOrFiles_ParquetReadOptions `protobuf:"bytes,9,opt,name=parquet,proto3,oneof"`
}

type ReadRel_LocalFiles_FileOrFiles_Arrow struct {
	Arrow *ReadRel_LocalFiles_FileOrFiles_ArrowReadOptions `protobuf:"bytes,10,opt,name=arrow,proto3,oneof"`
}

type ReadRel_LocalFiles_FileOrFiles_Orc struct {
	Orc *ReadRel_LocalFiles_FileOrFiles_OrcReadOptions `protobuf:"bytes,11,opt,name=orc,proto3,oneof"`
}

type ReadRel_LocalFiles_FileOrFiles_Extension struct {
	Extension *anypb.Any `protobuf:"bytes,12,opt,name=extension,proto3,oneof"`
}

type ReadRel_LocalFiles_FileOrFiles_Dwrf struct {
	Dwrf *ReadRel_LocalFiles_FileOrFiles_DwrfReadOptions `protobuf:"bytes,13,opt,name=dwrf,proto3,oneof"`
}

func (*ReadRel_LocalFiles_FileOrFiles_Parquet) isReadRel_LocalFiles_FileOrFiles_FileFormat() {}

func (*ReadRel_LocalFiles_FileOrFiles_Arrow) isReadRel_LocalFiles_FileOrFiles_FileFormat() {}

func (*ReadRel_LocalFiles_FileOrFiles_Orc) isReadRel_LocalFiles_FileOrFiles_FileFormat() {}

func (*ReadRel_LocalFiles_FileOrFiles_Extension) isReadRel_LocalFiles_FileOrFiles_FileFormat() {}

func (*ReadRel_LocalFiles_FileOrFiles_Dwrf) isReadRel_LocalFiles_FileOrFiles_FileFormat() {}

type ReadRel_LocalFiles_FileOrFiles_ParquetReadOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReadRel_LocalFiles_FileOrFiles_ParquetReadOptions) Reset() {
	*x = ReadRel_LocalFiles_FileOrFiles_ParquetReadOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRel_LocalFiles_FileOrFiles_ParquetReadOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRel_LocalFiles_FileOrFiles_ParquetReadOptions) ProtoMessage() {}

func (x *ReadRel_LocalFiles_FileOrFiles_ParquetReadOptions) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRel_LocalFiles_FileOrFiles_ParquetReadOptions.ProtoReflect.Descriptor instead.
func (*ReadRel_LocalFiles_FileOrFiles_ParquetReadOptions) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{1, 3, 0, 0}
}

type ReadRel_LocalFiles_FileOrFiles_ArrowReadOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReadRel_LocalFiles_FileOrFiles_ArrowReadOptions) Reset() {
	*x = ReadRel_LocalFiles_FileOrFiles_ArrowReadOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRel_LocalFiles_FileOrFiles_ArrowReadOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRel_LocalFiles_FileOrFiles_ArrowReadOptions) ProtoMessage() {}

func (x *ReadRel_LocalFiles_FileOrFiles_ArrowReadOptions) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRel_LocalFiles_FileOrFiles_ArrowReadOptions.ProtoReflect.Descriptor instead.
func (*ReadRel_LocalFiles_FileOrFiles_ArrowReadOptions) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{1, 3, 0, 1}
}

type ReadRel_LocalFiles_FileOrFiles_OrcReadOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReadRel_LocalFiles_FileOrFiles_OrcReadOptions) Reset() {
	*x = ReadRel_LocalFiles_FileOrFiles_OrcReadOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRel_LocalFiles_FileOrFiles_OrcReadOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRel_LocalFiles_FileOrFiles_OrcReadOptions) ProtoMessage() {}

func (x *ReadRel_LocalFiles_FileOrFiles_OrcReadOptions) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRel_LocalFiles_FileOrFiles_OrcReadOptions.ProtoReflect.Descriptor instead.
func (*ReadRel_LocalFiles_FileOrFiles_OrcReadOptions) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{1, 3, 0, 2}
}

type ReadRel_LocalFiles_FileOrFiles_DwrfReadOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReadRel_LocalFiles_FileOrFiles_DwrfReadOptions) Reset() {
	*x = ReadRel_LocalFiles_FileOrFiles_DwrfReadOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRel_LocalFiles_FileOrFiles_DwrfReadOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRel_LocalFiles_FileOrFiles_DwrfReadOptions) ProtoMessage() {}

func (x *ReadRel_LocalFiles_FileOrFiles_DwrfReadOptions) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRel_LocalFiles_FileOrFiles_DwrfReadOptions.ProtoReflect.Descriptor instead.
func (*ReadRel_LocalFiles_FileOrFiles_DwrfReadOptions) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{1, 3, 0, 3}
}

type AggregateRel_Grouping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GroupingExpressions []*Expression `protobuf:"bytes,1,rep,name=grouping_expressions,json=groupingExpressions,proto3" json:"grouping_expressions,omitempty"`
}

func (x *AggregateRel_Grouping) Reset() {
	*x = AggregateRel_Grouping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregateRel_Grouping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregateRel_Grouping) ProtoMessage() {}

func (x *AggregateRel_Grouping) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregateRel_Grouping.ProtoReflect.Descriptor instead.
func (*AggregateRel_Grouping) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{6, 0}
}

func (x *AggregateRel_Grouping) GetGroupingExpressions() []*Expression {
	if x != nil {
		return x.GroupingExpressions
	}
	return nil
}

type AggregateRel_Measure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Measure *AggregateFunction `protobuf:"bytes,1,opt,name=measure,proto3" json:"measure,omitempty"`
	// An optional boolean expression that acts to filter which records are
	// included in the measure. True means include this record for calculation
	// within the measure.
	// Helps to support SUM(<c>) FILTER(WHERE...) syntax without masking opportunities for optimization
	Filter *Expression `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *AggregateRel_Measure) Reset() {
	*x = AggregateRel_Measure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregateRel_Measure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregateRel_Measure) ProtoMessage() {}

func (x *AggregateRel_Measure) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregateRel_Measure.ProtoReflect.Descriptor instead.
func (*AggregateRel_Measure) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{6, 1}
}

func (x *AggregateRel_Measure) GetMeasure() *AggregateFunction {
	if x != nil {
		return x.Measure
	}
	return nil
}

func (x *AggregateRel_Measure) GetFilter() *Expression {
	if x != nil {
		return x.Filter
	}
	return nil
}

type ExchangeRel_ScatterFields struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fields []*Expression_FieldReference `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *ExchangeRel_ScatterFields) Reset() {
	*x = ExchangeRel_ScatterFields{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExchangeRel_ScatterFields) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeRel_ScatterFields) ProtoMessage() {}

func (x *ExchangeRel_ScatterFields) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeRel_ScatterFields.ProtoReflect.Descriptor instead.
func (*ExchangeRel_ScatterFields) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{13, 0}
}

func (x *ExchangeRel_ScatterFields) GetFields() []*Expression_FieldReference {
	if x != nil {
		return x.Fields
	}
	return nil
}

// Returns a single bucket number per record.
type ExchangeRel_SingleBucketExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Expression *Expression `protobuf:"bytes,1,opt,name=expression,proto3" json:"expression,omitempty"`
}

func (x *ExchangeRel_SingleBucketExpression) Reset() {
	*x = ExchangeRel_SingleBucketExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExchangeRel_SingleBucketExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeRel_SingleBucketExpression) ProtoMessage() {}

func (x *ExchangeRel_SingleBucketExpression) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeRel_SingleBucketExpression.ProtoReflect.Descriptor instead.
func (*ExchangeRel_SingleBucketExpression) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{13, 1}
}

func (x *ExchangeRel_SingleBucketExpression) GetExpression() *Expression {
	if x != nil {
		return x.Expression
	}
	return nil
}

// Returns zero or more bucket numbers per record
type ExchangeRel_MultiBucketExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Expression         *Expression `protobuf:"bytes,1,opt,name=expression,proto3" json:"expression,omitempty"`
	ConstrainedToCount bool        `protobuf:"varint,2,opt,name=constrained_to_count,json=constrainedToCount,proto3" json:"constrained_to_count,omitempty"`
}

func (x *ExchangeRel_MultiBucketExpression) Reset() {
	*x = ExchangeRel_MultiBucketExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExchangeRel_MultiBucketExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeRel_MultiBucketExpression) ProtoMessage() {}

func (x *ExchangeRel_MultiBucketExpression) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeRel_MultiBucketExpression.ProtoReflect.Descriptor instead.
func (*ExchangeRel_MultiBucketExpression) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{13, 2}
}

func (x *ExchangeRel_MultiBucketExpression) GetExpression() *Expression {
	if x != nil {
		return x.Expression
	}
	return nil
}

func (x *ExchangeRel_MultiBucketExpression) GetConstrainedToCount() bool {
	if x != nil {
		return x.ConstrainedToCount
	}
	return false
}

// Send all data to every target.
type ExchangeRel_Broadcast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExchangeRel_Broadcast) Reset() {
	*x = ExchangeRel_Broadcast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExchangeRel_Broadcast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeRel_Broadcast) ProtoMessage() {}

func (x *ExchangeRel_Broadcast) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeRel_Broadcast.ProtoReflect.Descriptor instead.
func (*ExchangeRel_Broadcast) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{13, 3}
}

// Route approximately
type ExchangeRel_RoundRobin struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// whether the round robin behavior is required to exact (per record) or
	// approximate. Defaults to approximate.
	Exact bool `protobuf:"varint,1,opt,name=exact,proto3" json:"exact,omitempty"`
}

func (x *ExchangeRel_RoundRobin) Reset() {
	*x = ExchangeRel_RoundRobin{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExchangeRel_RoundRobin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeRel_RoundRobin) ProtoMessage() {}

func (x *ExchangeRel_RoundRobin) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeRel_RoundRobin.ProtoReflect.Descriptor instead.
func (*ExchangeRel_RoundRobin) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{13, 4}
}

func (x *ExchangeRel_RoundRobin) GetExact() bool {
	if x != nil {
		return x.Exact
	}
	return false
}

// The message to describe partition targets of an exchange
type ExchangeRel_ExchangeTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes the partition id(s) to send. If this is empty, all data is sent
	// to this target.
	PartitionId []int32 `protobuf:"varint,1,rep,packed,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	// Types that are assignable to TargetType:
	//	*ExchangeRel_ExchangeTarget_Uri
	//	*ExchangeRel_ExchangeTarget_Extended
	TargetType isExchangeRel_ExchangeTarget_TargetType `protobuf_oneof:"target_type"`
}

func (x *ExchangeRel_ExchangeTarget) Reset() {
	*x = ExchangeRel_ExchangeTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExchangeRel_ExchangeTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeRel_ExchangeTarget) ProtoMessage() {}

func (x *ExchangeRel_ExchangeTarget) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeRel_ExchangeTarget.ProtoReflect.Descriptor instead.
func (*ExchangeRel_ExchangeTarget) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{13, 5}
}

func (x *ExchangeRel_ExchangeTarget) GetPartitionId() []int32 {
	if x != nil {
		return x.PartitionId
	}
	return nil
}

func (m *ExchangeRel_ExchangeTarget) GetTargetType() isExchangeRel_ExchangeTarget_TargetType {
	if m != nil {
		return m.TargetType
	}
	return nil
}

func (x *ExchangeRel_ExchangeTarget) GetUri() string {
	if x, ok := x.GetTargetType().(*ExchangeRel_ExchangeTarget_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *ExchangeRel_ExchangeTarget) GetExtended() *anypb.Any {
	if x, ok := x.GetTargetType().(*ExchangeRel_ExchangeTarget_Extended); ok {
		return x.Extended
	}
	return nil
}

type isExchangeRel_ExchangeTarget_TargetType interface {
	isExchangeRel_ExchangeTarget_TargetType()
}

type ExchangeRel_ExchangeTarget_Uri struct {
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3,oneof"`
}

type ExchangeRel_ExchangeTarget_Extended struct {
	Extended *anypb.Any `protobuf:"bytes,3,opt,name=extended,proto3,oneof"`
}

func (*ExchangeRel_ExchangeTarget_Uri) isExchangeRel_ExchangeTarget_TargetType() {}

func (*ExchangeRel_ExchangeTarget_Extended) isExchangeRel_ExchangeTarget_TargetType() {}

// Deprecated: Do not use.
type Expression_Enum struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to EnumKind:
	//	*Expression_Enum_Specified
	//	*Expression_Enum_Unspecified
	EnumKind isExpression_Enum_EnumKind `protobuf_oneof:"enum_kind"`
}

func (x *Expression_Enum) Reset() {
	*x = Expression_Enum{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Enum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Enum) ProtoMessage() {}

func (x *Expression_Enum) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Enum.ProtoReflect.Descriptor instead.
func (*Expression_Enum) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 0}
}

func (m *Expression_Enum) GetEnumKind() isExpression_Enum_EnumKind {
	if m != nil {
		return m.EnumKind
	}
	return nil
}

func (x *Expression_Enum) GetSpecified() string {
	if x, ok := x.GetEnumKind().(*Expression_Enum_Specified); ok {
		return x.Specified
	}
	return ""
}

func (x *Expression_Enum) GetUnspecified() *Expression_Enum_Empty {
	if x, ok := x.GetEnumKind().(*Expression_Enum_Unspecified); ok {
		return x.Unspecified
	}
	return nil
}

type isExpression_Enum_EnumKind interface {
	isExpression_Enum_EnumKind()
}

type Expression_Enum_Specified struct {
	Specified string `protobuf:"bytes,1,opt,name=specified,proto3,oneof"`
}

type Expression_Enum_Unspecified struct {
	Unspecified *Expression_Enum_Empty `protobuf:"bytes,2,opt,name=unspecified,proto3,oneof"`
}

func (*Expression_Enum_Specified) isExpression_Enum_EnumKind() {}

func (*Expression_Enum_Unspecified) isExpression_Enum_EnumKind() {}

type Expression_Literal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to LiteralType:
	//	*Expression_Literal_Boolean
	//	*Expression_Literal_I8
	//	*Expression_Literal_I16
	//	*Expression_Literal_I32
	//	*Expression_Literal_I64
	//	*Expression_Literal_Fp32
	//	*Expression_Literal_Fp64
	//	*Expression_Literal_String_
	//	*Expression_Literal_Binary
	//	*Expression_Literal_Timestamp
	//	*Expression_Literal_Date
	//	*Expression_Literal_Time
	//	*Expression_Literal_IntervalYearToMonth_
	//	*Expression_Literal_IntervalDayToSecond_
	//	*Expression_Literal_FixedChar
	//	*Expression_Literal_VarChar_
	//	*Expression_Literal_FixedBinary
	//	*Expression_Literal_Decimal_
	//	*Expression_Literal_Struct_
	//	*Expression_Literal_Map_
	//	*Expression_Literal_TimestampTz
	//	*Expression_Literal_Uuid
	//	*Expression_Literal_Null
	//	*Expression_Literal_List_
	//	*Expression_Literal_EmptyList
	//	*Expression_Literal_EmptyMap
	//	*Expression_Literal_UserDefined_
	LiteralType isExpression_Literal_LiteralType `protobuf_oneof:"literal_type"`
	// whether the literal type should be treated as a nullable type. Applies to
	// all members of union other than the Typed null (which should directly
	// declare nullability).
	Nullable bool `protobuf:"varint,50,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// optionally points to a type_variation_anchor defined in this plan.
	// Applies to all members of union other than the Typed null (which should
	// directly declare the type variation).
	TypeVariationReference uint32 `protobuf:"varint,51,opt,name=type_variation_reference,json=typeVariationReference,proto3" json:"type_variation_reference,omitempty"`
}

func (x *Expression_Literal) Reset() {
	*x = Expression_Literal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Literal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Literal) ProtoMessage() {}

func (x *Expression_Literal) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Literal.ProtoReflect.Descriptor instead.
func (*Expression_Literal) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 1}
}

func (m *Expression_Literal) GetLiteralType() isExpression_Literal_LiteralType {
	if m != nil {
		return m.LiteralType
	}
	return nil
}

func (x *Expression_Literal) GetBoolean() bool {
	if x, ok := x.GetLiteralType().(*Expression_Literal_Boolean); ok {
		return x.Boolean
	}
	return false
}

func (x *Expression_Literal) GetI8() int32 {
	if x, ok := x.GetLiteralType().(*Expression_Literal_I8); ok {
		return x.I8
	}
	return 0
}

func (x *Expression_Literal) GetI16() int32 {
	if x, ok := x.GetLiteralType().(*Expression_Literal_I16); ok {
		return x.I16
	}
	return 0
}

func (x *Expression_Literal) GetI32() int32 {
	if x, ok := x.GetLiteralType().(*Expression_Literal_I32); ok {
		return x.I32
	}
	return 0
}

func (x *Expression_Literal) GetI64() int64 {
	if x, ok := x.GetLiteralType().(*Expression_Literal_I64); ok {
		return x.I64
	}
	return 0
}

func (x *Expression_Literal) GetFp32() float32 {
	if x, ok := x.GetLiteralType().(*Expression_Literal_Fp32); ok {
		return x.Fp32
	}
	return 0
}

func (x *Expression_Literal) GetFp64() float64 {
	if x, ok := x.GetLiteralType().(*Expression_Literal_Fp64); ok {
		return x.Fp64
	}
	return 0
}

func (x *Expression_Literal) GetString_() string {
	if x, ok := x.GetLiteralType().(*Expression_Literal_String_); ok {
		return x.String_
	}
	return ""
}

func (x *Expression_Literal) GetBinary() []byte {
	if x, ok := x.GetLiteralType().(*Expression_Literal_Binary); ok {
		return x.Binary
	}
	return nil
}

func (x *Expression_Literal) GetTimestamp() int64 {
	if x, ok := x.GetLiteralType().(*Expression_Literal_Timestamp); ok {
		return x.Timestamp
	}
	return 0
}

func (x *Expression_Literal) GetDate() int32 {
	if x, ok := x.GetLiteralType().(*Expression_Literal_Date); ok {
		return x.Date
	}
	return 0
}

func (x *Expression_Literal) GetTime() int64 {
	if x, ok := x.GetLiteralType().(*Expression_Literal_Time); ok {
		return x.Time
	}
	return 0
}

func (x *Expression_Literal) GetIntervalYearToMonth() *Expression_Literal_IntervalYearToMonth {
	if x, ok := x.GetLiteralType().(*Expression_Literal_IntervalYearToMonth_); ok {
		return x.IntervalYearToMonth
	}
	return nil
}

func (x *Expression_Literal) GetIntervalDayToSecond() *Expression_Literal_IntervalDayToSecond {
	if x, ok := x.GetLiteralType().(*Expression_Literal_IntervalDayToSecond_); ok {
		return x.IntervalDayToSecond
	}
	return nil
}

func (x *Expression_Literal) GetFixedChar() string {
	if x, ok := x.GetLiteralType().(*Expression_Literal_FixedChar); ok {
		return x.FixedChar
	}
	return ""
}

func (x *Expression_Literal) GetVarChar() *Expression_Literal_VarChar {
	if x, ok := x.GetLiteralType().(*Expression_Literal_VarChar_); ok {
		return x.VarChar
	}
	return nil
}

func (x *Expression_Literal) GetFixedBinary() []byte {
	if x, ok := x.GetLiteralType().(*Expression_Literal_FixedBinary); ok {
		return x.FixedBinary
	}
	return nil
}

func (x *Expression_Literal) GetDecimal() *Expression_Literal_Decimal {
	if x, ok := x.GetLiteralType().(*Expression_Literal_Decimal_); ok {
		return x.Decimal
	}
	return nil
}

func (x *Expression_Literal) GetStruct() *Expression_Literal_Struct {
	if x, ok := x.GetLiteralType().(*Expression_Literal_Struct_); ok {
		return x.Struct
	}
	return nil
}

func (x *Expression_Literal) GetMap() *Expression_Literal_Map {
	if x, ok := x.GetLiteralType().(*Expression_Literal_Map_); ok {
		return x.Map
	}
	return nil
}

func (x *Expression_Literal) GetTimestampTz() int64 {
	if x, ok := x.GetLiteralType().(*Expression_Literal_TimestampTz); ok {
		return x.TimestampTz
	}
	return 0
}

func (x *Expression_Literal) GetUuid() []byte {
	if x, ok := x.GetLiteralType().(*Expression_Literal_Uuid); ok {
		return x.Uuid
	}
	return nil
}

func (x *Expression_Literal) GetNull() *Type {
	if x, ok := x.GetLiteralType().(*Expression_Literal_Null); ok {
		return x.Null
	}
	return nil
}

func (x *Expression_Literal) GetList() *Expression_Literal_List {
	if x, ok := x.GetLiteralType().(*Expression_Literal_List_); ok {
		return x.List
	}
	return nil
}

func (x *Expression_Literal) GetEmptyList() *Type_List {
	if x, ok := x.GetLiteralType().(*Expression_Literal_EmptyList); ok {
		return x.EmptyList
	}
	return nil
}

func (x *Expression_Literal) GetEmptyMap() *Type_Map {
	if x, ok := x.GetLiteralType().(*Expression_Literal_EmptyMap); ok {
		return x.EmptyMap
	}
	return nil
}

func (x *Expression_Literal) GetUserDefined() *Expression_Literal_UserDefined {
	if x, ok := x.GetLiteralType().(*Expression_Literal_UserDefined_); ok {
		return x.UserDefined
	}
	return nil
}

func (x *Expression_Literal) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (x *Expression_Literal) GetTypeVariationReference() uint32 {
	if x != nil {
		return x.TypeVariationReference
	}
	return 0
}

type isExpression_Literal_LiteralType interface {
	isExpression_Literal_LiteralType()
}

type Expression_Literal_Boolean struct {
	Boolean bool `protobuf:"varint,1,opt,name=boolean,proto3,oneof"`
}

type Expression_Literal_I8 struct {
	I8 int32 `protobuf:"varint,2,opt,name=i8,proto3,oneof"`
}

type Expression_Literal_I16 struct {
	I16 int32 `protobuf:"varint,3,opt,name=i16,proto3,oneof"`
}

type Expression_Literal_I32 struct {
	I32 int32 `protobuf:"varint,5,opt,name=i32,proto3,oneof"`
}

type Expression_Literal_I64 struct {
	I64 int64 `protobuf:"varint,7,opt,name=i64,proto3,oneof"`
}

type Expression_Literal_Fp32 struct {
	Fp32 float32 `protobuf:"fixed32,10,opt,name=fp32,proto3,oneof"`
}

type Expression_Literal_Fp64 struct {
	Fp64 float64 `protobuf:"fixed64,11,opt,name=fp64,proto3,oneof"`
}

type Expression_Literal_String_ struct {
	String_ string `protobuf:"bytes,12,opt,name=string,proto3,oneof"`
}

type Expression_Literal_Binary struct {
	Binary []byte `protobuf:"bytes,13,opt,name=binary,proto3,oneof"`
}

type Expression_Literal_Timestamp struct {
	// Timestamp in units of microseconds since the UNIX epoch.
	Timestamp int64 `protobuf:"varint,14,opt,name=timestamp,proto3,oneof"`
}

type Expression_Literal_Date struct {
	// Date in units of days since the UNIX epoch.
	Date int32 `protobuf:"varint,16,opt,name=date,proto3,oneof"`
}

type Expression_Literal_Time struct {
	// Time in units of microseconds past midnight
	Time int64 `protobuf:"varint,17,opt,name=time,proto3,oneof"`
}

type Expression_Literal_IntervalYearToMonth_ struct {
	IntervalYearToMonth *Expression_Literal_IntervalYearToMonth `protobuf:"bytes,19,opt,name=interval_year_to_month,json=intervalYearToMonth,proto3,oneof"`
}

type Expression_Literal_IntervalDayToSecond_ struct {
	IntervalDayToSecond *Expression_Literal_IntervalDayToSecond `protobuf:"bytes,20,opt,name=interval_day_to_second,json=intervalDayToSecond,proto3,oneof"`
}

type Expression_Literal_FixedChar struct {
	FixedChar string `protobuf:"bytes,21,opt,name=fixed_char,json=fixedChar,proto3,oneof"`
}

type Expression_Literal_VarChar_ struct {
	VarChar *Expression_Literal_VarChar `protobuf:"bytes,22,opt,name=var_char,json=varChar,proto3,oneof"`
}

type Expression_Literal_FixedBinary struct {
	FixedBinary []byte `protobuf:"bytes,23,opt,name=fixed_binary,json=fixedBinary,proto3,oneof"`
}

type Expression_Literal_Decimal_ struct {
	Decimal *Expression_Literal_Decimal `protobuf:"bytes,24,opt,name=decimal,proto3,oneof"`
}

type Expression_Literal_Struct_ struct {
	Struct *Expression_Literal_Struct `protobuf:"bytes,25,opt,name=struct,proto3,oneof"`
}

type Expression_Literal_Map_ struct {
	Map *Expression_Literal_Map `protobuf:"bytes,26,opt,name=map,proto3,oneof"`
}

type Expression_Literal_TimestampTz struct {
	// Timestamp in units of microseconds since the UNIX epoch.
	TimestampTz int64 `protobuf:"varint,27,opt,name=timestamp_tz,json=timestampTz,proto3,oneof"`
}

type Expression_Literal_Uuid struct {
	Uuid []byte `protobuf:"bytes,28,opt,name=uuid,proto3,oneof"`
}

type Expression_Literal_Null struct {
	Null *Type `protobuf:"bytes,29,opt,name=null,proto3,oneof"` // a typed null literal
}

type Expression_Literal_List_ struct {
	List *Expression_Literal_List `protobuf:"bytes,30,opt,name=list,proto3,oneof"`
}

type Expression_Literal_EmptyList struct {
	EmptyList *Type_List `protobuf:"bytes,31,opt,name=empty_list,json=emptyList,proto3,oneof"`
}

type Expression_Literal_EmptyMap struct {
	EmptyMap *Type_Map `protobuf:"bytes,32,opt,name=empty_map,json=emptyMap,proto3,oneof"`
}

type Expression_Literal_UserDefined_ struct {
	UserDefined *Expression_Literal_UserDefined `protobuf:"bytes,33,opt,name=user_defined,json=userDefined,proto3,oneof"`
}

func (*Expression_Literal_Boolean) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_I8) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_I16) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_I32) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_I64) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_Fp32) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_Fp64) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_String_) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_Binary) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_Timestamp) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_Date) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_Time) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_IntervalYearToMonth_) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_IntervalDayToSecond_) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_FixedChar) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_VarChar_) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_FixedBinary) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_Decimal_) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_Struct_) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_Map_) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_TimestampTz) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_Uuid) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_Null) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_List_) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_EmptyList) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_EmptyMap) isExpression_Literal_LiteralType() {}

func (*Expression_Literal_UserDefined_) isExpression_Literal_LiteralType() {}

// Expression to dynamically construct nested types.
type Expression_Nested struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the returned nested type is nullable.
	Nullable bool `protobuf:"varint,1,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// Optionally points to a type_variation_anchor defined in this plan for
	// the returned nested type.
	TypeVariationReference uint32 `protobuf:"varint,2,opt,name=type_variation_reference,json=typeVariationReference,proto3" json:"type_variation_reference,omitempty"`
	// Types that are assignable to NestedType:
	//	*Expression_Nested_Struct_
	//	*Expression_Nested_List_
	//	*Expression_Nested_Map_
	NestedType isExpression_Nested_NestedType `protobuf_oneof:"nested_type"`
}

func (x *Expression_Nested) Reset() {
	*x = Expression_Nested{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Nested) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Nested) ProtoMessage() {}

func (x *Expression_Nested) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Nested.ProtoReflect.Descriptor instead.
func (*Expression_Nested) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 2}
}

func (x *Expression_Nested) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (x *Expression_Nested) GetTypeVariationReference() uint32 {
	if x != nil {
		return x.TypeVariationReference
	}
	return 0
}

func (m *Expression_Nested) GetNestedType() isExpression_Nested_NestedType {
	if m != nil {
		return m.NestedType
	}
	return nil
}

func (x *Expression_Nested) GetStruct() *Expression_Nested_Struct {
	if x, ok := x.GetNestedType().(*Expression_Nested_Struct_); ok {
		return x.Struct
	}
	return nil
}

func (x *Expression_Nested) GetList() *Expression_Nested_List {
	if x, ok := x.GetNestedType().(*Expression_Nested_List_); ok {
		return x.List
	}
	return nil
}

func (x *Expression_Nested) GetMap() *Expression_Nested_Map {
	if x, ok := x.GetNestedType().(*Expression_Nested_Map_); ok {
		return x.Map
	}
	return nil
}

type isExpression_Nested_NestedType interface {
	isExpression_Nested_NestedType()
}

type Expression_Nested_Struct_ struct {
	Struct *Expression_Nested_Struct `protobuf:"bytes,3,opt,name=struct,proto3,oneof"`
}

type Expression_Nested_List_ struct {
	List *Expression_Nested_List `protobuf:"bytes,4,opt,name=list,proto3,oneof"`
}

type Expression_Nested_Map_ struct {
	Map *Expression_Nested_Map `protobuf:"bytes,5,opt,name=map,proto3,oneof"`
}

func (*Expression_Nested_Struct_) isExpression_Nested_NestedType() {}

func (*Expression_Nested_List_) isExpression_Nested_NestedType() {}

func (*Expression_Nested_Map_) isExpression_Nested_NestedType() {}

// A scalar function call.
type Expression_ScalarFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Points to a function_anchor defined in this plan, which must refer
	// to a scalar function in the associated YAML file. Required; avoid
	// using anchor/reference zero.
	FunctionReference uint32 `protobuf:"varint,1,opt,name=function_reference,json=functionReference,proto3" json:"function_reference,omitempty"`
	// The arguments to be bound to the function. This must have exactly the
	// number of arguments specified in the function definition, and the
	// argument types must also match exactly:
	//
	//  - Value arguments must be bound using FunctionArgument.value, and
	//    the expression in that must yield a value of a type that a function
	//    overload is defined for.
	//  - Type arguments must be bound using FunctionArgument.type.
	//  - Enum arguments must be bound using FunctionArgument.enum
	//    followed by Enum.specified, with a string that case-insensitively
	//    matches one of the allowed options.
	Arguments []*FunctionArgument `protobuf:"bytes,4,rep,name=arguments,proto3" json:"arguments,omitempty"`
	// Options to specify behavior for corner cases, or leave behavior
	// unspecified if the consumer does not need specific behavior in these
	// cases.
	Options []*FunctionOption `protobuf:"bytes,5,rep,name=options,proto3" json:"options,omitempty"`
	// Must be set to the return type of the function, exactly as derived
	// using the declaration in the extension.
	OutputType *Type `protobuf:"bytes,3,opt,name=output_type,json=outputType,proto3" json:"output_type,omitempty"`
	// Deprecated; use arguments instead.
	//
	// Deprecated: Do not use.
	Args []*Expression `protobuf:"bytes,2,rep,name=args,proto3" json:"args,omitempty"`
}

func (x *Expression_ScalarFunction) Reset() {
	*x = Expression_ScalarFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_ScalarFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_ScalarFunction) ProtoMessage() {}

func (x *Expression_ScalarFunction) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_ScalarFunction.ProtoReflect.Descriptor instead.
func (*Expression_ScalarFunction) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 3}
}

func (x *Expression_ScalarFunction) GetFunctionReference() uint32 {
	if x != nil {
		return x.FunctionReference
	}
	return 0
}

func (x *Expression_ScalarFunction) GetArguments() []*FunctionArgument {
	if x != nil {
		return x.Arguments
	}
	return nil
}

func (x *Expression_ScalarFunction) GetOptions() []*FunctionOption {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Expression_ScalarFunction) GetOutputType() *Type {
	if x != nil {
		return x.OutputType
	}
	return nil
}

// Deprecated: Do not use.
func (x *Expression_ScalarFunction) GetArgs() []*Expression {
	if x != nil {
		return x.Args
	}
	return nil
}

// A window function call.
type Expression_WindowFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Points to a function_anchor defined in this plan, which must refer
	// to a window function in the associated YAML file. Required; 0 is
	// considered to be a valid anchor/reference.
	FunctionReference uint32 `protobuf:"varint,1,opt,name=function_reference,json=functionReference,proto3" json:"function_reference,omitempty"`
	// The arguments to be bound to the function. This must have exactly the
	// number of arguments specified in the function definition, and the
	// argument types must also match exactly:
	//
	//  - Value arguments must be bound using FunctionArgument.value, and
	//    the expression in that must yield a value of a type that a function
	//    overload is defined for.
	//  - Type arguments must be bound using FunctionArgument.type, and a
	//    function overload must be defined for that type.
	//  - Enum arguments must be bound using FunctionArgument.enum
	//    followed by Enum.specified, with a string that case-insensitively
	//    matches one of the allowed options.
	Arguments []*FunctionArgument `protobuf:"bytes,9,rep,name=arguments,proto3" json:"arguments,omitempty"`
	// Options to specify behavior for corner cases, or leave behavior
	// unspecified if the consumer does not need specific behavior in these
	// cases.
	Options []*FunctionOption `protobuf:"bytes,11,rep,name=options,proto3" json:"options,omitempty"`
	// Must be set to the return type of the function, exactly as derived
	// using the declaration in the extension.
	OutputType *Type `protobuf:"bytes,7,opt,name=output_type,json=outputType,proto3" json:"output_type,omitempty"`
	// Describes which part of the window function to perform within the
	// context of distributed algorithms. Required. Must be set to
	// INITIAL_TO_RESULT for window functions that are not decomposable.
	Phase AggregationPhase `protobuf:"varint,6,opt,name=phase,proto3,enum=substrait.AggregationPhase" json:"phase,omitempty"`
	// If specified, the records that are part of the window defined by
	// upper_bound and lower_bound are ordered according to this list
	// before they are aggregated. The first sort field has the highest
	// priority; only if a sort field determines two records to be equivalent
	// is the next field queried. This field is optional, and is only allowed
	// if the window function is defined to support sorting.
	Sorts []*SortField `protobuf:"bytes,3,rep,name=sorts,proto3" json:"sorts,omitempty"`
	// Specifies whether equivalent records are merged before being aggregated.
	// Optional, defaults to AGGREGATION_INVOCATION_ALL.
	Invocation AggregateFunction_AggregationInvocation `protobuf:"varint,10,opt,name=invocation,proto3,enum=substrait.AggregateFunction_AggregationInvocation" json:"invocation,omitempty"`
	// When one or more partition expressions are specified, two records are
	// considered to be in the same partition if and only if these expressions
	// yield an equal tuple of values for both. When computing the window
	// function, only the subset of records within the bounds that are also in
	// the same partition as the current record are aggregated.
	Partitions []*Expression `protobuf:"bytes,2,rep,name=partitions,proto3" json:"partitions,omitempty"`
	// Defines the record relative to the current record from which the window
	// extends. The bound is inclusive. If the lower bound indexes a record
	// greater than the upper bound, TODO (null range/no records passed?
	// wrapping around as if lower/upper were swapped? error? null?).
	// Optional; defaults to the start of the partition.
	LowerBound *Expression_WindowFunction_Bound `protobuf:"bytes,5,opt,name=lower_bound,json=lowerBound,proto3" json:"lower_bound,omitempty"`
	// Defines the record relative to the current record up to which the window
	// extends. The bound is inclusive. If the upper bound indexes a record
	// less than the lower bound, TODO (null range/no records passed?
	// wrapping around as if lower/upper were swapped? error? null?).
	// Optional; defaults to the end of the partition.
	UpperBound *Expression_WindowFunction_Bound `protobuf:"bytes,4,opt,name=upper_bound,json=upperBound,proto3" json:"upper_bound,omitempty"`
	// Deprecated; use arguments instead.
	//
	// Deprecated: Do not use.
	Args []*Expression `protobuf:"bytes,8,rep,name=args,proto3" json:"args,omitempty"`
}

func (x *Expression_WindowFunction) Reset() {
	*x = Expression_WindowFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_WindowFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_WindowFunction) ProtoMessage() {}

func (x *Expression_WindowFunction) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_WindowFunction.ProtoReflect.Descriptor instead.
func (*Expression_WindowFunction) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 4}
}

func (x *Expression_WindowFunction) GetFunctionReference() uint32 {
	if x != nil {
		return x.FunctionReference
	}
	return 0
}

func (x *Expression_WindowFunction) GetArguments() []*FunctionArgument {
	if x != nil {
		return x.Arguments
	}
	return nil
}

func (x *Expression_WindowFunction) GetOptions() []*FunctionOption {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Expression_WindowFunction) GetOutputType() *Type {
	if x != nil {
		return x.OutputType
	}
	return nil
}

func (x *Expression_WindowFunction) GetPhase() AggregationPhase {
	if x != nil {
		return x.Phase
	}
	return AggregationPhase_AGGREGATION_PHASE_UNSPECIFIED
}

func (x *Expression_WindowFunction) GetSorts() []*SortField {
	if x != nil {
		return x.Sorts
	}
	return nil
}

func (x *Expression_WindowFunction) GetInvocation() AggregateFunction_AggregationInvocation {
	if x != nil {
		return x.Invocation
	}
	return AggregateFunction_AGGREGATION_INVOCATION_UNSPECIFIED
}

func (x *Expression_WindowFunction) GetPartitions() []*Expression {
	if x != nil {
		return x.Partitions
	}
	return nil
}

func (x *Expression_WindowFunction) GetLowerBound() *Expression_WindowFunction_Bound {
	if x != nil {
		return x.LowerBound
	}
	return nil
}

func (x *Expression_WindowFunction) GetUpperBound() *Expression_WindowFunction_Bound {
	if x != nil {
		return x.UpperBound
	}
	return nil
}

// Deprecated: Do not use.
func (x *Expression_WindowFunction) GetArgs() []*Expression {
	if x != nil {
		return x.Args
	}
	return nil
}

type Expression_IfThen struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ifs  []*Expression_IfThen_IfClause `protobuf:"bytes,1,rep,name=ifs,proto3" json:"ifs,omitempty"`
	Else *Expression                   `protobuf:"bytes,2,opt,name=else,proto3" json:"else,omitempty"`
}

func (x *Expression_IfThen) Reset() {
	*x = Expression_IfThen{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_IfThen) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_IfThen) ProtoMessage() {}

func (x *Expression_IfThen) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_IfThen.ProtoReflect.Descriptor instead.
func (*Expression_IfThen) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 5}
}

func (x *Expression_IfThen) GetIfs() []*Expression_IfThen_IfClause {
	if x != nil {
		return x.Ifs
	}
	return nil
}

func (x *Expression_IfThen) GetElse() *Expression {
	if x != nil {
		return x.Else
	}
	return nil
}

type Expression_Cast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type            *Type                           `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Input           *Expression                     `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	FailureBehavior Expression_Cast_FailureBehavior `protobuf:"varint,3,opt,name=failure_behavior,json=failureBehavior,proto3,enum=substrait.Expression_Cast_FailureBehavior" json:"failure_behavior,omitempty"`
}

func (x *Expression_Cast) Reset() {
	*x = Expression_Cast{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Cast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Cast) ProtoMessage() {}

func (x *Expression_Cast) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Cast.ProtoReflect.Descriptor instead.
func (*Expression_Cast) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 6}
}

func (x *Expression_Cast) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Expression_Cast) GetInput() *Expression {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *Expression_Cast) GetFailureBehavior() Expression_Cast_FailureBehavior {
	if x != nil {
		return x.FailureBehavior
	}
	return Expression_Cast_FAILURE_BEHAVIOR_UNSPECIFIED
}

type Expression_SwitchExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Match *Expression                            `protobuf:"bytes,3,opt,name=match,proto3" json:"match,omitempty"`
	Ifs   []*Expression_SwitchExpression_IfValue `protobuf:"bytes,1,rep,name=ifs,proto3" json:"ifs,omitempty"`
	Else  *Expression                            `protobuf:"bytes,2,opt,name=else,proto3" json:"else,omitempty"`
}

func (x *Expression_SwitchExpression) Reset() {
	*x = Expression_SwitchExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_SwitchExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_SwitchExpression) ProtoMessage() {}

func (x *Expression_SwitchExpression) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_SwitchExpression.ProtoReflect.Descriptor instead.
func (*Expression_SwitchExpression) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 7}
}

func (x *Expression_SwitchExpression) GetMatch() *Expression {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *Expression_SwitchExpression) GetIfs() []*Expression_SwitchExpression_IfValue {
	if x != nil {
		return x.Ifs
	}
	return nil
}

func (x *Expression_SwitchExpression) GetElse() *Expression {
	if x != nil {
		return x.Else
	}
	return nil
}

type Expression_SingularOrList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value   *Expression   `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Options []*Expression `protobuf:"bytes,2,rep,name=options,proto3" json:"options,omitempty"`
}

func (x *Expression_SingularOrList) Reset() {
	*x = Expression_SingularOrList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_SingularOrList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_SingularOrList) ProtoMessage() {}

func (x *Expression_SingularOrList) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_SingularOrList.ProtoReflect.Descriptor instead.
func (*Expression_SingularOrList) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 8}
}

func (x *Expression_SingularOrList) GetValue() *Expression {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Expression_SingularOrList) GetOptions() []*Expression {
	if x != nil {
		return x.Options
	}
	return nil
}

type Expression_MultiOrList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value   []*Expression                    `protobuf:"bytes,1,rep,name=value,proto3" json:"value,omitempty"`
	Options []*Expression_MultiOrList_Record `protobuf:"bytes,2,rep,name=options,proto3" json:"options,omitempty"`
}

func (x *Expression_MultiOrList) Reset() {
	*x = Expression_MultiOrList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MultiOrList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MultiOrList) ProtoMessage() {}

func (x *Expression_MultiOrList) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MultiOrList.ProtoReflect.Descriptor instead.
func (*Expression_MultiOrList) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 9}
}

func (x *Expression_MultiOrList) GetValue() []*Expression {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Expression_MultiOrList) GetOptions() []*Expression_MultiOrList_Record {
	if x != nil {
		return x.Options
	}
	return nil
}

type Expression_EmbeddedFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Arguments  []*Expression `protobuf:"bytes,1,rep,name=arguments,proto3" json:"arguments,omitempty"`
	OutputType *Type         `protobuf:"bytes,2,opt,name=output_type,json=outputType,proto3" json:"output_type,omitempty"`
	// Types that are assignable to Kind:
	//	*Expression_EmbeddedFunction_PythonPickleFunction_
	//	*Expression_EmbeddedFunction_WebAssemblyFunction_
	Kind isExpression_EmbeddedFunction_Kind `protobuf_oneof:"kind"`
}

func (x *Expression_EmbeddedFunction) Reset() {
	*x = Expression_EmbeddedFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_EmbeddedFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_EmbeddedFunction) ProtoMessage() {}

func (x *Expression_EmbeddedFunction) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_EmbeddedFunction.ProtoReflect.Descriptor instead.
func (*Expression_EmbeddedFunction) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 10}
}

func (x *Expression_EmbeddedFunction) GetArguments() []*Expression {
	if x != nil {
		return x.Arguments
	}
	return nil
}

func (x *Expression_EmbeddedFunction) GetOutputType() *Type {
	if x != nil {
		return x.OutputType
	}
	return nil
}

func (m *Expression_EmbeddedFunction) GetKind() isExpression_EmbeddedFunction_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *Expression_EmbeddedFunction) GetPythonPickleFunction() *Expression_EmbeddedFunction_PythonPickleFunction {
	if x, ok := x.GetKind().(*Expression_EmbeddedFunction_PythonPickleFunction_); ok {
		return x.PythonPickleFunction
	}
	return nil
}

func (x *Expression_EmbeddedFunction) GetWebAssemblyFunction() *Expression_EmbeddedFunction_WebAssemblyFunction {
	if x, ok := x.GetKind().(*Expression_EmbeddedFunction_WebAssemblyFunction_); ok {
		return x.WebAssemblyFunction
	}
	return nil
}

type isExpression_EmbeddedFunction_Kind interface {
	isExpression_EmbeddedFunction_Kind()
}

type Expression_EmbeddedFunction_PythonPickleFunction_ struct {
	PythonPickleFunction *Expression_EmbeddedFunction_PythonPickleFunction `protobuf:"bytes,3,opt,name=python_pickle_function,json=pythonPickleFunction,proto3,oneof"`
}

type Expression_EmbeddedFunction_WebAssemblyFunction_ struct {
	WebAssemblyFunction *Expression_EmbeddedFunction_WebAssemblyFunction `protobuf:"bytes,4,opt,name=web_assembly_function,json=webAssemblyFunction,proto3,oneof"`
}

func (*Expression_EmbeddedFunction_PythonPickleFunction_) isExpression_EmbeddedFunction_Kind() {}

func (*Expression_EmbeddedFunction_WebAssemblyFunction_) isExpression_EmbeddedFunction_Kind() {}

// A way to reference the inner property of a complex record. Can reference
// either a map key by literal, a struct field by the ordinal position of
// the desired field or a particular element in an array. Supports
// expressions that would roughly translate to something similar to:
// a.b[2].c['my_map_key'].x where a,b,c and x are struct field references
// (ordinalized in the internal representation here), [2] is a list offset
// and ['my_map_key'] is a reference into a map field.
type Expression_ReferenceSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ReferenceType:
	//	*Expression_ReferenceSegment_MapKey_
	//	*Expression_ReferenceSegment_StructField_
	//	*Expression_ReferenceSegment_ListElement_
	ReferenceType isExpression_ReferenceSegment_ReferenceType `protobuf_oneof:"reference_type"`
}

func (x *Expression_ReferenceSegment) Reset() {
	*x = Expression_ReferenceSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_ReferenceSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_ReferenceSegment) ProtoMessage() {}

func (x *Expression_ReferenceSegment) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_ReferenceSegment.ProtoReflect.Descriptor instead.
func (*Expression_ReferenceSegment) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 11}
}

func (m *Expression_ReferenceSegment) GetReferenceType() isExpression_ReferenceSegment_ReferenceType {
	if m != nil {
		return m.ReferenceType
	}
	return nil
}

func (x *Expression_ReferenceSegment) GetMapKey() *Expression_ReferenceSegment_MapKey {
	if x, ok := x.GetReferenceType().(*Expression_ReferenceSegment_MapKey_); ok {
		return x.MapKey
	}
	return nil
}

func (x *Expression_ReferenceSegment) GetStructField() *Expression_ReferenceSegment_StructField {
	if x, ok := x.GetReferenceType().(*Expression_ReferenceSegment_StructField_); ok {
		return x.StructField
	}
	return nil
}

func (x *Expression_ReferenceSegment) GetListElement() *Expression_ReferenceSegment_ListElement {
	if x, ok := x.GetReferenceType().(*Expression_ReferenceSegment_ListElement_); ok {
		return x.ListElement
	}
	return nil
}

type isExpression_ReferenceSegment_ReferenceType interface {
	isExpression_ReferenceSegment_ReferenceType()
}

type Expression_ReferenceSegment_MapKey_ struct {
	MapKey *Expression_ReferenceSegment_MapKey `protobuf:"bytes,1,opt,name=map_key,json=mapKey,proto3,oneof"`
}

type Expression_ReferenceSegment_StructField_ struct {
	StructField *Expression_ReferenceSegment_StructField `protobuf:"bytes,2,opt,name=struct_field,json=structField,proto3,oneof"`
}

type Expression_ReferenceSegment_ListElement_ struct {
	ListElement *Expression_ReferenceSegment_ListElement `protobuf:"bytes,3,opt,name=list_element,json=listElement,proto3,oneof"`
}

func (*Expression_ReferenceSegment_MapKey_) isExpression_ReferenceSegment_ReferenceType() {}

func (*Expression_ReferenceSegment_StructField_) isExpression_ReferenceSegment_ReferenceType() {}

func (*Expression_ReferenceSegment_ListElement_) isExpression_ReferenceSegment_ReferenceType() {}

// A reference that takes an existing subtype and selectively removes fields
// from it. For example, one might initially have an inner struct with 100
// fields but a a particular operation only needs to interact with only 2 of
// those 100 fields. In this situation, one would use a mask expression to
// eliminate the 98 fields that are not relevant to the rest of the operation
// pipeline.
//
// Note that this does not fundamentally alter the structure of data beyond
// the elimination of unnecessary elements.
type Expression_MaskExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Select                 *Expression_MaskExpression_StructSelect `protobuf:"bytes,1,opt,name=select,proto3" json:"select,omitempty"`
	MaintainSingularStruct bool                                    `protobuf:"varint,2,opt,name=maintain_singular_struct,json=maintainSingularStruct,proto3" json:"maintain_singular_struct,omitempty"`
}

func (x *Expression_MaskExpression) Reset() {
	*x = Expression_MaskExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MaskExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MaskExpression) ProtoMessage() {}

func (x *Expression_MaskExpression) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MaskExpression.ProtoReflect.Descriptor instead.
func (*Expression_MaskExpression) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 12}
}

func (x *Expression_MaskExpression) GetSelect() *Expression_MaskExpression_StructSelect {
	if x != nil {
		return x.Select
	}
	return nil
}

func (x *Expression_MaskExpression) GetMaintainSingularStruct() bool {
	if x != nil {
		return x.MaintainSingularStruct
	}
	return false
}

// A reference to an inner part of a complex object. Can reference reference a
// single element or a masked version of elements
type Expression_FieldReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether this is composed of a single element reference or a masked
	// element subtree
	//
	// Types that are assignable to ReferenceType:
	//	*Expression_FieldReference_DirectReference
	//	*Expression_FieldReference_MaskedReference
	ReferenceType isExpression_FieldReference_ReferenceType `protobuf_oneof:"reference_type"`
	// Whether this reference has an origin of a root struct or is based on the
	// ouput of an expression. When this is a RootReference and direct_reference
	// above is used, the direct_reference must be of a type StructField.
	//
	// Types that are assignable to RootType:
	//	*Expression_FieldReference_Expression
	//	*Expression_FieldReference_RootReference_
	//	*Expression_FieldReference_OuterReference_
	RootType isExpression_FieldReference_RootType `protobuf_oneof:"root_type"`
}

func (x *Expression_FieldReference) Reset() {
	*x = Expression_FieldReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_FieldReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_FieldReference) ProtoMessage() {}

func (x *Expression_FieldReference) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_FieldReference.ProtoReflect.Descriptor instead.
func (*Expression_FieldReference) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 13}
}

func (m *Expression_FieldReference) GetReferenceType() isExpression_FieldReference_ReferenceType {
	if m != nil {
		return m.ReferenceType
	}
	return nil
}

func (x *Expression_FieldReference) GetDirectReference() *Expression_ReferenceSegment {
	if x, ok := x.GetReferenceType().(*Expression_FieldReference_DirectReference); ok {
		return x.DirectReference
	}
	return nil
}

func (x *Expression_FieldReference) GetMaskedReference() *Expression_MaskExpression {
	if x, ok := x.GetReferenceType().(*Expression_FieldReference_MaskedReference); ok {
		return x.MaskedReference
	}
	return nil
}

func (m *Expression_FieldReference) GetRootType() isExpression_FieldReference_RootType {
	if m != nil {
		return m.RootType
	}
	return nil
}

func (x *Expression_FieldReference) GetExpression() *Expression {
	if x, ok := x.GetRootType().(*Expression_FieldReference_Expression); ok {
		return x.Expression
	}
	return nil
}

func (x *Expression_FieldReference) GetRootReference() *Expression_FieldReference_RootReference {
	if x, ok := x.GetRootType().(*Expression_FieldReference_RootReference_); ok {
		return x.RootReference
	}
	return nil
}

func (x *Expression_FieldReference) GetOuterReference() *Expression_FieldReference_OuterReference {
	if x, ok := x.GetRootType().(*Expression_FieldReference_OuterReference_); ok {
		return x.OuterReference
	}
	return nil
}

type isExpression_FieldReference_ReferenceType interface {
	isExpression_FieldReference_ReferenceType()
}

type Expression_FieldReference_DirectReference struct {
	DirectReference *Expression_ReferenceSegment `protobuf:"bytes,1,opt,name=direct_reference,json=directReference,proto3,oneof"`
}

type Expression_FieldReference_MaskedReference struct {
	MaskedReference *Expression_MaskExpression `protobuf:"bytes,2,opt,name=masked_reference,json=maskedReference,proto3,oneof"`
}

func (*Expression_FieldReference_DirectReference) isExpression_FieldReference_ReferenceType() {}

func (*Expression_FieldReference_MaskedReference) isExpression_FieldReference_ReferenceType() {}

type isExpression_FieldReference_RootType interface {
	isExpression_FieldReference_RootType()
}

type Expression_FieldReference_Expression struct {
	Expression *Expression `protobuf:"bytes,3,opt,name=expression,proto3,oneof"`
}

type Expression_FieldReference_RootReference_ struct {
	RootReference *Expression_FieldReference_RootReference `protobuf:"bytes,4,opt,name=root_reference,json=rootReference,proto3,oneof"`
}

type Expression_FieldReference_OuterReference_ struct {
	OuterReference *Expression_FieldReference_OuterReference `protobuf:"bytes,5,opt,name=outer_reference,json=outerReference,proto3,oneof"`
}

func (*Expression_FieldReference_Expression) isExpression_FieldReference_RootType() {}

func (*Expression_FieldReference_RootReference_) isExpression_FieldReference_RootType() {}

func (*Expression_FieldReference_OuterReference_) isExpression_FieldReference_RootType() {}

// Subquery relation expression
type Expression_Subquery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SubqueryType:
	//	*Expression_Subquery_Scalar_
	//	*Expression_Subquery_InPredicate_
	//	*Expression_Subquery_SetPredicate_
	//	*Expression_Subquery_SetComparison_
	SubqueryType isExpression_Subquery_SubqueryType `protobuf_oneof:"subquery_type"`
}

func (x *Expression_Subquery) Reset() {
	*x = Expression_Subquery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Subquery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Subquery) ProtoMessage() {}

func (x *Expression_Subquery) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Subquery.ProtoReflect.Descriptor instead.
func (*Expression_Subquery) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 14}
}

func (m *Expression_Subquery) GetSubqueryType() isExpression_Subquery_SubqueryType {
	if m != nil {
		return m.SubqueryType
	}
	return nil
}

func (x *Expression_Subquery) GetScalar() *Expression_Subquery_Scalar {
	if x, ok := x.GetSubqueryType().(*Expression_Subquery_Scalar_); ok {
		return x.Scalar
	}
	return nil
}

func (x *Expression_Subquery) GetInPredicate() *Expression_Subquery_InPredicate {
	if x, ok := x.GetSubqueryType().(*Expression_Subquery_InPredicate_); ok {
		return x.InPredicate
	}
	return nil
}

func (x *Expression_Subquery) GetSetPredicate() *Expression_Subquery_SetPredicate {
	if x, ok := x.GetSubqueryType().(*Expression_Subquery_SetPredicate_); ok {
		return x.SetPredicate
	}
	return nil
}

func (x *Expression_Subquery) GetSetComparison() *Expression_Subquery_SetComparison {
	if x, ok := x.GetSubqueryType().(*Expression_Subquery_SetComparison_); ok {
		return x.SetComparison
	}
	return nil
}

type isExpression_Subquery_SubqueryType interface {
	isExpression_Subquery_SubqueryType()
}

type Expression_Subquery_Scalar_ struct {
	// Scalar subquery
	Scalar *Expression_Subquery_Scalar `protobuf:"bytes,1,opt,name=scalar,proto3,oneof"`
}

type Expression_Subquery_InPredicate_ struct {
	// x IN y predicate
	InPredicate *Expression_Subquery_InPredicate `protobuf:"bytes,2,opt,name=in_predicate,json=inPredicate,proto3,oneof"`
}

type Expression_Subquery_SetPredicate_ struct {
	// EXISTS/UNIQUE predicate
	SetPredicate *Expression_Subquery_SetPredicate `protobuf:"bytes,3,opt,name=set_predicate,json=setPredicate,proto3,oneof"`
}

type Expression_Subquery_SetComparison_ struct {
	// ANY/ALL predicate
	SetComparison *Expression_Subquery_SetComparison `protobuf:"bytes,4,opt,name=set_comparison,json=setComparison,proto3,oneof"`
}

func (*Expression_Subquery_Scalar_) isExpression_Subquery_SubqueryType() {}

func (*Expression_Subquery_InPredicate_) isExpression_Subquery_SubqueryType() {}

func (*Expression_Subquery_SetPredicate_) isExpression_Subquery_SubqueryType() {}

func (*Expression_Subquery_SetComparison_) isExpression_Subquery_SubqueryType() {}

// Deprecated: Do not use.
type Expression_Enum_Empty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Expression_Enum_Empty) Reset() {
	*x = Expression_Enum_Empty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Enum_Empty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Enum_Empty) ProtoMessage() {}

func (x *Expression_Enum_Empty) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Enum_Empty.ProtoReflect.Descriptor instead.
func (*Expression_Enum_Empty) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 0, 0}
}

type Expression_Literal_VarChar struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value  string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Length uint32 `protobuf:"varint,2,opt,name=length,proto3" json:"length,omitempty"`
}

func (x *Expression_Literal_VarChar) Reset() {
	*x = Expression_Literal_VarChar{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Literal_VarChar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Literal_VarChar) ProtoMessage() {}

func (x *Expression_Literal_VarChar) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Literal_VarChar.ProtoReflect.Descriptor instead.
func (*Expression_Literal_VarChar) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 1, 0}
}

func (x *Expression_Literal_VarChar) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *Expression_Literal_VarChar) GetLength() uint32 {
	if x != nil {
		return x.Length
	}
	return 0
}

type Expression_Literal_Decimal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// little-endian twos-complement integer representation of complete value
	// (ignoring precision) Always 16 bytes in length
	Value []byte `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The maximum number of digits allowed in the value.
	// the maximum precision is 38.
	Precision int32 `protobuf:"varint,2,opt,name=precision,proto3" json:"precision,omitempty"`
	// declared scale of decimal literal
	Scale int32 `protobuf:"varint,3,opt,name=scale,proto3" json:"scale,omitempty"`
}

func (x *Expression_Literal_Decimal) Reset() {
	*x = Expression_Literal_Decimal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Literal_Decimal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Literal_Decimal) ProtoMessage() {}

func (x *Expression_Literal_Decimal) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Literal_Decimal.ProtoReflect.Descriptor instead.
func (*Expression_Literal_Decimal) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 1, 1}
}

func (x *Expression_Literal_Decimal) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Expression_Literal_Decimal) GetPrecision() int32 {
	if x != nil {
		return x.Precision
	}
	return 0
}

func (x *Expression_Literal_Decimal) GetScale() int32 {
	if x != nil {
		return x.Scale
	}
	return 0
}

type Expression_Literal_Map struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyValues []*Expression_Literal_Map_KeyValue `protobuf:"bytes,1,rep,name=key_values,json=keyValues,proto3" json:"key_values,omitempty"`
}

func (x *Expression_Literal_Map) Reset() {
	*x = Expression_Literal_Map{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Literal_Map) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Literal_Map) ProtoMessage() {}

func (x *Expression_Literal_Map) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Literal_Map.ProtoReflect.Descriptor instead.
func (*Expression_Literal_Map) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 1, 2}
}

func (x *Expression_Literal_Map) GetKeyValues() []*Expression_Literal_Map_KeyValue {
	if x != nil {
		return x.KeyValues
	}
	return nil
}

type Expression_Literal_IntervalYearToMonth struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Years  int32 `protobuf:"varint,1,opt,name=years,proto3" json:"years,omitempty"`
	Months int32 `protobuf:"varint,2,opt,name=months,proto3" json:"months,omitempty"`
}

func (x *Expression_Literal_IntervalYearToMonth) Reset() {
	*x = Expression_Literal_IntervalYearToMonth{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Literal_IntervalYearToMonth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Literal_IntervalYearToMonth) ProtoMessage() {}

func (x *Expression_Literal_IntervalYearToMonth) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Literal_IntervalYearToMonth.ProtoReflect.Descriptor instead.
func (*Expression_Literal_IntervalYearToMonth) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 1, 3}
}

func (x *Expression_Literal_IntervalYearToMonth) GetYears() int32 {
	if x != nil {
		return x.Years
	}
	return 0
}

func (x *Expression_Literal_IntervalYearToMonth) GetMonths() int32 {
	if x != nil {
		return x.Months
	}
	return 0
}

type Expression_Literal_IntervalDayToSecond struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Days         int32 `protobuf:"varint,1,opt,name=days,proto3" json:"days,omitempty"`
	Seconds      int32 `protobuf:"varint,2,opt,name=seconds,proto3" json:"seconds,omitempty"`
	Microseconds int32 `protobuf:"varint,3,opt,name=microseconds,proto3" json:"microseconds,omitempty"`
}

func (x *Expression_Literal_IntervalDayToSecond) Reset() {
	*x = Expression_Literal_IntervalDayToSecond{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Literal_IntervalDayToSecond) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Literal_IntervalDayToSecond) ProtoMessage() {}

func (x *Expression_Literal_IntervalDayToSecond) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Literal_IntervalDayToSecond.ProtoReflect.Descriptor instead.
func (*Expression_Literal_IntervalDayToSecond) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 1, 4}
}

func (x *Expression_Literal_IntervalDayToSecond) GetDays() int32 {
	if x != nil {
		return x.Days
	}
	return 0
}

func (x *Expression_Literal_IntervalDayToSecond) GetSeconds() int32 {
	if x != nil {
		return x.Seconds
	}
	return 0
}

func (x *Expression_Literal_IntervalDayToSecond) GetMicroseconds() int32 {
	if x != nil {
		return x.Microseconds
	}
	return 0
}

type Expression_Literal_Struct struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A possibly heterogeneously typed list of literals
	Fields []*Expression_Literal `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *Expression_Literal_Struct) Reset() {
	*x = Expression_Literal_Struct{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Literal_Struct) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Literal_Struct) ProtoMessage() {}

func (x *Expression_Literal_Struct) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Literal_Struct.ProtoReflect.Descriptor instead.
func (*Expression_Literal_Struct) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 1, 5}
}

func (x *Expression_Literal_Struct) GetFields() []*Expression_Literal {
	if x != nil {
		return x.Fields
	}
	return nil
}

type Expression_Literal_List struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A homogeneously typed list of literals
	Values []*Expression_Literal `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *Expression_Literal_List) Reset() {
	*x = Expression_Literal_List{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Literal_List) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Literal_List) ProtoMessage() {}

func (x *Expression_Literal_List) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Literal_List.ProtoReflect.Descriptor instead.
func (*Expression_Literal_List) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 1, 6}
}

func (x *Expression_Literal_List) GetValues() []*Expression_Literal {
	if x != nil {
		return x.Values
	}
	return nil
}

type Expression_Literal_UserDefined struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// points to a type_anchor defined in this plan
	TypeReference uint32 `protobuf:"varint,1,opt,name=type_reference,json=typeReference,proto3" json:"type_reference,omitempty"`
	// The parameters to be bound to the type class, if the type class is
	// parameterizable.
	TypeParameters []*Type_Parameter `protobuf:"bytes,3,rep,name=type_parameters,json=typeParameters,proto3" json:"type_parameters,omitempty"`
	// the value of the literal, serialized using some type-specific
	// protobuf message
	Value *anypb.Any `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Expression_Literal_UserDefined) Reset() {
	*x = Expression_Literal_UserDefined{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Literal_UserDefined) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Literal_UserDefined) ProtoMessage() {}

func (x *Expression_Literal_UserDefined) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Literal_UserDefined.ProtoReflect.Descriptor instead.
func (*Expression_Literal_UserDefined) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 1, 7}
}

func (x *Expression_Literal_UserDefined) GetTypeReference() uint32 {
	if x != nil {
		return x.TypeReference
	}
	return 0
}

func (x *Expression_Literal_UserDefined) GetTypeParameters() []*Type_Parameter {
	if x != nil {
		return x.TypeParameters
	}
	return nil
}

func (x *Expression_Literal_UserDefined) GetValue() *anypb.Any {
	if x != nil {
		return x.Value
	}
	return nil
}

type Expression_Literal_Map_KeyValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *Expression_Literal `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value *Expression_Literal `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Expression_Literal_Map_KeyValue) Reset() {
	*x = Expression_Literal_Map_KeyValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Literal_Map_KeyValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Literal_Map_KeyValue) ProtoMessage() {}

func (x *Expression_Literal_Map_KeyValue) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Literal_Map_KeyValue.ProtoReflect.Descriptor instead.
func (*Expression_Literal_Map_KeyValue) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 1, 2, 0}
}

func (x *Expression_Literal_Map_KeyValue) GetKey() *Expression_Literal {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *Expression_Literal_Map_KeyValue) GetValue() *Expression_Literal {
	if x != nil {
		return x.Value
	}
	return nil
}

type Expression_Nested_Map struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One or more key-value pairs. To specify an empty map, use
	// Literal.empty_map (otherwise type information would be missing).
	KeyValues []*Expression_Nested_Map_KeyValue `protobuf:"bytes,1,rep,name=key_values,json=keyValues,proto3" json:"key_values,omitempty"`
}

func (x *Expression_Nested_Map) Reset() {
	*x = Expression_Nested_Map{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Nested_Map) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Nested_Map) ProtoMessage() {}

func (x *Expression_Nested_Map) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Nested_Map.ProtoReflect.Descriptor instead.
func (*Expression_Nested_Map) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 2, 0}
}

func (x *Expression_Nested_Map) GetKeyValues() []*Expression_Nested_Map_KeyValue {
	if x != nil {
		return x.KeyValues
	}
	return nil
}

type Expression_Nested_Struct struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Zero or more possibly heterogeneously-typed list of expressions that
	// form the struct fields.
	Fields []*Expression `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *Expression_Nested_Struct) Reset() {
	*x = Expression_Nested_Struct{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Nested_Struct) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Nested_Struct) ProtoMessage() {}

func (x *Expression_Nested_Struct) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Nested_Struct.ProtoReflect.Descriptor instead.
func (*Expression_Nested_Struct) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 2, 1}
}

func (x *Expression_Nested_Struct) GetFields() []*Expression {
	if x != nil {
		return x.Fields
	}
	return nil
}

type Expression_Nested_List struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A homogeneously-typed list of one or more expressions that form the
	// list entries. To specify an empty list, use Literal.empty_list
	// (otherwise type information would be missing).
	Values []*Expression `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *Expression_Nested_List) Reset() {
	*x = Expression_Nested_List{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Nested_List) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Nested_List) ProtoMessage() {}

func (x *Expression_Nested_List) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Nested_List.ProtoReflect.Descriptor instead.
func (*Expression_Nested_List) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 2, 2}
}

func (x *Expression_Nested_List) GetValues() []*Expression {
	if x != nil {
		return x.Values
	}
	return nil
}

type Expression_Nested_Map_KeyValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mandatory key/value expressions.
	Key   *Expression `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value *Expression `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Expression_Nested_Map_KeyValue) Reset() {
	*x = Expression_Nested_Map_KeyValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Nested_Map_KeyValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Nested_Map_KeyValue) ProtoMessage() {}

func (x *Expression_Nested_Map_KeyValue) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Nested_Map_KeyValue.ProtoReflect.Descriptor instead.
func (*Expression_Nested_Map_KeyValue) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 2, 0, 0}
}

func (x *Expression_Nested_Map_KeyValue) GetKey() *Expression {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *Expression_Nested_Map_KeyValue) GetValue() *Expression {
	if x != nil {
		return x.Value
	}
	return nil
}

// Defines one of the two boundaries for the window of a window function.
type Expression_WindowFunction_Bound struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Kind:
	//	*Expression_WindowFunction_Bound_Preceding_
	//	*Expression_WindowFunction_Bound_Following_
	//	*Expression_WindowFunction_Bound_CurrentRow_
	//	*Expression_WindowFunction_Bound_Unbounded_
	Kind isExpression_WindowFunction_Bound_Kind `protobuf_oneof:"kind"`
}

func (x *Expression_WindowFunction_Bound) Reset() {
	*x = Expression_WindowFunction_Bound{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_WindowFunction_Bound) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_WindowFunction_Bound) ProtoMessage() {}

func (x *Expression_WindowFunction_Bound) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_WindowFunction_Bound.ProtoReflect.Descriptor instead.
func (*Expression_WindowFunction_Bound) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 4, 0}
}

func (m *Expression_WindowFunction_Bound) GetKind() isExpression_WindowFunction_Bound_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *Expression_WindowFunction_Bound) GetPreceding() *Expression_WindowFunction_Bound_Preceding {
	if x, ok := x.GetKind().(*Expression_WindowFunction_Bound_Preceding_); ok {
		return x.Preceding
	}
	return nil
}

func (x *Expression_WindowFunction_Bound) GetFollowing() *Expression_WindowFunction_Bound_Following {
	if x, ok := x.GetKind().(*Expression_WindowFunction_Bound_Following_); ok {
		return x.Following
	}
	return nil
}

func (x *Expression_WindowFunction_Bound) GetCurrentRow() *Expression_WindowFunction_Bound_CurrentRow {
	if x, ok := x.GetKind().(*Expression_WindowFunction_Bound_CurrentRow_); ok {
		return x.CurrentRow
	}
	return nil
}

func (x *Expression_WindowFunction_Bound) GetUnbounded() *Expression_WindowFunction_Bound_Unbounded {
	if x, ok := x.GetKind().(*Expression_WindowFunction_Bound_Unbounded_); ok {
		return x.Unbounded
	}
	return nil
}

type isExpression_WindowFunction_Bound_Kind interface {
	isExpression_WindowFunction_Bound_Kind()
}

type Expression_WindowFunction_Bound_Preceding_ struct {
	// The bound extends some number of records behind the current record.
	Preceding *Expression_WindowFunction_Bound_Preceding `protobuf:"bytes,1,opt,name=preceding,proto3,oneof"`
}

type Expression_WindowFunction_Bound_Following_ struct {
	// The bound extends some number of records ahead of the current
	// record.
	Following *Expression_WindowFunction_Bound_Following `protobuf:"bytes,2,opt,name=following,proto3,oneof"`
}

type Expression_WindowFunction_Bound_CurrentRow_ struct {
	// The bound extends to the current record.
	CurrentRow *Expression_WindowFunction_Bound_CurrentRow `protobuf:"bytes,3,opt,name=current_row,json=currentRow,proto3,oneof"`
}

type Expression_WindowFunction_Bound_Unbounded_ struct {
	// The bound extends to the start of the partition or the end of the
	// partition, depending on whether this represents the upper or lower
	// bound.
	Unbounded *Expression_WindowFunction_Bound_Unbounded `protobuf:"bytes,4,opt,name=unbounded,proto3,oneof"`
}

func (*Expression_WindowFunction_Bound_Preceding_) isExpression_WindowFunction_Bound_Kind() {}

func (*Expression_WindowFunction_Bound_Following_) isExpression_WindowFunction_Bound_Kind() {}

func (*Expression_WindowFunction_Bound_CurrentRow_) isExpression_WindowFunction_Bound_Kind() {}

func (*Expression_WindowFunction_Bound_Unbounded_) isExpression_WindowFunction_Bound_Kind() {}

// Defines that the bound extends this far back from the current record.
type Expression_WindowFunction_Bound_Preceding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A strictly positive integer specifying the number of records that
	// the window extends back from the current record. Required. Use
	// CurrentRow for offset zero and Following for negative offsets.
	Offset int64 `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *Expression_WindowFunction_Bound_Preceding) Reset() {
	*x = Expression_WindowFunction_Bound_Preceding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_WindowFunction_Bound_Preceding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_WindowFunction_Bound_Preceding) ProtoMessage() {}

func (x *Expression_WindowFunction_Bound_Preceding) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_WindowFunction_Bound_Preceding.ProtoReflect.Descriptor instead.
func (*Expression_WindowFunction_Bound_Preceding) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 4, 0, 0}
}

func (x *Expression_WindowFunction_Bound_Preceding) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// Defines that the bound extends this far ahead of the current record.
type Expression_WindowFunction_Bound_Following struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A strictly positive integer specifying the number of records that
	// the window extends ahead of the current record. Required. Use
	// CurrentRow for offset zero and Preceding for negative offsets.
	Offset int64 `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *Expression_WindowFunction_Bound_Following) Reset() {
	*x = Expression_WindowFunction_Bound_Following{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_WindowFunction_Bound_Following) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_WindowFunction_Bound_Following) ProtoMessage() {}

func (x *Expression_WindowFunction_Bound_Following) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_WindowFunction_Bound_Following.ProtoReflect.Descriptor instead.
func (*Expression_WindowFunction_Bound_Following) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 4, 0, 1}
}

func (x *Expression_WindowFunction_Bound_Following) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// Defines that the bound extends to or from the current record.
type Expression_WindowFunction_Bound_CurrentRow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Expression_WindowFunction_Bound_CurrentRow) Reset() {
	*x = Expression_WindowFunction_Bound_CurrentRow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_WindowFunction_Bound_CurrentRow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_WindowFunction_Bound_CurrentRow) ProtoMessage() {}

func (x *Expression_WindowFunction_Bound_CurrentRow) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_WindowFunction_Bound_CurrentRow.ProtoReflect.Descriptor instead.
func (*Expression_WindowFunction_Bound_CurrentRow) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 4, 0, 2}
}

// Defines an "unbounded bound": for lower bounds this means the start
// of the partition, and for upper bounds this means the end of the
// partition.
type Expression_WindowFunction_Bound_Unbounded struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Expression_WindowFunction_Bound_Unbounded) Reset() {
	*x = Expression_WindowFunction_Bound_Unbounded{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_WindowFunction_Bound_Unbounded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_WindowFunction_Bound_Unbounded) ProtoMessage() {}

func (x *Expression_WindowFunction_Bound_Unbounded) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_WindowFunction_Bound_Unbounded.ProtoReflect.Descriptor instead.
func (*Expression_WindowFunction_Bound_Unbounded) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 4, 0, 3}
}

type Expression_IfThen_IfClause struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	If   *Expression `protobuf:"bytes,1,opt,name=if,proto3" json:"if,omitempty"`
	Then *Expression `protobuf:"bytes,2,opt,name=then,proto3" json:"then,omitempty"`
}

func (x *Expression_IfThen_IfClause) Reset() {
	*x = Expression_IfThen_IfClause{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_IfThen_IfClause) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_IfThen_IfClause) ProtoMessage() {}

func (x *Expression_IfThen_IfClause) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_IfThen_IfClause.ProtoReflect.Descriptor instead.
func (*Expression_IfThen_IfClause) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 5, 0}
}

func (x *Expression_IfThen_IfClause) GetIf() *Expression {
	if x != nil {
		return x.If
	}
	return nil
}

func (x *Expression_IfThen_IfClause) GetThen() *Expression {
	if x != nil {
		return x.Then
	}
	return nil
}

type Expression_SwitchExpression_IfValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	If   *Expression_Literal `protobuf:"bytes,1,opt,name=if,proto3" json:"if,omitempty"`
	Then *Expression         `protobuf:"bytes,2,opt,name=then,proto3" json:"then,omitempty"`
}

func (x *Expression_SwitchExpression_IfValue) Reset() {
	*x = Expression_SwitchExpression_IfValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_SwitchExpression_IfValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_SwitchExpression_IfValue) ProtoMessage() {}

func (x *Expression_SwitchExpression_IfValue) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_SwitchExpression_IfValue.ProtoReflect.Descriptor instead.
func (*Expression_SwitchExpression_IfValue) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 7, 0}
}

func (x *Expression_SwitchExpression_IfValue) GetIf() *Expression_Literal {
	if x != nil {
		return x.If
	}
	return nil
}

func (x *Expression_SwitchExpression_IfValue) GetThen() *Expression {
	if x != nil {
		return x.Then
	}
	return nil
}

type Expression_MultiOrList_Record struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fields []*Expression `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *Expression_MultiOrList_Record) Reset() {
	*x = Expression_MultiOrList_Record{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MultiOrList_Record) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MultiOrList_Record) ProtoMessage() {}

func (x *Expression_MultiOrList_Record) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MultiOrList_Record.ProtoReflect.Descriptor instead.
func (*Expression_MultiOrList_Record) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 9, 0}
}

func (x *Expression_MultiOrList_Record) GetFields() []*Expression {
	if x != nil {
		return x.Fields
	}
	return nil
}

type Expression_EmbeddedFunction_PythonPickleFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Function     []byte   `protobuf:"bytes,1,opt,name=function,proto3" json:"function,omitempty"`
	Prerequisite []string `protobuf:"bytes,2,rep,name=prerequisite,proto3" json:"prerequisite,omitempty"`
}

func (x *Expression_EmbeddedFunction_PythonPickleFunction) Reset() {
	*x = Expression_EmbeddedFunction_PythonPickleFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_EmbeddedFunction_PythonPickleFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_EmbeddedFunction_PythonPickleFunction) ProtoMessage() {}

func (x *Expression_EmbeddedFunction_PythonPickleFunction) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_EmbeddedFunction_PythonPickleFunction.ProtoReflect.Descriptor instead.
func (*Expression_EmbeddedFunction_PythonPickleFunction) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 10, 0}
}

func (x *Expression_EmbeddedFunction_PythonPickleFunction) GetFunction() []byte {
	if x != nil {
		return x.Function
	}
	return nil
}

func (x *Expression_EmbeddedFunction_PythonPickleFunction) GetPrerequisite() []string {
	if x != nil {
		return x.Prerequisite
	}
	return nil
}

type Expression_EmbeddedFunction_WebAssemblyFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Script       []byte   `protobuf:"bytes,1,opt,name=script,proto3" json:"script,omitempty"`
	Prerequisite []string `protobuf:"bytes,2,rep,name=prerequisite,proto3" json:"prerequisite,omitempty"`
}

func (x *Expression_EmbeddedFunction_WebAssemblyFunction) Reset() {
	*x = Expression_EmbeddedFunction_WebAssemblyFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_EmbeddedFunction_WebAssemblyFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_EmbeddedFunction_WebAssemblyFunction) ProtoMessage() {}

func (x *Expression_EmbeddedFunction_WebAssemblyFunction) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_EmbeddedFunction_WebAssemblyFunction.ProtoReflect.Descriptor instead.
func (*Expression_EmbeddedFunction_WebAssemblyFunction) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 10, 1}
}

func (x *Expression_EmbeddedFunction_WebAssemblyFunction) GetScript() []byte {
	if x != nil {
		return x.Script
	}
	return nil
}

func (x *Expression_EmbeddedFunction_WebAssemblyFunction) GetPrerequisite() []string {
	if x != nil {
		return x.Prerequisite
	}
	return nil
}

type Expression_ReferenceSegment_MapKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// literal based reference to specific possible value in map.
	MapKey *Expression_Literal `protobuf:"bytes,1,opt,name=map_key,json=mapKey,proto3" json:"map_key,omitempty"`
	// Optional child segment
	Child *Expression_ReferenceSegment `protobuf:"bytes,2,opt,name=child,proto3" json:"child,omitempty"`
}

func (x *Expression_ReferenceSegment_MapKey) Reset() {
	*x = Expression_ReferenceSegment_MapKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_ReferenceSegment_MapKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_ReferenceSegment_MapKey) ProtoMessage() {}

func (x *Expression_ReferenceSegment_MapKey) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_ReferenceSegment_MapKey.ProtoReflect.Descriptor instead.
func (*Expression_ReferenceSegment_MapKey) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 11, 0}
}

func (x *Expression_ReferenceSegment_MapKey) GetMapKey() *Expression_Literal {
	if x != nil {
		return x.MapKey
	}
	return nil
}

func (x *Expression_ReferenceSegment_MapKey) GetChild() *Expression_ReferenceSegment {
	if x != nil {
		return x.Child
	}
	return nil
}

type Expression_ReferenceSegment_StructField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// zero-indexed ordinal position of field in struct
	Field int32 `protobuf:"varint,1,opt,name=field,proto3" json:"field,omitempty"`
	// Optional child segment
	Child *Expression_ReferenceSegment `protobuf:"bytes,2,opt,name=child,proto3" json:"child,omitempty"`
}

func (x *Expression_ReferenceSegment_StructField) Reset() {
	*x = Expression_ReferenceSegment_StructField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_ReferenceSegment_StructField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_ReferenceSegment_StructField) ProtoMessage() {}

func (x *Expression_ReferenceSegment_StructField) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_ReferenceSegment_StructField.ProtoReflect.Descriptor instead.
func (*Expression_ReferenceSegment_StructField) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 11, 1}
}

func (x *Expression_ReferenceSegment_StructField) GetField() int32 {
	if x != nil {
		return x.Field
	}
	return 0
}

func (x *Expression_ReferenceSegment_StructField) GetChild() *Expression_ReferenceSegment {
	if x != nil {
		return x.Child
	}
	return nil
}

type Expression_ReferenceSegment_ListElement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// zero-indexed ordinal position of element in list
	Offset int32 `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
	// Optional child segment
	Child *Expression_ReferenceSegment `protobuf:"bytes,2,opt,name=child,proto3" json:"child,omitempty"`
}

func (x *Expression_ReferenceSegment_ListElement) Reset() {
	*x = Expression_ReferenceSegment_ListElement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_ReferenceSegment_ListElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_ReferenceSegment_ListElement) ProtoMessage() {}

func (x *Expression_ReferenceSegment_ListElement) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_ReferenceSegment_ListElement.ProtoReflect.Descriptor instead.
func (*Expression_ReferenceSegment_ListElement) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 11, 2}
}

func (x *Expression_ReferenceSegment_ListElement) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *Expression_ReferenceSegment_ListElement) GetChild() *Expression_ReferenceSegment {
	if x != nil {
		return x.Child
	}
	return nil
}

type Expression_MaskExpression_Select struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//	*Expression_MaskExpression_Select_Struct
	//	*Expression_MaskExpression_Select_List
	//	*Expression_MaskExpression_Select_Map
	Type isExpression_MaskExpression_Select_Type `protobuf_oneof:"type"`
}

func (x *Expression_MaskExpression_Select) Reset() {
	*x = Expression_MaskExpression_Select{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MaskExpression_Select) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MaskExpression_Select) ProtoMessage() {}

func (x *Expression_MaskExpression_Select) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MaskExpression_Select.ProtoReflect.Descriptor instead.
func (*Expression_MaskExpression_Select) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 12, 0}
}

func (m *Expression_MaskExpression_Select) GetType() isExpression_MaskExpression_Select_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Expression_MaskExpression_Select) GetStruct() *Expression_MaskExpression_StructSelect {
	if x, ok := x.GetType().(*Expression_MaskExpression_Select_Struct); ok {
		return x.Struct
	}
	return nil
}

func (x *Expression_MaskExpression_Select) GetList() *Expression_MaskExpression_ListSelect {
	if x, ok := x.GetType().(*Expression_MaskExpression_Select_List); ok {
		return x.List
	}
	return nil
}

func (x *Expression_MaskExpression_Select) GetMap() *Expression_MaskExpression_MapSelect {
	if x, ok := x.GetType().(*Expression_MaskExpression_Select_Map); ok {
		return x.Map
	}
	return nil
}

type isExpression_MaskExpression_Select_Type interface {
	isExpression_MaskExpression_Select_Type()
}

type Expression_MaskExpression_Select_Struct struct {
	Struct *Expression_MaskExpression_StructSelect `protobuf:"bytes,1,opt,name=struct,proto3,oneof"`
}

type Expression_MaskExpression_Select_List struct {
	List *Expression_MaskExpression_ListSelect `protobuf:"bytes,2,opt,name=list,proto3,oneof"`
}

type Expression_MaskExpression_Select_Map struct {
	Map *Expression_MaskExpression_MapSelect `protobuf:"bytes,3,opt,name=map,proto3,oneof"`
}

func (*Expression_MaskExpression_Select_Struct) isExpression_MaskExpression_Select_Type() {}

func (*Expression_MaskExpression_Select_List) isExpression_MaskExpression_Select_Type() {}

func (*Expression_MaskExpression_Select_Map) isExpression_MaskExpression_Select_Type() {}

type Expression_MaskExpression_StructSelect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StructItems []*Expression_MaskExpression_StructItem `protobuf:"bytes,1,rep,name=struct_items,json=structItems,proto3" json:"struct_items,omitempty"`
}

func (x *Expression_MaskExpression_StructSelect) Reset() {
	*x = Expression_MaskExpression_StructSelect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MaskExpression_StructSelect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MaskExpression_StructSelect) ProtoMessage() {}

func (x *Expression_MaskExpression_StructSelect) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MaskExpression_StructSelect.ProtoReflect.Descriptor instead.
func (*Expression_MaskExpression_StructSelect) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 12, 1}
}

func (x *Expression_MaskExpression_StructSelect) GetStructItems() []*Expression_MaskExpression_StructItem {
	if x != nil {
		return x.StructItems
	}
	return nil
}

type Expression_MaskExpression_StructItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Field int32                             `protobuf:"varint,1,opt,name=field,proto3" json:"field,omitempty"`
	Child *Expression_MaskExpression_Select `protobuf:"bytes,2,opt,name=child,proto3" json:"child,omitempty"`
}

func (x *Expression_MaskExpression_StructItem) Reset() {
	*x = Expression_MaskExpression_StructItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MaskExpression_StructItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MaskExpression_StructItem) ProtoMessage() {}

func (x *Expression_MaskExpression_StructItem) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MaskExpression_StructItem.ProtoReflect.Descriptor instead.
func (*Expression_MaskExpression_StructItem) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 12, 2}
}

func (x *Expression_MaskExpression_StructItem) GetField() int32 {
	if x != nil {
		return x.Field
	}
	return 0
}

func (x *Expression_MaskExpression_StructItem) GetChild() *Expression_MaskExpression_Select {
	if x != nil {
		return x.Child
	}
	return nil
}

type Expression_MaskExpression_ListSelect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Selection []*Expression_MaskExpression_ListSelect_ListSelectItem `protobuf:"bytes,1,rep,name=selection,proto3" json:"selection,omitempty"`
	Child     *Expression_MaskExpression_Select                      `protobuf:"bytes,2,opt,name=child,proto3" json:"child,omitempty"`
}

func (x *Expression_MaskExpression_ListSelect) Reset() {
	*x = Expression_MaskExpression_ListSelect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MaskExpression_ListSelect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MaskExpression_ListSelect) ProtoMessage() {}

func (x *Expression_MaskExpression_ListSelect) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MaskExpression_ListSelect.ProtoReflect.Descriptor instead.
func (*Expression_MaskExpression_ListSelect) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 12, 3}
}

func (x *Expression_MaskExpression_ListSelect) GetSelection() []*Expression_MaskExpression_ListSelect_ListSelectItem {
	if x != nil {
		return x.Selection
	}
	return nil
}

func (x *Expression_MaskExpression_ListSelect) GetChild() *Expression_MaskExpression_Select {
	if x != nil {
		return x.Child
	}
	return nil
}

type Expression_MaskExpression_MapSelect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Select:
	//	*Expression_MaskExpression_MapSelect_Key
	//	*Expression_MaskExpression_MapSelect_Expression
	Select isExpression_MaskExpression_MapSelect_Select `protobuf_oneof:"select"`
	Child  *Expression_MaskExpression_Select            `protobuf:"bytes,3,opt,name=child,proto3" json:"child,omitempty"`
}

func (x *Expression_MaskExpression_MapSelect) Reset() {
	*x = Expression_MaskExpression_MapSelect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MaskExpression_MapSelect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MaskExpression_MapSelect) ProtoMessage() {}

func (x *Expression_MaskExpression_MapSelect) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MaskExpression_MapSelect.ProtoReflect.Descriptor instead.
func (*Expression_MaskExpression_MapSelect) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 12, 4}
}

func (m *Expression_MaskExpression_MapSelect) GetSelect() isExpression_MaskExpression_MapSelect_Select {
	if m != nil {
		return m.Select
	}
	return nil
}

func (x *Expression_MaskExpression_MapSelect) GetKey() *Expression_MaskExpression_MapSelect_MapKey {
	if x, ok := x.GetSelect().(*Expression_MaskExpression_MapSelect_Key); ok {
		return x.Key
	}
	return nil
}

func (x *Expression_MaskExpression_MapSelect) GetExpression() *Expression_MaskExpression_MapSelect_MapKeyExpression {
	if x, ok := x.GetSelect().(*Expression_MaskExpression_MapSelect_Expression); ok {
		return x.Expression
	}
	return nil
}

func (x *Expression_MaskExpression_MapSelect) GetChild() *Expression_MaskExpression_Select {
	if x != nil {
		return x.Child
	}
	return nil
}

type isExpression_MaskExpression_MapSelect_Select interface {
	isExpression_MaskExpression_MapSelect_Select()
}

type Expression_MaskExpression_MapSelect_Key struct {
	Key *Expression_MaskExpression_MapSelect_MapKey `protobuf:"bytes,1,opt,name=key,proto3,oneof"`
}

type Expression_MaskExpression_MapSelect_Expression struct {
	Expression *Expression_MaskExpression_MapSelect_MapKeyExpression `protobuf:"bytes,2,opt,name=expression,proto3,oneof"`
}

func (*Expression_MaskExpression_MapSelect_Key) isExpression_MaskExpression_MapSelect_Select() {}

func (*Expression_MaskExpression_MapSelect_Expression) isExpression_MaskExpression_MapSelect_Select() {
}

type Expression_MaskExpression_ListSelect_ListSelectItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//	*Expression_MaskExpression_ListSelect_ListSelectItem_Item
	//	*Expression_MaskExpression_ListSelect_ListSelectItem_Slice
	Type isExpression_MaskExpression_ListSelect_ListSelectItem_Type `protobuf_oneof:"type"`
}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem) Reset() {
	*x = Expression_MaskExpression_ListSelect_ListSelectItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MaskExpression_ListSelect_ListSelectItem) ProtoMessage() {}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MaskExpression_ListSelect_ListSelectItem.ProtoReflect.Descriptor instead.
func (*Expression_MaskExpression_ListSelect_ListSelectItem) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 12, 3, 0}
}

func (m *Expression_MaskExpression_ListSelect_ListSelectItem) GetType() isExpression_MaskExpression_ListSelect_ListSelectItem_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem) GetItem() *Expression_MaskExpression_ListSelect_ListSelectItem_ListElement {
	if x, ok := x.GetType().(*Expression_MaskExpression_ListSelect_ListSelectItem_Item); ok {
		return x.Item
	}
	return nil
}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem) GetSlice() *Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice {
	if x, ok := x.GetType().(*Expression_MaskExpression_ListSelect_ListSelectItem_Slice); ok {
		return x.Slice
	}
	return nil
}

type isExpression_MaskExpression_ListSelect_ListSelectItem_Type interface {
	isExpression_MaskExpression_ListSelect_ListSelectItem_Type()
}

type Expression_MaskExpression_ListSelect_ListSelectItem_Item struct {
	Item *Expression_MaskExpression_ListSelect_ListSelectItem_ListElement `protobuf:"bytes,1,opt,name=item,proto3,oneof"`
}

type Expression_MaskExpression_ListSelect_ListSelectItem_Slice struct {
	Slice *Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice `protobuf:"bytes,2,opt,name=slice,proto3,oneof"`
}

func (*Expression_MaskExpression_ListSelect_ListSelectItem_Item) isExpression_MaskExpression_ListSelect_ListSelectItem_Type() {
}

func (*Expression_MaskExpression_ListSelect_ListSelectItem_Slice) isExpression_MaskExpression_ListSelect_ListSelectItem_Type() {
}

type Expression_MaskExpression_ListSelect_ListSelectItem_ListElement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Field int32 `protobuf:"varint,1,opt,name=field,proto3" json:"field,omitempty"`
}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem_ListElement) Reset() {
	*x = Expression_MaskExpression_ListSelect_ListSelectItem_ListElement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem_ListElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MaskExpression_ListSelect_ListSelectItem_ListElement) ProtoMessage() {}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem_ListElement) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MaskExpression_ListSelect_ListSelectItem_ListElement.ProtoReflect.Descriptor instead.
func (*Expression_MaskExpression_ListSelect_ListSelectItem_ListElement) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 12, 3, 0, 0}
}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem_ListElement) GetField() int32 {
	if x != nil {
		return x.Field
	}
	return 0
}

type Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Start int32 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	End   int32 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice) Reset() {
	*x = Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice) ProtoMessage() {}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice.ProtoReflect.Descriptor instead.
func (*Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 12, 3, 0, 1}
}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice) GetStart() int32 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice) GetEnd() int32 {
	if x != nil {
		return x.End
	}
	return 0
}

type Expression_MaskExpression_MapSelect_MapKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapKey string `protobuf:"bytes,1,opt,name=map_key,json=mapKey,proto3" json:"map_key,omitempty"`
}

func (x *Expression_MaskExpression_MapSelect_MapKey) Reset() {
	*x = Expression_MaskExpression_MapSelect_MapKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MaskExpression_MapSelect_MapKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MaskExpression_MapSelect_MapKey) ProtoMessage() {}

func (x *Expression_MaskExpression_MapSelect_MapKey) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MaskExpression_MapSelect_MapKey.ProtoReflect.Descriptor instead.
func (*Expression_MaskExpression_MapSelect_MapKey) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 12, 4, 0}
}

func (x *Expression_MaskExpression_MapSelect_MapKey) GetMapKey() string {
	if x != nil {
		return x.MapKey
	}
	return ""
}

type Expression_MaskExpression_MapSelect_MapKeyExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapKeyExpression string `protobuf:"bytes,1,opt,name=map_key_expression,json=mapKeyExpression,proto3" json:"map_key_expression,omitempty"`
}

func (x *Expression_MaskExpression_MapSelect_MapKeyExpression) Reset() {
	*x = Expression_MaskExpression_MapSelect_MapKeyExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_MaskExpression_MapSelect_MapKeyExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_MaskExpression_MapSelect_MapKeyExpression) ProtoMessage() {}

func (x *Expression_MaskExpression_MapSelect_MapKeyExpression) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_MaskExpression_MapSelect_MapKeyExpression.ProtoReflect.Descriptor instead.
func (*Expression_MaskExpression_MapSelect_MapKeyExpression) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 12, 4, 1}
}

func (x *Expression_MaskExpression_MapSelect_MapKeyExpression) GetMapKeyExpression() string {
	if x != nil {
		return x.MapKeyExpression
	}
	return ""
}

// Singleton that expresses this FieldReference is rooted off the root
// incoming record type
type Expression_FieldReference_RootReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Expression_FieldReference_RootReference) Reset() {
	*x = Expression_FieldReference_RootReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_FieldReference_RootReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_FieldReference_RootReference) ProtoMessage() {}

func (x *Expression_FieldReference_RootReference) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_FieldReference_RootReference.ProtoReflect.Descriptor instead.
func (*Expression_FieldReference_RootReference) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 13, 0}
}

// A root reference for the outer relation's subquery
type Expression_FieldReference_OuterReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// number of subquery boundaries to traverse up for this field's reference
	//
	// This value must be >= 1
	StepsOut uint32 `protobuf:"varint,1,opt,name=steps_out,json=stepsOut,proto3" json:"steps_out,omitempty"`
}

func (x *Expression_FieldReference_OuterReference) Reset() {
	*x = Expression_FieldReference_OuterReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_FieldReference_OuterReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_FieldReference_OuterReference) ProtoMessage() {}

func (x *Expression_FieldReference_OuterReference) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_FieldReference_OuterReference.ProtoReflect.Descriptor instead.
func (*Expression_FieldReference_OuterReference) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 13, 1}
}

func (x *Expression_FieldReference_OuterReference) GetStepsOut() uint32 {
	if x != nil {
		return x.StepsOut
	}
	return 0
}

// A subquery with one row and one column. This is often an aggregate
// though not required to be.
type Expression_Subquery_Scalar struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Input *Rel `protobuf:"bytes,1,opt,name=input,proto3" json:"input,omitempty"`
}

func (x *Expression_Subquery_Scalar) Reset() {
	*x = Expression_Subquery_Scalar{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Subquery_Scalar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Subquery_Scalar) ProtoMessage() {}

func (x *Expression_Subquery_Scalar) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Subquery_Scalar.ProtoReflect.Descriptor instead.
func (*Expression_Subquery_Scalar) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 14, 0}
}

func (x *Expression_Subquery_Scalar) GetInput() *Rel {
	if x != nil {
		return x.Input
	}
	return nil
}

// Predicate checking that the left expression is contained in the right
// subquery
//
// Examples:
//
// x IN (SELECT * FROM t)
// (x, y) IN (SELECT a, b FROM t)
type Expression_Subquery_InPredicate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Needles  []*Expression `protobuf:"bytes,1,rep,name=needles,proto3" json:"needles,omitempty"`
	Haystack *Rel          `protobuf:"bytes,2,opt,name=haystack,proto3" json:"haystack,omitempty"`
}

func (x *Expression_Subquery_InPredicate) Reset() {
	*x = Expression_Subquery_InPredicate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Subquery_InPredicate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Subquery_InPredicate) ProtoMessage() {}

func (x *Expression_Subquery_InPredicate) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Subquery_InPredicate.ProtoReflect.Descriptor instead.
func (*Expression_Subquery_InPredicate) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 14, 1}
}

func (x *Expression_Subquery_InPredicate) GetNeedles() []*Expression {
	if x != nil {
		return x.Needles
	}
	return nil
}

func (x *Expression_Subquery_InPredicate) GetHaystack() *Rel {
	if x != nil {
		return x.Haystack
	}
	return nil
}

// A predicate over a set of rows in the form of a subquery
// EXISTS and UNIQUE are common SQL forms of this operation.
type Expression_Subquery_SetPredicate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// TODO: should allow expressions
	PredicateOp Expression_Subquery_SetPredicate_PredicateOp `protobuf:"varint,1,opt,name=predicate_op,json=predicateOp,proto3,enum=substrait.Expression_Subquery_SetPredicate_PredicateOp" json:"predicate_op,omitempty"`
	Tuples      *Rel                                         `protobuf:"bytes,2,opt,name=tuples,proto3" json:"tuples,omitempty"`
}

func (x *Expression_Subquery_SetPredicate) Reset() {
	*x = Expression_Subquery_SetPredicate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Subquery_SetPredicate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Subquery_SetPredicate) ProtoMessage() {}

func (x *Expression_Subquery_SetPredicate) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Subquery_SetPredicate.ProtoReflect.Descriptor instead.
func (*Expression_Subquery_SetPredicate) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 14, 2}
}

func (x *Expression_Subquery_SetPredicate) GetPredicateOp() Expression_Subquery_SetPredicate_PredicateOp {
	if x != nil {
		return x.PredicateOp
	}
	return Expression_Subquery_SetPredicate_PREDICATE_OP_UNSPECIFIED
}

func (x *Expression_Subquery_SetPredicate) GetTuples() *Rel {
	if x != nil {
		return x.Tuples
	}
	return nil
}

// A subquery comparison using ANY or ALL.
// Examples:
//
// SELECT *
// FROM t1
// WHERE x < ANY(SELECT y from t2)
type Expression_Subquery_SetComparison struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ANY or ALL
	ReductionOp Expression_Subquery_SetComparison_ReductionOp `protobuf:"varint,1,opt,name=reduction_op,json=reductionOp,proto3,enum=substrait.Expression_Subquery_SetComparison_ReductionOp" json:"reduction_op,omitempty"`
	// A comparison operator
	ComparisonOp Expression_Subquery_SetComparison_ComparisonOp `protobuf:"varint,2,opt,name=comparison_op,json=comparisonOp,proto3,enum=substrait.Expression_Subquery_SetComparison_ComparisonOp" json:"comparison_op,omitempty"`
	// left side of the expression
	Left *Expression `protobuf:"bytes,3,opt,name=left,proto3" json:"left,omitempty"`
	// right side of the expression
	Right *Rel `protobuf:"bytes,4,opt,name=right,proto3" json:"right,omitempty"`
}

func (x *Expression_Subquery_SetComparison) Reset() {
	*x = Expression_Subquery_SetComparison{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expression_Subquery_SetComparison) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expression_Subquery_SetComparison) ProtoMessage() {}

func (x *Expression_Subquery_SetComparison) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expression_Subquery_SetComparison.ProtoReflect.Descriptor instead.
func (*Expression_Subquery_SetComparison) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{24, 14, 3}
}

func (x *Expression_Subquery_SetComparison) GetReductionOp() Expression_Subquery_SetComparison_ReductionOp {
	if x != nil {
		return x.ReductionOp
	}
	return Expression_Subquery_SetComparison_REDUCTION_OP_UNSPECIFIED
}

func (x *Expression_Subquery_SetComparison) GetComparisonOp() Expression_Subquery_SetComparison_ComparisonOp {
	if x != nil {
		return x.ComparisonOp
	}
	return Expression_Subquery_SetComparison_COMPARISON_OP_UNSPECIFIED
}

func (x *Expression_Subquery_SetComparison) GetLeft() *Expression {
	if x != nil {
		return x.Left
	}
	return nil
}

func (x *Expression_Subquery_SetComparison) GetRight() *Rel {
	if x != nil {
		return x.Right
	}
	return nil
}

// This rel is used  to create references,
// in case we refer to a RelRoot field names will be ignored
type AggregateFunction_ReferenceRel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SubtreeOrdinal int32 `protobuf:"varint,1,opt,name=subtree_ordinal,json=subtreeOrdinal,proto3" json:"subtree_ordinal,omitempty"`
}

func (x *AggregateFunction_ReferenceRel) Reset() {
	*x = AggregateFunction_ReferenceRel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_substrait_algebra_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregateFunction_ReferenceRel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregateFunction_ReferenceRel) ProtoMessage() {}

func (x *AggregateFunction_ReferenceRel) ProtoReflect() protoreflect.Message {
	mi := &file_substrait_algebra_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregateFunction_ReferenceRel.ProtoReflect.Descriptor instead.
func (*AggregateFunction_ReferenceRel) Descriptor() ([]byte, []int) {
	return file_substrait_algebra_proto_rawDescGZIP(), []int{26, 0}
}

func (x *AggregateFunction_ReferenceRel) GetSubtreeOrdinal() int32 {
	if x != nil {
		return x.SubtreeOrdinal
	}
	return 0
}

var File_substrait_algebra_proto protoreflect.FileDescriptor

var file_substrait_algebra_proto_rawDesc = []byte{
	0x0a, 0x17, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2f, 0x61, 0x6c, 0x67, 0x65,
	0x62, 0x72, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x09, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x25, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb2, 0x06, 0x0a,
	0x09, 0x52, 0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x06, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x06, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x12, 0x2f, 0x0a, 0x04, 0x65, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x45, 0x6d, 0x69, 0x74, 0x48, 0x00, 0x52, 0x04, 0x65, 0x6d,
	0x69, 0x74, 0x12, 0x2d, 0x0a, 0x04, 0x68, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x48, 0x69, 0x6e, 0x74, 0x52, 0x04, 0x68, 0x69, 0x6e,
	0x74, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x08, 0x0a, 0x06, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x1a, 0x2d, 0x0a, 0x04, 0x45, 0x6d, 0x69, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x05, 0x52, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x1a, 0xef, 0x03, 0x0a, 0x04, 0x48, 0x69, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x48, 0x69, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x4b, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x48, 0x69, 0x6e,
	0x74, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12,
	0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x9d, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f,
	0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x6b, 0x0a, 0x11, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x12,
	0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x42, 0x0b, 0x0a, 0x09, 0x65, 0x6d, 0x69, 0x74, 0x5f, 0x6b, 0x69, 0x6e,
	0x64, 0x22, 0xbf, 0x0e, 0x0a, 0x07, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x6c, 0x12, 0x2c, 0x0a,
	0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x0b, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x4e, 0x61, 0x6d,
	0x65, 0x64, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x62, 0x61, 0x73, 0x65, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x12, 0x2d, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x43, 0x0a, 0x12, 0x62, 0x65, 0x73, 0x74, 0x5f, 0x65, 0x66, 0x66, 0x6f,
	0x72, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x62, 0x65, 0x73, 0x74, 0x45, 0x66, 0x66, 0x6f,
	0x72, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x44, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56,
	0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x0d, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61,
	0x6c, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65,
	0x6c, 0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x00,
	0x52, 0x0c, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x6c, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x48, 0x00, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x12, 0x40, 0x0a, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x6c, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x4c, 0x0a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x6c, 0x2e,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x00,
	0x52, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x1a, 0x7a, 0x0a, 0x0a, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x4c, 0x0a, 0x0c,
	0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x3c, 0x0a, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x3e, 0x0a, 0x0e, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x2c, 0x0a, 0x06,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x1a, 0x89, 0x07, 0x0a, 0x0a, 0x4c,
	0x6f, 0x63, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x05, 0x69, 0x74, 0x65,
	0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x6c, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x72, 0x46, 0x69,
	0x6c, 0x65, 0x73, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x74, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x1a, 0xe1, 0x05, 0x0a, 0x0b, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x72, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x12, 0x1b, 0x0a, 0x08, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x75, 0x72, 0x69, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x24, 0x0a, 0x0d, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x67, 0x6c, 0x6f, 0x62,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x72, 0x69, 0x50, 0x61, 0x74,
	0x68, 0x47, 0x6c, 0x6f, 0x62, 0x12, 0x1b, 0x0a, 0x08, 0x75, 0x72, 0x69, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x75, 0x72, 0x69, 0x46, 0x69,
	0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x75, 0x72, 0x69, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x75, 0x72, 0x69, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x14, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x58, 0x0a, 0x07, 0x70, 0x61,
	0x72, 0x71, 0x75, 0x65, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x6c, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4f,
	0x72, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x50, 0x61, 0x72, 0x71, 0x75, 0x65, 0x74, 0x52, 0x65,
	0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x01, 0x52, 0x07, 0x70, 0x61, 0x72,
	0x71, 0x75, 0x65, 0x74, 0x12, 0x52, 0x0a, 0x05, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x6c, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x72, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x41,
	0x72, 0x72, 0x6f, 0x77, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48,
	0x01, 0x52, 0x05, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x12, 0x4c, 0x0a, 0x03, 0x6f, 0x72, 0x63, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x6c, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x72, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x2e, 0x4f, 0x72, 0x63, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48,
	0x01, 0x52, 0x03, 0x6f, 0x72, 0x63, 0x12, 0x34, 0x0a, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x48,
	0x01, 0x52, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x04,
	0x64, 0x77, 0x72, 0x66, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x6c, 0x2e, 0x4c,
	0x6f, 0x63, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x72,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x44, 0x77, 0x72, 0x66, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x01, 0x52, 0x04, 0x64, 0x77, 0x72, 0x66, 0x1a, 0x14, 0x0a,
	0x12, 0x50, 0x61, 0x72, 0x71, 0x75, 0x65, 0x74, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x1a, 0x12, 0x0a, 0x10, 0x41, 0x72, 0x72, 0x6f, 0x77, 0x52, 0x65, 0x61, 0x64,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x10, 0x0a, 0x0e, 0x4f, 0x72, 0x63, 0x52, 0x65,
	0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x11, 0x0a, 0x0f, 0x44, 0x77, 0x72,
	0x66, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x0b, 0x0a, 0x09,
	0x70, 0x61, 0x74, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x4a, 0x04, 0x08, 0x05, 0x10, 0x06, 0x52, 0x06,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x0b, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x22, 0xf1, 0x01, 0x0a, 0x0a, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x65, 0x6c, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52,
	0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x12, 0x24, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52,
	0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x37, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xbb, 0x04, 0x0a, 0x07, 0x4a, 0x6f, 0x69, 0x6e,
	0x52, 0x65, 0x6c, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x52, 0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x12, 0x22, 0x0a, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52,
	0x04, 0x6c, 0x65, 0x66, 0x74, 0x12, 0x24, 0x0a, 0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x52, 0x65, 0x6c, 0x52, 0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x12, 0x35, 0x0a, 0x0a, 0x65,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x10, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x6a, 0x6f, 0x69, 0x6e, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x70, 0x6f, 0x73, 0x74, 0x4a, 0x6f, 0x69, 0x6e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1b, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x4a, 0x6f,
	0x69, 0x6e, 0x52, 0x65, 0x6c, 0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xb6, 0x01, 0x0a,
	0x08, 0x4a, 0x6f, 0x69, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x4a, 0x4f, 0x49,
	0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x49, 0x4e, 0x4e, 0x45, 0x52, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x4f, 0x49,
	0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x55, 0x54, 0x45, 0x52, 0x10, 0x02, 0x12, 0x12,
	0x0a, 0x0e, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4c, 0x45, 0x46, 0x54,
	0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x52, 0x49, 0x47, 0x48, 0x54, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x4a, 0x4f, 0x49, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x4d, 0x49, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x4a,
	0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x4e, 0x54, 0x49, 0x10, 0x06, 0x12,
	0x14, 0x0a, 0x10, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x49, 0x4e,
	0x47, 0x4c, 0x45, 0x10, 0x07, 0x22, 0xda, 0x01, 0x0a, 0x08, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x52,
	0x65, 0x6c, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52,
	0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x12, 0x22, 0x0a, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x04,
	0x6c, 0x65, 0x66, 0x74, 0x12, 0x24, 0x0a, 0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x52, 0x65, 0x6c, 0x52, 0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x74, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0xe4, 0x01, 0x0a, 0x08, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x6c, 0x12,
	0x2c, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x24, 0x0a,
	0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x05, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xff, 0x03, 0x0a, 0x0c, 0x41, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x3e,
	0x0a, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x41, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x69, 0x6e, 0x67, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b,
	0x0a, 0x08, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x41, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x52, 0x08, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x12, 0x61,
	0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41,
	0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x1a, 0x54, 0x0a, 0x08, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x12,
	0x48, 0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x70, 0x0a, 0x07, 0x4d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x12, 0x36, 0x0a, 0x07, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x07, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x12, 0x2d, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xe1, 0x01, 0x0a, 0x07,
	0x53, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x6c, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x06, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x52, 0x65, 0x6c, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x2a, 0x0a, 0x05, 0x73,
	0x6f, 0x72, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x53, 0x6f, 0x72, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x52, 0x05, 0x73, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xec, 0x01, 0x0a, 0x09, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x6c, 0x12, 0x2c, 0x0a,
	0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x05, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x12, 0x33, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xaa,
	0x03, 0x0a, 0x06, 0x53, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52,
	0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12,
	0x27, 0x0a, 0x02, 0x6f, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x2e, 0x53,
	0x65, 0x74, 0x4f, 0x70, 0x52, 0x02, 0x6f, 0x70, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61,
	0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0xc8, 0x01, 0x0a, 0x05, 0x53, 0x65, 0x74, 0x4f, 0x70, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x45,
	0x54, 0x5f, 0x4f, 0x50, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x54, 0x5f, 0x4f, 0x50, 0x5f, 0x4d, 0x49, 0x4e,
	0x55, 0x53, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15,
	0x53, 0x45, 0x54, 0x5f, 0x4f, 0x50, 0x5f, 0x4d, 0x49, 0x4e, 0x55, 0x53, 0x5f, 0x4d, 0x55, 0x4c,
	0x54, 0x49, 0x53, 0x45, 0x54, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x45, 0x54, 0x5f, 0x4f,
	0x50, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x53, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50,
	0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x03, 0x12, 0x20, 0x0a, 0x1c, 0x53, 0x45, 0x54, 0x5f,
	0x4f, 0x50, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x53, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x4d, 0x55, 0x4c, 0x54, 0x49, 0x53, 0x45, 0x54, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x45,
	0x54, 0x5f, 0x4f, 0x50, 0x5f, 0x55, 0x4e, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x49,
	0x4e, 0x43, 0x54, 0x10, 0x05, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x45, 0x54, 0x5f, 0x4f, 0x50, 0x5f,
	0x55, 0x4e, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x06, 0x22, 0x96, 0x01, 0x0a, 0x12,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x52,
	0x65, 0x6c, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52,
	0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x12, 0x24, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52,
	0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x2c, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x06, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x22, 0x6e, 0x0a, 0x10, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x6c, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x06,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x06, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x22, 0x97, 0x01, 0x0a, 0x11, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x52, 0x65, 0x6c, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73,
	0x12, 0x2c, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0x9a,
	0x09, 0x0a, 0x0b, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x6c, 0x12, 0x2c,
	0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x05,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x05, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x07, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x65, 0x6c, 0x2e, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x52, 0x0a, 0x11,
	0x73, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x6c, 0x2e,
	0x53, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x48, 0x00, 0x52,
	0x0f, 0x73, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x42, 0x79, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x12, 0x54, 0x0a, 0x0d, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x6c, 0x2e,
	0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x65, 0x6c, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x44, 0x0a, 0x0b, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x5f, 0x72, 0x6f, 0x62, 0x69, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x65, 0x6c, 0x2e, 0x52, 0x6f, 0x75, 0x6e, 0x64, 0x52, 0x6f, 0x62, 0x69,
	0x6e, 0x48, 0x00, 0x52, 0x0a, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x52, 0x6f, 0x62, 0x69, 0x6e, 0x12,
	0x40, 0x0a, 0x09, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45,
	0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x6c, 0x2e, 0x42, 0x72, 0x6f, 0x61, 0x64,
	0x63, 0x61, 0x73, 0x74, 0x48, 0x00, 0x52, 0x09, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73,
	0x74, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x4d, 0x0a, 0x0d, 0x53, 0x63, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x3c, 0x0a, 0x06, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x1a, 0x4f, 0x0a, 0x16, 0x53, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x80, 0x01, 0x0a, 0x15, 0x4d, 0x75,
	0x6c, 0x74, 0x69, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a,
	0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x65, 0x64, 0x54, 0x6f, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x0b, 0x0a, 0x09,
	0x42, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x1a, 0x22, 0x0a, 0x0a, 0x52, 0x6f, 0x75,
	0x6e, 0x64, 0x52, 0x6f, 0x62, 0x69, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x78, 0x61, 0x63, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x65, 0x78, 0x61, 0x63, 0x74, 0x1a, 0x8a, 0x01,
	0x0a, 0x0e, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x32, 0x0a, 0x08, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x64, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x48,
	0x00, 0x52, 0x08, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x42, 0x0d, 0x0a, 0x0b, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x65, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x45, 0x0a, 0x07, 0x52,
	0x65, 0x6c, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x24, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x14, 0x0a, 0x05,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x22, 0xf8, 0x05, 0x0a, 0x03, 0x52, 0x65, 0x6c, 0x12, 0x28, 0x0a, 0x04, 0x72, 0x65,
	0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x04,
	0x72, 0x65, 0x61, 0x64, 0x12, 0x2e, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x05, 0x66, 0x65, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x05, 0x66, 0x65, 0x74, 0x63,
	0x68, 0x12, 0x37, 0x0a, 0x09, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x48, 0x00, 0x52,
	0x09, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x04, 0x73, 0x6f,
	0x72, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2e, 0x53, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x04,
	0x73, 0x6f, 0x72, 0x74, 0x12, 0x28, 0x0a, 0x04, 0x6a, 0x6f, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x4a,
	0x6f, 0x69, 0x6e, 0x52, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x04, 0x6a, 0x6f, 0x69, 0x6e, 0x12, 0x31,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x12, 0x25, 0x0a, 0x03, 0x73, 0x65, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x74, 0x52, 0x65,
	0x6c, 0x48, 0x00, 0x52, 0x03, 0x73, 0x65, 0x74, 0x12, 0x4a, 0x0a, 0x10, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x52, 0x65,
	0x6c, 0x48, 0x00, 0x52, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x12, 0x47, 0x0a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x52, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x0e, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x12, 0x44, 0x0a,
	0x0e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x61, 0x66, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x61, 0x66, 0x52,
	0x65, 0x6c, 0x48, 0x00, 0x52, 0x0d, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4c,
	0x65, 0x61, 0x66, 0x12, 0x2b, 0x0a, 0x05, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x43,
	0x72, 0x6f, 0x73, 0x73, 0x52, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x05, 0x63, 0x72, 0x6f, 0x73, 0x73,
	0x12, 0x35, 0x0a, 0x09, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x6a, 0x6f, 0x69, 0x6e, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x48, 0x61, 0x73, 0x68, 0x4a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x08, 0x68,
	0x61, 0x73, 0x68, 0x4a, 0x6f, 0x69, 0x6e, 0x12, 0x38, 0x0a, 0x0a, 0x6d, 0x65, 0x72, 0x67, 0x65,
	0x5f, 0x6a, 0x6f, 0x69, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x4a, 0x6f, 0x69,
	0x6e, 0x52, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x4a, 0x6f, 0x69,
	0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x80, 0x01,
	0x0a, 0x10, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61,
	0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x3f, 0x0a, 0x0f, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x2c, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x22, 0xa4, 0x05, 0x0a, 0x06, 0x44, 0x64, 0x6c, 0x52, 0x65, 0x6c, 0x12, 0x40, 0x0a, 0x0c,
	0x6e, 0x61, 0x6d, 0x65, 0x64, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x4e,
	0x61, 0x6d, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x48,
	0x00, 0x52, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x47,
	0x0a, 0x10, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x39, 0x0a, 0x0c, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x12, 0x4b, 0x0a, 0x0e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x52, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x33, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1b, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x44, 0x64, 0x6c, 0x52,
	0x65, 0x6c, 0x2e, 0x44, 0x64, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x12, 0x27, 0x0a, 0x02, 0x6f, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x17, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x44, 0x64, 0x6c,
	0x52, 0x65, 0x6c, 0x2e, 0x44, 0x64, 0x6c, 0x4f, 0x70, 0x52, 0x02, 0x6f, 0x70, 0x12, 0x37, 0x0a,
	0x0f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x0e, 0x76, 0x69, 0x65, 0x77, 0x44, 0x65, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x52, 0x0a, 0x09, 0x44, 0x64, 0x6c, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x1a, 0x0a, 0x16, 0x44, 0x44, 0x4c, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43,
	0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x14, 0x0a, 0x10, 0x44, 0x44, 0x4c, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x54, 0x41,
	0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x44, 0x4c, 0x5f, 0x4f, 0x42, 0x4a,
	0x45, 0x43, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x10, 0x02, 0x22, 0x8d, 0x01, 0x0a, 0x05, 0x44,
	0x64, 0x6c, 0x4f, 0x70, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x44, 0x4c, 0x5f, 0x4f, 0x50, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d,
	0x44, 0x44, 0x4c, 0x5f, 0x4f, 0x50, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12,
	0x1c, 0x0a, 0x18, 0x44, 0x44, 0x4c, 0x5f, 0x4f, 0x50, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x5f, 0x4f, 0x52, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x02, 0x12, 0x10, 0x0a,
	0x0c, 0x44, 0x44, 0x4c, 0x5f, 0x4f, 0x50, 0x5f, 0x41, 0x4c, 0x54, 0x45, 0x52, 0x10, 0x03, 0x12,
	0x0f, 0x0a, 0x0b, 0x44, 0x44, 0x4c, 0x5f, 0x4f, 0x50, 0x5f, 0x44, 0x52, 0x4f, 0x50, 0x10, 0x04,
	0x12, 0x18, 0x0a, 0x14, 0x44, 0x44, 0x4c, 0x5f, 0x4f, 0x50, 0x5f, 0x44, 0x52, 0x4f, 0x50, 0x5f,
	0x49, 0x46, 0x5f, 0x45, 0x58, 0x49, 0x53, 0x54, 0x10, 0x05, 0x42, 0x0c, 0x0a, 0x0a, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xc3, 0x04, 0x0a, 0x08, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x52, 0x65, 0x6c, 0x12, 0x3e, 0x0a, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x5f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x64,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x39, 0x0a, 0x0c,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x4e,
	0x61, 0x6d, 0x65, 0x64, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0b, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x2b, 0x0a, 0x02, 0x6f, 0x70, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x70,
	0x52, 0x02, 0x6f, 0x70, 0x12, 0x24, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x52, 0x65, 0x6c, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x36, 0x0a, 0x06, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x2e,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x22, 0x75, 0x0a, 0x07, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x70, 0x12, 0x18, 0x0a,
	0x14, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x4f, 0x50, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x57, 0x52, 0x49, 0x54, 0x45,
	0x5f, 0x4f, 0x50, 0x5f, 0x49, 0x4e, 0x53, 0x45, 0x52, 0x54, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f,
	0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x4f, 0x50, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10,
	0x02, 0x12, 0x13, 0x0a, 0x0f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x4f, 0x50, 0x5f, 0x55, 0x50,
	0x44, 0x41, 0x54, 0x45, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f,
	0x4f, 0x50, 0x5f, 0x43, 0x54, 0x41, 0x53, 0x10, 0x04, 0x22, 0x65, 0x0a, 0x0a, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x4f, 0x55, 0x54, 0x50, 0x55,
	0x54, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x4e, 0x4f, 0x5f, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x10, 0x01, 0x12,
	0x1f, 0x0a, 0x1b, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x4d,
	0x4f, 0x44, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f, 0x54, 0x55, 0x50, 0x4c, 0x45, 0x53, 0x10, 0x02,
	0x42, 0x0c, 0x0a, 0x0a, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xbc,
	0x05, 0x0a, 0x0b, 0x48, 0x61, 0x73, 0x68, 0x4a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x6c, 0x12, 0x2c,
	0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x04,
	0x6c, 0x65, 0x66, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x04, 0x6c, 0x65, 0x66, 0x74,
	0x12, 0x24, 0x0a, 0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52,
	0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x12, 0x41, 0x0a, 0x09, 0x6c, 0x65, 0x66, 0x74, 0x5f, 0x6b,
	0x65, 0x79, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x08, 0x6c, 0x65, 0x66, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x43, 0x0a, 0x0a, 0x72, 0x69, 0x67,
	0x68, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x52, 0x09, 0x72, 0x69, 0x67, 0x68, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x3f,
	0x0a, 0x10, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x0e, 0x70, 0x6f, 0x73, 0x74, 0x4a, 0x6f, 0x69, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x33, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x4a, 0x6f,
	0x69, 0x6e, 0x52, 0x65, 0x6c, 0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xde, 0x01, 0x0a,
	0x08, 0x4a, 0x6f, 0x69, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x4a, 0x4f, 0x49,
	0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x49, 0x4e, 0x4e, 0x45, 0x52, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x4f, 0x49,
	0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x55, 0x54, 0x45, 0x52, 0x10, 0x02, 0x12, 0x12,
	0x0a, 0x0e, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4c, 0x45, 0x46, 0x54,
	0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x52, 0x49, 0x47, 0x48, 0x54, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x4a, 0x4f, 0x49, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x53, 0x45, 0x4d, 0x49, 0x10, 0x05,
	0x12, 0x18, 0x0a, 0x14, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x49,
	0x47, 0x48, 0x54, 0x5f, 0x53, 0x45, 0x4d, 0x49, 0x10, 0x06, 0x12, 0x17, 0x0a, 0x13, 0x4a, 0x4f,
	0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x41, 0x4e, 0x54,
	0x49, 0x10, 0x07, 0x12, 0x18, 0x0a, 0x14, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x41, 0x4e, 0x54, 0x49, 0x10, 0x08, 0x22, 0xbe, 0x05,
	0x0a, 0x0c, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x4a, 0x6f, 0x69, 0x6e, 0x52, 0x65, 0x6c, 0x12, 0x2c,
	0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x04,
	0x6c, 0x65, 0x66, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x04, 0x6c, 0x65, 0x66, 0x74,
	0x12, 0x24, 0x0a, 0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52,
	0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x12, 0x41, 0x0a, 0x09, 0x6c, 0x65, 0x66, 0x74, 0x5f, 0x6b,
	0x65, 0x79, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x08, 0x6c, 0x65, 0x66, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x43, 0x0a, 0x0a, 0x72, 0x69, 0x67,
	0x68, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x52, 0x09, 0x72, 0x69, 0x67, 0x68, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x3f,
	0x0a, 0x10, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x0e, 0x70, 0x6f, 0x73, 0x74, 0x4a, 0x6f, 0x69, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x34, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x4a,
	0x6f, 0x69, 0x6e, 0x52, 0x65, 0x6c, 0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65,
	0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65,
	0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xde, 0x01,
	0x0a, 0x08, 0x4a, 0x6f, 0x69, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x4a, 0x4f,
	0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x49, 0x4e, 0x4e, 0x45, 0x52, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x4f,
	0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x55, 0x54, 0x45, 0x52, 0x10, 0x02, 0x12,
	0x12, 0x0a, 0x0e, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4c, 0x45, 0x46,
	0x54, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x4a, 0x4f, 0x49, 0x4e,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x53, 0x45, 0x4d, 0x49, 0x10,
	0x05, 0x12, 0x18, 0x0a, 0x14, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52,
	0x49, 0x47, 0x48, 0x54, 0x5f, 0x53, 0x45, 0x4d, 0x49, 0x10, 0x06, 0x12, 0x17, 0x0a, 0x13, 0x4a,
	0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x41, 0x4e,
	0x54, 0x49, 0x10, 0x07, 0x12, 0x18, 0x0a, 0x14, 0x4a, 0x4f, 0x49, 0x4e, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x41, 0x4e, 0x54, 0x49, 0x10, 0x08, 0x22, 0x8a,
	0x01, 0x0a, 0x10, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x67, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x04, 0x65, 0x6e, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x04, 0x65, 0x6e, 0x75, 0x6d, 0x12, 0x25, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x2d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x0a, 0x0a, 0x08, 0x61, 0x72, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x44, 0x0a, 0x0e, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x22, 0xb7, 0x52, 0x0a, 0x0a, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x39, 0x0a, 0x07, 0x6c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c,
	0x48, 0x00, 0x52, 0x07, 0x6c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x12, 0x44, 0x0a, 0x09, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x4f, 0x0a, 0x0f, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x72, 0x5f, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x63, 0x61, 0x6c, 0x61, 0x72, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x0e, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x72, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x0f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x0e, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x07, 0x69, 0x66, 0x5f, 0x74, 0x68, 0x65, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x66, 0x54, 0x68,
	0x65, 0x6e, 0x48, 0x00, 0x52, 0x06, 0x69, 0x66, 0x54, 0x68, 0x65, 0x6e, 0x12, 0x55, 0x0a, 0x11,
	0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53,
	0x77, 0x69, 0x74, 0x63, 0x68, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x10, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x10, 0x73, 0x69, 0x6e, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x5f,
	0x6f, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x4f, 0x72, 0x4c,
	0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x69, 0x6e, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x4f,
	0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x0d, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x6f,
	0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x4f, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x48,
	0x00, 0x52, 0x0b, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x4f, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x30,
	0x0a, 0x04, 0x63, 0x61, 0x73, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x73, 0x74, 0x48, 0x00, 0x52, 0x04, 0x63, 0x61, 0x73, 0x74,
	0x12, 0x3c, 0x0a, 0x08, 0x73, 0x75, 0x62, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x62, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x48, 0x00, 0x52, 0x08, 0x73, 0x75, 0x62, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x36,
	0x0a, 0x06, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x06,
	0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x12, 0x34, 0x0a, 0x04, 0x65, 0x6e, 0x75, 0x6d, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x75, 0x6d,
	0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x04, 0x65, 0x6e, 0x75, 0x6d, 0x1a, 0x8a, 0x01, 0x0a,
	0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x1e, 0x0a, 0x09, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x73, 0x70, 0x65, 0x63,
	0x69, 0x66, 0x69, 0x65, 0x64, 0x12, 0x44, 0x0a, 0x0b, 0x75, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0b,
	0x75, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x1a, 0x0b, 0x0a, 0x05, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x3a, 0x02, 0x18, 0x01, 0x3a, 0x02, 0x18, 0x01, 0x42, 0x0b, 0x0a, 0x09,
	0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0x9c, 0x10, 0x0a, 0x07, 0x4c, 0x69,
	0x74, 0x65, 0x72, 0x61, 0x6c, 0x12, 0x1a, 0x0a, 0x07, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x07, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61,
	0x6e, 0x12, 0x10, 0x0a, 0x02, 0x69, 0x38, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52,
	0x02, 0x69, 0x38, 0x12, 0x12, 0x0a, 0x03, 0x69, 0x31, 0x36, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x00, 0x52, 0x03, 0x69, 0x31, 0x36, 0x12, 0x12, 0x0a, 0x03, 0x69, 0x33, 0x32, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x03, 0x69, 0x33, 0x32, 0x12, 0x12, 0x0a, 0x03, 0x69,
	0x36, 0x34, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x03, 0x69, 0x36, 0x34, 0x12,
	0x14, 0x0a, 0x04, 0x66, 0x70, 0x33, 0x32, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52,
	0x04, 0x66, 0x70, 0x33, 0x32, 0x12, 0x14, 0x0a, 0x04, 0x66, 0x70, 0x36, 0x34, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x04, 0x66, 0x70, 0x36, 0x34, 0x12, 0x18, 0x0a, 0x06, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x06, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x06, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x12,
	0x1e, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x00, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12,
	0x14, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52,
	0x04, 0x64, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x68, 0x0a, 0x16, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x79, 0x65, 0x61, 0x72, 0x5f, 0x74, 0x6f, 0x5f,
	0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x59, 0x65, 0x61, 0x72, 0x54, 0x6f, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x48, 0x00,
	0x52, 0x13, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x59, 0x65, 0x61, 0x72, 0x54, 0x6f,
	0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x12, 0x68, 0x0a, 0x16, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x5f, 0x64, 0x61, 0x79, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x74,
	0x65, 0x72, 0x61, 0x6c, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x44, 0x61, 0x79,
	0x54, 0x6f, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x13, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x44, 0x61, 0x79, 0x54, 0x6f, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x12,
	0x1f, 0x0a, 0x0a, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x18, 0x15, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x66, 0x69, 0x78, 0x65, 0x64, 0x43, 0x68, 0x61, 0x72,
	0x12, 0x42, 0x0a, 0x08, 0x76, 0x61, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x18, 0x16, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61,
	0x6c, 0x2e, 0x56, 0x61, 0x72, 0x43, 0x68, 0x61, 0x72, 0x48, 0x00, 0x52, 0x07, 0x76, 0x61, 0x72,
	0x43, 0x68, 0x61, 0x72, 0x12, 0x23, 0x0a, 0x0c, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x62, 0x69,
	0x6e, 0x61, 0x72, 0x79, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0b, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x12, 0x41, 0x0a, 0x07, 0x64, 0x65, 0x63,
	0x69, 0x6d, 0x61, 0x6c, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x2e, 0x44, 0x65, 0x63, 0x69, 0x6d, 0x61,
	0x6c, 0x48, 0x00, 0x52, 0x07, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x12, 0x3e, 0x0a, 0x06,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x12, 0x35, 0x0a, 0x03,
	0x6d, 0x61, 0x70, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x2e, 0x4d, 0x61, 0x70, 0x48, 0x00, 0x52, 0x03,
	0x6d, 0x61, 0x70, 0x12, 0x23, 0x0a, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x5f, 0x74, 0x7a, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54, 0x7a, 0x12, 0x14, 0x0a, 0x04, 0x75, 0x75, 0x69, 0x64,
	0x18, 0x1c, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x04, 0x75, 0x75, 0x69, 0x64, 0x12, 0x25,
	0x0a, 0x04, 0x6e, 0x75, 0x6c, 0x6c, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52,
	0x04, 0x6e, 0x75, 0x6c, 0x6c, 0x12, 0x38, 0x0a, 0x04, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x1e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72,
	0x61, 0x6c, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x04, 0x6c, 0x69, 0x73, 0x74, 0x12,
	0x35, 0x0a, 0x0a, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x1f, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x09, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x09, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x5f,
	0x6d, 0x61, 0x70, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x61, 0x70, 0x48, 0x00,
	0x52, 0x08, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x4d, 0x61, 0x70, 0x12, 0x4e, 0x0a, 0x0c, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0b, 0x75,
	0x73, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75,
	0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x32, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e, 0x75,
	0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x38, 0x0a, 0x18, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x33, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x16, 0x74, 0x79, 0x70, 0x65, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x1a, 0x37, 0x0a, 0x07, 0x56, 0x61, 0x72, 0x43, 0x68, 0x61, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x1a, 0x53, 0x0a, 0x07, 0x44, 0x65, 0x63,
	0x69, 0x6d, 0x61, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72,
	0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70,
	0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x1a, 0xc2,
	0x01, 0x0a, 0x03, 0x4d, 0x61, 0x70, 0x12, 0x49, 0x0a, 0x0a, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x2e, 0x4d, 0x61, 0x70, 0x2e, 0x4b, 0x65,
	0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x6b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x1a, 0x70, 0x0a, 0x08, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2f, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x33,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x1a, 0x43, 0x0a, 0x13, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x59,
	0x65, 0x61, 0x72, 0x54, 0x6f, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x79, 0x65,
	0x61, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x79, 0x65, 0x61, 0x72, 0x73,
	0x12, 0x16, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x73, 0x1a, 0x67, 0x0a, 0x13, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x44, 0x61, 0x79, 0x54, 0x6f, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x12,
	0x12, 0x0a, 0x04, 0x64, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x64,
	0x61, 0x79, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x22, 0x0a,
	0x0c, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x73, 0x1a, 0x3f, 0x0a, 0x06, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x12, 0x35, 0x0a, 0x06, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x1a, 0x3d, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x1a, 0xa4, 0x01, 0x0a, 0x0b, 0x55, 0x73, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x65,
	0x64, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x74, 0x79, 0x70, 0x65, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x42, 0x0a, 0x0f, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0e, 0x74, 0x79,
	0x70, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2a, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e,
	0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x6c, 0x69, 0x74, 0x65,
	0x72, 0x61, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x1a, 0xbf, 0x04, 0x0a, 0x06, 0x4e, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x38, 0x0a, 0x18, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x16, 0x74, 0x79, 0x70, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x3d, 0x0a, 0x06, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x4e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x48, 0x00,
	0x52, 0x06, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x12, 0x37, 0x0a, 0x04, 0x6c, 0x69, 0x73, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4e, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x04, 0x6c, 0x69, 0x73,
	0x74, 0x12, 0x34, 0x0a, 0x03, 0x6d, 0x61, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x2e, 0x4d, 0x61, 0x70,
	0x48, 0x00, 0x52, 0x03, 0x6d, 0x61, 0x70, 0x1a, 0xb1, 0x01, 0x0a, 0x03, 0x4d, 0x61, 0x70, 0x12,
	0x48, 0x0a, 0x0a, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4e, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x2e, 0x4d, 0x61, 0x70, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09,
	0x6b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x60, 0x0a, 0x08, 0x4b, 0x65, 0x79,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x27, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2b,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x37, 0x0a, 0x06, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x12, 0x2d, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x1a, 0x35, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x2d, 0x0a, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x0d, 0x0a, 0x0b, 0x6e,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x90, 0x02, 0x0a, 0x0e, 0x53,
	0x63, 0x61, 0x6c, 0x61, 0x72, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a,
	0x12, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x39, 0x0a, 0x09,
	0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x61, 0x72,
	0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x33, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x30, 0x0a, 0x0b,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2d,
	0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x1a, 0xe7, 0x08,
	0x0a, 0x0e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2d, 0x0a, 0x12, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x39, 0x0a, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x33, 0x0a, 0x07, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x30, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x31, 0x0a, 0x05, 0x70, 0x68, 0x61, 0x73, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1b, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x41, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x68, 0x61, 0x73, 0x65, 0x52, 0x05, 0x70,
	0x68, 0x61, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x05, 0x73, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x53, 0x6f, 0x72, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x05, 0x73, 0x6f, 0x72, 0x74, 0x73,
	0x12, 0x52, 0x0a, 0x0a, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4b, 0x0a, 0x0b, 0x6c,
	0x6f, 0x77, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x52, 0x0a, 0x6c, 0x6f,
	0x77, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x4b, 0x0a, 0x0b, 0x75, 0x70, 0x70, 0x65,
	0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x52, 0x0a, 0x75, 0x70, 0x70, 0x65, 0x72,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x2d, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04,
	0x61, 0x72, 0x67, 0x73, 0x1a, 0xd0, 0x03, 0x0a, 0x05, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x54,
	0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x65, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x2e, 0x50, 0x72,
	0x65, 0x63, 0x65, 0x64, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x65,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x54, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x2e, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52,
	0x09, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x12, 0x58, 0x0a, 0x0b, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x2e, 0x43, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x52, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x52, 0x6f, 0x77, 0x12, 0x54, 0x0a, 0x09, 0x75, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x2e, 0x55, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x48, 0x00, 0x52,
	0x09, 0x75, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x1a, 0x23, 0x0a, 0x09, 0x50, 0x72,
	0x65, 0x63, 0x65, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x1a,
	0x23, 0x0a, 0x09, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x12, 0x16, 0x0a, 0x06,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x1a, 0x0c, 0x0a, 0x0a, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52,
	0x6f, 0x77, 0x1a, 0x0b, 0x0a, 0x09, 0x55, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x42,
	0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0xca, 0x01, 0x0a, 0x06, 0x49, 0x66, 0x54, 0x68,
	0x65, 0x6e, 0x12, 0x37, 0x0a, 0x03, 0x69, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x66, 0x54, 0x68, 0x65, 0x6e, 0x2e, 0x49, 0x66,
	0x43, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x52, 0x03, 0x69, 0x66, 0x73, 0x12, 0x29, 0x0a, 0x04, 0x65,
	0x6c, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x65, 0x6c, 0x73, 0x65, 0x1a, 0x5c, 0x0a, 0x08, 0x49, 0x66, 0x43, 0x6c, 0x61, 0x75,
	0x73, 0x65, 0x12, 0x25, 0x0a, 0x02, 0x69, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x02, 0x69, 0x66, 0x12, 0x29, 0x0a, 0x04, 0x74, 0x68, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x74, 0x68, 0x65, 0x6e, 0x1a, 0xac, 0x02, 0x0a, 0x04, 0x43, 0x61, 0x73, 0x74, 0x12, 0x23, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x2b, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12,
	0x55, 0x0a, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x43, 0x61, 0x73, 0x74, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x42, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x52, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x42, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x22, 0x7b, 0x0a, 0x0f, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x20, 0x0a, 0x1c, 0x46, 0x41, 0x49,
	0x4c, 0x55, 0x52, 0x45, 0x5f, 0x42, 0x45, 0x48, 0x41, 0x56, 0x49, 0x4f, 0x52, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x46,
	0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x42, 0x45, 0x48, 0x41, 0x56, 0x49, 0x4f, 0x52, 0x5f,
	0x52, 0x45, 0x54, 0x55, 0x52, 0x4e, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x24, 0x0a,
	0x20, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x42, 0x45, 0x48, 0x41, 0x56, 0x49, 0x4f,
	0x52, 0x5f, 0x54, 0x48, 0x52, 0x4f, 0x57, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x50, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x02, 0x1a, 0x91, 0x02, 0x0a, 0x10, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x05, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x05,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x40, 0x0a, 0x03, 0x69, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x66, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x03, 0x69, 0x66, 0x73, 0x12, 0x29, 0x0a, 0x04, 0x65, 0x6c, 0x73, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x65, 0x6c,
	0x73, 0x65, 0x1a, 0x63, 0x0a, 0x07, 0x49, 0x66, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2d, 0x0a,
	0x02, 0x69, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x02, 0x69, 0x66, 0x12, 0x29, 0x0a, 0x04,
	0x74, 0x68, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x04, 0x74, 0x68, 0x65, 0x6e, 0x1a, 0x6e, 0x0a, 0x0e, 0x53, 0x69, 0x6e, 0x67, 0x75,
	0x6c, 0x61, 0x72, 0x4f, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2f, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xb7, 0x01, 0x0a, 0x0b, 0x4d, 0x75, 0x6c, 0x74,
	0x69, 0x4f, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x42, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x75, 0x6c,
	0x74, 0x69, 0x4f, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52,
	0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x37, 0x0a, 0x06, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x12, 0x2d, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x1a, 0x93, 0x04, 0x0a, 0x10, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x30, 0x0a, 0x0b, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0f, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x73, 0x0a,
	0x16, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x6c, 0x65, 0x5f, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x50, 0x69, 0x63, 0x6b,
	0x6c, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x70, 0x79,
	0x74, 0x68, 0x6f, 0x6e, 0x50, 0x69, 0x63, 0x6b, 0x6c, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x70, 0x0a, 0x15, 0x77, 0x65, 0x62, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x6d, 0x62,
	0x6c, 0x79, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65,
	0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x65, 0x62, 0x41, 0x73, 0x73,
	0x65, 0x6d, 0x62, 0x6c, 0x79, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x13, 0x77, 0x65, 0x62, 0x41, 0x73, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x79, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x56, 0x0a, 0x14, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x50, 0x69,
	0x63, 0x6b, 0x6c, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c,
	0x70, 0x72, 0x65, 0x72, 0x65, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74, 0x65, 0x1a, 0x51, 0x0a, 0x13,
	0x57, 0x65, 0x62, 0x41, 0x73, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x79, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x22, 0x0a, 0x0c, 0x70,
	0x72, 0x65, 0x72, 0x65, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0c, 0x70, 0x72, 0x65, 0x72, 0x65, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74, 0x65, 0x42,
	0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0xe8, 0x04, 0x0a, 0x10, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x07,
	0x6d, 0x61, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x61, 0x70, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x06,
	0x6d, 0x61, 0x70, 0x4b, 0x65, 0x79, 0x12, 0x57, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12,
	0x57, 0x0a, 0x0c, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x6c, 0x69, 0x73,
	0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x7e, 0x0a, 0x06, 0x4d, 0x61, 0x70, 0x4b,
	0x65, 0x79, 0x12, 0x36, 0x0a, 0x07, 0x6d, 0x61, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72,
	0x61, 0x6c, 0x52, 0x06, 0x6d, 0x61, 0x70, 0x4b, 0x65, 0x79, 0x12, 0x3c, 0x0a, 0x05, 0x63, 0x68,
	0x69, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x05, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x1a, 0x61, 0x0a, 0x0b, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3c, 0x0a,
	0x05, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x1a, 0x63, 0x0a, 0x0b, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x12, 0x3c, 0x0a, 0x05, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x63, 0x68, 0x69, 0x6c, 0x64,
	0x42, 0x10, 0x0a, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x1a, 0xa2, 0x0b, 0x0a, 0x0e, 0x4d, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x06, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73,
	0x6b, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x52, 0x06, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x12, 0x38, 0x0a, 0x18, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x5f, 0x73, 0x69, 0x6e,
	0x67, 0x75, 0x6c, 0x61, 0x72, 0x5f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x16, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x53, 0x69, 0x6e, 0x67,
	0x75, 0x6c, 0x61, 0x72, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x1a, 0xe8, 0x01, 0x0a, 0x06, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73,
	0x6b, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x48, 0x00, 0x52, 0x04, 0x6c, 0x69, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x03, 0x6d, 0x61, 0x70,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61,
	0x73, 0x6b, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x70,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x03, 0x6d, 0x61, 0x70, 0x42, 0x06, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x62, 0x0a, 0x0c, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x52, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x5f,
	0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x0b, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x1a, 0x65, 0x0a, 0x0a, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x41, 0x0a,
	0x05, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x52, 0x05, 0x63, 0x68, 0x69, 0x6c, 0x64,
	0x1a, 0xe6, 0x03, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x12,
	0x5c, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73, 0x6b, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x49, 0x74,
	0x65, 0x6d, 0x52, 0x09, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a,
	0x05, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x52, 0x05, 0x63, 0x68, 0x69, 0x6c, 0x64,
	0x1a, 0xb6, 0x02, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x49,
	0x74, 0x65, 0x6d, 0x12, 0x60, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4a, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x49, 0x74, 0x65,
	0x6d, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52,
	0x04, 0x69, 0x74, 0x65, 0x6d, 0x12, 0x60, 0x0a, 0x05, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73, 0x6b,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x49, 0x74, 0x65, 0x6d, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x48, 0x00,
	0x52, 0x05, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x1a, 0x23, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x1a, 0x33, 0x0a, 0x09,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12,
	0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x65, 0x6e,
	0x64, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0xeb, 0x02, 0x0a, 0x09, 0x4d, 0x61,
	0x70, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x49, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73, 0x6b,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x70, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x2e, 0x4d, 0x61, 0x70, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x61, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61,
	0x73, 0x6b, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x70,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x2e, 0x4d, 0x61, 0x70, 0x4b, 0x65, 0x79, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x05, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x73, 0x6b,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x52, 0x05, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x1a, 0x21, 0x0a, 0x06, 0x4d, 0x61, 0x70, 0x4b,
	0x65, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x6d, 0x61, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x61, 0x70, 0x4b, 0x65, 0x79, 0x1a, 0x40, 0x0a, 0x10, 0x4d,
	0x61, 0x70, 0x4b, 0x65, 0x79, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x2c, 0x0a, 0x12, 0x6d, 0x61, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6d, 0x61, 0x70,
	0x4b, 0x65, 0x79, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0x0a,
	0x06, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x1a, 0x8d, 0x04, 0x0a, 0x0e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x10, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0f,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x51, 0x0a, 0x10, 0x6d, 0x61, 0x73, 0x6b, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x4d, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x0f, 0x6d, 0x61, 0x73, 0x6b, 0x65, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x37, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52,
	0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x0e, 0x72,
	0x6f, 0x6f, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x01, 0x52, 0x0d, 0x72, 0x6f, 0x6f, 0x74, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5e, 0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x65,
	0x72, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x4f, 0x75, 0x74, 0x65, 0x72, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x01, 0x52, 0x0e, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0x0f, 0x0a, 0x0d, 0x52, 0x6f, 0x6f, 0x74,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0x2d, 0x0a, 0x0e, 0x4f, 0x75, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73,
	0x74, 0x65, 0x70, 0x73, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08,
	0x73, 0x74, 0x65, 0x70, 0x73, 0x4f, 0x75, 0x74, 0x42, 0x10, 0x0a, 0x0e, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x72, 0x6f,
	0x6f, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x95, 0x0a, 0x0a, 0x08, 0x53, 0x75, 0x62, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x3f, 0x0a, 0x06, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x62, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x53, 0x63, 0x61, 0x6c, 0x61, 0x72, 0x48, 0x00, 0x52, 0x06, 0x73,
	0x63, 0x61, 0x6c, 0x61, 0x72, 0x12, 0x4f, 0x0a, 0x0c, 0x69, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x62, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x69, 0x6e, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x73, 0x65, 0x74, 0x5f, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x62, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x53, 0x65,
	0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x65,
	0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x55, 0x0a, 0x0e, 0x73, 0x65,
	0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x62, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x0d, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f,
	0x6e, 0x1a, 0x2e, 0x0a, 0x06, 0x53, 0x63, 0x61, 0x6c, 0x61, 0x72, 0x12, 0x24, 0x0a, 0x05, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x1a, 0x6a, 0x0a, 0x0b, 0x49, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x12, 0x2f, 0x0a, 0x07, 0x6e, 0x65, 0x65, 0x64, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x6e, 0x65, 0x65, 0x64, 0x6c, 0x65,
	0x73, 0x12, 0x2a, 0x0a, 0x08, 0x68, 0x61, 0x79, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x52, 0x65, 0x6c, 0x52, 0x08, 0x68, 0x61, 0x79, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x1a, 0xf1, 0x01,
	0x0a, 0x0c, 0x53, 0x65, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x5a,
	0x0a, 0x0c, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x62, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x53, 0x65, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x52, 0x0b, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x12, 0x26, 0x0a, 0x06, 0x74, 0x75,
	0x70, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x06, 0x74, 0x75, 0x70, 0x6c,
	0x65, 0x73, 0x22, 0x5d, 0x0a, 0x0b, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4f,
	0x70, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x52, 0x45, 0x44, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x4f,
	0x50, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x17, 0x0a, 0x13, 0x50, 0x52, 0x45, 0x44, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x4f, 0x50, 0x5f,
	0x45, 0x58, 0x49, 0x53, 0x54, 0x53, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x52, 0x45, 0x44,
	0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x4f, 0x50, 0x5f, 0x55, 0x4e, 0x49, 0x51, 0x55, 0x45, 0x10,
	0x02, 0x1a, 0xaa, 0x04, 0x0a, 0x0d, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69,
	0x73, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x0c, 0x72, 0x65, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6f, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x53, 0x75, 0x62, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6d,
	0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x52, 0x0b, 0x72, 0x65, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x12, 0x5e, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x5f, 0x6f,
	0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53,
	0x75, 0x62, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x61,
	0x72, 0x69, 0x73, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e,
	0x4f, 0x70, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x4f, 0x70,
	0x12, 0x29, 0x0a, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x12, 0x24, 0x0a, 0x05, 0x72,
	0x69, 0x67, 0x68, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x52, 0x05, 0x72, 0x69, 0x67, 0x68,
	0x74, 0x22, 0xb1, 0x01, 0x0a, 0x0c, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e,
	0x4f, 0x70, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x52, 0x49, 0x53, 0x4f, 0x4e,
	0x5f, 0x4f, 0x50, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x52, 0x49, 0x53, 0x4f, 0x4e, 0x5f,
	0x4f, 0x50, 0x5f, 0x45, 0x51, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4d, 0x50, 0x41,
	0x52, 0x49, 0x53, 0x4f, 0x4e, 0x5f, 0x4f, 0x50, 0x5f, 0x4e, 0x45, 0x10, 0x02, 0x12, 0x14, 0x0a,
	0x10, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x52, 0x49, 0x53, 0x4f, 0x4e, 0x5f, 0x4f, 0x50, 0x5f, 0x4c,
	0x54, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x52, 0x49, 0x53, 0x4f,
	0x4e, 0x5f, 0x4f, 0x50, 0x5f, 0x47, 0x54, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4d,
	0x50, 0x41, 0x52, 0x49, 0x53, 0x4f, 0x4e, 0x5f, 0x4f, 0x50, 0x5f, 0x4c, 0x45, 0x10, 0x05, 0x12,
	0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x52, 0x49, 0x53, 0x4f, 0x4e, 0x5f, 0x4f, 0x50,
	0x5f, 0x47, 0x45, 0x10, 0x06, 0x22, 0x57, 0x0a, 0x0b, 0x52, 0x65, 0x64, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x44, 0x55, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x4f, 0x50, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x44, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x4f, 0x50, 0x5f, 0x41, 0x4e, 0x59, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x44, 0x55,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x50, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x02, 0x42, 0x0f,
	0x0a, 0x0d, 0x73, 0x75, 0x62, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42,
	0x0a, 0x0a, 0x08, 0x72, 0x65, 0x78, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xad, 0x03, 0x0a, 0x09,
	0x53, 0x6f, 0x72, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x29, 0x0a, 0x04, 0x65, 0x78, 0x70,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x65, 0x78, 0x70, 0x72, 0x12, 0x42, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x74, 0x2e, 0x53, 0x6f, 0x72, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x53, 0x6f,
	0x72, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x70,
	0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x48,
	0x00, 0x52, 0x1b, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xdd,
	0x01, 0x0a, 0x0d, 0x53, 0x6f, 0x72, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x22, 0x0a, 0x1e, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x41, 0x53, 0x43, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x53, 0x5f, 0x46, 0x49, 0x52,
	0x53, 0x54, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x44, 0x49, 0x52,
	0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x53, 0x43, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x53,
	0x5f, 0x4c, 0x41, 0x53, 0x54, 0x10, 0x02, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x4f, 0x52, 0x54, 0x5f,
	0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x5f, 0x4e,
	0x55, 0x4c, 0x4c, 0x53, 0x5f, 0x46, 0x49, 0x52, 0x53, 0x54, 0x10, 0x03, 0x12, 0x22, 0x0a, 0x1e,
	0x53, 0x4f, 0x52, 0x54, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44,
	0x45, 0x53, 0x43, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x53, 0x5f, 0x4c, 0x41, 0x53, 0x54, 0x10, 0x04,
	0x12, 0x1c, 0x0a, 0x18, 0x53, 0x4f, 0x52, 0x54, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x45, 0x44, 0x10, 0x05, 0x42, 0x0b,
	0x0a, 0x09, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x86, 0x05, 0x0a, 0x11,
	0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x2d, 0x0a, 0x12, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x39, 0x0a, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x33, 0x0a, 0x07, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x30, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x31, 0x0a, 0x05, 0x70, 0x68, 0x61, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1b, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x41, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x68, 0x61, 0x73, 0x65, 0x52, 0x05,
	0x70, 0x68, 0x61, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x05, 0x73, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74,
	0x2e, 0x53, 0x6f, 0x72, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x05, 0x73, 0x6f, 0x72, 0x74,
	0x73, 0x12, 0x52, 0x0a, 0x0a, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x69, 0x6e, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04,
	0x61, 0x72, 0x67, 0x73, 0x1a, 0x37, 0x0a, 0x0c, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x6c, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x75, 0x62, 0x74, 0x72, 0x65, 0x65, 0x5f,
	0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x73,
	0x75, 0x62, 0x74, 0x72, 0x65, 0x65, 0x4f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x22, 0x84, 0x01,
	0x0a, 0x15, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x22, 0x41, 0x47, 0x47, 0x52, 0x45,
	0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x56, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1e, 0x0a, 0x1a, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49,
	0x4e, 0x56, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12,
	0x23, 0x0a, 0x1f, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49,
	0x4e, 0x56, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x49, 0x4e,
	0x43, 0x54, 0x10, 0x02, 0x2a, 0xef, 0x01, 0x0a, 0x10, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x68, 0x61, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x41, 0x47, 0x47,
	0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x48, 0x41, 0x53, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2d, 0x0a, 0x29,
	0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x48, 0x41, 0x53,
	0x45, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x5f, 0x54, 0x4f, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x32, 0x0a, 0x2e, 0x41,
	0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x48, 0x41, 0x53, 0x45,
	0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x4f,
	0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12,
	0x27, 0x0a, 0x23, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50,
	0x48, 0x41, 0x53, 0x45, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x5f, 0x54, 0x4f, 0x5f,
	0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x10, 0x03, 0x12, 0x2c, 0x0a, 0x28, 0x41, 0x47, 0x47, 0x52,
	0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x48, 0x41, 0x53, 0x45, 0x5f, 0x49, 0x4e,
	0x54, 0x45, 0x52, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x52, 0x45,
	0x53, 0x55, 0x4c, 0x54, 0x10, 0x04, 0x42, 0x57, 0x0a, 0x12, 0x69, 0x6f, 0x2e, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2a,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x2d, 0x69, 0x6f, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x74, 0x2d, 0x67, 0x6f, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0xaa, 0x02, 0x12, 0x53, 0x75, 0x62,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_substrait_algebra_proto_rawDescOnce sync.Once
	file_substrait_algebra_proto_rawDescData = file_substrait_algebra_proto_rawDesc
)

func file_substrait_algebra_proto_rawDescGZIP() []byte {
	file_substrait_algebra_proto_rawDescOnce.Do(func() {
		file_substrait_algebra_proto_rawDescData = protoimpl.X.CompressGZIP(file_substrait_algebra_proto_rawDescData)
	})
	return file_substrait_algebra_proto_rawDescData
}

var file_substrait_algebra_proto_enumTypes = make([]protoimpl.EnumInfo, 15)
var file_substrait_algebra_proto_msgTypes = make([]protoimpl.MessageInfo, 108)
var file_substrait_algebra_proto_goTypes = []interface{}{
	(AggregationPhase)(0),                               // 0: substrait.AggregationPhase
	(JoinRel_JoinType)(0),                               // 1: substrait.JoinRel.JoinType
	(SetRel_SetOp)(0),                                   // 2: substrait.SetRel.SetOp
	(DdlRel_DdlObject)(0),                               // 3: substrait.DdlRel.DdlObject
	(DdlRel_DdlOp)(0),                                   // 4: substrait.DdlRel.DdlOp
	(WriteRel_WriteOp)(0),                               // 5: substrait.WriteRel.WriteOp
	(WriteRel_OutputMode)(0),                            // 6: substrait.WriteRel.OutputMode
	(HashJoinRel_JoinType)(0),                           // 7: substrait.HashJoinRel.JoinType
	(MergeJoinRel_JoinType)(0),                          // 8: substrait.MergeJoinRel.JoinType
	(Expression_Cast_FailureBehavior)(0),                // 9: substrait.Expression.Cast.FailureBehavior
	(Expression_Subquery_SetPredicate_PredicateOp)(0),   // 10: substrait.Expression.Subquery.SetPredicate.PredicateOp
	(Expression_Subquery_SetComparison_ComparisonOp)(0), // 11: substrait.Expression.Subquery.SetComparison.ComparisonOp
	(Expression_Subquery_SetComparison_ReductionOp)(0),  // 12: substrait.Expression.Subquery.SetComparison.ReductionOp
	(SortField_SortDirection)(0),                        // 13: substrait.SortField.SortDirection
	(AggregateFunction_AggregationInvocation)(0),        // 14: substrait.AggregateFunction.AggregationInvocation
	(*RelCommon)(nil),                                   // 15: substrait.RelCommon
	(*ReadRel)(nil),                                     // 16: substrait.ReadRel
	(*ProjectRel)(nil),                                  // 17: substrait.ProjectRel
	(*JoinRel)(nil),                                     // 18: substrait.JoinRel
	(*CrossRel)(nil),                                    // 19: substrait.CrossRel
	(*FetchRel)(nil),                                    // 20: substrait.FetchRel
	(*AggregateRel)(nil),                                // 21: substrait.AggregateRel
	(*SortRel)(nil),                                     // 22: substrait.SortRel
	(*FilterRel)(nil),                                   // 23: substrait.FilterRel
	(*SetRel)(nil),                                      // 24: substrait.SetRel
	(*ExtensionSingleRel)(nil),                          // 25: substrait.ExtensionSingleRel
	(*ExtensionLeafRel)(nil),                            // 26: substrait.ExtensionLeafRel
	(*ExtensionMultiRel)(nil),                           // 27: substrait.ExtensionMultiRel
	(*ExchangeRel)(nil),                                 // 28: substrait.ExchangeRel
	(*RelRoot)(nil),                                     // 29: substrait.RelRoot
	(*Rel)(nil),                                         // 30: substrait.Rel
	(*NamedObjectWrite)(nil),                            // 31: substrait.NamedObjectWrite
	(*ExtensionObject)(nil),                             // 32: substrait.ExtensionObject
	(*DdlRel)(nil),                                      // 33: substrait.DdlRel
	(*WriteRel)(nil),                                    // 34: substrait.WriteRel
	(*HashJoinRel)(nil),                                 // 35: substrait.HashJoinRel
	(*MergeJoinRel)(nil),                                // 36: substrait.MergeJoinRel
	(*FunctionArgument)(nil),                            // 37: substrait.FunctionArgument
	(*FunctionOption)(nil),                              // 38: substrait.FunctionOption
	(*Expression)(nil),                                  // 39: substrait.Expression
	(*SortField)(nil),                                   // 40: substrait.SortField
	(*AggregateFunction)(nil),                           // 41: substrait.AggregateFunction
	(*RelCommon_Direct)(nil),                            // 42: substrait.RelCommon.Direct
	(*RelCommon_Emit)(nil),                              // 43: substrait.RelCommon.Emit
	(*RelCommon_Hint)(nil),                              // 44: substrait.RelCommon.Hint
	(*RelCommon_Hint_Stats)(nil),                        // 45: substrait.RelCommon.Hint.Stats
	(*RelCommon_Hint_RuntimeConstraint)(nil),            // 46: substrait.RelCommon.Hint.RuntimeConstraint
	(*ReadRel_NamedTable)(nil),                          // 47: substrait.ReadRel.NamedTable
	(*ReadRel_VirtualTable)(nil),                        // 48: substrait.ReadRel.VirtualTable
	(*ReadRel_ExtensionTable)(nil),                      // 49: substrait.ReadRel.ExtensionTable
	(*ReadRel_LocalFiles)(nil),                          // 50: substrait.ReadRel.LocalFiles
	(*ReadRel_LocalFiles_FileOrFiles)(nil),              // 51: substrait.ReadRel.LocalFiles.FileOrFiles
	(*ReadRel_LocalFiles_FileOrFiles_ParquetReadOptions)(nil),               // 52: substrait.ReadRel.LocalFiles.FileOrFiles.ParquetReadOptions
	(*ReadRel_LocalFiles_FileOrFiles_ArrowReadOptions)(nil),                 // 53: substrait.ReadRel.LocalFiles.FileOrFiles.ArrowReadOptions
	(*ReadRel_LocalFiles_FileOrFiles_OrcReadOptions)(nil),                   // 54: substrait.ReadRel.LocalFiles.FileOrFiles.OrcReadOptions
	(*ReadRel_LocalFiles_FileOrFiles_DwrfReadOptions)(nil),                  // 55: substrait.ReadRel.LocalFiles.FileOrFiles.DwrfReadOptions
	(*AggregateRel_Grouping)(nil),                                           // 56: substrait.AggregateRel.Grouping
	(*AggregateRel_Measure)(nil),                                            // 57: substrait.AggregateRel.Measure
	(*ExchangeRel_ScatterFields)(nil),                                       // 58: substrait.ExchangeRel.ScatterFields
	(*ExchangeRel_SingleBucketExpression)(nil),                              // 59: substrait.ExchangeRel.SingleBucketExpression
	(*ExchangeRel_MultiBucketExpression)(nil),                               // 60: substrait.ExchangeRel.MultiBucketExpression
	(*ExchangeRel_Broadcast)(nil),                                           // 61: substrait.ExchangeRel.Broadcast
	(*ExchangeRel_RoundRobin)(nil),                                          // 62: substrait.ExchangeRel.RoundRobin
	(*ExchangeRel_ExchangeTarget)(nil),                                      // 63: substrait.ExchangeRel.ExchangeTarget
	(*Expression_Enum)(nil),                                                 // 64: substrait.Expression.Enum
	(*Expression_Literal)(nil),                                              // 65: substrait.Expression.Literal
	(*Expression_Nested)(nil),                                               // 66: substrait.Expression.Nested
	(*Expression_ScalarFunction)(nil),                                       // 67: substrait.Expression.ScalarFunction
	(*Expression_WindowFunction)(nil),                                       // 68: substrait.Expression.WindowFunction
	(*Expression_IfThen)(nil),                                               // 69: substrait.Expression.IfThen
	(*Expression_Cast)(nil),                                                 // 70: substrait.Expression.Cast
	(*Expression_SwitchExpression)(nil),                                     // 71: substrait.Expression.SwitchExpression
	(*Expression_SingularOrList)(nil),                                       // 72: substrait.Expression.SingularOrList
	(*Expression_MultiOrList)(nil),                                          // 73: substrait.Expression.MultiOrList
	(*Expression_EmbeddedFunction)(nil),                                     // 74: substrait.Expression.EmbeddedFunction
	(*Expression_ReferenceSegment)(nil),                                     // 75: substrait.Expression.ReferenceSegment
	(*Expression_MaskExpression)(nil),                                       // 76: substrait.Expression.MaskExpression
	(*Expression_FieldReference)(nil),                                       // 77: substrait.Expression.FieldReference
	(*Expression_Subquery)(nil),                                             // 78: substrait.Expression.Subquery
	(*Expression_Enum_Empty)(nil),                                           // 79: substrait.Expression.Enum.Empty
	(*Expression_Literal_VarChar)(nil),                                      // 80: substrait.Expression.Literal.VarChar
	(*Expression_Literal_Decimal)(nil),                                      // 81: substrait.Expression.Literal.Decimal
	(*Expression_Literal_Map)(nil),                                          // 82: substrait.Expression.Literal.Map
	(*Expression_Literal_IntervalYearToMonth)(nil),                          // 83: substrait.Expression.Literal.IntervalYearToMonth
	(*Expression_Literal_IntervalDayToSecond)(nil),                          // 84: substrait.Expression.Literal.IntervalDayToSecond
	(*Expression_Literal_Struct)(nil),                                       // 85: substrait.Expression.Literal.Struct
	(*Expression_Literal_List)(nil),                                         // 86: substrait.Expression.Literal.List
	(*Expression_Literal_UserDefined)(nil),                                  // 87: substrait.Expression.Literal.UserDefined
	(*Expression_Literal_Map_KeyValue)(nil),                                 // 88: substrait.Expression.Literal.Map.KeyValue
	(*Expression_Nested_Map)(nil),                                           // 89: substrait.Expression.Nested.Map
	(*Expression_Nested_Struct)(nil),                                        // 90: substrait.Expression.Nested.Struct
	(*Expression_Nested_List)(nil),                                          // 91: substrait.Expression.Nested.List
	(*Expression_Nested_Map_KeyValue)(nil),                                  // 92: substrait.Expression.Nested.Map.KeyValue
	(*Expression_WindowFunction_Bound)(nil),                                 // 93: substrait.Expression.WindowFunction.Bound
	(*Expression_WindowFunction_Bound_Preceding)(nil),                       // 94: substrait.Expression.WindowFunction.Bound.Preceding
	(*Expression_WindowFunction_Bound_Following)(nil),                       // 95: substrait.Expression.WindowFunction.Bound.Following
	(*Expression_WindowFunction_Bound_CurrentRow)(nil),                      // 96: substrait.Expression.WindowFunction.Bound.CurrentRow
	(*Expression_WindowFunction_Bound_Unbounded)(nil),                       // 97: substrait.Expression.WindowFunction.Bound.Unbounded
	(*Expression_IfThen_IfClause)(nil),                                      // 98: substrait.Expression.IfThen.IfClause
	(*Expression_SwitchExpression_IfValue)(nil),                             // 99: substrait.Expression.SwitchExpression.IfValue
	(*Expression_MultiOrList_Record)(nil),                                   // 100: substrait.Expression.MultiOrList.Record
	(*Expression_EmbeddedFunction_PythonPickleFunction)(nil),                // 101: substrait.Expression.EmbeddedFunction.PythonPickleFunction
	(*Expression_EmbeddedFunction_WebAssemblyFunction)(nil),                 // 102: substrait.Expression.EmbeddedFunction.WebAssemblyFunction
	(*Expression_ReferenceSegment_MapKey)(nil),                              // 103: substrait.Expression.ReferenceSegment.MapKey
	(*Expression_ReferenceSegment_StructField)(nil),                         // 104: substrait.Expression.ReferenceSegment.StructField
	(*Expression_ReferenceSegment_ListElement)(nil),                         // 105: substrait.Expression.ReferenceSegment.ListElement
	(*Expression_MaskExpression_Select)(nil),                                // 106: substrait.Expression.MaskExpression.Select
	(*Expression_MaskExpression_StructSelect)(nil),                          // 107: substrait.Expression.MaskExpression.StructSelect
	(*Expression_MaskExpression_StructItem)(nil),                            // 108: substrait.Expression.MaskExpression.StructItem
	(*Expression_MaskExpression_ListSelect)(nil),                            // 109: substrait.Expression.MaskExpression.ListSelect
	(*Expression_MaskExpression_MapSelect)(nil),                             // 110: substrait.Expression.MaskExpression.MapSelect
	(*Expression_MaskExpression_ListSelect_ListSelectItem)(nil),             // 111: substrait.Expression.MaskExpression.ListSelect.ListSelectItem
	(*Expression_MaskExpression_ListSelect_ListSelectItem_ListElement)(nil), // 112: substrait.Expression.MaskExpression.ListSelect.ListSelectItem.ListElement
	(*Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice)(nil),   // 113: substrait.Expression.MaskExpression.ListSelect.ListSelectItem.ListSlice
	(*Expression_MaskExpression_MapSelect_MapKey)(nil),                      // 114: substrait.Expression.MaskExpression.MapSelect.MapKey
	(*Expression_MaskExpression_MapSelect_MapKeyExpression)(nil),            // 115: substrait.Expression.MaskExpression.MapSelect.MapKeyExpression
	(*Expression_FieldReference_RootReference)(nil),                         // 116: substrait.Expression.FieldReference.RootReference
	(*Expression_FieldReference_OuterReference)(nil),                        // 117: substrait.Expression.FieldReference.OuterReference
	(*Expression_Subquery_Scalar)(nil),                                      // 118: substrait.Expression.Subquery.Scalar
	(*Expression_Subquery_InPredicate)(nil),                                 // 119: substrait.Expression.Subquery.InPredicate
	(*Expression_Subquery_SetPredicate)(nil),                                // 120: substrait.Expression.Subquery.SetPredicate
	(*Expression_Subquery_SetComparison)(nil),                               // 121: substrait.Expression.Subquery.SetComparison
	(*AggregateFunction_ReferenceRel)(nil),                                  // 122: substrait.AggregateFunction.ReferenceRel
	(*extensions.AdvancedExtension)(nil),                                    // 123: substrait.extensions.AdvancedExtension
	(*NamedStruct)(nil),                                                     // 124: substrait.NamedStruct
	(*anypb.Any)(nil),                                                       // 125: google.protobuf.Any
	(*Type)(nil),                                                            // 126: substrait.Type
	(*Type_List)(nil),                                                       // 127: substrait.Type.List
	(*Type_Map)(nil),                                                        // 128: substrait.Type.Map
	(*Type_Parameter)(nil),                                                  // 129: substrait.Type.Parameter
}
var file_substrait_algebra_proto_depIdxs = []int32{
	42,  // 0: substrait.RelCommon.direct:type_name -> substrait.RelCommon.Direct
	43,  // 1: substrait.RelCommon.emit:type_name -> substrait.RelCommon.Emit
	44,  // 2: substrait.RelCommon.hint:type_name -> substrait.RelCommon.Hint
	123, // 3: substrait.RelCommon.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	15,  // 4: substrait.ReadRel.common:type_name -> substrait.RelCommon
	124, // 5: substrait.ReadRel.base_schema:type_name -> substrait.NamedStruct
	39,  // 6: substrait.ReadRel.filter:type_name -> substrait.Expression
	39,  // 7: substrait.ReadRel.best_effort_filter:type_name -> substrait.Expression
	76,  // 8: substrait.ReadRel.projection:type_name -> substrait.Expression.MaskExpression
	123, // 9: substrait.ReadRel.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	48,  // 10: substrait.ReadRel.virtual_table:type_name -> substrait.ReadRel.VirtualTable
	50,  // 11: substrait.ReadRel.local_files:type_name -> substrait.ReadRel.LocalFiles
	47,  // 12: substrait.ReadRel.named_table:type_name -> substrait.ReadRel.NamedTable
	49,  // 13: substrait.ReadRel.extension_table:type_name -> substrait.ReadRel.ExtensionTable
	15,  // 14: substrait.ProjectRel.common:type_name -> substrait.RelCommon
	30,  // 15: substrait.ProjectRel.input:type_name -> substrait.Rel
	39,  // 16: substrait.ProjectRel.expressions:type_name -> substrait.Expression
	123, // 17: substrait.ProjectRel.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	15,  // 18: substrait.JoinRel.common:type_name -> substrait.RelCommon
	30,  // 19: substrait.JoinRel.left:type_name -> substrait.Rel
	30,  // 20: substrait.JoinRel.right:type_name -> substrait.Rel
	39,  // 21: substrait.JoinRel.expression:type_name -> substrait.Expression
	39,  // 22: substrait.JoinRel.post_join_filter:type_name -> substrait.Expression
	1,   // 23: substrait.JoinRel.type:type_name -> substrait.JoinRel.JoinType
	123, // 24: substrait.JoinRel.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	15,  // 25: substrait.CrossRel.common:type_name -> substrait.RelCommon
	30,  // 26: substrait.CrossRel.left:type_name -> substrait.Rel
	30,  // 27: substrait.CrossRel.right:type_name -> substrait.Rel
	123, // 28: substrait.CrossRel.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	15,  // 29: substrait.FetchRel.common:type_name -> substrait.RelCommon
	30,  // 30: substrait.FetchRel.input:type_name -> substrait.Rel
	123, // 31: substrait.FetchRel.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	15,  // 32: substrait.AggregateRel.common:type_name -> substrait.RelCommon
	30,  // 33: substrait.AggregateRel.input:type_name -> substrait.Rel
	56,  // 34: substrait.AggregateRel.groupings:type_name -> substrait.AggregateRel.Grouping
	57,  // 35: substrait.AggregateRel.measures:type_name -> substrait.AggregateRel.Measure
	123, // 36: substrait.AggregateRel.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	15,  // 37: substrait.SortRel.common:type_name -> substrait.RelCommon
	30,  // 38: substrait.SortRel.input:type_name -> substrait.Rel
	40,  // 39: substrait.SortRel.sorts:type_name -> substrait.SortField
	123, // 40: substrait.SortRel.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	15,  // 41: substrait.FilterRel.common:type_name -> substrait.RelCommon
	30,  // 42: substrait.FilterRel.input:type_name -> substrait.Rel
	39,  // 43: substrait.FilterRel.condition:type_name -> substrait.Expression
	123, // 44: substrait.FilterRel.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	15,  // 45: substrait.SetRel.common:type_name -> substrait.RelCommon
	30,  // 46: substrait.SetRel.inputs:type_name -> substrait.Rel
	2,   // 47: substrait.SetRel.op:type_name -> substrait.SetRel.SetOp
	123, // 48: substrait.SetRel.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	15,  // 49: substrait.ExtensionSingleRel.common:type_name -> substrait.RelCommon
	30,  // 50: substrait.ExtensionSingleRel.input:type_name -> substrait.Rel
	125, // 51: substrait.ExtensionSingleRel.detail:type_name -> google.protobuf.Any
	15,  // 52: substrait.ExtensionLeafRel.common:type_name -> substrait.RelCommon
	125, // 53: substrait.ExtensionLeafRel.detail:type_name -> google.protobuf.Any
	15,  // 54: substrait.ExtensionMultiRel.common:type_name -> substrait.RelCommon
	30,  // 55: substrait.ExtensionMultiRel.inputs:type_name -> substrait.Rel
	125, // 56: substrait.ExtensionMultiRel.detail:type_name -> google.protobuf.Any
	15,  // 57: substrait.ExchangeRel.common:type_name -> substrait.RelCommon
	30,  // 58: substrait.ExchangeRel.input:type_name -> substrait.Rel
	63,  // 59: substrait.ExchangeRel.targets:type_name -> substrait.ExchangeRel.ExchangeTarget
	58,  // 60: substrait.ExchangeRel.scatter_by_fields:type_name -> substrait.ExchangeRel.ScatterFields
	59,  // 61: substrait.ExchangeRel.single_target:type_name -> substrait.ExchangeRel.SingleBucketExpression
	60,  // 62: substrait.ExchangeRel.multi_target:type_name -> substrait.ExchangeRel.MultiBucketExpression
	62,  // 63: substrait.ExchangeRel.round_robin:type_name -> substrait.ExchangeRel.RoundRobin
	61,  // 64: substrait.ExchangeRel.broadcast:type_name -> substrait.ExchangeRel.Broadcast
	123, // 65: substrait.ExchangeRel.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	30,  // 66: substrait.RelRoot.input:type_name -> substrait.Rel
	16,  // 67: substrait.Rel.read:type_name -> substrait.ReadRel
	23,  // 68: substrait.Rel.filter:type_name -> substrait.FilterRel
	20,  // 69: substrait.Rel.fetch:type_name -> substrait.FetchRel
	21,  // 70: substrait.Rel.aggregate:type_name -> substrait.AggregateRel
	22,  // 71: substrait.Rel.sort:type_name -> substrait.SortRel
	18,  // 72: substrait.Rel.join:type_name -> substrait.JoinRel
	17,  // 73: substrait.Rel.project:type_name -> substrait.ProjectRel
	24,  // 74: substrait.Rel.set:type_name -> substrait.SetRel
	25,  // 75: substrait.Rel.extension_single:type_name -> substrait.ExtensionSingleRel
	27,  // 76: substrait.Rel.extension_multi:type_name -> substrait.ExtensionMultiRel
	26,  // 77: substrait.Rel.extension_leaf:type_name -> substrait.ExtensionLeafRel
	19,  // 78: substrait.Rel.cross:type_name -> substrait.CrossRel
	35,  // 79: substrait.Rel.hash_join:type_name -> substrait.HashJoinRel
	36,  // 80: substrait.Rel.merge_join:type_name -> substrait.MergeJoinRel
	123, // 81: substrait.NamedObjectWrite.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	125, // 82: substrait.ExtensionObject.detail:type_name -> google.protobuf.Any
	31,  // 83: substrait.DdlRel.named_object:type_name -> substrait.NamedObjectWrite
	32,  // 84: substrait.DdlRel.extension_object:type_name -> substrait.ExtensionObject
	124, // 85: substrait.DdlRel.table_schema:type_name -> substrait.NamedStruct
	85,  // 86: substrait.DdlRel.table_defaults:type_name -> substrait.Expression.Literal.Struct
	3,   // 87: substrait.DdlRel.object:type_name -> substrait.DdlRel.DdlObject
	4,   // 88: substrait.DdlRel.op:type_name -> substrait.DdlRel.DdlOp
	30,  // 89: substrait.DdlRel.view_definition:type_name -> substrait.Rel
	31,  // 90: substrait.WriteRel.named_table:type_name -> substrait.NamedObjectWrite
	32,  // 91: substrait.WriteRel.extension_table:type_name -> substrait.ExtensionObject
	124, // 92: substrait.WriteRel.table_schema:type_name -> substrait.NamedStruct
	5,   // 93: substrait.WriteRel.op:type_name -> substrait.WriteRel.WriteOp
	30,  // 94: substrait.WriteRel.input:type_name -> substrait.Rel
	6,   // 95: substrait.WriteRel.output:type_name -> substrait.WriteRel.OutputMode
	15,  // 96: substrait.HashJoinRel.common:type_name -> substrait.RelCommon
	30,  // 97: substrait.HashJoinRel.left:type_name -> substrait.Rel
	30,  // 98: substrait.HashJoinRel.right:type_name -> substrait.Rel
	77,  // 99: substrait.HashJoinRel.left_keys:type_name -> substrait.Expression.FieldReference
	77,  // 100: substrait.HashJoinRel.right_keys:type_name -> substrait.Expression.FieldReference
	39,  // 101: substrait.HashJoinRel.post_join_filter:type_name -> substrait.Expression
	7,   // 102: substrait.HashJoinRel.type:type_name -> substrait.HashJoinRel.JoinType
	123, // 103: substrait.HashJoinRel.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	15,  // 104: substrait.MergeJoinRel.common:type_name -> substrait.RelCommon
	30,  // 105: substrait.MergeJoinRel.left:type_name -> substrait.Rel
	30,  // 106: substrait.MergeJoinRel.right:type_name -> substrait.Rel
	77,  // 107: substrait.MergeJoinRel.left_keys:type_name -> substrait.Expression.FieldReference
	77,  // 108: substrait.MergeJoinRel.right_keys:type_name -> substrait.Expression.FieldReference
	39,  // 109: substrait.MergeJoinRel.post_join_filter:type_name -> substrait.Expression
	8,   // 110: substrait.MergeJoinRel.type:type_name -> substrait.MergeJoinRel.JoinType
	123, // 111: substrait.MergeJoinRel.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	126, // 112: substrait.FunctionArgument.type:type_name -> substrait.Type
	39,  // 113: substrait.FunctionArgument.value:type_name -> substrait.Expression
	65,  // 114: substrait.Expression.literal:type_name -> substrait.Expression.Literal
	77,  // 115: substrait.Expression.selection:type_name -> substrait.Expression.FieldReference
	67,  // 116: substrait.Expression.scalar_function:type_name -> substrait.Expression.ScalarFunction
	68,  // 117: substrait.Expression.window_function:type_name -> substrait.Expression.WindowFunction
	69,  // 118: substrait.Expression.if_then:type_name -> substrait.Expression.IfThen
	71,  // 119: substrait.Expression.switch_expression:type_name -> substrait.Expression.SwitchExpression
	72,  // 120: substrait.Expression.singular_or_list:type_name -> substrait.Expression.SingularOrList
	73,  // 121: substrait.Expression.multi_or_list:type_name -> substrait.Expression.MultiOrList
	70,  // 122: substrait.Expression.cast:type_name -> substrait.Expression.Cast
	78,  // 123: substrait.Expression.subquery:type_name -> substrait.Expression.Subquery
	66,  // 124: substrait.Expression.nested:type_name -> substrait.Expression.Nested
	64,  // 125: substrait.Expression.enum:type_name -> substrait.Expression.Enum
	39,  // 126: substrait.SortField.expr:type_name -> substrait.Expression
	13,  // 127: substrait.SortField.direction:type_name -> substrait.SortField.SortDirection
	37,  // 128: substrait.AggregateFunction.arguments:type_name -> substrait.FunctionArgument
	38,  // 129: substrait.AggregateFunction.options:type_name -> substrait.FunctionOption
	126, // 130: substrait.AggregateFunction.output_type:type_name -> substrait.Type
	0,   // 131: substrait.AggregateFunction.phase:type_name -> substrait.AggregationPhase
	40,  // 132: substrait.AggregateFunction.sorts:type_name -> substrait.SortField
	14,  // 133: substrait.AggregateFunction.invocation:type_name -> substrait.AggregateFunction.AggregationInvocation
	39,  // 134: substrait.AggregateFunction.args:type_name -> substrait.Expression
	45,  // 135: substrait.RelCommon.Hint.stats:type_name -> substrait.RelCommon.Hint.Stats
	46,  // 136: substrait.RelCommon.Hint.constraint:type_name -> substrait.RelCommon.Hint.RuntimeConstraint
	123, // 137: substrait.RelCommon.Hint.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	123, // 138: substrait.RelCommon.Hint.Stats.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	123, // 139: substrait.RelCommon.Hint.RuntimeConstraint.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	123, // 140: substrait.ReadRel.NamedTable.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	85,  // 141: substrait.ReadRel.VirtualTable.values:type_name -> substrait.Expression.Literal.Struct
	125, // 142: substrait.ReadRel.ExtensionTable.detail:type_name -> google.protobuf.Any
	51,  // 143: substrait.ReadRel.LocalFiles.items:type_name -> substrait.ReadRel.LocalFiles.FileOrFiles
	123, // 144: substrait.ReadRel.LocalFiles.advanced_extension:type_name -> substrait.extensions.AdvancedExtension
	52,  // 145: substrait.ReadRel.LocalFiles.FileOrFiles.parquet:type_name -> substrait.ReadRel.LocalFiles.FileOrFiles.ParquetReadOptions
	53,  // 146: substrait.ReadRel.LocalFiles.FileOrFiles.arrow:type_name -> substrait.ReadRel.LocalFiles.FileOrFiles.ArrowReadOptions
	54,  // 147: substrait.ReadRel.LocalFiles.FileOrFiles.orc:type_name -> substrait.ReadRel.LocalFiles.FileOrFiles.OrcReadOptions
	125, // 148: substrait.ReadRel.LocalFiles.FileOrFiles.extension:type_name -> google.protobuf.Any
	55,  // 149: substrait.ReadRel.LocalFiles.FileOrFiles.dwrf:type_name -> substrait.ReadRel.LocalFiles.FileOrFiles.DwrfReadOptions
	39,  // 150: substrait.AggregateRel.Grouping.grouping_expressions:type_name -> substrait.Expression
	41,  // 151: substrait.AggregateRel.Measure.measure:type_name -> substrait.AggregateFunction
	39,  // 152: substrait.AggregateRel.Measure.filter:type_name -> substrait.Expression
	77,  // 153: substrait.ExchangeRel.ScatterFields.fields:type_name -> substrait.Expression.FieldReference
	39,  // 154: substrait.ExchangeRel.SingleBucketExpression.expression:type_name -> substrait.Expression
	39,  // 155: substrait.ExchangeRel.MultiBucketExpression.expression:type_name -> substrait.Expression
	125, // 156: substrait.ExchangeRel.ExchangeTarget.extended:type_name -> google.protobuf.Any
	79,  // 157: substrait.Expression.Enum.unspecified:type_name -> substrait.Expression.Enum.Empty
	83,  // 158: substrait.Expression.Literal.interval_year_to_month:type_name -> substrait.Expression.Literal.IntervalYearToMonth
	84,  // 159: substrait.Expression.Literal.interval_day_to_second:type_name -> substrait.Expression.Literal.IntervalDayToSecond
	80,  // 160: substrait.Expression.Literal.var_char:type_name -> substrait.Expression.Literal.VarChar
	81,  // 161: substrait.Expression.Literal.decimal:type_name -> substrait.Expression.Literal.Decimal
	85,  // 162: substrait.Expression.Literal.struct:type_name -> substrait.Expression.Literal.Struct
	82,  // 163: substrait.Expression.Literal.map:type_name -> substrait.Expression.Literal.Map
	126, // 164: substrait.Expression.Literal.null:type_name -> substrait.Type
	86,  // 165: substrait.Expression.Literal.list:type_name -> substrait.Expression.Literal.List
	127, // 166: substrait.Expression.Literal.empty_list:type_name -> substrait.Type.List
	128, // 167: substrait.Expression.Literal.empty_map:type_name -> substrait.Type.Map
	87,  // 168: substrait.Expression.Literal.user_defined:type_name -> substrait.Expression.Literal.UserDefined
	90,  // 169: substrait.Expression.Nested.struct:type_name -> substrait.Expression.Nested.Struct
	91,  // 170: substrait.Expression.Nested.list:type_name -> substrait.Expression.Nested.List
	89,  // 171: substrait.Expression.Nested.map:type_name -> substrait.Expression.Nested.Map
	37,  // 172: substrait.Expression.ScalarFunction.arguments:type_name -> substrait.FunctionArgument
	38,  // 173: substrait.Expression.ScalarFunction.options:type_name -> substrait.FunctionOption
	126, // 174: substrait.Expression.ScalarFunction.output_type:type_name -> substrait.Type
	39,  // 175: substrait.Expression.ScalarFunction.args:type_name -> substrait.Expression
	37,  // 176: substrait.Expression.WindowFunction.arguments:type_name -> substrait.FunctionArgument
	38,  // 177: substrait.Expression.WindowFunction.options:type_name -> substrait.FunctionOption
	126, // 178: substrait.Expression.WindowFunction.output_type:type_name -> substrait.Type
	0,   // 179: substrait.Expression.WindowFunction.phase:type_name -> substrait.AggregationPhase
	40,  // 180: substrait.Expression.WindowFunction.sorts:type_name -> substrait.SortField
	14,  // 181: substrait.Expression.WindowFunction.invocation:type_name -> substrait.AggregateFunction.AggregationInvocation
	39,  // 182: substrait.Expression.WindowFunction.partitions:type_name -> substrait.Expression
	93,  // 183: substrait.Expression.WindowFunction.lower_bound:type_name -> substrait.Expression.WindowFunction.Bound
	93,  // 184: substrait.Expression.WindowFunction.upper_bound:type_name -> substrait.Expression.WindowFunction.Bound
	39,  // 185: substrait.Expression.WindowFunction.args:type_name -> substrait.Expression
	98,  // 186: substrait.Expression.IfThen.ifs:type_name -> substrait.Expression.IfThen.IfClause
	39,  // 187: substrait.Expression.IfThen.else:type_name -> substrait.Expression
	126, // 188: substrait.Expression.Cast.type:type_name -> substrait.Type
	39,  // 189: substrait.Expression.Cast.input:type_name -> substrait.Expression
	9,   // 190: substrait.Expression.Cast.failure_behavior:type_name -> substrait.Expression.Cast.FailureBehavior
	39,  // 191: substrait.Expression.SwitchExpression.match:type_name -> substrait.Expression
	99,  // 192: substrait.Expression.SwitchExpression.ifs:type_name -> substrait.Expression.SwitchExpression.IfValue
	39,  // 193: substrait.Expression.SwitchExpression.else:type_name -> substrait.Expression
	39,  // 194: substrait.Expression.SingularOrList.value:type_name -> substrait.Expression
	39,  // 195: substrait.Expression.SingularOrList.options:type_name -> substrait.Expression
	39,  // 196: substrait.Expression.MultiOrList.value:type_name -> substrait.Expression
	100, // 197: substrait.Expression.MultiOrList.options:type_name -> substrait.Expression.MultiOrList.Record
	39,  // 198: substrait.Expression.EmbeddedFunction.arguments:type_name -> substrait.Expression
	126, // 199: substrait.Expression.EmbeddedFunction.output_type:type_name -> substrait.Type
	101, // 200: substrait.Expression.EmbeddedFunction.python_pickle_function:type_name -> substrait.Expression.EmbeddedFunction.PythonPickleFunction
	102, // 201: substrait.Expression.EmbeddedFunction.web_assembly_function:type_name -> substrait.Expression.EmbeddedFunction.WebAssemblyFunction
	103, // 202: substrait.Expression.ReferenceSegment.map_key:type_name -> substrait.Expression.ReferenceSegment.MapKey
	104, // 203: substrait.Expression.ReferenceSegment.struct_field:type_name -> substrait.Expression.ReferenceSegment.StructField
	105, // 204: substrait.Expression.ReferenceSegment.list_element:type_name -> substrait.Expression.ReferenceSegment.ListElement
	107, // 205: substrait.Expression.MaskExpression.select:type_name -> substrait.Expression.MaskExpression.StructSelect
	75,  // 206: substrait.Expression.FieldReference.direct_reference:type_name -> substrait.Expression.ReferenceSegment
	76,  // 207: substrait.Expression.FieldReference.masked_reference:type_name -> substrait.Expression.MaskExpression
	39,  // 208: substrait.Expression.FieldReference.expression:type_name -> substrait.Expression
	116, // 209: substrait.Expression.FieldReference.root_reference:type_name -> substrait.Expression.FieldReference.RootReference
	117, // 210: substrait.Expression.FieldReference.outer_reference:type_name -> substrait.Expression.FieldReference.OuterReference
	118, // 211: substrait.Expression.Subquery.scalar:type_name -> substrait.Expression.Subquery.Scalar
	119, // 212: substrait.Expression.Subquery.in_predicate:type_name -> substrait.Expression.Subquery.InPredicate
	120, // 213: substrait.Expression.Subquery.set_predicate:type_name -> substrait.Expression.Subquery.SetPredicate
	121, // 214: substrait.Expression.Subquery.set_comparison:type_name -> substrait.Expression.Subquery.SetComparison
	88,  // 215: substrait.Expression.Literal.Map.key_values:type_name -> substrait.Expression.Literal.Map.KeyValue
	65,  // 216: substrait.Expression.Literal.Struct.fields:type_name -> substrait.Expression.Literal
	65,  // 217: substrait.Expression.Literal.List.values:type_name -> substrait.Expression.Literal
	129, // 218: substrait.Expression.Literal.UserDefined.type_parameters:type_name -> substrait.Type.Parameter
	125, // 219: substrait.Expression.Literal.UserDefined.value:type_name -> google.protobuf.Any
	65,  // 220: substrait.Expression.Literal.Map.KeyValue.key:type_name -> substrait.Expression.Literal
	65,  // 221: substrait.Expression.Literal.Map.KeyValue.value:type_name -> substrait.Expression.Literal
	92,  // 222: substrait.Expression.Nested.Map.key_values:type_name -> substrait.Expression.Nested.Map.KeyValue
	39,  // 223: substrait.Expression.Nested.Struct.fields:type_name -> substrait.Expression
	39,  // 224: substrait.Expression.Nested.List.values:type_name -> substrait.Expression
	39,  // 225: substrait.Expression.Nested.Map.KeyValue.key:type_name -> substrait.Expression
	39,  // 226: substrait.Expression.Nested.Map.KeyValue.value:type_name -> substrait.Expression
	94,  // 227: substrait.Expression.WindowFunction.Bound.preceding:type_name -> substrait.Expression.WindowFunction.Bound.Preceding
	95,  // 228: substrait.Expression.WindowFunction.Bound.following:type_name -> substrait.Expression.WindowFunction.Bound.Following
	96,  // 229: substrait.Expression.WindowFunction.Bound.current_row:type_name -> substrait.Expression.WindowFunction.Bound.CurrentRow
	97,  // 230: substrait.Expression.WindowFunction.Bound.unbounded:type_name -> substrait.Expression.WindowFunction.Bound.Unbounded
	39,  // 231: substrait.Expression.IfThen.IfClause.if:type_name -> substrait.Expression
	39,  // 232: substrait.Expression.IfThen.IfClause.then:type_name -> substrait.Expression
	65,  // 233: substrait.Expression.SwitchExpression.IfValue.if:type_name -> substrait.Expression.Literal
	39,  // 234: substrait.Expression.SwitchExpression.IfValue.then:type_name -> substrait.Expression
	39,  // 235: substrait.Expression.MultiOrList.Record.fields:type_name -> substrait.Expression
	65,  // 236: substrait.Expression.ReferenceSegment.MapKey.map_key:type_name -> substrait.Expression.Literal
	75,  // 237: substrait.Expression.ReferenceSegment.MapKey.child:type_name -> substrait.Expression.ReferenceSegment
	75,  // 238: substrait.Expression.ReferenceSegment.StructField.child:type_name -> substrait.Expression.ReferenceSegment
	75,  // 239: substrait.Expression.ReferenceSegment.ListElement.child:type_name -> substrait.Expression.ReferenceSegment
	107, // 240: substrait.Expression.MaskExpression.Select.struct:type_name -> substrait.Expression.MaskExpression.StructSelect
	109, // 241: substrait.Expression.MaskExpression.Select.list:type_name -> substrait.Expression.MaskExpression.ListSelect
	110, // 242: substrait.Expression.MaskExpression.Select.map:type_name -> substrait.Expression.MaskExpression.MapSelect
	108, // 243: substrait.Expression.MaskExpression.StructSelect.struct_items:type_name -> substrait.Expression.MaskExpression.StructItem
	106, // 244: substrait.Expression.MaskExpression.StructItem.child:type_name -> substrait.Expression.MaskExpression.Select
	111, // 245: substrait.Expression.MaskExpression.ListSelect.selection:type_name -> substrait.Expression.MaskExpression.ListSelect.ListSelectItem
	106, // 246: substrait.Expression.MaskExpression.ListSelect.child:type_name -> substrait.Expression.MaskExpression.Select
	114, // 247: substrait.Expression.MaskExpression.MapSelect.key:type_name -> substrait.Expression.MaskExpression.MapSelect.MapKey
	115, // 248: substrait.Expression.MaskExpression.MapSelect.expression:type_name -> substrait.Expression.MaskExpression.MapSelect.MapKeyExpression
	106, // 249: substrait.Expression.MaskExpression.MapSelect.child:type_name -> substrait.Expression.MaskExpression.Select
	112, // 250: substrait.Expression.MaskExpression.ListSelect.ListSelectItem.item:type_name -> substrait.Expression.MaskExpression.ListSelect.ListSelectItem.ListElement
	113, // 251: substrait.Expression.MaskExpression.ListSelect.ListSelectItem.slice:type_name -> substrait.Expression.MaskExpression.ListSelect.ListSelectItem.ListSlice
	30,  // 252: substrait.Expression.Subquery.Scalar.input:type_name -> substrait.Rel
	39,  // 253: substrait.Expression.Subquery.InPredicate.needles:type_name -> substrait.Expression
	30,  // 254: substrait.Expression.Subquery.InPredicate.haystack:type_name -> substrait.Rel
	10,  // 255: substrait.Expression.Subquery.SetPredicate.predicate_op:type_name -> substrait.Expression.Subquery.SetPredicate.PredicateOp
	30,  // 256: substrait.Expression.Subquery.SetPredicate.tuples:type_name -> substrait.Rel
	12,  // 257: substrait.Expression.Subquery.SetComparison.reduction_op:type_name -> substrait.Expression.Subquery.SetComparison.ReductionOp
	11,  // 258: substrait.Expression.Subquery.SetComparison.comparison_op:type_name -> substrait.Expression.Subquery.SetComparison.ComparisonOp
	39,  // 259: substrait.Expression.Subquery.SetComparison.left:type_name -> substrait.Expression
	30,  // 260: substrait.Expression.Subquery.SetComparison.right:type_name -> substrait.Rel
	261, // [261:261] is the sub-list for method output_type
	261, // [261:261] is the sub-list for method input_type
	261, // [261:261] is the sub-list for extension type_name
	261, // [261:261] is the sub-list for extension extendee
	0,   // [0:261] is the sub-list for field type_name
}

func init() { file_substrait_algebra_proto_init() }
func file_substrait_algebra_proto_init() {
	if File_substrait_algebra_proto != nil {
		return
	}
	file_substrait_type_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_substrait_algebra_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelCommon); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProjectRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JoinRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CrossRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregateRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SortRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilterRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExtensionSingleRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExtensionLeafRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExtensionMultiRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExchangeRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelRoot); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamedObjectWrite); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExtensionObject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DdlRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HashJoinRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MergeJoinRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionArgument); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SortField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregateFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelCommon_Direct); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelCommon_Emit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelCommon_Hint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelCommon_Hint_Stats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelCommon_Hint_RuntimeConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRel_NamedTable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRel_VirtualTable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRel_ExtensionTable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRel_LocalFiles); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRel_LocalFiles_FileOrFiles); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRel_LocalFiles_FileOrFiles_ParquetReadOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRel_LocalFiles_FileOrFiles_ArrowReadOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRel_LocalFiles_FileOrFiles_OrcReadOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRel_LocalFiles_FileOrFiles_DwrfReadOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregateRel_Grouping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregateRel_Measure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExchangeRel_ScatterFields); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExchangeRel_SingleBucketExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExchangeRel_MultiBucketExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExchangeRel_Broadcast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExchangeRel_RoundRobin); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExchangeRel_ExchangeTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Enum); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Literal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Nested); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_ScalarFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_WindowFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_IfThen); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Cast); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_SwitchExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_SingularOrList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MultiOrList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_EmbeddedFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_ReferenceSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MaskExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_FieldReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Subquery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Enum_Empty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Literal_VarChar); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Literal_Decimal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Literal_Map); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Literal_IntervalYearToMonth); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Literal_IntervalDayToSecond); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Literal_Struct); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Literal_List); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Literal_UserDefined); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Literal_Map_KeyValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Nested_Map); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Nested_Struct); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Nested_List); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Nested_Map_KeyValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_WindowFunction_Bound); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_WindowFunction_Bound_Preceding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_WindowFunction_Bound_Following); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_WindowFunction_Bound_CurrentRow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_WindowFunction_Bound_Unbounded); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_IfThen_IfClause); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_SwitchExpression_IfValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MultiOrList_Record); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_EmbeddedFunction_PythonPickleFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_EmbeddedFunction_WebAssemblyFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_ReferenceSegment_MapKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_ReferenceSegment_StructField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_ReferenceSegment_ListElement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MaskExpression_Select); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MaskExpression_StructSelect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MaskExpression_StructItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MaskExpression_ListSelect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MaskExpression_MapSelect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MaskExpression_ListSelect_ListSelectItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MaskExpression_ListSelect_ListSelectItem_ListElement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MaskExpression_ListSelect_ListSelectItem_ListSlice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MaskExpression_MapSelect_MapKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_MaskExpression_MapSelect_MapKeyExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_FieldReference_RootReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_FieldReference_OuterReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[103].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Subquery_Scalar); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[104].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Subquery_InPredicate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[105].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Subquery_SetPredicate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[106].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expression_Subquery_SetComparison); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_substrait_algebra_proto_msgTypes[107].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregateFunction_ReferenceRel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_substrait_algebra_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*RelCommon_Direct_)(nil),
		(*RelCommon_Emit_)(nil),
	}
	file_substrait_algebra_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ReadRel_VirtualTable_)(nil),
		(*ReadRel_LocalFiles_)(nil),
		(*ReadRel_NamedTable_)(nil),
		(*ReadRel_ExtensionTable_)(nil),
	}
	file_substrait_algebra_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*ExchangeRel_ScatterByFields)(nil),
		(*ExchangeRel_SingleTarget)(nil),
		(*ExchangeRel_MultiTarget)(nil),
		(*ExchangeRel_RoundRobin_)(nil),
		(*ExchangeRel_Broadcast_)(nil),
	}
	file_substrait_algebra_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*Rel_Read)(nil),
		(*Rel_Filter)(nil),
		(*Rel_Fetch)(nil),
		(*Rel_Aggregate)(nil),
		(*Rel_Sort)(nil),
		(*Rel_Join)(nil),
		(*Rel_Project)(nil),
		(*Rel_Set)(nil),
		(*Rel_ExtensionSingle)(nil),
		(*Rel_ExtensionMulti)(nil),
		(*Rel_ExtensionLeaf)(nil),
		(*Rel_Cross)(nil),
		(*Rel_HashJoin)(nil),
		(*Rel_MergeJoin)(nil),
	}
	file_substrait_algebra_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*DdlRel_NamedObject)(nil),
		(*DdlRel_ExtensionObject)(nil),
	}
	file_substrait_algebra_proto_msgTypes[19].OneofWrappers = []interface{}{
		(*WriteRel_NamedTable)(nil),
		(*WriteRel_ExtensionTable)(nil),
	}
	file_substrait_algebra_proto_msgTypes[22].OneofWrappers = []interface{}{
		(*FunctionArgument_Enum)(nil),
		(*FunctionArgument_Type)(nil),
		(*FunctionArgument_Value)(nil),
	}
	file_substrait_algebra_proto_msgTypes[24].OneofWrappers = []interface{}{
		(*Expression_Literal_)(nil),
		(*Expression_Selection)(nil),
		(*Expression_ScalarFunction_)(nil),
		(*Expression_WindowFunction_)(nil),
		(*Expression_IfThen_)(nil),
		(*Expression_SwitchExpression_)(nil),
		(*Expression_SingularOrList_)(nil),
		(*Expression_MultiOrList_)(nil),
		(*Expression_Cast_)(nil),
		(*Expression_Subquery_)(nil),
		(*Expression_Nested_)(nil),
		(*Expression_Enum_)(nil),
	}
	file_substrait_algebra_proto_msgTypes[25].OneofWrappers = []interface{}{
		(*SortField_Direction)(nil),
		(*SortField_ComparisonFunctionReference)(nil),
	}
	file_substrait_algebra_proto_msgTypes[36].OneofWrappers = []interface{}{
		(*ReadRel_LocalFiles_FileOrFiles_UriPath)(nil),
		(*ReadRel_LocalFiles_FileOrFiles_UriPathGlob)(nil),
		(*ReadRel_LocalFiles_FileOrFiles_UriFile)(nil),
		(*ReadRel_LocalFiles_FileOrFiles_UriFolder)(nil),
		(*ReadRel_LocalFiles_FileOrFiles_Parquet)(nil),
		(*ReadRel_LocalFiles_FileOrFiles_Arrow)(nil),
		(*ReadRel_LocalFiles_FileOrFiles_Orc)(nil),
		(*ReadRel_LocalFiles_FileOrFiles_Extension)(nil),
		(*ReadRel_LocalFiles_FileOrFiles_Dwrf)(nil),
	}
	file_substrait_algebra_proto_msgTypes[48].OneofWrappers = []interface{}{
		(*ExchangeRel_ExchangeTarget_Uri)(nil),
		(*ExchangeRel_ExchangeTarget_Extended)(nil),
	}
	file_substrait_algebra_proto_msgTypes[49].OneofWrappers = []interface{}{
		(*Expression_Enum_Specified)(nil),
		(*Expression_Enum_Unspecified)(nil),
	}
	file_substrait_algebra_proto_msgTypes[50].OneofWrappers = []interface{}{
		(*Expression_Literal_Boolean)(nil),
		(*Expression_Literal_I8)(nil),
		(*Expression_Literal_I16)(nil),
		(*Expression_Literal_I32)(nil),
		(*Expression_Literal_I64)(nil),
		(*Expression_Literal_Fp32)(nil),
		(*Expression_Literal_Fp64)(nil),
		(*Expression_Literal_String_)(nil),
		(*Expression_Literal_Binary)(nil),
		(*Expression_Literal_Timestamp)(nil),
		(*Expression_Literal_Date)(nil),
		(*Expression_Literal_Time)(nil),
		(*Expression_Literal_IntervalYearToMonth_)(nil),
		(*Expression_Literal_IntervalDayToSecond_)(nil),
		(*Expression_Literal_FixedChar)(nil),
		(*Expression_Literal_VarChar_)(nil),
		(*Expression_Literal_FixedBinary)(nil),
		(*Expression_Literal_Decimal_)(nil),
		(*Expression_Literal_Struct_)(nil),
		(*Expression_Literal_Map_)(nil),
		(*Expression_Literal_TimestampTz)(nil),
		(*Expression_Literal_Uuid)(nil),
		(*Expression_Literal_Null)(nil),
		(*Expression_Literal_List_)(nil),
		(*Expression_Literal_EmptyList)(nil),
		(*Expression_Literal_EmptyMap)(nil),
		(*Expression_Literal_UserDefined_)(nil),
	}
	file_substrait_algebra_proto_msgTypes[51].OneofWrappers = []interface{}{
		(*Expression_Nested_Struct_)(nil),
		(*Expression_Nested_List_)(nil),
		(*Expression_Nested_Map_)(nil),
	}
	file_substrait_algebra_proto_msgTypes[59].OneofWrappers = []interface{}{
		(*Expression_EmbeddedFunction_PythonPickleFunction_)(nil),
		(*Expression_EmbeddedFunction_WebAssemblyFunction_)(nil),
	}
	file_substrait_algebra_proto_msgTypes[60].OneofWrappers = []interface{}{
		(*Expression_ReferenceSegment_MapKey_)(nil),
		(*Expression_ReferenceSegment_StructField_)(nil),
		(*Expression_ReferenceSegment_ListElement_)(nil),
	}
	file_substrait_algebra_proto_msgTypes[62].OneofWrappers = []interface{}{
		(*Expression_FieldReference_DirectReference)(nil),
		(*Expression_FieldReference_MaskedReference)(nil),
		(*Expression_FieldReference_Expression)(nil),
		(*Expression_FieldReference_RootReference_)(nil),
		(*Expression_FieldReference_OuterReference_)(nil),
	}
	file_substrait_algebra_proto_msgTypes[63].OneofWrappers = []interface{}{
		(*Expression_Subquery_Scalar_)(nil),
		(*Expression_Subquery_InPredicate_)(nil),
		(*Expression_Subquery_SetPredicate_)(nil),
		(*Expression_Subquery_SetComparison_)(nil),
	}
	file_substrait_algebra_proto_msgTypes[78].OneofWrappers = []interface{}{
		(*Expression_WindowFunction_Bound_Preceding_)(nil),
		(*Expression_WindowFunction_Bound_Following_)(nil),
		(*Expression_WindowFunction_Bound_CurrentRow_)(nil),
		(*Expression_WindowFunction_Bound_Unbounded_)(nil),
	}
	file_substrait_algebra_proto_msgTypes[91].OneofWrappers = []interface{}{
		(*Expression_MaskExpression_Select_Struct)(nil),
		(*Expression_MaskExpression_Select_List)(nil),
		(*Expression_MaskExpression_Select_Map)(nil),
	}
	file_substrait_algebra_proto_msgTypes[95].OneofWrappers = []interface{}{
		(*Expression_MaskExpression_MapSelect_Key)(nil),
		(*Expression_MaskExpression_MapSelect_Expression)(nil),
	}
	file_substrait_algebra_proto_msgTypes[96].OneofWrappers = []interface{}{
		(*Expression_MaskExpression_ListSelect_ListSelectItem_Item)(nil),
		(*Expression_MaskExpression_ListSelect_ListSelectItem_Slice)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_substrait_algebra_proto_rawDesc,
			NumEnums:      15,
			NumMessages:   108,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_substrait_algebra_proto_goTypes,
		DependencyIndexes: file_substrait_algebra_proto_depIdxs,
		EnumInfos:         file_substrait_algebra_proto_enumTypes,
		MessageInfos:      file_substrait_algebra_proto_msgTypes,
	}.Build()
	File_substrait_algebra_proto = out.File
	file_substrait_algebra_proto_rawDesc = nil
	file_substrait_algebra_proto_goTypes = nil
	file_substrait_algebra_proto_depIdxs = nil
}
