// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EnvVar Environment variable model definition
//
// swagger:model envVar
type EnvVar struct {

	// Secret values are only readable by code running on Netlify's systems. With secrets, only the local development context values are readable from the UI, API, and CLI. By default, environment variable values are not secret.
	IsSecret bool `json:"is_secret,omitempty"`

	// The environment variable key, like ALGOLIA_ID (case-sensitive)
	Key string `json:"key,omitempty"`

	// The scopes that this environment variable is set to
	Scopes []string `json:"scopes"`

	// The timestamp of when the value was last updated
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`

	// updated by
	UpdatedBy *EnvVarUser `json:"updated_by,omitempty"`

	// An array of Value objects containing values and metadata
	Values []*EnvVarValue `json:"values"`
}

// Validate validates this env var
func (m *EnvVar) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateScopes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedBy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateValues(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var envVarScopesItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["builds","functions","runtime","post-processing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		envVarScopesItemsEnum = append(envVarScopesItemsEnum, v)
	}
}

func (m *EnvVar) validateScopesItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, envVarScopesItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EnvVar) validateScopes(formats strfmt.Registry) error {

	if swag.IsZero(m.Scopes) { // not required
		return nil
	}

	for i := 0; i < len(m.Scopes); i++ {

		// value enum
		if err := m.validateScopesItemsEnum("scopes"+"."+strconv.Itoa(i), "body", m.Scopes[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *EnvVar) validateUpdatedAt(formats strfmt.Registry) error {

	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *EnvVar) validateUpdatedBy(formats strfmt.Registry) error {

	if swag.IsZero(m.UpdatedBy) { // not required
		return nil
	}

	if m.UpdatedBy != nil {
		if err := m.UpdatedBy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("updated_by")
			}
			return err
		}
	}

	return nil
}

func (m *EnvVar) validateValues(formats strfmt.Registry) error {

	if swag.IsZero(m.Values) { // not required
		return nil
	}

	for i := 0; i < len(m.Values); i++ {
		if swag.IsZero(m.Values[i]) { // not required
			continue
		}

		if m.Values[i] != nil {
			if err := m.Values[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("values" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *EnvVar) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EnvVar) UnmarshalBinary(b []byte) error {
	var res EnvVar
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
