/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;

public class BcPGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private SecureRandom random;
    private boolean withIntegrityPacket;
    private int encAlgorithm;
    private int aeadAlgorithm = -1;
    private int chunkSize;

    public BcPGPDataEncryptorBuilder(int n) {
        this.encAlgorithm = n;
        if (n == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    public BcPGPDataEncryptorBuilder setWithIntegrityPacket(boolean bl) {
        this.withIntegrityPacket = bl;
        return this;
    }

    public BcPGPDataEncryptorBuilder setWithAEAD(int n, int n2) {
        if (this.encAlgorithm != 7 && this.encAlgorithm != 8 && this.encAlgorithm != 9) {
            throw new IllegalStateException("AEAD algorithms can only be used with AES");
        }
        if (n2 < 6) {
            throw new IllegalArgumentException("minimum chunkSize is 6");
        }
        this.aeadAlgorithm = n;
        this.chunkSize = n2 - 6;
        return this;
    }

    public BcPGPDataEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    public PGPDataEncryptor build(byte[] byArray) throws PGPException {
        if (this.aeadAlgorithm > 0) {
            return new MyAeadDataEncryptor(byArray);
        }
        return new MyPGPDataEncryptor(byArray);
    }

    private class MyAeadDataEncryptor
    implements PGPAEADDataEncryptor {
        private final AEADBlockCipher c;
        private final byte[] keyBytes;
        private final byte[] iv;

        MyAeadDataEncryptor(byte[] byArray) throws PGPException {
            this.keyBytes = byArray;
            this.c = BcUtil.createAEADCipher(BcPGPDataEncryptorBuilder.this.encAlgorithm, BcPGPDataEncryptorBuilder.this.aeadAlgorithm);
            this.iv = new byte[AEADEncDataPacket.getIVLength((byte)BcPGPDataEncryptorBuilder.this.aeadAlgorithm)];
            BcPGPDataEncryptorBuilder.this.getSecureRandom().nextBytes(this.iv);
        }

        public OutputStream getOutputStream(OutputStream outputStream) {
            try {
                return new BcUtil.PGPAeadOutputStream(outputStream, this.c, new KeyParameter(this.keyBytes), BcPGPDataEncryptorBuilder.this.encAlgorithm, BcPGPDataEncryptorBuilder.this.aeadAlgorithm, BcPGPDataEncryptorBuilder.this.chunkSize, this.iv);
            }
            catch (Exception exception) {
                throw new IllegalStateException("unable to process stream: " + exception.getMessage());
            }
        }

        public PGPDigestCalculator getIntegrityCalculator() {
            return null;
        }

        public int getBlockSize() {
            return this.c.getUnderlyingCipher().getBlockSize();
        }

        public int getAEADAlgorithm() {
            return BcPGPDataEncryptorBuilder.this.aeadAlgorithm;
        }

        public int getChunkSize() {
            return BcPGPDataEncryptorBuilder.this.chunkSize;
        }

        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final BufferedBlockCipher c;

        MyPGPDataEncryptor(byte[] byArray) throws PGPException {
            BlockCipher blockCipher = BcImplProvider.createBlockCipher(BcPGPDataEncryptorBuilder.this.encAlgorithm);
            try {
                this.c = BcUtil.createStreamCipher(true, blockCipher, BcPGPDataEncryptorBuilder.this.withIntegrityPacket, byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new PGPException("invalid parameters: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }

        public OutputStream getOutputStream(OutputStream outputStream) {
            return new CipherOutputStream(outputStream, this.c);
        }

        public PGPDigestCalculator getIntegrityCalculator() {
            if (BcPGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

