/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket;

import java.util.Collections;
import java.util.List;
import java.util.Queue;
import javax.net.ssl.SSLSession;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModule;
import org.jivesoftware.smack.c2s.StreamOpenAndCloseFactory;
import org.jivesoftware.smack.c2s.XmppClientToServerTransport;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.c2s.internal.WalkStateGraphContext;
import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateTransitionResult;
import org.jivesoftware.smack.packet.AbstractStreamClose;
import org.jivesoftware.smack.packet.AbstractStreamOpen;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;
import org.jivesoftware.smack.websocket.WebSocketConnectionAttemptState;
import org.jivesoftware.smack.websocket.XmppWebSocketTransportModuleDescriptor;
import org.jivesoftware.smack.websocket.elements.WebSocketCloseElement;
import org.jivesoftware.smack.websocket.elements.WebSocketOpenElement;
import org.jivesoftware.smack.websocket.impl.AbstractWebSocket;
import org.jivesoftware.smack.websocket.impl.WebSocketFactory;
import org.jivesoftware.smack.websocket.impl.WebSocketFactoryService;
import org.jivesoftware.smack.websocket.rce.InsecureWebSocketRemoteConnectionEndpoint;
import org.jivesoftware.smack.websocket.rce.SecureWebSocketRemoteConnectionEndpoint;
import org.jivesoftware.smack.websocket.rce.WebSocketRemoteConnectionEndpoint;
import org.jivesoftware.smack.websocket.rce.WebSocketRemoteConnectionEndpointLookup;
import org.jxmpp.jid.DomainBareJid;

public final class XmppWebSocketTransportModule
extends ModularXmppClientToServerConnectionModule<XmppWebSocketTransportModuleDescriptor> {
    private static final int WEBSOCKET_NORMAL_CLOSURE = 1000;
    private static final int[] KNOWN_SECURE_PORTS = new int[]{5443, 5281, 7443};
    private static final int[] KNOWN_INSECURE_PORTS = new int[]{5443, 5280, 7070};
    private final XmppWebSocketTransport websocketTransport;
    private AbstractWebSocket websocket;
    private XmppWebSocketTransport.DiscoveredWebSocketEndpoints discoveredWebSocketEndpoints;

    XmppWebSocketTransportModule(XmppWebSocketTransportModuleDescriptor moduleDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
        super(moduleDescriptor, connectionInternal);
        this.websocketTransport = new XmppWebSocketTransport(connectionInternal);
    }

    @Override
    protected XmppWebSocketTransport getTransport() {
        return this.websocketTransport;
    }

    public EstablishingWebSocketConnectionState constructEstablishingWebSocketConnectionState(EstablishingWebSocketConnectionStateDescriptor establishingWebSocketConnectionStateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
        return new EstablishingWebSocketConnectionState((StateDescriptor)establishingWebSocketConnectionStateDescriptor, connectionInternal);
    }

    public final class XmppWebSocketTransport
    extends XmppClientToServerTransport {
        AsyncButOrdered<Queue<TopLevelStreamElement>> asyncButOrderedOutgoingElementsQueue;

        XmppWebSocketTransport(ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(connectionInternal);
            this.asyncButOrderedOutgoingElementsQueue = new AsyncButOrdered();
        }

        @Override
        protected void resetDiscoveredConnectionEndpoints() {
            XmppWebSocketTransportModule.this.discoveredWebSocketEndpoints = null;
        }

        @Override
        public boolean hasUseableConnectionEndpoints() {
            return XmppWebSocketTransportModule.this.discoveredWebSocketEndpoints != null;
        }

        @Override
        protected List<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>> lookupConnectionEndpoints() {
            assert (XmppWebSocketTransportModule.this.discoveredWebSocketEndpoints == null);
            SmackFuture.InternalSmackFuture websocketEndpointsLookupFuture = new SmackFuture.InternalSmackFuture();
            this.connectionInternal.asyncGo(() -> {
                WebSocketRemoteConnectionEndpoint providedEndpoint;
                WebSocketRemoteConnectionEndpointLookup.Result result = null;
                ModularXmppClientToServerConnectionConfiguration configuration = this.connectionInternal.connection.getConfiguration();
                DomainBareJid host = configuration.getXMPPServiceDomain();
                if (((XmppWebSocketTransportModuleDescriptor)XmppWebSocketTransportModule.this.moduleDescriptor).isWebSocketEndpointDiscoveryEnabled()) {
                    result = WebSocketRemoteConnectionEndpointLookup.lookup(host);
                }
                if ((providedEndpoint = ((XmppWebSocketTransportModuleDescriptor)XmppWebSocketTransportModule.this.moduleDescriptor).getExplicitlyProvidedEndpoint()) != null) {
                    if (result == null) {
                        result = new WebSocketRemoteConnectionEndpointLookup.Result();
                    }
                    boolean INSERT_INDEX = false;
                    if (providedEndpoint instanceof SecureWebSocketRemoteConnectionEndpoint) {
                        SecureWebSocketRemoteConnectionEndpoint secureEndpoint = (SecureWebSocketRemoteConnectionEndpoint)providedEndpoint;
                        result.discoveredSecureEndpoints.add(0, secureEndpoint);
                    } else if (providedEndpoint instanceof InsecureWebSocketRemoteConnectionEndpoint) {
                        InsecureWebSocketRemoteConnectionEndpoint insecureEndpoint = (InsecureWebSocketRemoteConnectionEndpoint)providedEndpoint;
                        result.discoveredInsecureEndpoints.add(0, insecureEndpoint);
                    } else {
                        throw new AssertionError();
                    }
                }
                if (((XmppWebSocketTransportModuleDescriptor)XmppWebSocketTransportModule.this.moduleDescriptor).isImplicitWebSocketEndpointEnabled()) {
                    for (int securePort : KNOWN_SECURE_PORTS) {
                        SecureWebSocketRemoteConnectionEndpoint implicitSecureEndpoint = SecureWebSocketRemoteConnectionEndpoint.from("wss://" + String.valueOf(host) + ":" + securePort + "/ws");
                        result.discoveredSecureEndpoints.add(implicitSecureEndpoint);
                    }
                    for (int insecurePort : KNOWN_INSECURE_PORTS) {
                        InsecureWebSocketRemoteConnectionEndpoint implicitInsecureEndpoint = InsecureWebSocketRemoteConnectionEndpoint.from("ws://" + String.valueOf(host) + ":" + insecurePort + "/ws");
                        result.discoveredInsecureEndpoints.add(implicitInsecureEndpoint);
                    }
                }
                XmppClientToServerTransport.LookupConnectionEndpointsResult endpointsResult = result.isEmpty() ? new WebSocketEndpointsDiscoveryFailed(result.lookupFailures) : new DiscoveredWebSocketEndpoints(result);
                websocketEndpointsLookupFuture.setResult(endpointsResult);
            });
            return Collections.singletonList(websocketEndpointsLookupFuture);
        }

        @Override
        protected void loadConnectionEndpoints(XmppClientToServerTransport.LookupConnectionEndpointsSuccess lookupConnectionEndpointsSuccess) {
            XmppWebSocketTransportModule.this.discoveredWebSocketEndpoints = (DiscoveredWebSocketEndpoints)lookupConnectionEndpointsSuccess;
        }

        @Override
        protected void afterFiltersClosed() {
        }

        @Override
        protected void disconnect() {
            XmppWebSocketTransportModule.this.websocket.disconnect(1000, "WebSocket closed normally");
        }

        @Override
        protected void notifyAboutNewOutgoingElements() {
            Queue<TopLevelStreamElement> outgoingElementsQueue = this.connectionInternal.outgoingElementsQueue;
            this.asyncButOrderedOutgoingElementsQueue.performAsyncButOrdered(outgoingElementsQueue, () -> {
                TopLevelStreamElement topLevelStreamElement;
                while ((topLevelStreamElement = (TopLevelStreamElement)outgoingElementsQueue.poll()) != null) {
                    XmppWebSocketTransportModule.this.websocket.send(topLevelStreamElement);
                    this.connectionInternal.fireFirstLevelElementSendListeners(topLevelStreamElement);
                }
            });
        }

        @Override
        public SSLSession getSslSession() {
            return XmppWebSocketTransportModule.this.websocket.getSSLSession();
        }

        @Override
        public boolean isTransportSecured() {
            return XmppWebSocketTransportModule.this.websocket.isConnectionSecure();
        }

        @Override
        public XmppClientToServerTransport.Stats getStats() {
            return null;
        }

        @Override
        public StreamOpenAndCloseFactory getStreamOpenAndCloseFactory() {
            return new StreamOpenAndCloseFactory(){

                @Override
                public AbstractStreamOpen createStreamOpen(DomainBareJid to, CharSequence from, String id, String lang) {
                    return new WebSocketOpenElement(to);
                }

                @Override
                public AbstractStreamClose createStreamClose() {
                    return new WebSocketCloseElement();
                }
            };
        }

        public final class DiscoveredWebSocketEndpoints
        implements XmppClientToServerTransport.LookupConnectionEndpointsSuccess {
            final WebSocketRemoteConnectionEndpointLookup.Result result;

            DiscoveredWebSocketEndpoints(WebSocketRemoteConnectionEndpointLookup.Result result) {
                assert (result != null);
                this.result = result;
            }
        }

        final class WebSocketEndpointsDiscoveryFailed
        implements XmppClientToServerTransport.LookupConnectionEndpointsFailed {
            final List<RemoteConnectionEndpointLookupFailure> lookupFailures;

            WebSocketEndpointsDiscoveryFailed(RemoteConnectionEndpointLookupFailure lookupFailure) {
                this(Collections.singletonList(lookupFailure));
            }

            WebSocketEndpointsDiscoveryFailed(List<RemoteConnectionEndpointLookupFailure> lookupFailures) {
                assert (lookupFailures != null);
                this.lookupFailures = Collections.unmodifiableList(lookupFailures);
            }

            public String toString() {
                StringBuilder str = new StringBuilder();
                StringUtils.appendTo(this.lookupFailures, str);
                return str.toString();
            }
        }
    }

    final class EstablishingWebSocketConnectionState
    extends State.AbstractTransport {
        EstablishingWebSocketConnectionState(StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(XmppWebSocketTransportModule.this.websocketTransport, stateDescriptor, connectionInternal);
        }

        @Override
        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) throws InterruptedException, SmackException.NoResponseException, SmackException.NotConnectedException, SmackException, XMPPException {
            WebSocketFactory webSocketFactory = ((XmppWebSocketTransportModuleDescriptor)((XmppWebSocketTransportModule)XmppWebSocketTransportModule.this).moduleDescriptor).webSocketFactory != null ? ((XmppWebSocketTransportModuleDescriptor)((XmppWebSocketTransportModule)XmppWebSocketTransportModule.this).moduleDescriptor).webSocketFactory : WebSocketFactoryService::createWebSocket;
            WebSocketConnectionAttemptState connectionAttemptState = new WebSocketConnectionAttemptState(this.connectionInternal, XmppWebSocketTransportModule.this.discoveredWebSocketEndpoints, webSocketFactory);
            StateTransitionResult.Failure failure = connectionAttemptState.establishWebSocketConnection();
            if (failure != null) {
                return failure;
            }
            XmppWebSocketTransportModule.this.websocket = connectionAttemptState.getConnectedWebSocket();
            this.connectionInternal.setTransport(XmppWebSocketTransportModule.this.websocketTransport);
            this.connectionInternal.newStreamOpenWaitForFeaturesSequence("stream features after initial connection");
            return new WebSocketConnectedResult(XmppWebSocketTransportModule.this.websocket.getEndpoint());
        }
    }

    public static final class WebSocketConnectedResult
    extends StateTransitionResult.Success {
        final WebSocketRemoteConnectionEndpoint connectedEndpoint;

        public WebSocketConnectedResult(WebSocketRemoteConnectionEndpoint connectedEndpoint) {
            super("WebSocket connection established with endpoint: " + String.valueOf(connectedEndpoint));
            this.connectedEndpoint = connectedEndpoint;
        }
    }

    static final class EstablishingWebSocketConnectionStateDescriptor
    extends StateDescriptor {
        private EstablishingWebSocketConnectionStateDescriptor() {
            super(EstablishingWebSocketConnectionState.class);
            this.addPredeccessor(ModularXmppClientToServerConnection.LookupRemoteConnectionEndpointsStateDescriptor.class);
            this.addSuccessor(ModularXmppClientToServerConnection.ConnectedButUnauthenticatedStateDescriptor.class);
            this.declareInferiorityTo("org.jivesoftware.smack.tcp.XmppTcpTransportModule$EstablishingTcpConnectionStateDescriptor");
        }

        @Override
        protected State constructState(ModularXmppClientToServerConnectionInternal connectionInternal) {
            XmppWebSocketTransportModule websocketTransportModule = (XmppWebSocketTransportModule)connectionInternal.connection.getConnectionModuleFor(XmppWebSocketTransportModuleDescriptor.class);
            return websocketTransportModule.constructEstablishingWebSocketConnectionState(this, connectionInternal);
        }
    }
}

