/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.workgroup.MetaData;
import org.jivesoftware.smackx.workgroup.QueueUser;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitation;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitationListener;
import org.jivesoftware.smackx.workgroup.agent.Agent;
import org.jivesoftware.smackx.workgroup.agent.AgentRoster;
import org.jivesoftware.smackx.workgroup.agent.Offer;
import org.jivesoftware.smackx.workgroup.agent.OfferListener;
import org.jivesoftware.smackx.workgroup.agent.QueueUsersListener;
import org.jivesoftware.smackx.workgroup.agent.RevokedOffer;
import org.jivesoftware.smackx.workgroup.agent.TranscriptManager;
import org.jivesoftware.smackx.workgroup.agent.TranscriptSearchManager;
import org.jivesoftware.smackx.workgroup.agent.WorkgroupQueue;
import org.jivesoftware.smackx.workgroup.ext.history.AgentChatHistory;
import org.jivesoftware.smackx.workgroup.ext.history.ChatMetadata;
import org.jivesoftware.smackx.workgroup.ext.macros.MacroGroup;
import org.jivesoftware.smackx.workgroup.ext.macros.Macros;
import org.jivesoftware.smackx.workgroup.ext.notes.ChatNotes;
import org.jivesoftware.smackx.workgroup.packet.DepartQueuePacket;
import org.jivesoftware.smackx.workgroup.packet.MonitorPacket;
import org.jivesoftware.smackx.workgroup.packet.OccupantsInfo;
import org.jivesoftware.smackx.workgroup.packet.OfferRequestProvider;
import org.jivesoftware.smackx.workgroup.packet.OfferRevokeProvider;
import org.jivesoftware.smackx.workgroup.packet.QueueDetails;
import org.jivesoftware.smackx.workgroup.packet.QueueOverview;
import org.jivesoftware.smackx.workgroup.packet.RoomInvitation;
import org.jivesoftware.smackx.workgroup.packet.RoomTransfer;
import org.jivesoftware.smackx.workgroup.packet.SessionID;
import org.jivesoftware.smackx.workgroup.packet.Transcript;
import org.jivesoftware.smackx.workgroup.packet.Transcripts;
import org.jivesoftware.smackx.workgroup.settings.GenericSettings;
import org.jivesoftware.smackx.workgroup.settings.SearchSettings;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.Form;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public class AgentSession {
    private static final Logger LOGGER = Logger.getLogger(AgentSession.class.getName());
    private final XMPPConnection connection;
    private final EntityBareJid workgroupJID;
    private boolean online = false;
    private Presence.Mode presenceMode;
    private int maxChats;
    private final Map<String, List<String>> metaData;
    private final Map<Resourcepart, WorkgroupQueue> queues = new HashMap<Resourcepart, WorkgroupQueue>();
    private final List<OfferListener> offerListeners;
    private final List<WorkgroupInvitationListener> invitationListeners;
    private final List<QueueUsersListener> queueUsersListeners;
    private AgentRoster agentRoster = null;
    private final TranscriptManager transcriptManager;
    private final TranscriptSearchManager transcriptSearchManager;
    private final Agent agent;
    private final StanzaListener packetListener;

    public AgentSession(EntityBareJid workgroupJID, XMPPConnection connection) {
        if (!connection.isAuthenticated()) {
            throw new IllegalStateException("Must login to server before creating workgroup.");
        }
        this.workgroupJID = workgroupJID;
        this.connection = connection;
        this.transcriptManager = new TranscriptManager(connection);
        this.transcriptSearchManager = new TranscriptSearchManager(connection);
        this.maxChats = -1;
        this.metaData = new HashMap<String, List<String>>();
        this.offerListeners = new ArrayList<OfferListener>();
        this.invitationListeners = new ArrayList<WorkgroupInvitationListener>();
        this.queueUsersListeners = new ArrayList<QueueUsersListener>();
        OrFilter filter = new OrFilter(new StanzaTypeFilter(Presence.class), new StanzaTypeFilter(Message.class));
        this.packetListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) {
                try {
                    AgentSession.this.handlePacket(packet);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error processing packet", e);
                }
            }
        };
        connection.addAsyncStanzaListener(this.packetListener, filter);
        connection.registerIQRequestHandler(new AbstractIqRequestHandler("offer", "http://jabber.org/protocol/workgroup", IQ.Type.set, IQRequestHandler.Mode.async){

            @Override
            public IQ handleIQRequest(IQ iqRequest) {
                IQ reply = IQ.createResultIQ(iqRequest);
                AgentSession.this.fireOfferRequestEvent((OfferRequestProvider.OfferRequestPacket)iqRequest);
                return reply;
            }
        });
        connection.registerIQRequestHandler(new AbstractIqRequestHandler("offer-revoke", "http://jabber.org/protocol/workgroup", IQ.Type.set, IQRequestHandler.Mode.async){

            @Override
            public IQ handleIQRequest(IQ iqRequest) {
                IQ reply = IQ.createResultIQ(iqRequest);
                AgentSession.this.fireOfferRevokeEvent((OfferRevokeProvider.OfferRevokePacket)iqRequest);
                return reply;
            }
        });
        this.agent = new Agent(connection, workgroupJID);
    }

    public void close() {
        this.connection.removeAsyncStanzaListener(this.packetListener);
    }

    public AgentRoster getAgentRoster() throws SmackException.NotConnectedException, InterruptedException {
        if (this.agentRoster == null) {
            this.agentRoster = new AgentRoster(this.connection, this.workgroupJID);
        }
        for (int elapsed = 0; !this.agentRoster.rosterInitialized && elapsed <= 2000; elapsed += 500) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.agentRoster;
    }

    public Presence.Mode getPresenceMode() {
        return this.presenceMode;
    }

    public int getMaxChats() {
        return this.maxChats;
    }

    public boolean isOnline() {
        return this.online;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaData(String key, String val) throws XMPPException, SmackException, InterruptedException {
        Map<String, List<String>> map = this.metaData;
        synchronized (map) {
            List<String> oldVals = this.metaData.get(key);
            if (oldVals == null || !oldVals.get(0).equals(val)) {
                oldVals.set(0, val);
                this.setStatus(this.presenceMode, this.maxChats);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaData(String key) throws XMPPException, SmackException, InterruptedException {
        Map<String, List<String>> map = this.metaData;
        synchronized (map) {
            List<String> oldVal = this.metaData.remove(key);
            if (oldVal != null) {
                this.setStatus(this.presenceMode, this.maxChats);
            }
        }
    }

    public List<String> getMetaData(String key) {
        return this.metaData.get(key);
    }

    public void setOnline(boolean online) throws XMPPException, SmackException, InterruptedException {
        if (this.online == online) {
            return;
        }
        if (online) {
            Presence presence = ((PresenceBuilder)this.connection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.available).to(this.workgroupJID)).build();
            presence.addExtension(new StandardExtensionElement("agent-status", "http://jabber.org/protocol/workgroup"));
            StanzaCollector collector = this.connection.createStanzaCollectorAndSend(new AndFilter(new StanzaTypeFilter(Presence.class), FromMatchesFilter.create(this.workgroupJID)), presence);
            presence = (Presence)collector.nextResultOrThrow();
        } else {
            Presence presence = ((PresenceBuilder)this.connection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.unavailable).to(this.workgroupJID)).build();
            presence.addExtension(new StandardExtensionElement("agent-status", "http://jabber.org/protocol/workgroup"));
            this.connection.sendStanza(presence);
        }
    }

    public void setStatus(Presence.Mode presenceMode, int maxChats) throws XMPPException, SmackException, InterruptedException {
        this.setStatus(presenceMode, maxChats, null);
    }

    public void setStatus(Presence.Mode presenceMode, int maxChats, String status) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (!this.online) {
            throw new IllegalStateException("Cannot set status when the agent is not online.");
        }
        if (presenceMode == null) {
            presenceMode = Presence.Mode.available;
        }
        this.presenceMode = presenceMode;
        this.maxChats = maxChats;
        PresenceBuilder presenceBuilder = ((PresenceBuilder)this.connection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.available).setMode(presenceMode).to(this.workgroupJID)).setStatus(status);
        StandardExtensionElement.Builder builder = StandardExtensionElement.builder("agent-status", "http://jabber.org/protocol/workgroup");
        builder.addElement("max_chats", Integer.toString(maxChats));
        presenceBuilder.addExtension(builder.build());
        presenceBuilder.addExtension(new MetaData(this.metaData));
        Presence presence = presenceBuilder.build();
        StanzaCollector collector = this.connection.createStanzaCollectorAndSend(new AndFilter(new StanzaTypeFilter(Presence.class), FromMatchesFilter.create(this.workgroupJID)), presence);
        collector.nextResultOrThrow();
    }

    public void setStatus(Presence.Mode presenceMode, String status) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (!this.online) {
            throw new IllegalStateException("Cannot set status when the agent is not online.");
        }
        if (presenceMode == null) {
            presenceMode = Presence.Mode.available;
        }
        this.presenceMode = presenceMode;
        PresenceBuilder presenceBuilder = (PresenceBuilder)this.connection.getStanzaFactory().buildPresenceStanza().ofType(Presence.Type.available).setMode(presenceMode).to(this.getWorkgroupJID());
        if (status != null) {
            presenceBuilder.setStatus(status);
        }
        Presence presence = presenceBuilder.build();
        presence.addExtension(new MetaData(this.metaData));
        StanzaCollector collector = this.connection.createStanzaCollectorAndSend(new AndFilter(new StanzaTypeFilter(Presence.class), FromMatchesFilter.create(this.workgroupJID)), presence);
        collector.nextResultOrThrow();
    }

    public void dequeueUser(EntityJid userID) throws XMPPException, SmackException.NotConnectedException, InterruptedException {
        DepartQueuePacket departPacket = new DepartQueuePacket(this.workgroupJID, userID);
        this.connection.sendStanza(departPacket);
    }

    public Transcripts getTranscripts(Jid userID) throws XMPPException, SmackException, InterruptedException {
        return this.transcriptManager.getTranscripts(this.workgroupJID, userID);
    }

    public Transcript getTranscript(String sessionID) throws XMPPException, SmackException, InterruptedException {
        return this.transcriptManager.getTranscript(this.workgroupJID, sessionID);
    }

    public Form getTranscriptSearchForm() throws XMPPException, SmackException, InterruptedException {
        return this.transcriptSearchManager.getSearchForm(this.workgroupJID.asDomainBareJid());
    }

    public ReportedData searchTranscripts(FillableForm completedForm) throws XMPPException, SmackException, InterruptedException {
        return this.transcriptSearchManager.submitSearch(this.workgroupJID.asDomainBareJid(), completedForm);
    }

    public OccupantsInfo getOccupantsInfo(String roomID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        OccupantsInfo request = new OccupantsInfo(roomID);
        request.setType(IQ.Type.get);
        request.setTo(this.workgroupJID);
        OccupantsInfo response = (OccupantsInfo)this.connection.sendIqRequestAndWaitForResponse(request);
        return response;
    }

    public Jid getWorkgroupJID() {
        return this.workgroupJID;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public WorkgroupQueue getQueue(String queueName) {
        Resourcepart queueNameResourcepart;
        try {
            queueNameResourcepart = Resourcepart.from(queueName);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
        return this.getQueue(queueNameResourcepart);
    }

    public WorkgroupQueue getQueue(Resourcepart queueName) {
        return this.queues.get(queueName);
    }

    public Iterator<WorkgroupQueue> getQueues() {
        return Collections.unmodifiableMap(new HashMap<Resourcepart, WorkgroupQueue>(this.queues)).values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueUsersListener(QueueUsersListener listener) {
        List<QueueUsersListener> list2 = this.queueUsersListeners;
        synchronized (list2) {
            if (!this.queueUsersListeners.contains(listener)) {
                this.queueUsersListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueUsersListener(QueueUsersListener listener) {
        List<QueueUsersListener> list2 = this.queueUsersListeners;
        synchronized (list2) {
            this.queueUsersListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOfferListener(OfferListener offerListener) {
        List<OfferListener> list2 = this.offerListeners;
        synchronized (list2) {
            if (!this.offerListeners.contains(offerListener)) {
                this.offerListeners.add(offerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOfferListener(OfferListener offerListener) {
        List<OfferListener> list2 = this.offerListeners;
        synchronized (list2) {
            this.offerListeners.remove(offerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationListener(WorkgroupInvitationListener invitationListener) {
        List<WorkgroupInvitationListener> list2 = this.invitationListeners;
        synchronized (list2) {
            if (!this.invitationListeners.contains(invitationListener)) {
                this.invitationListeners.add(invitationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationListener(WorkgroupInvitationListener invitationListener) {
        List<WorkgroupInvitationListener> list2 = this.invitationListeners;
        synchronized (list2) {
            this.invitationListeners.remove(invitationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOfferRequestEvent(OfferRequestProvider.OfferRequestPacket requestPacket) {
        Offer offer = new Offer(this.connection, this, requestPacket.getUserID(), requestPacket.getUserJID(), this.getWorkgroupJID(), new Date(new Date().getTime() + (long)requestPacket.getTimeout() * 1000L), requestPacket.getSessionID(), requestPacket.getMetaData(), requestPacket.getContent());
        List<OfferListener> list2 = this.offerListeners;
        synchronized (list2) {
            for (OfferListener listener : this.offerListeners) {
                listener.offerReceived(offer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOfferRevokeEvent(OfferRevokeProvider.OfferRevokePacket orp) {
        RevokedOffer revokedOffer = new RevokedOffer(orp.getUserJID(), orp.getUserID(), this.getWorkgroupJID(), orp.getSessionID(), orp.getReason(), new Date());
        List<OfferListener> list2 = this.offerListeners;
        synchronized (list2) {
            for (OfferListener listener : this.offerListeners) {
                listener.offerRevoked(revokedOffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationEvent(Jid groupChatJID, String sessionID, String body, Jid from, Map<String, List<String>> metaData) {
        WorkgroupInvitation invitation = new WorkgroupInvitation(this.connection.getUser(), groupChatJID, this.workgroupJID, sessionID, body, from, metaData);
        List<WorkgroupInvitationListener> list2 = this.invitationListeners;
        synchronized (list2) {
            for (WorkgroupInvitationListener listener : this.invitationListeners) {
                listener.invitationReceived(invitation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueUsersEvent(WorkgroupQueue queue, WorkgroupQueue.Status status, int averageWaitTime, Date oldestEntry, Set<QueueUser> users) {
        List<QueueUsersListener> list2 = this.queueUsersListeners;
        synchronized (list2) {
            for (QueueUsersListener listener : this.queueUsersListeners) {
                if (status != null) {
                    listener.statusUpdated(queue, status);
                }
                if (averageWaitTime != -1) {
                    listener.averageWaitTimeUpdated(queue, averageWaitTime);
                }
                if (oldestEntry != null) {
                    listener.oldestEntryUpdated(queue, oldestEntry);
                }
                if (users == null) continue;
                listener.usersUpdated(queue, users);
            }
        }
    }

    private void handlePacket(Stanza packet) {
        if (packet instanceof Presence) {
            QueueOverview queueOverview;
            Presence presence = (Presence)packet;
            Resourcepart queueName = presence.getFrom().getResourceOrNull();
            WorkgroupQueue queue = this.queues.get(queueName);
            if (queue == null) {
                queue = new WorkgroupQueue(queueName);
                this.queues.put(queueName, queue);
            }
            if ((queueOverview = (QueueOverview)presence.getExtensionElement(QueueOverview.ELEMENT_NAME, QueueOverview.NAMESPACE)) != null) {
                if (queueOverview.getStatus() == null) {
                    queue.setStatus(WorkgroupQueue.Status.CLOSED);
                } else {
                    queue.setStatus(queueOverview.getStatus());
                }
                queue.setAverageWaitTime(queueOverview.getAverageWaitTime());
                queue.setOldestEntry(queueOverview.getOldestEntry());
                this.fireQueueUsersEvent(queue, queueOverview.getStatus(), queueOverview.getAverageWaitTime(), queueOverview.getOldestEntry(), null);
                return;
            }
            QueueDetails queueDetails = (QueueDetails)packet.getExtensionElement("notify-queue-details", "http://jabber.org/protocol/workgroup");
            if (queueDetails != null) {
                queue.setUsers(queueDetails.getUsers());
                this.fireQueueUsersEvent(queue, null, -1, null, queueDetails.getUsers());
                return;
            }
            StandardExtensionElement notifyAgents = (StandardExtensionElement)presence.getExtensionElement("notify-agents", "http://jabber.org/protocol/workgroup");
            if (notifyAgents != null) {
                int currentChats = Integer.parseInt(notifyAgents.getFirstElement("current-chats", "http://jabber.org/protocol/workgroup").getText());
                int maxChats = Integer.parseInt(notifyAgents.getFirstElement("max-chats", "http://jabber.org/protocol/workgroup").getText());
                queue.setCurrentChats(currentChats);
                queue.setMaxChats(maxChats);
                return;
            }
        } else if (packet instanceof Message) {
            MUCUser.Invite invite;
            Message message = (Message)packet;
            MUCUser mucUser = MUCUser.from(message);
            MUCUser.Invite invite2 = invite = mucUser != null ? mucUser.getInvite() : null;
            if (invite != null && this.workgroupJID.equals(invite.getFrom())) {
                MetaData metaDataExt;
                String sessionID = null;
                Map<String, List<String>> metaData = null;
                SessionID sessionIDExt = (SessionID)message.getExtensionElement("session", "http://jivesoftware.com/protocol/workgroup");
                if (sessionIDExt != null) {
                    sessionID = sessionIDExt.getSessionID();
                }
                if ((metaDataExt = (MetaData)message.getExtensionElement("metadata", "http://jivesoftware.com/protocol/workgroup")) != null) {
                    metaData = metaDataExt.getMetaData();
                }
                this.fireInvitationEvent(message.getFrom(), sessionID, message.getBody(), message.getFrom(), metaData);
            }
        }
    }

    public void setNote(String sessionID, String note) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ChatNotes notes = new ChatNotes();
        notes.setType(IQ.Type.set);
        notes.setTo(this.workgroupJID);
        notes.setSessionID(sessionID);
        notes.setNotes(note);
        this.connection.sendIqRequestAndWaitForResponse(notes);
    }

    public ChatNotes getNote(String sessionID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ChatNotes request = new ChatNotes();
        request.setType(IQ.Type.get);
        request.setTo(this.workgroupJID);
        request.setSessionID(sessionID);
        ChatNotes response = (ChatNotes)this.connection.sendIqRequestAndWaitForResponse(request);
        return response;
    }

    public AgentChatHistory getAgentHistory(EntityBareJid jid, int maxSessions, Date startDate) throws XMPPException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        AgentChatHistory request = startDate != null ? new AgentChatHistory(jid, maxSessions, startDate) : new AgentChatHistory(jid, maxSessions);
        request.setType(IQ.Type.get);
        request.setTo(this.workgroupJID);
        AgentChatHistory response = (AgentChatHistory)this.connection.sendIqRequestAndWaitForResponse(request);
        return response;
    }

    public SearchSettings getSearchSettings() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        SearchSettings request = new SearchSettings();
        request.setType(IQ.Type.get);
        request.setTo(this.workgroupJID);
        SearchSettings response = (SearchSettings)this.connection.sendIqRequestAndWaitForResponse(request);
        return response;
    }

    public MacroGroup getMacros(boolean global) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Macros request = new Macros();
        request.setType(IQ.Type.get);
        request.setTo(this.workgroupJID);
        request.setPersonal(!global);
        Macros response = (Macros)this.connection.sendIqRequestAndWaitForResponse(request);
        return response.getRootGroup();
    }

    public void saveMacros(MacroGroup group2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Macros request = new Macros();
        request.setType(IQ.Type.set);
        request.setTo(this.workgroupJID);
        request.setPersonal(true);
        request.setPersonalMacroGroup(group2);
        this.connection.sendIqRequestAndWaitForResponse(request);
    }

    public Map<String, List<String>> getChatMetadata(String sessionID) throws XMPPException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        ChatMetadata request = new ChatMetadata();
        request.setType(IQ.Type.get);
        request.setTo(this.workgroupJID);
        request.setSessionID(sessionID);
        ChatMetadata response = (ChatMetadata)this.connection.sendIqRequestAndWaitForResponse(request);
        return response.getMetadata();
    }

    public void sendRoomInvitation(RoomInvitation.Type type, Jid invitee, String sessionID, String reason) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        RoomInvitation invitation = new RoomInvitation(type, invitee, sessionID, reason);
        RoomInvitation.RoomInvitationIQ iq = new RoomInvitation.RoomInvitationIQ(invitation);
        iq.setType(IQ.Type.set);
        iq.setTo(this.workgroupJID);
        iq.setFrom(this.connection.getUser());
        this.connection.sendIqRequestAndWaitForResponse(iq);
    }

    public void sendRoomTransfer(RoomTransfer.Type type, String invitee, String sessionID, String reason) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        RoomTransfer transfer = new RoomTransfer(type, invitee, sessionID, reason);
        RoomTransfer.RoomTransferIQ iq = new RoomTransfer.RoomTransferIQ(transfer);
        iq.setType(IQ.Type.set);
        iq.setTo(this.workgroupJID);
        iq.setFrom(this.connection.getUser());
        this.connection.sendIqRequestAndWaitForResponse(iq);
    }

    public GenericSettings getGenericSettings(XMPPConnection con, String query) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        GenericSettings setting = new GenericSettings();
        setting.setType(IQ.Type.get);
        setting.setTo(this.workgroupJID);
        GenericSettings response = (GenericSettings)this.connection.sendIqRequestAndWaitForResponse(setting);
        return response;
    }

    public boolean hasMonitorPrivileges(XMPPConnection con) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MonitorPacket request = new MonitorPacket();
        request.setType(IQ.Type.get);
        request.setTo(this.workgroupJID);
        MonitorPacket response = (MonitorPacket)this.connection.sendIqRequestAndWaitForResponse(request);
        return response.isMonitor();
    }

    public void makeRoomOwner(XMPPConnection con, String sessionID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MonitorPacket request = new MonitorPacket();
        request.setType(IQ.Type.set);
        request.setTo(this.workgroupJID);
        request.setSessionID(sessionID);
        this.connection.sendIqRequestAndWaitForResponse(request);
    }
}

