// Copyright 2009 the Sputnik authors.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
info: Check operator x >>> y in distinct points
es5id: 11.7.3_A4_T3
description: ShiftExpression = 2^n - 1, n = 0...15
---*/

//CHECK
 
if (0 >>> 0 !== 0) { 
  throw new Test262Error('#1: 0 >>> 0 === 0. Actual: ' + (0 >>> 0)); 
} 


if (1 >>> 0 !== 1) { 
  throw new Test262Error('#2: 1 >>> 0 === 1. Actual: ' + (1 >>> 0)); 
} 


if (3 >>> 0 !== 3) { 
  throw new Test262Error('#3: 3 >>> 0 === 3. Actual: ' + (3 >>> 0)); 
} 


if (7 >>> 0 !== 7) { 
  throw new Test262Error('#4: 7 >>> 0 === 7. Actual: ' + (7 >>> 0)); 
} 


if (15 >>> 0 !== 15) { 
  throw new Test262Error('#5: 15 >>> 0 === 15. Actual: ' + (15 >>> 0)); 
} 


if (31 >>> 0 !== 31) { 
  throw new Test262Error('#6: 31 >>> 0 === 31. Actual: ' + (31 >>> 0)); 
} 


if (63 >>> 0 !== 63) { 
  throw new Test262Error('#7: 63 >>> 0 === 63. Actual: ' + (63 >>> 0)); 
} 


if (127 >>> 0 !== 127) { 
  throw new Test262Error('#8: 127 >>> 0 === 127. Actual: ' + (127 >>> 0)); 
} 


if (255 >>> 0 !== 255) { 
  throw new Test262Error('#9: 255 >>> 0 === 255. Actual: ' + (255 >>> 0)); 
} 


if (511 >>> 0 !== 511) { 
  throw new Test262Error('#10: 511 >>> 0 === 511. Actual: ' + (511 >>> 0)); 
} 


if (1023 >>> 0 !== 1023) { 
  throw new Test262Error('#11: 1023 >>> 0 === 1023. Actual: ' + (1023 >>> 0)); 
} 


if (2047 >>> 0 !== 2047) { 
  throw new Test262Error('#12: 2047 >>> 0 === 2047. Actual: ' + (2047 >>> 0)); 
} 


if (4095 >>> 0 !== 4095) { 
  throw new Test262Error('#13: 4095 >>> 0 === 4095. Actual: ' + (4095 >>> 0)); 
} 


if (8191 >>> 0 !== 8191) { 
  throw new Test262Error('#14: 8191 >>> 0 === 8191. Actual: ' + (8191 >>> 0)); 
} 


if (16383 >>> 0 !== 16383) { 
  throw new Test262Error('#15: 16383 >>> 0 === 16383. Actual: ' + (16383 >>> 0)); 
} 


if (32767 >>> 0 !== 32767) { 
  throw new Test262Error('#16: 32767 >>> 0 === 32767. Actual: ' + (32767 >>> 0)); 
} 


if (65535 >>> 0 !== 65535) { 
  throw new Test262Error('#17: 65535 >>> 0 === 65535. Actual: ' + (65535 >>> 0)); 
} 


if (131071 >>> 0 !== 131071) { 
  throw new Test262Error('#18: 131071 >>> 0 === 131071. Actual: ' + (131071 >>> 0)); 
} 


if (262143 >>> 0 !== 262143) { 
  throw new Test262Error('#19: 262143 >>> 0 === 262143. Actual: ' + (262143 >>> 0)); 
} 


if (524287 >>> 0 !== 524287) { 
  throw new Test262Error('#20: 524287 >>> 0 === 524287. Actual: ' + (524287 >>> 0)); 
} 


if (1048575 >>> 0 !== 1048575) { 
  throw new Test262Error('#21: 1048575 >>> 0 === 1048575. Actual: ' + (1048575 >>> 0)); 
} 


if (2097151 >>> 0 !== 2097151) { 
  throw new Test262Error('#22: 2097151 >>> 0 === 2097151. Actual: ' + (2097151 >>> 0)); 
} 


if (4194303 >>> 0 !== 4194303) { 
  throw new Test262Error('#23: 4194303 >>> 0 === 4194303. Actual: ' + (4194303 >>> 0)); 
} 


if (8388607 >>> 0 !== 8388607) { 
  throw new Test262Error('#24: 8388607 >>> 0 === 8388607. Actual: ' + (8388607 >>> 0)); 
} 


if (16777215 >>> 0 !== 16777215) { 
  throw new Test262Error('#25: 16777215 >>> 0 === 16777215. Actual: ' + (16777215 >>> 0)); 
} 


if (33554431 >>> 0 !== 33554431) { 
  throw new Test262Error('#26: 33554431 >>> 0 === 33554431. Actual: ' + (33554431 >>> 0)); 
} 


if (67108863 >>> 0 !== 67108863) { 
  throw new Test262Error('#27: 67108863 >>> 0 === 67108863. Actual: ' + (67108863 >>> 0)); 
} 


if (134217727 >>> 0 !== 134217727) { 
  throw new Test262Error('#28: 134217727 >>> 0 === 134217727. Actual: ' + (134217727 >>> 0)); 
} 


if (268435455 >>> 0 !== 268435455) { 
  throw new Test262Error('#29: 268435455 >>> 0 === 268435455. Actual: ' + (268435455 >>> 0)); 
} 


if (536870911 >>> 0 !== 536870911) { 
  throw new Test262Error('#30: 536870911 >>> 0 === 536870911. Actual: ' + (536870911 >>> 0)); 
} 


if (1073741823 >>> 0 !== 1073741823) { 
  throw new Test262Error('#31: 1073741823 >>> 0 === 1073741823. Actual: ' + (1073741823 >>> 0)); 
} 


if (2147483647 >>> 0 !== 2147483647) { 
  throw new Test262Error('#32: 2147483647 >>> 0 === 2147483647. Actual: ' + (2147483647 >>> 0)); 
} 


if (4294967295 >>> 0 !== 4294967295) { 
  throw new Test262Error('#33: 4294967295 >>> 0 === 4294967295. Actual: ' + (4294967295 >>> 0)); 
} 


if (0 >>> 1 !== 0) { 
  throw new Test262Error('#34: 0 >>> 1 === 0. Actual: ' + (0 >>> 1)); 
} 


if (1 >>> 1 !== 0) { 
  throw new Test262Error('#35: 1 >>> 1 === 0. Actual: ' + (1 >>> 1)); 
} 


if (3 >>> 1 !== 1) { 
  throw new Test262Error('#36: 3 >>> 1 === 1. Actual: ' + (3 >>> 1)); 
} 


if (7 >>> 1 !== 3) { 
  throw new Test262Error('#37: 7 >>> 1 === 3. Actual: ' + (7 >>> 1)); 
} 


if (15 >>> 1 !== 7) { 
  throw new Test262Error('#38: 15 >>> 1 === 7. Actual: ' + (15 >>> 1)); 
} 


if (31 >>> 1 !== 15) { 
  throw new Test262Error('#39: 31 >>> 1 === 15. Actual: ' + (31 >>> 1)); 
} 


if (63 >>> 1 !== 31) { 
  throw new Test262Error('#40: 63 >>> 1 === 31. Actual: ' + (63 >>> 1)); 
} 


if (127 >>> 1 !== 63) { 
  throw new Test262Error('#41: 127 >>> 1 === 63. Actual: ' + (127 >>> 1)); 
} 


if (255 >>> 1 !== 127) { 
  throw new Test262Error('#42: 255 >>> 1 === 127. Actual: ' + (255 >>> 1)); 
} 


if (511 >>> 1 !== 255) { 
  throw new Test262Error('#43: 511 >>> 1 === 255. Actual: ' + (511 >>> 1)); 
} 


if (1023 >>> 1 !== 511) { 
  throw new Test262Error('#44: 1023 >>> 1 === 511. Actual: ' + (1023 >>> 1)); 
} 


if (2047 >>> 1 !== 1023) { 
  throw new Test262Error('#45: 2047 >>> 1 === 1023. Actual: ' + (2047 >>> 1)); 
} 


if (4095 >>> 1 !== 2047) { 
  throw new Test262Error('#46: 4095 >>> 1 === 2047. Actual: ' + (4095 >>> 1)); 
} 


if (8191 >>> 1 !== 4095) { 
  throw new Test262Error('#47: 8191 >>> 1 === 4095. Actual: ' + (8191 >>> 1)); 
} 


if (16383 >>> 1 !== 8191) { 
  throw new Test262Error('#48: 16383 >>> 1 === 8191. Actual: ' + (16383 >>> 1)); 
} 


if (32767 >>> 1 !== 16383) { 
  throw new Test262Error('#49: 32767 >>> 1 === 16383. Actual: ' + (32767 >>> 1)); 
} 


if (65535 >>> 1 !== 32767) { 
  throw new Test262Error('#50: 65535 >>> 1 === 32767. Actual: ' + (65535 >>> 1)); 
} 


if (131071 >>> 1 !== 65535) { 
  throw new Test262Error('#51: 131071 >>> 1 === 65535. Actual: ' + (131071 >>> 1)); 
} 


if (262143 >>> 1 !== 131071) { 
  throw new Test262Error('#52: 262143 >>> 1 === 131071. Actual: ' + (262143 >>> 1)); 
} 


if (524287 >>> 1 !== 262143) { 
  throw new Test262Error('#53: 524287 >>> 1 === 262143. Actual: ' + (524287 >>> 1)); 
} 


if (1048575 >>> 1 !== 524287) { 
  throw new Test262Error('#54: 1048575 >>> 1 === 524287. Actual: ' + (1048575 >>> 1)); 
} 


if (2097151 >>> 1 !== 1048575) { 
  throw new Test262Error('#55: 2097151 >>> 1 === 1048575. Actual: ' + (2097151 >>> 1)); 
} 


if (4194303 >>> 1 !== 2097151) { 
  throw new Test262Error('#56: 4194303 >>> 1 === 2097151. Actual: ' + (4194303 >>> 1)); 
} 


if (8388607 >>> 1 !== 4194303) { 
  throw new Test262Error('#57: 8388607 >>> 1 === 4194303. Actual: ' + (8388607 >>> 1)); 
} 


if (16777215 >>> 1 !== 8388607) { 
  throw new Test262Error('#58: 16777215 >>> 1 === 8388607. Actual: ' + (16777215 >>> 1)); 
} 


if (33554431 >>> 1 !== 16777215) { 
  throw new Test262Error('#59: 33554431 >>> 1 === 16777215. Actual: ' + (33554431 >>> 1)); 
} 


if (67108863 >>> 1 !== 33554431) { 
  throw new Test262Error('#60: 67108863 >>> 1 === 33554431. Actual: ' + (67108863 >>> 1)); 
} 


if (134217727 >>> 1 !== 67108863) { 
  throw new Test262Error('#61: 134217727 >>> 1 === 67108863. Actual: ' + (134217727 >>> 1)); 
} 


if (268435455 >>> 1 !== 134217727) { 
  throw new Test262Error('#62: 268435455 >>> 1 === 134217727. Actual: ' + (268435455 >>> 1)); 
} 


if (536870911 >>> 1 !== 268435455) { 
  throw new Test262Error('#63: 536870911 >>> 1 === 268435455. Actual: ' + (536870911 >>> 1)); 
} 


if (1073741823 >>> 1 !== 536870911) { 
  throw new Test262Error('#64: 1073741823 >>> 1 === 536870911. Actual: ' + (1073741823 >>> 1)); 
} 


if (2147483647 >>> 1 !== 1073741823) { 
  throw new Test262Error('#65: 2147483647 >>> 1 === 1073741823. Actual: ' + (2147483647 >>> 1)); 
} 


if (4294967295 >>> 1 !== 2147483647) { 
  throw new Test262Error('#66: 4294967295 >>> 1 === 2147483647. Actual: ' + (4294967295 >>> 1)); 
} 


if (0 >>> 2 !== 0) { 
  throw new Test262Error('#67: 0 >>> 2 === 0. Actual: ' + (0 >>> 2)); 
} 


if (1 >>> 2 !== 0) { 
  throw new Test262Error('#68: 1 >>> 2 === 0. Actual: ' + (1 >>> 2)); 
} 


if (3 >>> 2 !== 0) { 
  throw new Test262Error('#69: 3 >>> 2 === 0. Actual: ' + (3 >>> 2)); 
} 


if (7 >>> 2 !== 1) { 
  throw new Test262Error('#70: 7 >>> 2 === 1. Actual: ' + (7 >>> 2)); 
} 


if (15 >>> 2 !== 3) { 
  throw new Test262Error('#71: 15 >>> 2 === 3. Actual: ' + (15 >>> 2)); 
} 


if (31 >>> 2 !== 7) { 
  throw new Test262Error('#72: 31 >>> 2 === 7. Actual: ' + (31 >>> 2)); 
} 


if (63 >>> 2 !== 15) { 
  throw new Test262Error('#73: 63 >>> 2 === 15. Actual: ' + (63 >>> 2)); 
} 


if (127 >>> 2 !== 31) { 
  throw new Test262Error('#74: 127 >>> 2 === 31. Actual: ' + (127 >>> 2)); 
} 


if (255 >>> 2 !== 63) { 
  throw new Test262Error('#75: 255 >>> 2 === 63. Actual: ' + (255 >>> 2)); 
} 


if (511 >>> 2 !== 127) { 
  throw new Test262Error('#76: 511 >>> 2 === 127. Actual: ' + (511 >>> 2)); 
} 


if (1023 >>> 2 !== 255) { 
  throw new Test262Error('#77: 1023 >>> 2 === 255. Actual: ' + (1023 >>> 2)); 
} 


if (2047 >>> 2 !== 511) { 
  throw new Test262Error('#78: 2047 >>> 2 === 511. Actual: ' + (2047 >>> 2)); 
} 


if (4095 >>> 2 !== 1023) { 
  throw new Test262Error('#79: 4095 >>> 2 === 1023. Actual: ' + (4095 >>> 2)); 
} 


if (8191 >>> 2 !== 2047) { 
  throw new Test262Error('#80: 8191 >>> 2 === 2047. Actual: ' + (8191 >>> 2)); 
} 


if (16383 >>> 2 !== 4095) { 
  throw new Test262Error('#81: 16383 >>> 2 === 4095. Actual: ' + (16383 >>> 2)); 
} 


if (32767 >>> 2 !== 8191) { 
  throw new Test262Error('#82: 32767 >>> 2 === 8191. Actual: ' + (32767 >>> 2)); 
} 


if (65535 >>> 2 !== 16383) { 
  throw new Test262Error('#83: 65535 >>> 2 === 16383. Actual: ' + (65535 >>> 2)); 
} 


if (131071 >>> 2 !== 32767) { 
  throw new Test262Error('#84: 131071 >>> 2 === 32767. Actual: ' + (131071 >>> 2)); 
} 


if (262143 >>> 2 !== 65535) { 
  throw new Test262Error('#85: 262143 >>> 2 === 65535. Actual: ' + (262143 >>> 2)); 
} 


if (524287 >>> 2 !== 131071) { 
  throw new Test262Error('#86: 524287 >>> 2 === 131071. Actual: ' + (524287 >>> 2)); 
} 


if (1048575 >>> 2 !== 262143) { 
  throw new Test262Error('#87: 1048575 >>> 2 === 262143. Actual: ' + (1048575 >>> 2)); 
} 


if (2097151 >>> 2 !== 524287) { 
  throw new Test262Error('#88: 2097151 >>> 2 === 524287. Actual: ' + (2097151 >>> 2)); 
} 


if (4194303 >>> 2 !== 1048575) { 
  throw new Test262Error('#89: 4194303 >>> 2 === 1048575. Actual: ' + (4194303 >>> 2)); 
} 


if (8388607 >>> 2 !== 2097151) { 
  throw new Test262Error('#90: 8388607 >>> 2 === 2097151. Actual: ' + (8388607 >>> 2)); 
} 


if (16777215 >>> 2 !== 4194303) { 
  throw new Test262Error('#91: 16777215 >>> 2 === 4194303. Actual: ' + (16777215 >>> 2)); 
} 


if (33554431 >>> 2 !== 8388607) { 
  throw new Test262Error('#92: 33554431 >>> 2 === 8388607. Actual: ' + (33554431 >>> 2)); 
} 


if (67108863 >>> 2 !== 16777215) { 
  throw new Test262Error('#93: 67108863 >>> 2 === 16777215. Actual: ' + (67108863 >>> 2)); 
} 


if (134217727 >>> 2 !== 33554431) { 
  throw new Test262Error('#94: 134217727 >>> 2 === 33554431. Actual: ' + (134217727 >>> 2)); 
} 


if (268435455 >>> 2 !== 67108863) { 
  throw new Test262Error('#95: 268435455 >>> 2 === 67108863. Actual: ' + (268435455 >>> 2)); 
} 


if (536870911 >>> 2 !== 134217727) { 
  throw new Test262Error('#96: 536870911 >>> 2 === 134217727. Actual: ' + (536870911 >>> 2)); 
} 


if (1073741823 >>> 2 !== 268435455) { 
  throw new Test262Error('#97: 1073741823 >>> 2 === 268435455. Actual: ' + (1073741823 >>> 2)); 
} 


if (2147483647 >>> 2 !== 536870911) { 
  throw new Test262Error('#98: 2147483647 >>> 2 === 536870911. Actual: ' + (2147483647 >>> 2)); 
} 


if (4294967295 >>> 2 !== 1073741823) { 
  throw new Test262Error('#99: 4294967295 >>> 2 === 1073741823. Actual: ' + (4294967295 >>> 2)); 
} 


if (0 >>> 3 !== 0) { 
  throw new Test262Error('#100: 0 >>> 3 === 0. Actual: ' + (0 >>> 3)); 
} 


if (1 >>> 3 !== 0) { 
  throw new Test262Error('#101: 1 >>> 3 === 0. Actual: ' + (1 >>> 3)); 
} 


if (3 >>> 3 !== 0) { 
  throw new Test262Error('#102: 3 >>> 3 === 0. Actual: ' + (3 >>> 3)); 
} 


if (7 >>> 3 !== 0) { 
  throw new Test262Error('#103: 7 >>> 3 === 0. Actual: ' + (7 >>> 3)); 
} 


if (15 >>> 3 !== 1) { 
  throw new Test262Error('#104: 15 >>> 3 === 1. Actual: ' + (15 >>> 3)); 
} 


if (31 >>> 3 !== 3) { 
  throw new Test262Error('#105: 31 >>> 3 === 3. Actual: ' + (31 >>> 3)); 
} 


if (63 >>> 3 !== 7) { 
  throw new Test262Error('#106: 63 >>> 3 === 7. Actual: ' + (63 >>> 3)); 
} 


if (127 >>> 3 !== 15) { 
  throw new Test262Error('#107: 127 >>> 3 === 15. Actual: ' + (127 >>> 3)); 
} 


if (255 >>> 3 !== 31) { 
  throw new Test262Error('#108: 255 >>> 3 === 31. Actual: ' + (255 >>> 3)); 
} 


if (511 >>> 3 !== 63) { 
  throw new Test262Error('#109: 511 >>> 3 === 63. Actual: ' + (511 >>> 3)); 
} 


if (1023 >>> 3 !== 127) { 
  throw new Test262Error('#110: 1023 >>> 3 === 127. Actual: ' + (1023 >>> 3)); 
} 


if (2047 >>> 3 !== 255) { 
  throw new Test262Error('#111: 2047 >>> 3 === 255. Actual: ' + (2047 >>> 3)); 
} 


if (4095 >>> 3 !== 511) { 
  throw new Test262Error('#112: 4095 >>> 3 === 511. Actual: ' + (4095 >>> 3)); 
} 


if (8191 >>> 3 !== 1023) { 
  throw new Test262Error('#113: 8191 >>> 3 === 1023. Actual: ' + (8191 >>> 3)); 
} 


if (16383 >>> 3 !== 2047) { 
  throw new Test262Error('#114: 16383 >>> 3 === 2047. Actual: ' + (16383 >>> 3)); 
} 


if (32767 >>> 3 !== 4095) { 
  throw new Test262Error('#115: 32767 >>> 3 === 4095. Actual: ' + (32767 >>> 3)); 
} 


if (65535 >>> 3 !== 8191) { 
  throw new Test262Error('#116: 65535 >>> 3 === 8191. Actual: ' + (65535 >>> 3)); 
} 


if (131071 >>> 3 !== 16383) { 
  throw new Test262Error('#117: 131071 >>> 3 === 16383. Actual: ' + (131071 >>> 3)); 
} 


if (262143 >>> 3 !== 32767) { 
  throw new Test262Error('#118: 262143 >>> 3 === 32767. Actual: ' + (262143 >>> 3)); 
} 


if (524287 >>> 3 !== 65535) { 
  throw new Test262Error('#119: 524287 >>> 3 === 65535. Actual: ' + (524287 >>> 3)); 
} 


if (1048575 >>> 3 !== 131071) { 
  throw new Test262Error('#120: 1048575 >>> 3 === 131071. Actual: ' + (1048575 >>> 3)); 
} 


if (2097151 >>> 3 !== 262143) { 
  throw new Test262Error('#121: 2097151 >>> 3 === 262143. Actual: ' + (2097151 >>> 3)); 
} 


if (4194303 >>> 3 !== 524287) { 
  throw new Test262Error('#122: 4194303 >>> 3 === 524287. Actual: ' + (4194303 >>> 3)); 
} 


if (8388607 >>> 3 !== 1048575) { 
  throw new Test262Error('#123: 8388607 >>> 3 === 1048575. Actual: ' + (8388607 >>> 3)); 
} 


if (16777215 >>> 3 !== 2097151) { 
  throw new Test262Error('#124: 16777215 >>> 3 === 2097151. Actual: ' + (16777215 >>> 3)); 
} 


if (33554431 >>> 3 !== 4194303) { 
  throw new Test262Error('#125: 33554431 >>> 3 === 4194303. Actual: ' + (33554431 >>> 3)); 
} 


if (67108863 >>> 3 !== 8388607) { 
  throw new Test262Error('#126: 67108863 >>> 3 === 8388607. Actual: ' + (67108863 >>> 3)); 
} 


if (134217727 >>> 3 !== 16777215) { 
  throw new Test262Error('#127: 134217727 >>> 3 === 16777215. Actual: ' + (134217727 >>> 3)); 
} 


if (268435455 >>> 3 !== 33554431) { 
  throw new Test262Error('#128: 268435455 >>> 3 === 33554431. Actual: ' + (268435455 >>> 3)); 
} 


if (536870911 >>> 3 !== 67108863) { 
  throw new Test262Error('#129: 536870911 >>> 3 === 67108863. Actual: ' + (536870911 >>> 3)); 
} 


if (1073741823 >>> 3 !== 134217727) { 
  throw new Test262Error('#130: 1073741823 >>> 3 === 134217727. Actual: ' + (1073741823 >>> 3)); 
} 


if (2147483647 >>> 3 !== 268435455) { 
  throw new Test262Error('#131: 2147483647 >>> 3 === 268435455. Actual: ' + (2147483647 >>> 3)); 
} 


if (4294967295 >>> 3 !== 536870911) { 
  throw new Test262Error('#132: 4294967295 >>> 3 === 536870911. Actual: ' + (4294967295 >>> 3)); 
} 


if (0 >>> 4 !== 0) { 
  throw new Test262Error('#133: 0 >>> 4 === 0. Actual: ' + (0 >>> 4)); 
} 


if (1 >>> 4 !== 0) { 
  throw new Test262Error('#134: 1 >>> 4 === 0. Actual: ' + (1 >>> 4)); 
} 


if (3 >>> 4 !== 0) { 
  throw new Test262Error('#135: 3 >>> 4 === 0. Actual: ' + (3 >>> 4)); 
} 


if (7 >>> 4 !== 0) { 
  throw new Test262Error('#136: 7 >>> 4 === 0. Actual: ' + (7 >>> 4)); 
} 


if (15 >>> 4 !== 0) { 
  throw new Test262Error('#137: 15 >>> 4 === 0. Actual: ' + (15 >>> 4)); 
} 


if (31 >>> 4 !== 1) { 
  throw new Test262Error('#138: 31 >>> 4 === 1. Actual: ' + (31 >>> 4)); 
} 


if (63 >>> 4 !== 3) { 
  throw new Test262Error('#139: 63 >>> 4 === 3. Actual: ' + (63 >>> 4)); 
} 


if (127 >>> 4 !== 7) { 
  throw new Test262Error('#140: 127 >>> 4 === 7. Actual: ' + (127 >>> 4)); 
} 


if (255 >>> 4 !== 15) { 
  throw new Test262Error('#141: 255 >>> 4 === 15. Actual: ' + (255 >>> 4)); 
} 


if (511 >>> 4 !== 31) { 
  throw new Test262Error('#142: 511 >>> 4 === 31. Actual: ' + (511 >>> 4)); 
} 


if (1023 >>> 4 !== 63) { 
  throw new Test262Error('#143: 1023 >>> 4 === 63. Actual: ' + (1023 >>> 4)); 
} 


if (2047 >>> 4 !== 127) { 
  throw new Test262Error('#144: 2047 >>> 4 === 127. Actual: ' + (2047 >>> 4)); 
} 


if (4095 >>> 4 !== 255) { 
  throw new Test262Error('#145: 4095 >>> 4 === 255. Actual: ' + (4095 >>> 4)); 
} 


if (8191 >>> 4 !== 511) { 
  throw new Test262Error('#146: 8191 >>> 4 === 511. Actual: ' + (8191 >>> 4)); 
} 


if (16383 >>> 4 !== 1023) { 
  throw new Test262Error('#147: 16383 >>> 4 === 1023. Actual: ' + (16383 >>> 4)); 
} 


if (32767 >>> 4 !== 2047) { 
  throw new Test262Error('#148: 32767 >>> 4 === 2047. Actual: ' + (32767 >>> 4)); 
} 


if (65535 >>> 4 !== 4095) { 
  throw new Test262Error('#149: 65535 >>> 4 === 4095. Actual: ' + (65535 >>> 4)); 
} 


if (131071 >>> 4 !== 8191) { 
  throw new Test262Error('#150: 131071 >>> 4 === 8191. Actual: ' + (131071 >>> 4)); 
} 


if (262143 >>> 4 !== 16383) { 
  throw new Test262Error('#151: 262143 >>> 4 === 16383. Actual: ' + (262143 >>> 4)); 
} 


if (524287 >>> 4 !== 32767) { 
  throw new Test262Error('#152: 524287 >>> 4 === 32767. Actual: ' + (524287 >>> 4)); 
} 


if (1048575 >>> 4 !== 65535) { 
  throw new Test262Error('#153: 1048575 >>> 4 === 65535. Actual: ' + (1048575 >>> 4)); 
} 


if (2097151 >>> 4 !== 131071) { 
  throw new Test262Error('#154: 2097151 >>> 4 === 131071. Actual: ' + (2097151 >>> 4)); 
} 


if (4194303 >>> 4 !== 262143) { 
  throw new Test262Error('#155: 4194303 >>> 4 === 262143. Actual: ' + (4194303 >>> 4)); 
} 


if (8388607 >>> 4 !== 524287) { 
  throw new Test262Error('#156: 8388607 >>> 4 === 524287. Actual: ' + (8388607 >>> 4)); 
} 


if (16777215 >>> 4 !== 1048575) { 
  throw new Test262Error('#157: 16777215 >>> 4 === 1048575. Actual: ' + (16777215 >>> 4)); 
} 


if (33554431 >>> 4 !== 2097151) { 
  throw new Test262Error('#158: 33554431 >>> 4 === 2097151. Actual: ' + (33554431 >>> 4)); 
} 


if (67108863 >>> 4 !== 4194303) { 
  throw new Test262Error('#159: 67108863 >>> 4 === 4194303. Actual: ' + (67108863 >>> 4)); 
} 


if (134217727 >>> 4 !== 8388607) { 
  throw new Test262Error('#160: 134217727 >>> 4 === 8388607. Actual: ' + (134217727 >>> 4)); 
} 


if (268435455 >>> 4 !== 16777215) { 
  throw new Test262Error('#161: 268435455 >>> 4 === 16777215. Actual: ' + (268435455 >>> 4)); 
} 


if (536870911 >>> 4 !== 33554431) { 
  throw new Test262Error('#162: 536870911 >>> 4 === 33554431. Actual: ' + (536870911 >>> 4)); 
} 


if (1073741823 >>> 4 !== 67108863) { 
  throw new Test262Error('#163: 1073741823 >>> 4 === 67108863. Actual: ' + (1073741823 >>> 4)); 
} 


if (2147483647 >>> 4 !== 134217727) { 
  throw new Test262Error('#164: 2147483647 >>> 4 === 134217727. Actual: ' + (2147483647 >>> 4)); 
} 


if (4294967295 >>> 4 !== 268435455) { 
  throw new Test262Error('#165: 4294967295 >>> 4 === 268435455. Actual: ' + (4294967295 >>> 4)); 
} 


if (0 >>> 5 !== 0) { 
  throw new Test262Error('#166: 0 >>> 5 === 0. Actual: ' + (0 >>> 5)); 
} 


if (1 >>> 5 !== 0) { 
  throw new Test262Error('#167: 1 >>> 5 === 0. Actual: ' + (1 >>> 5)); 
} 


if (3 >>> 5 !== 0) { 
  throw new Test262Error('#168: 3 >>> 5 === 0. Actual: ' + (3 >>> 5)); 
} 


if (7 >>> 5 !== 0) { 
  throw new Test262Error('#169: 7 >>> 5 === 0. Actual: ' + (7 >>> 5)); 
} 


if (15 >>> 5 !== 0) { 
  throw new Test262Error('#170: 15 >>> 5 === 0. Actual: ' + (15 >>> 5)); 
} 


if (31 >>> 5 !== 0) { 
  throw new Test262Error('#171: 31 >>> 5 === 0. Actual: ' + (31 >>> 5)); 
} 


if (63 >>> 5 !== 1) { 
  throw new Test262Error('#172: 63 >>> 5 === 1. Actual: ' + (63 >>> 5)); 
} 


if (127 >>> 5 !== 3) { 
  throw new Test262Error('#173: 127 >>> 5 === 3. Actual: ' + (127 >>> 5)); 
} 


if (255 >>> 5 !== 7) { 
  throw new Test262Error('#174: 255 >>> 5 === 7. Actual: ' + (255 >>> 5)); 
} 


if (511 >>> 5 !== 15) { 
  throw new Test262Error('#175: 511 >>> 5 === 15. Actual: ' + (511 >>> 5)); 
} 


if (1023 >>> 5 !== 31) { 
  throw new Test262Error('#176: 1023 >>> 5 === 31. Actual: ' + (1023 >>> 5)); 
} 


if (2047 >>> 5 !== 63) { 
  throw new Test262Error('#177: 2047 >>> 5 === 63. Actual: ' + (2047 >>> 5)); 
} 


if (4095 >>> 5 !== 127) { 
  throw new Test262Error('#178: 4095 >>> 5 === 127. Actual: ' + (4095 >>> 5)); 
} 


if (8191 >>> 5 !== 255) { 
  throw new Test262Error('#179: 8191 >>> 5 === 255. Actual: ' + (8191 >>> 5)); 
} 


if (16383 >>> 5 !== 511) { 
  throw new Test262Error('#180: 16383 >>> 5 === 511. Actual: ' + (16383 >>> 5)); 
} 


if (32767 >>> 5 !== 1023) { 
  throw new Test262Error('#181: 32767 >>> 5 === 1023. Actual: ' + (32767 >>> 5)); 
} 


if (65535 >>> 5 !== 2047) { 
  throw new Test262Error('#182: 65535 >>> 5 === 2047. Actual: ' + (65535 >>> 5)); 
} 


if (131071 >>> 5 !== 4095) { 
  throw new Test262Error('#183: 131071 >>> 5 === 4095. Actual: ' + (131071 >>> 5)); 
} 


if (262143 >>> 5 !== 8191) { 
  throw new Test262Error('#184: 262143 >>> 5 === 8191. Actual: ' + (262143 >>> 5)); 
} 


if (524287 >>> 5 !== 16383) { 
  throw new Test262Error('#185: 524287 >>> 5 === 16383. Actual: ' + (524287 >>> 5)); 
} 


if (1048575 >>> 5 !== 32767) { 
  throw new Test262Error('#186: 1048575 >>> 5 === 32767. Actual: ' + (1048575 >>> 5)); 
} 


if (2097151 >>> 5 !== 65535) { 
  throw new Test262Error('#187: 2097151 >>> 5 === 65535. Actual: ' + (2097151 >>> 5)); 
} 


if (4194303 >>> 5 !== 131071) { 
  throw new Test262Error('#188: 4194303 >>> 5 === 131071. Actual: ' + (4194303 >>> 5)); 
} 


if (8388607 >>> 5 !== 262143) { 
  throw new Test262Error('#189: 8388607 >>> 5 === 262143. Actual: ' + (8388607 >>> 5)); 
} 


if (16777215 >>> 5 !== 524287) { 
  throw new Test262Error('#190: 16777215 >>> 5 === 524287. Actual: ' + (16777215 >>> 5)); 
} 


if (33554431 >>> 5 !== 1048575) { 
  throw new Test262Error('#191: 33554431 >>> 5 === 1048575. Actual: ' + (33554431 >>> 5)); 
} 


if (67108863 >>> 5 !== 2097151) { 
  throw new Test262Error('#192: 67108863 >>> 5 === 2097151. Actual: ' + (67108863 >>> 5)); 
} 


if (134217727 >>> 5 !== 4194303) { 
  throw new Test262Error('#193: 134217727 >>> 5 === 4194303. Actual: ' + (134217727 >>> 5)); 
} 


if (268435455 >>> 5 !== 8388607) { 
  throw new Test262Error('#194: 268435455 >>> 5 === 8388607. Actual: ' + (268435455 >>> 5)); 
} 


if (536870911 >>> 5 !== 16777215) { 
  throw new Test262Error('#195: 536870911 >>> 5 === 16777215. Actual: ' + (536870911 >>> 5)); 
} 


if (1073741823 >>> 5 !== 33554431) { 
  throw new Test262Error('#196: 1073741823 >>> 5 === 33554431. Actual: ' + (1073741823 >>> 5)); 
} 


if (2147483647 >>> 5 !== 67108863) { 
  throw new Test262Error('#197: 2147483647 >>> 5 === 67108863. Actual: ' + (2147483647 >>> 5)); 
} 


if (4294967295 >>> 5 !== 134217727) { 
  throw new Test262Error('#198: 4294967295 >>> 5 === 134217727. Actual: ' + (4294967295 >>> 5)); 
} 


if (0 >>> 6 !== 0) { 
  throw new Test262Error('#199: 0 >>> 6 === 0. Actual: ' + (0 >>> 6)); 
} 


if (1 >>> 6 !== 0) { 
  throw new Test262Error('#200: 1 >>> 6 === 0. Actual: ' + (1 >>> 6)); 
} 


if (3 >>> 6 !== 0) { 
  throw new Test262Error('#201: 3 >>> 6 === 0. Actual: ' + (3 >>> 6)); 
} 


if (7 >>> 6 !== 0) { 
  throw new Test262Error('#202: 7 >>> 6 === 0. Actual: ' + (7 >>> 6)); 
} 


if (15 >>> 6 !== 0) { 
  throw new Test262Error('#203: 15 >>> 6 === 0. Actual: ' + (15 >>> 6)); 
} 


if (31 >>> 6 !== 0) { 
  throw new Test262Error('#204: 31 >>> 6 === 0. Actual: ' + (31 >>> 6)); 
} 


if (63 >>> 6 !== 0) { 
  throw new Test262Error('#205: 63 >>> 6 === 0. Actual: ' + (63 >>> 6)); 
} 


if (127 >>> 6 !== 1) { 
  throw new Test262Error('#206: 127 >>> 6 === 1. Actual: ' + (127 >>> 6)); 
} 


if (255 >>> 6 !== 3) { 
  throw new Test262Error('#207: 255 >>> 6 === 3. Actual: ' + (255 >>> 6)); 
} 


if (511 >>> 6 !== 7) { 
  throw new Test262Error('#208: 511 >>> 6 === 7. Actual: ' + (511 >>> 6)); 
} 


if (1023 >>> 6 !== 15) { 
  throw new Test262Error('#209: 1023 >>> 6 === 15. Actual: ' + (1023 >>> 6)); 
} 


if (2047 >>> 6 !== 31) { 
  throw new Test262Error('#210: 2047 >>> 6 === 31. Actual: ' + (2047 >>> 6)); 
} 


if (4095 >>> 6 !== 63) { 
  throw new Test262Error('#211: 4095 >>> 6 === 63. Actual: ' + (4095 >>> 6)); 
} 


if (8191 >>> 6 !== 127) { 
  throw new Test262Error('#212: 8191 >>> 6 === 127. Actual: ' + (8191 >>> 6)); 
} 


if (16383 >>> 6 !== 255) { 
  throw new Test262Error('#213: 16383 >>> 6 === 255. Actual: ' + (16383 >>> 6)); 
} 


if (32767 >>> 6 !== 511) { 
  throw new Test262Error('#214: 32767 >>> 6 === 511. Actual: ' + (32767 >>> 6)); 
} 


if (65535 >>> 6 !== 1023) { 
  throw new Test262Error('#215: 65535 >>> 6 === 1023. Actual: ' + (65535 >>> 6)); 
} 


if (131071 >>> 6 !== 2047) { 
  throw new Test262Error('#216: 131071 >>> 6 === 2047. Actual: ' + (131071 >>> 6)); 
} 


if (262143 >>> 6 !== 4095) { 
  throw new Test262Error('#217: 262143 >>> 6 === 4095. Actual: ' + (262143 >>> 6)); 
} 


if (524287 >>> 6 !== 8191) { 
  throw new Test262Error('#218: 524287 >>> 6 === 8191. Actual: ' + (524287 >>> 6)); 
} 


if (1048575 >>> 6 !== 16383) { 
  throw new Test262Error('#219: 1048575 >>> 6 === 16383. Actual: ' + (1048575 >>> 6)); 
} 


if (2097151 >>> 6 !== 32767) { 
  throw new Test262Error('#220: 2097151 >>> 6 === 32767. Actual: ' + (2097151 >>> 6)); 
} 


if (4194303 >>> 6 !== 65535) { 
  throw new Test262Error('#221: 4194303 >>> 6 === 65535. Actual: ' + (4194303 >>> 6)); 
} 


if (8388607 >>> 6 !== 131071) { 
  throw new Test262Error('#222: 8388607 >>> 6 === 131071. Actual: ' + (8388607 >>> 6)); 
} 


if (16777215 >>> 6 !== 262143) { 
  throw new Test262Error('#223: 16777215 >>> 6 === 262143. Actual: ' + (16777215 >>> 6)); 
} 


if (33554431 >>> 6 !== 524287) { 
  throw new Test262Error('#224: 33554431 >>> 6 === 524287. Actual: ' + (33554431 >>> 6)); 
} 


if (67108863 >>> 6 !== 1048575) { 
  throw new Test262Error('#225: 67108863 >>> 6 === 1048575. Actual: ' + (67108863 >>> 6)); 
} 


if (134217727 >>> 6 !== 2097151) { 
  throw new Test262Error('#226: 134217727 >>> 6 === 2097151. Actual: ' + (134217727 >>> 6)); 
} 


if (268435455 >>> 6 !== 4194303) { 
  throw new Test262Error('#227: 268435455 >>> 6 === 4194303. Actual: ' + (268435455 >>> 6)); 
} 


if (536870911 >>> 6 !== 8388607) { 
  throw new Test262Error('#228: 536870911 >>> 6 === 8388607. Actual: ' + (536870911 >>> 6)); 
} 


if (1073741823 >>> 6 !== 16777215) { 
  throw new Test262Error('#229: 1073741823 >>> 6 === 16777215. Actual: ' + (1073741823 >>> 6)); 
} 


if (2147483647 >>> 6 !== 33554431) { 
  throw new Test262Error('#230: 2147483647 >>> 6 === 33554431. Actual: ' + (2147483647 >>> 6)); 
} 


if (4294967295 >>> 6 !== 67108863) { 
  throw new Test262Error('#231: 4294967295 >>> 6 === 67108863. Actual: ' + (4294967295 >>> 6)); 
} 


if (0 >>> 7 !== 0) { 
  throw new Test262Error('#232: 0 >>> 7 === 0. Actual: ' + (0 >>> 7)); 
} 


if (1 >>> 7 !== 0) { 
  throw new Test262Error('#233: 1 >>> 7 === 0. Actual: ' + (1 >>> 7)); 
} 


if (3 >>> 7 !== 0) { 
  throw new Test262Error('#234: 3 >>> 7 === 0. Actual: ' + (3 >>> 7)); 
} 


if (7 >>> 7 !== 0) { 
  throw new Test262Error('#235: 7 >>> 7 === 0. Actual: ' + (7 >>> 7)); 
} 


if (15 >>> 7 !== 0) { 
  throw new Test262Error('#236: 15 >>> 7 === 0. Actual: ' + (15 >>> 7)); 
} 


if (31 >>> 7 !== 0) { 
  throw new Test262Error('#237: 31 >>> 7 === 0. Actual: ' + (31 >>> 7)); 
} 


if (63 >>> 7 !== 0) { 
  throw new Test262Error('#238: 63 >>> 7 === 0. Actual: ' + (63 >>> 7)); 
} 


if (127 >>> 7 !== 0) { 
  throw new Test262Error('#239: 127 >>> 7 === 0. Actual: ' + (127 >>> 7)); 
} 


if (255 >>> 7 !== 1) { 
  throw new Test262Error('#240: 255 >>> 7 === 1. Actual: ' + (255 >>> 7)); 
} 


if (511 >>> 7 !== 3) { 
  throw new Test262Error('#241: 511 >>> 7 === 3. Actual: ' + (511 >>> 7)); 
} 


if (1023 >>> 7 !== 7) { 
  throw new Test262Error('#242: 1023 >>> 7 === 7. Actual: ' + (1023 >>> 7)); 
} 


if (2047 >>> 7 !== 15) { 
  throw new Test262Error('#243: 2047 >>> 7 === 15. Actual: ' + (2047 >>> 7)); 
} 


if (4095 >>> 7 !== 31) { 
  throw new Test262Error('#244: 4095 >>> 7 === 31. Actual: ' + (4095 >>> 7)); 
} 


if (8191 >>> 7 !== 63) { 
  throw new Test262Error('#245: 8191 >>> 7 === 63. Actual: ' + (8191 >>> 7)); 
} 


if (16383 >>> 7 !== 127) { 
  throw new Test262Error('#246: 16383 >>> 7 === 127. Actual: ' + (16383 >>> 7)); 
} 


if (32767 >>> 7 !== 255) { 
  throw new Test262Error('#247: 32767 >>> 7 === 255. Actual: ' + (32767 >>> 7)); 
} 


if (65535 >>> 7 !== 511) { 
  throw new Test262Error('#248: 65535 >>> 7 === 511. Actual: ' + (65535 >>> 7)); 
} 


if (131071 >>> 7 !== 1023) { 
  throw new Test262Error('#249: 131071 >>> 7 === 1023. Actual: ' + (131071 >>> 7)); 
} 


if (262143 >>> 7 !== 2047) { 
  throw new Test262Error('#250: 262143 >>> 7 === 2047. Actual: ' + (262143 >>> 7)); 
} 


if (524287 >>> 7 !== 4095) { 
  throw new Test262Error('#251: 524287 >>> 7 === 4095. Actual: ' + (524287 >>> 7)); 
} 


if (1048575 >>> 7 !== 8191) { 
  throw new Test262Error('#252: 1048575 >>> 7 === 8191. Actual: ' + (1048575 >>> 7)); 
} 


if (2097151 >>> 7 !== 16383) { 
  throw new Test262Error('#253: 2097151 >>> 7 === 16383. Actual: ' + (2097151 >>> 7)); 
} 


if (4194303 >>> 7 !== 32767) { 
  throw new Test262Error('#254: 4194303 >>> 7 === 32767. Actual: ' + (4194303 >>> 7)); 
} 


if (8388607 >>> 7 !== 65535) { 
  throw new Test262Error('#255: 8388607 >>> 7 === 65535. Actual: ' + (8388607 >>> 7)); 
} 


if (16777215 >>> 7 !== 131071) { 
  throw new Test262Error('#256: 16777215 >>> 7 === 131071. Actual: ' + (16777215 >>> 7)); 
} 


if (33554431 >>> 7 !== 262143) { 
  throw new Test262Error('#257: 33554431 >>> 7 === 262143. Actual: ' + (33554431 >>> 7)); 
} 


if (67108863 >>> 7 !== 524287) { 
  throw new Test262Error('#258: 67108863 >>> 7 === 524287. Actual: ' + (67108863 >>> 7)); 
} 


if (134217727 >>> 7 !== 1048575) { 
  throw new Test262Error('#259: 134217727 >>> 7 === 1048575. Actual: ' + (134217727 >>> 7)); 
} 


if (268435455 >>> 7 !== 2097151) { 
  throw new Test262Error('#260: 268435455 >>> 7 === 2097151. Actual: ' + (268435455 >>> 7)); 
} 


if (536870911 >>> 7 !== 4194303) { 
  throw new Test262Error('#261: 536870911 >>> 7 === 4194303. Actual: ' + (536870911 >>> 7)); 
} 


if (1073741823 >>> 7 !== 8388607) { 
  throw new Test262Error('#262: 1073741823 >>> 7 === 8388607. Actual: ' + (1073741823 >>> 7)); 
} 


if (2147483647 >>> 7 !== 16777215) { 
  throw new Test262Error('#263: 2147483647 >>> 7 === 16777215. Actual: ' + (2147483647 >>> 7)); 
} 


if (4294967295 >>> 7 !== 33554431) { 
  throw new Test262Error('#264: 4294967295 >>> 7 === 33554431. Actual: ' + (4294967295 >>> 7)); 
} 


if (0 >>> 8 !== 0) { 
  throw new Test262Error('#265: 0 >>> 8 === 0. Actual: ' + (0 >>> 8)); 
} 


if (1 >>> 8 !== 0) { 
  throw new Test262Error('#266: 1 >>> 8 === 0. Actual: ' + (1 >>> 8)); 
} 


if (3 >>> 8 !== 0) { 
  throw new Test262Error('#267: 3 >>> 8 === 0. Actual: ' + (3 >>> 8)); 
} 


if (7 >>> 8 !== 0) { 
  throw new Test262Error('#268: 7 >>> 8 === 0. Actual: ' + (7 >>> 8)); 
} 


if (15 >>> 8 !== 0) { 
  throw new Test262Error('#269: 15 >>> 8 === 0. Actual: ' + (15 >>> 8)); 
} 


if (31 >>> 8 !== 0) { 
  throw new Test262Error('#270: 31 >>> 8 === 0. Actual: ' + (31 >>> 8)); 
} 


if (63 >>> 8 !== 0) { 
  throw new Test262Error('#271: 63 >>> 8 === 0. Actual: ' + (63 >>> 8)); 
} 


if (127 >>> 8 !== 0) { 
  throw new Test262Error('#272: 127 >>> 8 === 0. Actual: ' + (127 >>> 8)); 
} 


if (255 >>> 8 !== 0) { 
  throw new Test262Error('#273: 255 >>> 8 === 0. Actual: ' + (255 >>> 8)); 
} 


if (511 >>> 8 !== 1) { 
  throw new Test262Error('#274: 511 >>> 8 === 1. Actual: ' + (511 >>> 8)); 
} 


if (1023 >>> 8 !== 3) { 
  throw new Test262Error('#275: 1023 >>> 8 === 3. Actual: ' + (1023 >>> 8)); 
} 


if (2047 >>> 8 !== 7) { 
  throw new Test262Error('#276: 2047 >>> 8 === 7. Actual: ' + (2047 >>> 8)); 
} 


if (4095 >>> 8 !== 15) { 
  throw new Test262Error('#277: 4095 >>> 8 === 15. Actual: ' + (4095 >>> 8)); 
} 


if (8191 >>> 8 !== 31) { 
  throw new Test262Error('#278: 8191 >>> 8 === 31. Actual: ' + (8191 >>> 8)); 
} 


if (16383 >>> 8 !== 63) { 
  throw new Test262Error('#279: 16383 >>> 8 === 63. Actual: ' + (16383 >>> 8)); 
} 


if (32767 >>> 8 !== 127) { 
  throw new Test262Error('#280: 32767 >>> 8 === 127. Actual: ' + (32767 >>> 8)); 
} 


if (65535 >>> 8 !== 255) { 
  throw new Test262Error('#281: 65535 >>> 8 === 255. Actual: ' + (65535 >>> 8)); 
} 


if (131071 >>> 8 !== 511) { 
  throw new Test262Error('#282: 131071 >>> 8 === 511. Actual: ' + (131071 >>> 8)); 
} 


if (262143 >>> 8 !== 1023) { 
  throw new Test262Error('#283: 262143 >>> 8 === 1023. Actual: ' + (262143 >>> 8)); 
} 


if (524287 >>> 8 !== 2047) { 
  throw new Test262Error('#284: 524287 >>> 8 === 2047. Actual: ' + (524287 >>> 8)); 
} 


if (1048575 >>> 8 !== 4095) { 
  throw new Test262Error('#285: 1048575 >>> 8 === 4095. Actual: ' + (1048575 >>> 8)); 
} 


if (2097151 >>> 8 !== 8191) { 
  throw new Test262Error('#286: 2097151 >>> 8 === 8191. Actual: ' + (2097151 >>> 8)); 
} 


if (4194303 >>> 8 !== 16383) { 
  throw new Test262Error('#287: 4194303 >>> 8 === 16383. Actual: ' + (4194303 >>> 8)); 
} 


if (8388607 >>> 8 !== 32767) { 
  throw new Test262Error('#288: 8388607 >>> 8 === 32767. Actual: ' + (8388607 >>> 8)); 
} 


if (16777215 >>> 8 !== 65535) { 
  throw new Test262Error('#289: 16777215 >>> 8 === 65535. Actual: ' + (16777215 >>> 8)); 
} 


if (33554431 >>> 8 !== 131071) { 
  throw new Test262Error('#290: 33554431 >>> 8 === 131071. Actual: ' + (33554431 >>> 8)); 
} 


if (67108863 >>> 8 !== 262143) { 
  throw new Test262Error('#291: 67108863 >>> 8 === 262143. Actual: ' + (67108863 >>> 8)); 
} 


if (134217727 >>> 8 !== 524287) { 
  throw new Test262Error('#292: 134217727 >>> 8 === 524287. Actual: ' + (134217727 >>> 8)); 
} 


if (268435455 >>> 8 !== 1048575) { 
  throw new Test262Error('#293: 268435455 >>> 8 === 1048575. Actual: ' + (268435455 >>> 8)); 
} 


if (536870911 >>> 8 !== 2097151) { 
  throw new Test262Error('#294: 536870911 >>> 8 === 2097151. Actual: ' + (536870911 >>> 8)); 
} 


if (1073741823 >>> 8 !== 4194303) { 
  throw new Test262Error('#295: 1073741823 >>> 8 === 4194303. Actual: ' + (1073741823 >>> 8)); 
} 


if (2147483647 >>> 8 !== 8388607) { 
  throw new Test262Error('#296: 2147483647 >>> 8 === 8388607. Actual: ' + (2147483647 >>> 8)); 
} 


if (4294967295 >>> 8 !== 16777215) { 
  throw new Test262Error('#297: 4294967295 >>> 8 === 16777215. Actual: ' + (4294967295 >>> 8)); 
} 


if (0 >>> 9 !== 0) { 
  throw new Test262Error('#298: 0 >>> 9 === 0. Actual: ' + (0 >>> 9)); 
} 


if (1 >>> 9 !== 0) { 
  throw new Test262Error('#299: 1 >>> 9 === 0. Actual: ' + (1 >>> 9)); 
} 


if (3 >>> 9 !== 0) { 
  throw new Test262Error('#300: 3 >>> 9 === 0. Actual: ' + (3 >>> 9)); 
} 


if (7 >>> 9 !== 0) { 
  throw new Test262Error('#301: 7 >>> 9 === 0. Actual: ' + (7 >>> 9)); 
} 


if (15 >>> 9 !== 0) { 
  throw new Test262Error('#302: 15 >>> 9 === 0. Actual: ' + (15 >>> 9)); 
} 


if (31 >>> 9 !== 0) { 
  throw new Test262Error('#303: 31 >>> 9 === 0. Actual: ' + (31 >>> 9)); 
} 


if (63 >>> 9 !== 0) { 
  throw new Test262Error('#304: 63 >>> 9 === 0. Actual: ' + (63 >>> 9)); 
} 


if (127 >>> 9 !== 0) { 
  throw new Test262Error('#305: 127 >>> 9 === 0. Actual: ' + (127 >>> 9)); 
} 


if (255 >>> 9 !== 0) { 
  throw new Test262Error('#306: 255 >>> 9 === 0. Actual: ' + (255 >>> 9)); 
} 


if (511 >>> 9 !== 0) { 
  throw new Test262Error('#307: 511 >>> 9 === 0. Actual: ' + (511 >>> 9)); 
} 


if (1023 >>> 9 !== 1) { 
  throw new Test262Error('#308: 1023 >>> 9 === 1. Actual: ' + (1023 >>> 9)); 
} 


if (2047 >>> 9 !== 3) { 
  throw new Test262Error('#309: 2047 >>> 9 === 3. Actual: ' + (2047 >>> 9)); 
} 


if (4095 >>> 9 !== 7) { 
  throw new Test262Error('#310: 4095 >>> 9 === 7. Actual: ' + (4095 >>> 9)); 
} 


if (8191 >>> 9 !== 15) { 
  throw new Test262Error('#311: 8191 >>> 9 === 15. Actual: ' + (8191 >>> 9)); 
} 


if (16383 >>> 9 !== 31) { 
  throw new Test262Error('#312: 16383 >>> 9 === 31. Actual: ' + (16383 >>> 9)); 
} 


if (32767 >>> 9 !== 63) { 
  throw new Test262Error('#313: 32767 >>> 9 === 63. Actual: ' + (32767 >>> 9)); 
} 


if (65535 >>> 9 !== 127) { 
  throw new Test262Error('#314: 65535 >>> 9 === 127. Actual: ' + (65535 >>> 9)); 
} 


if (131071 >>> 9 !== 255) { 
  throw new Test262Error('#315: 131071 >>> 9 === 255. Actual: ' + (131071 >>> 9)); 
} 


if (262143 >>> 9 !== 511) { 
  throw new Test262Error('#316: 262143 >>> 9 === 511. Actual: ' + (262143 >>> 9)); 
} 


if (524287 >>> 9 !== 1023) { 
  throw new Test262Error('#317: 524287 >>> 9 === 1023. Actual: ' + (524287 >>> 9)); 
} 


if (1048575 >>> 9 !== 2047) { 
  throw new Test262Error('#318: 1048575 >>> 9 === 2047. Actual: ' + (1048575 >>> 9)); 
} 


if (2097151 >>> 9 !== 4095) { 
  throw new Test262Error('#319: 2097151 >>> 9 === 4095. Actual: ' + (2097151 >>> 9)); 
} 


if (4194303 >>> 9 !== 8191) { 
  throw new Test262Error('#320: 4194303 >>> 9 === 8191. Actual: ' + (4194303 >>> 9)); 
} 


if (8388607 >>> 9 !== 16383) { 
  throw new Test262Error('#321: 8388607 >>> 9 === 16383. Actual: ' + (8388607 >>> 9)); 
} 


if (16777215 >>> 9 !== 32767) { 
  throw new Test262Error('#322: 16777215 >>> 9 === 32767. Actual: ' + (16777215 >>> 9)); 
} 


if (33554431 >>> 9 !== 65535) { 
  throw new Test262Error('#323: 33554431 >>> 9 === 65535. Actual: ' + (33554431 >>> 9)); 
} 


if (67108863 >>> 9 !== 131071) { 
  throw new Test262Error('#324: 67108863 >>> 9 === 131071. Actual: ' + (67108863 >>> 9)); 
} 


if (134217727 >>> 9 !== 262143) { 
  throw new Test262Error('#325: 134217727 >>> 9 === 262143. Actual: ' + (134217727 >>> 9)); 
} 


if (268435455 >>> 9 !== 524287) { 
  throw new Test262Error('#326: 268435455 >>> 9 === 524287. Actual: ' + (268435455 >>> 9)); 
} 


if (536870911 >>> 9 !== 1048575) { 
  throw new Test262Error('#327: 536870911 >>> 9 === 1048575. Actual: ' + (536870911 >>> 9)); 
} 


if (1073741823 >>> 9 !== 2097151) { 
  throw new Test262Error('#328: 1073741823 >>> 9 === 2097151. Actual: ' + (1073741823 >>> 9)); 
} 


if (2147483647 >>> 9 !== 4194303) { 
  throw new Test262Error('#329: 2147483647 >>> 9 === 4194303. Actual: ' + (2147483647 >>> 9)); 
} 


if (4294967295 >>> 9 !== 8388607) { 
  throw new Test262Error('#330: 4294967295 >>> 9 === 8388607. Actual: ' + (4294967295 >>> 9)); 
} 


if (0 >>> 10 !== 0) { 
  throw new Test262Error('#331: 0 >>> 10 === 0. Actual: ' + (0 >>> 10)); 
} 


if (1 >>> 10 !== 0) { 
  throw new Test262Error('#332: 1 >>> 10 === 0. Actual: ' + (1 >>> 10)); 
} 


if (3 >>> 10 !== 0) { 
  throw new Test262Error('#333: 3 >>> 10 === 0. Actual: ' + (3 >>> 10)); 
} 


if (7 >>> 10 !== 0) { 
  throw new Test262Error('#334: 7 >>> 10 === 0. Actual: ' + (7 >>> 10)); 
} 


if (15 >>> 10 !== 0) { 
  throw new Test262Error('#335: 15 >>> 10 === 0. Actual: ' + (15 >>> 10)); 
} 


if (31 >>> 10 !== 0) { 
  throw new Test262Error('#336: 31 >>> 10 === 0. Actual: ' + (31 >>> 10)); 
} 


if (63 >>> 10 !== 0) { 
  throw new Test262Error('#337: 63 >>> 10 === 0. Actual: ' + (63 >>> 10)); 
} 


if (127 >>> 10 !== 0) { 
  throw new Test262Error('#338: 127 >>> 10 === 0. Actual: ' + (127 >>> 10)); 
} 


if (255 >>> 10 !== 0) { 
  throw new Test262Error('#339: 255 >>> 10 === 0. Actual: ' + (255 >>> 10)); 
} 


if (511 >>> 10 !== 0) { 
  throw new Test262Error('#340: 511 >>> 10 === 0. Actual: ' + (511 >>> 10)); 
} 


if (1023 >>> 10 !== 0) { 
  throw new Test262Error('#341: 1023 >>> 10 === 0. Actual: ' + (1023 >>> 10)); 
} 


if (2047 >>> 10 !== 1) { 
  throw new Test262Error('#342: 2047 >>> 10 === 1. Actual: ' + (2047 >>> 10)); 
} 


if (4095 >>> 10 !== 3) { 
  throw new Test262Error('#343: 4095 >>> 10 === 3. Actual: ' + (4095 >>> 10)); 
} 


if (8191 >>> 10 !== 7) { 
  throw new Test262Error('#344: 8191 >>> 10 === 7. Actual: ' + (8191 >>> 10)); 
} 


if (16383 >>> 10 !== 15) { 
  throw new Test262Error('#345: 16383 >>> 10 === 15. Actual: ' + (16383 >>> 10)); 
} 


if (32767 >>> 10 !== 31) { 
  throw new Test262Error('#346: 32767 >>> 10 === 31. Actual: ' + (32767 >>> 10)); 
} 


if (65535 >>> 10 !== 63) { 
  throw new Test262Error('#347: 65535 >>> 10 === 63. Actual: ' + (65535 >>> 10)); 
} 


if (131071 >>> 10 !== 127) { 
  throw new Test262Error('#348: 131071 >>> 10 === 127. Actual: ' + (131071 >>> 10)); 
} 


if (262143 >>> 10 !== 255) { 
  throw new Test262Error('#349: 262143 >>> 10 === 255. Actual: ' + (262143 >>> 10)); 
} 


if (524287 >>> 10 !== 511) { 
  throw new Test262Error('#350: 524287 >>> 10 === 511. Actual: ' + (524287 >>> 10)); 
} 


if (1048575 >>> 10 !== 1023) { 
  throw new Test262Error('#351: 1048575 >>> 10 === 1023. Actual: ' + (1048575 >>> 10)); 
} 


if (2097151 >>> 10 !== 2047) { 
  throw new Test262Error('#352: 2097151 >>> 10 === 2047. Actual: ' + (2097151 >>> 10)); 
} 


if (4194303 >>> 10 !== 4095) { 
  throw new Test262Error('#353: 4194303 >>> 10 === 4095. Actual: ' + (4194303 >>> 10)); 
} 


if (8388607 >>> 10 !== 8191) { 
  throw new Test262Error('#354: 8388607 >>> 10 === 8191. Actual: ' + (8388607 >>> 10)); 
} 


if (16777215 >>> 10 !== 16383) { 
  throw new Test262Error('#355: 16777215 >>> 10 === 16383. Actual: ' + (16777215 >>> 10)); 
} 


if (33554431 >>> 10 !== 32767) { 
  throw new Test262Error('#356: 33554431 >>> 10 === 32767. Actual: ' + (33554431 >>> 10)); 
} 


if (67108863 >>> 10 !== 65535) { 
  throw new Test262Error('#357: 67108863 >>> 10 === 65535. Actual: ' + (67108863 >>> 10)); 
} 


if (134217727 >>> 10 !== 131071) { 
  throw new Test262Error('#358: 134217727 >>> 10 === 131071. Actual: ' + (134217727 >>> 10)); 
} 


if (268435455 >>> 10 !== 262143) { 
  throw new Test262Error('#359: 268435455 >>> 10 === 262143. Actual: ' + (268435455 >>> 10)); 
} 


if (536870911 >>> 10 !== 524287) { 
  throw new Test262Error('#360: 536870911 >>> 10 === 524287. Actual: ' + (536870911 >>> 10)); 
} 


if (1073741823 >>> 10 !== 1048575) { 
  throw new Test262Error('#361: 1073741823 >>> 10 === 1048575. Actual: ' + (1073741823 >>> 10)); 
} 


if (2147483647 >>> 10 !== 2097151) { 
  throw new Test262Error('#362: 2147483647 >>> 10 === 2097151. Actual: ' + (2147483647 >>> 10)); 
} 


if (4294967295 >>> 10 !== 4194303) { 
  throw new Test262Error('#363: 4294967295 >>> 10 === 4194303. Actual: ' + (4294967295 >>> 10)); 
} 


if (0 >>> 11 !== 0) { 
  throw new Test262Error('#364: 0 >>> 11 === 0. Actual: ' + (0 >>> 11)); 
} 


if (1 >>> 11 !== 0) { 
  throw new Test262Error('#365: 1 >>> 11 === 0. Actual: ' + (1 >>> 11)); 
} 


if (3 >>> 11 !== 0) { 
  throw new Test262Error('#366: 3 >>> 11 === 0. Actual: ' + (3 >>> 11)); 
} 


if (7 >>> 11 !== 0) { 
  throw new Test262Error('#367: 7 >>> 11 === 0. Actual: ' + (7 >>> 11)); 
} 


if (15 >>> 11 !== 0) { 
  throw new Test262Error('#368: 15 >>> 11 === 0. Actual: ' + (15 >>> 11)); 
} 


if (31 >>> 11 !== 0) { 
  throw new Test262Error('#369: 31 >>> 11 === 0. Actual: ' + (31 >>> 11)); 
} 


if (63 >>> 11 !== 0) { 
  throw new Test262Error('#370: 63 >>> 11 === 0. Actual: ' + (63 >>> 11)); 
} 


if (127 >>> 11 !== 0) { 
  throw new Test262Error('#371: 127 >>> 11 === 0. Actual: ' + (127 >>> 11)); 
} 


if (255 >>> 11 !== 0) { 
  throw new Test262Error('#372: 255 >>> 11 === 0. Actual: ' + (255 >>> 11)); 
} 


if (511 >>> 11 !== 0) { 
  throw new Test262Error('#373: 511 >>> 11 === 0. Actual: ' + (511 >>> 11)); 
} 


if (1023 >>> 11 !== 0) { 
  throw new Test262Error('#374: 1023 >>> 11 === 0. Actual: ' + (1023 >>> 11)); 
} 


if (2047 >>> 11 !== 0) { 
  throw new Test262Error('#375: 2047 >>> 11 === 0. Actual: ' + (2047 >>> 11)); 
} 


if (4095 >>> 11 !== 1) { 
  throw new Test262Error('#376: 4095 >>> 11 === 1. Actual: ' + (4095 >>> 11)); 
} 


if (8191 >>> 11 !== 3) { 
  throw new Test262Error('#377: 8191 >>> 11 === 3. Actual: ' + (8191 >>> 11)); 
} 


if (16383 >>> 11 !== 7) { 
  throw new Test262Error('#378: 16383 >>> 11 === 7. Actual: ' + (16383 >>> 11)); 
} 


if (32767 >>> 11 !== 15) { 
  throw new Test262Error('#379: 32767 >>> 11 === 15. Actual: ' + (32767 >>> 11)); 
} 


if (65535 >>> 11 !== 31) { 
  throw new Test262Error('#380: 65535 >>> 11 === 31. Actual: ' + (65535 >>> 11)); 
} 


if (131071 >>> 11 !== 63) { 
  throw new Test262Error('#381: 131071 >>> 11 === 63. Actual: ' + (131071 >>> 11)); 
} 


if (262143 >>> 11 !== 127) { 
  throw new Test262Error('#382: 262143 >>> 11 === 127. Actual: ' + (262143 >>> 11)); 
} 


if (524287 >>> 11 !== 255) { 
  throw new Test262Error('#383: 524287 >>> 11 === 255. Actual: ' + (524287 >>> 11)); 
} 


if (1048575 >>> 11 !== 511) { 
  throw new Test262Error('#384: 1048575 >>> 11 === 511. Actual: ' + (1048575 >>> 11)); 
} 


if (2097151 >>> 11 !== 1023) { 
  throw new Test262Error('#385: 2097151 >>> 11 === 1023. Actual: ' + (2097151 >>> 11)); 
} 


if (4194303 >>> 11 !== 2047) { 
  throw new Test262Error('#386: 4194303 >>> 11 === 2047. Actual: ' + (4194303 >>> 11)); 
} 


if (8388607 >>> 11 !== 4095) { 
  throw new Test262Error('#387: 8388607 >>> 11 === 4095. Actual: ' + (8388607 >>> 11)); 
} 


if (16777215 >>> 11 !== 8191) { 
  throw new Test262Error('#388: 16777215 >>> 11 === 8191. Actual: ' + (16777215 >>> 11)); 
} 


if (33554431 >>> 11 !== 16383) { 
  throw new Test262Error('#389: 33554431 >>> 11 === 16383. Actual: ' + (33554431 >>> 11)); 
} 


if (67108863 >>> 11 !== 32767) { 
  throw new Test262Error('#390: 67108863 >>> 11 === 32767. Actual: ' + (67108863 >>> 11)); 
} 


if (134217727 >>> 11 !== 65535) { 
  throw new Test262Error('#391: 134217727 >>> 11 === 65535. Actual: ' + (134217727 >>> 11)); 
} 


if (268435455 >>> 11 !== 131071) { 
  throw new Test262Error('#392: 268435455 >>> 11 === 131071. Actual: ' + (268435455 >>> 11)); 
} 


if (536870911 >>> 11