// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// Request body payload for CreateOAuth2Token operation The operation type is determined by the grant_type parameter: - grant_type=authorization_code: Requires code, redirect_uri, code_verifier - grant_type=refresh_token: Requires refresh_token
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct CreateOAuth2TokenRequestBody {
    /// The client identifier (ARN) used during Sign-In onboarding Required for both authorization code and refresh token flows
    pub client_id: ::std::string::String,
    /// OAuth 2.0 grant type - determines which flow is used Must be "authorization_code" or "refresh_token"
    pub grant_type: ::std::string::String,
    /// The authorization code received from /v1/authorize Required only when grant_type=authorization_code
    pub code: ::std::option::Option<::std::string::String>,
    /// The redirect URI that must match the original authorization request Required only when grant_type=authorization_code
    pub redirect_uri: ::std::option::Option<::std::string::String>,
    /// PKCE code verifier to prove possession of the original code challenge Required only when grant_type=authorization_code
    pub code_verifier: ::std::option::Option<::std::string::String>,
    /// The refresh token returned from auth_code redemption Required only when grant_type=refresh_token
    pub refresh_token: ::std::option::Option<::std::string::String>,
}
impl CreateOAuth2TokenRequestBody {
    /// The client identifier (ARN) used during Sign-In onboarding Required for both authorization code and refresh token flows
    pub fn client_id(&self) -> &str {
        use std::ops::Deref;
        self.client_id.deref()
    }
    /// OAuth 2.0 grant type - determines which flow is used Must be "authorization_code" or "refresh_token"
    pub fn grant_type(&self) -> &str {
        use std::ops::Deref;
        self.grant_type.deref()
    }
    /// The authorization code received from /v1/authorize Required only when grant_type=authorization_code
    pub fn code(&self) -> ::std::option::Option<&str> {
        self.code.as_deref()
    }
    /// The redirect URI that must match the original authorization request Required only when grant_type=authorization_code
    pub fn redirect_uri(&self) -> ::std::option::Option<&str> {
        self.redirect_uri.as_deref()
    }
    /// PKCE code verifier to prove possession of the original code challenge Required only when grant_type=authorization_code
    pub fn code_verifier(&self) -> ::std::option::Option<&str> {
        self.code_verifier.as_deref()
    }
    /// The refresh token returned from auth_code redemption Required only when grant_type=refresh_token
    pub fn refresh_token(&self) -> ::std::option::Option<&str> {
        self.refresh_token.as_deref()
    }
}
impl ::std::fmt::Debug for CreateOAuth2TokenRequestBody {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOAuth2TokenRequestBody");
        formatter.field("client_id", &self.client_id);
        formatter.field("grant_type", &self.grant_type);
        formatter.field("code", &self.code);
        formatter.field("redirect_uri", &self.redirect_uri);
        formatter.field("code_verifier", &self.code_verifier);
        formatter.field("refresh_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl CreateOAuth2TokenRequestBody {
    /// Creates a new builder-style object to manufacture [`CreateOAuth2TokenRequestBody`](crate::types::CreateOAuth2TokenRequestBody).
    pub fn builder() -> crate::types::builders::CreateOAuth2TokenRequestBodyBuilder {
        crate::types::builders::CreateOAuth2TokenRequestBodyBuilder::default()
    }
}

/// A builder for [`CreateOAuth2TokenRequestBody`](crate::types::CreateOAuth2TokenRequestBody).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct CreateOAuth2TokenRequestBodyBuilder {
    pub(crate) client_id: ::std::option::Option<::std::string::String>,
    pub(crate) grant_type: ::std::option::Option<::std::string::String>,
    pub(crate) code: ::std::option::Option<::std::string::String>,
    pub(crate) redirect_uri: ::std::option::Option<::std::string::String>,
    pub(crate) code_verifier: ::std::option::Option<::std::string::String>,
    pub(crate) refresh_token: ::std::option::Option<::std::string::String>,
}
impl CreateOAuth2TokenRequestBodyBuilder {
    /// The client identifier (ARN) used during Sign-In onboarding Required for both authorization code and refresh token flows
    /// This field is required.
    pub fn client_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.client_id = ::std::option::Option::Some(input.into());
        self
    }
    /// The client identifier (ARN) used during Sign-In onboarding Required for both authorization code and refresh token flows
    pub fn set_client_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.client_id = input;
        self
    }
    /// The client identifier (ARN) used during Sign-In onboarding Required for both authorization code and refresh token flows
    pub fn get_client_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.client_id
    }
    /// OAuth 2.0 grant type - determines which flow is used Must be "authorization_code" or "refresh_token"
    /// This field is required.
    pub fn grant_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.grant_type = ::std::option::Option::Some(input.into());
        self
    }
    /// OAuth 2.0 grant type - determines which flow is used Must be "authorization_code" or "refresh_token"
    pub fn set_grant_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.grant_type = input;
        self
    }
    /// OAuth 2.0 grant type - determines which flow is used Must be "authorization_code" or "refresh_token"
    pub fn get_grant_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.grant_type
    }
    /// The authorization code received from /v1/authorize Required only when grant_type=authorization_code
    pub fn code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.code = ::std::option::Option::Some(input.into());
        self
    }
    /// The authorization code received from /v1/authorize Required only when grant_type=authorization_code
    pub fn set_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.code = input;
        self
    }
    /// The authorization code received from /v1/authorize Required only when grant_type=authorization_code
    pub fn get_code(&self) -> &::std::option::Option<::std::string::String> {
        &self.code
    }
    /// The redirect URI that must match the original authorization request Required only when grant_type=authorization_code
    pub fn redirect_uri(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.redirect_uri = ::std::option::Option::Some(input.into());
        self
    }
    /// The redirect URI that must match the original authorization request Required only when grant_type=authorization_code
    pub fn set_redirect_uri(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.redirect_uri = input;
        self
    }
    /// The redirect URI that must match the original authorization request Required only when grant_type=authorization_code
    pub fn get_redirect_uri(&self) -> &::std::option::Option<::std::string::String> {
        &self.redirect_uri
    }
    /// PKCE code verifier to prove possession of the original code challenge Required only when grant_type=authorization_code
    pub fn code_verifier(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.code_verifier = ::std::option::Option::Some(input.into());
        self
    }
    /// PKCE code verifier to prove possession of the original code challenge Required only when grant_type=authorization_code
    pub fn set_code_verifier(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.code_verifier = input;
        self
    }
    /// PKCE code verifier to prove possession of the original code challenge Required only when grant_type=authorization_code
    pub fn get_code_verifier(&self) -> &::std::option::Option<::std::string::String> {
        &self.code_verifier
    }
    /// The refresh token returned from auth_code redemption Required only when grant_type=refresh_token
    pub fn refresh_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.refresh_token = ::std::option::Option::Some(input.into());
        self
    }
    /// The refresh token returned from auth_code redemption Required only when grant_type=refresh_token
    pub fn set_refresh_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.refresh_token = input;
        self
    }
    /// The refresh token returned from auth_code redemption Required only when grant_type=refresh_token
    pub fn get_refresh_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.refresh_token
    }
    /// Consumes the builder and constructs a [`CreateOAuth2TokenRequestBody`](crate::types::CreateOAuth2TokenRequestBody).
    /// This method will fail if any of the following fields are not set:
    /// - [`client_id`](crate::types::builders::CreateOAuth2TokenRequestBodyBuilder::client_id)
    /// - [`grant_type`](crate::types::builders::CreateOAuth2TokenRequestBodyBuilder::grant_type)
    pub fn build(self) -> ::std::result::Result<crate::types::CreateOAuth2TokenRequestBody, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::CreateOAuth2TokenRequestBody {
            client_id: self.client_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "client_id",
                    "client_id was not specified but it is required when building CreateOAuth2TokenRequestBody",
                )
            })?,
            grant_type: self.grant_type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "grant_type",
                    "grant_type was not specified but it is required when building CreateOAuth2TokenRequestBody",
                )
            })?,
            code: self.code,
            redirect_uri: self.redirect_uri,
            code_verifier: self.code_verifier,
            refresh_token: self.refresh_token,
        })
    }
}
impl ::std::fmt::Debug for CreateOAuth2TokenRequestBodyBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOAuth2TokenRequestBodyBuilder");
        formatter.field("client_id", &self.client_id);
        formatter.field("grant_type", &self.grant_type);
        formatter.field("code", &self.code);
        formatter.field("redirect_uri", &self.redirect_uri);
        formatter.field("code_verifier", &self.code_verifier);
        formatter.field("refresh_token", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
