// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A Top level guardrail trace object. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseTrace.html">ConverseTrace</a>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailTraceAssessment {
    /// <p>The output from the model.</p>
    pub model_output: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// <p>The input assessment.</p>
    pub input_assessment: ::std::option::Option<::std::collections::HashMap<::std::string::String, crate::types::GuardrailAssessment>>,
    /// <p>the output assessments.</p>
    pub output_assessments:
        ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::vec::Vec<crate::types::GuardrailAssessment>>>,
    /// <p>Provides the reason for the action taken when harmful content is detected.</p>
    pub action_reason: ::std::option::Option<::std::string::String>,
}
impl GuardrailTraceAssessment {
    /// <p>The output from the model.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.model_output.is_none()`.
    pub fn model_output(&self) -> &[::std::string::String] {
        self.model_output.as_deref().unwrap_or_default()
    }
    /// <p>The input assessment.</p>
    pub fn input_assessment(&self) -> ::std::option::Option<&::std::collections::HashMap<::std::string::String, crate::types::GuardrailAssessment>> {
        self.input_assessment.as_ref()
    }
    /// <p>the output assessments.</p>
    pub fn output_assessments(
        &self,
    ) -> ::std::option::Option<&::std::collections::HashMap<::std::string::String, ::std::vec::Vec<crate::types::GuardrailAssessment>>> {
        self.output_assessments.as_ref()
    }
    /// <p>Provides the reason for the action taken when harmful content is detected.</p>
    pub fn action_reason(&self) -> ::std::option::Option<&str> {
        self.action_reason.as_deref()
    }
}
impl GuardrailTraceAssessment {
    /// Creates a new builder-style object to manufacture [`GuardrailTraceAssessment`](crate::types::GuardrailTraceAssessment).
    pub fn builder() -> crate::types::builders::GuardrailTraceAssessmentBuilder {
        crate::types::builders::GuardrailTraceAssessmentBuilder::default()
    }
}

/// A builder for [`GuardrailTraceAssessment`](crate::types::GuardrailTraceAssessment).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailTraceAssessmentBuilder {
    pub(crate) model_output: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) input_assessment: ::std::option::Option<::std::collections::HashMap<::std::string::String, crate::types::GuardrailAssessment>>,
    pub(crate) output_assessments:
        ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::vec::Vec<crate::types::GuardrailAssessment>>>,
    pub(crate) action_reason: ::std::option::Option<::std::string::String>,
}
impl GuardrailTraceAssessmentBuilder {
    /// Appends an item to `model_output`.
    ///
    /// To override the contents of this collection use [`set_model_output`](Self::set_model_output).
    ///
    /// <p>The output from the model.</p>
    pub fn model_output(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.model_output.unwrap_or_default();
        v.push(input.into());
        self.model_output = ::std::option::Option::Some(v);
        self
    }
    /// <p>The output from the model.</p>
    pub fn set_model_output(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.model_output = input;
        self
    }
    /// <p>The output from the model.</p>
    pub fn get_model_output(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.model_output
    }
    /// Adds a key-value pair to `input_assessment`.
    ///
    /// To override the contents of this collection use [`set_input_assessment`](Self::set_input_assessment).
    ///
    /// <p>The input assessment.</p>
    pub fn input_assessment(mut self, k: impl ::std::convert::Into<::std::string::String>, v: crate::types::GuardrailAssessment) -> Self {
        let mut hash_map = self.input_assessment.unwrap_or_default();
        hash_map.insert(k.into(), v);
        self.input_assessment = ::std::option::Option::Some(hash_map);
        self
    }
    /// <p>The input assessment.</p>
    pub fn set_input_assessment(
        mut self,
        input: ::std::option::Option<::std::collections::HashMap<::std::string::String, crate::types::GuardrailAssessment>>,
    ) -> Self {
        self.input_assessment = input;
        self
    }
    /// <p>The input assessment.</p>
    pub fn get_input_assessment(
        &self,
    ) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, crate::types::GuardrailAssessment>> {
        &self.input_assessment
    }
    /// Adds a key-value pair to `output_assessments`.
    ///
    /// To override the contents of this collection use [`set_output_assessments`](Self::set_output_assessments).
    ///
    /// <p>the output assessments.</p>
    pub fn output_assessments(
        mut self,
        k: impl ::std::convert::Into<::std::string::String>,
        v: ::std::vec::Vec<crate::types::GuardrailAssessment>,
    ) -> Self {
        let mut hash_map = self.output_assessments.unwrap_or_default();
        hash_map.insert(k.into(), v);
        self.output_assessments = ::std::option::Option::Some(hash_map);
        self
    }
    /// <p>the output assessments.</p>
    pub fn set_output_assessments(
        mut self,
        input: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::vec::Vec<crate::types::GuardrailAssessment>>>,
    ) -> Self {
        self.output_assessments = input;
        self
    }
    /// <p>the output assessments.</p>
    pub fn get_output_assessments(
        &self,
    ) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::vec::Vec<crate::types::GuardrailAssessment>>> {
        &self.output_assessments
    }
    /// <p>Provides the reason for the action taken when harmful content is detected.</p>
    pub fn action_reason(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.action_reason = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides the reason for the action taken when harmful content is detected.</p>
    pub fn set_action_reason(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.action_reason = input;
        self
    }
    /// <p>Provides the reason for the action taken when harmful content is detected.</p>
    pub fn get_action_reason(&self) -> &::std::option::Option<::std::string::String> {
        &self.action_reason
    }
    /// Consumes the builder and constructs a [`GuardrailTraceAssessment`](crate::types::GuardrailTraceAssessment).
    pub fn build(self) -> crate::types::GuardrailTraceAssessment {
        crate::types::GuardrailTraceAssessment {
            model_output: self.model_output,
            input_assessment: self.input_assessment,
            output_assessments: self.output_assessments,
            action_reason: self.action_reason,
        }
    }
}
