/// Auto-generated bindings for a pre-instantiated version of a
/// component which implements the world `empty`.
///
/// This structure is created through [`EmptyPre::new`] which
/// takes a [`InstancePre`](wasmtime::component::InstancePre) that
/// has been created through a [`Linker`](wasmtime::component::Linker).
///
/// For more information see [`Empty`] as well.
pub struct EmptyPre<T> {
    instance_pre: wasmtime::component::InstancePre<T>,
    indices: EmptyIndices,
}
impl<T> Clone for EmptyPre<T> {
    fn clone(&self) -> Self {
        Self {
            instance_pre: self.instance_pre.clone(),
            indices: self.indices.clone(),
        }
    }
}
impl<_T> EmptyPre<_T> {
    /// Creates a new copy of `EmptyPre` bindings which can then
    /// be used to instantiate into a particular store.
    ///
    /// This method may fail if the component behind `instance_pre`
    /// does not have the required exports.
    pub fn new(
        instance_pre: wasmtime::component::InstancePre<_T>,
    ) -> wasmtime::Result<Self> {
        let indices = EmptyIndices::new(&instance_pre)?;
        Ok(Self { instance_pre, indices })
    }
    pub fn engine(&self) -> &wasmtime::Engine {
        self.instance_pre.engine()
    }
    pub fn instance_pre(&self) -> &wasmtime::component::InstancePre<_T> {
        &self.instance_pre
    }
    /// Instantiates a new instance of [`Empty`] within the
    /// `store` provided.
    ///
    /// This function will use `self` as the pre-instantiated
    /// instance to perform instantiation. Afterwards the preloaded
    /// indices in `self` are used to lookup all exports on the
    /// resulting instance.
    pub fn instantiate(
        &self,
        mut store: impl wasmtime::AsContextMut<Data = _T>,
    ) -> wasmtime::Result<Empty> {
        let mut store = store.as_context_mut();
        let instance = self.instance_pre.instantiate(&mut store)?;
        self.indices.load(&mut store, &instance)
    }
}
/// Auto-generated bindings for index of the exports of
/// `empty`.
///
/// This is an implementation detail of [`EmptyPre`] and can
/// be constructed if needed as well.
///
/// For more information see [`Empty`] as well.
#[derive(Clone)]
pub struct EmptyIndices {}
/// Auto-generated bindings for an instance a component which
/// implements the world `empty`.
///
/// This structure can be created through a number of means
/// depending on your requirements and what you have on hand:
///
/// * The most convenient way is to use
///   [`Empty::instantiate`] which only needs a
///   [`Store`], [`Component`], and [`Linker`].
///
/// * Alternatively you can create a [`EmptyPre`] ahead of
///   time with a [`Component`] to front-load string lookups
///   of exports once instead of per-instantiation. This
///   method then uses [`EmptyPre::instantiate`] to
///   create a [`Empty`].
///
/// * If you've instantiated the instance yourself already
///   then you can use [`Empty::new`].
///
/// These methods are all equivalent to one another and move
/// around the tradeoff of what work is performed when.
///
/// [`Store`]: wasmtime::Store
/// [`Component`]: wasmtime::component::Component
/// [`Linker`]: wasmtime::component::Linker
pub struct Empty {}
const _: () = {
    #[allow(unused_imports)]
    use wasmtime::component::__internal::anyhow;
    impl EmptyIndices {
        /// Creates a new copy of `EmptyIndices` bindings which can then
        /// be used to instantiate into a particular store.
        ///
        /// This method may fail if the component does not have the
        /// required exports.
        pub fn new<_T>(
            _instance_pre: &wasmtime::component::InstancePre<_T>,
        ) -> wasmtime::Result<Self> {
            let _component = _instance_pre.component();
            let _instance_type = _instance_pre.instance_type();
            Ok(EmptyIndices {})
        }
        /// Uses the indices stored in `self` to load an instance
        /// of [`Empty`] from the instance provided.
        ///
        /// Note that at this time this method will additionally
        /// perform type-checks of all exports.
        pub fn load(
            &self,
            mut store: impl wasmtime::AsContextMut,
            instance: &wasmtime::component::Instance,
        ) -> wasmtime::Result<Empty> {
            let _ = &mut store;
            let _instance = instance;
            Ok(Empty {})
        }
    }
    impl Empty {
        /// Convenience wrapper around [`EmptyPre::new`] and
        /// [`EmptyPre::instantiate`].
        pub fn instantiate<_T>(
            store: impl wasmtime::AsContextMut<Data = _T>,
            component: &wasmtime::component::Component,
            linker: &wasmtime::component::Linker<_T>,
        ) -> wasmtime::Result<Empty> {
            let pre = linker.instantiate_pre(component)?;
            EmptyPre::new(pre)?.instantiate(store)
        }
        /// Convenience wrapper around [`EmptyIndices::new`] and
        /// [`EmptyIndices::load`].
        pub fn new(
            mut store: impl wasmtime::AsContextMut,
            instance: &wasmtime::component::Instance,
        ) -> wasmtime::Result<Empty> {
            let indices = EmptyIndices::new(&instance.instance_pre(&store))?;
            indices.load(&mut store, instance)
        }
    }
};
