/*
Copyright (c) 2018, MIPI Alliance, Inc. 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in
  the documentation and/or other materials provided with the
  distribution.

* Neither the name of the copyright holder nor the names of its
  contributors may be used to endorse or promote products derived
  from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
 * Contributors:
 * Norbert Schulz (Intel Corporation) - Initial API and implementation
 */

#include "mipi_syst_gtest.h"

#if defined(MIPI_SYST_PCFG_ENABLE_PLATFORM_STATE_DATA) && defined(MIPI_SYST_PCFG_ENABLE_DEFAULT_SCATTER_WRITE) && defined(MIPI_SYST_PCFG_ENABLE_CATID64_API)

class MipiSysTFixtureCatId64 : public MipiSysTFixtureOutput
{
public:
	void SetUp() {
		MipiSysTFixtureOutput::SetUp();
	}

	void TearDown(){
		MipiSysTFixtureOutput::TearDown();
	}

	const char * mipi_syst_write_catalog64_message(struct mipi_syst_handle* svh,
	struct mipi_syst_msglocation* loc,
		enum mipi_syst_severity severity,
		mipi_syst_u64 catid)
	{
		static std::string result;

		::mipi_syst_write_catalog64_message(svh, loc, severity, catid);
		result = sstr.str();
		sstr.str("");

		return result.c_str();
	}
};

TEST_F(MipiSysTFixtureCatId64, syst_catid64_basic)
{
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG64_0(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE)
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG64_1(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE,1 )
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG64_2(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2 )
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG64_3(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3 )
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG64_4(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3, 4 )
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG64_5(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2,3,4,5 )
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG64_6(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2,3,4,5,6 )
		);
#if defined(MIPI_SYST_PCFG_ENABLE_LOCATION_RECORD)

	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG64_0_LOC16(0,MIPI_SYST_SEVERITY_WARNING, 1, 0xCAFEBABE )
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG64_0_LOC32(0,MIPI_SYST_SEVERITY_WARNING, 1, 0xCAFEBABE )
		);

#if defined(MIPI_SYST_PCFG_ENABLE_LOCATION_ADDRESS)
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG64_0_LOCADDR(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE)
		);
#endif
#endif
}

TEST_F(MipiSysTFixtureCatId64, syst_catid64_noloc_output)
{
	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>0008<D64>000decafcafebabe<FLAG>"),
		MIPI_SYST_CATALOG64_0(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>000c<D64>000decafcafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATALOG64_1(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>0010<D64>000decafcafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATALOG64_2(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>0014<D64>000decafcafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATALOG64_3(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2, 3)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>0018<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATALOG64_4(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2, 3, 4)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>001c<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATALOG64_5(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2, 3, 4, 5)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>0020<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATALOG64_6(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2, 3, 4, 5, 6)
		);
}

#if defined(MIPI_SYST_PCFG_ENABLE_LOCATION_RECORD)
#if defined(MIPI_SYST_PCFG_ENABLE_LOCATION_ADDRESS)
TEST_F(MipiSysTFixtureCatId64, syst_catid64_locaddr_output)
{
#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0008<D64>000decafcafebabe<FLAG>"),
		MIPI_SYST_CATALOG64_0_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0008<D64>000decafcafebabe<FLAG>"),
		MIPI_SYST_CATALOG64_0_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>000c<D64>000decafcafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATALOG64_1_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>000c<D64>000decafcafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATALOG64_1_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0010<D64>000decafcafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATALOG64_2_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0010<D64>000decafcafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATALOG64_2_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0014<D64>000decafcafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATALOG64_3_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2, 3)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0014<D64>000decafcafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATALOG64_3_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2, 3)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0018<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATALOG64_4_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2, 3, 4)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0018<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATALOG64_4_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2, 3, 4)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>001c<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATALOG64_5_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2, 3, 4, 5)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>001c<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATALOG64_5_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2, 3, 4, 5)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0020<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATALOG64_6_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2, 3, 4, 5, 6)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0020<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATALOG64_6_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, 1, 2, 3, 4, 5, 6)
		);
#endif
}
#endif //MIPI_SYST_PCFG_ENABLE_LOCATION_ADDRESS

TEST_F(MipiSysTFixtureCatId64, syst_catid64_loc16_output)
{
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0008<D64>000decafcafebabe<FLAG>"),
		MIPI_SYST_CATALOG64_0_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>000c<D64>000decafcafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATALOG64_1_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, 1)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0010<D64>000decafcafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATALOG64_2_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, 1, 2)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0014<D64>000decafcafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATALOG64_3_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, 1, 2, 3)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0018<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATALOG64_4_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, 1, 2, 3, 4)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>001c<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATALOG64_5_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, 1, 2, 3, 4, 5)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0020<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATALOG64_6_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, 1, 2, 3, 4, 5, 6)
		);
}

TEST_F(MipiSysTFixtureCatId64, syst_catid64_loc32_output)
{
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0008<D64>000decafcafebabe<FLAG>"),
		MIPI_SYST_CATALOG64_0_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>000c<D64>000decafcafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATALOG64_1_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, 1)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0010<D64>000decafcafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATALOG64_2_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, 1, 2)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0014<D64>000decafcafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATALOG64_3_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, 1, 2, 3)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0018<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATALOG64_4_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, 1, 2, 3, 4)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>001c<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATALOG64_5_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, 1, 2, 3, 4, 5)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0020<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATALOG64_6_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, 1, 2, 3, 4, 5, 6)
		);
}
#endif //MIPI_SYST_PCFG_ENABLE_LOCATION_RECORD


TEST_F(MipiSysTFixtureCatId64, syst_printf64_noloc_output)
{
	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>0008<D64>000decafcafebabe<FLAG>"),
		MIPI_SYST_CATPRINTF64_0(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy")
		);

	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>000c<D64>000decafcafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATPRINTF64_1(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>0010<D64>000decafcafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATPRINTF64_2(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>0014<D64>000decafcafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATPRINTF64_3(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>0018<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATPRINTF64_4(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>001c<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATPRINTF64_5(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4, 5)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012233[typ=3:2 mu=1:2 sev=3 len]<D16>0020<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATPRINTF64_6(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4, 5, 6)
		);
}

#if defined(MIPI_SYST_PCFG_ENABLE_LOCATION_RECORD)
#if defined(MIPI_SYST_PCFG_ENABLE_LOCATION_ADDRESS)
TEST_F(MipiSysTFixtureCatId64, syst_printf64_locaddr_output)
{
#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0008<D64>000decafcafebabe<FLAG>"),
		MIPI_SYST_CATPRINTF64_0_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy")
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0008<D64>000decafcafebabe<FLAG>"),
		MIPI_SYST_CATPRINTF64_0_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy")
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>000c<D64>000decafcafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATPRINTF64_1_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>000c<D64>000decafcafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATPRINTF64_1_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0010<D64>000decafcafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATPRINTF64_2_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0010<D64>000decafcafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATPRINTF64_2_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0014<D64>000decafcafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATPRINTF64_3_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0014<D64>000decafcafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATPRINTF64_3_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0018<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATPRINTF64_4_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0018<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATPRINTF64_4_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>001c<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATPRINTF64_5_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4, 5)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>001c<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATPRINTF64_5_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4, 5)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0020<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATPRINTF64_6_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4, 5, 6)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0020<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATPRINTF64_6_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4, 5, 6)
		);
#endif
}
#endif //MIPI_SYST_PCFG_ENABLE_LOCATION_ADDRESS

TEST_F(MipiSysTFixtureCatId64, syst_printf64_loc16_output)
{
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0008<D64>000decafcafebabe<FLAG>"),
		MIPI_SYST_CATPRINTF64_0_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, "dummy")
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>000c<D64>000decafcafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATPRINTF64_1_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, "dummy", 1)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0010<D64>000decafcafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATPRINTF64_2_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, "dummy", 1, 2)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0014<D64>000decafcafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATPRINTF64_3_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0018<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATPRINTF64_4_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>001c<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATPRINTF64_5_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4, 5)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0020<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATPRINTF64_6_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4, 5, 6)
		);
}

TEST_F(MipiSysTFixtureCatId64, syst_printf64_loc32_output)
{
	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0008<D64>000decafcafebabe<FLAG>"),
		MIPI_SYST_CATPRINTF64_0_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, "dummy")
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>000c<D64>000decafcafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATPRINTF64_1_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, "dummy", 1)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0010<D64>000decafcafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATPRINTF64_2_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, "dummy", 1, 2)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0014<D64>000decafcafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATPRINTF64_3_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0018<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATPRINTF64_4_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>001c<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATPRINTF64_5_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4, 5)
		);

	EXPECT_STREQ(
		xform("<D32TS>02012333[typ=3:2 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0020<D64>000decafcafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATPRINTF64_6_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xDECAFCAFEBABEull, "dummy", 1, 2, 3, 4, 5, 6)
		);
}
#endif //MIPI_SYST_PCFG_ENABLE_LOCATION_RECORD

#endif //MIPI_SYST_PCFG_ENABLE_PLATFORM_STATE_DATA && MIPI_SYST_PCFG_ENABLE_DEFAULT_SCATTER_WRITE && MIPI_SYST_PCFG_ENABLE_CATID64_API