#!/usr/bin/env python3
# SPDX-License-Identifier: GPL-2.0-or-later
#
# Script that generates lib/crypto/fips.h
#
# Copyright 2025 Google LLC

import hashlib
import hmac

fips_test_data = b"fips test data\0\0"
fips_test_key = b"fips test key\0\0\0"

def print_static_u8_array_definition(name, value):
    print('')
    print(f'static const u8 {name}[] __initconst __maybe_unused = {{')
    for i in range(0, len(value), 8):
        line = '\t' + ''.join(f'0x{b:02x}, ' for b in value[i:i+8])
        print(f'{line.rstrip()}')
    print('};')

print('/* SPDX-License-Identifier: GPL-2.0-or-later */')
print(f'/* This file was generated by: gen-fips-testvecs.py */')
print()
print('#include <linux/fips.h>')

print_static_u8_array_definition("fips_test_data", fips_test_data)
print_static_u8_array_definition("fips_test_key", fips_test_key)

for alg in 'sha1', 'sha256', 'sha512':
    ctx = hmac.new(fips_test_key, digestmod=alg)
    ctx.update(fips_test_data)
    print_static_u8_array_definition(f'fips_test_hmac_{alg}_value', ctx.digest())

print_static_u8_array_definition(f'fips_test_sha3_256_value',
                                 hashlib.sha3_256(fips_test_data).digest())
