package Test2::Manual::Anatomy;
use strict;
use warnings;

our $VERSION = '1.302210';

1;

__END__

=head1 NAME

Test2::Manual::Anatomy - The hub for documentation of the inner workings of
Test2 components.

=head1 DESCRIPTION

This section covers internals of the Test2 architecture. This is useful
information for toolbuilder, but is essential information for maintainers of
Test2 itself.

=head1 END TO END

The L<Test2::Manual::Anatomy::EndToEnd> document is an overview of Test2 from load to finish.

=head1 EVENTS

The L<Test2::Manual::Anatomy::Event> document explains the internals of events.

=head1 THE CONTEXT

The L<Test2::Manual::Anatomy::Context> document explains how the
L<Test2::API::Context> object works.

=head1 THE API AND THE API INSTANCE

The L<Test2::Manual::Anatomy::API> document explains the inner workings of the
Test2 API.

=head1 HUBS

The L<Test2::Manual::Anatomy::Hubs> document explains the inner working of
the Test2 hub stack, and the hubs therein.

=head1 THE IPC SYSTEM

The L<Test2::Manual::Anatomy::IPC> document describes the IPC system.

=head1 INTERNAL UTILITIES

The L<Test2::Manual::Anatomy::Utilities> document describes various utilities
provided by the Test2 system.

=head1 SEE ALSO

L<Test2::Manual> - Primary index of the manual.

=head1 SOURCE

The source code repository for Test2-Manual can be found at
F<https://github.com/Test-More/test-more/>.

=head1 MAINTAINERS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 AUTHORS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 COPYRIGHT

Copyright Chad Granum E<lt>exodist@cpan.orgE<gt>.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

See F<http://dev.perl.org/licenses/>

=cut
