/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.json.JSONTokener;

public class ReadableData
implements ReadablePipe {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public static final QName _contentType = new QName("", "content-type");
    public static final QName c_contentType = new QName("c", "http://www.w3.org/ns/xproc-step", "content-type");
    public static final QName _encoding = new QName("", "encoding");
    public static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    private int pos = 0;
    private QName wrapper = null;
    private String uri = null;
    private String contentType = null;
    private XProcRuntime runtime = null;
    private DocumentSequence documents = null;
    private Step reader = null;

    public ReadableData(XProcRuntime xProcRuntime, QName qName, String string, String string2) {
        URI uRI;
        this.runtime = xProcRuntime;
        this.uri = string;
        this.wrapper = qName;
        this.contentType = string2;
        this.documents = new DocumentSequence(xProcRuntime);
        String string3 = this.parseContentType(string2);
        String string4 = this.parseCharset(string2);
        if (string == null) {
            return;
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XProcException(uRISyntaxException);
        }
        TreeWriter treeWriter = new TreeWriter(xProcRuntime);
        treeWriter.startDocument(uRI);
        try {
            URL uRL = uRI.toURL();
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            String string5 = uRLConnection.getContentType();
            if ("content/unknown".equals(string5) && string2 != null) {
                string5 = string2;
            }
            String string6 = this.parseContentType(string5);
            String string7 = this.parseCharset(string5);
            if (string7 != null) {
                string5 = string6 + "; charset=\"" + string7 + "\"";
            }
            String string8 = string7;
            if ("file".equals(uRL.getProtocol()) && string7 == null && string6.equals(string3)) {
                string8 = string4;
            }
            if (xProcRuntime.transparentJSON() && HttpUtils.jsonContentType(string2)) {
                if (string8 == null) {
                    string8 = "UTF-8";
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string8);
                JSONTokener jSONTokener = new JSONTokener(inputStreamReader);
                XdmNode xdmNode = JSONtoXML.convert(xProcRuntime.getProcessor(), jSONTokener, xProcRuntime.jsonFlavor());
                treeWriter.addSubtree(xdmNode);
            } else {
                treeWriter.addStartElement(qName);
                if (XProcConstants.c_data.equals((Object)qName)) {
                    if ("content/unknown".equals(string5)) {
                        treeWriter.addAttribute(_contentType, "application/octet-stream");
                    } else {
                        treeWriter.addAttribute(_contentType, string5);
                    }
                    if (!this.isText(string5, string8)) {
                        treeWriter.addAttribute(_encoding, "base64");
                    }
                } else {
                    if ("content/unknown".equals(string5)) {
                        treeWriter.addAttribute(c_contentType, "application/octet-stream");
                    } else {
                        treeWriter.addAttribute(c_contentType, string5);
                    }
                    if (!this.isText(string5, string8)) {
                        treeWriter.addAttribute(c_encoding, "base64");
                    }
                }
                treeWriter.startContent();
                if (this.isText(string5, string8)) {
                    if (string8 == null) {
                        string8 = "UTF-8";
                    }
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string8));
                    int n = 12288;
                    char[] cArray = new char[n];
                    int n2 = bufferedReader.read(cArray, 0, n);
                    while (n2 >= 0) {
                        if (n2 > 0) {
                            String string9 = new String(cArray, 0, n2);
                            treeWriter.addText(string9);
                        }
                        n2 = bufferedReader.read(cArray, 0, n);
                    }
                    bufferedReader.close();
                } else {
                    int n = 12288;
                    byte[] byArray = new byte[n];
                    int n3 = 0;
                    int n4 = n;
                    boolean bl = false;
                    while (!bl) {
                        int n5 = inputStream.read(byArray, n3, n4);
                        if (n5 >= 0) {
                            n3 += n5;
                            n4 -= n5;
                        } else {
                            bl = true;
                        }
                        if (n4 != 0 && !bl) continue;
                        String string10 = Base64.encodeBytes(byArray, 0, n3);
                        treeWriter.addText(string10 + "\n");
                        n3 = 0;
                        n4 = n;
                    }
                    inputStream.close();
                }
                treeWriter.addEndElement();
            }
        }
        catch (IOException iOException) {
            throw new XProcException(XProcConstants.dynamicError(29), (Throwable)iOException);
        }
        treeWriter.endDocument();
        this.documents.add(treeWriter.getResult());
    }

    @Override
    public void canReadSequence(boolean bl) {
    }

    @Override
    public boolean readSequence() {
        return false;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public boolean moreDocuments() {
        return this.pos < this.documents.size();
    }

    @Override
    public boolean closed() {
        return true;
    }

    @Override
    public int documentCount() {
        return this.documents.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.documents;
    }

    @Override
    public XdmNode read() throws SaxonApiException {
        XdmNode xdmNode = this.documents.get(this.pos++);
        if (this.reader != null) {
            this.runtime.finest(null, this.reader.getNode(), this.reader.getName() + " read '" + (xdmNode == null ? "null" : xdmNode.getBaseURI()) + "' from " + this);
        }
        return xdmNode;
    }

    private boolean isText(String string, String string2) {
        return "application/xml".equals(string) || string.endsWith("+xml") || string.startsWith("text/") || "utf-8".equals(string2);
    }

    private String parseContentType(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(";");
        if (n > 0) {
            String string2 = string.substring(0, n).trim();
            return string2;
        }
        return string;
    }

    private String parseCharset(String string) {
        String string2 = HttpUtils.getCharset(string);
        if (string2 != null) {
            return string2.toLowerCase();
        }
        return null;
    }
}

