/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class NamespaceRename
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _from = new QName("from");
    private static final QName _to = new QName("to");
    private static final QName _apply_to = new QName("apply-to");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private String from = null;
    private String to = null;
    private String applyTo = null;

    public NamespaceRename(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        this.from = this.getOption(_from) != null ? this.getOption(_from).getString() : "";
        this.to = this.getOption(_to) != null ? this.getOption(_to).getString() : "";
        this.applyTo = this.getOption(_apply_to, "all");
        if ("http://www.w3.org/XML/1998/namespace".equals(this.from) || "http://www.w3.org/XML/1998/namespace".equals(this.to) || "http://www.w3.org/2000/xmlns/".equals(this.from) || "http://www.w3.org/2000/xmlns/".equals(this.to)) {
            throw XProcException.stepError(14);
        }
        if (this.from.equals(this.to)) {
            this.result.write(this.source.read());
        } else {
            this.matcher = new ProcessMatch(this.runtime, this);
            this.matcher.match(this.source.read(), new RuntimeValue("*", this.step.getNode()));
            this.result.write(this.matcher.getResult());
        }
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6);
        }
    }

    @Override
    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        NodeInfo inode = node.getUnderlyingNode();
        NamePool pool = inode.getNamePool();
        int[] inscopeNS = inode.getDeclaredNamespaces(null);
        int[] newNS = null;
        int nameCode = inode.getNameCode();
        int typeCode = inode.getTypeAnnotation() & 0xFFFFF;
        if ("attributes".equals(this.applyTo)) {
            this.matcher.addStartElement(nameCode, typeCode, inscopeNS);
        } else {
            if (inscopeNS.length > 0) {
                int countNS = 0;
                for (int pos = 0; pos < inscopeNS.length; ++pos) {
                    int ns = inscopeNS[pos];
                    String uri = pool.getURIFromNamespaceCode(ns);
                    if (this.from.equals(uri) && "".equals(this.to)) continue;
                    ++countNS;
                }
                newNS = new int[countNS];
                int newPos = 0;
                for (int pos = 0; pos < inscopeNS.length; ++pos) {
                    int ns = inscopeNS[pos];
                    String pfx = pool.getPrefixFromNamespaceCode(ns);
                    String uri = pool.getURIFromNamespaceCode(ns);
                    if (this.from.equals(uri)) {
                        if ("".equals(this.to)) continue;
                        int newns = pool.getNamespaceCode(pfx, this.to);
                        if (newns < 0) {
                            newns = pool.allocateNamespaceCode(pfx, this.to);
                        }
                        newNS[newPos++] = newns;
                        continue;
                    }
                    newNS[newPos++] = ns;
                }
            }
            String pfx = pool.getPrefix(nameCode);
            String uri = pool.getURI(nameCode);
            if (this.from.equals(uri)) {
                if ("".equals(this.to)) {
                    pfx = "";
                }
                nameCode = pool.allocate(pfx, this.to, node.getNodeName().getLocalName());
            }
            this.matcher.addStartElement(nameCode, typeCode, newNS);
        }
        if (!"elements".equals(this.applyTo)) {
            XdmSequenceIterator iter = node.axisIterator(Axis.ATTRIBUTE);
            while (iter.hasNext()) {
                XdmNode attr = (XdmNode)iter.next();
                inode = attr.getUnderlyingNode();
                pool = inode.getNamePool();
                nameCode = inode.getNameCode();
                typeCode = inode.getTypeAnnotation() & 0xFFFFF;
                String pfx = pool.getPrefix(nameCode);
                String uri = pool.getURI(nameCode);
                if (this.from.equals(uri)) {
                    if ("".equals(pfx)) {
                        pfx = "_1";
                    }
                    nameCode = pool.allocate(pfx, this.to, attr.getNodeName().getLocalName());
                }
                this.matcher.addAttribute(nameCode, typeCode, attr.getStringValue());
            }
        } else {
            this.matcher.addAttributes(node);
        }
        return true;
    }

    @Override
    public void processEndElement(XdmNode node) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode node) throws SaxonApiException {
        this.matcher.addText(node.getStringValue());
    }

    @Override
    public void processComment(XdmNode node) throws SaxonApiException {
        this.matcher.addComment(node.getStringValue());
    }

    @Override
    public void processPI(XdmNode node) throws SaxonApiException {
        this.matcher.addPI(node.getNodeName().getLocalName(), node.getStringValue());
    }

    @Override
    public void processAttribute(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("processAttribute can't be called in NamespaceRename--but it was!?");
    }
}

