/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractPatternFunction;
import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.BinaryPattern;
import com.thaiopensource.relaxng.pattern.BlankDataDerivType;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataDataDerivType;
import com.thaiopensource.relaxng.pattern.DataDerivType;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InconsistentDataDerivType;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.RefPattern;
import com.thaiopensource.relaxng.pattern.SingleDataDerivType;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.pattern.ValueDataDerivType;
import com.thaiopensource.relaxng.pattern.ValuePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataDerivTypeFunction
extends AbstractPatternFunction<DataDerivType> {
    private final ValidatorPatternBuilder builder;

    DataDerivTypeFunction(ValidatorPatternBuilder validatorPatternBuilder) {
        this.builder = validatorPatternBuilder;
    }

    static DataDerivType dataDerivType(ValidatorPatternBuilder validatorPatternBuilder, Pattern pattern) {
        return pattern.apply(validatorPatternBuilder.getDataDerivTypeFunction());
    }

    @Override
    public DataDerivType caseOther(Pattern pattern) {
        return new SingleDataDerivType();
    }

    @Override
    public DataDerivType caseRef(RefPattern refPattern) {
        return this.apply(refPattern.getPattern());
    }

    @Override
    public DataDerivType caseAfter(AfterPattern afterPattern) {
        Pattern pattern = afterPattern.getOperand1();
        DataDerivType dataDerivType = this.apply(afterPattern.getOperand1());
        if (!pattern.isNullable()) {
            return dataDerivType;
        }
        return dataDerivType.combine(new BlankDataDerivType());
    }

    private DataDerivType caseBinary(BinaryPattern binaryPattern) {
        return this.apply(binaryPattern.getOperand1()).combine(this.apply(binaryPattern.getOperand2()));
    }

    @Override
    public DataDerivType caseChoice(ChoicePattern choicePattern) {
        return this.caseBinary(choicePattern);
    }

    @Override
    public DataDerivType caseGroup(GroupPattern groupPattern) {
        return this.caseBinary(groupPattern);
    }

    @Override
    public DataDerivType caseInterleave(InterleavePattern interleavePattern) {
        return this.caseBinary(interleavePattern);
    }

    @Override
    public DataDerivType caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        return this.apply(oneOrMorePattern.getOperand());
    }

    @Override
    public DataDerivType caseList(ListPattern listPattern) {
        return InconsistentDataDerivType.getInstance();
    }

    @Override
    public DataDerivType caseValue(ValuePattern valuePattern) {
        return new ValueDataDerivType(valuePattern.getDatatype(), valuePattern.getDatatypeName());
    }

    @Override
    public DataDerivType caseData(DataPattern dataPattern) {
        if (dataPattern.allowsAnyString()) {
            return new SingleDataDerivType();
        }
        return new DataDataDerivType(dataPattern);
    }

    @Override
    public DataDerivType caseDataExcept(DataExceptPattern dataExceptPattern) {
        if (dataExceptPattern.allowsAnyString()) {
            return this.apply(dataExceptPattern.getExcept());
        }
        return new DataDataDerivType(dataExceptPattern).combine(this.apply(dataExceptPattern.getExcept()));
    }

    private DataDerivType apply(Pattern pattern) {
        return this.builder.getPatternMemo(pattern).dataDerivType();
    }
}

