/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.python.google.common.collect.ExplicitOrdering;
import org.python.google.common.collect.ImmutableCollection;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.ImmutableMap;
import org.python.google.common.collect.ImmutableSortedAsList;
import org.python.google.common.collect.ImmutableSortedSet;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.ObjectArrays;
import org.python.google.common.collect.Platform;
import org.python.google.common.collect.RegularImmutableList;
import org.python.google.common.collect.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true, emulated=true)
final class ExplicitOrderedImmutableSortedSet<E>
extends ImmutableSortedSet<E> {
    private final Object[] elements;
    private final int fromIndex;
    private final int toIndex;

    static <E> ImmutableSortedSet<E> create(List<E> list) {
        ExplicitOrdering<E> ordering = new ExplicitOrdering<E>(list);
        if (ordering.rankMap.isEmpty()) {
            return ExplicitOrderedImmutableSortedSet.emptySet(ordering);
        }
        Object[] elements = ((ImmutableCollection)((Object)ordering.rankMap.keySet())).toArray();
        return new ExplicitOrderedImmutableSortedSet<E>(elements, ordering);
    }

    ExplicitOrderedImmutableSortedSet(Object[] elements, Comparator<? super E> comparator) {
        this(elements, comparator, 0, elements.length);
    }

    ExplicitOrderedImmutableSortedSet(Object[] elements, Comparator<? super E> comparator, int fromIndex, int toIndex) {
        super(comparator);
        this.elements = elements;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    private ImmutableMap<E, Integer> rankMap() {
        return ((ExplicitOrdering)this.comparator()).rankMap;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray(this.elements, this.fromIndex, this.size());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.toIndex - this.fromIndex;
    }

    @Override
    public boolean contains(Object o) {
        Integer index = this.rankMap().get(o);
        return index != null && index >= this.fromIndex && index < this.toIndex;
    }

    @Override
    boolean isPartialView() {
        return this.fromIndex != 0 || this.toIndex != this.elements.length;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        Platform.unsafeArrayCopy(this.elements, this.fromIndex, array, 0, this.size());
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            array = ObjectArrays.newArray(array, size);
        } else if (array.length > size) {
            array[size] = null;
        }
        Platform.unsafeArrayCopy(this.elements, this.fromIndex, array, 0, size);
        return array;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = this.fromIndex; i < this.toIndex; ++i) {
            hash += this.elements[i].hashCode();
        }
        return hash;
    }

    @Override
    public E first() {
        return (E)this.elements[this.fromIndex];
    }

    @Override
    public E last() {
        return (E)this.elements[this.toIndex - 1];
    }

    @Override
    ImmutableSortedSet<E> headSetImpl(E toElement) {
        return this.createSubset(this.fromIndex, this.findSubsetIndex(toElement));
    }

    @Override
    ImmutableSortedSet<E> subSetImpl(E fromElement, E toElement) {
        return this.createSubset(this.findSubsetIndex(fromElement), this.findSubsetIndex(toElement));
    }

    @Override
    ImmutableSortedSet<E> tailSetImpl(E fromElement) {
        return this.createSubset(this.findSubsetIndex(fromElement), this.toIndex);
    }

    private int findSubsetIndex(E element) {
        Integer index = this.rankMap().get(element);
        if (index == null) {
            throw new ClassCastException();
        }
        if (index <= this.fromIndex) {
            return this.fromIndex;
        }
        if (index >= this.toIndex) {
            return this.toIndex;
        }
        return index;
    }

    private ImmutableSortedSet<E> createSubset(int newFromIndex, int newToIndex) {
        if (newFromIndex < newToIndex) {
            return new ExplicitOrderedImmutableSortedSet<E>(this.elements, this.comparator, newFromIndex, newToIndex);
        }
        return ExplicitOrderedImmutableSortedSet.emptySet(this.comparator);
    }

    @Override
    int indexOf(Object target) {
        Integer index = this.rankMap().get(target);
        return index != null && index >= this.fromIndex && index < this.toIndex ? index - this.fromIndex : -1;
    }

    @Override
    ImmutableList<E> createAsList() {
        return new ImmutableSortedAsList(this, new RegularImmutableList(this.elements, this.fromIndex, this.size()));
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializedForm<E>
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        public SerializedForm(Object[] elements) {
            this.elements = elements;
        }

        Object readResolve() {
            return ImmutableSortedSet.withExplicitOrder(Arrays.asList(this.elements));
        }
    }
}

