/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.th;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Locale;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.AttributeSource;

public final class ThaiWordFilter
extends TokenFilter {
    private BreakIterator breaker = BreakIterator.getWordInstance(new Locale("th"));
    private TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    private OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private AttributeSource.State thaiState = null;

    public ThaiWordFilter(TokenStream input) {
        super(input);
    }

    public final boolean incrementToken() throws IOException {
        int end;
        if (this.thaiState != null) {
            int start = this.breaker.current();
            end = this.breaker.next();
            if (end != -1) {
                this.restoreState(this.thaiState);
                this.termAtt.setTermBuffer(this.termAtt.termBuffer(), start, end - start);
                this.offsetAtt.setOffset(this.offsetAtt.startOffset() + start, this.offsetAtt.startOffset() + end);
                return true;
            }
            this.thaiState = null;
        }
        if (!this.input.incrementToken() || this.termAtt.termLength() == 0) {
            return false;
        }
        String text = this.termAtt.term();
        if (Character.UnicodeBlock.of(text.charAt(0)) != Character.UnicodeBlock.THAI) {
            this.termAtt.setTermBuffer(text.toLowerCase());
            return true;
        }
        this.thaiState = this.captureState();
        this.breaker.setText(text);
        end = this.breaker.next();
        if (end != -1) {
            this.termAtt.setTermBuffer(text, 0, end);
            this.offsetAtt.setOffset(this.offsetAtt.startOffset(), this.offsetAtt.startOffset() + end);
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this.thaiState = null;
    }
}

