import sys
from typing import Any, Final, Literal, overload

if sys.platform != "win32" and sys.platform != "darwin":
    # Depends on soundcard.h
    AFMT_AC3: Final[int]
    AFMT_A_LAW: Final[int]
    AFMT_IMA_ADPCM: Final[int]
    AFMT_MPEG: Final[int]
    AFMT_MU_LAW: Final[int]
    AFMT_QUERY: Final[int]
    AFMT_S16_BE: Final[int]
    AFMT_S16_LE: Final[int]
    AFMT_S16_NE: Final[int]
    AFMT_S8: Final[int]
    AFMT_U16_BE: Final[int]
    AFMT_U16_LE: Final[int]
    AFMT_U8: Final[int]
    SNDCTL_COPR_HALT: Final[int]
    SNDCTL_COPR_LOAD: Final[int]
    SNDCTL_COPR_RCODE: Final[int]
    SNDCTL_COPR_RCVMSG: Final[int]
    SNDCTL_COPR_RDATA: Final[int]
    SNDCTL_COPR_RESET: Final[int]
    SNDCTL_COPR_RUN: Final[int]
    SNDCTL_COPR_SENDMSG: Final[int]
    SNDCTL_COPR_WCODE: Final[int]
    SNDCTL_COPR_WDATA: Final[int]
    SNDCTL_DSP_BIND_CHANNEL: Final[int]
    SNDCTL_DSP_CHANNELS: Final[int]
    SNDCTL_DSP_GETBLKSIZE: Final[int]
    SNDCTL_DSP_GETCAPS: Final[int]
    SNDCTL_DSP_GETCHANNELMASK: Final[int]
    SNDCTL_DSP_GETFMTS: Final[int]
    SNDCTL_DSP_GETIPTR: Final[int]
    SNDCTL_DSP_GETISPACE: Final[int]
    SNDCTL_DSP_GETODELAY: Final[int]
    SNDCTL_DSP_GETOPTR: Final[int]
    SNDCTL_DSP_GETOSPACE: Final[int]
    SNDCTL_DSP_GETSPDIF: Final[int]
    SNDCTL_DSP_GETTRIGGER: Final[int]
    SNDCTL_DSP_MAPINBUF: Final[int]
    SNDCTL_DSP_MAPOUTBUF: Final[int]
    SNDCTL_DSP_NONBLOCK: Final[int]
    SNDCTL_DSP_POST: Final[int]
    SNDCTL_DSP_PROFILE: Final[int]
    SNDCTL_DSP_RESET: Final[int]
    SNDCTL_DSP_SAMPLESIZE: Final[int]
    SNDCTL_DSP_SETDUPLEX: Final[int]
    SNDCTL_DSP_SETFMT: Final[int]
    SNDCTL_DSP_SETFRAGMENT: Final[int]
    SNDCTL_DSP_SETSPDIF: Final[int]
    SNDCTL_DSP_SETSYNCRO: Final[int]
    SNDCTL_DSP_SETTRIGGER: Final[int]
    SNDCTL_DSP_SPEED: Final[int]
    SNDCTL_DSP_STEREO: Final[int]
    SNDCTL_DSP_SUBDIVIDE: Final[int]
    SNDCTL_DSP_SYNC: Final[int]
    SNDCTL_FM_4OP_ENABLE: Final[int]
    SNDCTL_FM_LOAD_INSTR: Final[int]
    SNDCTL_MIDI_INFO: Final[int]
    SNDCTL_MIDI_MPUCMD: Final[int]
    SNDCTL_MIDI_MPUMODE: Final[int]
    SNDCTL_MIDI_PRETIME: Final[int]
    SNDCTL_SEQ_CTRLRATE: Final[int]
    SNDCTL_SEQ_GETINCOUNT: Final[int]
    SNDCTL_SEQ_GETOUTCOUNT: Final[int]
    SNDCTL_SEQ_GETTIME: Final[int]
    SNDCTL_SEQ_NRMIDIS: Final[int]
    SNDCTL_SEQ_NRSYNTHS: Final[int]
    SNDCTL_SEQ_OUTOFBAND: Final[int]
    SNDCTL_SEQ_PANIC: Final[int]
    SNDCTL_SEQ_PERCMODE: Final[int]
    SNDCTL_SEQ_RESET: Final[int]
    SNDCTL_SEQ_RESETSAMPLES: Final[int]
    SNDCTL_SEQ_SYNC: Final[int]
    SNDCTL_SEQ_TESTMIDI: Final[int]
    SNDCTL_SEQ_THRESHOLD: Final[int]
    SNDCTL_SYNTH_CONTROL: Final[int]
    SNDCTL_SYNTH_ID: Final[int]
    SNDCTL_SYNTH_INFO: Final[int]
    SNDCTL_SYNTH_MEMAVL: Final[int]
    SNDCTL_SYNTH_REMOVESAMPLE: Final[int]
    SNDCTL_TMR_CONTINUE: Final[int]
    SNDCTL_TMR_METRONOME: Final[int]
    SNDCTL_TMR_SELECT: Final[int]
    SNDCTL_TMR_SOURCE: Final[int]
    SNDCTL_TMR_START: Final[int]
    SNDCTL_TMR_STOP: Final[int]
    SNDCTL_TMR_TEMPO: Final[int]
    SNDCTL_TMR_TIMEBASE: Final[int]
    SOUND_MIXER_ALTPCM: Final[int]
    SOUND_MIXER_BASS: Final[int]
    SOUND_MIXER_CD: Final[int]
    SOUND_MIXER_DIGITAL1: Final[int]
    SOUND_MIXER_DIGITAL2: Final[int]
    SOUND_MIXER_DIGITAL3: Final[int]
    SOUND_MIXER_IGAIN: Final[int]
    SOUND_MIXER_IMIX: Final[int]
    SOUND_MIXER_LINE: Final[int]
    SOUND_MIXER_LINE1: Final[int]
    SOUND_MIXER_LINE2: Final[int]
    SOUND_MIXER_LINE3: Final[int]
    SOUND_MIXER_MIC: Final[int]
    SOUND_MIXER_MONITOR: Final[int]
    SOUND_MIXER_NRDEVICES: Final[int]
    SOUND_MIXER_OGAIN: Final[int]
    SOUND_MIXER_PCM: Final[int]
    SOUND_MIXER_PHONEIN: Final[int]
    SOUND_MIXER_PHONEOUT: Final[int]
    SOUND_MIXER_RADIO: Final[int]
    SOUND_MIXER_RECLEV: Final[int]
    SOUND_MIXER_SPEAKER: Final[int]
    SOUND_MIXER_SYNTH: Final[int]
    SOUND_MIXER_TREBLE: Final[int]
    SOUND_MIXER_VIDEO: Final[int]
    SOUND_MIXER_VOLUME: Final[int]

    control_labels: list[str]
    control_names: list[str]

    # TODO: oss_audio_device return type
    @overload
    def open(mode: Literal["r", "w", "rw"]) -> Any: ...
    @overload
    def open(device: str, mode: Literal["r", "w", "rw"]) -> Any: ...

    # TODO: oss_mixer_device return type
    def openmixer(device: str = ...) -> Any: ...

    class OSSAudioError(Exception): ...
    error = OSSAudioError
